<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme qiye_1
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */
require_once get_template_directory() . '/inc/classes/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'happythemes_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
function happythemes_register_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(

		// This is an example of how to include a plugin bundled with a theme.
		array(
			'name'               => '一键导入演示数据', // The plugin name.
			'slug'               => 'one-click-demo-import', // The plugin slug (typically the folder name).
			'source'             => 'https://www.hnymwl.com/downloads_free/plugins/one-click-demo-import.zip', // The plugin source.
			'required'           => false, // If false, the plugin is only 'recommended' instead of required.
			'version'            => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			//'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			//'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			//'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			//'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),	

		//array(
		//	'name'               => 'WooCommerce', // The plugin name.
		//	'slug'               => 'woocommerce', // The plugin slug (typically the folder name).
		//	'required'           => false, // If false, the plugin is only 'recommended' instead of required.
		//),									

		// This is an example of how to include a plugin from a GitHub repository in your theme.
		// This presumes that the plugin code is based in the root of the GitHub repository
		// and not in a subdirectory ('/src') of the repository.
		//array(
		//	'name'      => 'Adminbar Link Comments to Pending',
		//	'slug'      => 'adminbar-link-comments-to-pending',
		//	'source'    => 'https://github.com/jrfnl/WP-adminbar-comments-to-pending/archive/master.zip',
		//),

		// This is an example of how to include a plugin from the WordPress Plugin Repository.
		//array(
		//	'name'      => 'BuddyPress',
		//	'slug'      => 'buddypress',
		//	'required'  => false,
		//),

		// This is an example of the use of 'is_callable' functionality. A user could - for instance -
		// have WPSEO installed *or* WPSEO Premium. The slug would in that last case be different, i.e.
		// 'wordpress-seo-premium'.
		// By setting 'is_callable' to either a function from that plugin or a class method
		// `array( 'class', 'method' )` similar to how you hook in to actions and filters, TGMPA can still
		// recognize the plugin as being installed.
		//array(
		//	'name'        => 'WordPress SEO by Yoast',
		//	'slug'        => 'wordpress-seo',
		//	'is_callable' => 'wpseo_init',
		//),

	);

	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id'           => 'daohang',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.

		'strings'      => array(
			'page_title'                      => __( '安装必需的插件', 'daohang' ),
			'menu_title'                      => __( '安装插件', 'daohang' ),
			'installing'                      => __( '正在安装插件: %s', 'daohang' ),
			'updating'                        => __( '正在更新插件: %s', 'daohang' ),
			'oops'                            => __( '插件API出现错误。', 'daohang' ),
			'notice_can_install_required'     => _n_noop(
				'该主题需要安装以下插件: %1$s',
				'该主题需要安装以下插件: %1$s',
				'daohang'
			),
			'notice_can_install_recommended'  => _n_noop(
				'该主题建议安装以下插件: %1$s',
				'该主题建议安装以下插件: %1$s',
				'daohang'
			),
			'notice_ask_to_update'            => _n_noop(
				'以下插件需要更新到最新版本，以确保与此主题的最大兼容性: %1$s',
				'以下插件需要更新到最新版本，以确保与此主题的最大兼容性: %1$s',
				'daohang'
			),
			'notice_ask_to_update_maybe'      => _n_noop(
				'有一个更新可用: %1$s',
				'以下插件有可用的更新: %1$s',
				'daohang'
			),
			'notice_can_activate_required'    => _n_noop(
				'以下所需的插件当前未激活: %1$s',
				'以下所需的插件当前未激活: %1$s',
				'daohang'
			),
			'notice_can_activate_recommended' => _n_noop(
				'以下推荐的插件当前未激活: %1$s',
				'以下推荐的插件当前未激活: %1$s',
				'daohang'
			),
			'install_link'                    => _n_noop(
				'开始安装插件',
				'开始安装插件',
				'daohang'
			),
			'update_link' 					  => _n_noop(
				'开始更新插件',
				'开始更新插件',
				'daohang'
			),
			'activate_link'                   => _n_noop(
				'开始激活插件',
				'开始激活插件',
				'daohang'
			),
			'return'                          => __( '返回所需的插件安装程序', 'daohang' ),
			'plugin_activated'                => __( '插件已成功激活。', 'daohang' ),
			'activated_successfully'          => __( '以下插件已成功激活:', 'daohang' ),
			'plugin_already_active'           => __( '插件 %1$s 已经激活。', 'daohang' ),
			'plugin_needs_higher_version'     => __( '插件未激活。需要更高版本的 %s。 请先更新插件。', 'daohang' ),
			'complete'                        => __( '所以插件都已安装并激活。 %1$s', 'daohang' ),
			'dismiss'                         => __( '忽略此提示', 'daohang' ),
			'notice_cannot_install_activate'  => __( '有一个或多个必需或推荐的插件可供安装，更新或激活。', 'daohang' ),
			'contact_admin'                   => __( '请联系本网站的管理员以获取帮助。', 'daohang' ),

			'nag_type'                        => '', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
		),
	);

	tgmpa( $plugins, $config );
}
