<?php $class = ( $wp_query->current_post + 1 === $wp_query->post_count ) ? 'clear last' : 'clear'; ?>

<?php 
	if ( function_exists('get_field') ) {
		// Post Images
		if (get_field('image_1')) {
			$image_1 = get_field('image_1');
		}
		if (get_field('image_2')) {
			$image_2 = get_field('image_2');
		} 			
		if (get_field('image_3')) {
			$image_3 = get_field('image_3');
		} 			
	}

?>	

<div id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>	

	<?php if ( (get_theme_mod('loop-featured-on', true) == true) && ( empty($image_1) || empty($image_2) || empty($image_3) ) ) { ?>

		<?php if( has_post_thumbnail() ) { ?>
			<a class="thumbnail-link" href="<?php the_permalink(); ?>" target="_blank">
				<div class="thumbnail-wrap">
					<?php 
						the_post_thumbnail('post_thumb'); 
					?>
				</div><!-- .thumbnail-wrap -->
			</a>
		<?php } else { ?>
			<?php daohang_custom_thumb(600,360,get_theme_mod('default-thumb',true)); ?>
		<?php } ?>

	<?php } ?>	

	<div class="entry-header">

		<h2 class="entry-title"><a href="<?php the_permalink(); ?>" target="_blank"><?php the_title(); ?></a></h2>

		<?php get_template_part( 'template-parts/entry', 'meta' ); ?>
		
	</div><!-- .entry-header -->

	<?php if ( ( empty($image_1) || empty($image_2) || empty($image_3) ) && (get_theme_mod('loop-excerpt-on', true) == true )) : ?>		
	
	<div class="entry-summary">
		<?php
			if ( has_excerpt() ) {
				the_excerpt();
			} else {
				$content = get_the_content($more_link_text, $stripteaser, $more_file);
				// remove [caption] shortcode
				$content = preg_replace("/\[caption.*\[\/caption\]/", '', $content);
				
				// short codes are applied
				$content = apply_filters('the_content', $content);
				echo wp_trim_words( $content, get_theme_mod('loop-excerpt-length', '60'), '...' );				
			}
		?>
	</div><!-- .entry-summary -->
	
	<?php endif; ?>

	<?php if ( (get_theme_mod('loop-featured-on', true) == true) && ( !empty($image_1) && !empty($image_2) && !empty($image_3) ) ) { ?>

		<ul class="gallery-list">

			<li class="ht_fixed_grid_1_3"><a target="_blank" class="thumb" href="<?php the_permalink();?>"><img src="<?php echo get_template_directory_uri();?>/thumb.php?src=<?php echo $image_1; ?>&w=300&h=180"" alt="<?php echo get_the_title(); ?>"/></a></li>

			<li class="ht_fixed_grid_1_3"><a target="_blank" class="thumb" href="<?php the_permalink();?>"><img src="<?php echo get_template_directory_uri();?>/thumb.php?src=<?php echo $image_2; ?>&w=300&h=180"" alt="<?php echo get_the_title(); ?>"/></a></li>

			<li class="ht_fixed_grid_1_3"><a target="_blank" class="thumb" href="<?php the_permalink();?>"><img src="<?php echo get_template_directory_uri();?>/thumb.php?src=<?php echo $image_3; ?>&w=300&h=180"" alt="<?php echo get_the_title(); ?>"/></a></li>

 		</ul>

	<?php } ?>	

</div><!-- #post-<?php the_ID(); ?> -->