<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package daohang
 */	
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<header class="entry-header">	

			<?php
			if ( is_single() ) :
				the_title( '<h1 class="entry-title">', '</h1>' );
			else :
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			endif;

			if ( 'post' === get_post_type() ) : ?>

				<?php get_template_part( 'template-parts/entry-meta', 'single' ); ?>

			<?php
			endif; ?>

	</header><!-- .entry-header -->

	<?php if( get_theme_mod('single-excerpt-on', true) == true ) : ?>

		<div class="single-excerpt">
			<?php the_excerpt(); ?>
		</div><!-- .single-excerpt -->

	<?php endif; ?>
	
	<div class="entry-content">
		<?php 
			if( ( get_theme_mod('single-featured-on', false) == true ) && has_post_thumbnail() && (strpos($post->post_content,'[gallery') === false) ): 
				the_post_thumbnail('single_thumb'); 
			endif;
		?>	
		
		<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( '阅读全文 %s <span class="meta-nav">&rarr;</span>', 'daohang' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( '分页', 'daohang' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			) );
		?>
	</div><!-- .entry-content -->

	<?php if( get_theme_mod('single-credit-on', true) == true ) : ?>

		<div class="single-credit">
			<?php
				$single_credit_default = '免责声明：文章内容不代表本站立场，本站不对其内容的真实性、完整性、准确性给予任何担保、暗示和承诺，仅供读者参考，文章版权归原作者所有。如本文内容影响到您的合法权益（内容、图片等），请及时联系本站，我们会及时删除处理。';
				$single_credit = get_post_meta($post->ID, 'single_credit', true);
				if ( !empty($single_credit) ) {
					echo $single_credit;
				} else {
					echo get_theme_mod('single-credit-text', $single_credit_default);
				}
			?>
		</div>

	<?php endif; ?>

	<div class="entry-bottom clear">
		<div class="entry-tags">

			<?php if (has_tag()) { ?><span class="tag-links"><span>标签:</span><?php the_tags('', ' '); ?></span><?php } ?>
				
			<?php
				edit_post_link(
					sprintf(
						/* translators: %s: Name of current post */
						esc_html__( '编辑 %s', 'daohang' ),
						the_title( '<span class="screen-reader-text">"', '"</span>', false )
					),
					'<span class="edit-link">',
					'</span>'
				);
			?>

		</div><!-- .entry-tags -->	

		<?php if( get_theme_mod('single-share-on', true) == true ) : ?>

			<span class="custom-share">
				<span class="social-share" data-sites="wechat, weibo, qq, qzone"></span>
			</span>	

		<?php endif; ?>

	</div>
</article><!-- #post-## -->

<?php if( get_theme_mod('single-bottom-ad','') ) { ?>
	<div class="single-bottom-ad">
		<?php echo get_theme_mod('single-bottom-ad'); ?>
	</div>
<?php } ?>

<?php if ( get_theme_mod('author-box-on', true) ) : ?>

<div class="author-box clear">
	<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), 120 ); ?></a>
	<div class="author-meta">	
		<h4 class="author-name"><?php echo __('作者:', 'daohang'); ?> <span class="hover-underline"><a target="_blank" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_the_author_meta('nickname'); ?></a></span></h4>	
		<div class="author-desc">
			<?php 
				echo the_author_meta('description'); 
			?>
		</div>
	</div>
</div><!-- .author-box -->

<?php endif; ?>

<?php if ( get_theme_mod('post-nav-on', true) ) : ?>

<div id="post-nav" class="clear">
    <?php $prevPost = get_previous_post(true);
        if($prevPost) {
            $args = array(
                'posts_per_page' => 1,
                'include' => $prevPost->ID
            );
            $prevPost = get_posts($args);
            foreach ($prevPost as $post) {
                setup_postdata($post);
    ?>
        <div class="post-previous">
            <a class="previous" href="<?php the_permalink(); ?>">
            	<span><i class="fa fa-angle-left"></i> 上一篇</span>				            	
	            <h4><?php the_title(); ?></h4>
	        </a>
        </div>
    <?php
                wp_reset_postdata();
            } //end foreach
        } else {
    ?>
        <div class="post-previous">
        	<div class="no-next">
        	<span>没有了</span>		            
            <h4>已是最新文章</h4>
        	</div>
        </div>
    <?php } ?>
    <?php     
        $nextPost = get_next_post(true);
        if($nextPost) {
            $args = array(
                'posts_per_page' => 1,
                'include' => $nextPost->ID
            );
            $nextPost = get_posts($args);
            foreach ($nextPost as $post) {
                setup_postdata($post);
    ?>
        <div class="ht_grid_1_2 post-next">
             <a class="next" href="<?php the_permalink(); ?>">
            	<span>下一篇 <i class="fa fa-angle-right"></i></span>			            
	            <h4><?php the_title(); ?></h4>
	        </a>
        </div>
    <?php
               wp_reset_postdata();
            } //end foreach
        } else {
    ?>
        <div class="ht_grid_1_2 post-next">
        	<div class="no-next">
        		<span>没有了</span>		            
            	<h4>已是最早文章</h4>
			</div>
        </div>
    <?php
        }
    ?>
</div><!-- .post-nav -->

<?php endif; ?>
