<?php
 namespace App\Modules\BigWheel\Mobile; use App\Modules\Activity\JoinMode; use App\Modules\Base\ActivityBaseTrait; use App\Modules\Base\BaseMobileController; use App\Modules\Modules; use App\Modules\PrizePool\Util\PrizePoolUtil; use App\Types\ModuleStatus; use Illuminate\Support\Facades\Request; use Illuminate\Support\Facades\View; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\TimeUtil; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; class HomeController extends BaseMobileController implements MemberLoginCheck { use ActivityBaseTrait; const MODULE = 'bigWheel'; const MODULE_UNDERSCORE = 'big_wheel'; public static function owner() { $alias = Request::route('alias'); if (empty($alias)) { return 0; } $setting = ModelUtil::get('module_' . self::MODULE_UNDERSCORE . '_activity', ['alias' => $alias]); if (empty($setting)) { return 0; } return $setting['memberUserId']; } public function home() { if (Modules::status(self::owner(), self::MODULE) != ModuleStatus::OK) { return Response::send(-1, '功能已过期'); } $prizes = PrizePoolUtil::listUserShownPrizes(self::MODULE, $this->activity['id'], 8, $this->memberUserId); $orderMap = [0, 4, 6, 2, 1, 5, 3, 7]; $optimizedPrizes = []; foreach ($prizes as $k => $prize) { $optimizedPrizes[] = $prizes[$orderMap[$k]]; } return $this->_view('home', [ 'prizes' => $optimizedPrizes, 'prepareResultHtml' => $this->getPrepareResultHtml(), ]); } public function draw() { if (!$this->activity['enable']) { return Response::send(-1, '大转盘活动未开启'); } if (!TimeUtil::isDatetimeEmpty($this->activity['startTime'])) { if (time() < strtotime($this->activity['startTime'])) { return Response::send(-1, '大转盘未开始'); } } if (!TimeUtil::isDatetimeEmpty($this->activity['endTime'])) { if (time() > strtotime($this->activity['endTime'])) { return Response::send(-1, '大转盘已经结束'); } } ModelUtil::transactionBegin(); try { $activity = ModelUtil::getWithLock('module_' . self::MODULE_UNDERSCORE . '_activity', ['id' => $this->activity['id']]); switch ($this->activity['joinMode']) { case JoinMode::ONCE_PER_ACCOUNT: if (ModelUtil::exists('module_' . self::MODULE_UNDERSCORE . '_drawn', ['activityId' => $this->activity['id'], 'userId' => $this->userId()])) { ModelUtil::transactionCommit(); return Response::send(-1, '您已经抽过奖了'); } break; case JoinMode::LIMIT_DAILY: $todayCount = ModelUtil::model('module_' . self::MODULE_UNDERSCORE . '_drawn') ->where(['activityId' => $this->activity['id'], 'userId' => $this->userId()]) ->where('created_at', '>=', date('Y-m-d 00:00:00', time())) ->where('created_at', '<=', date('Y-m-d 23:59:59', time())) ->count(); if ($todayCount >= $this->activity['joinDailyLimit']) { ModelUtil::transactionCommit(); return Response::send(-1, '每天最多只能抽' . $this->activity['joinDailyLimit'] . '次奖哦~'); } break; case JoinMode::NOT_LIMIT: break; } if ($this->activity['payDrawEnable']) { $payDraw = PrizePoolUtil::getUnusedPayDraw($this->memberUserId, $this->userId(), self::MODULE, $this->activity['id']); if (empty($payDraw)) { ModelUtil::transactionCommit(); $html = View::make('res::activity.payDraw', [ 'activity' => $activity, ])->render(); return Response::send(0, null, [ 'prizeId' => 0, 'html' => $html ]); } PrizePoolUtil::markPayDraw($payDraw['id']); } ModelUtil::insert('module_' . self::MODULE_UNDERSCORE . '_drawn', ['activityId' => $this->activity['id'], 'userId' => $this->userId()]); $drawn = PrizePoolUtil::drawPrize( $this->memberUserId, $this->userId(), self::MODULE, $this->activity['id'] ); ModelUtil::transactionCommit(); } catch (\Exception $e) { ModelUtil::transactionRollback(); return Response::send(-1, $e->getMessage()); } $html = View::make('res::activity.drawn', [ 'activity' => $activity, 'drawn' => $drawn, ])->render(); return Response::send(0, null, [ 'prizeId' => $drawn ? $drawn['prizeId'] : 0, 'html' => $html ]); } }