<?php
 namespace Module\Event\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Form\Form; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use Module\Event\Type\EventShowStatus; use Module\Event\Type\EventStatus; class EventController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('event') ->field(function ($builder) { $builder->id('id', 'ID'); $builder->select('categoryId', '分类')->optionModelTree('event_category'); $builder->text('title', '名称'); $builder->type('showStatus', '在线状态')->type(EventShowStatus::class); $builder->type('status', '正在报名')->type(EventStatus::class); $builder->datetime('time', '活动时间'); $builder->switch('applyTimeLimit', '报名时间限制') ->when(1, function (Form $form) { $form->datetime('applyStartTime', '报名开始时间'); $form->datetime('applyEndTime', '报名截止时间'); }); $builder->switch('applyNumberLimit', '报名人数限制') ->when(1, function (Form $form) { $form->number('applyNumberMax', '最大报名人数'); }); $builder->currency('price', '报名价格')->help('0表示免费'); $builder->text('title', '名称'); $builder->text('summary', '简要描述'); $builder->image('cover', '头图'); $builder->images('photos', '宣传照片'); $builder->keyValueList('param', '活动属性')->keyLabel('name')->valueLabel('value'); $builder->richHtml('applyText', '报名说明'); $builder->richHtml('applySuccessText', '报名成功说明'); $builder->richHtml('content', '内容描述'); $builder->customField('fieldCustom1', '报名字段1')->help('留空表示不启用'); $builder->customField('fieldCustom2', '报名字段2')->help('留空表示不启用'); $builder->customField('fieldCustom3', '报名字段3')->help('留空表示不启用'); $builder->customField('fieldCustom4', '报名字段4')->help('留空表示不启用'); $builder->customField('fieldCustom5', '报名字段5')->help('留空表示不启用'); $builder->display('created_at', L('Created At'))->listable(false); $builder->display('updated_at', L('Updated At'))->listable(false); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->like('title', L('Title')); }) ->hookChanged(function (Form $form) { }) ->title('活动管理')->formClass('wide'); } } 