<?php
 namespace Module\Event\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\Request; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use Module\Event\Type\EventOrderStatus; use Module\Member\Util\MemberCmsUtil; class OrderController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('event_order') ->field(function ($builder) { $builder->id('id', 'ID')->editable(true); $builder->display('created_at', '创建时间')->editable(true); $builder->display('sn', '订单号')->editable(true); $builder->display('memberUserId', '用户')->hookRendering(function (AbstractField $field, $item, $index) { return MemberCmsUtil::showFromId($item->memberUserId); }); $builder->type('status', '状态')->type(EventOrderStatus::class); $builder->display('totalFee', '总费用'); $builder->currency('payFee', '支付金额'); $builder->display('_item', '订单详情')->hookRendering(function (AbstractField $field, $item, $index) { $orderItems = ModelUtil::all('event_order_item', ['orderId' => $item->id]); ModelUtil::join($orderItems, 'eventId', '_event', 'event', 'id'); return AutoRenderedFieldValue::makeView('module::Event.View.admin.order.item', [ 'orderItems' => $orderItems, 'item' => $item, ]); })->width(300); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->eq('status', '状态')->select(EventOrderStatus::class); }) ->disableCUD()->canShow(false)->canEdit(true) ->title('活动订单'); } private function listForStatus($status) { $grid = $this->grid(); $grid->build(); $grid->filter(function (GridFilter $filter) use ($status) { $filter->clearFilter(); $filter->eq('id', L('ID')); $filter->fixScope()->where('status', $status); }); CRUDUtil::registerGridResource($grid, '\\' . __CLASS__); if (Request::isPost()) { return $grid->request(); } return app(AdminPage::class)->pageTitle(TypeUtil::name(EventOrderStatus::class, $status))->body($grid); } public function waitPay() { return $this->listForStatus(EventOrderStatus::WAIT_PAY); } public function completed() { return $this->listForStatus(EventOrderStatus::COMPLETED); } public function expired() { return $this->listForStatus(EventOrderStatus::EXPIRED); } } 