@extends($_viewFrame)

@section('pageTitleMain','报名'.htmlspecialchars($event['title']))

{!! \ModStart\ModStart::js('asset/common/lazyLoad.js') !!}
@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('event')}}">活动</a>
            <a href="{{modstart_web_url('event/'.$event['id'])}}">{{$event['title']}}</a>
            <a class="active" href="{{modstart_web_url('event/'.$event['id'].'/submit')}}">提交报名</a>
        </div>
        <div class="ub-panel" style="max-width:600px;margin:0 auto;">
            <div class="head">
                <div class="title">活动信息</div>
            </div>
            <div class="body">
                <div style="max-width:200px;margin:0 auto;text-align:center;" class="tw-float-right">
                    <img style="max-width:200px;" class="tw-rounded" src="{{\ModStart\Core\Assets\AssetsUtil::fix($event['cover'])}}" />
                </div>
                <h2>{{$event['title']}}</h2>
                <div class="ub-pair">
                    <div class="name">
                        时间：
                    </div>
                    <div class="value">
                        {{\Carbon\Carbon::parse($event['time'])->format('Y-m-d H:i')}}
                    </div>
                </div>
                @if($event['applyTimeLimit'])
                    <div class="ub-pair">
                        <div class="name">
                            报名开始：
                        </div>
                        <div class="value">
                            {{\Carbon\Carbon::parse($event['applyStartTime'])->format('Y-m-d H:i')}}
                        </div>
                    </div>
                    <div class="ub-pair">
                        <div class="name">
                            报名截止：
                        </div>
                        <div class="value">
                            {{\Carbon\Carbon::parse($event['applyEndTime'])->format('Y-m-d H:i')}}
                        </div>
                    </div>
                @endif
                @if($event['applyNumberLimit'])
                    <div class="ub-pair">
                        <div class="name">
                            报名限制：
                        </div>
                        <div class="value">
                            {{$event['applyNumberMax']}}人
                        </div>
                    </div>
                @endif
                @foreach($event['param'] as $item)
                    <div class="ub-pair">
                        <div class="name">
                            {{$item['name']}}：
                        </div>
                        <div class="value">
                            {{$item['value']}}
                        </div>
                    </div>
                @endforeach
                <div class="ub-pair">
                    <div class="name">
                        费用：
                    </div>
                    <div class="value">
                        @if($event['price']>0)
                            <div class="tw-font-bold ub-text-primary">￥{{$event['price']}}元</div>
                        @else
                            <div class="tw-font-bold ub-text-primary">免费</div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="ub-panel" style="max-width:600px;margin:0 auto;">
            <div class="head">
                <div class="title">报名信息</div>
            </div>
            <div class="body">
                <form action="{{modstart_api_url('event')}}/submit"  method="post" data-ajax-form>
                    <input type="hidden" name="id" value="{{$event['id']}}" />
                    <input type="hidden" name="redirect" value="{{modstart_web_url('event_order_member')}}" />
                    @if($event['applyText'])
                        <div class="tw-bg-gray-100 tw-rounded tw-p-2 ub-html">
                            {!! $event['applyText'] !!}
                        </div>
                    @endif
                    <div class="ub-form">
                        @if(!empty($event['_fieldCustom']))
                            <div class="ub-text-center ub-padding margin-top">
                                请填写以下报名信息
                            </div>
                            <div class="tw-bg-gray-100 tw-rounded tw-p-2 tw-mt-2">
                                @foreach($event['_fieldCustom'] as $index=>$field)
                                    {!! \ModStart\Field\CustomField::renderField($field,'fieldCustom'.($index+1)) !!}
                                @endforeach
                            </div>
                        @endif
                    </div>
                    <div class="margin-top ub-text-center">
                        <button type="submit" class="btn btn-lg btn-primary">确定报名</button>
                    </div>
                </form>
            </div>
        </div>

    </div>

@endsection





