<?php
 namespace Module\Event\Web\Controller; use Illuminate\Support\Facades\View; use ModStart\App\Web\Layout\WebPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Util\CRUDUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Grid\Grid; use ModStart\Grid\GridFilter; use ModStart\ModStart; use ModStart\Module\ModuleBaseController; use ModStart\Widget\Box; use Module\Event\Constant\PayConstant; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; use Module\PayCenter\Traits\PayCenterPerformTrait; class EventOrderMemberController extends ModuleBaseController implements MemberLoginCheck { use PayCenterPerformTrait; private $api; private $viewMemberFrame; public function __construct() { list($this->viewMemberFrame, $_) = $this->viewPaths('member.frame'); View::share('_viewMemberFrame', $this->viewMemberFrame); $this->api = app(\Module\Event\Api\Controller\EventOrderMemberController::class); } public function index(WebPage $page) { ModStart::js('asset/common/qrcode.js'); $grid = Grid::make('event_order'); $grid->filter(function (GridFilter $filter) { $filter->fixScope()->where(['memberUserId' => MemberUser::id()]); $filter->range('created_at', '时间')->datetime(); }); $grid->disableCUD()->disableItemOperate(); $grid->useSimple(function (AbstractField $field, $item, $index) { $orderItems = ModelUtil::all('event_order_item', ['orderId' => $item->id], ['*'], ['id', 'asc']); ModelUtil::join($orderItems, 'eventId', '_event', 'event', 'id'); return AutoRenderedFieldValue::makeView('module::Event.View.pc.member.orderItem', [ 'item' => $item, 'orderItems' => $orderItems, ]); }); if (Request::isPost()) { return $grid->request(); } return $page->pageTitle('我的活动')->view($this->viewMemberFrame)->body(new Box($grid, '我的活动')); } public function pay($id) { $order = ModelUtil::get('event_order', ['memberUserId' => MemberUser::id(), 'id' => $id]); BizException::throwsIfEmpty('订单不存在', $order); return $this->performRedirectOrderPay(PayConstant::EVENT_ORDER, $order['id']); } } 