<?php
 namespace Module\PayCenter\Traits; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use Module\PayCenter\Util\PayOrderUtil; trait PayCenterPerformTrait { private function performSubmitOrder($biz, $bizId, $feeTotal, $body, $param = []) { $input = InputPackage::buildFromInput(); $redirect = $input->getTrimString('redirect'); $order = PayOrderUtil::prepareOrder($biz, $bizId, $feeTotal, $body, $redirect, $param); $orderSecretId = PayOrderUtil::getOrderSecretId($order['id']); $payUrl = modstart_web_url('pay') . "?order=$orderSecretId"; return Response::generate(0, null, [ 'payUrl' => $payUrl, 'orderSecretId' => $orderSecretId, ], $payUrl); } private function performRedirectOrderPay($biz, $bizId) { $ret = $this->performRedirectOrderPayUrl($biz, $bizId); return Response::redirect($ret['data']['payUrl']); } private function performRedirectOrderPayUrl($biz, $bizId) { $order = PayOrderUtil::getByBizAndBizId($biz, $bizId); BizException::throwsIfEmpty('订单不存在', $order); $orderSecretId = PayOrderUtil::getOrderSecretId($order['id']); $payUrl = modstart_web_url('pay') . "?order=$orderSecretId"; return Response::generateSuccessData([ 'payUrl' => $payUrl ]); } }