@extends($_viewFrame)

@section('pageTitleMain','结算中心')

{!! \ModStart\ModStart::js('vendor/PayCenter/entry/pay.js') !!}
@section('bodyAppend')
    @parent
    <script>
        window.__pay = {
            device: '{{\ModStart\Core\Util\AgentUtil::device()}}'
        };
    </script>
@endsection

@section('bodyContent')

    <div class="ub-container" style="max-width:600px;">
        <div class="ub-text-center ub-text-bold" style="padding:0.5rem 0;font-size:1rem;color:#999;">
            <i class="iconfont icon-fukuan"></i>
            结算中心
        </div>
        <div class="ub-panel margin-top">
            <div class="head">
                <div class="title ub-text-muted">订单信息</div>
            </div>
            <div class="body">
                <div class="ub-pair">
                    <div class="name">订单号</div>
                    <div class="value">{{$order['id']}}</div>
                </div>
                <div class="ub-pair">
                    <div class="name">内容</div>
                    <div class="value">{{$order['body']}}</div>
                </div>
                <div class="ub-pair">
                    <div class="name">金额</div>
                    <div class="value"><span class="ub-text-warning" style="font-size:1rem;">￥{{$order['feeTotal']}}</span></div>
                </div>
            </div>
        </div>
        @if($order['status']===\Module\PayCenter\Type\PayOrderStatus::PAYED)
            <div class="ub-alert ub-alert-success">
                当前订单已支付，正在跳转中...
            </div>
            <script>
                setTimeout(function(){
                    window.location.href = {!! json_encode($order['redirect']) !!};
                },2000);
            </script>
        @elseif($order['status']===\Module\PayCenter\Type\PayOrderStatus::CLOSED)
            <div class="ub-alert ub-alert-success">
                订单已关闭，正在跳转中...
            </div>
            <script>
                setTimeout(function(){
                    window.location.href = {!! json_encode($order['redirect']) !!};
                },2000);
            </script>
        @else
            <div class="ub-panel">
                <div class="head">
                    <div class="title ub-text-muted">点击支付</div>
                </div>
                <div class="body">
                    @if( \Module\PayCenter\Util\PayUtil::hasPay() )
                        <div class="ub-list-pay">
                            @if(\Module\PayCenter\Util\PayUtil::isAlipayEnable())
                                <a class="item {{$autoClickPayType==\Module\PayCenter\Type\PayType::ALIPAY?'active':''}}" href="javascript:;"
                                   data-type="{{\Module\PayCenter\Type\PayType::ALIPAY}}">
                                    <img class="icon" src="@asset('asset/image/pay/alipay.jpg')"/>
                                    支付宝
                                </a>
                            @endif
                            @if(\Module\PayCenter\Util\PayUtil::isWechatEnable())
                                @if(\ModStart\Core\Util\AgentUtil::isWechat())
                                    <a class="item {{$autoClickPayType==\Module\PayCenter\Type\PayType::WECHAT_MOBILE?'active':''}}" href="javascript:;"
                                       data-type="{{\Module\PayCenter\Type\PayType::WECHAT_MOBILE}}">
                                        <img class="icon" src="@asset('asset/image/pay/wechat.jpg')"/>
                                        微信手机支付
                                    </a>
                                @else
                                    <a class="item {{$autoClickPayType==\Module\PayCenter\Type\PayType::WECHAT?'active':''}}" href="javascript:;"
                                       data-type="{{\Module\PayCenter\Type\PayType::WECHAT}}">
                                        <img class="icon" src="@asset('asset/image/pay/wechat.jpg')"/>
                                        微信扫码支付
                                    </a>
                                @endif
                            @endif
                        </div>
                    @else
                        <div class="ub-alert ub-alert-danger">
                            未开通任何支付方式
                        </div>
                    @endif
                </div>
            </div>
        @endif
    </div>

@endsection
