<?php
 namespace Module\PayCenter\Web\Controller; use Illuminate\Support\Facades\Session; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Module\ModuleBaseController; use Module\PayCenter\Type\PayOrderStatus; use Module\PayCenter\Type\PayType; use Module\PayCenter\Util\PayOrderUtil; use Module\PayCenter\Util\PayUtil; use Module\Vendor\Oauth\OauthType; class PayController extends ModuleBaseController { private $api; public function __construct() { $this->api = app(\Module\PayCenter\Api\Controller\PayController::class); } public function index() { $payInfo = Response::tryGetData($this->api->info()); $order = $payInfo['order']; if (Request::isPost()) { return Response::jsonFromGenerate($this->api->submit($order, $payInfo['orderSecretId'])); } $autoClickPayType = Session::get('autoClickPayType', null); Session::forget('autoClickPayType'); return $this->view('pay.index', [ 'order' => $order, 'autoClickPayType' => $autoClickPayType, ]); } public function watch() { $payInfo = Response::tryGetData($this->api->info()); $order = $payInfo['order']; switch ($order['status']) { case PayOrderStatus::NEW_ORDER: case PayOrderStatus::CREATED: return Response::generate(0, null, ['status' => 'new']); case PayOrderStatus::PAYED: return Response::generate(0, null, ['status' => 'payed']); case PayOrderStatus::CLOSED: return Response::generate(0, null, ['status' => 'expired']); default: return Response::generate(-1, 'order status error'); } } }