<?php
 namespace Module\PayCenter\Web\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Request; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use Module\PayCenter\Type\PayType; use Module\PayCenter\Util\PayOrderUtil; class ReturnController extends Controller { public function index($payType = '') { $input = InputPackage::buildFromInput(); switch ($payType) { case PayType::ALIPAY: PayOrderUtil::initAlipay(); if (!app('alipay.web')->verify()) { Log::info('PayCenter.ReturnController - alipay return - query data verification fail - ' . json_encode([ 'data' => Request::getQueryString() ])); return Response::send(-1, '支付失败:-1'); } switch (Input::get('trade_status')) { case 'TRADE_SUCCESS': case 'TRADE_FINISHED': $outTradeNo = $input->getTrimString('out_trade_no'); $tradeNo = $input->getTrimString('trade_no'); Log::info('PayCenter.ReturnController - alipay return - data verification success - ' . json_encode([ 'out_trade_no' => $outTradeNo, 'trade_no' => $tradeNo, ])); $ret = PayOrderUtil::handleOrderPay(PayType::ALIPAY, $outTradeNo, [ 'payOrderId' => $tradeNo, ]); if ($ret['code']) { return Response::send(-1, '支付失败:' . $ret['msg']); } $redirect = empty($ret['data']['order']['redirect']) ? null : $ret['data']['order']['redirect']; if (null === $redirect) { return Response::send(0, '支付成功'); } else { return Response::send(0, null, null, $redirect); } } return Response::send(-1, '支付失败'); } } } 