@extends($_viewFrame)

@section('pageTitle',modstart_config('siteName').' - '.modstart_config('siteSlogan'))

@section('bodyContent')

    @include('module::Banner.View.pc.public.banner',['position'=>'home','bannerRatio'=>\ModStart\Core\Util\AgentUtil::isMobile()?'5-3':'3-1'])

    <div class="ub-container margin-top">
        @foreach(\Module\Event\Util\EventUtil::listCategories() as $category)
            <div class="ub-panel transparent">
                <div class="head">
                    <div class="title">
                        {{$category['title']}}
                        <span class="ub-text-muted tw-ml-2">
                            {{$category['summary']}}
                        </span>
                    </div>
                </div>
                <div class="body ub-list-items">
                    <div class="row">
                        @foreach(\Module\Event\Util\EventUtil::listEventByCategory($category['id']) as $record)
                            <div class="col-md-3 col-12">
                                <div class="item-video-cover">
                                    <a class="ub-cover-5-3" href="{{modstart_web_url('event/'.$record['id'])}}" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}})"></a>
                                    <a class="title" href="{{modstart_web_url('event/'.$record['id'])}}">{{$record['title']}}</a>
                                    <div class="category">
                                        <div class="stat">
                                        <span class="ub-text-muted">
                                            <i class="iconfont icon-time"></i>
                                            {{\Carbon\Carbon::parse($record['time'])->toDateString()}}
                                        </span>
                                        </div>
                                        @if($record['status']==\Module\Event\Type\EventStatus::APPLYING)
                                            <span class="ub-text-success">正在报名</span>
                                        @else
                                            <div class="ub-text-muted">{{\ModStart\Core\Type\TypeUtil::name(\Module\Event\Type\EventStatus::class,$record['status'])}}</div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="ub-container margin-top">
        @include('module::Partner.View.pc.public.partner',['position'=>'home'])
    </div>

@endsection
