<?php
 namespace ModStart\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminPage; use ModStart\Admin\Repository\ModuleRepository; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Field\AbstractField; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\Grid; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Module\ModuleStatus; use ModStart\Module\ModuleType; use ModStart\Repository\RepositoryUtil; use ModStart\Widget\ButtonAjaxRequest; use ModStart\Widget\ButtonDialogRequest; use ModStart\Widget\StatusText; use ModStart\Widget\TextAjaxRequest; use ModStart\Widget\TextDialogRequest; class ModuleController extends Controller { public function index(AdminPage $page) { $grid = new Grid(ModuleRepository::class); $grid->display('basic', L('Name'))->width(300)->hookRendering(function (AbstractField $field, $item, $index) { return join('', [ '<div>' . htmlspecialchars($item->title) . ' ' . $item->name . '</div>', '<div class="ub-text-muted">' . htmlspecialchars($item->description) . '</div>', ]); }); $grid->select('type', L('Type'))->optionType(ModuleType::class); $grid->display('require', L('Depend on')); $grid->type('status', L('Status')) ->type([1 => L('Installed'), 2 => L('Not Installed'),], [1 => 'success', 2 => 'warning']) ->hookValueUnserialize(function ($value, AbstractField $field) { $item = $field->item(); return ModuleManager::isModuleInstalled($item->name) ? 1 : 2; }); $grid->display('version', L('Version')); $grid->display('author', L('Author')); $grid->hookItemOperateRendering(function (ItemOperate $itemOperate) { $itemOperate->getField()->width(300); $item = $itemOperate->item(); if (ModuleManager::isSystemModule($item->name)) { $itemOperate->push(ButtonAjaxRequest::warning(L('Refresh'), action('\\' . __CLASS__ . '@refresh', ['name' => $item->name])), null, true); $itemOperate->push('<span class="btn btn-default disabled">' . L('System Module') . '</span>'); } else { if (ModuleManager::isModuleInstalled($item->name)) { if (!empty($item->config)) { $itemOperate->push(ButtonDialogRequest::primary(L('Config'), action('\\' . __CLASS__ . '@config', ['name' => $item->name]))); } $itemOperate->push(ButtonAjaxRequest::warning(L('Refresh'), action('\\' . __CLASS__ . '@refresh', ['name' => $item->name]))); $itemOperate->push(ButtonAjaxRequest::muted(L('Install'), null, null, true)); $itemOperate->push(ButtonAjaxRequest::danger(L('Uninstall'), action('\\' . __CLASS__ . '@uninstall', ['name' => $item->name]), L('Confirm Uninstall ?') . ' (' . $item->name . ')')); } else { $itemOperate->push(ButtonAjaxRequest::primary(L('Install'), action('\\' . __CLASS__ . '@install', ['name' => $item->name]), L('Confirm Install ?') . ' (' . $item->name . ')')); $itemOperate->push(ButtonAjaxRequest::muted(L('Uninstall'), null, null, true)); } } }); $grid->filter(function (GridFilter $filter) { $filter->eq('type', L('Type'))->radio(ModuleType::class); $filter->eq('status', L('Status'))->radio(ModuleStatus::class); $filter->like('keywords', L('Keywords')); }); $grid->disableCUD(); if (Request::isPost()) { return $grid->request(); } $grid->enablePagination(false); return $page->pageTitle(L('Module Manager'))->body($grid); } public function install() { AdminPermission::demoCheck(); AdminPermission::permitCheck('\ModStart\Admin\Controller\ModuleController@index'); $ret = ModuleManager::install(InputPackage::buildFromInput()->getTrimString('name')); return Response::jsonIfGenerateSuccess($ret, L('Install Success'), null, '[js]window.__grids.get(0).lister.refresh();'); } public function refresh() { AdminPermission::demoCheck(); AdminPermission::permitCheck('\ModStart\Admin\Controller\ModuleController@index'); $ret = ModuleManager::install(InputPackage::buildFromInput()->getTrimString('name')); return Response::jsonIfGenerateSuccess($ret, L('Operate Success'), null, '[js]window.__grids.get(0).lister.refresh();'); } public function uninstall() { AdminPermission::demoCheck(); AdminPermission::permitCheck('\ModStart\Admin\Controller\ModuleController@index'); $ret = ModuleManager::uninstall(InputPackage::buildFromInput()->getTrimString('name')); return Response::jsonIfGenerateSuccess($ret, L('Uninstall Success'), null, '[js]window.__grids.get(0).lister.refresh();'); } public function config(AdminConfigBuilder $builder) { AdminPermission::permitCheck('\ModStart\Admin\Controller\ModuleController@index'); $module = InputPackage::buildFromInput()->getTrimString('name'); $basic = ModuleManager::getModuleBasic($module); AdminPermission::demoPostCheck(); $builder->useDialog(); $builder->pageTitle($basic['title'] . ' ' . L('Module Config')); $moduleInfo = ModuleManager::getInstalledModuleInfo($module); BizException::throwsIfEmpty('Module config error', $basic['config']); foreach ($basic['config'] as $key => $callers) { $field = null; if (!isset($moduleInfo['config'][$key])) { $moduleInfo['config'][$key] = null; } foreach ($callers as $caller) { $name = array_shift($caller); if (null === $field) { array_unshift($caller, $key); $field = call_user_func([$builder, $name], ...$caller); } else { call_user_func([$field, $name], ...$caller); } } } return $builder->perform(RepositoryUtil::itemFromArray($moduleInfo['config']), function (Form $form) use ($module) { ModuleManager::saveUserInstalledModuleConfig($module, $form->dataForming()); }); } }