<?php

/*
 * This file is part of the overtrue/wechat.
 *
 * (c) overtrue <i@overtrue.me>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */
namespace EasyWeChat\OfficialAccount\Auth;

use EasyWeChat\Kernel\AccessToken as BaseAccessToken;
/**
 * Class AuthorizerAccessToken.
 *
 * @author overtrue <i@overtrue.me>
 */
class AccessToken extends BaseAccessToken
{
    /**
     * @var string
     */
    protected $endpointToGetToken = 'https://api.weixin.qq.com/cgi-bin/token';
    /**
     * @return array
     */
    protected function getCredentials()
    {
        return ['grant_type' => 'client_credential', 'appid' => $this->app['config']['app_id'], 'secret' => $this->app['config']['secret']];
    }
}