<?php

/*
 * This file is part of the overtrue/wechat.
 *
 * (c) overtrue <i@overtrue.me>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */
namespace EasyWeChat\Work\MiniProgram\Auth;

use EasyWeChat\Kernel\BaseClient;
/**
 * Class Client.
 */
class Client extends BaseClient
{
    /**
     * Get session info by code.
     *
     * @param $code
     *
     * @return \Psr\Http\Message\ResponseInterface|\EasyWeChat\Kernel\Support\Collection|array|object|string
     *
     * @throws \EasyWeChat\Kernel\Exceptions\InvalidConfigException
     */
    public function session($code)
    {
        $params = ['js_code' => $code, 'grant_type' => 'authorization_code'];
        return $this->httpGet('cgi-bin/miniprogram/jscode2session', $params);
    }
}