<?php
 namespace App\Modules\User\Mobile; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\Session; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\Member\Type\Gender; use TechSoft\Laravel\Oauth\Driver\Oauth; class OauthController extends Controller { private function getOauthConfig($type) { $config = []; $config['CALLBACK'] = action('\App\Modules\User\Mobile\OauthController@callback', ['oauthType' => $type]); $config['APP_KEY'] = ConfigUtil::getWithEnv('oauthWechatMobileAppId'); $config['APP_SECRET'] = ConfigUtil::getWithEnv('oauthWechatMobileAppSecret'); $config['PROXY'] = ConfigUtil::getWithEnv('oauthWechatMobileProxy'); return $config; } public function login($type) { $config = $this->getOauthConfig($type); if (empty($config)) { return Response::send(-1, '授权登录配置错误'); } if ($config['PROXY']) { $url = $config['PROXY'] . '?appid=' . $config['APP_KEY'] . '&scope=snsapi_base&redirect_uri=' . urlencode($config['CALLBACK']); } else { $sns = Oauth::getInstance($type, $config); $url = $sns->getRequestCodeURL(); } $redirect = Input::get('redirect', '/'); if (!empty($redirect)) { Session::put('oauthRedirect', $redirect); } return redirect($url); } public function callback($oauthType) { $code = Input::get('code', ''); if (empty($code)) { return Response::send(-1, '登录失败(code为空)'); } $config = $this->getOauthConfig($oauthType); if (empty($config)) { return Response::send(-1, '授权登录配置错误'); } $oauth = Oauth::getInstance($oauthType, $config); $token = null; $openid = null; try { $token = $oauth->getAccessToken($code, null); $openid = $oauth->openid(); } catch (\Exception $e) { return Response::send(-1, '登录失败(' . $e->getMessage() . ')'); } if (empty($token) || empty($openid)) { return Response::send(-1, '登录失败(token=' . print_r($token, true) . ',openid=' . $openid . ')'); } $data = $oauth->call('sns/userinfo'); if (!empty($data ['errcode'])) { return Response::send(-1, "微信登录失败：" . $data['errmsg']); } $userInfo = []; $userInfo['username'] = $data['nickname']; $userInfo['avatar'] = $data['headimgurl']; if ($data['sex'] == 2) { $userInfo['gender'] = Gender::FEMALE; } else if ($data['sex'] == 1) { $userInfo['gender'] = Gender::MALE; } else { $userInfo['gender'] = Gender::UNKNOWN; } $userInfo['province'] = $data['province']; $userInfo['city'] = $data['city']; $userInfo['country'] = $data['country']; $memberUserId = MemberUtil::getIdByOauth($oauthType, $openid); if (empty($memberUserId)) { $memberUser = MemberUtil::insert($userInfo); $memberUserId = $memberUser['id']; MemberUtil::update($memberUserId, ['alias' => $memberUserId]); } else { MemberUtil::update($memberUserId, $userInfo); } MemberUtil::putOauth($memberUserId, $oauthType, $openid); Session::put('memberUserId', $memberUserId); return redirect(Session::get('oauthRedirect', '/')); } }