<?php
 namespace App\Util; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Type\TypeUtil; use TechSoft\Laravel\Assets\AssetsUtil; class CmsHtmlUtil { public static function user($user) { if (!is_array($user)) { $user = ModelUtil::getWithCache('member_user', ['id' => $user]); } if (!empty($user)) { $user['avatar'] = AssetsUtil::fix($user['avatar']); return ' <a href="javascript:;" data-user-info="' . $user['id'] . '" class="list-user-info"><img src="' . $user['avatar'] . '" /><span>' . htmlspecialchars($user['username']) . '</span></a>'; } return ''; } public static function image($imageUrl) { return '<img style="width:40px;height:40px;border:1px solid #EEE;border-radius:3px;" 
        src="' . AssetsUtil::fixOrDefault($imageUrl, 'assets/lib/img/none.png') . '" data-image-preview />'; } public static function images($imageUrlArray) { $images = []; foreach ($imageUrlArray as $imageUrl) { $images[] = '<img style="width:40px;height:40px;border:1px solid #EEE;border-radius:3px;" 
        src="' . AssetsUtil::fixOrDefault($imageUrl, 'assets/lib/img/none.png') . '" data-image-preview />'; } return join(' ', $images); } public static function link($linkUrl, $title = null) { if (empty($linkUrl)) { return ''; } if (null === $title) { $title = '<i class="uk-icon-link"></i> ' . htmlspecialchars($linkUrl); } return '<a href="' . htmlspecialchars($linkUrl) . '" target="_blank" style="max-width:20em;display:inline-block;white-space:no-wrap;overflow:hidden;text-overflow:ellipsis;">' . $title . '</a>'; } public static function visible($visible, $link = null) { if ($link) { if ($visible) { return '<a href="javascript:;" data-uk-tooltip title="点击隐藏" data-ajax-request-loading data-ajax-request="' . htmlspecialchars($link) . '" class="uk-text-success"><i class="uk-icon-eye"></i> 是</a>'; } else { return '<a href="javascript:;" data-uk-tooltip title="点击显示" data-ajax-request-loading data-ajax-request="' . htmlspecialchars($link) . '" class="uk-text-danger"><i class="uk-icon-eye-slash"></i> 否</a>'; } } else { if ($visible) { return '<span class="uk-text-success">是</span>'; } else { return '<span class="uk-text-danger">否</span>'; } } } public static function pass($link = null, $text = null) { if (null === $text) { $text = '审核通过'; } return '<a class="uk-button uk-button-success" style="padding:0 0.8em;" href="javascript:;" data-uk-tooltip title="' . $text . '" data-ajax-request-loading data-ajax-request="' . htmlspecialchars($link) . '"><i class="uk-icon-check"></i></a>'; } public static function reject($link = null) { return '<a class="uk-button uk-button-danger" style="padding:0 0.8em;" href="javascript:;" data-uk-tooltip title="审核拒绝" data-ajax-request-loading data-ajax-request="' . htmlspecialchars($link) . '"><i class="uk-icon-minus"></i></a>'; } public static function retry($link = null) { return '<a class="uk-button uk-button-danger" style="padding:0 0.8em;" href="javascript:;" data-uk-tooltip title="重试" data-ajax-request-loading data-ajax-request="' . htmlspecialchars($link) . '"><i class="uk-icon-refresh"></i></a>'; } public static function edit($link) { return '<a class="uk-button uk-button-primary" style="padding:0 0.8em;" href="' . htmlspecialchars($link) . '" data-uk-tooltip title="编辑"><i class="uk-icon-edit"></i></a>'; } public static function editDialog($link) { return '<a class="uk-button uk-button-primary" style="padding:0 0.8em;" href="javascript:;" data-dialog-request="' . htmlspecialchars($link) . '" data-uk-tooltip title="编辑"><i class="uk-icon-edit"></i></a>'; } public static function viewDialog($link) { return '<a class="uk-button uk-button-primary" style="padding:0 0.8em;" href="javascript:;" data-dialog-request="' . htmlspecialchars($link) . '" data-uk-tooltip title="查看"><i class="uk-icon-eye"></i></a>'; } public static function delete($link) { return '<a class="uk-button uk-button-danger" style="padding:0 0.8em;" href="javascript:;" data-confirm="确定删除?" data-ajax-request-loading data-ajax-request="' . htmlspecialchars($link) . '" data-uk-tooltip title="删除"><i class="uk-icon-trash"></i></a>'; } public static function statusDanger($text) { return '<span class="uk-text-danger">' . $text . '</span>'; } public static function statusSuccess($text) { return '<span class="uk-text-success">' . $text . '</span>'; } public static function statusMuted($text) { return '<span class="uk-text-muted">' . $text . '</span>'; } public static function statusWarning($text) { return '<span class="uk-text-warning">' . $text . '</span>'; } public static function status($typeCls, $value, $map = []) { $name = TypeUtil::name($typeCls, $value); if (empty($name)) { return ''; } if (empty($map[$value])) { $map[$value] = ''; } return '<span class="uk-text-' . $map[$value] . '">' . $name . '</span>'; } public static function badge($typeCls, $value, $map = []) { $name = TypeUtil::name($typeCls, $value); if (empty($name)) { return ''; } if (empty($map[$value])) { $map[$value] = ''; } return '<span class="uk-badge uk-badge-' . $map[$value] . '">' . $name . '</span>'; } }