@extends('res::frameMUI')

@section('pageTitle',htmlspecialchars($_activity['title']))

@section('headAppend')
    <link rel="stylesheet" href="@assets('res/bigWheel/default/mobile/css/style.css')">
    <style type="text/css">
        html{background-image: url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($_activity['background'])}});}
        .pb-activity-action .nav a{ color:{{$_activity['textColor']}}; }
    </style>
@endsection

@section('bodyScript')
    @parent
    <script src="//res.wx.qq.com/open/js/jweixin-1.0.0.js"></script>
    <script>
        var __app = {
            prizes:@jsonArray($prizes),
            payDrawUrl:'{{action('\App\Modules\PrizePool\Mobile\HomeController@payDraw',['alias'=>$_memberUser['alias'],'activityType'=>\App\Modules\PrizePool\ActivityType::BIG_WHEEL,'activityAlias'=>$_activity['alias']])}}',
            drawUrl:'{{action('\App\Modules\BigWheel\Mobile\HomeController@draw',['alias'=>$_activity['alias']])}}',
            prepareResultHtml: @jsonString($prepareResultHtml),
            share:{
                title:<?php echo json_encode($_activity['shareTitle']); ?>,
                link:window.location.href,
                desc:<?php echo json_encode($_activity['shareDesc']); ?>,
                imgUrl:'{{\TechSoft\Laravel\Assets\AssetsUtil::fixFull($_activity['shareImage'])}}'
            }
        };
        wx.config(<?php echo \App\Util\PlatformUtil::getWechatApp($_activity['memberUserId'])
            ->js->config(array('chooseWXPay','onMenuShareTimeline','onMenuShareAppMessage','hideAllNonBaseMenuItem'), false) ?>);
        wx.ready(function () {
            @if($_activity['shareEnable'])
                wx.onMenuShareAppMessage({
                    title: __app.share.title,
                    desc: __app.share.desc,
                    link: __app.share.link,
                    imgUrl: __app.share.imgUrl,
                    type: 'link',
                    dataUrl: ''
                });
                wx.onMenuShareTimeline({
                    title: __app.share.title,
                    desc: __app.share.desc,
                    link: __app.share.link,
                    imgUrl: __app.share.imgUrl
                });
            @else
                wx.hideAllNonBaseMenuItem();
            @endif
        });
    </script>
    <script src="@assets('assets/m/bigWheel/all.js')"></script>
    @if($_activity['backgroundMusic'])
        @include('res::activity.music',['backgroundMusic'=>$_activity['backgroundMusic']])
    @endif
@endsection

@section('body')

    <div class="mui-content">

        <div class="pb-big-wheel">
            <div class="wheel-box">
                <canvas id="wheel" width="480" height="480"></canvas>
                <img id="pointer" class="pointer" src="@assets('res/bigWheel/default/mobile/css/pointer.png')" />
            </div>
        </div>

        <div class="pb-activity-action">
            <div class="nav">
                @if($_activity['description'])
                    <a href="javascript:;" onclick="$('.pb-dialog-description').show();$('body,html').addClass('locked');"><i class="iconfont">&#xe619;</i> 活动说明</a>
                @endif
                @if($_activity['prizeUsersEnable'])
                    <a href="{{action('\App\Modules\PrizePool\Mobile\HomeController@users',['alias'=>$_memberUser['alias'],'activityType'=>\App\Modules\PrizePool\ActivityType::BIG_WHEEL,'activityAlias'=>$_activity['alias']])}}"><i class="iconfont">&#xe62e;</i> 中奖用户</a>
                @endif
                <a href="{{action('\App\Modules\PrizePool\Mobile\HomeController@activity',['alias'=>$_memberUser['alias'],'activityType'=>\App\Modules\PrizePool\ActivityType::BIG_WHEEL,'activityAlias'=>$_activity['alias']])}}"><i class="iconfont">&#xe607;</i> 我的奖品</a>
                @if($_activity['shareEnable'])
                    <a href="javascript:;" onclick="$('.pb-dialog-share').show();$('body,html').addClass('locked');"><i class="iconfont">&#xe60c;</i> 分享活动</a>
                @endif
            </div>
        </div>

        @if($_activity['description'])
            @include('res::activity.description',['description'=>\TechSoft\Laravel\Util\HtmlUtil::text2html($_activity['description'])])
        @endif
        @if($_activity['shareEnable'])
            @include('res::activity.share')
        @endif
    </div>

@endsection