@foreach($records as $record)
    <div class="item-user">
        <div class="head">
            <div class="prize">
                @if($record['type']==\App\Modules\PrizePool\PrizeType::REDBAG)
                    {{$record['name']}}
                    <span class="value">
                    ￥{{sprintf('%0.2f',$record['redbagValue'])}} 元
                </span>
                @endif
                @if($record['type']==\App\Modules\PrizePool\PrizeType::CREDIT)
                    {{$record['name']}}
                    <span class="value">
                    {{$record['creditValue']}} 分
                </span>
                @endif
                @if($record['type']==\App\Modules\PrizePool\PrizeType::CODE)
                    {{$record['name']}}
                @endif
                @if($record['type']==\App\Modules\PrizePool\PrizeType::PHYSICAL)
                    {{$record['name']}}
                @endif
            </div>
            <div class="avatar">
                @if(empty($record['_user']['avatar']))
                    <img src="@assets('assets/lib/img/avatar.png')" />
                @else
                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($record['_user']['avatar'])}}" />
                @endif
            </div>
            <div class="username">
                {{$record['_user']['username'] or '[未知用户]'}}
            </div>
            <div class="time">
                <i class="iconfont">&#xe61e;</i>
                <time datetime="{{$record['created_at']}}"></time>
            </div>
        </div>
    </div>
@endforeach