@extends('theme.default.pc.member.frame')

@section('pageTitleMain','礼品中心')

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li class="uk-active"><span>奖品中心</span></li>
    </ul>
@endsection

@section('bodyScript')
    @parent
    <script src="@assets('assets/echarts/echarts.all.js')"></script>
    <script>
        $(function () {
            var option = {
                color: ['#DF6B25'],
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {
                        type : 'shadow'
                    }
                },
                grid: {
                    left: '3%',
                    right: '3%',
                    bottom: '3%',
                    top:'3%',
                    containLabel: true
                },
                xAxis : [
                    {
                        type : 'category',
                        data : @jsonArray($drawLatestReport['time']),
                        axisTick: {
                            alignWithLabel: true,
                        },
                        axisLabel:{
                            interval:0,
                            formatter: function (value, index) {
                                var date = new Date(value);
                                return [(date.getMonth()<9?'0':''),(date.getMonth() + 1), (date.getDate()<10?'0':''),date.getDate()].join('');
                            }
                        }
                    }
                ],
                yAxis : [
                    {
                        type : 'value'
                    }
                ],
                series : [
                    {
                        name:'奖品领取数量',
                        type:'bar',
                        barWidth: '60%',
                        data:@jsonArray($drawLatestReport['value'])
                    }
                ]
            };
            echarts.init(document.getElementById('drawLatestReport')).setOption(option);
        });
    </script>
@endsection

@section('memberContent')

    <div class="uk-grid">
        <div class="uk-width-1-2">

            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>概况</h2>
                </div>
                <div class="body">
                    <div class="uk-grid">
                        <div class="uk-width-1-2">
                            <a href="/module/manage/prize_pool_prize" class="item-count">
                                <i class="uk-icon-gift"></i>
                                <span class="value uk-text-success">{{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('module_prize_pool',['memberUserId'=>$_memberUser['id']]))}}</span>
                                <span class="title">奖品总数</span>
                            </a>
                        </div>
                        <div class="uk-width-1-2">
                            <a href="/module/manage/prize_pool_drawn" class="item-count">
                                <i class="uk-icon-gift"></i>
                                <span class="value uk-text-success">{{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('module_prize_pool_drawn',['memberUserId'=>$_memberUser['id']]))}}</span>
                                <span class="title">总领取人次</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>操作</h2>
                </div>
                <div class="body">
                    <div class="uk-grid">
                        <div class="uk-width-1-3">
                            <a href="/module/manage/prize_pool_prize" class="item">
                                <i class="uk-icon-list-alt"></i>
                                <span>奖品管理</span>
                            </a>
                        </div>
                        <div class="uk-width-1-3">
                            <a href="/module/manage/prize_pool_drawn" class="item">
                                <i class="uk-icon-list"></i>
                                <span>领取记录</span>
                            </a>
                        </div>
                        <div class="uk-width-1-3">
                            <a href="/module/manage/prize_pool_setting" class="item">
                                <i class="uk-icon-cog"></i>
                                <span>未中奖设置</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="uk-width-1-2">

            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>奖品领取数量</h2>
                </div>
                <div class="body">
                    <div id="drawLatestReport" style="height:235px;width:100%;"></div>
                </div>
            </div>

        </div>
    </div>


@endsection