<?php
class AdminAction extends GlobalAction{
    function _initialize(){
		parent::_initialize();
		//取角色组
		$rolelist = D('Admin_role')->order('id desc')->findAll();
		$this->assign('rolelist',$rolelist);
	}
	
	/**
	 * 管理员列表
	 *
	 */
	public function index(){
		parent::_checkpermission();
		$Admin = D('Admin');
		$list = $Admin->table(C('DB_PREFIX').'admin a')->join(C('DB_PREFIX').'admin_role b on a.roleid=b.id')->field('a.*,b.name as rolename')->order('a.id desc')->findAll();
		$this->assign('list',$list);
		$this->display();
    }
	
    /**
     * 添加管理员
	 *
     */
    public function add(){
		parent::_checkpermission();
		//表单提交
		if($this->isPost()){	
			$Admin = D('Admin');
			if($Admin->create()){
				if(false !== $Admin->add()){
					$this->operatelog('0','添加管理员 '.$_SERVER['PHP_SELF']); //写入日志	
					$this->success('添加成功');
				}
				else{
					$this->error('添加失败');
				}
			}
			else{
				$this->error($Admin->getError());
			}
		}
		else{
			//添加管理员
			$this->display();
		}
    }
	
    /**
     * 修改管理员
	 *
     */
    public function edit(){
		parent::_checkpermission();
		//表单提交
		if($this->isPost()){
			$Admin = D('Admin');
			if($Admin->create()){
				if(!empty($_POST['password'])){
					$Admin->password = md5($_POST['password']);
				}
				else{
					$Admin->password = $_POST['oldpassword'];
				}		
				if(false !== $Admin->save()){
					$this->operatelog('0','修改管理员 '.$_SERVER['PHP_SELF']); //写入日志	
					$this->assign('jumpUrl',$_POST['returnurl']);
					$this->success('更新成功');
				}
				else{
					$this->error('没有任何更新');
				}
			}
			else{
				$this->error($Admin->getError());
			}
		}
		else{
			//修改管理员
			if(!empty($_GET['id'])){
				$Admin = D('Admin');
				$data= $Admin->getById($_GET['id']);
				if($data){
					$this->assign('returnurl',$_SERVER['HTTP_REFERER']);
					$this->assign('data',$data);
					$this->display();
				}
				else{
					exit('编辑项不存在');
				}		
			}
			else{
				exit('编辑项不存在');
			}
		}
    }
	
    /**
     * 删除
	 *
     */
	 public function delete(){
		parent::_checkpermission();
		if(!empty($_GET['id'])){
			$Admin = D('Admin');
			if($Admin->delete($_GET['id'])) {
				$this->operatelog('0','删除管理员 '.$_SERVER['PHP_SELF']); //写入日志	
				$this->success('删除成功!');
			}
			else{
				$this->error('删除出错!');
			}
		}
		else{
			$this->error('删除项不存在');
		}
	 }
	 
	/**
	 * 密码修改
	 *
	 */
    public function password(){
		//表单提交
		if($this->isPost()){
			$old_password = md5(trim($_POST['old_password']));
			$new_password = md5(trim($_POST['new_password']));	
			//
			$Admin = D('Admin');
			$condition = array();
			$condition['id'] = $this->adminid;
			$condition['password'] = $old_password;
			$result = $Admin->where($condition)->find();
			if(false == $result){
				$this->error('旧密码输入错误');
			}
			else{
				$data['id'] = $this->adminid;
				$data['password'] = $new_password;
				if($Admin->save($data)){
					$this->success('密码修改成功');
				}
				else{
					$this->error('密码修改失败');
				}				
			}
		}
		else{
			$this->display();
		}		
	}
}
?>
