<?php
require_once (APP_PATH.'/Common/function.php');
class GlobalAction extends Action{
	protected $username,$adminid,$roleid;
	function _initialize(){		
		$this->username = Session::get('username');
		$this->adminid = intval(Session::get('adminid'));
		$this->assign('username',$this->username);
		$this->assign('adminid',$this->adminid);
		if(empty($this->username) || empty($this->adminid)){
			if(MODULE_NAME != 'Public'){
				redirect(U('Public/login'));
			}
		}
		$this->assign('returnurl',$_SERVER['HTTP_REFERER']);
	}
	
	/**
	 * 权限检查
	 *
	 */
	protected function _checkpermission($action = NULL){
		$formatAction = strtolower($action);
		if(empty($action)) $formatAction = strtolower(MODULE_NAME.'_'.ACTION_NAME);		
		$permission = Session::get('permission');		
		
		if($permission != 'all'){
			
			$Admin_role = D('Admin_role');
			$getPermission = $Admin_role->Where('id='.$this->roleid)->find();			
			$arrPermission = explode(',',strtolower($getPermission['permission']).',index_index');
			if(!in_array($formatAction,$arrPermission)){
				$this->error('当前角色组无权限进行此操作，请联系管理员授权');
			}		
		}
	}
	
	/**
	 * 添加日志
	 *
	 */
	protected function operatelog($classid,$operate,$username=''){
		$Log = D('Log');
		$Log->classid = $classid;
		$Log->operate = $operate;
		$Log->username = !empty($username)?$username:$this->username;
		$Log->ip = getip();
		$Log->posttime = strtotime(date('Y-m-d H:i:s'));
		$Log->add();
	}
	
}
?>