<?php

//货币转换
function num_format($num){
    if(!is_numeric($num)){
        return false;
    }
    $rvalue='';
    $num = explode('.',$num);//把整数和小数分开
    $rl = !isset($num['1']) ? '' : $num['1'];//小数部分的值
    $j = strlen($num[0]) % 3;//整数有多少位
    $sl = substr($num[0], 0, $j);//前面不满三位的数取出来
    $sr = substr($num[0], $j);//后面的满三位的数取出来
    $i = 0;
    while($i <= strlen($sr)){
        $rvalue = $rvalue.','.substr($sr, $i, 3);//三位三位取出再合并，按逗号隔开
        $i = $i + 3;
    }
    $rvalue = $sl.$rvalue;
    $rvalue = substr($rvalue,0,strlen($rvalue)-1);//去掉最后一个逗号
    $rvalue = explode(',',$rvalue);//分解成数组
    if($rvalue[0]==0){
        array_shift($rvalue);//如果第一个元素为0，删除第一个元素
    }
    $rv = $rvalue[0];//前面不满三位的数
    for($i = 1; $i < count($rvalue); $i++){
        $rv = $rv.','.$rvalue[$i];
    }
    if(!empty($rl)){
        $rvalue = $rv.'.'.$rl;//小数不为空，整数和小数合并
    }else{
        $rvalue = $rv;//小数为空，只有整数
    }
    return $rvalue;
}

//返回充值订单号
function ordernumber(){
	return date('Ymd').substr(implode(NULL, array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), 0, 8);
}

//判断是否选中目录
function checkstrMenu($needle,$str){

    //判断是否包含a这个字符
    $tmparray = explode($needle,$str);
    if(count($tmparray)>1){
    	return true;
    } else{
    	return false;
    }
}

//替代*号
function half_replace($str){
    $len = strlen($str)/2;
    return substr_replace($str,str_repeat('*',$len),ceil(($len)/2),$len);
}

 //返回今天星期几
function weekname($time){

	$weekarray=array("日","一","二","三","四","五","六");
	return "星期".$weekarray[$time];
}

function DateAdd($part, $number, $date){
	$date_array = getdate(strtotime($date));
	$hor = $date_array["hours"];
	$min = $date_array["minutes"];
	$sec = $date_array["seconds"];
	$mon = $date_array["mon"];
	$day = $date_array["mday"];
	$yar = $date_array["year"];
	switch($part){
		case "y": $yar += $number; break;
		case "q": $mon += ($number * 3); break;
		case "m": $mon += $number; break;
		case "w": $day += ($number * 7); break;
		case "d": $day += $number; break;
		case "h": $hor += $number; break;
		case "n": $min += $number; break;
		case "s": $sec += $number; break;
	}
	return date("Y-m-d H:i:s", mktime($hor, $min, $sec, $mon, $day, $yar));
}
   
//提现状态
function dealstatus($key){

	if($key == 0) return '未处理';
	if($key == 1) return '已处理';
	if($key == 2) return '取消提现';
}

 //时间
function toData($dataNori){

	return date('Y-m-d H:i:s',$dataNori);
}

//隐藏邮箱
function hideEmail($mailname){
	 
	$info = explode('@', $mailname); 
	$mailname = substr_replace($info[0],'***',2,3);
    return $mailname.'@'.$info[1];
}


//函数作用：检测提交的值是不是含有SQL注射的字符，防止注射
//参　　数：$sql_str: 提交的变量 
//返 回 值：返回检测结果，ture or false 
function inject_check($sql_str) {  

	//普通注册
	if(!preg_match("/^[a-zA-Z0-9]{6,32}+$/",$sql_str))
	{
		return false;
	}else{
		return true;
	}
} 

function mymd5($string,$action="EN")
{
	return $string;
// global $webdb,$onlineip;
// $secret_string = $webdb[mymd5].'5*j,.^&;?.%#@!';
// if($string=="") return "";
// if($action=="EN") $md5code=substr(md5($string),8,10);
// else
// {
// $md5code=substr($string,-10);
// $string=substr($string,0,strlen($string)-10);
// }
// $key = md5($md5code.$secret_string);
// $string = ($action=="EN"?$string:base64_decode($string));
// $len = strlen($key);
// $code = "";
// for($i=0;$i<strlen($string);$i++)
// {
// $k = $i%$len;
// $code .= $string[$i]^$key[$k];
// }
// $code = ($action == "DE"?(substr(md5($code),8,10)==$md5code?$code:NULL) : base64_encode($code)."$md5code");
// return $code;
}
function getip(){
if (getenv("HTTP_CLIENT_IP") &&strcasecmp(getenv("HTTP_CLIENT_IP"),"unknown"))
$ip = getenv("HTTP_CLIENT_IP");
else if (getenv("HTTP_X_FORWARDED_FOR") &&strcasecmp(getenv("HTTP_X_FORWARDED_FOR"),"unknown"))
$ip = getenv("HTTP_X_FORWARDED_FOR");
else if (getenv("REMOTE_ADDR") &&strcasecmp(getenv("REMOTE_ADDR"),"unknown"))
$ip = getenv("REMOTE_ADDR");
else if (isset($_SERVER['REMOTE_ADDR']) &&$_SERVER['REMOTE_ADDR'] &&strcasecmp($_SERVER['REMOTE_ADDR'],"unknown"))
$ip = $_SERVER['REMOTE_ADDR'];
else
$ip = "unknown";
return($ip);
}
function m_str($string,$sublen,$start = 0,$code = 'UTF-8'){
if($code == 'UTF-8'){
$pa = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/";
preg_match_all($pa,$string,$t_string);
if(count($t_string[0]) -$start >$sublen) return join('',array_slice($t_string[0],$start,$sublen))."...";
return join('',array_slice($t_string[0],$start,$sublen));
}else {
$start = $start*2;
$sublen = $sublen*2;
$strlen = strlen($string);
$tmpstr = '';
for($i=0;$i<$strlen;$i++){
if($i>=$start &&$i<($start+$sublen)) {
if(ord(substr($string,$i,1))>129){
$tmpstr.= substr($string,$i,2);
}else {
$tmpstr.= substr($string,$i,1);
}
}
if(ord(substr($string,$i,1))>129) $i++;
}
if(strlen($tmpstr)<$strlen ) $tmpstr.= "...";
return $tmpstr;
}
}

?>