<?php

/***********************************************************
 * [大米CMS] (C)2011 - 2011 damicms.com
 *
 * @function 系统RBAC认证
 *
 * @Filename CommonAction.class.php $
 *
 * @Author 追影 QQ:279197963 $
 *
 * @Date 2011-11-17 14:57:09 $
 *************************************************************/
class CommonAction extends Action
{
    function _initialize()
    {
        header("Content-type: text/html; charset=utf-8");
//模拟关闭magic_quotes_gpc 不关闭有时视频用不起
        if (get_magic_quotes_gpc()) {
            $_GET = stripslashesRecursive($_GET);
            $_POST = stripslashesRecursive($_POST);
            $_COOKIE = stripslashesRecursive($_COOKIE);
        }
        import('ORG.Util.Cookie');
//先检查cookie
        if (!Cookie::is_set($_SESSION['cookietime'])) {
            redirect(PHP_FILE . C('USER_AUTH_GATEWAY'));
        } else {
            //保存cookie信息
            Cookie::set($_SESSION['cookietime'], '1', 60 * 60 * 3);
        }

        // 用户权限检查
        if (C('USER_AUTH_ON') && !in_array(MODULE_NAME, explode(',', C('NOT_AUTH_MODULE')))) {
            import('ORG.Util.RBAC');
            if (!RBAC::AccessDecision()) {
                //检查认证识别号
                if (!$_SESSION [C('USER_AUTH_KEY')]) {
                    //跳转到认证网关
                    redirect(PHP_FILE . C('USER_AUTH_GATEWAY'));
                }
                // 没有权限 抛出错误
                if (C('RBAC_ERROR_PAGE')) {
                    // 定义权限错误页面
                    redirect(C('RBAC_ERROR_PAGE'));
                } else {
                    if (C('GUEST_AUTH_ON')) {
                        $this->assign('jumpUrl', PHP_FILE . C('USER_AUTH_GATEWAY'));
                    }
                    // 提示错误信息
                    $this->error(L('_VALID_ACCESS_'));
                }
            }else{
                //记录后台访问操作
                if(!in_array(MODULE_NAME,array('Public','Article','Admin','Type'))){
                $model_info = M('node')->where("level=2 and name='".MODULE_NAME."'")->find();
                $last_log = M('log')->where("username='".$_SESSION['username']."'")->order('addtime desc')->find();
                if($model_info['id']){
                    $action_info = M('node')->where("level=3 and name='".ACTION_NAME."' and pid=".$model_info[id])->find();
                    if($action_info && $last_log['operate'] != '操作'.$action_info['title']){
                        $this->_log_operation('操作'.$action_info['title']);
                    }else if($last_log['operate'] != '操作'.$model_info['title']){
                        $this->_log_operation('操作'.$model_info['title']);
                    }
                }
                }
            }
        }
    }

    function _log_operation($log, $result = '成功')
    {
        if (!isset($_SESSION[C('USER_AUTH_KEY')])) {
            $username = '游客';
            $usergroup = '';
        } else {
            if(isset($_SESSION['admin_username']) && isset($_SESSION['admin_group'])){
                $username = $_SESSION['admin_username'] ;
                $usergroup =  $_SESSION['admin_group'];
            }else{
            $sql = 'SELECT role_admin.role_id,role.`name` as groupname,admin.username FROM ' . C('RBAC_USER_TABLE') . ' as role_admin LEFT JOIN ' . C('DB_PREFIX') . 'admin  as admin ON role_admin.user_id = admin.id left JOIN ' . C('RBAC_ROLE_TABLE') . ' as role ON  role.id = role_admin.role_id WHERE admin.id = ' . $_SESSION[C('USER_AUTH_KEY')] . ' and role.`status` = 1';
            //echo $sql;
                $rs =   M()->query($sql);
            if($rs) {
                $usergroup  = $rs[0]['groupname'];
                $_SESSION['admin_group'] = $rs[0]['groupname'];
                $username = $rs[0]['username'];
                $_SESSION['admin_username'] = $rs[0]['username'];
            }
            }

        }
        $ip = get_client_ip();
        $data = array();
        $data['username'] = $username;
        $data['usergroup'] = $usergroup;
        $data['operate'] = $log;
        $data['result'] = $result;
        $data['ip'] = $ip;
        $data['addtime'] = time();
        M('log')->add($data);
        unset($data);
    }
}

?>