/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : test

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2017-12-09 14:58:36
*/

SET AUTOCOMMIT=0;
SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for ebcms5_app
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_app`;
CREATE TABLE `ebcms5_app` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `app_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '应用ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `version` varchar(255) NOT NULL DEFAULT '' COMMENT '版本',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='已经安装的APP表';

-- ----------------------------
-- Records of ebcms5_app
-- ----------------------------
INSERT INTO `ebcms5_app` VALUES ('1', '1', '核心', 'ebcms', '1.8.6', '1479890844', '1475398105', '1');
INSERT INTO `ebcms5_app` VALUES ('2', '4', '内容管理系统', 'content', '1.1.4', '1499653848', '1499653848', '1');
INSERT INTO `ebcms5_app` VALUES ('3', '5', '模板助手', 'mbzs', '1.1.1', '1499653880', '1499653880', '1');
INSERT INTO `ebcms5_app` VALUES ('4', '6', '友情链接', 'link', '1.1.0', '1499653903', '1499653903', '1');
INSERT INTO `ebcms5_app` VALUES ('8', '8', '论坛', 'forum', '1.1.4', '1499659841', '1499659841', '1');
INSERT INTO `ebcms5_app` VALUES ('9', '16', '访问统计', 'tongji', '1.0.1', '1499918530', '1499918530', '1');
INSERT INTO `ebcms5_app` VALUES ('10', '12', '会员中心', 'user', '2.0.3', '1500370209', '1500370209', '1');
INSERT INTO `ebcms5_app` VALUES ('11', '13', '超级支付', 'superpay', '1.0.0', '1501421488', '1501421488', '1');

-- ----------------------------
-- Table structure for ebcms5_auth_access
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_access`;
CREATE TABLE `ebcms5_auth_access` (
  `uid` mediumint(8) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色权限表';

-- ----------------------------
-- Records of ebcms5_auth_access
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_group`;
CREATE TABLE `ebcms5_auth_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` char(100) NOT NULL DEFAULT '',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `rules` text COMMENT '规则',
  `c_rules` text COMMENT '栏目权限规则',
  `menus` text COMMENT '菜单权限',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of ebcms5_auth_group
-- ----------------------------
INSERT INTO `ebcms5_auth_group` VALUES ('1', '系统', '管理员', '', '1', '', '', '', '5');
INSERT INTO `ebcms5_auth_group` VALUES ('2', '系统', '工程师', '', '1', '', '', '', '4');
INSERT INTO `ebcms5_auth_group` VALUES ('3', '系统', '编辑', '', '1', '', '', '', '3');
INSERT INTO `ebcms5_auth_group` VALUES ('4', '系统', '客服', '', '1', '', '', '', '2');

-- ----------------------------
-- Table structure for ebcms5_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_rule`;
CREATE TABLE `ebcms5_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明',
  `name` char(80) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `condition` char(100) NOT NULL DEFAULT '',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  `opstr` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6714 DEFAULT CHARSET=utf8 COMMENT='权限规则表';

-- ----------------------------
-- Records of ebcms5_auth_rule
-- ----------------------------
INSERT INTO `ebcms5_auth_rule` VALUES ('1', '0', '后台', 'ebcms_api_index', '1', '', '10', 'ebcms', '后台');
INSERT INTO `ebcms5_auth_rule` VALUES ('2', '1', '配置管理', 'ebcms_config_index', '1', '', '0', 'ebcms', '配置管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('3', '2', '设置', 'ebcms_config_setting', '1', '', '0', 'ebcms', '系统设置');
INSERT INTO `ebcms5_auth_rule` VALUES ('34', '1', '扩展管理', 'ebcms_extend_index', '1', '', '0', 'ebcms', '扩展管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('35', '34', '添加', 'ebcms_extend_add', '1', '', '0', 'ebcms', '添加扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('36', '34', '修改', 'ebcms_extend_edit', '1', '', '0', 'ebcms', '修改扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('37', '34', '删除', 'ebcms_extend_delete', '1', '', '0', 'ebcms', '删除扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('40', '34', '排序', 'ebcms_extend_resort', '1', '', '0', 'ebcms', '排序扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('41', '1', '扩展字段管理', 'ebcms_extendfield_index', '1', '', '0', 'ebcms', '扩展字段管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('42', '41', '添加', 'ebcms_extendfield_add', '1', '', '0', 'ebcms', '添加扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('43', '41', '编辑', 'ebcms_extendfield_edit', '1', '', '0', 'ebcms', '修改扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('44', '41', '删除', 'ebcms_extendfield_delete', '1', '', '0', 'ebcms', '删除扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('45', '41', '变更状态', 'ebcms_extendfield_status', '1', '', '0', 'ebcms', '变更扩展字段状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('47', '41', '排序', 'ebcms_extendfield_resort', '1', '', '0', 'ebcms', '排序扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('48', '1', '后台首页', 'ebcms_index_index', '1', '', '0', 'ebcms', '后台首页');
INSERT INTO `ebcms5_auth_rule` VALUES ('49', '48', '主页', 'ebcms_index_main', '1', '', '0', 'ebcms', '主页');
INSERT INTO `ebcms5_auth_rule` VALUES ('50', '48', '删除缓存', 'ebcms_index_runtime', '1', '', '0', 'ebcms', '删除缓存');
INSERT INTO `ebcms5_auth_rule` VALUES ('51', '48', '修改自己的密码', 'ebcms_index_password', '1', '', '0', 'ebcms', '修改自己的密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('52', '48', '附件上传', 'ebcms_index_upload', '1', '', '0', 'ebcms', '附件上传');
INSERT INTO `ebcms5_auth_rule` VALUES ('53', '48', '编辑器附件上传', 'ebcms_index_ueditor', '1', '', '0', 'ebcms', '编辑器附件上传');
INSERT INTO `ebcms5_auth_rule` VALUES ('58', '1', '角色管理', 'ebcms_group_index', '1', '', '0', 'ebcms', '角色管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('59', '58', '添加', 'ebcms_group_add', '1', '', '0', 'ebcms', '添加角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('60', '58', '编辑', 'ebcms_group_edit', '1', '', '0', 'ebcms', '修改角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('61', '58', '删除', 'ebcms_group_delete', '1', '', '0', 'ebcms', '删除角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('62', '58', '分配权限', 'ebcms_group_rule', '1', '', '0', 'ebcms', '对角色分配权限');
INSERT INTO `ebcms5_auth_rule` VALUES ('63', '58', '分配菜单', 'ebcms_group_menu', '1', '', '0', 'ebcms', '对角色分配菜单权限');
INSERT INTO `ebcms5_auth_rule` VALUES ('64', '58', '变更状态', 'ebcms_group_status', '1', '', '0', 'ebcms', '审核角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('66', '58', '排序', 'ebcms_group_resort', '1', '', '0', 'ebcms', '对角色排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('72', '1318', '分配角色', 'ebcms_manager_group', '1', '', '0', 'ebcms', '给后台账户分配角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('77', '1', '操作日志管理', 'ebcms_oplog_index', '1', '', '0', 'ebcms', '操作日志管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('78', '77', '删除', 'ebcms_oplog_delete', '1', '', '0', 'ebcms', '删除操作日志');
INSERT INTO `ebcms5_auth_rule` VALUES ('79', '77', '查看详情', 'ebcms_oplog_show', '1', '', '0', 'ebcms', '查看操作日志');
INSERT INTO `ebcms5_auth_rule` VALUES ('862', '1', '导航管理', 'ebcms_nav_index', '1', '', '0', 'ebcms', '导航管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('863', '862', '添加', 'ebcms_nav_add', '1', '', '0', 'ebcms', '添加导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('864', '862', '编辑', 'ebcms_nav_edit', '1', '', '0', 'ebcms', '编辑导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('865', '862', '审核', 'ebcms_nav_status', '1', '', '0', 'ebcms', '审核导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('867', '862', '删除', 'ebcms_nav_delete', '1', '', '0', 'ebcms', '删除导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('1318', '1', '账户管理', 'ebcms_manager_index', '1', '', '3', 'ebcms', '账户管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('1319', '1318', '查看信息', 'ebcms_manager_info', '1', '', '0', 'ebcms', '查看后台账户信息');
INSERT INTO `ebcms5_auth_rule` VALUES ('1320', '1318', '添加', 'ebcms_manager_add', '1', '', '0', 'ebcms', '添加后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1321', '1318', '编辑', 'ebcms_manager_edit', '1', '', '0', 'ebcms', '编辑后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1322', '1318', '删除', 'ebcms_manager_delete', '1', '', '0', 'ebcms', '删除后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1323', '1318', '重置密码', 'ebcms_manager_password', '1', '', '0', 'ebcms', '重置后台账户密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('1324', '1318', '变更状态', 'ebcms_manager_status', '1', '', '0', 'ebcms', '变更后台账户状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('3636', '48', '发邮件', 'ebcms_index_email', '1', '', '0', 'ebcms', '发邮件');
INSERT INTO `ebcms5_auth_rule` VALUES ('6365', '862', '排序', 'ebcms_nav_resort', '1', '', '0', 'ebcms', '导航排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6595', '0', '内容管理系统', 'content', '1', '', '200', 'content', '内容管理系统');
INSERT INTO `ebcms5_auth_rule` VALUES ('6596', '6595', '内容管理', 'content_admin.content_index', '1', '', '0', 'content', '内容管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6597', '6596', '添加', 'content_admin.content_add', '1', '', '9', 'content', '添加内容');
INSERT INTO `ebcms5_auth_rule` VALUES ('6598', '6596', '编辑', 'content_admin.content_edit', '1', '', '8', 'content', '编辑内容');
INSERT INTO `ebcms5_auth_rule` VALUES ('6599', '6596', '批量移动', 'content_admin.content_move', '1', '', '0', 'content', '批量移动');
INSERT INTO `ebcms5_auth_rule` VALUES ('6600', '6596', '更改样式', 'content_admin.content_style', '1', '', '0', 'content', '更改样式');
INSERT INTO `ebcms5_auth_rule` VALUES ('6601', '6596', '删除', 'content_admin.content_delete', '1', '', '0', 'content', '内容删除');
INSERT INTO `ebcms5_auth_rule` VALUES ('6602', '6596', '设置属性', 'content_admin.content_attr', '1', '', '0', 'content', '设置内容属性');
INSERT INTO `ebcms5_auth_rule` VALUES ('6603', '6596', '变更状态', 'content_admin.content_status', '1', '', '0', 'content', '变更内容状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6604', '6595', '栏目管理', 'content_admin.channel_index', '1', '', '0', 'content', '栏目管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6605', '6604', '添加', 'content_admin.channel_add', '1', '', '9', 'content', '添加栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6606', '6604', '编辑', 'content_admin.channel_edit', '1', '', '0', 'content', '编辑栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6607', '6604', '栏目合并', 'content_admin.channel_merge', '1', '', '0', 'content', '合并栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6608', '6604', '删除', 'content_admin.channel_delete', '1', '', '0', 'content', '删除栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6609', '6604', '排序', 'content_admin.channel_resort', '1', '', '0', 'content', '栏目排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6610', '6604', '变更状态', 'content_admin.channel_status', '1', '', '0', 'content', '变更栏目状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6611', '6595', '标签管理', 'content_admin.tag_index', '1', '', '0', 'content', '标签管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6612', '6611', '删除', 'content_admin.tag_delete', '1', '', '0', 'content', '删除内容标签');
INSERT INTO `ebcms5_auth_rule` VALUES ('6613', '6611', '编辑', 'content_admin.tag_edit', '1', '', '0', 'content', '编辑内容标签');
INSERT INTO `ebcms5_auth_rule` VALUES ('6614', '6611', '推荐', 'content_admin.tag_recommend', '1', '', '0', 'content', '对内容标签执行推荐操作');
INSERT INTO `ebcms5_auth_rule` VALUES ('6615', '6611', '修改样式', 'content_admin.tag_style', '1', '', '0', 'content', '修改内容标签样式');
INSERT INTO `ebcms5_auth_rule` VALUES ('6616', '6611', '合并', 'content_admin.tag_merge', '1', '', '0', 'content', '合并内容标签');
INSERT INTO `ebcms5_auth_rule` VALUES ('6617', '6595', '属性管理', 'content_admin.attr_index', '1', '', '0', 'content', '属性管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6618', '6617', '内容移除', 'content_admin.attr_remove', '1', '', '0', 'content', '内容移除');
INSERT INTO `ebcms5_auth_rule` VALUES ('6619', '6617', '内容排序', 'content_admin.attr_resort', '1', '', '0', 'content', '内容排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6620', '0', '模板助手', 'mbzs', '1', '', '200', 'mbzs', '模板助手');
INSERT INTO `ebcms5_auth_rule` VALUES ('6621', '6620', '模板助手管理', 'mbzs_mbzs_index', '1', '', '0', 'mbzs', '模板助手管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6622', '6621', '变更状态', 'mbzs_mbzs_status', '1', '', '0', 'mbzs', '变更模板变量状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6623', '6621', '编辑', 'mbzs_mbzs_edit', '1', '', '0', 'mbzs', '编辑模板变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6624', '6621', '添加', 'mbzs_mbzs_add', '1', '', '0', 'mbzs', '添加模板助手变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6625', '6621', '删除', 'mbzs_mbzs_delete', '1', '', '0', 'mbzs', '删除模板助手变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6626', '6621', '排序', 'mbzs_mbzs_resort', '1', '', '0', 'mbzs', '模板助手变量排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6627', '0', '友情链接', 'link', '1', '', '40', 'link', '友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6628', '6627', '友情链接管理', 'link_admin.link_index', '1', '', '0', 'link', '友情链接管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6629', '6628', '删除', 'link_admin.link_delete', '1', '', '0', 'link', '删除友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6630', '6628', '编辑', 'link_admin.link_edit', '1', '', '0', 'link', '编辑友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6631', '6628', '添加', 'link_admin.link_add', '1', '', '0', 'link', '添加友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6632', '6628', '审核', 'link_admin.link_status', '1', '', '0', 'link', '审核友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6633', '6628', '排序', 'link_admin.link_resort', '1', '', '0', 'link', '友情链接排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6664', '0', '简易论坛', 'forum', '1', '', '100', 'forum', '简易论坛');
INSERT INTO `ebcms5_auth_rule` VALUES ('6665', '6664', '板块管理', 'forum_admin.forum_index', '1', '', '9', 'forum', '板块管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6666', '6665', '删除', 'forum_admin.forum_delete', '1', '', '0', 'forum', '删除板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6667', '6665', '排序', 'forum_admin.forum_resort', '1', '', '0', 'forum', '板块排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6668', '6665', '审核', 'forum_admin.forum_status', '1', '', '0', 'forum', '审核板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6669', '6665', '编辑', 'forum_admin.forum_edit', '1', '', '0', 'forum', '编辑板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6670', '6665', '删除版主', 'forum_admin.forum_delete_moderator', '1', '', '0', 'forum', '删除版主');
INSERT INTO `ebcms5_auth_rule` VALUES ('6671', '6665', '编辑版主', 'forum_admin.forum_edit_moderator', '1', '', '0', 'forum', '编辑版主');
INSERT INTO `ebcms5_auth_rule` VALUES ('6672', '6665', '添加版主', 'forum_admin.forum_add_moderator', '1', '', '0', 'forum', '添加版主');
INSERT INTO `ebcms5_auth_rule` VALUES ('6673', '6665', '添加', 'forum_admin.forum_add', '1', '', '0', 'forum', '添加板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6674', '6665', '开关论坛', 'forum_admin.forum_open', '1', '', '0', 'forum', '开关板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6675', '6665', '合并', 'forum_admin.forum_merge', '1', '', '0', 'forum', '合并板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6676', '6665', '权限设置', 'forum_admin.forum_auth', '1', '', '0', 'forum', '板块权限设置');
INSERT INTO `ebcms5_auth_rule` VALUES ('6677', '0', '统计', 'tongji', '1', '', '3000', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6678', '6677', '统计', 'tongji_index', '1', '', '0', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6679', '6678', '查看浏览记录', 'tongji_index_index', '1', '', '0', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6680', '6678', '查看页面统计', 'tongji_index_tj', '1', '', '0', 'tongji', '查看页面统计');
INSERT INTO `ebcms5_auth_rule` VALUES ('6681', '6678', '删除统计数据', 'tongji_index_delete', '1', '', '0', 'tongji', '删除统计数据');
INSERT INTO `ebcms5_auth_rule` VALUES ('6698', '0', '用户模块', 'user', '1', '', '20', 'user', '用户模块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6699', '6698', '用户管理', 'user_admin.user_index', '1', '', '2', 'user', '用户管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6700', '6699', '添加', 'user_admin.user_add', '1', '', '9', 'user', '添加会员');
INSERT INTO `ebcms5_auth_rule` VALUES ('6701', '6699', '编辑', 'user_admin.user_edit', '1', '', '8', 'user', '编辑会员信息');
INSERT INTO `ebcms5_auth_rule` VALUES ('6702', '6699', '变更财务', 'user_admin.user_currency', '1', '', '0', 'user', '变更会员财务');
INSERT INTO `ebcms5_auth_rule` VALUES ('6703', '6699', '发送消息', 'user_admin.user_msg', '1', '', '0', 'user', '向会员发送消息');
INSERT INTO `ebcms5_auth_rule` VALUES ('6704', '6699', '变更状态', 'user_admin.user_status', '1', '', '0', 'user', '变更会员状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6705', '6699', '删除', 'user_admin.user_delete', '1', '', '0', 'user', '删除会员');
INSERT INTO `ebcms5_auth_rule` VALUES ('6706', '6699', '重置密码', 'user_admin.user_password', '1', '', '0', 'user', '重置会员密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('6707', '6699', '查看详情', 'user_admin.user_info', '1', '', '0', 'user', '查看会员信息');
INSERT INTO `ebcms5_auth_rule` VALUES ('6708', '6698', '评论管理', 'user_admin.comment_index', '1', '', '1', 'user', '评论管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6709', '6708', '审核', 'user_admin.comment_status', '1', '', '0', 'user', '变更评论状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6710', '6708', '编辑', 'user_admin.comment_edit', '1', '', '0', 'user', '编辑评论');
INSERT INTO `ebcms5_auth_rule` VALUES ('6711', '6708', '删除', 'user_admin.comment_delete', '1', '', '0', 'user', '删除评论');
INSERT INTO `ebcms5_auth_rule` VALUES ('6712', '6698', '流水管理', 'user_admin.currencylog_index', '1', '', '0', 'user', '流水管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6713', '6712', '删除', 'user_admin.currencylog_delete', '1', '', '0', 'user', '删除流水');

-- ----------------------------
-- Table structure for ebcms5_config
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_config`;
CREATE TABLE `ebcms5_config` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `render` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `form` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '类型配置',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许用户配置',
  `remark` text COMMENT '说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1514 DEFAULT CHARSET=utf8 COMMENT='核心配置表';

-- ----------------------------
-- Records of ebcms5_config
-- ----------------------------
INSERT INTO `ebcms5_config` VALUES ('5', '系统配置@base', '1', '操作权限认证', 'auth_type', '1', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5b9e\\u65f6\\u8ba4\\u8bc1|1\\r\\n\\u767b\\u5f55\\u8ba4\\u8bc1|2\"}', '1', '实时认证更安全，登陆认证更高效', '80');
INSERT INTO `ebcms5_config` VALUES ('10', '邮箱配置@email', '1', '邮箱密码', 'password', 'zzeddixysnsnbhai', 'string', 'form_textbox', '', '1', '', '7');
INSERT INTO `ebcms5_config` VALUES ('11', '系统配置@base', '1', '操作日志记录', 'oplog_on', '1', 'bool', 'form_bool', '', '1', '', '1');
INSERT INTO `ebcms5_config` VALUES ('12', '邮箱配置@email', '1', '邮箱账号', 'name', 'market@ebcms.com', 'string', 'form_textbox', '', '1', '', '8');
INSERT INTO `ebcms5_config` VALUES ('13', '邮箱配置@email', '1', '发送者地址', 'from', 'market@ebcms.com', 'string', 'form_textbox', '', '1', '', '5');
INSERT INTO `ebcms5_config` VALUES ('14', '邮箱配置@email', '1', '发送者名称', 'fromname', '易贝科技', 'string', 'form_textbox', '', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('15', '邮箱配置@email', '1', '服务器', 'host', 'smtp.qq.com', 'string', 'form_textbox', '', '1', '', '60');
INSERT INTO `ebcms5_config` VALUES ('16', '邮箱配置@email', '1', '端口', 'port', '25', 'string', 'form_textbox', '', '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('17', '邮箱配置@email', '1', 'SMTP验证', 'smtpauth', '1', 'bool', 'form_bool', '', '1', '', '4');
INSERT INTO `ebcms5_config` VALUES ('18', '邮箱配置@email', '1', '允许HTML', 'html', '1', 'bool', 'form_bool', '', '1', '', '3');
INSERT INTO `ebcms5_config` VALUES ('19', '系统配置@base', '1', '备份目录', 'backup_path', './backup', 'string', 'form_textbox', '', '1', '相对于入口文件 index.php 的目录，备份目录请设置为可读可写！', '1');
INSERT INTO `ebcms5_config` VALUES ('23', '编辑器@ueditor', '1', '编辑器配置', 'config', '{\r\n&quot;iframeCssUrl&quot;:&quot;/third/bootstrap/css/bootstrap.min.css&quot;,\r\n&quot;initialStyle&quot;:&quot;body{margin:15px;}&quot;\r\n}', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"5\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '1', '请参考百度编辑器的配置文档 ueditor.config.js', '50');
INSERT INTO `ebcms5_config` VALUES ('24', '编辑器@ueditor', '1', '编辑器上传配置', 'upload', '', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"10\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '1', '参考百度编辑器的配置文件：config.json', '9');
INSERT INTO `ebcms5_config` VALUES ('25', 'SEO配置@seo', '2', '网站名称', 'sitename', '易贝内容管理系统', 'string', 'form_textbox', '', '1', '定义浏览器顶部标签显示的文字。对SEO友好。\r\n首页：网站名称 + 网站标题\r\n其他页面：页面标题 + 网站名称', '90');
INSERT INTO `ebcms5_config` VALUES ('26', 'SEO配置@seo', '2', '网站标题', 'title', '易贝内容管理系统|免费的内容管理系统|EBCMS|phpcms', 'string', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '1', '定义浏览器顶部标签显示的文字。对SEO友好。\r\n首页：网站名称 + 网站标题\r\n其他页面：页面标题 + 网站名称', '8');
INSERT INTO `ebcms5_config` VALUES ('27', 'SEO配置@seo', '2', '关键字', 'keywords', '易贝内容管理系统 内容管理系统 cms ebcms 开源cms', 'string', 'form_textbox', '', '1', '用空格或英文的逗号 , 分割。', '7');
INSERT INTO `ebcms5_config` VALUES ('28', 'SEO配置@seo', '2', '网站简介', 'description', '易贝内容管理系统是一套自由的功能灵活的开源的内容管理系统。', 'string', 'form_multitextbox', '', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1199', '基本配置@site', '2', '关闭网站', 'closed', '0', 'bool', 'form_bool', null, '1', '', '100');
INSERT INTO `ebcms5_config` VALUES ('1200', '基本配置@site', '2', '关闭原因', 'closed_reason', '系统维护中。。。', 'string', 'form_textbox', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1203', '验证码@captcha', '2', '加密密钥', 'seKey', 'http://www.ebcms.com', 'string', 'form_textbox', null, '0', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1204', '验证码@captcha', '2', '字符', 'codeSet', '2345678abcdefhijkmnpqrstuvwxyzABCDEFGHJKLMNPQRTUVWXY', 'string', 'form_textbox', null, '1', '2345678abcdefhijkmnpqrstuvwxyzABCDEFGHJKLMNPQRTUVWXY', '28');
INSERT INTO `ebcms5_config` VALUES ('1205', '验证码@captcha', '2', '有效期', 'expire', '18000', 'number', 'form_numberbox', null, '0', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1206', '验证码@captcha', '2', '是否使用中文', 'useZh', '0', 'bool', 'form_bool', null, '1', '', '26');
INSERT INTO `ebcms5_config` VALUES ('1207', '验证码@captcha', '2', '中文字符', 'zhSet', '们以我到他会作时要动国产的一是工就年阶义发成部民可出能方进在了不和有大这主中人上为来分生对于学下级地个用同行面说种过命度革而多子后自社加小机也经力线本电高量长党得实家定深法表着水理化争现所二起政三好十战无农使性前等反体合斗路图把结第里正新开论之物从当两些还天资事队批点育重其思与间内去因件日利相由压员气业代全组数果期导平各基或月毛然如应形想制心样干都向变关问比展那它最及外没看治提五解系林者米群头意只明四道马认次文通但条较克又公孔领军流入接席位情运器并飞原油放立题质指建区验活众很教决特此常石强极土少已根共直团统式转别造切九你取西持总料连任志观调七么山程百报更见必真保热委手改管处己将修支识病象几先老光专什六型具示复安带每东增则完风回南广劳轮科北打积车计给节做务被整联步类集号列温装即毫知轴研单色坚据速防史拉世设达尔场织历花受求传口断况采精金界品判参层止边清至万确究书术状厂须离再目海交权且儿青才证低越际八试规斯近注办布门铁需走议县兵固除般引齿千胜细影济白格效置推空配刀叶率述今选养德话查差半敌始片施响收华觉备名红续均药标记难存测士身紧液派准斤角降维板许破述技消底床田势端感往神便贺村构照容非搞亚磨族火段算适讲按值美态黄易彪服早班麦削信排台声该击素张密害侯草何树肥继右属市严径螺检左页抗苏显苦英快称坏移约巴材省黑武培著河帝仅针怎植京助升王眼她抓含苗副杂普谈围食射源例致酸旧却充足短划剂宣环落首尺波承粉践府鱼随考刻靠够满夫失包住促枝局菌杆周护岩师举曲春元超负砂封换太模贫减阳扬江析亩木言球朝医校古呢稻宋听唯输滑站另卫字鼓刚写刘微略范供阿块某功套友限项余倒卷创律雨让骨远帮初皮播优占死毒圈伟季训控激找叫云互跟裂粮粒母练塞钢顶策双留误础吸阻故寸盾晚丝女散焊功株亲院冷彻弹错散商视艺灭版烈零室轻血倍缺厘泵察绝富城冲喷壤简否柱李望盘磁雄似困巩益洲脱投送奴侧润盖挥距触星松送获兴独官混纪依未突架宽冬章湿偏纹吃执阀矿寨责熟稳夺硬价努翻奇甲预职评读背协损棉侵灰虽矛厚罗泥辟告卵箱掌氧恩爱停曾溶营终纲孟钱待尽俄缩沙退陈讨奋械载胞幼哪剥迫旋征槽倒握担仍呀鲜吧卡粗介钻逐弱脚怕盐末阴丰雾冠丙街莱贝辐肠付吉渗瑞惊顿挤秒悬姆烂森糖圣凹陶词迟蚕亿矩康遵牧遭幅园腔订香肉弟屋敏恢忘编印蜂急拿扩伤飞露核缘游振操央伍域甚迅辉异序免纸夜乡久隶缸夹念兰映沟乙吗儒杀汽磷艰晶插埃燃欢铁补咱芽永瓦倾阵碳演威附牙芽永瓦斜灌欧献顺猪洋腐请透司危括脉宜笑若尾束壮暴企菜穗楚汉愈绿拖牛份染既秋遍锻玉夏疗尖殖井费州访吹荣铜沿替滚客召旱悟刺脑措贯藏敢令隙炉壳硫煤迎铸粘探临薄旬善福纵择礼愿伏残雷延烟句纯渐耕跑泽慢栽鲁赤繁境潮横掉锥希池败船假亮谓托伙哲怀割摆贡呈劲财仪沉炼麻罪祖息车穿货销齐鼠抽画饲龙库守筑房歌寒喜哥洗蚀废纳腹乎录镜妇恶脂庄擦险赞钟摇典柄辩竹谷卖乱虚桥奥伯赶垂途额壁网截野遗静谋弄挂课镇妄盛耐援扎虑键归符庆聚绕摩忙舞遇索顾胶羊湖钉仁音迹碎伸灯避泛亡答勇频皇柳哈揭甘诺概宪浓岛袭谁洪谢炮浇斑讯懂灵蛋闭孩释乳巨徒私银伊景坦累匀霉杜乐勒隔弯绩招绍胡呼痛峰零柴簧午跳居尚丁秦稍追梁折耗碱殊岗挖氏刃剧堆赫荷胸衡勤膜篇登驻案刊秧缓凸役剪川雪链渔啦脸户洛孢勃盟买杨宗焦赛旗滤硅炭股坐蒸凝竟陷枪黎救冒暗洞犯筒您宋弧爆谬涂味津臂障褐陆啊健尊豆拔莫抵桑坡缝警挑污冰柬嘴啥饭塑寄赵喊垫丹渡耳刨虎笔稀昆浪萨茶滴浅拥穴覆伦娘吨浸袖珠雌妈紫戏塔锤震岁貌洁剖牢锋疑霸闪埔猛诉刷狠忽灾闹乔唐漏闻沈熔氯荒茎男凡抢像浆旁玻亦忠唱蒙予纷捕锁尤乘乌智淡允叛畜俘摸锈扫毕璃宝芯爷鉴秘净蒋钙肩腾枯抛轨堂拌爸循诱祝励肯酒绳穷塘燥泡袋朗喂铝软渠颗惯贸粪综墙趋彼届墨碍启逆卸航衣孙龄岭骗休借', 'string', 'form_multitextbox', null, '1', '', '24');
INSERT INTO `ebcms5_config` VALUES ('1208', '验证码@captcha', '2', '背景混淆', 'useImgBg', '1', 'bool', 'form_bool', null, '1', '', '18');
INSERT INTO `ebcms5_config` VALUES ('1209', '验证码@captcha', '2', '字体大小', 'fontSize', '25', 'number', 'form_numberbox', null, '0', '', '16');
INSERT INTO `ebcms5_config` VALUES ('1210', '验证码@captcha', '2', '曲线混淆', 'useCurve', '1', 'bool', 'form_bool', null, '1', '', '22');
INSERT INTO `ebcms5_config` VALUES ('1211', '验证码@captcha', '2', '杂点混淆', 'useNoise', '1', 'bool', 'form_bool', null, '1', '', '20');
INSERT INTO `ebcms5_config` VALUES ('1212', '验证码@captcha', '2', '图片高', 'imageH', '0', 'number', 'form_numberbox', null, '0', '', '14');
INSERT INTO `ebcms5_config` VALUES ('1213', '验证码@captcha', '2', '图片宽', 'imageW', '0', 'number', 'form_numberbox', null, '0', '', '12');
INSERT INTO `ebcms5_config` VALUES ('1214', '验证码@captcha', '2', '字符数', 'length', '4', 'number', 'form_numberbox', null, '1', '', '30');
INSERT INTO `ebcms5_config` VALUES ('1215', '验证码@captcha', '2', '字体', 'fontttf', '', 'string', 'form_textbox', null, '0', '', '10');
INSERT INTO `ebcms5_config` VALUES ('1216', '验证码@captcha', '2', '背景色', 'bg', '243\r\n251\r\n254', 'item', 'form_multitextbox', null, '0', 'rgb色  一行一个。\r\n243\r\n251\r\n254', '8');
INSERT INTO `ebcms5_config` VALUES ('1217', '验证码@captcha', '2', '验证重置', 'reset', '1', 'bool', 'form_bool', null, '0', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1377', '路由配置@route', '2', '路由模式', 'model', '1', 'number', 'form_radio', '{\"values\":\"普通模式|0\\r\\n应用模式|1\"}', '1', '', '50');
INSERT INTO `ebcms5_config` VALUES ('1378', '路由配置@route', '2', '自定义路由', 'rules', '/|index/index/index\r\nuser_reg|user/auth/reg\r\nuser_login|user/auth/login', 'string', 'form_multitextbox', '{\"height\":\"15\",\"width\":\"\",\"prompt\":\"\"}', '1', '非专业人士，请不要随意定义，否则可能导致无法访问！\r\n用竖线分割 一行一个，例如：\r\nuser_reg|user/auth/reg\r\nuser_login|user/auth/login', '0');
INSERT INTO `ebcms5_config` VALUES ('1418', '基本配置@site', '2', '手机版', 'mobile', '0', 'bool', 'form_bool', null, '1', '开启手机版后，手机访问会自动定位到 当前模板主题对应的移动端模板 例如：default_mobile', '7');
INSERT INTO `ebcms5_config` VALUES ('1419', '基本配置@site', '2', '模板主题', 'theme', 'default', 'string', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$path = ROOT_PATH . \'templates\' . DS;\\r\\n\\t$dirs = scandir($path);\\r\\n\\t$res = [];\\r\\n\\t$thumbs = [];\\r\\n\\tforeach($dirs as $k){\\r\\n\\t\\tif(!in_array($k,[\'.\',\'..\']) &amp;&amp; !preg_match(&quot;\\/[\\\\x7f-\\\\xff]\\/&quot;, $k) &amp;&amp; is_dir($path . $k)){\\r\\n\\t\\t\\tif(\'_mobile\' != substr($k,-7)){\\r\\n\\t\\t\\t\\t$res[] = $k;\\r\\n\\t\\t\\t\\t$thumb = $path . $k . DS . \'thumb.png\';\\r\\n\\t\\t\\t\\t$thumb = is_file($thumb)?$thumb:\'.\\/system\\/image\\/nopic.gif\';\\r\\n\\t\\t\\t\\t$img_info = getimagesize($thumb);\\r\\n\\t\\t\\t\\t$thumbs[$k] = \'data:\' . $img_info[\'mime\'] . \';base64,\' . base64_encode(file_get_contents($thumb));\\r\\n\\t\\t\\t}\\r\\n\\t\\t}\\r\\n\\t}\\r\\n{\\/php}\\r\\n&lt;div style=&quot;clear: both;overflow: hidden;&quot;&gt;\\r\\n{foreach name=\'res\' item=\'v\'}\\r\\n\\t&lt;div class=&quot;thumbnail&quot; onclick=&quot;$(this).css(\'border\', \'1px solid red\').siblings().css(\'border\', \'1px solid #ddd\');$(\'#{$field.unique}\').val(\'{$v}\');&quot; style=&quot;width:13em;float:left;cursor: pointer; margin-right:10px;{eq name=&quot;field.value&quot; value=\'$v\'}border:1px solid red;{\\/eq}&quot;&gt;\\r\\n\\t\\t&lt;img src=&quot;{$thumbs[$v]}&quot; alt=&quot;{$v}&quot; style=&quot;width: 100%;height: 10em;&quot;&gt;\\r\\n\\t\\t&lt;div class=&quot;caption&quot;&gt;\\r\\n\\t\\t\\t&lt;h4 class=&quot;text-center&quot;&gt;{$v}&lt;\\/h4&gt;\\r\\n\\t\\t&lt;\\/div&gt;\\r\\n\\t&lt;\\/div&gt;\\r\\n{\\/foreach}\\r\\n&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot; value=&quot;{$field.value}&quot;&gt;\"}', '1', '模板位于templates目录下', '8');
INSERT INTO `ebcms5_config` VALUES ('1420', '常规配置', '3', 'URL模式', 'url_model', '2', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"普通模式|0\\r\\n标准模式|1\\r\\n高级模式|2\"}', '1', '普通模式不走路由，标准模式是常规路由，高级模式支持自定义文件夹和文件名。', '30');
INSERT INTO `ebcms5_config` VALUES ('1421', '常规配置', '3', '是否记录点击', 'click_record', '1', 'bool', 'form_bool', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1422', '常规配置', '3', '内容属性', 'attr', '头条\r\n幻灯\r\n请在设置中心设置默认数据', 'item', 'form_multitextbox', null, '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1423', '友情链接', '4', '开启验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '2');
INSERT INTO `ebcms5_config` VALUES ('1424', '友情链接', '4', '开启在线申请', 'apply', '1', 'bool', 'form_bool', null, '1', '', '1');
INSERT INTO `ebcms5_config` VALUES ('1453', '基本配置', '8', '开启论坛', 'open', '1', 'bool', 'form_bool', null, '1', '特殊时期可关闭，关闭后，不能发帖，不能跟帖，不能评论，只能查看！', '20');
INSERT INTO `ebcms5_config` VALUES ('1454', '基本配置', '8', '游客附件上传', 'guest_upload', '0', 'bool', 'form_bool', null, '1', '通常请不要让游客上传附件。', '19');
INSERT INTO `ebcms5_config` VALUES ('1455', '基本配置', '8', '敏感词处理方式', 'badwords_handle', '1', 'number', 'form_radio', '{\"values\":\"禁止提交|0\\r\\n进入审核|1\\r\\n直接替换|2\\r\\n不用处理|99\"}', '1', '', '10');
INSERT INTO `ebcms5_config` VALUES ('1456', '奖励配置', '8', '发帖奖励', 'thread_add_currency', 'jifen:10', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\njifen:10\njinbi:1', '10');
INSERT INTO `ebcms5_config` VALUES ('1457', '基本配置', '8', '敏感词', 'badwords', '麻痹=***\n共产党=***\n你妈=我妈\n狗日=***\n日你=日我\n傻逼=***我是傻逼***', 'ini', 'form_multitextbox', null, '1', '一行一个，用 = 分割：例如\n你麻痹=***\n共产党=***\n草你妈=草我马', '9');
INSERT INTO `ebcms5_config` VALUES ('1458', '奖励配置', '8', '跟帖奖励', 'rethread_add_currency', 'jifen:1', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\njifen:10\njinbi:1', '8');
INSERT INTO `ebcms5_config` VALUES ('1459', '基本配置', '8', '附件类型', 'upload_ext', 'jpg\r\npng\r\ngif\r\njpeg\r\nzip\r\nrar', 'item', 'form_multitextbox', null, '1', '一行一个，例如：\r\njpg\r\npng\r\ngif', '0');
INSERT INTO `ebcms5_config` VALUES ('1460', '基本配置', '9', '是否开启', 'on', '1', 'bool', 'form_bool', null, '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1487', '基本配置@base', '11', '会员等级', 'grade', '1:普通会员\r\n2:高级会员\r\n3:金牌会员\r\n4:钻石会员', 'item', 'form_multitextbox', null, '1', '一行一个，形如 数字:等级名称，例如：\r\n1:普通会员\r\n2:高级会员\r\n3:金牌会员\r\n4:钻石会员', '99');
INSERT INTO `ebcms5_config` VALUES ('1488', '注册@reg', '11', '是否允许注册', 'on', '1', 'bool', 'form_bool', null, '1', '', '98');
INSERT INTO `ebcms5_config` VALUES ('1489', '登录@login', '11', '登陆验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '97');
INSERT INTO `ebcms5_config` VALUES ('1490', '找回密码@password', '11', '表单验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '96');
INSERT INTO `ebcms5_config` VALUES ('1491', '修改信息@edit', '11', '表单验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '95');
INSERT INTO `ebcms5_config` VALUES ('1492', '评论配置@comment', '11', '是否开启评论', 'on', '1', 'bool', 'form_bool', null, '1', '', '94');
INSERT INTO `ebcms5_config` VALUES ('1493', '自助升级@gradebuy', '11', '是否开启', 'allow', '1', 'bool', 'form_bool', null, '1', '开启后才可以进行会员自助购买。', '93');
INSERT INTO `ebcms5_config` VALUES ('1494', '注册@reg', '11', '邮箱验证', 'email_verify', '1', 'bool', 'form_bool', null, '1', '', '10');
INSERT INTO `ebcms5_config` VALUES ('1495', '注册@reg', '11', '注册验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1496', '登录@login', '11', '登陆奖励', 'jiangli', 'jifen:1', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:1\r\njinbi:1', '9');
INSERT INTO `ebcms5_config` VALUES ('1497', '找回密码@password', '11', '邮件模板', 'email_tpl', '&lt;p&gt;尊敬的用户，您的邮箱认证码是：&lt;span style=&quot;color: rgb(255, 0, 0);&quot;&gt;&lt;strong&gt;{$code}&lt;/strong&gt;&lt;/span&gt;，请勿泄露给他人，若非本人操作，请忽略！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"200\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1498', '基本配置@base', '11', '币种类型', 'currency', 'jifen:积分\r\njinbi:金币\r\nyuan:余额', 'item', 'form_multitextbox', '{\"height\":\"\",\"width\":\"\",\"prompt\":\"\"}', '1', '自带jifen jinbi yuan三种内置币种，以及 bi1 bi2 bi3 bi4 bi5 bi6 六个自定义扩展币种', '9');
INSERT INTO `ebcms5_config` VALUES ('1499', '评论配置@comment', '11', '允许评论', 'auth', '[\"0\"]', 'json', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n\\t$my_grades[0] = \'\\u6e38\\u5ba2\';\\r\\n\\t$tmp = json_decode($field[\'value\'],true);\\r\\n{\\/php}\\r\\n{foreach name=\'my_grades\' item=\'grade\'}\\r\\n\\t&lt;label class=&quot;checkbox-inline&quot; for=&quot;{$field.unique}_{$key}&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;checkbox&quot; id=&quot;{$field.unique}_{$key}&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$key}&quot; {if condition=&quot;in_array($key,(Array)$tmp)&quot;}checked{\\/if} &gt; {$grade}\\r\\n\\t&lt;\\/label&gt;\\r\\n{\\/foreach}\"}', '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1500', '注册@reg', '11', '默认用户组', 'grade', '1', 'number', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '1', '', '8');
INSERT INTO `ebcms5_config` VALUES ('1501', '评论配置@comment', '11', '无须验证码', 'captcha', '', 'json', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n\\t$my_grades[0] = \'\\u6e38\\u5ba2\';\\r\\n\\t$tmp = json_decode($field[\'value\'],true);\\r\\n{\\/php}\\r\\n{foreach name=\'my_grades\' item=\'grade\'}\\r\\n\\t&lt;label class=&quot;checkbox-inline&quot; for=&quot;{$field.unique}_{$key}&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;checkbox&quot; id=&quot;{$field.unique}_{$key}&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$key}&quot; {if condition=&quot;in_array($key,(Array)$tmp)&quot;}checked{\\/if} &gt; {$grade}\\r\\n\\t&lt;\\/label&gt;\\r\\n{\\/foreach}\"}', '1', '', '8');
INSERT INTO `ebcms5_config` VALUES ('1502', '自助升级@gradebuy', '11', '参数配置', 'config', '{\"1\":{\"value\":\"10\",\"currency\":\"jifen\"},\"2\":{\"value\":\"100\",\"currency\":\"jifen\"},\"3\":{\"value\":\"500\",\"currency\":\"jifen\"},\"4\":{\"value\":\"5000\",\"currency\":\"jifen\"}}', 'json', 'form_custom', '{\"html\":\"{php}\\r\\n$grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n$currency = \\\\ebcms\\\\Config::get(\'user.base.currency\');\\r\\n$res = [];\\r\\n$_value = json_decode($field[\'value\'],true);\\r\\nforeach($grades as $k =&gt; $title){\\r\\n\\t$res[] = [\\r\\n\\t\\t\'title\'=&gt;$title,\\r\\n\\t\\t\'field\'=&gt;$field[\'field\'].\'[\'.$k.\']\',\\r\\n\\t\\t\'value\'=&gt; isset($_value[$k][\'value\'])?$_value[$k][\'value\']:\'\',\\r\\n\\t\\t\'currency\'=&gt; isset($_value[$k][\'currency\'])?$_value[$k][\'currency\']:\'jifen\',\\r\\n\\t];\\r\\n}\\r\\n{\\/php}\\r\\n{foreach name=\'res\' item=\'vo\'}\\r\\n&lt;div class=&quot;row&quot; style=&quot;padding-bottom:15px;&quot;&gt;\\r\\n\\t&lt;div class=&quot;col-md-3&quot;&gt;\\r\\n\\t\\t\\u5347\\u7ea7\\u5230&lt;b&gt;\\u3010{$vo.title}\\u3011&lt;\\/b&gt;\\u9700\\u8981\\r\\n\\t&lt;\\/div&gt;\\r\\n\\t&lt;div class=&quot;col-md-3&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;{$field.unique}_{$key}&quot; name=&quot;{$vo.field}[value]&quot; value=&quot;{$vo.value}&quot; placeholder=&quot;&quot;&gt;\\r\\n\\t&lt;\\/div&gt;\\r\\n\\t&lt;div class=&quot;col-md-6&quot;&gt;\\r\\n\\t\\t{foreach name=\'currency\' item=\'cu\' key=\'cur\'}\\r\\n\\t\\t\\t&lt;label class=&quot;radio-inline&quot; for=&quot;{$field.unique}_{$key}_{$cur}&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;radio&quot; id=&quot;{$field.unique}_{$key}_{$cur}&quot; name=&quot;{$vo.field}[currency]&quot; value=&quot;{$cur}&quot; {eq name=&quot;vo.currency&quot; value=\'$cur\'}checked{\\/eq}&gt; {$cu}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t{\\/foreach}\\r\\n\\t&lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n{\\/foreach}\"}', '1', '数值填空，则表示不允许购买改会员组', '8');
INSERT INTO `ebcms5_config` VALUES ('1503', '注册@reg', '11', '注册奖励', 'jiangli', 'jifen:10', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '7');
INSERT INTO `ebcms5_config` VALUES ('1504', '评论配置@comment', '11', '消息通知模板', 'notice_tpl', '&lt;span class=&quot;text-danger&quot;&gt;&lt;b&gt;您的评论&lt;/b&gt;&lt;/span&gt;：{$comment_p.content}\r\n&lt;br/&gt;\r\n&lt;span class=&quot;text-danger&quot;&gt;&lt;b&gt;他的回复&lt;/b&gt;&lt;/span&gt;：{$comment.content}\r\n&lt;br/&gt;\r\n&lt;span class=&quot;text-muted&quot;&gt;回复人：&lt;a href=&quot;{$comment.user.space_url}&quot;&gt;{$comment.user.nickname|default=&quot;游客&quot;}&lt;/a&gt; 回复时间：{$comment.create_time|date=\'Y-m-d H:i:s\',###} &lt;/span&gt;', 'string', 'form_multitextbox', null, '1', '被回复 comment_p\r\n当前回复 comment', '7');
INSERT INTO `ebcms5_config` VALUES ('1505', '注册@reg', '11', '注册验证邮件模板', 'email_tpl', '&lt;p&gt;尊敬的用户，您的邮箱认证码是：&lt;span style=&quot;color: rgb(255, 0, 0);&quot;&gt;&lt;strong&gt;{$code}&lt;/strong&gt;&lt;/span&gt;，请勿泄露给他人，若非本人操作，请忽略！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"200\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1506', '评论配置@comment', '11', '铭感词处理', 'badwords_handle', '1', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"禁止提交|0\\r\\n进入审核|1\\r\\n直接替换|2\\r\\n不用处理|99\"}', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1507', '注册@reg', '11', '注册成功消息模板', 'success_msg', '&lt;p&gt;尊敬的会员:{$user.nickname}，你好，你注册的邮箱是 {$user.email} 欢迎注册！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"200\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '1', '', '5');
INSERT INTO `ebcms5_config` VALUES ('1508', '评论配置@comment', '11', '敏感词', 'badwords', '麻痹=***\r\n共产党=***\r\n你妈=我妈\r\n狗日=***\r\n日你=日我\r\n傻逼=***我是傻逼***', 'ini', 'form_multitextbox', null, '1', '一行一个 用‘=’分割\r\n左侧敏感词 右侧替换内容', '5');
INSERT INTO `ebcms5_config` VALUES ('1509', '评论配置@comment', '11', '评论奖励', 'jiangli', 'jifen:1', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '0');
INSERT INTO `ebcms5_config` VALUES ('1510', '推广奖励@promote', '11', '关闭推广', 'promote_closed', '0', 'bool', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5f00\\u542f|0\\r\\n\\u5173\\u95ed|1\"}', '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1511', '推广奖励@promote', '11', '访问奖励', 'promote_access_ncentive', 'jifen:1', 'item', 'form_multitextbox', '{\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"\",\"width\":\"\",\"prompt\":\"\"}', '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '0');
INSERT INTO `ebcms5_config` VALUES ('1512', '推广奖励@promote', '11', '注册奖励', 'promote_reg_ncentive', 'jifen:50', 'item', 'form_multitextbox', '[]', '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '0');
INSERT INTO `ebcms5_config` VALUES ('1513', '基本配置', '12', '安全模式', 'safe_mode', '1', 'bool', 'form_bool', null, '1', '安全性更高', '0');

-- ----------------------------
-- Table structure for ebcms5_configcate
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_configcate`;
CREATE TABLE `ebcms5_configcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `name` varchar(255) NOT NULL DEFAULT 'Common' COMMENT '生效应用',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许用户配置',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='核心配置分类表';

-- ----------------------------
-- Records of ebcms5_configcate
-- ----------------------------
INSERT INTO `ebcms5_configcate` VALUES ('1', '系统配置', '系统配置', 'system', '', '1', '90', 'ebcms');
INSERT INTO `ebcms5_configcate` VALUES ('2', '应用配置', '前台配置', 'home', '', '1', '85', 'ebcms');
INSERT INTO `ebcms5_configcate` VALUES ('3', '应用配置', '内容管理系统', 'content', '', '1', '1', 'content');
INSERT INTO `ebcms5_configcate` VALUES ('4', '应用配置', '友情链接', 'link', '', '1', '2', 'link');
INSERT INTO `ebcms5_configcate` VALUES ('8', '应用配置', '简易论坛', 'forum', '', '1', '0', 'forum');
INSERT INTO `ebcms5_configcate` VALUES ('9', '应用配置', '访客统计', 'tongji', '', '1', '0', 'tongji');
INSERT INTO `ebcms5_configcate` VALUES ('11', '应用配置', '会员配置', 'user', '', '1', '7', 'user');
INSERT INTO `ebcms5_configcate` VALUES ('12', '应用配置', '超级支付', 'superpay', '', '1', '0', 'superpay');

-- ----------------------------
-- Table structure for ebcms5_content_attr
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_attr`;
CREATE TABLE `ebcms5_content_attr` (
  `content_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  `attr` varchar(255) NOT NULL DEFAULT '' COMMENT '属性',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容属性表';

-- ----------------------------
-- Records of ebcms5_content_attr
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_content_body
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_body`;
CREATE TABLE `ebcms5_content_body` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `body` text COMMENT '内容主体',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容副表';

-- ----------------------------
-- Records of ebcms5_content_body
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_content_channel
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_channel`;
CREATE TABLE `ebcms5_content_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'meta标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `extend_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '扩展id',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `tpl_detail` varchar(255) NOT NULL DEFAULT '' COMMENT '内容页模板',
  `eb_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `eb_ext` text COMMENT '扩展信息',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COMMENT='内容栏目表';

-- ----------------------------
-- Records of ebcms5_content_channel
-- ----------------------------
INSERT INTO `ebcms5_content_channel` VALUES ('1', '0', 'news', '新闻', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1473737709', '1468748433', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('2', '0', 'tiyu', '体育', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1473737719', '1468748443', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('4', '0', 'yule', '娱乐', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1473737742', '1468748480', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('7', '1', 'junshi', '军事', '军事哈哈哈哈', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1480595690', '1468748523', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('8', '1', 'shehui', '社会', '', '', '', '0', '', '', '', '', '1468752305', '1468748532', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('9', '1', 'guoji', '国际', '', '', '', '0', '', '', '', '', '1468752309', '1468748540', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('10', '2', 'nba', 'NBA', '', '', '', '0', '', '', '', '', '1468748553', '1468748553', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('11', '2', 'zhongchao', '中超', '', '', '', '0', '', '', '', '{\"text\":\"自定义单行文本\",\"__config__\":{\"text\":\"text\",\"textarea\":\"textarea\",\"file\":\"file\",\"editor\":\"ueditor\",\"__test__\":\"test\"},\"textarea\":\"自定义多行文本\",\"file\":\"自定义文件上传\",\"editor\":\"<p>自定义编辑器。<br\\/><\\/p>\"}', '1468834879', '1468748568', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('12', '2', 'aoyun', '奥运', '奥运', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1468900974', '1468748585', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('16', '4', 'mingxing', '明星', '', '', '', '0', '', '', '', '', '1468748640', '1468748640', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('17', '4', 'dianying', '电影', '', '', '', '0', '', '', '', '', '1468748652', '1468748652', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('18', '0', 'xingzuo', '付费浏览', '', '', '', '1', '', 'detail_money', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1501423100', '1468748664', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('19', '0', 'shouji', '手机', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1502106212', '1468748682', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('20', '0', 'tansuo', '探索', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1502106219', '1468748693', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_content_content
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_content`;
CREATE TABLE `ebcms5_content_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_shorttitle` varchar(255) NOT NULL DEFAULT '' COMMENT '短标题',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'META标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `eb_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT '文件名称',
  `ext` text COMMENT '扩展信息',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `eb_style` varchar(255) NOT NULL DEFAULT '' COMMENT '样式',
  PRIMARY KEY (`id`),
  KEY `list` (`channel_id`,`status`,`id`),
  KEY `list2` (`status`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容基本表';

-- ----------------------------
-- Records of ebcms5_content_content
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_content_tag
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_tag`;
CREATE TABLE `ebcms5_content_tag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `tag` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  `recommend` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `eb_style` varchar(255) NOT NULL DEFAULT '' COMMENT '样式',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容标签表';

-- ----------------------------
-- Records of ebcms5_content_tag
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_content_tags
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_tags`;
CREATE TABLE `ebcms5_content_tags` (
  `c_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '标签ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容标签关联表';

-- ----------------------------
-- Records of ebcms5_content_tags
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_extend
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extend`;
CREATE TABLE `ebcms5_extend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `app` varchar(255) DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='扩展表';

-- ----------------------------
-- Records of ebcms5_extend
-- ----------------------------
INSERT INTO `ebcms5_extend` VALUES ('1', '内容模块', '收费模型', '', '1', '1', 'content');

-- ----------------------------
-- Table structure for ebcms5_extendfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extendfield`;
CREATE TABLE `ebcms5_extendfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `value` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='扩展字段表';

-- ----------------------------
-- Records of ebcms5_extendfield
-- ----------------------------
INSERT INTO `ebcms5_extendfield` VALUES ('1', '1', '收费设置', '收费币种', 'currency', 'jifen', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.currency\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '', '1', '1');
INSERT INTO `ebcms5_extendfield` VALUES ('2', '1', '收费设置', '收费额', 'price', '0', 'form_numberbox', '{\"disabled\":\"0\",\"readonly\":\"0\",\"max\":\"\",\"min\":\"\",\"prompt\":\"\"}', '', '2', '1');
INSERT INTO `ebcms5_extendfield` VALUES ('3', '1', '收费设置', '是否需要收费', 'currency_on', '0', 'form_bool', '{\"disabled\":\"0\",\"readonly\":\"0\"}', '', '3', '1');
INSERT INTO `ebcms5_extendfield` VALUES ('4', '1', '收费设置', '有效期', 'expire', '0', 'form_select', '{\"values\":\"\\u4e0d\\u9650\\u671f|0\\r\\n1\\u5206\\u949f|60\\r\\n1\\u5c0f\\u65f6|3600\\r\\n1\\u5929|86400\",\"editable\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\"}', '超过该时间需要重新支付', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_form
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_form`;
CREATE TABLE `ebcms5_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `html` text COMMENT '模板',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3218 DEFAULT CHARSET=utf8 COMMENT='表单表';

-- ----------------------------
-- Records of ebcms5_form
-- ----------------------------
INSERT INTO `ebcms5_form` VALUES ('1', '表单配置', '单行文本', 'form_textbox', '', '100', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2', '表单配置', '布尔选项', 'form_bool', '', '56', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('3', '表单配置', '隐藏域', 'form_hidden', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('4', '表单配置', '百度编辑器', 'form_ueditor', '', '86', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('5', '表单配置', '数字框', 'form_numberbox', '', '91', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('6', '表单配置', '上传', 'form_upload', '', '69', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('9', '表单配置', '多文件上传', 'form_uploads', '', '62', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('13', '表单配置', '数据库', 'form_database', '', '45', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('14', '表单配置', '多行文本', 'form_multitextbox', '', '97', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('18', '账户管理', '添加角色', 'ebcms_group_add', '', '66', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('19', '账户管理', '修改角色', 'ebcms_group_edit', '', '56', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('20', '账户管理', '添加账户', 'ebcms_manager_add', '', '136', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('21', '账户管理', '编辑账户', 'ebcms_manager_edit', '', '75', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('22', '扩展管理', '添加扩展', 'ebcms_extend_add', '', '141', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('23', '扩展管理', '修改扩展', 'ebcms_extend_edit', '', '71', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('24', '扩展管理', '添加字段', 'ebcms_extendfield_add', '', '60', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('25', '扩展管理', '修改字段', 'ebcms_extendfield_edit', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('26', '表单配置', '单选', 'form_radio', '', '72', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('27', '表单配置', '复选', 'form_checkbox', '', '71', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('32', '基本表单', '修改自己密码', 'ebcms_index_password', '', '90', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('33', '表单配置', '下拉选项', 'form_select', '', '44', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('411', '导航管理', '添加导航', 'ebcms_nav_add', '', '160', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('412', '导航管理', '编辑导航', 'ebcms_nav_edit', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('1444', '基本表单', '发送邮件', 'ebcms_index_email', '', '110', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('1497', '表单配置', '自定义', 'form_custom', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2542', '账户管理', '分配权限', 'ebcms_group_rule', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2543', '账户管理', '菜单权限', 'ebcms_group_menu', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2544', '账户管理', '重置密码', 'ebcms_manager_password', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2545', '账户管理', '分配角色', 'ebcms_manager_group', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2546', '基本表单', '应用卸载', 'ebcms_app_uninstall', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('3173', '内容管理', '添加分类', 'content_admin.channel_add', '', '350', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3174', '内容管理', '添加内容', 'content_admin.content_add', '', '39', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3175', '内容管理', '标签合并', 'content_admin.tag_merge', '', '17', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3176', '内容管理', '合并', 'content_admin.channel_merge', '', '48', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3177', '内容管理', '修改标签', 'content_admin.tag_edit', '', '18', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3178', '内容管理', '修改分类', 'content_admin.channel_edit', '', '49', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3179', '内容管理', '内容批量移动', 'content_admin.content_move', '', '37', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3180', '内容管理', '修改内容', 'content_admin.content_edit', '', '38', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3181', '模板助手', '添加', 'mbzs_mbzs_add', '', '300', '', 'mbzs');
INSERT INTO `ebcms5_form` VALUES ('3182', '模板助手', '编辑', 'mbzs_mbzs_edit', '', '3', '', 'mbzs');
INSERT INTO `ebcms5_form` VALUES ('3183', '友情链接', '添加', 'link_admin.link_add', '', '220', null, 'link');
INSERT INTO `ebcms5_form` VALUES ('3184', '友情链接', '编辑', 'link_admin.link_edit', '', '0', null, 'link');
INSERT INTO `ebcms5_form` VALUES ('3199', '简易论坛', '添加板块', 'forum_admin.forum_add', '', '300', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3200', '简易论坛', '移动帖子', 'forum_admin.thread_move', '', '0', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3201', '简易论坛', '添加版主', 'forum_admin.forum_add_moderator', '', '5', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3202', '简易论坛', '编辑板块', 'forum_admin.forum_edit', '', '9', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3203', '简易论坛', '编辑版主', 'forum_admin.forum_edit_moderator', '', '4', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3204', '简易论坛', '权限设置', 'forum_admin.forum_auth', '', '6', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3205', '简易论坛', '编辑帖子', 'forum_admin.thread_edit', '', '8', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3206', '简易论坛', '编辑跟帖', 'forum_admin.rethread_edit', '', '7', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3207', '简易论坛', '合并板块', 'forum_admin.forum_merge', '', '8', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3213', '用户管理', '发消息', 'user_admin.user_msg', '', '0', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3214', '用户管理', '添加用户', 'user_admin.user_add', '', '170', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3215', '用户管理', '编辑用户', 'user_admin.user_edit', '', '0', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3216', '用户管理', '财务变更', 'user_admin.user_currency', '', '0', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3217', '用户管理', '编辑评论', 'user_admin.comment_edit', '', '0', '', 'user');

-- ----------------------------
-- Table structure for ebcms5_formfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_formfield`;
CREATE TABLE `ebcms5_formfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `subtable` varchar(250) NOT NULL DEFAULT '' COMMENT '副表',
  `extfield` varchar(250) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `defaultvaluetype` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '取值类型',
  `defaultvalue` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22602 DEFAULT CHARSET=utf8 COMMENT='表单字段表';

-- ----------------------------
-- Records of ebcms5_formfield
-- ----------------------------
INSERT INTO `ebcms5_formfield` VALUES ('2', '1', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('3', '1', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '38');
INSERT INTO `ebcms5_formfield` VALUES ('7', '1', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('8', '1', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('9', '2', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('10', '2', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('11', '2', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('12', '3', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('13', '4', '基本配置', '高度', 'initialframeheight', '', 'config', '3', 'initialframeheight', 'form_numberbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('14', '4', '基本配置', '自动高度', 'autoheightenabled', '', 'config', '3', 'autoheightenabled', 'form_bool', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('15', '4', '基本配置', '最大字符数', 'maximumwords', '', 'config', '3', 'maximumwords', 'form_numberbox', '{\"required\":\"0\",\"editable\":\"1\",\"readonly\":\"0\",\"max\":\"\",\"min\":\"\",\"prompt\":\"\",\"disabled\":\"0\",\"width\":\"\",\"prefix\":\"\",\"suffix\":\"\",\"groupseparator\":\"\",\"decimalseparator\":\"\",\"precision\":\"\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('16', '4', '基本配置', '开启字数统计', 'wordcount', '', 'config', '3', 'wordcount', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('17', '4', '基本配置', '显示元素路径', 'elementpathenabled', '', 'config', '3', 'elementpathenabled', 'form_bool', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('18', '4', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('20', '5', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('21', '5', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '38');
INSERT INTO `ebcms5_formfield` VALUES ('22', '5', '基本配置', '最大值', 'max', '', 'config', '3', 'max', 'form_numberbox', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('23', '5', '基本配置', '最小值', 'min', '', 'config', '3', 'min', 'form_numberbox', 'null', '', '25');
INSERT INTO `ebcms5_formfield` VALUES ('24', '5', '基本配置', '提示信息', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '15');
INSERT INTO `ebcms5_formfield` VALUES ('25', '5', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('29', '6', '基本配置', '允许的类型', 'extensions', '', 'config', '3', 'extensions', 'form_textbox', 'null', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40');
INSERT INTO `ebcms5_formfield` VALUES ('30', '6', '基本配置', '提示信息', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('31', '6', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('47', '9', '基本配置', '允许的类型', 'extensions', '', 'config', '3', 'extensions', 'form_textbox', 'null', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40');
INSERT INTO `ebcms5_formfield` VALUES ('48', '9', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('49', '9', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('66', '13', '基本配置', '模型名称', 'model', '', 'config', '3', 'model', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '对应的后台的模型名称', '50');
INSERT INTO `ebcms5_formfield` VALUES ('67', '13', '基本配置', '是否可编辑', 'editable', '', 'config', '3', 'editable', 'form_bool', 'null', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '48');
INSERT INTO `ebcms5_formfield` VALUES ('69', '13', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '43');
INSERT INTO `ebcms5_formfield` VALUES ('70', '13', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '42');
INSERT INTO `ebcms5_formfield` VALUES ('71', '13', '基本配置', '根选项', 'rootitem', '', 'config', '3', 'rootitem', 'form_bool', 'null', '根选项开启后 所有条目都会在根选项之下，通常用于选择父级 默认0', '40');
INSERT INTO `ebcms5_formfield` VALUES ('72', '13', '其他配置', '查询条件', 'queryparams', '', 'config', '3', 'queryparams', 'form_multitextbox', 'null', '格式：字段|eq|value\r\n字段|eq|(I)value 添加(I)表示的是提交变量\r\n字段|eq|(@)value 添加(@)表示的是变量', '40');
INSERT INTO `ebcms5_formfield` VALUES ('73', '13', '基本配置', '树型化', 'tree', '', 'config', '3', 'tree', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('74', '13', '其他配置', '递归字段', 'pid', '', 'config', '3', 'pid', 'form_textbox', 'null', '通常请不要修改 默认pid', '30');
INSERT INTO `ebcms5_formfield` VALUES ('75', '13', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('76', '13', '其他配置', '显示字段', 'titlefield', '', 'config', '3', 'titlefield', 'form_textbox', 'null', '默认为text', '9');
INSERT INTO `ebcms5_formfield` VALUES ('77', '13', '其他配置', '值字段', 'valuefield', '', 'config', '3', 'valuefield', 'form_textbox', 'null', '默认为id', '6');
INSERT INTO `ebcms5_formfield` VALUES ('78', '13', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('79', '13', '其他配置', '宽度', 'width', '', 'config', '3', 'width', 'form_numberbox', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('81', '14', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('82', '14', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('83', '14', '基本配置', '高度', 'height', '', 'config', '3', 'height', 'form_numberbox', 'null', '这里是指行数。默认5', '31');
INSERT INTO `ebcms5_formfield` VALUES ('84', '14', '基本配置', '宽度', 'width', '', 'config', '3', 'width', 'form_numberbox', 'null', '不填写表示 100% ', '30');
INSERT INTO `ebcms5_formfield` VALUES ('87', '14', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '15');
INSERT INTO `ebcms5_formfield` VALUES ('88', '14', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('104', '18', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '{\"disabled\":\"0\",\"values\":\"系统|系统\\r\\n普通|普通\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('106', '18', '基本信息', '名称', 'title', '', '', '0', '', 'form_textbox', 'null', '', '91');
INSERT INTO `ebcms5_formfield` VALUES ('107', '18', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('109', '19', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '{\"disabled\":\"0\",\"values\":\"系统|系统\\r\\n普通|普通\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('110', '19', '基本信息', '名称', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '82');
INSERT INTO `ebcms5_formfield` VALUES ('111', '19', '基本信息', '备注', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('112', '19', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('113', '20', '基本信息', '邮箱', 'email', '', '', '0', '', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('114', '20', '基本信息', '昵称', 'nickname', '', '', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"2-6个字符\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('115', '20', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"5-10个字符\",\"maxlength\":\"10\",\"minlength\":\"5\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('116', '20', '基本信息', '头像', 'avatar', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/manager\\/avatar\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('119', '21', '基本信息', '邮箱', 'email', '', '', '3', 'email', 'form_textbox', 'null', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('120', '21', '基本信息', '昵称', 'nickname', '', '', '3', 'nickname', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('121', '21', '基本信息', '头像', 'avatar', '', '', '3', 'avatar', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/manager\\/avatar\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('123', '21', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('124', '22', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('125', '22', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96');
INSERT INTO `ebcms5_formfield` VALUES ('126', '22', '基本信息', '说明', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '75');
INSERT INTO `ebcms5_formfield` VALUES ('127', '23', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('128', '23', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '97');
INSERT INTO `ebcms5_formfield` VALUES ('129', '23', '基本信息', '说明', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '46');
INSERT INTO `ebcms5_formfield` VALUES ('130', '23', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('131', '24', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('132', '24', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"10\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96');
INSERT INTO `ebcms5_formfield` VALUES ('133', '24', '基本信息', '字段', 'name', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '89');
INSERT INTO `ebcms5_formfield` VALUES ('134', '24', '基本信息', '表单类型', 'type', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|表单配置\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('135', '24', '基本信息', '默认值', 'value', '', '', '0', '', 'form_multitextbox', 'null', '', '78');
INSERT INTO `ebcms5_formfield` VALUES ('136', '24', '基本信息', '说明', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('137', '24', '基本信息', '分类', 'category_id', '', '', '1', 'category_id', 'form_hidden', 'null', '', '2');
INSERT INTO `ebcms5_formfield` VALUES ('138', '25', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('139', '25', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '95');
INSERT INTO `ebcms5_formfield` VALUES ('140', '25', '基本信息', '字段', 'name', '', '', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '94');
INSERT INTO `ebcms5_formfield` VALUES ('141', '25', '基本信息', '表单类型', 'type', '', '', '3', 'type', 'form_database', '{\"model\":\"ebcms\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|表单配置\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '更改表单类型后 请更改上一行字段名称 否则可能报错', '93');
INSERT INTO `ebcms5_formfield` VALUES ('142', '25', '基本信息', '默认值', 'value', '', '', '3', 'value', 'form_multitextbox', 'null', '', '87');
INSERT INTO `ebcms5_formfield` VALUES ('143', '25', '基本信息', '说明', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '67');
INSERT INTO `ebcms5_formfield` VALUES ('144', '25', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('145', '26', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('146', '26', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '55');
INSERT INTO `ebcms5_formfield` VALUES ('147', '26', '基本配置', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50');
INSERT INTO `ebcms5_formfield` VALUES ('148', '26', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('149', '27', '基本信息', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('150', '27', '基本信息', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '70');
INSERT INTO `ebcms5_formfield` VALUES ('151', '27', '基本信息', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50');
INSERT INTO `ebcms5_formfield` VALUES ('152', '27', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('175', '32', '基本信息', '旧密码', 'oldpassword', '', '', '0', '', 'form_textbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('176', '32', '基本信息', '新密码', 'password', '', '', '0', '', 'form_textbox', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('177', '32', '基本信息', '重复密码', 'passwordtwo', '', '', '0', '', 'form_textbox', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('178', '33', '基本信息', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '80');
INSERT INTO `ebcms5_formfield` VALUES ('179', '33', '基本信息', '是否可编辑', 'editable', '', 'config', '3', 'editable', 'form_bool', 'null', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '60');
INSERT INTO `ebcms5_formfield` VALUES ('180', '33', '基本信息', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('181', '33', '基本信息', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('182', '33', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2882', '411', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('2883', '411', '基本信息', '链接地址', 'eb_url', '', '', '0', '', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/\r\n系统写法：content/index/lists?id=1', '6');
INSERT INTO `ebcms5_formfield` VALUES ('2884', '411', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('2885', '411', '基本信息', '父级', 'pid', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/nav\",\"editable\":\"0\",\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"group|eq|(I)group\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2886', '412', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"ebcms\\/nav\",\"editable\":\"0\",\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"group|eq|(@)group\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('2887', '412', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2888', '412', '基本信息', '链接地址', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/\r\n系统写法：content/index/lists?id=1', '7');
INSERT INTO `ebcms5_formfield` VALUES ('2889', '412', '个性扩展', '个性扩展', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2890', '412', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2891', '411', '基本信息', '所属应用', 'app', '', '', '0', '', 'form_textbox', '{\"prompt\":\"可不填\"}', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：\r\n1、卸载应用的时候，自动删除\r\n2、暂停应用的时候，前台自动隐藏', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2892', '412', '基本信息', '所属应用', 'app', '', '', '3', 'app', 'form_textbox', '{\"prompt\":\"可不填\"}', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：\r\n1、卸载应用的时候，自动删除\r\n2、暂停应用的时候，前台自动隐藏', '5');
INSERT INTO `ebcms5_formfield` VALUES ('7002', '411', '个性扩展', '个性扩展', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('7006', '13', '基本配置', '分组化', 'group', '', 'config', '3', 'group', 'form_bool', 'null', '', '35');
INSERT INTO `ebcms5_formfield` VALUES ('10186', '1444', '基本信息', '邮件主题', 'topic', '', '', '1', 'topic', 'form_select', '{\"values\":\"系统消息|系统消息\\r\\n优惠信息|优惠信息\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('10187', '1444', '基本信息', '邮件地址', 'email', '', '', '1', 'email', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('10188', '1444', '基本信息', '对方称呼', 'name', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('10189', '1444', '基本信息', '内容', 'content', '', '', '0', '', 'form_ueditor', '{\"initialframeheight\":\"200\",\"maximumwords\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('10558', '1497', '基本配置', 'HTML', 'html', '', 'config', '3', 'html', 'form_multitextbox', '{\"height\":\"20\",\"width\":\"\",\"prompt\":\"\"}', '常见结构：\r\n&lt;tr&gt;\r\n	&lt;th&gt;{$field.title}&lt;/th&gt;\r\n	&lt;td&gt;\r\n		&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;示例&quot;&gt;\r\n		{notempty name=\'field.remark\'}\r\n			&lt;p class=&quot;help-block&quot;&gt;{$field.remark}&lt;/p&gt;\r\n		{/notempty}\r\n	&lt;/td&gt;\r\n&lt;/tr&gt;\r\n支持变量：\r\nfield   当前字段的配置数据\r\ndata    当前表单分配的数据\r\ngroups  当前表单的字段信息\r\nform    当前表单信息', '9');
INSERT INTO `ebcms5_formfield` VALUES ('10559', '1497', '基本配置', 'ID', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('11750', '411', '基本信息', '打开方式', 'target', '', '', '0', '_self', 'form_select', '{\"values\":\"新窗口|_blank\\r\\n当前窗口|_self\\r\\n父窗口|_parent\\r\\n_top|_top\",\"editable\":\"1\"}', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('11751', '412', '基本信息', '打开方式', 'target', '', '', '3', 'target', 'form_select', '{\"values\":\"新窗口|_blank\\r\\n当前窗口|_self\\r\\n父窗口|_parent\\r\\n_top|_top\",\"editable\":\"1\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('12294', '22', '基本信息', '所属应用', 'app', '', '', '0', '', 'form_textbox', 'null', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：卸载应用的时候，自动删除', '10');
INSERT INTO `ebcms5_formfield` VALUES ('12295', '23', '基本信息', '所属应用', 'app', '', '', '3', 'app', 'form_textbox', 'null', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：卸载应用的时候，自动删除', '10');
INSERT INTO `ebcms5_formfield` VALUES ('17492', '2542', '基本信息', '权限', 'rule_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n    $checked = \\\\think\\\\Db::name(\'auth_group\')-&gt;where(array(\'id\' =&gt; array(\'eq\', input(\'id\'))))-&gt;value(\'rules\');\\r\\n    $rules = \\\\think\\\\Db::name(\'auth_rule\')-&gt;order(\'sort desc\')-&gt;select();\\r\\n    $rules = \\\\ebcms\\\\Tree::tree($rules);\\r\\n{\\/php}\\r\\n{foreach name=\'rules\' item=\'a\'}\\r\\n    &lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n        &lt;tr&gt;\\r\\n            &lt;td colspan=&quot;2&quot;&gt;\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$a.id}&quot; {in name=&quot;a.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$a.title}\\r\\n                &lt;\\/label&gt;\\r\\n            &lt;\\/td&gt;\\r\\n        &lt;\\/tr&gt;\\r\\n        {foreach name=\'a.rows\' item=\'b\'}\\r\\n        &lt;tr&gt;\\r\\n            &lt;th&gt;\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$b.id}&quot; {in name=&quot;b.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$b.title}\\r\\n                &lt;\\/label&gt;\\r\\n            &lt;\\/th&gt;\\r\\n            &lt;td&gt;\\r\\n                {foreach name=\'b.rows\' item=\'c\'}\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$c.id}&quot; {in name=&quot;c.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$c.title}\\r\\n                &lt;\\/label&gt;\\r\\n                {\\/foreach}\\r\\n            &lt;\\/td&gt;\\r\\n        &lt;\\/tr&gt;\\r\\n        {\\/foreach}\\r\\n    &lt;\\/table&gt;\\r\\n{\\/foreach}\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17493', '2542', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('17494', '2543', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17495', '2543', '基本信息', '菜单', 'menu_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$checked = \\\\think\\\\Db::name(\'auth_group\')-&gt;where(array(\'id\' =&gt; array(\'eq\', input(\'id\'))))-&gt;value(\'menus\');\\r\\n\\t$menus = \\\\think\\\\Db::name(\'menu\')-&gt;order(\'sort desc\')-&gt;select();\\r\\n\\t$menus = \\\\ebcms\\\\Tree::tree($menus);\\r\\n{\\/php}\\r\\n&lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n\\t{foreach name=\'menus\' item=\'top\'}\\r\\n\\t&lt;tr&gt;\\r\\n\\t\\t&lt;th&gt;\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$top.id}&quot; {in name=&quot;top.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$top.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t&lt;\\/th&gt;\\r\\n\\t\\t&lt;td&gt;\\r\\n\\t\\t\\t{foreach name=\'top.rows\' item=\'sub\'}\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$sub.id}&quot; {in name=&quot;sub.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$sub.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;\\/td&gt;\\r\\n\\t&lt;\\/tr&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/table&gt;\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17496', '2544', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17497', '2544', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '2');
INSERT INTO `ebcms5_formfield` VALUES ('17498', '2545', '基本信息', '角色', 'group_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$checked = \\\\think\\\\Db::name(\'auth_access\')-&gt;where(\'uid=\' . input(\'id\'))-&gt;column(\'group_id\');\\r\\n\\t$groups = \\\\think\\\\Db::name(\'auth_group\')-&gt;select();\\r\\n\\t$groups = \\\\ebcms\\\\Tree::group($groups);\\r\\n{\\/php}\\r\\n&lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n\\t{foreach name=\'groups\' item=\'items\'}\\r\\n\\t&lt;tr&gt;\\r\\n\\t\\t&lt;th&gt;\\r\\n\\t\\t\\t{$key}\\r\\n\\t\\t&lt;\\/th&gt;\\r\\n\\t\\t&lt;td&gt;\\r\\n\\t\\t\\t{foreach name=\'items\' item=\'vo\'}\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$vo.id}&quot; {in name=&quot;vo.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$vo.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;\\/td&gt;\\r\\n\\t&lt;\\/tr&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/table&gt;\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17499', '2545', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17500', '2546', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', null, '为保证系统安全，请输入密码！', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17501', '2546', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('18296', '6', '基本配置', '上传目录', 'path', '', 'config', '3', 'path', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('18299', '9', '基本配置', '上传目录', 'path', '', 'config', '3', 'path', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('21544', '13', '基本配置', '查询排序', 'order', '', 'config', '3', '', 'form_textbox', null, '', '49');
INSERT INTO `ebcms5_formfield` VALUES ('21545', '13', '基本配置', '查询排序', 'order', '', 'config', '3', '', 'form_textbox', null, '', '49');
INSERT INTO `ebcms5_formfield` VALUES ('22372', '3173', '基本信息', '父级', 'pid', '', '', '1', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22373', '3173', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"editable\":\"1\",\"maxlength\":\"80\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22374', '3173', '基本信息', '名称', 'name', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"请填写英文字符\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22375', '3173', '高级设置', 'meta标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', 'null', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22376', '3173', '基本信息', '关键字', 'keywords', '', '', '0', '', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '空格或英文的逗号分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22377', '3173', '基本信息', '摘要', 'description', '', '', '0', '', 'form_multitextbox', '{\"required\":\"0\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"255\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22378', '3173', '高级设置', '模型扩展', 'extend_id', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '在 【系统管理 =&gt; 模型扩展】 里面设置\n可以根据自身网站需要扩展出 产品模型 图集模型 下载模型等等', '41');
INSERT INTO `ebcms5_formfield` VALUES ('22379', '3173', '高级设置', '列表页模板', 'tpl', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填写 默认为channel\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22380', '3173', '高级设置', '内容页模板', 'tpl_detail', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填写默认为 detail\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '21');
INSERT INTO `ebcms5_formfield` VALUES ('22381', '3173', '高级设置', '跳转链接', 'eb_url', '', '', '0', '', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/news.html\n以及系统写法：content/index/channel?id=3', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22382', '3173', '个性扩展', '个性扩展', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22383', '3174', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '600');
INSERT INTO `ebcms5_formfield` VALUES ('22384', '3174', '高级设置', 'META标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', 'null', '用作seo标题设置，不填则默认为标题', '300');
INSERT INTO `ebcms5_formfield` VALUES ('22385', '3174', '高级设置', '短标题', 'eb_shorttitle', '', '', '0', '', 'form_textbox', 'null', '一般用作 首页 列表页调用 没有则调用标题', '70');
INSERT INTO `ebcms5_formfield` VALUES ('22386', '3174', '高级设置', '摘要', 'description', '', '', '0', '', 'form_multitextbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22387', '3174', '基本信息', '关键字', 'keywords', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    $(function() {\\r\\n        EBCMS.CORE.myfun(\'suggest_keywords\',function(container,content,strong){\\r\\n            if (content) {\\r\\n                if (content != 0) {\\r\\n                    if ($(container).val()) {\\r\\n                        var keywords = $(container).val().split(\',\');\\r\\n                        var ue = UE.getEditor(content);\\r\\n                        var contents = ue.getContent().split(\'\\uff0c\');\\r\\n                        var num = Math.min(keywords.length,contents.length-1);\\r\\n                        var nums = EBCMS.FN.random_num(num,0,contents.length-1);\\r\\n                        $.each(nums, function(index, val) {\\r\\n                            if (strong == 1) {\\r\\n                                contents[val] = contents[val]+\'\\uff0c&lt;strong&gt;\'+keywords[index]+\'&lt;\\/strong&gt;\';\\r\\n                            }else{\\r\\n                                contents[val] = contents[val]+\'\\uff0c\'+keywords[index];\\r\\n                            }\\r\\n                        });\\r\\n                        ue.setContent(contents.join(\'\\uff0c\'));\\r\\n                    }\\r\\n                }else{\\r\\n                    EBCMS.MSG.notice(\'\\u672a\\u914d\\u7f6e\\u63a5\\u6536\\u5b57\\u6bb5\\uff01\');\\r\\n                }\\r\\n            }else{\\r\\n                EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u4e2d...\');\\r\\n                $.ajax({\\r\\n                    url: \'{:url(\'ebcms\\/api\\/index\')}\',\\r\\n                    type: \'POST\',\\r\\n                    dataType: \'json\',\\r\\n                    data: {\\r\\n                        api: \'suggest_keywords\',\\r\\n                        k:$(container).val(),\\r\\n                    },\\r\\n                    success:function(res){\\r\\n                        if (res.data &amp;&amp; res.data.length) {\\r\\n                            EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u6210\\u529f...\',0.5);\\r\\n                            $(container).val($(container).val()+\',\'+res.data.join(\',\'));\\r\\n                        }else{\\r\\n                            EBCMS.MSG.tips(\'\\u6682\\u65e0\\u5185\\u5bb9...\');\\r\\n                        }\\r\\n                    },\\r\\n                    error:function(){\\r\\n                        EBCMS.MSG.alert(\'\\u670d\\u52a1\\u5668\\u5fd9\\uff0c\\u8bf7\\u7a0d\\u540e\\u518d\\u8bd5\\uff01\');\\r\\n                    }\\r\\n                });\\r\\n            }\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n    &lt;tr&gt;\\r\\n        &lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\\r\\n            &lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\');&quot;&gt;\\u957f\\u5c3e\\u5173\\u952e\\u8bcd&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\',\'{$groups[\'\\u57fa\\u672c\\u4fe1\\u606f\'][\'body[body]\'][\'unique\']}\',1);&quot;&gt;\\u63d2\\u5165\\u5230\\u5185\\u5bb9&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n    &lt;\\/tr&gt;\\r\\n&lt;\\/table&gt;\"}', '空格或英文的逗号分割', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22388', '3174', '基本信息', '标签', 'tags', '', '', '0', '', 'form_textbox', 'null', '空格或英文的逗号分割', '42');
INSERT INTO `ebcms5_formfield` VALUES ('22389', '3174', '高级设置', '模板', 'tpl', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填默认为detail\"}', '只填写文件名，不要写后缀\n模板位于 application/content/view/index/下', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22390', '3174', '高级设置', '文件名', 'filename', '', '', '0', '', 'form_textbox', 'null', '默认为文章id', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22391', '3174', '基本信息', '缩略图', 'thumb', '', '', '0', '', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/content\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22392', '3174', '基本信息', '内容', 'body', '', 'body', '0', '', 'form_ueditor', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22393', '3174', '高级设置', '外部链接', 'eb_url', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '常规写法：http://www.ebcms.com/news.html\n系统写法：content/index/channel?id=1', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22394', '3174', '基本信息', '分类', 'channel_id', '', '', '1', 'channel_id', 'form_hidden', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"extend_id|eq|($)channel.extend_id\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22395', '3175', '基本信息', '将标签', 'tag1', '', '', '1', 'tag1', 'form_textbox', '{\"required\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"\"}', '多个标签 请用空格分隔', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22396', '3175', '基本信息', '合并到', 'tag2', '', '', '1', 'tag2', 'form_textbox', 'null', '不存在则自动创建', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22397', '3176', '基本信息', '栏目id', 'ids', '', '', '1', 'ids', 'form_multitextbox', '{\"required\":\"1\",\"disabled\":\"0\",\"readonly\":\"1\",\"height\":\"\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22398', '3176', '基本信息', '合并到', 'id', '', '', '0', '', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"id|notin|(I)ids\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '不同模型之间的栏目合并，如果和目标栏目模型不一样，会造成这些栏目下面的内容的自定义扩展数据丢失，但主体内容不受影响！', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22399', '3177', '基本信息', '标签', 'tag', '', '', '3', 'tag', 'form_textbox', 'null', '若标签存在，将执行合并', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22400', '3177', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22401', '3178', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22402', '3178', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22403', '3178', '基本信息', '名称', 'name', '', '', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22404', '3178', '基本信息', '关键字', 'keywords', '', '', '3', 'keywords', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '用空格或英文的逗号”,“分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22405', '3178', '高级设置', 'meta标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22406', '3178', '基本信息', '摘要', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22407', '3178', '高级设置', '模型扩展', 'extend_id', '', '', '3', 'extend_id', 'form_database', '{\"model\":\"ebcms\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '在 【系统管理 =&gt; 模型扩展】 里面设置\n可以根据自身网站需要扩展出 产品模型 图集模型 下载模型等等', '41');
INSERT INTO `ebcms5_formfield` VALUES ('22408', '3178', '高级设置', '列表页模板', 'tpl', '', '', '3', 'tpl', 'form_textbox', '{\"prompt\":\"不填写 默认为channel\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22409', '3178', '高级设置', '内容页模板', 'tpl_detail', '', '', '3', 'tpl_detail', 'form_textbox', '{\"prompt\":\"不填写 默认为detail\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '21');
INSERT INTO `ebcms5_formfield` VALUES ('22410', '3178', '高级设置', '跳转链接', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/news.html\n以及系统写法：content/index/channel?id=3', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22411', '3178', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22412', '3178', '个性扩展', '扩展字段', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22413', '3179', '基本信息', '内容id', 'ids', '', '', '1', 'ids', 'form_multitextbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22414', '3179', '基本信息', '移动到', 'channel_id', '', '', '1', 'channel_id', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '如果移动的内容和移动到的栏目的模型不一样，会造成移动的内容中模型不一样的那一部分数据的自定义扩展内容数据丢失，但主体内容数据不会丢失！\n非超级管理员操作，会自动排除已经锁定的数据。', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22415', '3180', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '600');
INSERT INTO `ebcms5_formfield` VALUES ('22416', '3180', '高级设置', 'META标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', 'null', '用作seo标题设置，不填则默认为标题', '300');
INSERT INTO `ebcms5_formfield` VALUES ('22417', '3180', '高级设置', '短标题', 'eb_shorttitle', '', '', '3', 'eb_shorttitle', 'form_textbox', 'null', '一般用作 首页 列表页调用 没有则调用标题', '70');
INSERT INTO `ebcms5_formfield` VALUES ('22418', '3180', '基本信息', '关键字', 'keywords', '', '', '3', 'keywords', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    $(function() {\\r\\n        EBCMS.CORE.myfun(\'suggest_keywords\',function(container,content,strong){\\r\\n            if (content) {\\r\\n                if (content != 0) {\\r\\n                    if ($(container).val()) {\\r\\n                        var keywords = $(container).val().split(\',\');\\r\\n                        var ue = UE.getEditor(content);\\r\\n                        var contents = ue.getContent().split(\'\\uff0c\');\\r\\n                        var num = Math.min(keywords.length,contents.length-1);\\r\\n                        var nums = EBCMS.FN.random_num(num,0,contents.length-1);\\r\\n                        $.each(nums, function(index, val) {\\r\\n                            if (strong == 1) {\\r\\n                                contents[val] = contents[val]+\'\\uff0c&lt;strong&gt;\'+keywords[index]+\'&lt;\\/strong&gt;\';\\r\\n                            }else{\\r\\n                                contents[val] = contents[val]+\'\\uff0c\'+keywords[index];\\r\\n                            }\\r\\n                        });\\r\\n                        ue.setContent(contents.join(\'\\uff0c\'));\\r\\n                    }\\r\\n                }else{\\r\\n                    EBCMS.MSG.notice(\'\\u672a\\u914d\\u7f6e\\u63a5\\u6536\\u5b57\\u6bb5\\uff01\');\\r\\n                }\\r\\n            }else{\\r\\n                EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u4e2d...\');\\r\\n                $.ajax({\\r\\n                    url: \'{:url(\'ebcms\\/api\\/index\')}\',\\r\\n                    type: \'POST\',\\r\\n                    dataType: \'json\',\\r\\n                    data: {\\r\\n                        api: \'suggest_keywords\',\\r\\n                        k:$(container).val(),\\r\\n                    },\\r\\n                    success:function(res){\\r\\n                        if (res.data &amp;&amp; res.data.length) {\\r\\n                            EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u6210\\u529f...\',0.5);\\r\\n                            $(container).val($(container).val()+\',\'+res.data.join(\',\'));\\r\\n                        }else{\\r\\n                            EBCMS.MSG.tips(\'\\u6682\\u65e0\\u5185\\u5bb9...\');\\r\\n                        }\\r\\n                    },\\r\\n                    error:function(){\\r\\n                        EBCMS.MSG.alert(\'\\u670d\\u52a1\\u5668\\u5fd9\\uff0c\\u8bf7\\u7a0d\\u540e\\u518d\\u8bd5\\uff01\');\\r\\n                    }\\r\\n                });\\r\\n            }\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n    &lt;tr&gt;\\r\\n        &lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\\r\\n            &lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\');&quot;&gt;\\u957f\\u5c3e\\u5173\\u952e\\u8bcd&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\',\'{$groups[\'\\u57fa\\u672c\\u4fe1\\u606f\'][\'body[body]\'][\'unique\']}\',1);&quot;&gt;\\u63d2\\u5165\\u5230\\u5185\\u5bb9&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n    &lt;\\/tr&gt;\\r\\n&lt;\\/table&gt;\"}', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22419', '3180', '高级设置', '摘要', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22420', '3180', '高级设置', '模板', 'tpl', '', '', '3', 'tpl', 'form_textbox', '{\"prompt\":\"不填写 默认为detail\"}', '只填写文件名，不要写后缀\n模板位于 application/content/view/index/下', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22421', '3180', '基本信息', '标签', 'tags', '', '', '3', 'tags', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '35');
INSERT INTO `ebcms5_formfield` VALUES ('22422', '3180', '高级设置', '文件名', 'filename', '', '', '3', 'filename', 'form_textbox', '{\"prompt\":\"\"}', '默认为文章id', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22423', '3180', '基本信息', '缩略图', 'thumb', '', '', '3', 'thumb', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/content\",\"prompt\":\"\"}', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22424', '3180', '高级设置', '外部链接', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '常规写法：http://www.ebcms.com/news.html\n系统写法：content/index/channel?id=1', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22425', '3180', '基本信息', '内容', 'body', 'body', '', '3', 'body', 'form_ueditor', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22426', '3180', '高级设置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22427', '3181', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22428', '3181', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22429', '3181', '基本信息', '键', 'name', '', '', '0', '', 'form_textbox', '', '英文字符', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22430', '3181', '基本信息', '值', 'value', '', '', '0', '', 'form_custom', '{\"html\":\"{switch name=&quot;$Request.param.form&quot;}\\r\\n\\t{case value=&quot;multitextbox&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;ueditor&quot;}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUE(\'{$field.unique}\',{\\r\\n\\t\\t\\t\\t\\tautoHeightEnabled:{$field.config.autoheightenabled|default=\'false\'},\\r\\n\\t\\t\\t\\t\\tmaximumWords:{$field.config.maximumwords|default=\'10000\'},\\r\\n\\t\\t\\t\\t\\twordCount:{$field.config.wordcount|default=\'true\'},\\r\\n\\t\\t\\t\\t\\telementPathEnabled:{$field.config.elementpathenabled|default=\'true\'},\\r\\n\\t\\t\\t\\t\\tinitialFrameHeight:{$field.config.initialframeheight|default=\'420\'},\\r\\n\\t\\t\\t\\t});\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;textarea name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot;&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;upload&quot;}\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$field[\'config\'][\'path\'] = \'\\/mbzs\'\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUploader(\'#{$field.unique}_pick\',function(file,res){\\r\\n\\t\\t\\t\\t\\tif (res.code) {\\r\\n\\t\\t\\t\\t\\t\\t$(\'#{$field.unique}\').val(res.data.pathname);\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\tEBCMS.MSG.alert(res.msg);\\r\\n\\t\\t\\t\\t\\t};\\r\\n\\t\\t\\t\\t},\'{$field.config.extensions|default=&quot;&quot;}\',\'{$field.config.path|default=&quot;&quot;}\');\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n\\t\\t\\t&lt;tr&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;padding: 0px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;div id=&quot;{$field.unique}_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t&lt;\\/tr&gt;\\r\\n\\t\\t&lt;\\/table&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;tpl&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n{\\/switch}\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22431', '3181', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', '', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22432', '3181', '基本信息', '表单类型', 'form', '', '', '1', 'form', 'form_hidden', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5355\\u884c\\u6587\\u672c|form_textbox\\r\\n\\u591a\\u884c\\u6587\\u672c|form_multitextbox\\r\\n\\u7f16\\u8f91\\u5668|form_ueditor\\r\\n\\u56fe\\u7247|form_image\\r\\n\\u5e03\\u5c14|form_bool\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22433', '3182', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22434', '3182', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22435', '3182', '基本信息', '键', 'name', '', '', '3', 'name', 'form_textbox', '', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22436', '3182', '基本信息', '值', 'value', '', '', '3', 'value', 'form_custom', '{\"html\":\"{switch name=&quot;data.form&quot;}\\r\\n\\t{case value=&quot;multitextbox&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;ueditor&quot;}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUE(\'{$field.unique}\',{\\r\\n\\t\\t\\t\\t\\tautoHeightEnabled:{$field.config.autoheightenabled|default=\'false\'},\\r\\n\\t\\t\\t\\t\\tmaximumWords:{$field.config.maximumwords|default=\'10000\'},\\r\\n\\t\\t\\t\\t\\twordCount:{$field.config.wordcount|default=\'true\'},\\r\\n\\t\\t\\t\\t\\telementPathEnabled:{$field.config.elementpathenabled|default=\'true\'},\\r\\n\\t\\t\\t\\t\\tinitialFrameHeight:{$field.config.initialframeheight|default=\'420\'},\\r\\n\\t\\t\\t\\t});\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;textarea name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot;&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;upload&quot;}\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$field[\'config\'][\'path\'] = \'\\/mbzs\'\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUploader(\'#{$field.unique}_pick\',function(file,res){\\r\\n\\t\\t\\t\\t\\tif (res.code) {\\r\\n\\t\\t\\t\\t\\t\\t$(\'#{$field.unique}\').val(res.data.pathname);\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\tEBCMS.MSG.alert(res.msg);\\r\\n\\t\\t\\t\\t\\t};\\r\\n\\t\\t\\t\\t},\'{$field.config.extensions|default=&quot;&quot;}\',\'{$field.config.path|default=&quot;&quot;}\');\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n\\t\\t\\t&lt;tr&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;padding: 0px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;div id=&quot;{$field.unique}_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t&lt;\\/tr&gt;\\r\\n\\t\\t&lt;\\/table&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;tpl&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n{\\/switch}\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22437', '3182', '基本信息', '备注', 'remark', '', '', '3', 'remark', 'form_multitextbox', '', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22438', '3182', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', '', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22439', '3183', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_select', '{\"values\":\"友情链接|友情链接\\r\\n合作伙伴|合作伙伴\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22440', '3183', '基本信息', '名称', 'title', '', '', '0', '', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22441', '3183', '基本信息', '网址', 'url', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22442', '3183', '基本信息', '站标', 'logo', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/link\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22443', '3183', '基本信息', '简介', 'description', '', '', '0', '', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22444', '3183', '基本信息', '其他信息', 'info', '', '', '0', '', 'form_multitextbox', 'null', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22445', '3184', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_select', '{\"values\":\"友情链接|友情链接\\r\\n合作伙伴|合作伙伴\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22446', '3184', '基本信息', '名称', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22447', '3184', '基本信息', '网址', 'url', '', '', '3', 'url', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22448', '3184', '基本信息', '站标', 'logo', '', '', '3', 'logo', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/link\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22449', '3184', '基本信息', '简介', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22450', '3184', '基本信息', '其他信息', 'info', '', '', '3', 'info', 'form_multitextbox', 'null', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22451', '3184', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22514', '3199', '基本信息', '分组', 'group', '', '', '0', '默认分组', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22515', '3199', '高级设置', '列表模板', 'tpl_list', '', 'config', '0', '', 'form_textbox', null, '默认为 list', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22516', '3199', '数据扩展', '数据扩展', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*改名名称*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*编辑器*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;填写内容&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;上传&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;单行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;多行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;文件&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;编辑框&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        {notempty name=\'field.remark\'}\\r\\n            &lt;p class=&quot;help-block&quot;&gt;{$field.remark}&lt;\\/p&gt;\\r\\n        {\\/notempty}\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;table-responsive&quot; style=&quot;border: 1px solid #ddd;&quot;&gt;\\r\\n            &lt;table class=&quot;table table-noborder&quot; id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/table&gt;\\r\\n            &lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\\r\\n        &lt;\\/div&gt;\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22517', '3199', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22518', '3199', '基本信息', 'META标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22519', '3199', '高级设置', '帖子模板', 'tpl_thread', '', 'config', '0', '', 'form_textbox', null, '默认为 thread', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22520', '3199', '基本信息', '关键词', 'keywords', '', '', '0', '', 'form_textbox', null, '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22521', '3199', '基本信息', '简介', 'description', '', '', '0', '', 'form_multitextbox', null, '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22522', '3200', '基本信息', '帖子ID', 'ids', '', '', '1', 'ids', 'form_multitextbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22523', '3200', '基本信息', '移动到', 'forum_id', '', '', '0', '', 'form_database', '{\"model\":\"forum\\/forum\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22524', '3201', '基本信息', '用户ID', 'user_id', '', '', '0', '', 'form_numberbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22525', '3201', '基本信息', '权限', 'auth', '', '', '0', '', 'form_checkbox', '{\"values\":\"删除|delete\\r\\n编辑|edit\\r\\n审核|status\\r\\n精华|best\\r\\n置顶|top1\\r\\n全局置顶|top2\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22526', '3201', '基本信息', '论坛id', 'forum_id', '', '', '1', 'forum_id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22527', '3202', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22528', '3202', '高级设置', '列表模板', 'tpl_list', '', 'config', '3', 'tpl_list', 'form_textbox', null, '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22529', '3202', '数据扩展', '数据扩展', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*改名名称*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*编辑器*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;填写内容&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;上传&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;单行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;多行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;文件&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;编辑框&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        {notempty name=\'field.remark\'}\\r\\n            &lt;p class=&quot;help-block&quot;&gt;{$field.remark}&lt;\\/p&gt;\\r\\n        {\\/notempty}\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;table-responsive&quot; style=&quot;border: 1px solid #ddd;&quot;&gt;\\r\\n            &lt;table class=&quot;table table-noborder&quot; id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/table&gt;\\r\\n            &lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\\r\\n        &lt;\\/div&gt;\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22530', '3202', '高级设置', '帖子模板', 'tpl_thread', '', 'config', '3', 'tpl_thread', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22531', '3202', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22532', '3202', '基本信息', 'META标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22533', '3202', '基本信息', '关键词', 'keywords', '', '', '3', 'keywords', 'form_textbox', null, '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22534', '3202', '基本信息', '简介', 'description', '', '', '3', 'description', 'form_multitextbox', null, '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22535', '3202', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22536', '3203', '基本信息', '用户id', 'user_id', '', '', '3', 'user_id', 'form_numberbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22537', '3203', '基本信息', '权限', 'auth', '', '', '3', 'auth', 'form_checkbox', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"删除|delete\\r\\n编辑|edit\\r\\n审核|status\\r\\n精华|best\\r\\n置顶|top1\\r\\n全局置顶|top2\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22538', '3203', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22539', '3204', '基本信息', '权限', 'auth', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n    $grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n    $grades[0] = \'游客\';\\r\\n    $x = \\\\think\\\\Db::name(\'forum\') -&gt; find(input(\'id\'));\\r\\n    $auth = explode(\',\',$x[\'auth\']);\\r\\n    $authgroup = [\\r\\n        \'浏览\'                =&gt;  0,\\r\\n        \'发帖\'                =&gt;  10,\\r\\n        \'发帖无须审核\'        =&gt;  11,\\r\\n        \'发帖无须验证码\'         =&gt;  12,\\r\\n        \'跟帖\'                =&gt;  40,\\r\\n        \'跟帖无须审核\'        =&gt;  41,\\r\\n        \'跟帖验证码\'         =&gt;  42,\\r\\n    ];\\r\\n{\\/php}\\r\\n&lt;script&gt;\\r\\n    $(function(){\\r\\n        $(\'.auth\').bind(\'click\', function(event) {\\r\\n            $(\'input\',this).trigger(\'click\');\\r\\n        });\\r\\n        $(\'._aa\').bind(\'click\', function(event) {\\r\\n            $(\'.aa_\'+$(this).data(\'x\')).trigger(\'click\');\\r\\n        });\\r\\n        $(\'._bb\').bind(\'click\', function(event) {\\r\\n            $(\'.bb_\'+$(this).data(\'x\')).trigger(\'click\');\\r\\n        });\\r\\n        $(\'._aabb\').bind(\'click\', function(event) {\\r\\n            $(\'.auth\').trigger(\'click\');\\r\\n        });\\r\\n        $.each({$auth|json_encode}, function(index, val) {\\r\\n            $(\'.auth_\'+val).trigger(\'click\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n            &lt;tr&gt;\\r\\n                &lt;th class=&quot;_aabb&quot;&gt;&lt;\\/th&gt;\\r\\n                {foreach name=\'authgroup\' item=\'x\'}\\r\\n                &lt;th class=&quot;_aa&quot; data-x=\'{$x}\'&gt;{$key}&lt;\\/th&gt;\\r\\n                {\\/foreach}\\r\\n            &lt;\\/tr&gt;\\r\\n            {foreach name=\'grades\' item=\'vo\' key=&quot;k1&quot;}\\r\\n                &lt;tr&gt;\\r\\n                    &lt;th class=&quot;_bb&quot; data-x=&quot;{$k1}&quot;&gt;{$vo}&lt;\\/th&gt;\\r\\n                    {foreach name=\'authgroup\' item=\'x\'}\\r\\n                    &lt;td class=&quot;auth aa_{$x} bb_{$k1}&quot;&gt;\\r\\n                        &lt;input type=&quot;checkbox&quot; name=&quot;auth[]&quot; class=&quot;auth_{$k1}_{$x}&quot; value=&quot;{$k1}_{$x}&quot;&gt;\\r\\n                    &lt;\\/td&gt;\\r\\n                    {\\/foreach}\\r\\n                &lt;\\/tr&gt;\\r\\n            {\\/foreach}\\r\\n        &lt;\\/table&gt;\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22540', '3204', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22541', '3205', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', null, '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22542', '3205', 'SEO', '关键词', 'keywords', '', '', '3', 'keywords', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22543', '3205', 'SEO', '描述', 'description', '', '', '3', 'description', 'form_multitextbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22544', '3205', '基本信息', '内容', 'detail', 'body', '', '3', 'detail', 'form_ueditor', null, '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22545', '3205', '基本信息', 'ID', 'id', '', '', '3', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22546', '3206', '基本信息', '跟帖内容', 'content', '', '', '3', 'content', 'form_ueditor', null, '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22547', '3206', '基本信息', 'ID', 'id', '', '', '3', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22548', '3207', '基本信息', '板块ID', 'ids', '', '', '1', 'ids', 'form_multitextbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22549', '3207', '基本信息', '合并到', 'id', '', '', '0', '', 'form_database', '{\"model\":\"forum\\/forum\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22576', '3213', '基本信息', '用户', 'user', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$user = \\\\app\\\\user\\\\model\\\\User::get(input(\'user_id\'));\\r\\n{\\/php}\\r\\n&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;{$user.nickname}\\uff08ID\\uff1a{$user.id}\\uff0c\\u90ae\\u7bb1\\uff1a{$user.email}\\uff09&quot; readonly disabled&gt;\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22577', '3213', '基本信息', '消息类型', 'topic', '', '', '0', '系统消息', 'form_select', '{\"values\":\"系统消息|系统消息\\r\\n信息通知|信息通知\",\"editable\":\"1\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22578', '3213', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22579', '3213', '基本信息', '消息内容', 'content', '', '', '0', '', 'form_multitextbox', 'null', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22580', '3213', '基本信息', 'user_id', 'user_id', '', '', '1', 'user_id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22581', '3214', '基本信息', '用户等级', 'grade', '', '', '0', '1', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22582', '3214', '基本信息', '邮箱', 'email', '', '', '0', '', 'form_textbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22583', '3214', '基本信息', '昵称', 'nickname', '', '', '0', '', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22584', '3214', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22585', '3214', '基本信息', '头像', 'avatar', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/user\\/avatar\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22586', '3214', '基本信息', '座右铭', 'motto', '', '', '0', '', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22587', '3215', '基本信息', '用户等级', 'grade', '', '', '3', 'grade', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22588', '3215', '基本信息', '邮箱', 'email', '', '', '3', 'email', 'form_textbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22589', '3215', '基本信息', '昵称', 'nickname', '', '', '3', 'nickname', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22590', '3215', '基本信息', '头像', 'avatar', '', '', '3', 'avatar', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/user\\/avatar\",\"prompt\":\"\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22591', '3215', '基本信息', '座右铭', 'motto', '', '', '3', 'motto', 'form_multitextbox', 'null', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22592', '3215', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22593', '3216', '基本信息', '用户', 'user', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$user = \\\\app\\\\user\\\\model\\\\User::get(input(\'user_id\'));\\r\\n{\\/php}\\r\\n&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;{$user.nickname}\\uff08ID\\uff1a{$user.id}\\uff0c\\u90ae\\u7bb1\\uff1a{$user.email}\\uff09&quot; readonly disabled&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22594', '3216', '基本信息', '类型', 'type', '', '', '0', 'inc', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"充值|inc\\r\\n扣费|dec\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22595', '3216', '基本信息', '币种', 'currency', '', '', '0', 'jifen', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$_currency = \\\\ebcms\\\\Config::get(\'user.base.currency\');\\r\\n{\\/php}\\r\\n{foreach name=\'_currency\' item=\'_temp\' key=\'curr\'}\\r\\n\\t&lt;label class=&quot;radio-inline&quot; for=&quot;{$field.unique}_{$curr}&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;radio&quot; name=&quot;{$field.field}&quot; id=&quot;{$field.unique}_{$curr}&quot; value=&quot;{$curr}&quot; {eq name=&quot;field.value&quot; value=\'$curr\'}checked{\\/eq}&gt; {$_temp}\\r\\n\\t&lt;\\/label&gt;\\r\\n{\\/foreach}\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22596', '3216', '基本信息', '数额', 'num', '', '', '0', '0', 'form_numberbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22597', '3216', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22598', '3216', '基本信息', '通知消息', 'msg', '', '', '0', '', 'form_multitextbox', 'null', '通知用户的消息，不填写则为系统默认消息', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22599', '3216', '基本信息', '用户id', 'user_id', '', '', '1', 'user_id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22600', '3217', '基本信息', '内容', 'content', '', '', '3', 'content', 'form_multitextbox', null, '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22601', '3217', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '0');

-- ----------------------------
-- Table structure for ebcms5_forum
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum`;
CREATE TABLE `ebcms5_forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'meta标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `eb_ext` text COMMENT '扩展信息',
  `config` text COMMENT '配置',
  `auth` text COMMENT '权限',
  `open` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '开启论坛',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='论坛表';

-- ----------------------------
-- Records of ebcms5_forum
-- ----------------------------
INSERT INTO `ebcms5_forum` VALUES ('1', '默认分组', '手机论坛', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '{\"tpl_list\":\"\",\"tpl_thread\":\"\"}', '1_0,1_10,1_11,1_40,1_41,2_0,2_10,2_11,2_40,2_41,3_0,3_10,3_11,3_40,3_41,4_0,4_10,4_11,4_40,4_41,0_0,0_10,0_11,0_40,0_41', '1', '0', '0', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_forum_moderator
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_moderator`;
CREATE TABLE `ebcms5_forum_moderator` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '论坛id',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '评论人id',
  `auth` varchar(255) NOT NULL DEFAULT '' COMMENT '权限',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='版主权限表';

-- ----------------------------
-- Records of ebcms5_forum_moderator
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_forum_rethread
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_rethread`;
CREATE TABLE `ebcms5_forum_rethread` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thread_id` int(10) unsigned NOT NULL COMMENT 'FORUM_ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回帖用户ID',
  `content` text,
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  PRIMARY KEY (`id`),
  KEY `forum_id` (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ebcms5_forum_rethread
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_forum_thread
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_thread`;
CREATE TABLE `ebcms5_forum_thread` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '内容ID',
  `forum_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '标题',
  `keywords` char(70) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` char(250) NOT NULL DEFAULT '' COMMENT '内容描述',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP',
  `views` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览数',
  `rethreads` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '跟帖数',
  `eb_cache` text COMMENT '缓存',
  `rethread_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最新跟帖时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '修改时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '精华等级',
  `best` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '精华等级',
  `top` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '置顶',
  PRIMARY KEY (`id`),
  KEY `user` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ebcms5_forum_thread
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_forum_thread_body
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_thread_body`;
CREATE TABLE `ebcms5_forum_thread_body` (
  `id` int(11) unsigned NOT NULL,
  `detail` text NOT NULL COMMENT '帖子内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ebcms5_forum_thread_body
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_link_link
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_link_link`;
CREATE TABLE `ebcms5_link_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `info` varchar(255) NOT NULL DEFAULT '' COMMENT '其他信息',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '连接地址',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- ----------------------------
-- Records of ebcms5_link_link
-- ----------------------------
INSERT INTO `ebcms5_link_link` VALUES ('1', '友情链接', '易贝网站管理系统', '', '', '', 'http://www.ebcms.com/', '1479188905', '1479188905', '0', '1');
INSERT INTO `ebcms5_link_link` VALUES ('2', '友情链接', '开源CMS', '', '', '', 'http://www.ebcms.com/', '1479189038', '1479188937', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_manager
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_manager`;
CREATE TABLE `ebcms5_manager` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '后台人员ID',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT 'QQ号码',
  `nickname` char(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `login_times` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `login_ip` char(15) NOT NULL DEFAULT '' COMMENT '登陆ip地址',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登陆时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of ebcms5_manager
-- ----------------------------
INSERT INTO `ebcms5_manager` VALUES ('1', 'kujiw@qq.com', '管理员', '', '559461b6b41e9e4010dfb8f069cf0e2c', '1122', '182.150.164.222', '1512800940', '0', '0', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_mbzs
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_mbzs`;
CREATE TABLE `ebcms5_mbzs` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `form` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `remark` text COMMENT '说明',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='核心配置表';

-- ----------------------------
-- Records of ebcms5_mbzs
-- ----------------------------
INSERT INTO `ebcms5_mbzs` VALUES ('1', '广告', '头部banner', 'header_banner', 'http://static.ebcms.com/img/ad1.gif', 'upload', '首页头部广告', '1479041750', '1479037002', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('2', '广告', '首页栏目上方', 'index_panel_ad', 'http://static.ebcms.com/img/ad2.gif', 'upload', '首页栏目面板上方刚搞', '1479041759', '1479037071', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('3', '广告', '侧栏广告', 'side_ad', 'http://static.ebcms.com/img/ad3.gif', 'upload', '', '1479041767', '1479037097', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('5', '广告', '论坛帖子', 'index_forum', '{if condition=&quot;check_app(\'forum\')&quot;}\r\n&lt;style&gt;\r\n	.text-overflow{\r\n		display:block;\r\n		white-space:nowrap;\r\n		overflow:hidden;\r\n		text-overflow:ellipsis;\r\n	}\r\n&lt;/style&gt;\r\n{php}\r\n	$lists = \\app\\forum\\model\\Thread::with(\'forum,user\') -&gt; where([\'status\'=&gt;1,\'forum_id\'=&gt;[\'in\',\'1,2\']]) -&gt; order(\'id desc,rethread_time desc\') -&gt; limit(15) -&gt; select();\r\n{/php}\r\n&lt;table class=&quot;table table-bordered table-hover&quot; style=&quot;table-layout: fixed;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;th style=&quot;width: 130px;&quot;&gt;作者&lt;/th&gt;\r\n		&lt;th&gt;标题&lt;/th&gt;\r\n		&lt;th style=&quot;width: 140px;&quot; class=&quot;hidden-xs&quot;&gt;发帖时间&lt;/th&gt;\r\n		&lt;th style=&quot;width: 50px;&quot; class=&quot;hidden-xs&quot;&gt;阅读&lt;/th&gt;\r\n		&lt;th style=&quot;width: 50px;&quot; class=&quot;hidden-xs&quot;&gt;跟帖&lt;/th&gt;\r\n		&lt;th style=&quot;width: 140px;&quot; class=&quot;hidden-xs&quot;&gt;最后回帖&lt;/th&gt;\r\n	&lt;/tr&gt;\r\n	{foreach name=\'lists\' item=\'vo\'}\r\n	&lt;tr&gt;\r\n		&lt;td&gt;{notempty name=\'vo.user.nickname\'}&lt;a href=&quot;{$vo.user.space_url}&quot; class=&quot;text-overflow&quot;&gt;&lt;img src=&quot;{$vo.user.avatar|thumb=14,14,3}&quot; width=&quot;14&quot; height=&quot;14&quot; alt=&quot;&quot;&gt; {$vo.user.nickname}&lt;/a&gt;{else}&lt;img src=&quot;/system/image/avatar.gif&quot; width=&quot;14&quot; height=&quot;14&quot; alt=&quot;&quot;&gt; 游客{/notempty}&lt;/td&gt;\r\n		&lt;td&gt;&lt;a href=&quot;{$vo.forum.url}&quot; class=&quot;text-muted&quot;&gt;[{$vo.forum.title}]&lt;/a&gt;&amp;nbsp;&lt;a href=&quot;{$vo.url}&quot; style=&quot;{$vo.style}&quot;&gt;{$vo.title}&lt;/a&gt;&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.create_time|date=\'Y-m-d H:i\',###}&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.views}&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.rethreads2}&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.rethread_time|date=\'Y-m-d H:i\',###}&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	{/foreach}\r\n&lt;/table&gt;\r\n{/if}', 'tpl', '', '1502975931', '1501410271', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('6', '广告', '侧边广告', 'slide_ad', '&lt;p&gt;\r\n&lt;script type=&quot;text/javascript&quot; src=&quot;http://a.ebcms.com/mhzniieiekon.js&quot;&gt;&lt;/script&gt;\r\n&lt;/p&gt;', 'tpl', '', '1509623232', '1502974497', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('7', '广告', '内容页广告', 'content_ad', '&lt;p&gt;\r\n&lt;script type=&quot;text/javascript&quot; src=&quot;http://a.ebcms.com/mhzniieiekon.js&quot;&gt;&lt;/script&gt;\r\n&lt;/p&gt;', 'tpl', '', '1504179130', '1502976505', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('8', '广告', '调用指定栏目的文章', 'content_lists', '{php}\r\n    $data = \\app\\content\\model\\Content::where([\'channel_id\'=&gt;\'7\',\'status\'=&gt;1]) -&gt; limit(\'5\') -&gt; order(\'id desc\') -&gt; select();\r\n{/php}\r\n{foreach name=\'data\' item=\'vo\'}\r\n    文章标题：{$vo.title}\r\n{/foreach}', 'tpl', '', '1509623138', '1509623124', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_menu
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_menu`;
CREATE TABLE `ebcms5_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `url` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1675 DEFAULT CHARSET=utf8 COMMENT='导航表';

-- ----------------------------
-- Records of ebcms5_menu
-- ----------------------------
INSERT INTO `ebcms5_menu` VALUES ('3', '10', '账户管理', 'ebcms/manager/index', '53', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('4', '10', '角色管理', 'ebcms/group/index', '54', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('8', '10', '操作日志', 'ebcms/oplog/index', '52', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('10', '0', '系统', '', '2000', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('11', '10', '设置中心', 'ebcms/config/index', '83', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('22', '936', '应用商店', 'ebcms/store/index', '98', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('560', '10', '__DIVIDER__', '', '60', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('935', '10', '模型扩展', 'ebcms/extend/index', '81', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('936', '0', '模块', '', '3000', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1030', '936', '__DIVIDER__', '', '50', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1315', '10', '清理缓存', 'javascript:M.runtime();', '1', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1330', '10', '前台导航', 'ebcms/nav/index', '80', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1652', '0', '内容', '', '5000', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1653', '1652', '内容管理', 'content/admin.content/index', '9', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1654', '1652', '栏目管理', 'content/admin.channel/index', '8', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1655', '1652', '标签管理', 'content/admin.tag/index', '7', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1656', '1652', '属性管理', 'content/admin.attr/index', '0', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1657', '936', '内容管理', 'content/admin.content/index', '3', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1658', '936', '模板助手', 'mbzs/mbzs/index', '4', 'mbzs');
INSERT INTO `ebcms5_menu` VALUES ('1659', '936', '友情链接', 'link/admin.link/index', '3', 'link');
INSERT INTO `ebcms5_menu` VALUES ('1665', '936', '论坛管理', 'forum/admin.forum/index', '7', 'forum');
INSERT INTO `ebcms5_menu` VALUES ('1666', '936', '访客统计', 'tongji/tongji/index', '0', 'tongji');
INSERT INTO `ebcms5_menu` VALUES ('1671', '0', '会员', '', '7000', 'user');
INSERT INTO `ebcms5_menu` VALUES ('1672', '1671', '会员管理', 'user/admin.user/index', '1', 'user');
INSERT INTO `ebcms5_menu` VALUES ('1673', '1671', '流水管理', 'user/admin.currencylog/index', '0', 'user');
INSERT INTO `ebcms5_menu` VALUES ('1674', '1671', '评论管理', 'user/admin.comment/index', '0', 'user');

-- ----------------------------
-- Table structure for ebcms5_nav
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_nav`;
CREATE TABLE `ebcms5_nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_url` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `target` varchar(20) NOT NULL DEFAULT '' COMMENT '目标窗口',
  `eb_ext` text COMMENT '扩展',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COMMENT='功能菜单表';

-- ----------------------------
-- Records of ebcms5_nav
-- ----------------------------
INSERT INTO `ebcms5_nav` VALUES ('3', '主导航', '0', '官方论坛', 'https://www.ebcms.com/forum.html', '_blank', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '0', '');
INSERT INTO `ebcms5_nav` VALUES ('17', '用户中心', '0', '论坛', '', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('18', '用户中心', '17', '我的帖子', 'forum/user/thread', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '3', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('19', '用户中心', '17', '我的跟帖', 'forum/user/rethread', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '2', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('20', '个人空间', '0', '论坛', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('21', '个人空间', '20', '他的帖子', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('22', '主导航', '0', '论坛', 'forum/index/index', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('27', '用户中心', '0', '个人账户', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '50', '1', 'user');
INSERT INTO `ebcms5_nav` VALUES ('28', '用户中心', '27', '账户概况', 'user/currency/index', '', '{\"__config__\":{\"__test__\":\"test\"}}', '9', '1', 'user');
INSERT INTO `ebcms5_nav` VALUES ('29', '用户中心', '27', '账户流水', 'user/currency/log', '', '{\"__config__\":{\"__test__\":\"test\"}}', '8', '1', 'user');
INSERT INTO `ebcms5_nav` VALUES ('30', '用户中心', '27', '自助升级', 'user/gradebuy/index', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'user');

-- ----------------------------
-- Table structure for ebcms5_oplog
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_oplog`;
CREATE TABLE `ebcms5_oplog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '说明',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '动作',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  `ids` text COMMENT '提交的id',
  `request` text COMMENT '详细',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '执行状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_oplog
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_superpay
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_superpay`;
CREATE TABLE `ebcms5_superpay` (
  `sign` varchar(50) NOT NULL DEFAULT '' COMMENT '标志',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `expire_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '过期时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='购买记录表';

-- ----------------------------
-- Records of ebcms5_superpay
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_tongji_tongji
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_tongji_tongji`;
CREATE TABLE `ebcms5_tongji_tongji` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '网页标题',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `from` varchar(255) NOT NULL DEFAULT '' COMMENT '来源地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_tongji_tongji
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_user
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user`;
CREATE TABLE `ebcms5_user` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '邮箱',
  `nickname` char(20) NOT NULL DEFAULT '' COMMENT '昵称',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `motto` varchar(255) NOT NULL DEFAULT '' COMMENT '座右铭',
  `grade` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员等级',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `login_times` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `login_ip` char(15) NOT NULL DEFAULT '' COMMENT '登陆ip地址',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登陆时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `ext` text COMMENT '扩展信息',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of ebcms5_user
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_user_comment
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_comment`;
CREATE TABLE `ebcms5_user_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `key` varchar(255) NOT NULL DEFAULT '' COMMENT '标识',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '评论人id',
  `to_user_id` int(10) unsigned DEFAULT '0' COMMENT '回复对象id',
  `top_id` int(10) unsigned DEFAULT '0' COMMENT '顶级评论id',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父评论id',
  `content` text NOT NULL COMMENT '评论内容',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容评论表';

-- ----------------------------
-- Records of ebcms5_user_comment
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_user_currency
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_currency`;
CREATE TABLE `ebcms5_user_currency` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '后台人员ID',
  `jifen` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '积分',
  `jinbi` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '金币',
  `yuan` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '元',
  `bi1` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种1',
  `bi2` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种2',
  `bi3` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种3',
  `bi4` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种4',
  `bi5` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种5',
  `bi6` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种6',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户财富表';

-- ----------------------------
-- Records of ebcms5_user_currency
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_user_currency_log
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_currency_log`;
CREATE TABLE `ebcms5_user_currency_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `num` int(11) NOT NULL DEFAULT '0' COMMENT '数量',
  `currency` varchar(255) NOT NULL DEFAULT '' COMMENT '货币类型',
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作人id',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='财富日志表';

-- ----------------------------
-- Records of ebcms5_user_currency_log
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_user_message
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_message`;
CREATE TABLE `ebcms5_user_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `topic` varchar(255) NOT NULL DEFAULT '' COMMENT '主题',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `content` text COMMENT '消息内容',
  `isread` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息通知表';

-- ----------------------------
-- Records of ebcms5_user_message
-- ----------------------------
