/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : test

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2017-12-09 14:51:19
*/

SET AUTOCOMMIT=0;
SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for ebcms5_app
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_app`;
CREATE TABLE `ebcms5_app` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `app_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '应用ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `version` varchar(255) NOT NULL DEFAULT '' COMMENT '版本',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='已经安装的APP表';

-- ----------------------------
-- Records of ebcms5_app
-- ----------------------------
INSERT INTO `ebcms5_app` VALUES ('1', '1', '核心', 'ebcms', '1.8.6', '1479890844', '1475398105', '1');
INSERT INTO `ebcms5_app` VALUES ('2', '4', '内容管理系统', 'content', '1.1.4', '1499653848', '1499653848', '1');
INSERT INTO `ebcms5_app` VALUES ('3', '5', '模板助手', 'mbzs', '1.1.1', '1499653880', '1499653880', '1');
INSERT INTO `ebcms5_app` VALUES ('4', '6', '友情链接', 'link', '1.1.0', '1499653903', '1499653903', '1');
INSERT INTO `ebcms5_app` VALUES ('8', '8', '论坛', 'forum', '1.1.4', '1499659841', '1499659841', '1');
INSERT INTO `ebcms5_app` VALUES ('9', '16', '访问统计', 'tongji', '1.0.1', '1499918530', '1499918530', '1');
INSERT INTO `ebcms5_app` VALUES ('10', '12', '会员中心', 'user', '2.0.3', '1500370209', '1500370209', '1');
INSERT INTO `ebcms5_app` VALUES ('11', '13', '超级支付', 'superpay', '1.0.0', '1501421488', '1501421488', '1');

-- ----------------------------
-- Table structure for ebcms5_auth_access
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_access`;
CREATE TABLE `ebcms5_auth_access` (
  `uid` mediumint(8) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色权限表';

-- ----------------------------
-- Records of ebcms5_auth_access
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_group`;
CREATE TABLE `ebcms5_auth_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` char(100) NOT NULL DEFAULT '',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `rules` text COMMENT '规则',
  `c_rules` text COMMENT '栏目权限规则',
  `menus` text COMMENT '菜单权限',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of ebcms5_auth_group
-- ----------------------------
INSERT INTO `ebcms5_auth_group` VALUES ('1', '系统', '管理员', '', '1', '', '', '', '5');
INSERT INTO `ebcms5_auth_group` VALUES ('2', '系统', '工程师', '', '1', '', '', '', '4');
INSERT INTO `ebcms5_auth_group` VALUES ('3', '系统', '编辑', '', '1', '', '', '', '3');
INSERT INTO `ebcms5_auth_group` VALUES ('4', '系统', '客服', '', '1', '', '', '', '2');

-- ----------------------------
-- Table structure for ebcms5_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_rule`;
CREATE TABLE `ebcms5_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明',
  `name` char(80) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `condition` char(100) NOT NULL DEFAULT '',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  `opstr` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6714 DEFAULT CHARSET=utf8 COMMENT='权限规则表';

-- ----------------------------
-- Records of ebcms5_auth_rule
-- ----------------------------
INSERT INTO `ebcms5_auth_rule` VALUES ('1', '0', '后台', 'ebcms_api_index', '1', '', '10', 'ebcms', '后台');
INSERT INTO `ebcms5_auth_rule` VALUES ('2', '1', '配置管理', 'ebcms_config_index', '1', '', '0', 'ebcms', '配置管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('3', '2', '设置', 'ebcms_config_setting', '1', '', '0', 'ebcms', '系统设置');
INSERT INTO `ebcms5_auth_rule` VALUES ('34', '1', '扩展管理', 'ebcms_extend_index', '1', '', '0', 'ebcms', '扩展管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('35', '34', '添加', 'ebcms_extend_add', '1', '', '0', 'ebcms', '添加扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('36', '34', '修改', 'ebcms_extend_edit', '1', '', '0', 'ebcms', '修改扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('37', '34', '删除', 'ebcms_extend_delete', '1', '', '0', 'ebcms', '删除扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('40', '34', '排序', 'ebcms_extend_resort', '1', '', '0', 'ebcms', '排序扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('41', '1', '扩展字段管理', 'ebcms_extendfield_index', '1', '', '0', 'ebcms', '扩展字段管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('42', '41', '添加', 'ebcms_extendfield_add', '1', '', '0', 'ebcms', '添加扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('43', '41', '编辑', 'ebcms_extendfield_edit', '1', '', '0', 'ebcms', '修改扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('44', '41', '删除', 'ebcms_extendfield_delete', '1', '', '0', 'ebcms', '删除扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('45', '41', '变更状态', 'ebcms_extendfield_status', '1', '', '0', 'ebcms', '变更扩展字段状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('47', '41', '排序', 'ebcms_extendfield_resort', '1', '', '0', 'ebcms', '排序扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('48', '1', '后台首页', 'ebcms_index_index', '1', '', '0', 'ebcms', '后台首页');
INSERT INTO `ebcms5_auth_rule` VALUES ('49', '48', '主页', 'ebcms_index_main', '1', '', '0', 'ebcms', '主页');
INSERT INTO `ebcms5_auth_rule` VALUES ('50', '48', '删除缓存', 'ebcms_index_runtime', '1', '', '0', 'ebcms', '删除缓存');
INSERT INTO `ebcms5_auth_rule` VALUES ('51', '48', '修改自己的密码', 'ebcms_index_password', '1', '', '0', 'ebcms', '修改自己的密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('52', '48', '附件上传', 'ebcms_index_upload', '1', '', '0', 'ebcms', '附件上传');
INSERT INTO `ebcms5_auth_rule` VALUES ('53', '48', '编辑器附件上传', 'ebcms_index_ueditor', '1', '', '0', 'ebcms', '编辑器附件上传');
INSERT INTO `ebcms5_auth_rule` VALUES ('58', '1', '角色管理', 'ebcms_group_index', '1', '', '0', 'ebcms', '角色管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('59', '58', '添加', 'ebcms_group_add', '1', '', '0', 'ebcms', '添加角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('60', '58', '编辑', 'ebcms_group_edit', '1', '', '0', 'ebcms', '修改角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('61', '58', '删除', 'ebcms_group_delete', '1', '', '0', 'ebcms', '删除角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('62', '58', '分配权限', 'ebcms_group_rule', '1', '', '0', 'ebcms', '对角色分配权限');
INSERT INTO `ebcms5_auth_rule` VALUES ('63', '58', '分配菜单', 'ebcms_group_menu', '1', '', '0', 'ebcms', '对角色分配菜单权限');
INSERT INTO `ebcms5_auth_rule` VALUES ('64', '58', '变更状态', 'ebcms_group_status', '1', '', '0', 'ebcms', '审核角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('66', '58', '排序', 'ebcms_group_resort', '1', '', '0', 'ebcms', '对角色排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('72', '1318', '分配角色', 'ebcms_manager_group', '1', '', '0', 'ebcms', '给后台账户分配角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('77', '1', '操作日志管理', 'ebcms_oplog_index', '1', '', '0', 'ebcms', '操作日志管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('78', '77', '删除', 'ebcms_oplog_delete', '1', '', '0', 'ebcms', '删除操作日志');
INSERT INTO `ebcms5_auth_rule` VALUES ('79', '77', '查看详情', 'ebcms_oplog_show', '1', '', '0', 'ebcms', '查看操作日志');
INSERT INTO `ebcms5_auth_rule` VALUES ('862', '1', '导航管理', 'ebcms_nav_index', '1', '', '0', 'ebcms', '导航管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('863', '862', '添加', 'ebcms_nav_add', '1', '', '0', 'ebcms', '添加导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('864', '862', '编辑', 'ebcms_nav_edit', '1', '', '0', 'ebcms', '编辑导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('865', '862', '审核', 'ebcms_nav_status', '1', '', '0', 'ebcms', '审核导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('867', '862', '删除', 'ebcms_nav_delete', '1', '', '0', 'ebcms', '删除导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('1318', '1', '账户管理', 'ebcms_manager_index', '1', '', '3', 'ebcms', '账户管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('1319', '1318', '查看信息', 'ebcms_manager_info', '1', '', '0', 'ebcms', '查看后台账户信息');
INSERT INTO `ebcms5_auth_rule` VALUES ('1320', '1318', '添加', 'ebcms_manager_add', '1', '', '0', 'ebcms', '添加后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1321', '1318', '编辑', 'ebcms_manager_edit', '1', '', '0', 'ebcms', '编辑后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1322', '1318', '删除', 'ebcms_manager_delete', '1', '', '0', 'ebcms', '删除后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1323', '1318', '重置密码', 'ebcms_manager_password', '1', '', '0', 'ebcms', '重置后台账户密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('1324', '1318', '变更状态', 'ebcms_manager_status', '1', '', '0', 'ebcms', '变更后台账户状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('3636', '48', '发邮件', 'ebcms_index_email', '1', '', '0', 'ebcms', '发邮件');
INSERT INTO `ebcms5_auth_rule` VALUES ('6365', '862', '排序', 'ebcms_nav_resort', '1', '', '0', 'ebcms', '导航排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6595', '0', '内容管理系统', 'content', '1', '', '200', 'content', '内容管理系统');
INSERT INTO `ebcms5_auth_rule` VALUES ('6596', '6595', '内容管理', 'content_admin.content_index', '1', '', '0', 'content', '内容管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6597', '6596', '添加', 'content_admin.content_add', '1', '', '9', 'content', '添加内容');
INSERT INTO `ebcms5_auth_rule` VALUES ('6598', '6596', '编辑', 'content_admin.content_edit', '1', '', '8', 'content', '编辑内容');
INSERT INTO `ebcms5_auth_rule` VALUES ('6599', '6596', '批量移动', 'content_admin.content_move', '1', '', '0', 'content', '批量移动');
INSERT INTO `ebcms5_auth_rule` VALUES ('6600', '6596', '更改样式', 'content_admin.content_style', '1', '', '0', 'content', '更改样式');
INSERT INTO `ebcms5_auth_rule` VALUES ('6601', '6596', '删除', 'content_admin.content_delete', '1', '', '0', 'content', '内容删除');
INSERT INTO `ebcms5_auth_rule` VALUES ('6602', '6596', '设置属性', 'content_admin.content_attr', '1', '', '0', 'content', '设置内容属性');
INSERT INTO `ebcms5_auth_rule` VALUES ('6603', '6596', '变更状态', 'content_admin.content_status', '1', '', '0', 'content', '变更内容状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6604', '6595', '栏目管理', 'content_admin.channel_index', '1', '', '0', 'content', '栏目管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6605', '6604', '添加', 'content_admin.channel_add', '1', '', '9', 'content', '添加栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6606', '6604', '编辑', 'content_admin.channel_edit', '1', '', '0', 'content', '编辑栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6607', '6604', '栏目合并', 'content_admin.channel_merge', '1', '', '0', 'content', '合并栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6608', '6604', '删除', 'content_admin.channel_delete', '1', '', '0', 'content', '删除栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6609', '6604', '排序', 'content_admin.channel_resort', '1', '', '0', 'content', '栏目排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6610', '6604', '变更状态', 'content_admin.channel_status', '1', '', '0', 'content', '变更栏目状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6611', '6595', '标签管理', 'content_admin.tag_index', '1', '', '0', 'content', '标签管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6612', '6611', '删除', 'content_admin.tag_delete', '1', '', '0', 'content', '删除内容标签');
INSERT INTO `ebcms5_auth_rule` VALUES ('6613', '6611', '编辑', 'content_admin.tag_edit', '1', '', '0', 'content', '编辑内容标签');
INSERT INTO `ebcms5_auth_rule` VALUES ('6614', '6611', '推荐', 'content_admin.tag_recommend', '1', '', '0', 'content', '对内容标签执行推荐操作');
INSERT INTO `ebcms5_auth_rule` VALUES ('6615', '6611', '修改样式', 'content_admin.tag_style', '1', '', '0', 'content', '修改内容标签样式');
INSERT INTO `ebcms5_auth_rule` VALUES ('6616', '6611', '合并', 'content_admin.tag_merge', '1', '', '0', 'content', '合并内容标签');
INSERT INTO `ebcms5_auth_rule` VALUES ('6617', '6595', '属性管理', 'content_admin.attr_index', '1', '', '0', 'content', '属性管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6618', '6617', '内容移除', 'content_admin.attr_remove', '1', '', '0', 'content', '内容移除');
INSERT INTO `ebcms5_auth_rule` VALUES ('6619', '6617', '内容排序', 'content_admin.attr_resort', '1', '', '0', 'content', '内容排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6620', '0', '模板助手', 'mbzs', '1', '', '200', 'mbzs', '模板助手');
INSERT INTO `ebcms5_auth_rule` VALUES ('6621', '6620', '模板助手管理', 'mbzs_mbzs_index', '1', '', '0', 'mbzs', '模板助手管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6622', '6621', '变更状态', 'mbzs_mbzs_status', '1', '', '0', 'mbzs', '变更模板变量状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6623', '6621', '编辑', 'mbzs_mbzs_edit', '1', '', '0', 'mbzs', '编辑模板变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6624', '6621', '添加', 'mbzs_mbzs_add', '1', '', '0', 'mbzs', '添加模板助手变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6625', '6621', '删除', 'mbzs_mbzs_delete', '1', '', '0', 'mbzs', '删除模板助手变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6626', '6621', '排序', 'mbzs_mbzs_resort', '1', '', '0', 'mbzs', '模板助手变量排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6627', '0', '友情链接', 'link', '1', '', '40', 'link', '友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6628', '6627', '友情链接管理', 'link_admin.link_index', '1', '', '0', 'link', '友情链接管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6629', '6628', '删除', 'link_admin.link_delete', '1', '', '0', 'link', '删除友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6630', '6628', '编辑', 'link_admin.link_edit', '1', '', '0', 'link', '编辑友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6631', '6628', '添加', 'link_admin.link_add', '1', '', '0', 'link', '添加友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6632', '6628', '审核', 'link_admin.link_status', '1', '', '0', 'link', '审核友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6633', '6628', '排序', 'link_admin.link_resort', '1', '', '0', 'link', '友情链接排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6664', '0', '简易论坛', 'forum', '1', '', '100', 'forum', '简易论坛');
INSERT INTO `ebcms5_auth_rule` VALUES ('6665', '6664', '板块管理', 'forum_admin.forum_index', '1', '', '9', 'forum', '板块管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6666', '6665', '删除', 'forum_admin.forum_delete', '1', '', '0', 'forum', '删除板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6667', '6665', '排序', 'forum_admin.forum_resort', '1', '', '0', 'forum', '板块排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6668', '6665', '审核', 'forum_admin.forum_status', '1', '', '0', 'forum', '审核板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6669', '6665', '编辑', 'forum_admin.forum_edit', '1', '', '0', 'forum', '编辑板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6670', '6665', '删除版主', 'forum_admin.forum_delete_moderator', '1', '', '0', 'forum', '删除版主');
INSERT INTO `ebcms5_auth_rule` VALUES ('6671', '6665', '编辑版主', 'forum_admin.forum_edit_moderator', '1', '', '0', 'forum', '编辑版主');
INSERT INTO `ebcms5_auth_rule` VALUES ('6672', '6665', '添加版主', 'forum_admin.forum_add_moderator', '1', '', '0', 'forum', '添加版主');
INSERT INTO `ebcms5_auth_rule` VALUES ('6673', '6665', '添加', 'forum_admin.forum_add', '1', '', '0', 'forum', '添加板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6674', '6665', '开关论坛', 'forum_admin.forum_open', '1', '', '0', 'forum', '开关板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6675', '6665', '合并', 'forum_admin.forum_merge', '1', '', '0', 'forum', '合并板块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6676', '6665', '权限设置', 'forum_admin.forum_auth', '1', '', '0', 'forum', '板块权限设置');
INSERT INTO `ebcms5_auth_rule` VALUES ('6677', '0', '统计', 'tongji', '1', '', '3000', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6678', '6677', '统计', 'tongji_index', '1', '', '0', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6679', '6678', '查看浏览记录', 'tongji_index_index', '1', '', '0', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6680', '6678', '查看页面统计', 'tongji_index_tj', '1', '', '0', 'tongji', '查看页面统计');
INSERT INTO `ebcms5_auth_rule` VALUES ('6681', '6678', '删除统计数据', 'tongji_index_delete', '1', '', '0', 'tongji', '删除统计数据');
INSERT INTO `ebcms5_auth_rule` VALUES ('6698', '0', '用户模块', 'user', '1', '', '20', 'user', '用户模块');
INSERT INTO `ebcms5_auth_rule` VALUES ('6699', '6698', '用户管理', 'user_admin.user_index', '1', '', '2', 'user', '用户管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6700', '6699', '添加', 'user_admin.user_add', '1', '', '9', 'user', '添加会员');
INSERT INTO `ebcms5_auth_rule` VALUES ('6701', '6699', '编辑', 'user_admin.user_edit', '1', '', '8', 'user', '编辑会员信息');
INSERT INTO `ebcms5_auth_rule` VALUES ('6702', '6699', '变更财务', 'user_admin.user_currency', '1', '', '0', 'user', '变更会员财务');
INSERT INTO `ebcms5_auth_rule` VALUES ('6703', '6699', '发送消息', 'user_admin.user_msg', '1', '', '0', 'user', '向会员发送消息');
INSERT INTO `ebcms5_auth_rule` VALUES ('6704', '6699', '变更状态', 'user_admin.user_status', '1', '', '0', 'user', '变更会员状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6705', '6699', '删除', 'user_admin.user_delete', '1', '', '0', 'user', '删除会员');
INSERT INTO `ebcms5_auth_rule` VALUES ('6706', '6699', '重置密码', 'user_admin.user_password', '1', '', '0', 'user', '重置会员密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('6707', '6699', '查看详情', 'user_admin.user_info', '1', '', '0', 'user', '查看会员信息');
INSERT INTO `ebcms5_auth_rule` VALUES ('6708', '6698', '评论管理', 'user_admin.comment_index', '1', '', '1', 'user', '评论管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6709', '6708', '审核', 'user_admin.comment_status', '1', '', '0', 'user', '变更评论状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6710', '6708', '编辑', 'user_admin.comment_edit', '1', '', '0', 'user', '编辑评论');
INSERT INTO `ebcms5_auth_rule` VALUES ('6711', '6708', '删除', 'user_admin.comment_delete', '1', '', '0', 'user', '删除评论');
INSERT INTO `ebcms5_auth_rule` VALUES ('6712', '6698', '流水管理', 'user_admin.currencylog_index', '1', '', '0', 'user', '流水管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6713', '6712', '删除', 'user_admin.currencylog_delete', '1', '', '0', 'user', '删除流水');

-- ----------------------------
-- Table structure for ebcms5_config
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_config`;
CREATE TABLE `ebcms5_config` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `render` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `form` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '类型配置',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许用户配置',
  `remark` text COMMENT '说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1514 DEFAULT CHARSET=utf8 COMMENT='核心配置表';

-- ----------------------------
-- Records of ebcms5_config
-- ----------------------------
INSERT INTO `ebcms5_config` VALUES ('5', '系统配置@base', '1', '操作权限认证', 'auth_type', '1', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5b9e\\u65f6\\u8ba4\\u8bc1|1\\r\\n\\u767b\\u5f55\\u8ba4\\u8bc1|2\"}', '1', '实时认证更安全，登陆认证更高效', '80');
INSERT INTO `ebcms5_config` VALUES ('10', '邮箱配置@email', '1', '邮箱密码', 'password', 'zzeddixysnsnbhai', 'string', 'form_textbox', '', '1', '', '7');
INSERT INTO `ebcms5_config` VALUES ('11', '系统配置@base', '1', '操作日志记录', 'oplog_on', '1', 'bool', 'form_bool', '', '1', '', '1');
INSERT INTO `ebcms5_config` VALUES ('12', '邮箱配置@email', '1', '邮箱账号', 'name', 'market@ebcms.com', 'string', 'form_textbox', '', '1', '', '8');
INSERT INTO `ebcms5_config` VALUES ('13', '邮箱配置@email', '1', '发送者地址', 'from', 'market@ebcms.com', 'string', 'form_textbox', '', '1', '', '5');
INSERT INTO `ebcms5_config` VALUES ('14', '邮箱配置@email', '1', '发送者名称', 'fromname', '易贝科技', 'string', 'form_textbox', '', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('15', '邮箱配置@email', '1', '服务器', 'host', 'smtp.qq.com', 'string', 'form_textbox', '', '1', '', '60');
INSERT INTO `ebcms5_config` VALUES ('16', '邮箱配置@email', '1', '端口', 'port', '25', 'string', 'form_textbox', '', '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('17', '邮箱配置@email', '1', 'SMTP验证', 'smtpauth', '1', 'bool', 'form_bool', '', '1', '', '4');
INSERT INTO `ebcms5_config` VALUES ('18', '邮箱配置@email', '1', '允许HTML', 'html', '1', 'bool', 'form_bool', '', '1', '', '3');
INSERT INTO `ebcms5_config` VALUES ('19', '系统配置@base', '1', '备份目录', 'backup_path', './backup', 'string', 'form_textbox', '', '1', '相对于入口文件 index.php 的目录，备份目录请设置为可读可写！', '1');
INSERT INTO `ebcms5_config` VALUES ('23', '编辑器@ueditor', '1', '编辑器配置', 'config', '{\r\n&quot;iframeCssUrl&quot;:&quot;/third/bootstrap/css/bootstrap.min.css&quot;,\r\n&quot;initialStyle&quot;:&quot;body{margin:15px;}&quot;\r\n}', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"5\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '1', '请参考百度编辑器的配置文档 ueditor.config.js', '50');
INSERT INTO `ebcms5_config` VALUES ('24', '编辑器@ueditor', '1', '编辑器上传配置', 'upload', '', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"10\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '1', '参考百度编辑器的配置文件：config.json', '9');
INSERT INTO `ebcms5_config` VALUES ('25', 'SEO配置@seo', '2', '网站名称', 'sitename', '易贝内容管理系统', 'string', 'form_textbox', '', '1', '定义浏览器顶部标签显示的文字。对SEO友好。\r\n首页：网站名称 + 网站标题\r\n其他页面：页面标题 + 网站名称', '90');
INSERT INTO `ebcms5_config` VALUES ('26', 'SEO配置@seo', '2', '网站标题', 'title', '易贝内容管理系统|免费的内容管理系统|EBCMS|phpcms', 'string', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '1', '定义浏览器顶部标签显示的文字。对SEO友好。\r\n首页：网站名称 + 网站标题\r\n其他页面：页面标题 + 网站名称', '8');
INSERT INTO `ebcms5_config` VALUES ('27', 'SEO配置@seo', '2', '关键字', 'keywords', '易贝内容管理系统 内容管理系统 cms ebcms 开源cms', 'string', 'form_textbox', '', '1', '用空格或英文的逗号 , 分割。', '7');
INSERT INTO `ebcms5_config` VALUES ('28', 'SEO配置@seo', '2', '网站简介', 'description', '易贝内容管理系统是一套自由的功能灵活的开源的内容管理系统。', 'string', 'form_multitextbox', '', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1199', '基本配置@site', '2', '关闭网站', 'closed', '0', 'bool', 'form_bool', null, '1', '', '100');
INSERT INTO `ebcms5_config` VALUES ('1200', '基本配置@site', '2', '关闭原因', 'closed_reason', '系统维护中。。。', 'string', 'form_textbox', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1203', '验证码@captcha', '2', '加密密钥', 'seKey', 'http://www.ebcms.com', 'string', 'form_textbox', null, '0', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1204', '验证码@captcha', '2', '字符', 'codeSet', '2345678abcdefhijkmnpqrstuvwxyzABCDEFGHJKLMNPQRTUVWXY', 'string', 'form_textbox', null, '1', '2345678abcdefhijkmnpqrstuvwxyzABCDEFGHJKLMNPQRTUVWXY', '28');
INSERT INTO `ebcms5_config` VALUES ('1205', '验证码@captcha', '2', '有效期', 'expire', '18000', 'number', 'form_numberbox', null, '0', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1206', '验证码@captcha', '2', '是否使用中文', 'useZh', '0', 'bool', 'form_bool', null, '1', '', '26');
INSERT INTO `ebcms5_config` VALUES ('1207', '验证码@captcha', '2', '中文字符', 'zhSet', '们以我到他会作时要动国产的一是工就年阶义发成部民可出能方进在了不和有大这主中人上为来分生对于学下级地个用同行面说种过命度革而多子后自社加小机也经力线本电高量长党得实家定深法表着水理化争现所二起政三好十战无农使性前等反体合斗路图把结第里正新开论之物从当两些还天资事队批点育重其思与间内去因件日利相由压员气业代全组数果期导平各基或月毛然如应形想制心样干都向变关问比展那它最及外没看治提五解系林者米群头意只明四道马认次文通但条较克又公孔领军流入接席位情运器并飞原油放立题质指建区验活众很教决特此常石强极土少已根共直团统式转别造切九你取西持总料连任志观调七么山程百报更见必真保热委手改管处己将修支识病象几先老光专什六型具示复安带每东增则完风回南广劳轮科北打积车计给节做务被整联步类集号列温装即毫知轴研单色坚据速防史拉世设达尔场织历花受求传口断况采精金界品判参层止边清至万确究书术状厂须离再目海交权且儿青才证低越际八试规斯近注办布门铁需走议县兵固除般引齿千胜细影济白格效置推空配刀叶率述今选养德话查差半敌始片施响收华觉备名红续均药标记难存测士身紧液派准斤角降维板许破述技消底床田势端感往神便贺村构照容非搞亚磨族火段算适讲按值美态黄易彪服早班麦削信排台声该击素张密害侯草何树肥继右属市严径螺检左页抗苏显苦英快称坏移约巴材省黑武培著河帝仅针怎植京助升王眼她抓含苗副杂普谈围食射源例致酸旧却充足短划剂宣环落首尺波承粉践府鱼随考刻靠够满夫失包住促枝局菌杆周护岩师举曲春元超负砂封换太模贫减阳扬江析亩木言球朝医校古呢稻宋听唯输滑站另卫字鼓刚写刘微略范供阿块某功套友限项余倒卷创律雨让骨远帮初皮播优占死毒圈伟季训控激找叫云互跟裂粮粒母练塞钢顶策双留误础吸阻故寸盾晚丝女散焊功株亲院冷彻弹错散商视艺灭版烈零室轻血倍缺厘泵察绝富城冲喷壤简否柱李望盘磁雄似困巩益洲脱投送奴侧润盖挥距触星松送获兴独官混纪依未突架宽冬章湿偏纹吃执阀矿寨责熟稳夺硬价努翻奇甲预职评读背协损棉侵灰虽矛厚罗泥辟告卵箱掌氧恩爱停曾溶营终纲孟钱待尽俄缩沙退陈讨奋械载胞幼哪剥迫旋征槽倒握担仍呀鲜吧卡粗介钻逐弱脚怕盐末阴丰雾冠丙街莱贝辐肠付吉渗瑞惊顿挤秒悬姆烂森糖圣凹陶词迟蚕亿矩康遵牧遭幅园腔订香肉弟屋敏恢忘编印蜂急拿扩伤飞露核缘游振操央伍域甚迅辉异序免纸夜乡久隶缸夹念兰映沟乙吗儒杀汽磷艰晶插埃燃欢铁补咱芽永瓦倾阵碳演威附牙芽永瓦斜灌欧献顺猪洋腐请透司危括脉宜笑若尾束壮暴企菜穗楚汉愈绿拖牛份染既秋遍锻玉夏疗尖殖井费州访吹荣铜沿替滚客召旱悟刺脑措贯藏敢令隙炉壳硫煤迎铸粘探临薄旬善福纵择礼愿伏残雷延烟句纯渐耕跑泽慢栽鲁赤繁境潮横掉锥希池败船假亮谓托伙哲怀割摆贡呈劲财仪沉炼麻罪祖息车穿货销齐鼠抽画饲龙库守筑房歌寒喜哥洗蚀废纳腹乎录镜妇恶脂庄擦险赞钟摇典柄辩竹谷卖乱虚桥奥伯赶垂途额壁网截野遗静谋弄挂课镇妄盛耐援扎虑键归符庆聚绕摩忙舞遇索顾胶羊湖钉仁音迹碎伸灯避泛亡答勇频皇柳哈揭甘诺概宪浓岛袭谁洪谢炮浇斑讯懂灵蛋闭孩释乳巨徒私银伊景坦累匀霉杜乐勒隔弯绩招绍胡呼痛峰零柴簧午跳居尚丁秦稍追梁折耗碱殊岗挖氏刃剧堆赫荷胸衡勤膜篇登驻案刊秧缓凸役剪川雪链渔啦脸户洛孢勃盟买杨宗焦赛旗滤硅炭股坐蒸凝竟陷枪黎救冒暗洞犯筒您宋弧爆谬涂味津臂障褐陆啊健尊豆拔莫抵桑坡缝警挑污冰柬嘴啥饭塑寄赵喊垫丹渡耳刨虎笔稀昆浪萨茶滴浅拥穴覆伦娘吨浸袖珠雌妈紫戏塔锤震岁貌洁剖牢锋疑霸闪埔猛诉刷狠忽灾闹乔唐漏闻沈熔氯荒茎男凡抢像浆旁玻亦忠唱蒙予纷捕锁尤乘乌智淡允叛畜俘摸锈扫毕璃宝芯爷鉴秘净蒋钙肩腾枯抛轨堂拌爸循诱祝励肯酒绳穷塘燥泡袋朗喂铝软渠颗惯贸粪综墙趋彼届墨碍启逆卸航衣孙龄岭骗休借', 'string', 'form_multitextbox', null, '1', '', '24');
INSERT INTO `ebcms5_config` VALUES ('1208', '验证码@captcha', '2', '背景混淆', 'useImgBg', '1', 'bool', 'form_bool', null, '1', '', '18');
INSERT INTO `ebcms5_config` VALUES ('1209', '验证码@captcha', '2', '字体大小', 'fontSize', '25', 'number', 'form_numberbox', null, '0', '', '16');
INSERT INTO `ebcms5_config` VALUES ('1210', '验证码@captcha', '2', '曲线混淆', 'useCurve', '1', 'bool', 'form_bool', null, '1', '', '22');
INSERT INTO `ebcms5_config` VALUES ('1211', '验证码@captcha', '2', '杂点混淆', 'useNoise', '1', 'bool', 'form_bool', null, '1', '', '20');
INSERT INTO `ebcms5_config` VALUES ('1212', '验证码@captcha', '2', '图片高', 'imageH', '0', 'number', 'form_numberbox', null, '0', '', '14');
INSERT INTO `ebcms5_config` VALUES ('1213', '验证码@captcha', '2', '图片宽', 'imageW', '0', 'number', 'form_numberbox', null, '0', '', '12');
INSERT INTO `ebcms5_config` VALUES ('1214', '验证码@captcha', '2', '字符数', 'length', '4', 'number', 'form_numberbox', null, '1', '', '30');
INSERT INTO `ebcms5_config` VALUES ('1215', '验证码@captcha', '2', '字体', 'fontttf', '', 'string', 'form_textbox', null, '0', '', '10');
INSERT INTO `ebcms5_config` VALUES ('1216', '验证码@captcha', '2', '背景色', 'bg', '243\r\n251\r\n254', 'item', 'form_multitextbox', null, '0', 'rgb色  一行一个。\r\n243\r\n251\r\n254', '8');
INSERT INTO `ebcms5_config` VALUES ('1217', '验证码@captcha', '2', '验证重置', 'reset', '1', 'bool', 'form_bool', null, '0', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1377', '路由配置@route', '2', '路由模式', 'model', '1', 'number', 'form_radio', '{\"values\":\"普通模式|0\\r\\n应用模式|1\"}', '1', '', '50');
INSERT INTO `ebcms5_config` VALUES ('1378', '路由配置@route', '2', '自定义路由', 'rules', '/|index/index/index\r\nuser_reg|user/auth/reg\r\nuser_login|user/auth/login', 'string', 'form_multitextbox', '{\"height\":\"15\",\"width\":\"\",\"prompt\":\"\"}', '1', '非专业人士，请不要随意定义，否则可能导致无法访问！\r\n用竖线分割 一行一个，例如：\r\nuser_reg|user/auth/reg\r\nuser_login|user/auth/login', '0');
INSERT INTO `ebcms5_config` VALUES ('1418', '基本配置@site', '2', '手机版', 'mobile', '0', 'bool', 'form_bool', null, '1', '开启手机版后，手机访问会自动定位到 当前模板主题对应的移动端模板 例如：default_mobile', '7');
INSERT INTO `ebcms5_config` VALUES ('1419', '基本配置@site', '2', '模板主题', 'theme', 'default', 'string', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$path = ROOT_PATH . \'templates\' . DS;\\r\\n\\t$dirs = scandir($path);\\r\\n\\t$res = [];\\r\\n\\t$thumbs = [];\\r\\n\\tforeach($dirs as $k){\\r\\n\\t\\tif(!in_array($k,[\'.\',\'..\']) &amp;&amp; !preg_match(&quot;\\/[\\\\x7f-\\\\xff]\\/&quot;, $k) &amp;&amp; is_dir($path . $k)){\\r\\n\\t\\t\\tif(\'_mobile\' != substr($k,-7)){\\r\\n\\t\\t\\t\\t$res[] = $k;\\r\\n\\t\\t\\t\\t$thumb = $path . $k . DS . \'thumb.png\';\\r\\n\\t\\t\\t\\t$thumb = is_file($thumb)?$thumb:\'.\\/system\\/image\\/nopic.gif\';\\r\\n\\t\\t\\t\\t$img_info = getimagesize($thumb);\\r\\n\\t\\t\\t\\t$thumbs[$k] = \'data:\' . $img_info[\'mime\'] . \';base64,\' . base64_encode(file_get_contents($thumb));\\r\\n\\t\\t\\t}\\r\\n\\t\\t}\\r\\n\\t}\\r\\n{\\/php}\\r\\n&lt;div style=&quot;clear: both;overflow: hidden;&quot;&gt;\\r\\n{foreach name=\'res\' item=\'v\'}\\r\\n\\t&lt;div class=&quot;thumbnail&quot; onclick=&quot;$(this).css(\'border\', \'1px solid red\').siblings().css(\'border\', \'1px solid #ddd\');$(\'#{$field.unique}\').val(\'{$v}\');&quot; style=&quot;width:13em;float:left;cursor: pointer; margin-right:10px;{eq name=&quot;field.value&quot; value=\'$v\'}border:1px solid red;{\\/eq}&quot;&gt;\\r\\n\\t\\t&lt;img src=&quot;{$thumbs[$v]}&quot; alt=&quot;{$v}&quot; style=&quot;width: 100%;height: 10em;&quot;&gt;\\r\\n\\t\\t&lt;div class=&quot;caption&quot;&gt;\\r\\n\\t\\t\\t&lt;h4 class=&quot;text-center&quot;&gt;{$v}&lt;\\/h4&gt;\\r\\n\\t\\t&lt;\\/div&gt;\\r\\n\\t&lt;\\/div&gt;\\r\\n{\\/foreach}\\r\\n&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot; value=&quot;{$field.value}&quot;&gt;\"}', '1', '模板位于templates目录下', '8');
INSERT INTO `ebcms5_config` VALUES ('1420', '常规配置', '3', 'URL模式', 'url_model', '2', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"普通模式|0\\r\\n标准模式|1\\r\\n高级模式|2\"}', '1', '普通模式不走路由，标准模式是常规路由，高级模式支持自定义文件夹和文件名。', '30');
INSERT INTO `ebcms5_config` VALUES ('1421', '常规配置', '3', '是否记录点击', 'click_record', '1', 'bool', 'form_bool', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1422', '常规配置', '3', '内容属性', 'attr', '头条\r\n幻灯\r\n请在设置中心设置默认数据', 'item', 'form_multitextbox', null, '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1423', '友情链接', '4', '开启验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '2');
INSERT INTO `ebcms5_config` VALUES ('1424', '友情链接', '4', '开启在线申请', 'apply', '1', 'bool', 'form_bool', null, '1', '', '1');
INSERT INTO `ebcms5_config` VALUES ('1453', '基本配置', '8', '开启论坛', 'open', '1', 'bool', 'form_bool', null, '1', '特殊时期可关闭，关闭后，不能发帖，不能跟帖，不能评论，只能查看！', '20');
INSERT INTO `ebcms5_config` VALUES ('1454', '基本配置', '8', '游客附件上传', 'guest_upload', '0', 'bool', 'form_bool', null, '1', '通常请不要让游客上传附件。', '19');
INSERT INTO `ebcms5_config` VALUES ('1455', '基本配置', '8', '敏感词处理方式', 'badwords_handle', '1', 'number', 'form_radio', '{\"values\":\"禁止提交|0\\r\\n进入审核|1\\r\\n直接替换|2\\r\\n不用处理|99\"}', '1', '', '10');
INSERT INTO `ebcms5_config` VALUES ('1456', '奖励配置', '8', '发帖奖励', 'thread_add_currency', 'jifen:10', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\njifen:10\njinbi:1', '10');
INSERT INTO `ebcms5_config` VALUES ('1457', '基本配置', '8', '敏感词', 'badwords', '麻痹=***\n共产党=***\n你妈=我妈\n狗日=***\n日你=日我\n傻逼=***我是傻逼***', 'ini', 'form_multitextbox', null, '1', '一行一个，用 = 分割：例如\n你麻痹=***\n共产党=***\n草你妈=草我马', '9');
INSERT INTO `ebcms5_config` VALUES ('1458', '奖励配置', '8', '跟帖奖励', 'rethread_add_currency', 'jifen:1', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\njifen:10\njinbi:1', '8');
INSERT INTO `ebcms5_config` VALUES ('1459', '基本配置', '8', '附件类型', 'upload_ext', 'jpg\r\npng\r\ngif\r\njpeg\r\nzip\r\nrar', 'item', 'form_multitextbox', null, '1', '一行一个，例如：\r\njpg\r\npng\r\ngif', '0');
INSERT INTO `ebcms5_config` VALUES ('1460', '基本配置', '9', '是否开启', 'on', '1', 'bool', 'form_bool', null, '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1487', '基本配置@base', '11', '会员等级', 'grade', '1:普通会员\r\n2:高级会员\r\n3:金牌会员\r\n4:钻石会员', 'item', 'form_multitextbox', null, '1', '一行一个，形如 数字:等级名称，例如：\r\n1:普通会员\r\n2:高级会员\r\n3:金牌会员\r\n4:钻石会员', '99');
INSERT INTO `ebcms5_config` VALUES ('1488', '注册@reg', '11', '是否允许注册', 'on', '1', 'bool', 'form_bool', null, '1', '', '98');
INSERT INTO `ebcms5_config` VALUES ('1489', '登录@login', '11', '登陆验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '97');
INSERT INTO `ebcms5_config` VALUES ('1490', '找回密码@password', '11', '表单验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '96');
INSERT INTO `ebcms5_config` VALUES ('1491', '修改信息@edit', '11', '表单验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '95');
INSERT INTO `ebcms5_config` VALUES ('1492', '评论配置@comment', '11', '是否开启评论', 'on', '1', 'bool', 'form_bool', null, '1', '', '94');
INSERT INTO `ebcms5_config` VALUES ('1493', '自助升级@gradebuy', '11', '是否开启', 'allow', '1', 'bool', 'form_bool', null, '1', '开启后才可以进行会员自助购买。', '93');
INSERT INTO `ebcms5_config` VALUES ('1494', '注册@reg', '11', '邮箱验证', 'email_verify', '1', 'bool', 'form_bool', null, '1', '', '10');
INSERT INTO `ebcms5_config` VALUES ('1495', '注册@reg', '11', '注册验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1496', '登录@login', '11', '登陆奖励', 'jiangli', 'jifen:1', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:1\r\njinbi:1', '9');
INSERT INTO `ebcms5_config` VALUES ('1497', '找回密码@password', '11', '邮件模板', 'email_tpl', '&lt;p&gt;尊敬的用户，您的邮箱认证码是：&lt;span style=&quot;color: rgb(255, 0, 0);&quot;&gt;&lt;strong&gt;{$code}&lt;/strong&gt;&lt;/span&gt;，请勿泄露给他人，若非本人操作，请忽略！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"200\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1498', '基本配置@base', '11', '币种类型', 'currency', 'jifen:积分\r\njinbi:金币\r\nyuan:余额', 'item', 'form_multitextbox', '{\"height\":\"\",\"width\":\"\",\"prompt\":\"\"}', '1', '自带jifen jinbi yuan三种内置币种，以及 bi1 bi2 bi3 bi4 bi5 bi6 六个自定义扩展币种', '9');
INSERT INTO `ebcms5_config` VALUES ('1499', '评论配置@comment', '11', '允许评论', 'auth', '[\"0\"]', 'json', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n\\t$my_grades[0] = \'\\u6e38\\u5ba2\';\\r\\n\\t$tmp = json_decode($field[\'value\'],true);\\r\\n{\\/php}\\r\\n{foreach name=\'my_grades\' item=\'grade\'}\\r\\n\\t&lt;label class=&quot;checkbox-inline&quot; for=&quot;{$field.unique}_{$key}&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;checkbox&quot; id=&quot;{$field.unique}_{$key}&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$key}&quot; {if condition=&quot;in_array($key,(Array)$tmp)&quot;}checked{\\/if} &gt; {$grade}\\r\\n\\t&lt;\\/label&gt;\\r\\n{\\/foreach}\"}', '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1500', '注册@reg', '11', '默认用户组', 'grade', '1', 'number', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '1', '', '8');
INSERT INTO `ebcms5_config` VALUES ('1501', '评论配置@comment', '11', '无须验证码', 'captcha', '', 'json', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n\\t$my_grades[0] = \'\\u6e38\\u5ba2\';\\r\\n\\t$tmp = json_decode($field[\'value\'],true);\\r\\n{\\/php}\\r\\n{foreach name=\'my_grades\' item=\'grade\'}\\r\\n\\t&lt;label class=&quot;checkbox-inline&quot; for=&quot;{$field.unique}_{$key}&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;checkbox&quot; id=&quot;{$field.unique}_{$key}&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$key}&quot; {if condition=&quot;in_array($key,(Array)$tmp)&quot;}checked{\\/if} &gt; {$grade}\\r\\n\\t&lt;\\/label&gt;\\r\\n{\\/foreach}\"}', '1', '', '8');
INSERT INTO `ebcms5_config` VALUES ('1502', '自助升级@gradebuy', '11', '参数配置', 'config', '{\"1\":{\"value\":\"10\",\"currency\":\"jifen\"},\"2\":{\"value\":\"100\",\"currency\":\"jifen\"},\"3\":{\"value\":\"500\",\"currency\":\"jifen\"},\"4\":{\"value\":\"5000\",\"currency\":\"jifen\"}}', 'json', 'form_custom', '{\"html\":\"{php}\\r\\n$grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n$currency = \\\\ebcms\\\\Config::get(\'user.base.currency\');\\r\\n$res = [];\\r\\n$_value = json_decode($field[\'value\'],true);\\r\\nforeach($grades as $k =&gt; $title){\\r\\n\\t$res[] = [\\r\\n\\t\\t\'title\'=&gt;$title,\\r\\n\\t\\t\'field\'=&gt;$field[\'field\'].\'[\'.$k.\']\',\\r\\n\\t\\t\'value\'=&gt; isset($_value[$k][\'value\'])?$_value[$k][\'value\']:\'\',\\r\\n\\t\\t\'currency\'=&gt; isset($_value[$k][\'currency\'])?$_value[$k][\'currency\']:\'jifen\',\\r\\n\\t];\\r\\n}\\r\\n{\\/php}\\r\\n{foreach name=\'res\' item=\'vo\'}\\r\\n&lt;div class=&quot;row&quot; style=&quot;padding-bottom:15px;&quot;&gt;\\r\\n\\t&lt;div class=&quot;col-md-3&quot;&gt;\\r\\n\\t\\t\\u5347\\u7ea7\\u5230&lt;b&gt;\\u3010{$vo.title}\\u3011&lt;\\/b&gt;\\u9700\\u8981\\r\\n\\t&lt;\\/div&gt;\\r\\n\\t&lt;div class=&quot;col-md-3&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;{$field.unique}_{$key}&quot; name=&quot;{$vo.field}[value]&quot; value=&quot;{$vo.value}&quot; placeholder=&quot;&quot;&gt;\\r\\n\\t&lt;\\/div&gt;\\r\\n\\t&lt;div class=&quot;col-md-6&quot;&gt;\\r\\n\\t\\t{foreach name=\'currency\' item=\'cu\' key=\'cur\'}\\r\\n\\t\\t\\t&lt;label class=&quot;radio-inline&quot; for=&quot;{$field.unique}_{$key}_{$cur}&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;radio&quot; id=&quot;{$field.unique}_{$key}_{$cur}&quot; name=&quot;{$vo.field}[currency]&quot; value=&quot;{$cur}&quot; {eq name=&quot;vo.currency&quot; value=\'$cur\'}checked{\\/eq}&gt; {$cu}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t{\\/foreach}\\r\\n\\t&lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n{\\/foreach}\"}', '1', '数值填空，则表示不允许购买改会员组', '8');
INSERT INTO `ebcms5_config` VALUES ('1503', '注册@reg', '11', '注册奖励', 'jiangli', 'jifen:10', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '7');
INSERT INTO `ebcms5_config` VALUES ('1504', '评论配置@comment', '11', '消息通知模板', 'notice_tpl', '&lt;span class=&quot;text-danger&quot;&gt;&lt;b&gt;您的评论&lt;/b&gt;&lt;/span&gt;：{$comment_p.content}\r\n&lt;br/&gt;\r\n&lt;span class=&quot;text-danger&quot;&gt;&lt;b&gt;他的回复&lt;/b&gt;&lt;/span&gt;：{$comment.content}\r\n&lt;br/&gt;\r\n&lt;span class=&quot;text-muted&quot;&gt;回复人：&lt;a href=&quot;{$comment.user.space_url}&quot;&gt;{$comment.user.nickname|default=&quot;游客&quot;}&lt;/a&gt; 回复时间：{$comment.create_time|date=\'Y-m-d H:i:s\',###} &lt;/span&gt;', 'string', 'form_multitextbox', null, '1', '被回复 comment_p\r\n当前回复 comment', '7');
INSERT INTO `ebcms5_config` VALUES ('1505', '注册@reg', '11', '注册验证邮件模板', 'email_tpl', '&lt;p&gt;尊敬的用户，您的邮箱认证码是：&lt;span style=&quot;color: rgb(255, 0, 0);&quot;&gt;&lt;strong&gt;{$code}&lt;/strong&gt;&lt;/span&gt;，请勿泄露给他人，若非本人操作，请忽略！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"200\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1506', '评论配置@comment', '11', '铭感词处理', 'badwords_handle', '1', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"禁止提交|0\\r\\n进入审核|1\\r\\n直接替换|2\\r\\n不用处理|99\"}', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1507', '注册@reg', '11', '注册成功消息模板', 'success_msg', '&lt;p&gt;尊敬的会员:{$user.nickname}，你好，你注册的邮箱是 {$user.email} 欢迎注册！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"200\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '1', '', '5');
INSERT INTO `ebcms5_config` VALUES ('1508', '评论配置@comment', '11', '敏感词', 'badwords', '麻痹=***\r\n共产党=***\r\n你妈=我妈\r\n狗日=***\r\n日你=日我\r\n傻逼=***我是傻逼***', 'ini', 'form_multitextbox', null, '1', '一行一个 用‘=’分割\r\n左侧敏感词 右侧替换内容', '5');
INSERT INTO `ebcms5_config` VALUES ('1509', '评论配置@comment', '11', '评论奖励', 'jiangli', 'jifen:1', 'item', 'form_multitextbox', null, '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '0');
INSERT INTO `ebcms5_config` VALUES ('1510', '推广奖励@promote', '11', '关闭推广', 'promote_closed', '0', 'bool', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5f00\\u542f|0\\r\\n\\u5173\\u95ed|1\"}', '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1511', '推广奖励@promote', '11', '访问奖励', 'promote_access_ncentive', 'jifen:1', 'item', 'form_multitextbox', '{\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"\",\"width\":\"\",\"prompt\":\"\"}', '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '0');
INSERT INTO `ebcms5_config` VALUES ('1512', '推广奖励@promote', '11', '注册奖励', 'promote_reg_ncentive', 'jifen:50', 'item', 'form_multitextbox', '[]', '1', '根据您配置的币种类型，自定义奖励，支持多种币种同时奖励，例如：\r\njifen:10\r\njinbi:1', '0');
INSERT INTO `ebcms5_config` VALUES ('1513', '基本配置', '12', '安全模式', 'safe_mode', '1', 'bool', 'form_bool', null, '1', '安全性更高', '0');

-- ----------------------------
-- Table structure for ebcms5_configcate
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_configcate`;
CREATE TABLE `ebcms5_configcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `name` varchar(255) NOT NULL DEFAULT 'Common' COMMENT '生效应用',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许用户配置',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='核心配置分类表';

-- ----------------------------
-- Records of ebcms5_configcate
-- ----------------------------
INSERT INTO `ebcms5_configcate` VALUES ('1', '系统配置', '系统配置', 'system', '', '1', '90', 'ebcms');
INSERT INTO `ebcms5_configcate` VALUES ('2', '应用配置', '前台配置', 'home', '', '1', '85', 'ebcms');
INSERT INTO `ebcms5_configcate` VALUES ('3', '应用配置', '内容管理系统', 'content', '', '1', '1', 'content');
INSERT INTO `ebcms5_configcate` VALUES ('4', '应用配置', '友情链接', 'link', '', '1', '2', 'link');
INSERT INTO `ebcms5_configcate` VALUES ('8', '应用配置', '简易论坛', 'forum', '', '1', '0', 'forum');
INSERT INTO `ebcms5_configcate` VALUES ('9', '应用配置', '访客统计', 'tongji', '', '1', '0', 'tongji');
INSERT INTO `ebcms5_configcate` VALUES ('11', '应用配置', '会员配置', 'user', '', '1', '7', 'user');
INSERT INTO `ebcms5_configcate` VALUES ('12', '应用配置', '超级支付', 'superpay', '', '1', '0', 'superpay');

-- ----------------------------
-- Table structure for ebcms5_content_attr
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_attr`;
CREATE TABLE `ebcms5_content_attr` (
  `content_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  `attr` varchar(255) NOT NULL DEFAULT '' COMMENT '属性',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容属性表';

-- ----------------------------
-- Records of ebcms5_content_attr
-- ----------------------------
INSERT INTO `ebcms5_content_attr` VALUES ('6', '幻灯', '9');
INSERT INTO `ebcms5_content_attr` VALUES ('5', '幻灯', '8');
INSERT INTO `ebcms5_content_attr` VALUES ('6', '头条', '0');
INSERT INTO `ebcms5_content_attr` VALUES ('5', '头条', '9');
INSERT INTO `ebcms5_content_attr` VALUES ('4', '头条', '33');
INSERT INTO `ebcms5_content_attr` VALUES ('4', '幻灯', '7');

-- ----------------------------
-- Table structure for ebcms5_content_body
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_body`;
CREATE TABLE `ebcms5_content_body` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `body` text COMMENT '内容主体',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8 COMMENT='内容副表';

-- ----------------------------
-- Records of ebcms5_content_body
-- ----------------------------
INSERT INTO `ebcms5_content_body` VALUES ('1', '&lt;p&gt;外媒称，美国海军14日宣布，海军作战部长约翰·理查森上将即将访问中国，以探讨南中国海安全事宜。&lt;br/&gt;&lt;br/&gt;　　据美国《星条旗报》网站7月14日报道，一份海军新闻稿说，理查森在三天访问期间将参观中国人民解放军海军设施，并与解放军海军司令员吴胜利上将举行会晤。&lt;br/&gt;&lt;br/&gt;　　除南中国海议题外，两位上将预计还将探讨其他争议性较小的议题，包括最近举行的“环太平洋”联合军事演习。&lt;br/&gt;&lt;br/&gt;　　理查森将于7月17日起访问北京和青岛。这是他首次访华。&lt;br/&gt;&lt;br/&gt;　　根据海军新闻稿，理查森将参观中国的海军潜艇学院以及航空母舰辽宁舰。&lt;br/&gt;&lt;br/&gt;　　另据法新社7月15日报道，美国海军14日表示，美国和中国海军的指挥官将举行会晤。&lt;br/&gt;&lt;br/&gt;　　海军作战部长约翰·理查森上将即将从17日起对北京和沿海城市青岛进行为期三天的访问，其间将与中国海军司令员吴胜利举行会晤。&lt;br/&gt;&lt;br/&gt;　　北京被海牙仲裁庭12日作出的裁决所激怒，裁决认为中国对南中国海的主权主张是无效的。&lt;br/&gt;&lt;br/&gt;　　拥有世界上最大规模海军力量的美国在该地区派驻有军舰。从去年起，它还在该地区进行了三次“航行自由”行动，派遣军舰进入北京在南中国海修筑的人工岛12海里范围内，以显示华盛顿不接受中国的领土主权主张。&lt;br/&gt;&lt;br/&gt;　　尽管紧张态势不断加剧，但中美海军之间仍然保持着联系，试图将发生任何误解的风险降到最低。&lt;br/&gt;&lt;br/&gt;　　中国受邀参加了今年的“环太平洋”军事演习，目前该演习正在夏威夷和加利福尼亚之间的海域举行。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('2', '&lt;p&gt;土耳其7月15日晚发生一起未遂军事政变，导致至少161人死亡和1440人受伤。16日，土政府指责流亡美国的土耳其宗教人士费特胡拉·居伦（Fethullah Gulen）在幕后策划这次政变，使土美关系出现紧张迹象，并封锁了美国在土耳其的空军基地，白宫为此召开紧急会议。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 据俄罗斯卫星新闻网17日报道，美国驻土耳其领事馆16日说，在发生军人政变后，美国在土耳其南部的因斯里克空军基地被封锁，基地电力供应也被切断。美国官员称，因土耳其领空关闭，美国暂停对IS实施空中打击。&amp;nbsp;&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;资料图：美国在土耳其南部的因斯里克空军基地&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 另据新华网7月17日消息，美国时间7月16日，白宫发表声明说，奥巴马7月16日在白宫紧急召集其国家安全顾问班子开会，专门听取有关土耳其最新局势的汇报。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 美国总统奥巴马当日重申，美国“坚定不移地”支持土耳其的民选政府，希望美土双方在应对共同挑战方面继续合作。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 尽管迄今美方没有收到有关美国人在这次政变中死伤的报告，但奥巴马指示其国安班子继续与土耳其相关部门合作，确保美在土外交人员、军人及家属的安全。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 声明说，美国同时呼吁土耳其各方在法治框架内行事，避免采取会导致进一步暴力和局势动荡的行动。奥巴马还强调，在联合打击恐怖主义等应对共同挑战方面，美土双方需要继续合作。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 土耳其政变使土美关系出现紧张迹象。这次白宫会议是在有报道说土政府封锁了美军驻扎的因吉尔利克空军基地后举行的。美军利用该基地对叙利亚境内的极端组织“伊斯兰国”武装发动空袭。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 土耳其流亡美国宗教人士被指远程策划政变&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 土政府指责流亡美国的土耳其人费特胡拉·居伦在幕后策划这次政变，要求美政府将他引渡回土耳其。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 美国务卿克里7月16日在卢森堡表示，美将考虑这个引渡请求，但美国尚未收到证明居伦有罪的证据。&amp;nbsp;&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 而费特胡拉·居伦本人则表示与政变无关，并强烈谴责土耳其的政变行为。他说，作为一个饱受多次军事政变折磨的人，如果我被指控与本次政变有关联，这是相当侮辱的。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 他还表示，政府应当由自由公平的选举来产生，而非武力。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 近期勿前往土耳其旅游&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 美国国务院16日还发布了旅游警告，建议美国公民目前重新考虑是否到土耳其旅游。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 中国外交部及中国驻土耳其大使馆网站早在今年5月16日就曾发布最新旅游警告，提醒中国公民在近期谨慎前往土耳其、暂勿前往土耳其东南部和土耳其叙利亚边境地区，该提醒有效期至2016年11月16日。（综合/观察者网 周远方）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('3', '&lt;p&gt;最近美帝国主义两艘航母战斗群公然闯入南海，耀武扬威的嘴脸令人发指，再加上南海仲裁对中国非常不利，这两件事牵动了无数中国人的心，一时间中美开战的舆论“甚嚣尘上”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;如果因为南海问题真的打起来了，中国的胜算有几何？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;得出结论之前，先做如下考虑：&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;第一，孰叫胜，孰叫败？现代的战争，军事上的胜败远不是最终的评判标准。最终的评判标准，应该是谁在战争中获取了更多的政治利益和战略利益！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;第二，战争的形式问题。毫无疑问，军事行动应该是战争的直接形式，但是，现代战争还有政治、经济、金融、文化等等表现方式。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;那么，单纯从军事上说，美国就一定能打败中国吗？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;如这场战争发生在中国家门口，美国绝无完胜的把握。理由有二：&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;一，美国的后勤补给线，无法支撑一场大规模且耗时漫长，并充满危险的战争。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;二，情报系统的不确定性，将影响美军的指挥协调能力。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;武器对比方面，中国自1996年后的知耻后进奋发图强终于弥补了和美军的代差，看看央视播放演习镜头里的鹰击12反舰导弹，看看苏30MKKII，歼16D，看看运20和红旗九、S300部署在人造岛礁。当然还有052D、052C这些不亚于美军的战舰。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;诚然，中美之间的武器装备仍确实存在着较大的差距。但中美如开战的话，以美军的大规模进攻为标志的第一阶段的战斗，中国将付出重大的代价。但是，战争转入第二阶段，美国将在付出巨大代价后，由于无法征服中国，从而不得承认中国作为真正的谈判对手，接受中国参与制定的国际规则。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;综述以上，中美之间的战争孰胜孰败？由于中美之间发展阶段的不同，文化背景、民族性格的差异，中美之间如果发生一场的战争，美国将失去现有的霸主地位，中国将凤凰涅槃！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('4', '&lt;p&gt;针对所谓的南海“仲裁结果”，太平岛被认定为是礁，台湾渔民自组船队预订20日开往太平岛登岛护权。台“海岸巡防署”16日也派出千吨级的巡防救难舰“台东舰”前往太平岛，接替“伟星舰”执行巡弋护渔任务。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 据台湾《联合报》报道，所谓南海“仲裁结果”引起岛内渔民的强烈反弹。“判决实在太不公平了”东港籍海吉利号渔船船主郑春忠表示，太平岛怎么可能是礁？一出领海就是别人的经济海域，以后怎么去捕鱼，既然台当局力度不够，干脆渔民自己来捍卫权益。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 台湾屏东东港渔民自15日晚起，大肆号召各地渔民登太平岛宣示，虽路途遥远往返需费9至10天，截至16日下午4时，已有6艘船响应，预计20日上午10时出发。据台湾《中国时报》报道，宣示活动发言人罗强飞表示，从台湾到太平岛的路途约864海里，往返要花掉10天左右，以CT4吨级渔船估计，要花上20万元（新台币，下同）的油料，因此虽不少渔民想加入响应，碍于生计仍在观望。罗强飞透露，他们会以民间的力量募集款项，不愿任何政党经费介入，要让台当局看见渔民的决心和愤慨。&amp;nbsp;&lt;br/&gt;&lt;br/&gt;&amp;nbsp; &amp;nbsp;&amp;nbsp; 《联合报》指出，原只设定6艘渔船组成船队出发，但消息传出后有不少渔船声援，16日讨论决定维持在十艘。东港籍海吉利号渔船船主郑春忠表示，他也会派一艘一百多吨的渔船前往。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; “我们是合法出海捕鱼作业”郑春忠说，船队将在太平岛附近经济海域作业，也会带物品登岛慰劳驻岛海巡官兵。他们计划取太平岛的淡水，在岛上生火煮饭，“用行动来证明这是岛”。东港区渔会总干事林汉丑表示，登岛行动由渔民自主发起，渔会尊重，渔民在紧急情况下可登岛。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 台湾琉球区渔会总干事蔡宝兴说，渔会积极鼓励渔船主参加，争取捕鱼权益。“渔业署副署长”黄鸿燕也表示，尊重渔民的行动，渔民只要依正常渠道申请，即可出海作业；登太平岛非“渔业署”管辖业务，但会持续和渔民沟通。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 据台湾“东森新闻云”报道，民国党16日发起全民联署行动，民国党主席徐欣莹指出，太平岛绝对是岛不是礁，台湾地区领导人蔡英文应该拿出决心，别让渔民孤军奋战。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 报道指出，太平岛被判定为“礁”，严重影响屏东东港及小琉球地区的渔民，但台当局除提前派出“康定舰”巡弋南海外，后续动态静悄悄。对于外传蔡英文可能在近期登岛宣示，蔡英文办公室也澄清，目前没有规划，让渔民痛批台当局实在太软弱。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 此次渔民自主发起的宣示活动，有渔民热烈响应，也有渔民认为在没有官方加持下，自行登岛根本没效果。屏东县议员洪慈綪说，“不是几个渔民去喊口号就有效，若与菲律宾渔船擦枪走火，安全问题谁负责？”&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('5', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　经过多年的讨价还价，美韩还是在7月8日敲定了部署“萨德”（THAAD：末段高空区域防御系统）到韩国的具体地点，当然了目前所有消息都认为这是美国的一次战略上的胜利。尤其是“萨德”本身2000公里探测距离，将会让中国东部的远程弹道导弹都处于美国反导网络侦测范围内，而这一带正好是中国对美洲大陆进行核打击的“东风-31”弹道导弹的发射阵地。这不等于卡主了中国“东风”导弹的命门了吗？实际上并非如此，美国如此急迫的把自己又送到了中国门口，反而给中国火箭军送了个新目标。&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 大家最担心的“萨德“的AN/TPY-2型X波段雷达，其实真没有必要过分担心。美国早在2006年和2014年就在日本部署过两台X波段AN/ATY-2机动式早期预警雷达，结果呢？美国获得了什么核心数据了吗？同样没有。而且X波段也没有多么神秘，在这个波段上带宽就这么大，使用多台老式远程雷达进行大功率持续干扰，“萨德”就根本没有办法发挥效用了。有些朋友认为这样效费比不高，不过相对于能够克制的威胁，这些投入问题不大，其实相当划算。因为要完成同样功能的大型远程相控阵雷达，仅建造费用就是天文数字，仅仅建造费用就要7亿美元，后期维护更是天文数字。&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 而且中国要想打击”萨德“有很多手段可以进行反击：目前中国的远程火箭炮部队正在进行海上训练。大家可以看下从海上打击”萨德“部署地点的距离是多少。以前都说真理在火炮的射程之内，现在也可以在火箭炮射程之内。而且“萨德”最有效的是针对高空的弹道导弹，在中国火箭军的“东风-10”陆地巡航导弹的超低空掠海打击下毫无还手之力。虽然韩国会负责“萨德”低空防御任务，不过由于韩国在开战之初就可能面临来自三方的同时打击，能拦住多少是个说不准的事情。只要一发摧毁了“萨德”的远程雷达，整套系统就此瘫痪了。而且，对于中国火箭军来说，”萨德“反而是给他们提供了一个陆基直接打击美军的合理目标，尤其”萨德“部署地点完全在“东风-21“中程弹道导弹和”东风-10“巡航导弹打击范围。对美军来说，最宝贵的还是人而不是装备，眼皮子底下的目标中国能不打？&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 不过韩国部分媒体称根本不怕中国和俄罗斯对”萨德“进行打击。韩国亚洲大学中国研究室的金姓主任在韩国的《每日经济新闻》上撰文称：在部署”萨德“的实际协议中就隐含了对在韩”萨德“系统被打击时的反击条款，就是美、日对韩国联合的保证：当遭受到中、俄等国的摧毁时，将会履行反击义务。不过这种保证只是一种纸面保证。相对于中国多种反击手段：从陆地上的短程弹道导弹、远程火箭炮、空射和陆基巡航导弹等多种报复手段，毕竟”萨德“再能机动，韩国国土范围就是这么大，没有丝毫战略纵深可言。所以还是奉劝韩国不要耍小聪明，这样只会让自己处于更被动的情况，损人不利己其实就是韩国目前状态。&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 大家一直都认为美国在这个时间点部署“萨德”反导系统其实是针对中国的一招狠招。事实则是关于部署萨德，美国人心中早有小算盘。考虑到未来的极端情况，美国甚至可以直接空运部署部署“萨德”到美军驻韩基地里；这个根本不需要韩国同意，直接空运部署就好了，只不过防御角度上可能会存在一些死角，但是肯定确保美国自己的安全了，跟帮韩国防御没什么关系。而且美国越过韩国直接部署装备以前就有先例：当年美国驻扎在韩国的”斗牛犬“导弹和核弹头就完全部署在乌山基地里。所以“萨德”不过就是美国人手中一张可打可藏的牌，只不过在这个时间点打出来就是针对中国的。我们不要过分担心也不能轻视，更要思考未来面对这样情况要提前遏制的手段，而不是事后亮反击手段。（作者署名：无名高地）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('6', '&lt;p&gt;导言： 新华社快讯：菲律宾 南海 仲裁案仲裁庭１２日作出非法无效的所谓最终裁决。对此，中方多次声明，菲律宾共和国阿基诺三世政府单方面提起仲裁违背国际法，仲裁庭没有管辖权，中国不接受，不承认。&amp;nbsp;&lt;br/&gt;　　美国曾经遇到此类所谓的判决，靠的强大的军事机器让胜诉者执行不了，对于中国来说，若菲国不撤诉，就不要指望与中国合作解决经济困境的问题，就象尼加拿瓜一样，没打一仗就象得到岛屿与土地，这个是不可能的，美国就是靠打来解决所有的问题，什么联合国都是屁，何况海牙法庭这搞笑的组织，不认它时屁都不是。维护国家利益的十一段线（九段线）还靠全体国民的努力，家不和，结果是外敌得利，这个历史的教训值得记取的。&amp;nbsp;&lt;br/&gt;　　国家领土的坚守不靠一纸文书，靠的就是枪杆子，没有这个一切就不要谈了，宁可死一个亿也要把所有的岛屿保下来，否则倒退一步，意味着步步退，敌进是没有止境的，也许国人应当丢掉幻想，准备战斗，死多少无所谓，只要打退想侵占土地的敌国就可以了，甚至也不需要笨猪式的不首先用核，要以死来抵抗任何国家趁机侵占国家的岛屿与领土。当然已经被敌国占的，可以等待，若有新占，必须血战到底，不然当局就应当下课，因为人民不满意了。&amp;nbsp;&lt;br/&gt;　　只有血洗，才能立威，若内部的贪腐分子亦会得到清洗与震撼，谁卖国，谁爱国，不看你说什么，不看你是否是在位在野，而在你的实际行动。&amp;nbsp;&lt;br/&gt;　　什么都向内，不敢保祖产，意味着民心将失，执政的基础便荡然无存，所以南海风云，可以显各方的真实面目。在国土将被侵入的条件下，执政者，得利者应当有相当重要的担当，走在前面，而不是退缩，所谓在其谋其政。亦不是保其权位而向敌国绥靖，国家的领土，没有一寸多余的。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('7', '&lt;p&gt;海牙国际法庭所谓的南海仲裁案终于公布了，结果中国被置于彻底否定和相当不利的地位。这件事当然不能就此了结，相反，这恐怕只是一个开始，不要说接下来会不会有具体执行的，仅就这项裁决本身而言，也注定要成为中国头上的一个“紧箍咒”，被“国际社会”用来时时地敲打中国。预计，在今后与美国进一步“良性互动”，“深化互信，增强合作”的诸般过程中，中国将始终摆脱不了这方面的讹诈，美国将时时、处处、事事借仲裁要挟中国，这是起码的后续效应。南海问题被地国际化了，而且是“化”得彻头彻尾、彻里彻外，这意味着今后可能要出现种种意想不到的麻烦。从这个意义上说，这当然是一件坏事。&lt;br/&gt;　　但是，凡事都有两个方面，南海仲裁案也不例外。笔者以为，从另外一个视角看，这又是一件大好事，主要体现在它是生动的一课，对中国具有不可忽视的教育作用。&lt;br/&gt;　　首先，这是对中国爱国主义的一次空前动员，效果十分明显。中国人民的爱国热情过去很多时候都是帝国主义的炮声唤醒的，现在，他们又开着大炮回来了，这比他们巧梳妆、细打扮的绅士摸样来得好，因为这后一种摸样很有欺骗性，会助长中国人的散沙现象，而他们的大炮则不同，在他们大炮的威胁下，中华民族的凝聚力、爆发力和战斗力将得以快速增长。此次南海仲裁及围绕此次仲裁所发生的一系列事件就是这样。现在，平常关心不关心国家领土安全的人，现在都空前地关心了；平常对爱国与否漫不经心的人现在也都空前地关心了。可以说，爱国主义在中国被空前地激发起来了，效果已经十分明显。这不是一件大好事吗？&lt;br/&gt;　　其次，这还是对中国人民一次相当深刻的教育。长期以来，在“专家”、“学者”们的鼓噪下，关于中国与美国的关系，有关中国与资本主义世界的关系，基本逻辑与基本价值体系全都颠倒了，以致于是非不分、敌我不分，相当一些中国人把中国的前途与出路寄托在美国身上，相当一中国人认为中国将与美国“风雨同舟、殊途同归”，把美国当成帮助中国发展崛起的外部条件，把美国当成中国未来所努力的方向。现在，通过在南海争端中美国扮演的角色，相当多的中国人将因此进一步认清美国的霸权本质，进一步认清中美关系的本质属性，同时也能进一步认清美国主导下的世界秩序的丑陋与丑恶。这样教育作用很了不得，只有美国霸权主义者才有资格充当这个称职的反面教员。&lt;br/&gt;　　最后，这将促进一些中国人在思想灵魂深处进行反思。他们将因此反思自己，以前那样亲美，那样对美国歌颂赞美是不是有些过了；他们会反思自己，以前那样“逢中必反、逢美必赞”是不是有点没良心、缺人味。这样的反思将导致中国庞大的亲美阵营出现分裂，而这样的分裂，将极大地压缩中国亲美主义者的政治空间，极大地削弱他们的社会基础。可以说，美国对中国挥舞大棒，可能会让中国国内少数铁杆亲美分子嚣张，而将处使多数亲美主义者清醒过来，从而在事实上降低了中国国内的政治危险。这对中国而言，也是一件很好的事情。&lt;br/&gt;　　正是因为这样，笔者才坚定地认为，南海这堂生动的政治课，实在是上得好啊！坦率地说，现如今中国各种政治迷魂汤到处蔓延流淌，而像这等发人深省的政治课却少之又少，不能不说是一个缺憾。类似这样的课程，今后可能还要发生很多，但眼前这一堂课，无疑具有里程碑意义，它可能要成为中美关系上的一个里程碑，成为当代中国对外安全战略上的一个历史转折点。&lt;br/&gt;　　现在，一切具有基本爱国心的中国人都已经明白，中国同美国打交道，同资本主义世界打交道，不斗争就没有出路，“合作”是相对的、有限的，而“斗争”则是绝对的、长期的，面向未来，实现中华民族的伟大崛起，中国必须高举反霸、爱国的旗帜，这也是相辅相成的两大主题，把这样的两个主题牢固地树立起来，中国才能在美国面前挺直腰杆，才能在“不接受、不承认”的基础上更进一步。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('8', '&lt;p&gt;中国已经多年没有进行过核弹核爆试验，那么现在中国核力量到达是个什么水平，就引发了网友的关心和热议。&lt;/p&gt;&lt;p&gt;　　由于中国一直都不愿意公开谈论中国本身装备的核弹数量，威力等等细节，因此外界对此也是有各式各样的猜测。&lt;/p&gt;&lt;p&gt;　　韩国认为评价核弹技术的一个重要指标是核弹小型化技术，在这个方面中国没有优势，还不如印度。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;只有核弹小型化，才能缩小洲际导弹的尺寸，或者搭载更多的探测设备和燃料。按韩国的数字，美国核弹头仅有110公斤，俄罗斯225公斤，印度500公斤，中国600公斤。&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　但是我们知道，在1966年，从酒泉卫星发射中心就已经试验了当时的最高机密。使用东风2型导弹搭载核弹射向罗布泊试验场。结果，是圆满完成任务，中国第一次有了可以搭载核弹的弹道导弹。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;1969年，中国又使用东风3号导弹测试了搭载氢弹试验，当时就可以安装爆炸威力为百万吨级的小型化氢弹。至于韩国说的，中国导弹核弹头为500公斤不如印度，那都是几十年前的数据了。这种拿几十年前数据说现在的，逻辑未免太可笑了。&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　1966年东风2号导弹搭载的核弹头才是500公斤。而且，大核弹头也不是坏事，只是需要更大型导弹，但是其爆炸威力也是响应成倍增长的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('9', '&lt;p&gt;最近，俄罗斯媒体一直在吹风，一会要把原来俄罗斯的超级航母技术卖给中国，一会又要卖给中国核潜艇，这和过去毛子卖给中国武器的态度完全不同，俄罗斯媒体为何突然吹这个风呢？在占豪看来，主要应该是基于三方面原因：&lt;br/&gt;　　一、经济压力所迫。&lt;br/&gt;　　由于俄罗斯经济陷入衰退，俄罗斯2016年的军事预算削减了5%，这种压力对俄罗斯来说非常大，那么出售装备给中国就是维系其军工企业运营和升级的关键。然而，现在中国军事实力也上来了，一般的东西中国根本不需要，所以这就想着试探一下看看这些高附加值的东西中国是不是需要，通过媒体释放出来一些信号可以试探中国反应。&lt;br/&gt;　　二、战略上刺激中美海上争霸。&lt;br/&gt;　　关于这一点俄罗斯的军事专家也说了，将这些战略装备和技术卖给中国可以促使中国与美国进行海上争霸，俄罗斯认为中国资源是有限的，投入更大的海军对俄罗斯这个陆上强国来说就是好事。既然俄罗斯现在造不出超级航母，那不如在中国还没有设计出更高级别航母的情况下卖给中国还能换钱。特别是中国拥有更高级别的核潜艇对俄罗斯威胁不会增加多少，但对美国威胁却会增加不少，更重要的是这玩意真值钱，也只有中国、印度能买得起。&lt;br/&gt;　　三、中国军事科技进步所逼。&lt;br/&gt;　　俄罗斯的科技进步速度远不如中国，现在中国自己的航母技术正在突飞猛进，估计自主航母到第三或第四艘的时候，差不多也就能造到8万到10万吨级了，这个时间根本用不了几年，估计2020年到2025年之间中国就开造这样的超大型航母，到那时俄罗斯的8万吨的超级航母技术对中国又有什么吸引力？也别说到那时候，哪怕现在，中国对俄罗斯的这些技术是否感冒都很难说，因为中国已经有了自己的设计能力。至于核动力潜艇，中国与俄罗斯技术上还有较大差距，如果俄罗斯真卖，中国还真有可能买，但再过十年八年俄罗斯再卖中国就不一定买了。没有中国这个买家顶着，俄罗斯想黑印度的钱也就难了。所以，俄罗斯这么提出来，哪怕不代表克里姆林宫的意见，也至少代表俄罗斯军方的部分意见。&lt;br/&gt;　　当然，至于中国是否感兴趣，那又是另说了，因为中国的军事科技的确是日新月异。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('11', '&lt;p&gt;最近关于印度的话题很火，&lt;strong&gt;印度电影大全&lt;/strong&gt;，今年因为工作关系我在印度呆了半年，所以对印度的情况相对了解一点，又发现国内的很多同志们对印度并不很清楚，&lt;strong&gt;印度&lt;/strong&gt;，所以向大家介绍下我在印度的感受。&lt;/p&gt;&lt;p&gt;1、基本建设真的是糟糕透顶。我在印度坐十个小时的火车，沿途就没看到过任何令人赏心悦目的建筑，&lt;strong&gt;印度舞蹈&lt;/strong&gt;，&lt;strong&gt;印度性与艺术照片&lt;/strong&gt;，到处都是一片破败的景象。说他们基本建设落后我们30年绝不为过。&lt;/p&gt;&lt;p&gt;而且在十个小时的火车中，我也没有看到任何工厂!很奇怪吧!火车包括火车站也是超级破烂，印度的大、中、小城市我都去过，到处都是乱糟糟的，&lt;strong&gt;印度舞蹈&lt;/strong&gt;，我常常想印度人的钱都拿去干嘛了。&lt;/p&gt;&lt;pre class=&quot;brush:php;toolbar:false&quot;&gt;啊手动阀手动阀&lt;/pre&gt;&lt;p&gt;2、印度人不讲卫生也是真的。右手抓饭左手擦屁股。而且他们的食物粘乎乎的，看到印度人把他们的黑手在里面搅来搅去，真是有多恶心就有多恶心。&lt;/p&gt;&lt;p&gt;反正我在印度是从来没吃过印度人的饭，&lt;strong&gt;印度尼西亚&lt;/strong&gt;，&lt;strong&gt;印度尼西亚&lt;/strong&gt;，只吃中国厨师做的，&lt;strong&gt;印度罕见连体婴降生&lt;/strong&gt;，坐火车就带些煮熟的鸡蛋，和一些饼干。印度人的带包装的饼干也不干净。另外，在我吃饭的时候，绝对不能看到任何印度人，否则没法吃。&lt;/p&gt;&lt;p&gt;印度火车内部，不通空气，气味刺鼻，&lt;strong&gt;印度妓女村&lt;/strong&gt;，&lt;strong&gt;印度&lt;/strong&gt;，你吃得下去饭么&lt;/p&gt;&lt;p&gt;3、印度人很穷也是真的。很多人就睡在路边上，&lt;strong&gt;印度妓女村&lt;/strong&gt;，没有家。我还看到过住在树上的。很多文盲。我们在那边找一个焊工比在国内找一个高级工程师还要难。但是干体力活的人很容易找。&lt;/p&gt;&lt;p&gt;4、印度有些电视台24小时都在放歌舞，这个很无敌。&lt;/p&gt;&lt;p&gt;5、大多数印度人并不认为他们领先中国20年，&lt;strong&gt;印度罕见连体婴降生&lt;/strong&gt;，他们谈起自己的国家就大摇其头，说我们太穷之类的话。去过中国的印度人很羡慕中国。&lt;/p&gt;&lt;p&gt;印度人大便后用左手擦屁股，&lt;strong&gt;印度吧&lt;/strong&gt;，右手一般用来吃饭，问题是当你一只手拿不过来时&lt;/p&gt;&lt;p&gt;6、医疗卫生方面。离我们那(我们在一个小城)300公里远才有一个医院，&lt;strong&gt;印度电影大全&lt;/strong&gt;，所以在印度千万不能得病。常用的药一定要带够。&lt;/p&gt;&lt;p&gt;7、但是印度的治安还可以。有个同事走了，&lt;strong&gt;印度人看中国&lt;/strong&gt;，鞋放在宿舍外面几个月都没丢。我们宿舍区也有些印度人在住，&lt;strong&gt;印度罕见连体婴降生&lt;/strong&gt;，&lt;strong&gt;印度性与艺术照片&lt;/strong&gt;，搞卫生的也是印度人。&lt;/p&gt;&lt;p&gt;8、印度的敌人。我问几个印度青年，&lt;strong&gt;印度电影&lt;/strong&gt;，他们回答是：第一，美国(阻挠他们发展核武器)第二，&lt;strong&gt;印度吧&lt;/strong&gt;，巴基斯坦(不用说了)，第三，中国(不用说了)。&lt;/p&gt;&lt;p&gt;9、印度超级热。比中国最热的地方还要热。&lt;/p&gt;&lt;p&gt;10、公共汽车超级破，出租车也很破。&lt;/p&gt;&lt;p&gt;11、我在印度呆一个小时都嫌多。&lt;/p&gt;&lt;p&gt;12、这辈子再也不想去印度。&lt;/p&gt;&lt;p&gt;13、我既不是愤青，也不是精英，&lt;strong&gt;印度尼西亚&lt;/strong&gt;，只是写下自己真实感受的普通中国人。&lt;/p&gt;&lt;p&gt;曝光印度重口味生活中国人吐着回来&lt;/p&gt;&lt;p&gt;听我一好朋友说过，她的姐姐被印度人邀请去印度参加婚礼，住的五星级酒店照样没有厕纸!你可别不相信，你到印度旅游一圈才能深有体会!这是一个集腐尸，粪便为一体的国家。&lt;/p&gt;&lt;p&gt;恒河上漂着的尸体，&lt;strong&gt;印度人看中国&lt;/strong&gt;，活人就在旁边刷牙洗澡&lt;/p&gt;&lt;p&gt;印度土地干燥，树木并不繁茂，有时候放眼大地一片荒芜。印度人喜欢尊崇牛为圣牛，&lt;strong&gt;印度神油&lt;/strong&gt;，满大街的圣牛随便拉屎。印度妇女更是有了收集牛粪这一项娱乐活动。&lt;/p&gt;&lt;p&gt;你能想象BODHGAYA，多少年来游客朝圣者络绎不绝的圣地，当地人还是生活在赤贫的脏乱中。古镇大街旁，&lt;strong&gt;印度电影&lt;/strong&gt;，垃圾洒满地。野生动物们争相恐后的把垃圾当做早餐。&lt;/p&gt;&lt;p&gt;PURI是印度东海岸有名的度假胜地。也是一个天堂与地狱共存的清贫渔村。整个村的人几乎都在海滩上拉屎，郊外也如此。更令人震惊的是，印度男人把随处方便当做一种传统文化。&lt;/p&gt;&lt;p&gt;秉持着我脏但是我精彩的理念，在恒哥边上的古城VARANSY，每天都有人在垃圾堆上大小便，排泄物，垃圾一堆堆回归圣河，各地的朝圣者，&lt;strong&gt;印度神油&lt;/strong&gt;，&lt;strong&gt;印度电影大全&lt;/strong&gt;，怀着对神的敬意在此刷牙洗脸沐浴游泳。&lt;/p&gt;&lt;p&gt;近日，一小群人争论印度落后中国多少。结果很快出来，落后10年至25年以上。事实上，弄清两个“正在崛起的亚洲巨人”之间的差距是一项有益的研究。比如，中国2011年的GDP是6.99万亿美元，或者说是印度1.84万亿美元的4倍。&lt;/p&gt;&lt;p&gt;如果印度经济以年平均7.8%的速度发展(过去10年的速度)，&lt;strong&gt;印度性与艺术照片&lt;/strong&gt;，&lt;strong&gt;印度舞蹈&lt;/strong&gt;，印度需要18年的时间才能达到中国目前的规模。&lt;/p&gt;&lt;p&gt;如果发展速度加快到9%，印度仍然需要15年。印度是否本可以避免落后中国如此多?毕竟，当中国于1978年开始四个现代化的时候，&lt;strong&gt;印度吧&lt;/strong&gt;，&lt;strong&gt;印度神油&lt;/strong&gt;，两个经济体的规模大约 相等(1450亿美元至1480亿美元)。甚至在1991年，&lt;strong&gt;印度人看中国&lt;/strong&gt;，当印度开始改革的时候，中国经济只比印度2680亿美元的经济大40%。&lt;/p&gt;&lt;p&gt;答案是，印度1991年就已经在主要的指标上落后中国二十年以上。差距并没有弥合。&lt;/p&gt;&lt;p&gt;我正好访问了中国…别说落后中国十年或者二十年左右——我们至少落后他们200年…当我们200年后达到他们目前水平的时候——中国将领先我们500年…虽然那里的人们有某些问题…不过在商场、基础设施、公路、汽车、精通科技的人才等方面，&lt;strong&gt;印度妓女村&lt;/strong&gt;，&lt;strong&gt;印度电影&lt;/strong&gt;，&lt;strong&gt;印度&lt;/strong&gt;，你无法进行比较…&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('12', '&lt;p&gt;让拥有一定资产的能人、富人走上村干部岗位，曾被当成发展农村经济的捷径，在江苏乃至全国遍地开花。然而，在“老板村官”为农村面貌带来改变的同 时，一些问题也随之暴露。今年5月，南通海门明星村官叶剑生疑因身陷债务纠纷服下化学物品。时隔两个月，常州也发生类似情况，一村支书因身缠巨债与外界失 联。现代快报记者历时数日调查，从个案到现象，尝试找出“老板村官”频繁出事的潜在原因。知名社会学专家邱建新在接受现代快报记者采访时表示，自身素质的 不足以及监管、考核制度的缺陷，共同导致了乡村治理的异化。因此，必须完善监管制度，把权力关进笼子。&lt;/p&gt;&lt;p&gt;　　现代快报/ZAKER南京记者&lt;/p&gt;&lt;p&gt;　　宋体佳 文/摄　　身缠巨债，常州一村支书跑路&lt;/p&gt;&lt;p&gt;　　7 月9日，有网友在当地论坛爆料称，常州青城村村支书陈某跑路了，然而，因网帖语焉不详，这条信息并未引起网友的太多关注。此后两天，不断有人在网络上发帖 谈及此事，且情节越来越丰富，按网友的说法，陈某因无力偿还巨额高利贷，只好跑路。随后，这一说法得到当地村委及镇政府的证实。&lt;/p&gt;&lt;p&gt;　　“前几 天一直在做防汛工作，也没发现有什么异常。”7月14日，青城村委会工作人员谷芳（化名）在接受现代快报记者采访时称，她最后一次见到陈某是在6日的防汛 工作会议上，而到了7月8日，防汛工作会议的组织者变成了镇里的领导。崔敏（化名）也是青城村委会的工作人员，她回忆，自从去年8月，陈某提任村支书后， 就经常有些社会人员到村委会找他，“有的开着豪车，也有银行的”。崔敏称，陈某跑路之后，仍有不少人到村委会找他，“都是要债的，坐在办公室不肯走。听说 欠得太多了，接近2个亿。”&lt;/p&gt;&lt;p&gt;　　“一开始我也是从网上看到的，直到镇里开紧急会议，我才知道这个事情。”当地镇政府相关负责人在接受现代快 报记者采访时称，镇党委对此事非常重视，于7月11日紧急召开党政工作会议，由于陈某“因个人债务原因离职，已不能胜任村支书工作”，免去其青城村村支书 职务。此外，该镇还及时选派了新村支书暂时接管青城村事务。该负责人称，陈某确实因身缠巨债躲了起来，具体的欠债数额还在进一步统计中。另外，陈某欠下的 主要是个人债务，与村、镇政府无任何关系，“若有触犯法律的地方，将由相关部门调查，交由司法机关处理”。&lt;/p&gt;&lt;p&gt;　　此后，青城村多位知情村民告诉现代快报记者，陈某所欠下的债务和政府无关。&lt;/p&gt;&lt;p&gt;　　因为致富有方走上了村官岗位&lt;/p&gt;&lt;p&gt;　　在青城村，村支书陈某因身缠巨债跑路的消息早就炸开了锅。至于欠款的数额，尽管官方至今没有给出确切的说法，但在当地人的传言中，陈某身上背负的债务至少有一亿元，且这笔钱和他的企业有很大的关联。&lt;/p&gt;&lt;p&gt;　　在 青城村工作人员出具的一份统计表中，现代快报记者看到，陈某还是“常州恒源钢结构工程有限公司”的法人代表。而据崔敏透露，陈某也正是因为企业主的身份， 才被作为“能人”引进村官岗位的。“他就是这个地方的人。”崔敏称，早前，陈某曾因生活困苦做过“托锅底”的手艺活，后于2003年前后成立钢结构公司， 企业也不断壮大。因为做事踏实、勤奋、脑袋灵活，深得老支书的赏识，得到不少帮助。&lt;/p&gt;&lt;p&gt;　　2013年5月，老支书临退休前，将陈某作为能人推 选进入青城村委，当了副书记。“本来是打算让他做村支书的，后来因为各种原因，镇里另派了支书人员，只给他安排了一个副支书。”崔敏介绍，在副支书岗位工 作近两年后，镇里来的书记因为患病被调离，作为唯一副书记，陈某临危受命，于去年8月被提拔为青城村村支书。没想到，担任村支书还未满一年，陈某就身陷债 务漩涡。7月14日下午，现代快报记者在青城工业园看到，曾红火一时的“常州恒源钢结构工程有限公司”非常冷清。门卫称，目前工厂已处于停业状态，老板也 不知去向。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('13', '&lt;p&gt;正值暑假，安徽阜阳3男孩在家看动画《葫芦娃》，一时兴起想“扮”葫芦娃玩儿。于是他们走到村里一处葫芦地，顺手偷了几个葫芦，“扮起”葫芦娃。民警找来家长，协商赔偿了农民伯伯的损失。男孩不解：“想当葫芦娃有错吗？”@@中警安徽&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('14', '&lt;p&gt;记者 左燕燕 实习生 龚晨霞&lt;/p&gt;&lt;p&gt;　　“遭遇‘呼死你’软件攻击，一分钟5个电话，一小时600个电话，一天14000多个电话，持续一天了，微信转账300元才能停止骚扰”。昨日，网友聂先生发微博称。&lt;/p&gt;&lt;p&gt;　　通讯专家向重案组37号(微信号：zhonganzu37)解释，针对这种情况，可下载一些拦截软件，通过设置拦截无主叫号码电话，便可脱离困扰。警方则建议市民遇到上述情况，可立即报警求助。&lt;/p&gt;&lt;p&gt;　　莫名遭遇一天14000多无主电话骚扰&lt;/p&gt;&lt;p&gt;　　7月15日下午五点，互联网产品公司经理聂先生突然接到电话骚扰，一分钟5个电话，一小时600个电话，一天14000多个电话，响一秒就挂断，“我的手机是吉祥号码，对方可能觉得我比较有钱。”&lt;/p&gt;&lt;p&gt;　　由于骚扰电话均未显示号码，聂先生无法设置黑/白名单拒绝接听，只好开启了勿扰模式，但电话仍旧可以打进来。联系运营公司，“说是无主号码，无法拦截处理和查找信息，建议办理紧急停机。”&lt;/p&gt;&lt;p&gt;　　电话“轰炸”的同时，聂先生接收到两条短信，内容基本相似，告知他号码被“呼死你”软件攻击，每天呼叫时间为早上8点到晚上23点，需要添加微信公众号，支付300元才能解除骚扰。&lt;/p&gt;&lt;p&gt;　　对方短信中甚至扬言，“钱不多，给你10分钟解除时间，如果超过解除时间，会根据小时解除费用50%收取呼叫费用。”手机号码归属地是浙江绍兴，但回拨过去却一直无法接听。&lt;/p&gt;&lt;p&gt;　　昨日上午11点多，聂先生没有给对方转钱，而是选择报警，中午12点半，将近一天的电话骚扰终于停止。&lt;/p&gt;&lt;p&gt;　　“也不知道为什么突然停了，幸好这是周末，不在工作时间，所以没有造成太大影响。如果长期如此，只能考虑换个号码。”聂先生对重案组37号(微信号：zhonganzu37)说道。&lt;/p&gt;&lt;p&gt;　　使用软件拨打上千次电话仅几分钱&lt;/p&gt;&lt;p&gt;　　360手机卫士安全的专家买昭一丁表示，这类软件使用成本非常低，基本上千次可能才几分钱。本来这种服务是用来协助有关部门整治非法广告的，但如今已经被滥用，甚至出现了这位市民遭遇的被敲诈情况。&lt;/p&gt;&lt;p&gt;　　那么手机是否真的无法拦截这类电话？专家称，可以在手机上安装如360手机卫士这样的安全软件，开启其中的骚扰拦截功能。将拦截模式设置为“只接受通讯录”，“只接受白名单”，或者“全部拦截”，就能有效避免手机被不断的呼叫。&lt;/p&gt;&lt;p&gt;　　另外，如果有人宣传在手机上安装类似“呼死你”这样的App，也确实有可能是窃取用户隐私甚至恶意扣费的恶意木马应用。推荐大家不要安装来路不明的手机应用，同时使用手机安全软件定期扫描与查杀手机病毒，避免个人财产遭受损失。&lt;/p&gt;&lt;p&gt;　　应对：涉嫌敲诈勒索 应立即报警&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('15', '&lt;p&gt;网友视频爆料，“广东大沥新都会一男子的女友要换电影票，工作人员不让，男子就跟工作人员吵了起来，随后从6楼跳下”。对此佛山市公安局南海分局称，事发7月14日，地点是南海大沥新都会商场，男子跳楼原因仍在调查。网友：为什么把命看得那么淡[蜡烛]&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('16', '&lt;p&gt;据香港《文汇报》7月17日报道，香港西区观龙楼昨天（16日）凌晨发生骸人听闻纵火及凶杀案。独居6旬老汉因噪音与一邻居积怨，争执后有人突向对方住所掷燃烧弹纵火，邻居一家三口惨遭灭门，其中持单程证（又称前往港澳通行证，为公安部门发给有条件的申请人赴港澳地区定居的证件--观察者网注）来港团聚仅5日的妻子及年仅3岁半女儿相拥葬身火海，男户主全身着火坠楼死亡，疑凶后折返再纵火自焚同丧黄泉。警方港岛总区重案组已接手调查惨剧肇因。&lt;/p&gt;&lt;p&gt;　　男户主堕4楼平台 烧至皮开肉绽&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　酿成4人死亡的邻里惨剧现场为西环观龙楼D座13楼两个对户单位。其中59号单位住有一家三口，包括26岁男子黄志强、同龄妻子吴倩欣、及年仅3岁半的女儿黄依琳。对户64号单位为一名63岁独居男子许伟忠，4人同在案件中身亡。&lt;/p&gt;&lt;p&gt;　　港岛总区刑事总部警司温兆雄表示，独居汉死者患精神病多年，曾有多次投诉噪音及与邻居争执记录，屋苑管理部门及社工均有跟进事件。警方正设法联络独居汉的兄长，调查其精神状况及背景，以及两户人家事发前有否发生争执等。案件暂列作纵火及凶杀案，交由港岛总区重案组跟进。&lt;/p&gt;&lt;p&gt;　　事发于昨日凌晨1时40分，上址两个单位几乎同时冒烟起火，大厦多名居民发现纷纷报案，在消防员到场前，其中一家三口单位的火势已迅速蔓延全屋，烈焰及浓烟由露台向外喷窜，其间有住客更目睹一个火人攀出窗外挣扎呼救，约半分钟终不支飞堕至4楼平台。&lt;/p&gt;&lt;p&gt;　　消防员赶到立即出动搜救队进入火场扑救，并协助约200名大厦住客逃生。同时间，救援人员在4楼平台发现一名被烧至衣衫尽毁、皮开肉绽的男子，证实已当场死亡。&lt;/p&gt;&lt;p&gt;　　至凌晨3时58分，消防员终将两个单位的大火扑灭，并在堕楼男子的单位客厅处，发现两具相拥烧焦女尸，又在另一单位的大门后发现一具男焦尸。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('17', '&lt;p&gt;据港媒报道，爱金成狂的印度宾布里富豪普盖（Datta Phuge）周四遇袭身亡，12名嫌犯手持镰刀和石头对其痛殴，普盖送医后死亡。警方随后拘捕5名疑犯，其中一人为普盖的侄儿，事件怀疑与金钱纠纷有关。&lt;/p&gt;&lt;p&gt;　　事发于周四晚上，48岁的普盖与22岁儿子获邀出席一个生日派对，当他们开车抵达派对地点后，袭击者把普盖从座驾里拉了出来，有指12名疑犯用镰刀和大石殴打普盖至死。普盖22岁儿子舒布汉驾驶另一辆车子从旁经过，目击整场袭击，但未受攻击。舒布汉称认识大部分行凶者。&lt;/p&gt;&lt;p&gt;　　普盖从2013年开始有了名气，从事贷款业的他曾豪掷18.7万英镑打造一件重3.5公斤、由15名工人制造的黄金战衣，更自称“宾布里黄金汉”。普盖外出时均有保镖护驾，唯独事发当日保镖未有随行。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('18', '&lt;p&gt;华商报汉中讯（记者周金柱）6月25日晚9时许，南郑县青树镇冉家营村发生惨剧：上门女婿罗某因琐事与妻子发生口角，将妻子和岳母残忍杀害。行凶过程中，女儿一度呼救，却被他关进厨房后继续行凶。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　7月13日上午，在南郑县青树镇冉家营村杨明志家，9岁的孙女躲在他身后一语不发。杨明志说，当时他正在镇上工地打工，听孙女电话里说“妈妈和奶奶都被爸爸砍倒了”，就赶紧骑摩托车赶回家，发现老伴和女儿躺在院子里，已没有了呼吸，周围还有很多血迹。&lt;/p&gt;&lt;p&gt;　　杨明志的二女儿杨春兰说，2003年1月，姐姐和同村男子罗某经人介绍认识一个月便结了婚，婚后发现两人性格差异大，关系开始恶化。2007年，他们的女儿秀秀（化名）出生。&lt;/p&gt;&lt;p&gt;　　“秀秀出生时患有血管瘤。”杨春兰说，今年6月6日，姐姐向法院提出离婚，7月5日就要开庭。办案民警介绍，6月25日晚，42岁的罗某打工回家，因琐事与妻子发生争吵，罗某便从厨房拿出菜刀将妻子砍伤在地，岳母邓某上前阻拦并追打罗某，罗某便捡起院中砖块朝邓某头部连打数下。见岳母倒地，罗某又用砖块和木墩向母女头部连砸数下，致二人死亡。作案后，罗某前往派出所投案自首。7月13日，罗某因涉嫌故意杀人罪被批捕。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('19', '&lt;p&gt;重庆商报讯 日前，合川区公安局云门派出所接到群众报警，称他家里进去了一名陌生男子，怀疑是小偷。民警迅速赶到现场，发现了擅自闯入的年轻男子倪某。经了解，倪某今年23岁，浙江温州人，与居住在该处的李某曾是男女朋友。后来两人分手，但倪某一直放不下这段感情。为挽回李某，倪某买了一堆礼物，从工作地广东打飞的来到重庆，找到了李某的住处。面对“从天而降”的前男友，李某当场婉拒了，随后便藏身朋友家“玩失踪”。倪某则找来锁匠换掉李某家大门的锁芯，并进入李某家中静待其回家。&lt;/p&gt;&lt;p&gt;　　这一切被李某的邻居发现，邻居立即给李某的父亲打了电话，李某父亲马上报了警。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　近日，对倪某非法侵入他人住宅的违法行为，合川区公安局对其处以行政拘留5日并罚款200元。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('20', '&lt;p&gt;据中山电视台《城市零距离》报道，在广东中山古镇打工的汪先生向我们报料，说工厂给他的工资中有假钱，他数了一下，竟然有12张之多！&lt;/p&gt;&lt;p&gt;　　事情还要从7月11日说起，当时汪先生去广州火车站买车票，打算坐火车去浙江找工作。“我是拿两张100元钞票出来，因为它是200元的车票，售票员说这钱是假的，然后叫我换几张。”&lt;/p&gt;&lt;p&gt;　　汪先生于是又从钱包里重新拿了四张百元钞票出来，谁知道还是被告知是假的。汪先生赶紧清点自己的钱，发现类似这样的钞票一共有12张！&lt;/p&gt;&lt;p&gt;　　记者仔细观察发现，这12张钞票中有很多张的编号都是一致的。比如说有5张钞票都是用了P50W373099这个编号，有4张钞票用了P50W373092的编号，有3张钞票用了P50W373096的编号。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　而迎光一看这些钞票，还可发现钞票的水印印刷十分粗糙，水印的头像也与真钞的有明显的不同。记者之后随机找了一间商铺用验钞机逐一检验这些钞票的真假，无一例外全是假钞。&lt;/p&gt;&lt;p&gt;　　那这些假钞究竟是从哪里来的呢？汪先生就说，他之前在古镇一家儿童用品公司工作，辞工后，他在7月7日领到了3月份到6月份的工资，共计6150元，全部现金发放。他就怀疑，这些假钞是工厂给他的。&lt;/p&gt;&lt;p&gt;　　（记者：你这些假钞确定是从工厂里领出来的？）确定！因为我又没换，又没拿去用，一拿来我就包起来了，就揣在这包里了。汪先生说，当时他只清点了下数目就走了，并没有一张一张去辨认钞票的真假。12张是假的话，等于工资就少了1200元，真是欲哭无泪！&lt;/p&gt;&lt;p&gt;　　记者之后通过电话联系上汪先生之前工作的儿童用品公司的负责人。对方就说，工厂发的钱都是真钞，他建议汪先生去报警。儿童用品厂负责人袁先生说：“员工和人事是点得清清楚楚的了，当面点清当面过了机的，我们发工资的时候，他应该是在火车站或者在其他场所被人调换了。”&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('21', '&lt;p&gt;网站截图&lt;/p&gt;&lt;p&gt;　　这个犀利、理直气壮甚至十分粗鲁的问题，来自Quora上一位不知名人士。Quora类似知乎，是美国知名的问答平台。&lt;/p&gt;&lt;p&gt;　　一年多来，超过100名网友给出了答案，美国人、印度人、挪威人以及海外华人……长期受到西方媒体轰炸的他们，却道出了风格各异的精彩见解，一个上海姑娘的短文配图更是获赞两万。&lt;/p&gt;&lt;p&gt;　　7月13日，微博网友@天涯尼丹小 发现了这些回答，他感叹这简直是在“用论文方式给题主洗脑”，读书人现在干嘛要造反？中国人为何要搞（西式）民主？中国政府真独裁？……“颜色革命威武，教育了全球读书人！”&lt;/p&gt;&lt;p&gt;　　下面，观察者网摘译了其中阅读量和点赞量最高的一批，以飨读者。&lt;/p&gt;&lt;p&gt;　　Mickey Lin：把美国强扭成单一国家，美国人也会拒绝吧？&lt;/p&gt;&lt;p&gt;　　曾在北京和台北学习，加州大学影视艺术学院&lt;/p&gt;&lt;p&gt;　　民主不过是政治体制中的一种，不一定是一个国家最好的政府组成形式。&lt;/p&gt;&lt;p&gt;　　许多民主国家的发展并不如中国好，比如印度。上世纪60年代到80年代，印度的GDP高于中国，但现在却落后于中国。&lt;/p&gt;&lt;p&gt;中印GDP增长对比&lt;/p&gt;&lt;p&gt;　　题主假设每个知识精英都渴望民主或者美式政府制度，但事实可能并非如此。&lt;/p&gt;&lt;p&gt;　　比如，联合国193个成员国中，165个是单一国家（观察者网注：unitary states），中央政府权力高于地方政府。但美国各州却是部分自治的。美国是否该变得向其他大多数国家一样呢？大多数美国人应该是拒绝的吧，因为这可能适合其他国家，但不适合美国。&lt;/p&gt;&lt;p&gt;　　民主很好，但也应该尊重其他人的不同爱好和选择。&lt;/p&gt;&lt;p&gt;　　（6月8日，610赞，31113阅读）&lt;/p&gt;&lt;p&gt;　　Akshay Lawange：言论自由能吃么？&lt;/p&gt;&lt;p&gt;　　坐标新德里，“政治学理论研究者”&lt;/p&gt;&lt;p&gt;　　如果说民主是一套软件，你为什么想把它满世界安装呢？&lt;/p&gt;&lt;p&gt;　　中国如今比民主国家还好，比如印度。&lt;/p&gt;&lt;p&gt;　　中国人发明了新的发展模式。统治阶级（观察者网注：political class）每天都要为生存而战。中国知道，经济一旦出事，执政党接着就得下岗。他们必须把经济搞好。”&lt;/p&gt;&lt;p&gt;　　就印度而言，我们不享有“实质民主”（substantial democracy），只是处于“程序民主”（procedural democracy）。当民众连识字、吃饱饭的权力都没有的时候，你还能想到什么公民权利？&lt;/p&gt;&lt;p&gt;　　对于乞丐来说，言论自由能吃么？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('22', '&lt;p&gt;新华社北京7月16日电&amp;nbsp; 日本前首相鸠山由纪夫16日回答新华社记者提问时说，南海问题应该由当事方通过对话与合作解决，不应该从外部施加压力要求中国和菲律宾接受仲裁结果。&lt;/p&gt;&lt;p&gt;　　鸠山说：“南海问题应该由中国与菲律宾来解决，据说新上任的菲律宾总统也想开始与中国对话。我不希望看到，有外部压力利用这个事情一个劲地挑衅对方。”&lt;/p&gt;&lt;p&gt;　　当天，鸠山在北京举行的第五届世界和平论坛上发表了演讲。&lt;/p&gt;&lt;p&gt;　　在谈到菲律宾南海仲裁案临时仲裁庭本月12日公布的所谓最终裁决时，他指出，南海仲裁案无助于解决南海问题，南海问题应当通过协商特别是双边谈判来解决。&lt;/p&gt;&lt;p&gt;　　鸠山评论说，菲律宾单方面提起并强行推进仲裁的做法对解决南海问题没有任何益处，甚至会导致矛盾升级。“当事方应当坐到谈判桌前，在深入了解立场、找到共同点的基础上进行协商，这其中双边谈判无疑是重中之重。”&lt;/p&gt;&lt;p&gt;　　“领土纠纷应该在地区层面予以解决，通过构建合作框架，保证地区的安全与稳定，”他说。&lt;/p&gt;&lt;p&gt;　　鸠山2009年9月担任日本首相，次年6月辞去首相职务。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('23', '&lt;p&gt;[土军方：上百名叛乱分子被杀]BBC报道，土耳其军方代理参谋长表示，104名叛乱分子被杀。此前报道中提到的在政变中死亡的90人中，包括41名警察、47名平民和两名士兵。目前，军事政变造成的死亡人数已超过190&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('24', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　#环球快讯# [亚美尼亚首都警方大楼被占领 当局驳斥“政变”传闻]据外电报道，亚美尼亚安全部门官员7月17日说，首都埃里温一警察局遭一队与被拘禁反对派领导有关的武装部队袭击，并劫持了多名人 质。人质中包括警察局副局长。政府和武装部队的谈判正在进行，不过当局已驳斥了政变传闻。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('25', '&lt;p&gt;北京时间7月17日，今年NBA总决赛，勒布朗-詹姆斯带领骑士完成了历史性的逆转，并夺得总冠军。在不少人看来，今年31岁的詹姆斯有望夺得更多的总冠军，但是cheatsheet网站却列出了詹姆斯无法再夺冠的十点理由，前提是他一直留在骑士队。&lt;/p&gt;&lt;p&gt;　　10）东部正在变强&lt;/p&gt;&lt;p&gt;　　在过去长达十年的时间里，东部已经成为了詹姆斯的“私人后花园”。他已经赢得了3个NBA总冠军，而且连续6次参加总决赛。但是这种局面可能不会维持太久。&lt;br/&gt;今夏，凯尔特人签下了艾尔-霍福德，德怀特-霍华德加盟老鹰，尼克斯引进了罗斯和诺阿，公牛得到了韦德。虽然詹姆斯的骑士依然是东部老大，但是东部的其他球队看上去已经准备好挑战骑士的霸主的地位。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　9）夺冠的代价非常昂贵&lt;/p&gt;&lt;p&gt;　　虽然NBA的工资帽涨到了9410万美元，而且可能还会上涨，但是詹姆斯会想尽一切办法让自己的经济利益得到最大化。他不会再接受降薪，即便这意味着腾出薪金空间签下另一个明星球员。现在，要想打造一支总冠军球队需要付出昂贵的代价，正如我们看到的骑士队。&lt;/p&gt;&lt;p&gt;　　8）詹姆斯的投篮在退步&lt;/p&gt;&lt;p&gt;　　詹姆斯的运动能力非常恐怖，再加上超高的篮球智商，使得他在场上难以阻挡。但是随着年龄的增长，突破对詹姆斯而言会变得越来越困难。考虑到他跳投的不稳定性，这可能会成为一个问题。&lt;/p&gt;&lt;p&gt;　　上赛季，詹姆斯的三分球命中率只有30.9%，而其他球队也敢于在比赛中放他在外面投篮。如果不能提升外线投篮，这将成为詹姆斯的一个挑战。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('26', '&lt;p&gt;新浪体育讯　　北京时间7月16日，据《波士顿先驱报》报道，最近，有关凯尔特人仍然希望补强并且可能通过交易得到球星的消息成为一大热门，而跟绿军联系紧密的其中一个巨星，就是快船核心布雷克-格里芬。但最新消息显示，凯尔特人方面对于格里芬并没有太大的兴趣，除了他的合同之外，还有另外一个因素。&lt;/p&gt;&lt;p&gt;　　根据此前的报道，凯尔特人曾经希望通过引入第三方来跟快船进行有关格里芬的交易，而这第三方很有可能会是国王队，他们最近在兜售鲁迪-盖伊。不过，根据先驱报得到的消息显示，凯尔特人目前对于格里芬有一些顾虑，让他们并不太想要得到这位球星了。&lt;/p&gt;&lt;p&gt;　　首先就是格里芬的合同，下赛季格里芬的薪水将会是2009万美元，而2017-18赛季的薪水将会是2132万美元，但他有着球员选项，很可能会选择在18年夏天跳出合同寻求薪水更高的新约。也就是说，如果交易来了格里芬，他是有可能在一个赛季之后就跳出合同走人的，这让凯尔特人就必须在考虑交易时非常慎重。&lt;/p&gt;&lt;p&gt;　　不过，除了合同外还有另一个因素让绿军对格里芬望而却步，那就是他腿部伤势的隐患。根据一位第三方球队的高管透露，格里芬的腿伤隐患让所有想要交易他的球队都非常慎重。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('27', '&lt;p&gt;新浪体育讯　　北京时间7月17日，迈阿密热火队总裁帕特-莱利今天召开了一场新闻发布会，并主要谈论了热火在今夏的运作。发布会上，莱利坦言德维恩-韦德离开热火让他“大感震惊”。&lt;/p&gt;&lt;p&gt;　　今年夏天，虽然热火队留住了白边，但是他们没有追到第一目标凯文-杜兰特，而且还流失了队魂韦德。&lt;/p&gt;&lt;p&gt;　　“我们经历了一个艰难的夏天，就是这样。”帕特-莱利告诉在场的记者。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　“发生在德维恩身上的事情让我大感震惊。”&lt;/p&gt;&lt;p&gt;　　今夏自由球员市场上，韦德与热火的谈判再度陷入僵局，而且从头至尾，作为总裁的莱利一直没有出现在与韦德的谈判过程中。对此，莱利在今天的发布会上感到非常后悔。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('29', '&lt;p&gt;新浪体育讯　　北京时间7月17日，中超联赛烽火继续，中超第17轮最焦点的赛事无疑是上海申花坐镇主场虹口足球场对阵上海上港的德比大战。今天申花方面放弃了赛前前往虹口足球场适应场地的训练，而是全队在康桥基地完成了德比大战之前的最后一练，今晚7点30分，主帅曼萨诺携阵中大将柏佳骏出席了赛前发布会。&lt;/p&gt;&lt;p&gt;　　针对德比大战的备战情况，申花主帅曼萨诺表示：“周三刚打好足协杯，准备时间不长，但是大家都做好了充分准备对这场比赛。对手方面我们很了解，对手是强队，也有实力，今年投入很大，中期刚换了一个很有能力球员。不过明天是我们的主场，有球迷助威，希望拿下对手，给球迷带来胜利。”&lt;/p&gt;&lt;p&gt;　　针对目前申花阵中伤病方面是否只有李运秋一个伤员这个问题，曼萨诺透露：“确实是的，当然他在恢复的最后一个阶段了。”　　本赛季首回合德比大战中，申花在客场战平了上港，这场是否渴望战胜对手？是否会针对胡尔克有所准备？面对这一系列外界关注的话题，曼萨诺表示：“你的这个问题提醒我想起来，德比比赛第一场时，我们是在1比0领先时，登巴巴点球没进，留下遗憾，希望明天能多点运气，跟这样强队交手，运气很重要。我也知道，刚才胡尔克他们都跟队训练了，上港的实力更强大，最重要是做好我们自己！”&lt;/p&gt;&lt;p&gt;　　之前三场没踩场结果零封对手并且都赢球了，是不是因为这个原因，今天没有来虹口足球场适应场地？曼萨诺笑言：“你说的这个数据我还没考虑过，今天没有踩场主要是因为考虑到球场之前演唱会办完草皮不是很好，想保护一下草皮，不过，如果明天赢了，我下场还不来踩场，那么你就说对了！”随后曼帅也不忘提醒在场媒体朋友们：“你们都问下柏佳骏吧，他现在是申花队员，不是对手阵中的队员了。”&lt;/p&gt;&lt;p&gt;　　假如明天胡尔克出场，那么柏佳骏防守胡尔克有没有问题？对此，柏佳骏淡然表示：“以前也在比赛中碰到过身体强的，还有就是比赛不是我一个人在踢，我相信我的队友也会过来帮忙，一起防守胡尔克的。”（曲小尤）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('30', '&lt;p&gt;新浪体育讯　　北京时间7月16日晚19：35，2016年中超联赛第17轮，河北华夏幸福主场迎战北京国安，上半场比赛伤停补时阶段，国安门将杨智带着腰伤扑出了姜宁近在咫尺的头球攻门，再次展现了圣杨智的威风，完成这次扑救后，杨智中场休息时只能在队友的搀扶才能离场，下半场比赛也被侯森换下，希望他的伤势没有大碍。杨智受伤瞬间&lt;/p&gt;&lt;p&gt;　　比赛第31分钟，华夏幸福中路过顶长传，老将杜威前插抢点时与杨智撞在一起，杜威的大腿顶在了杨智的腰部，队医进场给杨智进行了短暂治疗后，杨智选择继续坚持比赛。但上半场行将结束时，杨智主动将皮球抛出界，示意无法坚持比赛，国安计划让杨智踢完上半场到中场休息再做调整，但没想到伤停补时阶段，球队门前再度出现险情，杨智带着腰伤扑出必进球。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('31', '&lt;p&gt;北京时间7月15日，中国足协官网公布处罚决定，上海申花俱乐部官员庞斯因在7月9日与延边富德的比赛中指责裁判员造成不良影响，被禁止进入替补席3场并罚款15000元&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('32', '&lt;p&gt;北京时间7月17日消息，在2016年世界女排大奖赛结束后，国际排联公布了最新一期的世界排名。上期位居次席的中国女排因今年大奖赛仅获第5、被最终夺魁的巴西以2分的微弱优势反超，积278分退至第3。大奖赛卫冕受挫屈居亚军的美国仍以315分高居榜首，280分的巴西升至第2。&lt;/p&gt;&lt;p&gt;　　本期世界排名所统计的比赛包括2016年世界女排大奖赛、2015年世界杯、2014年世界锦标赛和2012年伦敦奥运会，2015年洲际锦标赛的积分被剔除。&lt;/p&gt;&lt;p&gt;　　上期排名第2的中国队在今年大奖赛仅列第5进账38分，加上2015年世界杯夺魁计入100分、2014年世锦赛亚军赢得90分和2012年伦敦奥运会并列第5收获50分，总分达到278分。此前排名第3的巴西在今年大奖赛名次比去年提升2位、中国下降1位，此消彼长，中国女排在世界排名累计分上被对手超越落至第3。&lt;/p&gt;&lt;p&gt;　　本期世界排名三甲球队的归属与上期一致，只是排名第2、第3的中巴两强位置对调。美国女排虽在大奖赛卫冕受挫亚军收官，但作为唯一一支在统计积分的大赛中均跻身三甲的球队，仍以总成绩315分领跑诸强。斩获大奖赛第11冠的巴西以2分优势力压中国升至次席，其总分为280分。&lt;/p&gt;&lt;p&gt;　　排名第4至第10位的球队与上期完全一致。俄罗斯218分居第4，日本208分排第5，塞尔维亚192分列第6，多米尼加、意大利、韩国和土耳其分居第7至第10位。&lt;/p&gt;&lt;p&gt;　　本期世界排名的变动主要受大奖赛成绩的影响。荷兰在一档总决赛力夺季军进账42分，总分达78分、排名飙升4位来到第11，成为本期名次提升幅度最大的球队。欧洲两强德国和比利时因大奖赛成绩欠佳，排名均下降2位。一档垫底的德国积69分退至第13，比排在第14的泰国仅多1分；获得一档第11名的比利时以64分落至第15。再度无缘三档总决赛的昔日豪门古巴队降至第22位。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('33', '&lt;p&gt;新浪体育讯　　随着美国奥运选拔赛告一段落，美国奥运游泳团队也已经集结完毕，正在美国本土进行最后的紧张训练中。美国当地时间昨天，NBA圣安东尼奥马刺队的主教练波波维奇和曾经获得总决赛MVP的法国球星帕克造访美国奥运泳团，给美国泳军打气助威。&lt;/p&gt;&lt;p&gt;　　在里约奥运会前，美国泳军获得奥运资格的选手都将来到奥运备战训练营进行最后的备战。包括菲尔普斯、罗切特、莱德基、富兰克林等诸多名将都在阵中。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('34', '&lt;p&gt;新浪体育讯　　北京时间7月15日消息，里约热内卢红灯区的妓女们正在为&lt;a href=&quot;http://2016.sina.com.cn/&quot; target=&quot;_blank&quot;&gt;里约奥运会&lt;/a&gt;提供“性服务销售”，原本希望在巴西举办世界杯之后迎来井喷的市场，却在两年后意外遇冷。身处臭名昭著的比拉-米莫萨区的性工作者们表示，原本期待在巴西世界杯后延续热潮的市场却出现了大幅下滑。&lt;/p&gt;&lt;p&gt;　　目前距离奥运会开幕还有不到一个月的时间， 性工作者表示她们已经准备好了英文传单邀请运动员光顾里约城旁边的这个红灯区，提供十分便宜的性交易。破旧的传单上写着30分钟的性交易是40雷亚尔（约合9英镑），比原来的75雷亚尔（约合17英镑）下降了48%。&lt;/p&gt;&lt;p&gt;　　比拉-米莫萨是里约最老和最大的嫖娼区，超过3000名女性在这片繁华市井的70多个酒吧和夜总会提供服务。但是这些女性的收入最近由于巴西严峻的经济形势而大幅缩水，巴西正在经历着经济衰退最为严重的时期。　　在奥运会开幕前四周的时候，一些米莫萨的性工作者已经开出了白菜价来吸引外国游客。里约城内正在分发一份英文传单，但它显然不为很多人所知。上面说一小时的性服务收费从原来的90雷亚尔（约合20英镑）降至60雷亚尔（约合13英镑），半小时的三人性服务标价是每个女孩40雷亚尔（约合9英镑）。&lt;/p&gt;&lt;p&gt;　　39岁的长期性工作者艾琳-多辛尼娅透露给每日邮报记者称，她们不想看到世界杯重演，业务确实下降的很严重。她表示：“我们对于世界杯期望太高，因为每个人都告诉我们需求是巨大的，我们都以为自己要发财了。我们在路上放置大电视屏给男人们去看足球，我们还提供烧烤和音乐派对。但是几乎没有人来，世界杯时路上几乎是空的。我觉得外国人可能比较担心来到这样的地方，因为它既不靠近海滩也不靠近酒店。而且他们可能也害怕染上什么病。”&lt;/p&gt;&lt;p&gt;　　“只有一些阿根廷人和乌拉圭人，但是他们并不是很有钱，甚至还讨价还价。甚至连我们的巴西常客都不来了，他们都忙着去看足球了。但是这一次，我们不抱任何幻想。我们知道我们会在奥运会期间被遗忘，就像我们在世界杯期间一样。这就是为什么我们要更加的积极主动，我们只想挣些钱来谋生。”&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('44', '&lt;p&gt;　新浪娱乐讯 不知不觉，又到星期五了，号称周五播报员的鹿晗[微博]貌似又有大动作？是的，#鹿晗运动季#在今天正式开启啦！7月11日，新浪娱乐就发微博预告，鹿晗小镇再次开启，神秘大礼盒就是#鹿晗运动季#！别再“北京瘫”、“横店瘫”、“葛优瘫”等各种瘫了，快跟着鹿晗一块儿来运动吧~！&lt;/p&gt;&lt;p&gt;　　一言不合就运动？ 鹿晗早就预告过啦！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('45', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;据台湾媒体报道，霍建华与林心如14日凌晨相约KTV欢唱，出门时林心如却媒体被拍到“大肚照”，疑似坐实怀孕传闻。两性观念开放的年代，娱乐圈中有很多女星曾“带球”出嫁，下面一床情书便来扒扒奉子成婚喜上加喜的10大女星。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('46', '&lt;p&gt;　本文来自“玩儿电影”公众号（id：wan2movie）　　&lt;/p&gt;&lt;p&gt;　　进入暑期以后，每周都有不止一部吸引眼球的新片上线抢市场。观众看得热闹，但为了跟上点评/吐槽的节奏，本玩可能会在这个夏天里，在厕所哭晕N次……&lt;/p&gt;&lt;p&gt;　　但，也是没有办法的事，这就是暑期档嘛。&lt;/p&gt;&lt;p&gt;　　《寒战2》《大鱼海棠》等片的热度还没完全过去，本周的新片已经气势汹汹地杀来——文艺佳作、爱情喜剧、动作喜剧、犯罪悬疑、惊悚、动画……乍看之下眼花缭乱，但其实选择起来依然没啥难度，听我道来。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('47', '&lt;p&gt;据澎湃新闻7月14日报道 7月13日，《华尔街日报》援引知情人士称，万达集团正与维亚康姆（Viacom）进行磋商，欲收购对方旗下公司派拉蒙影业（Paramount Pictures）49%的股份。但该消息还未得到万达方面的官方确认。&lt;/p&gt;&lt;p&gt;　　但现在，维亚康姆内部分成了两派：目前维亚康姆最大股东、现年92岁的亿万富翁萨默•雷石东（Sumner Redstone）竭力反对该交易的进行；而另一边，包括董事长和首席执行长Philippe Dauman在内的维亚康姆高管主张出售派拉蒙影片部分股权，来获得急需的现金。同时，维亚康姆正在为派拉蒙影业寻求80亿-100亿美元的估值。&lt;/p&gt;&lt;p&gt;　　报道称，还有一位投资者也在寻求洽购派拉蒙影业的股份。维亚康姆第二大股东Mario Gabelli曾在2015年12月表示，维亚康姆应当联络阿里巴巴，以围绕派拉蒙股权出售事宜展开商谈。&lt;/p&gt;&lt;p&gt;　　在今年2月份的时候，维亚康姆的CEO菲利普•道曼就曾宣布，正在寻找战略投资人，将出售派拉蒙的少数股权。派拉蒙影业2015年的财报数据显示，公司营收10.25&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('48', '&lt;p&gt;新浪娱乐讯 第18届台北电影奖16日晚间在台北举行，许玮甯以《红衣小女孩》、《失控谎言》、短片《世纪末的华丽》夺下影后宝座，也是台北电影奖史上首度以三部作品同时得奖，许玮甯硬咽感谢工作人员与家人，不免被问到是否与旧爱阮经天复合？她表示：“先不回应了，把焦点放在电影上吧。”合作鬼片《红衣小女孩》的黄河也擒下影帝，备受瞩目的任达华、王大陆、宋芸桦等人则与奖项失之交臂。以原住民为主角的《只要我长大》获得百万首奖、最佳剧情长片、最佳导演奖、最佳新演员奖与最佳剪辑奖，让导演陈洁瑶直呼像作梦。&lt;/p&gt;&lt;p&gt;　　许玮甯三作品夺影后瞄准金马 黄河《红衣小女孩》称帝&lt;/p&gt;&lt;p&gt;　　许玮甯夺得最佳女主角奖，这是她第一个电影奖项。评审认为，她在参赛片中曝光率高，但每次都给予不同的深刻印象，人物的阴暗、罪咎、自我毁灭都活灵活现，展现出她多样化的表演能力，潜力深不可测，评审也一致通过她以三部片同时得奖，显现她演戏的范围广。&lt;/p&gt;&lt;p&gt;　　许玮甯接连获得金钟奖最佳女配角、台北电影奖影后的肯定，她表示：“对我来说很具意义，会觉得自己是在往对的方向走。”也希望把年底的金马奖当目标。许玮甯上台时，一直告诉自己不要哭，就怕像去年领金钟奖时讲话一直发抖，这次比较冷静。&lt;/p&gt;&lt;p&gt;　　合作《红衣小女孩》的黄河夺得最佳男主角奖，他18岁就夺得金钟视帝，这是他首座电影影帝奖项，评审认为，虽然电影剧情不在他、戏份也不多，但他从气质到小动作，都细致具现了一个被现实压迫的年轻人，并让观众记住该角色，评审团主席舒琪说：“越平凡的角色越难演。”&lt;/p&gt;&lt;p&gt;　　黄河完全没有预想到自己得奖，当颁奖人念到他名字时眼睛瞪的超大，他感谢恩师易智言导演，表示：“他对我影响很大，没有他就没有我。”他17岁就就出道，26岁的他经历演艺生涯起伏，曾长达一年多没拍戏，妈妈问他：“怎么每天都待在家。”黄河只能不停充实自己、把握每个机会。&lt;/p&gt;&lt;p&gt;　　庄凯勋、简嫚书以《菜鸟》囊括男女配角 两人获得首座电影奖&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('49', '&lt;p&gt;朋友圈已经随着网络的普及成为了许多人日常生活中的一个组成部分，产生了任何想法、发生了某件事情第一时间并不是和身边人分享，而是组织一下语言发朋友圈。科技紫微星座网今天就要为大家揭秘，在12星座好友的可见范围内，千万别发这些内容，否则你就等着被屏蔽吧&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('50', '&lt;p&gt;2017年将是苹果iPhone诞生的第十个年头，在这样一个特殊的日子，全新的iPhone8或7s也将以崭新的面貌展现在用户面前，根据内部人士的爆料和分析师的预测，下一代iPhone8无论在材质还是功能上都将有飞跃，其中可以确定的是明年的iPhone将使用OLED屏幕。&lt;/p&gt;&lt;p&gt;　　全球OLED供应商包括LG Display、三星、JDI和夏普，无论是谁都想抢得苹果这个超级金主，三星目前垄断全球90% OLED屏幕出货量，是其中最可能成为苹果供应商的厂家，LG Display此前就曾表示会为了争取订单而增大对OLED屏幕的研发投入。对于夏普而言，刚刚被鸿海收购的它们亟需一个好的机会打翻身仗，所以争取苹果 明年的订单将非常迫切。&lt;/p&gt;&lt;p&gt;　　按照原来的计划，鸿海预计会在今年6月份结束之前完成对夏普的收购，只不过由于中国大陆的反垄断审查耗时较长，收购进度并没有像鸿海所想象的那样快。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('51', '&lt;p&gt;5月底我们曾经报道了三星A9 Pro在海外开售的消息，不过根据最新消息，三星A9 Pro的销售范围将仅限亚洲市场。也就是说三星A9 Pro将成为一款名副其实的亚洲特供机。 &amp;nbsp; 三星A9 Pro拥有一块6英寸的大屏幕，或许是考虑到如此大的机身尺寸在某些国家和地区可能不受欢迎，三星A9&amp;nbsp;Pro才选择只限定在亚洲范围开卖。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp; 除了6英寸屏幕，三星A9 Pro的主要卖点还包括骁龙652处理器、4GB RAM+32GB ROM、800万像素+1600万像素的摄像头组合、5000毫安时电池和Android 6.0.1系统。在中国市场其早在数月前就已经开卖了，售价2999元人民币。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('52', '&lt;p&gt;魅族已经宣布将在7月19日正式发布新旗舰MX6。此前，魅族联合创始人、总裁白永祥表示，魅族把PRO 6的很多工艺带给了MX6，供应链部门也正在努力让MX6成为备货最好的梦想机。&lt;/p&gt;&lt;p&gt;　　此外，白永祥强调，MX6的成本提高了，售价也会提升，但他相信MX6会是两千元价位上设计和工艺最好的产品。&lt;/p&gt;&lt;p&gt;　　如此来说，MX6的售价就不是原来的1799元起了，会是多少呢？&lt;/p&gt;&lt;p&gt;　　今日，有网友曝光了一张魅族内部文件，文件显示，即将发布的MX6、智能保护套搭售价格为2299元，看来是要一起亮相了。&lt;/p&gt;&lt;p&gt;　　据此前曝光的高清谍照来看，这款保护套应该是皮革材质，外观简洁大方，目前已知支持开盖唤醒、合上休眠，是否还有更多功能暂时不详。保护套边缘配备了LED呼吸灯，还有不同颜色变化。预计，LED灯将用来提示手机来电、短信等通知。&lt;/p&gt;&lt;p&gt;　　据悉，魅族MX6将采用1080p屏幕（预计是5.5英寸），搭载联发科Helio X20（MT6797）处理器，4GB内存+32GB机身存储，摄像头组合为前置500万像素+1200万像素，运行系统为Flyme 5.2.2（Android 6.0）。据悉，电池容量预计在3000mAh以上。&lt;/p&gt;&lt;p&gt;　　这价格大家觉得贵吗？&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('53', '&lt;p&gt;巴西里约奥运会开幕在即，作为奥运会的主赞助商之一，三星也顺势推出了一款里约奥运限量版的Galaxy S7 Edge。　　在造型上，这款奥运限量版的S7 Edge与普通版基本相同，不过它在设计中大量运用奥运五环的颜色对机身进行点缀。其中，机身左侧的音量键就用上了奥运五环中的绿色。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('54', '&lt;p&gt;　经过多轮爆料和三星官方的预热，我们对三星Note 7的外观、配置和发布日期已经有了基本的了解，变数不会太大。接下来，我们所关心的就是其究竟什么时候开卖了，毕竟咱们买得到才是王道。关于这一点，韩国媒体最新消息称，三星Note 7有望在发布当日就开卖，也就是8月2日。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　回顾上代Note旗舰，三星Note 5是在发布后大约一周才实现首发的，Note 7今年这上市速度有点惊人了。据了解，2016年里约奥运会将在8月5日开幕，三星此举正是为了最大化地利用奥运热，并且已经为8月2日首发供货做好了准备。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('55', '&lt;p&gt;编者按：太阳黑子是太阳活动水平的标识，但是在2016年6月底，太阳上连续十几天没有黑子，难道很快要进入太阳活动低年？太阳马上要进入休眠状态了？地球要进入新一轮“冰河期”了？&lt;/p&gt;&lt;p&gt;　　“冰河期”真的要来了吗？&lt;/p&gt;&lt;p&gt;　　最近，随着第24活动周太阳活动水平的不断下降，太阳上的黑子真是越来越少 了，以前还可以掰着指头数，现在恐怕只能握着拳头数了。甚至在6月下旬开始的十几天里，太阳上便没有了黑子，明亮的太阳上干干净净的。&lt;/p&gt;&lt;p&gt;7月5日没有黑子的太阳(SDO卫星观测)　&lt;/p&gt;&lt;p&gt;　　眼瞅着这么冷冷清清的太阳，仿佛要进入休眠状态了。这不禁让我们想起了去年流传甚广的一篇报道——《太阳2030年将休眠 地球即将步入冰河时期》。文章回忆起&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('56', '&lt;p&gt;资料图：亚马逊雨林被开垦用来种大豆。&lt;/p&gt;&lt;p&gt;　　中新网7月16日电 据外媒报道，最新《科学》期刊上的一份研究报告称，地球陆地上58%地区的物种多样性完整指数已低于安全值。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　该份报告指出，受此冲击最大的是美国、阿根廷、南非与中亚的草原地区，这些地区的动物与植物数量皆因人类活动而减少。&lt;/p&gt;&lt;p&gt;　　报告指出，陆地表面约58%地区的物种“完整性”已经降至安全界限以下；这主要是农业用地、道路与城市发展持续扩充所致。全球大约71%的人口居住在这些陆地上。&lt;/p&gt;&lt;p&gt;　　研究人员在18659个地点进行了238万次记录，共录得39123个生物物种。他们以此数据界定，相较于没有人类活动的地方，所谓“安全”地方的在地物种数量必须至少达到90%水平。&lt;/p&gt;&lt;p&gt;　　报告主要作者为伦敦大学学院学者纽博尔德，他说：“如果我们任由生物多样性受破坏，到头来农业发展将难以支撑下去。”&lt;/p&gt;&lt;p&gt;　　物种多样性水平降低后，依靠蜜蜂等昆虫授粉传播的农作物、为粮食作物生产养分与水分等的健康土壤，以及吸收大气中二氧化碳以应对气候暖化的树林等自然生态服务系统将面对更大风险。&lt;/p&gt;&lt;p&gt;　　该报告的另一作者珀维斯表示，“许多决策者最担心的是经济衰退，殊不知生态&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('57', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　文章来源：蝌蚪五线谱&lt;/p&gt;&lt;p&gt;　　科学家已经发现军舰鸟能长时间的飞行，但是近期的一项研究结果令人有点震惊，研究人员发现军舰鸟的飞行时间可以长达两个月！&lt;/p&gt;&lt;p&gt;　　发表在《科学》杂志上的新研究发现，居住在印度洋和太平洋的大型的军舰鸟，借助上升气流，每隔六分钟挥舞着巨大翅膀，从而飞行几百英里。&lt;/p&gt;&lt;p&gt;　　研究团队在军舰鸟的后颈贴上了极轻的设备。该小型太阳能设备与卫星相连，其功能包括GPS跟踪、心率监视器、加速计和测高计。它们的重量只有10克，可以在跟随着军舰鸟的同时保证其的自由飞行。&lt;/p&gt;&lt;p&gt;　　研究人员知道军舰鸟拥有其轻的体重，并且体重分布在大翅膀上，这有助于它们在空中持久的飞行。因为大型的军舰鸟没有防水的羽毛，他们必须持久的在空中飞行，来防止在水面上降落。&lt;/p&gt;&lt;p&gt;　　发现大型军舰鸟的飞行模式&lt;/p&gt;&lt;p&gt;　　研究团队认为，在印度洋的核心地段，大型的军舰鸟充分利用这里独特的气候，实现长久俯冲后的高飞和滑翔过程。一年四季，巨大的印度洋仍然表现得相当平稳的，这里被称为赤道无风带。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　大型的的军舰鸟坚守在赤道无风带的周围，环绕在这周围数天甚至数月，因为它们发现在赤道无风带的周围的天气相当恒定和可靠，充满了有利于飞升的上升气流。在这赤道无风带周围飞行时，军舰鸟只花费它们10%的时间去寻找食物。而剩余的时间它们都用在了从云到积雨云的飞翔，每天飞行的距离长达400英里。&lt;/p&gt;&lt;p&gt;　　研究团队表示，他们很可能在长途跋涉的空气中睡觉。&lt;/p&gt;&lt;p&gt;　　在之前的研究中，研究人员认为大型军舰鸟由于云层中可能存&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('58', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　文章来源：中国科学报 微信公众号&lt;/p&gt;&lt;p&gt;　　专家建议尽快完善相关法律规避伦理风险和社会争议&lt;/p&gt;&lt;p&gt;　　从修改植物基因，到改变蝴蝶翅膀的图案，再到修改人类细胞……以CRISPR为代表的基因编辑技术风靡生命科学领域。&lt;/p&gt;&lt;p&gt;　　日前，在香山科学会议第564次学术讨论会上，专家指出，我国基因编辑研究工作正在向源头创新转移，现阶段应大力推动该领域的研究及应用，并及时制定严格有效的监管措施和伦理规范，保证基因编辑下游应用快速健康有序发展。&lt;/p&gt;&lt;p&gt;　　向源头创新转移&lt;/p&gt;&lt;p&gt;　　今年5月，河北科技大学生命科学与工程学院副教授韩春雨等人的最新成果：一种全新的基因编辑技术(NgAgo-gDNA)，引发了全球生物学研究者的关注。&lt;/p&gt;&lt;p&gt;　　在此之前，基因编辑界最大腕的“明星”是美国结构生物学家詹妮弗·杜德纳发明的CRISPR/Cas9，科学界称之为基因“魔剪”。&lt;/p&gt;&lt;p&gt;　　而更早之前，包括ZFN、TALEN等在内的基因编辑技术的原创者也都不是中国科学家。&lt;/p&gt;&lt;p&gt;　　“韩春雨实验室的成果代表了我国在基因编辑源头技术开发上的重要突破。”&lt;/p&gt;&lt;p&gt;　　此次会议执行主席之一、中科院院士周琪告诉《中国科学报》记者，“这标志着中国的基因编辑研究工作已经在向源头创新转移。”&lt;/p&gt;&lt;p&gt;　　研究者相信，中国科学家在基因编辑技术上的一系列具有国际影响力的成果，将推动基因修饰技术在人类疾病研究等领域的快速发展。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('59', '&lt;p&gt;央视财经讯 我国年内第14次成品油零售价调价窗口期，于7月21日24时开启。经过前两次搁浅后,国家发改委宣布，本次成品油价格迎来年内第二次下调！汽、柴油每吨分别下调155元和150元；全国平均来看折合90号汽油每升下调0.1元，0号柴油每升下调0.13元，&lt;strong&gt;油价下调原因&lt;/strong&gt;，&lt;strong&gt;中国油价下调&lt;/strong&gt;，&lt;strong&gt;今日油价下调&lt;/strong&gt;，92号汽油均每升下调0.11元。按一般家用汽车油箱50L的容量估测,加满一箱汽油将节省约5元。&lt;/p&gt;&lt;p&gt;此次成品油零售价格下调，&lt;strong&gt;油价下调整最新消息&lt;/strong&gt;，&lt;strong&gt;油价下调&lt;/strong&gt;，国内汽柴油零售市场将再次全面回归“五元时代”。对于终端消费者来说，&lt;strong&gt;油价下调最新消息&lt;/strong&gt;，降低出行成本无疑是个好消息。以北京为例，&lt;strong&gt;油价下调图片&lt;/strong&gt;，#92#号汽油将从6.05元/升降至5.94元/升，而上海#92#号汽油则从6.01元/升降至5.90元/升。&lt;/p&gt;&lt;p style=&quot;text-align:center&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;6月份开始,国际原油价格一直处于45-52美元/桶的价格区间内震荡盘整。前两次调价周期(6月9日-7月7日)内,按国内成品油价格机制,调价金额每吨不足50元,成品油价格不调整。&lt;/p&gt;&lt;p&gt;多家机构认为,本轮调价周期内,因美元上涨,美国库欣地区等全球各地燃油库存大涨,加重了市场对供应过剩的忧虑,导致国际油价震荡下行。&lt;/p&gt;&lt;p&gt;截至7月19日收盘,伦敦洲际交易所布伦特原油期货结算价报48.18美元,WTI原油期货结算价报47.6美元；纽约商品交易所原油期货结算价收报45.45美元,相比6月8日的51.23美元,下跌幅度为11.28%。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;，&lt;strong&gt;油价下调再爽约&lt;/strong&gt;，&lt;strong&gt;油价下调时间&lt;/strong&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('60', '&lt;p&gt;【环球网报道 记者 余鹏飞】菲律宾总统杜特尔特日前暗示了他愿意按照前总统菲德尔·拉莫斯的建议，搁置南海仲裁案的“裁决”，恢复与中国的双边对话。杜特尔特就此解释称，“中国有钱，美国是没有钱的”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　据《菲律宾商报》7月24日报道，菲律宾总统杜特尔特22日发表演讲称，菲德尔·拉莫斯向其建议在与中国对话时，搁置南海仲裁案的“裁决”是没有问题的。与中国的经济合作可帮助菲律宾的南部群岛致富。&lt;/p&gt;&lt;p&gt;　　不过，菲律宾最高法院高级陪审法官加彪(音译)22日声称，重启与中国的谈判也是有前提的，即中国将不提到其“九段线”主张。此前菲律宾总检察长卡利达和外交部长亚赛表示，菲律宾在与中国政府谈判时将必须利用“裁决”。&lt;/p&gt;&lt;p&gt;　　报道称，菲律宾总统杜特尔特表示，菲律宾仍然希望与中国友好，菲律宾打算建设经济区和农场到市场的道路，“中国有钱，不是美国。美国是没有钱的”。&lt;/p&gt;&lt;p&gt;　　对于所谓的“南海仲裁”，中国政府已经多次表示，由菲律宾阿基诺政府单方面提起的所谓仲裁，扭曲《联合国海洋法公约》宗旨，挑战作为地区规则的《南海各方行为宣言》，是打着法治和规则旗号反法治和规则。南海仲裁从一开始就是个非法的东西。中方根本不承认、也绝对不会接受这样一个非法的、完全违背了国际法的这么一个单方面提起来的所谓仲裁案，中方会继续表明立场。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('61', '&lt;p&gt;北京时间7月24日，据雅虎体育报道，凯文-杜兰特今夏加盟勇士队的决定引起了很大的争议，但是据阿杜本人表示，从那之后，从来没有人当面抨击过他的这个决定。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　自从杜兰特在7月4日宣布加盟勇士队之后，外界的反应非常激烈，雷霆队球迷开始烧杜兰特的球衣；查尔斯-巴克利对他的决定表示失望，并称杜兰特这是“想骗一个总冠军”；甚至连他的两位昔日队友坎特和亚当斯都在推特上唱双簧并讽刺杜兰特背叛球队。&lt;/p&gt;&lt;p&gt;　　虽然杜兰特已经听到了那些批评的声音，但是他表示外界对这个决定的反应并不是太糟糕。&lt;/p&gt;&lt;p&gt;　　“所有那些批评的声音都发生在网络上。我从来没有遇到过一个人当面说我坏话。”杜兰特说道，“对于外面的批评家来说，他们很容易告诉你应该做什么以及怎么去做。我是那个需要经历整个过程的人，所以我真的不能去在意外部的噪音。工作没有停止，一切保持原样。”&lt;/p&gt;&lt;p&gt;　　正如杜兰特说的，他在今夏从篮球的角度做出了一个对他来说最有利的决定，所以他愿意承担一切后果。此外，他强调自己只会在意那些真正爱他的人，至于其他人，杜兰特根本不会在乎他们的评论。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('62', '&lt;p&gt;佩莱出席战申花赛前发布会&lt;/p&gt;&lt;p&gt;　　齐鲁网济南7月23日讯 （ 记者 李淼 实习记者 薛睿 ） 中超联赛第19轮山东鲁能主场迎战上海申花，鲁能主帅马加特出席了赛前发布会，主帅马加特表示申花是一支强大的队伍，明天不会期待很多进球。&lt;/p&gt;&lt;p&gt;　　马加特：申花是强大的对手&amp;nbsp;明天不会期待很多进球&lt;/p&gt;&lt;p&gt;　　发布会上，鲁能主帅马加特表示申花是一个强大的对手，“在几周前足协杯的比赛中对阵上海申花使我们积攒了经验，我认为那是一场不错的比赛。申花向我们展示出他是一支强大的球队，甚至在过去的比赛中他是最强大的一支。”&lt;/p&gt;&lt;p&gt;　　在此前上海滩新旧霸主上海申花与上海上港的德比之战中，申花外援登巴巴断腿重伤，对此，主教练马加特表示：“登巴巴受伤对我们来说是好是坏不能 判断，但对申花来说是一种损失。通常一个队员的重伤能让他的队员更众志成城，因此我们面对的是一场艰苦的比赛，想拿下三分不是简单的事。”&lt;/p&gt;&lt;p&gt;　　过去的两场比赛鲁能都以大比分胜利，而鲁能是否还有进攻的潜力成为大家关注的话题，对此，马加特表示，“就像刚才说的明天我们面对是更强大的对手，会有更多困难。过去两场球队的确都进了很多球，但对手开场都为我们制造了麻烦，直到比赛最后我们才确定胜利，因此明天不会期待很多进球。”&lt;/p&gt;&lt;p&gt;　　马加特上任后果敢的使用年轻小将让球迷十分惊喜，而对于明天的首发名单，马加特坦言，“我的比赛名单主要通过球员训练表现和对手而决定，过去他们表现很好，明天的首发名单不会有大改变，但会有一两个人退出首发名单，会有其他人补充进来。”&lt;/p&gt;&lt;p&gt;　　佩莱：集中精力打好比赛&amp;nbsp;希望进球帮助球队胜利&lt;/p&gt;&lt;p&gt;　　跟随主教练马加特出席发布会的是上一轮联赛中刚刚打入中超首球的外援佩莱，佩莱先是祝福了重伤的登巴巴，“关于登巴巴我为他送上祝福，祝他早日康复。”对于明天的比赛，佩莱说，“从我第一天来就知道每场比赛对我们都很重要，每一分都很重要，这从积分榜上可以看出。之前几场球队有很好的表现，希望接下来我们也有好的表现。主教练之前和上海交过手，但我是第一次，从排名来看他们是很强的对手，所以90分钟里我们要集中精力，打好这场比赛。”&lt;/p&gt;&lt;p&gt;　　上轮联赛中，新援佩莱首发出场并打入了自己的中超首颗进球，而对于明天比赛的进球目标，佩莱表示，“首先很高兴我已经取得联赛进球。对一个前锋大家最期待的就是进球，进球建立在球队胜利的基础上，作为前锋我希望进球帮助球队胜利，如果我的进球能帮球队胜利或者拿到奖杯，那是我所期待的。”&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('63', '&lt;p&gt;李源一进球后被队友包围庆祝&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　新浪体育讯　　2016赛季中超联赛第19轮，天津泰达客场1-3负于杭州绿城。虽然输掉了比赛，但天津泰达本场比赛也有收获。前国奥主力中场李源一本场比赛奉献一脚世界波，一度为天津泰达扳平比分，在重返天津泰达后踢得第一场中超比赛中就收获了中超首球。李源一本场比赛25分钟的出场时间虽然不多，但已经超过了他在广州恒大半个赛季的中超出场时间，攻防两端都很积极，表现让人眼前一亮。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('64', '&lt;p&gt;俄罗斯田径之前被判定不能参加里约奥运会，而现在又传来更惊人的消息，据英国媒体《每日邮报》报道，国际奥林匹克委员会准备对整个俄罗斯代表团实行禁赛，代表团387名运动员将无法出战里约奥运会。&lt;/p&gt;&lt;p&gt;　　《每日邮报》周日版了解到，整个俄罗斯奥运代表团都无法参加下个月的里约奥运会，根据他们的消息源，国际奥委会将用最强硬的方式处罚这387名俄罗斯代表团运动员。&lt;/p&gt;&lt;p&gt;　　之前，受到处罚的只是俄罗斯田径代表团，但《每日邮报》表示，今天的裁决结果将排除俄罗斯在自行车、柔道、摔跤等其他项目的夺金希望。这场争论涉及到俄罗斯总统普京的体育部发放类固醇混合物以及在2012年伦敦奥运会前掩盖污染的尿液样本。&lt;/p&gt;&lt;p&gt;　　不过，《每日邮报》也指出，一小部分在国外训练、经过严格的反兴奋剂程序并且没有涉及腐败的俄罗斯运动员，有希望以中立的身份出战奥运会。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('65', '&lt;p&gt;陆浩杰和陆永（右）&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　中新社北京7月23日电 （记者 张素）力拔山兮，壮士出征，中国举重队23日晚从北京兵发里约。这支最“给力”的队伍说：这次要全面超越上届奥运会。&lt;/p&gt;&lt;p&gt;　　自1984年洛杉矶奥运会至今，中国举重队共获29枚金牌，与中国体操队并列“金牌榜”第二。近4届奥运会，除了2008年北京奥运会时豪夺8金，他们在悉尼、雅典、伦敦三次境外参赛所获金牌数均为5枚。&lt;/p&gt;&lt;p&gt;　　这一次，中国举重队派出10名大力士出战10个级别，明确喊出目标：保六争八。女队主教练王国新已是第七次奥运之旅，他将带领四位“90后”女将“保三争四”。面对中新社记者提出对于时差、气温、治安等问题有无担忧，王国新回答：“我们在两年前就已做好全部准备”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　出征仪式上，中国国家体育总局举摔柔运动管理中心主任周进强连用三句诗鼓舞全队士气。“人生能有几回搏”，引自新中国首位世界冠军容国团的誓言；“壮士一去兮不复还”，是借《荆轲歌》号召选手们“抱着必胜信念”；“黄沙百战穿金甲，不破楼兰终不还”，是借《从军行》激发选手们对金牌的渴望。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('73', '&lt;p style=&quot;white-space: normal;&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;小龙女与杨过终于结婚了，这个无论是在小说还是影视作品中均为出现的场景，今天(7月19日)将在现实中出现！7月19日，“过儿”陈晓和“小龙女”陈妍希将在北京的雁西湖举办婚礼！&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;陈晓陈妍希婚礼内场布置&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('74', '&lt;p&gt;陈乔恩以前一段说自己爱吃睾丸，尤其是鸡睾丸的视频被网友扒了出来，引起热议。对此陈乔恩透露自己的丰胸秘诀是吃鸡睾丸。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;陈乔恩&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('75', '&lt;p&gt;今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。透露获内地老板朋友扫写真，预计中港合共售出近3000本。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;24岁何洛沂穿低胸装展露事业线&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　新浪娱乐讯 北京时间7月24日消息，据香港媒体报导，今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。昨天（7月23日）她凑热闹入书展宣传，以低胸上衣配短裤，露事业线加长腿赠兴。她透露获内地老板朋友扫写真，预计中港合共售出近3000本。&lt;/p&gt;&lt;p&gt;　　拒50万饭局&lt;/p&gt;&lt;p&gt;　　追问有没有老板出价邀约饭局？何洛沂表明内地老板只是普通朋友，但另有人出价：“试过几次，其中有人在微博户口私讯我说出50万邀饭局，但我没回复。因为是原则不是价钱问题，觉得不道德，约吃饭出价已不合理，还不淮我带助手或朋友出席，感觉不舒服。”她还不停暗讽其他写真对手，例如自己没干爹支持、有人年过30岁出写真感觉老、和自己写真没有修图，句句有骨。她拒开名讽刺，认为读书眼睛雪亮，一看便明白，而她本人则敢素颜上阵，强调自己真材实料。（颖颖）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('76', '&lt;p&gt;新浪娱乐讯 在承诺不再拍“大型动作片”四年后，62岁的成龙[微博]在这个夏天又出山了。虽没亲自担任导演，但《绝地逃亡》那笑料和动作齐飞的熟悉配方、那中外混血的熟悉味道，早已将他出卖。这次他多了约翰尼·诺克斯维尔这个在片中成事不足败事有余的老外拍档，多了范冰冰[微博]的倾情助阵，也多了些力不从心的自知。但大哥依然是那个爱玩命、爱“教年轻人”、爱感叹苦日子里出光辉的大哥。年过六旬的成龙为何坚持扮演动作英雄？他如何教育王大陆[微博]、黄子韬[微博]、吴彦祖[微博]和谢霆锋？怎么惊险万分地掉进水中、假戏真做到喊救命？约翰尼和范冰冰的吻戏隐藏着怎样的心机？耀莱签约吴亦凡之后有什么样的远大计划？一切的一切，都在这次访谈中解答。&lt;/p&gt;&lt;p&gt;　　三十年坚持成式动作喜剧 只因影迷支持依旧&lt;/p&gt;&lt;p&gt;　　新浪娱乐：首先请问成龙，至今你专注于“成龙式”动作喜剧已有三十余年了，是什么样的动力让你坚持继续拍下去？&lt;/p&gt;&lt;p&gt;　　成龙：是全世界的影迷，以及新的观众。我自己也很喜欢拍动作。以前拍动作的时候，大家看到我做那些平常人做不到、却又有机会去做的东西，都说“哇”。比如说一般是坐直升机，而我是吊在直升机外面。现在继续做，就是让大家觉得：“哇，成龙到现在还可以这样子！”&lt;/p&gt;&lt;p&gt;　　所以感谢大家的支持。每一个月、每一天我都收到大家寄来的信或是基金会提供的钱。我没法一一致谢，只能用好的电影来回报大家。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('77', '&lt;p&gt;不知不觉7月已到月尾，大雨也从南方下到了北方，可就算大雨让整座城市倾倒，影院也会为你上新片……&lt;/p&gt;&lt;p&gt;　　但也有觉得暑期档太挤，移到中秋档的《大话西游3》，还有作别七夕档进军贺岁档的《三少爷的剑》。就让小玩向这两部改档的电影挥挥手，然后再激动的和你们讲讲这周的新片情况。&lt;/p&gt;&lt;p&gt;　　相较于前几周的清一色的国产片，这周影院里多了日本、印度和美国的片子，票房厮杀战就更厉害了，大家的选择空间也更多了一些。新片一共有十部，但并不是每一部都值得去看哦。&lt;/p&gt;&lt;p&gt;　　《绝地逃亡》&amp;nbsp;2016-7-21&lt;/p&gt;&lt;p&gt;　　导演： 雷尼·哈林&lt;/p&gt;&lt;p&gt;　　主演： 成龙 /范冰冰 / 约翰尼·诺克斯维尔 / 曾志伟&lt;/p&gt;&lt;p&gt;　　类型： 喜剧 / 动作&lt;/p&gt;&lt;p&gt;　　成龙的动作喜剧，总感觉说完这七个字就已经明白这部电影是怎样的了……&lt;/p&gt;&lt;p&gt;　　虽然影片宣传的时候主打成龙和范冰冰，但其实范冰冰戏份少到打酱油，主要是成龙和约翰尼·诺克斯维尔两人从俄罗斯一路逃到香港的故事，有种风光旅游穿插剧情的感觉。&lt;/p&gt;&lt;p&gt;　　以前成龙的电影最大的看点就是干净利索的打斗了，可今年成龙已经62岁了，都到了不应该叫大哥，应该叫大爷了的年龄了。所以整部电影看下来，更多的也许是辛酸吧……&lt;/p&gt;&lt;p&gt;　　关注“玩儿电影”公众号（id：wan2movie）有机会抢票。&lt;/p&gt;&lt;p&gt;　　《泰山归来：险战丛林》&amp;nbsp;2016-7-19&lt;/p&gt;&lt;p&gt;　　导演： 大卫·叶茨&lt;/p&gt;&lt;p&gt;　　主演： 亚历山大·斯卡斯加德 / 玛格特·罗比 / 塞缪尔·杰克逊&lt;/p&gt;&lt;p&gt;　　类型： 动作 / 冒险&lt;/p&gt;&lt;p&gt;　　古老传说的现代新诠释，强调了殖民时代背景，企图从人性入手让整个故事更加有深度，不过导演大卫耶茨功力所限，结果显得四六不靠。&lt;/p&gt;&lt;p&gt;　　而颜和肉更是拉动这部电影票房的两架大马车！主角颜值都奇高，E大一言不合就爆衫，优美的人鱼线简直可以让人原谅影片的一切问题，玛格特罗比爱捆绑，各种捆绑湿身戏，美的不要太动人~配角方面赛缪尔杰克逊、瓦尔兹的表现也十分抢眼。影片中热带丛林环境和动物还会让人屡次想起《奇幻森林》。&lt;/p&gt;&lt;p&gt;　　《哆啦A梦：新·大雄的日本诞生》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;　　导演： 八锹新之介&lt;/p&gt;&lt;p&gt;　　主演： 水田山葵 / 大原惠美 / 嘉数由美 / 木村昴 / 关智一&lt;/p&gt;&lt;p&gt;　　类型： 动画&lt;/p&gt;&lt;p&gt;　　看见蓝胖子，必然就得说到情怀，既然如此，那就请让我自动变身脑残粉吧！因为太多人的童年都是哆啦A梦和大雄陪伴的，而预告里一句“一起天真”简直直戳泪点，让人想立马冲进电影院刷个几遍。&lt;/p&gt;&lt;p&gt;　　虽然影片故事只是在89年剧场版的基础上进行重制和改良，依旧是讲述的大雄一行人穿越到远古时代后卷入部落纷争的故事。但经典并不会被时代所遗弃，现在看感动也还在。&lt;/p&gt;&lt;p&gt;　　最最最为重要的是，这是良心的2D，人物也还是原来熟悉的原画造型！想想“伴我同行”的CG造型，简直感动的要流泪……&lt;/p&gt;&lt;p&gt;　　同样，在“玩儿电影”公众号上可以抢票。&lt;/p&gt;&lt;p&gt;　　《天亮之前》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;　　导演： 吴中天&lt;/p&gt;&lt;p&gt;　　主演： 郭富城 / 杨子姗 / 郝蕾 / 安志杰&lt;/p&gt;&lt;p&gt;　　类型： 爱情&lt;/p&gt;&lt;p&gt;　　简单来说就是一个欠债赌徒和一个风尘女的爱情故事。&lt;/p&gt;&lt;p&gt;　　杨子姗饰演的女主就算被赌徒骗尽钱财，也会愿意去相信一次，再赌一次，这样的设定致敬了经典的爱情电影《卡比利亚之夜》。可海报上“用你一夜，赌我一生”这种乡村文艺的宣传，档次真得就立马down下去了呢……&lt;/p&gt;&lt;p&gt;　　编剧任鹏，还写过《催眠大师》的剧本，所以剧情流畅性和逻辑性还是挺好的，只是再浪漫的爱情都容易陷入套路的深渊，好在男女主演技都在线，至少不会像某些青春片那样跳戏= =&lt;/p&gt;&lt;p&gt;　　这部片子我们也有票，关注“玩儿电影”公众号可参与抢票。&lt;/p&gt;&lt;p&gt;　　《巴霍巴利王：开端》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;　　导演： S·S·拉贾穆里&lt;/p&gt;&lt;p&gt;　　主演： 帕拉巴斯 / 拉纳·达格巴帝 / 安努舒卡·谢蒂 / 特曼娜·芭蒂亚&lt;/p&gt;&lt;p&gt;　　类型： 动作 / 历史 / 冒险&lt;/p&gt;&lt;p&gt;　　印度斥巨资（约等于1.69亿人民币）打造的史诗级神片，号称印度指环王的野心之作。在特效上面虽然不及好莱坞，但也可以看到印度人努力追赶的诚意。&lt;/p&gt;&lt;p&gt;　　另外，因为电影是以神话为背景的片子，所以里面很多故事情节都是基于……脑洞制作的，各种开挂各种神展开，一言不合男女主就拥抱在一起从冬天滚到了春天，而演员表演也非常夸张，如果你喜欢细腻不动声色的情感表达方式，可能刚开始会被他们的表演吓到。&lt;/p&gt;&lt;p&gt;　　说起印度片里惯有的歌舞，在这部电影里也有出现，并且美轮美奂，堪称亮点。&lt;/p&gt;&lt;p&gt;　　所以，如果你想周末在电影院里愉快地吐吐槽、过过眼瘾，可以去看一下这部邻国神片。同上，“玩儿电影”公众号上有赠票活动。&lt;/p&gt;&lt;p&gt;　　《泡沫之夏》&amp;nbsp;2016-7-21&lt;/p&gt;&lt;p&gt;　　导演： 赖俊羽&lt;/p&gt;&lt;p&gt;　　主演： 黄灿灿 / 罗仲谦 / 严禹豪&lt;/p&gt;&lt;p&gt;　　类型： 剧情 / 爱情&lt;/p&gt;&lt;p&gt;　　《泡沫之夏》这部玛丽苏小说可谓是一代人的青春小读物，可是，敲黑板划重点，这是十年前的小说，十年前啊！！！什么车祸梗，失忆梗，三角恋梗，拜托，你以为这10年大家都没长大么？&lt;/p&gt;&lt;p&gt;　　而且这个选角，小说里形容男主欧辰是忧郁俊美冰冷的少爷，你再看看上图的男主……大哥，你认真的样子真得好像街边贴膜的……真心比何润东还毁欧辰0.0&lt;/p&gt;&lt;p&gt;　　如果硬要在大S那款剧版的《泡沫之夏》和这款黄灿灿的电影版《泡沫之夏》里选一个优胜者的话，我宁愿选择此生都没看过这部小说。&lt;/p&gt;&lt;p&gt;　　不过如果你要看这部电影的话，我们在“玩儿电影”公众号上有赠票活动。&lt;/p&gt;&lt;p&gt;　　《魔都凶音》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;　　导演： 彭鹏华&lt;/p&gt;&lt;p&gt;　　主演： 姜雯 / 于小伟 / 张瑶 / 张辛苑 / 王笑天&lt;/p&gt;&lt;p&gt;　　类型： 悬疑 / 惊悚 / 恐怖&lt;/p&gt;&lt;p&gt;　　看海报以为是小三被正房捉奸，而偷情男女将正房关入小黑屋，正房积怨，化身鬼魂报复他们的故事。&lt;/p&gt;&lt;p&gt;　　但其实并不是，剧情介绍说是女主刘小兰非要作死进一间别人都不去的房间进行探险这样……&lt;/p&gt;&lt;p&gt;　　嗯，感觉这个电影看海报开开脑洞就可以过去惹，所以没票送。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('78', '&lt;p&gt;杨子姗&lt;/p&gt;&lt;p&gt;　　新浪娱乐讯 面前的杨子姗[微博]一身黑色紧身小西装，长衣长裤，利落爽快，与《天亮之前》中那个“风尘女子”的人设相去甚远。这是生活中的杨子姗喜欢的穿衣风格，中性，再加那么一点酷，至于风情，她更多地留给了故事中的角色。&lt;/p&gt;&lt;p&gt;　　《天亮之前》是杨子姗与老公吴中天自公布婚讯以来的首度合作。此前，二人异地恋终成正果的爱情故事已遍传网络，声情并“貌”地甜倒了一片单身狗。不过当这对颜值演艺俱登对的小情侣调整身份变成了演员与导演，二人却好像“疏离”了不少，据说，连男一号郭富城[微博]，都是拍了一半戏才突然意识到二人之间可能存在着非比寻常的特殊关系……&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('79', '&lt;p&gt;7月22日太阳进入狮子座的影响&lt;/p&gt;&lt;p&gt;　　7月22日：太阳进入狮子座&lt;/p&gt;&lt;p&gt;　　（查看你的本命盘&amp;gt;&amp;gt;）&lt;/p&gt;&lt;p&gt;　　太阳这颗星体是狮子座的守护星座，象征着绝对的权力与光芒，富有活力与表现力，并且在执行力度上非常强劲，当这颗星体再次进入入庙位置的狮子座，对大众而言，经历过六月的沉淀与休憩，意味着下半年的真正开始与再次出发。&lt;/p&gt;&lt;p&gt;　　之前讲述过上半年对这一整年而言都是一种磨砺，而真正的重头戏则在下半年太阳进入狮子座之后，届时不论是对社会整体，还是我们自身来讲，都会经历一场蜕变。如果在上半年或者六月期间对某些事还有所逃避，那么在这个当下你会主动去解决，不再让问题蔓延。&lt;/p&gt;&lt;p&gt;　　在社会角度上，可能会面临经济政策的调整，届时会影响到很多人在就业与购房方面的意向；而对个人来说，这会是很多人考虑跳槽或者已经辞职准备新工作的阶段，这个时候你会觉得自己的想法非常重要，也会更多考虑自己的理想与未来，而变得不那么容易接受生活中的委屈。因为狮子座本身所特有的号召性，这会是很多人主动号召社会力量达成某些计划的时期，但是当多个人争夺同一利益时，角逐与争执再所难免，还是想清楚自己要的是什么才好。&lt;/p&gt;&lt;p&gt;　　行星影响强度：★★★★☆&lt;/p&gt;&lt;p&gt;　　注意的问题：&lt;/p&gt;&lt;p&gt;　　如果在这个当下你希望辞职或者对自己的人生做出另一番打算，那么就要想清楚自己的计划是不是真的可行，如果你的计划是七月中之前就已经筹划好的，那么基本上问题不大。可是如果是这个月底才开始有的新想法，还是慎重考虑，别到最后变成死撑着空谈理想，那就真的是美梦一场了。&lt;/p&gt;&lt;p&gt;　　绝对不能碰的禁区：&lt;/p&gt;&lt;p&gt;　　理想一定是会建立在现实基础之上的，谈理想，先谈钱。&lt;/p&gt;&lt;p&gt;　　影响范围最大的星座（参考太阳与上升星座）：白羊座、狮子座、射手座、水瓶座、双鱼座。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('80', '&lt;p&gt;如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦~&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;8心动绝招让男人拜倒裙下&lt;/p&gt;&lt;p&gt;　　在崇尚自由恋爱的时代，大多数人不到万不得已都不会走上相亲这条老路，然而不得不承认的是，相亲确实是解决剩女问题最有效的方法之一。如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦！&lt;/p&gt;&lt;p&gt;　　注意一：首次见面一定要让他选地方&lt;/p&gt;&lt;p&gt;　　作为女人，有太多的主意会让男人觉得你想控制他，所以不要有太多的意见。他在电话里问你在什么地方见面，你就说：“听你的吧，哪里都可以啊。”这样一来，你不仅给他小鸟依人的感觉，而且把难题抛给他。&lt;/p&gt;&lt;p&gt;　　注意二：一定要比他晚到几分钟&lt;/p&gt;&lt;p&gt;　　相亲的女人一定不是二十啷当岁的小女孩儿吧，所以如果你到的比男人早，会让人觉得你特急，特上赶着，别听别人说什么准时到的女生给人感觉纯朴，都瞎掰。我们也不是不准时啊，如果他早到10分钟，我们正点到就好了，如果他正点到，我们就晚个两分钟喽~~怎么操作自己想办法。&lt;/p&gt;&lt;p&gt;　　注意三：点菜是个技巧&lt;/p&gt;&lt;p&gt;　　一定一定不要点贵的菜，尤其是你的约会对象是个钻石王老五的时候，他会觉得你想讹他。但是如果你点特便宜的菜他也许会觉得你以后上不了台面儿，所以意思到了就可以了，让他知道你不骄奢，但不是没吃过没见过。通常我的建议都是点一个青菜，很难出错。饮料嘛当然点酸奶喽，爱喝奶，可以让他浮想联翩哦~~&lt;/p&gt;&lt;p&gt;　　注意四：少说话多微笑&lt;/p&gt;&lt;p&gt;　　言多必失言多必失，一定要记住。哪怕他以后觉得你是个话痨，那是以后的事，第一次你也得给我忍住喽。淑女都是乖乖的坐在那里微笑。如果对方实在太不爱说话，而你又看上他了，就引出几个话题，如果他还是不怎么说话，你就讲个笑话给他，要这样说：“要不，我讲个笑话给你吧，你不许不笑哦。”即使你讲的不好听，他也会觉得你很可爱。&lt;/p&gt;&lt;p&gt;　　注意四：避开敏感话题&lt;/p&gt;&lt;p&gt;　　第一次见面就问人家交过几个女朋友，和前一个女朋友怎么分的手，太可怕了吧，太八婆了吧。记住：你是大家闺秀，那些问题留着以后慢慢知道也不迟。如果反过来他问你，你就说：“呀，你这么问我，我都有点不好意思了，以后慢慢告诉你好吗？”这样，一来你给他一个你想和她继续交往的讯号，二来他会觉得你很害羞，三来他还不会觉得你不实在，因为你没想隐瞒他，只是现在不想说而已。&lt;/p&gt;&lt;p&gt;　　注意五：表面看上去要很坦诚&lt;/p&gt;&lt;p&gt;　　虽然前面的几个小技巧都有点耍小心眼儿的意思，但是归根结底还是要让对方感觉你是很有诚意的，纯朴、老实都是男人认为老婆需要具备的素质，但是要知道老实和机灵并不冲突哦，千万别让人觉得你笨了巴叽的。比如你可以透露给他一些听上去很真诚但又无关痛痒的事情：“我特别爱睡懒觉，我妈妈说以后嫁了人要给老公做早点就不能睡懒觉了，呵呵~~”&lt;/p&gt;&lt;p&gt;　　注意六：时刻注意表情要娇羞&lt;/p&gt;&lt;p&gt;　　虽然现在娶个处女是很难的事，但男人都希望他的老婆没什么感情经历，如果你老盯着他看，他会心里发毛的，你可以在他看你的时候低下头，垂下眼，实在不会，就看看韩剧，里面的女主角个个都能装着呢~&lt;/p&gt;&lt;p&gt;　　注意七：您的手机准备好了吗&lt;/p&gt;&lt;p&gt;　　如果你和他初次见面就没完没了的有电话进来，是很让人烦的。但是如果你把手机改成震动被他发现他会不太舒服，如果你干脆放在书包里又让他觉得你肯定还有垫背的。所以把你的手机转移，大大方方的放在桌面 上，最好和你的好朋友约好，在中途给你发个短信，你也可以大大方方的告诉他是好朋友来的，一个电话没有一个短信没有也不太真实，是吧。&lt;/p&gt;&lt;p&gt;　　注意八：要适度的勾引&lt;/p&gt;&lt;p&gt;　　前面几条都做到了，只能说没有出什么错，但毕竟是要让他喜欢和你在一起啊，所以多少要勾引勾引他，据说，女孩子把手放在嘴边的时候最性感，你自己对着镜子练习一下吧：用白皙水嫩的手拿着饮料杯，喝完了再舔舔嘴唇，迷死他吧，不犯法的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('81', '&lt;p&gt;12星座男能给你什么样的安全感&lt;/p&gt;&lt;p&gt;　　恋爱中的女人，无疑是需要安全感的，而安全感的内容可以是不同的：男友温柔细心，对自己无尽呵护宠爱，让女人有安全感；男友勤勉上进，懂得为未来的美好生活奋斗、规划，让女人有安全感……那么，12星男又会带给恋人怎样的安全感呢？魔法星座即刻来揭晓！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('82', '&lt;p&gt;　　香港七星堂/文&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　眉也是面相学中的一种，也可以看出一个人的运势与否，看一个人能否带来好的运势，眉形也有影响，那么眉形要怎么样才是好的呢？下面来详细解析眉形看福气。&lt;/p&gt;&lt;p&gt;　　1，眉形长度比眼睛长有福气&lt;/p&gt;&lt;p&gt;　　眉毛无论是粗细还是长短，但是一定要顺，要比眼睛长，但是也不能太长，会对个人性格上有很大的反差，要适中，那才比较好，古人云：眉毛长过目为良相，本身也是如此，这是相学中针对眉毛中最基本的准则。除此之外，即使一个人的眉毛比较柔顺，但是也要看眉毛的光泽，也就是色泽，色泽上的深浅也有很大的讲究。&lt;/p&gt;&lt;p&gt;　　2，眉形以整齐为主有福气&lt;/p&gt;&lt;p&gt;　　毛色光润、整齐才是心理平衡、感情与理智并重的好相，眉毛长的人，体内荷尔蒙分泌正常，也代表父母的遗传良好，以前的相学家，还常以眉毛来看一个人兄弟姐妹多少，但是现在看兄弟姐妹是没法看，因为现在计划生育，一般的家庭兄弟姐妹也很少，一个，两个，甚至居多，三个往上几乎都少。&lt;/p&gt;&lt;p&gt;　　3，眉毛柔顺不宜太近有福气&lt;/p&gt;&lt;p&gt;　　眉毛太近的人过于计较，其为人比较自私一些，这种人不但烦恼多愁，性格也患得患失，相当疑神疑鬼，因此好机会都不能把握，尤其在自身的事业上体现最为明显，就算有贵人相助，内心的猜疑，也让自身难以在事业上有很好的发展眉毛如果是柔顺者，即可说明此人一生都顺利没有大起大落，且多半就是不愁烦恼，能够很看的开的人，一般不会纠结于一件事耿耿于怀的人。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('83', '&lt;p&gt;　　科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。猛犸象约在1万年前从地球上灭绝。&lt;/p&gt;&lt;p&gt;　　新浪科技讯 北京时间7月21日消息，随着北极的永久冻土层不断融化，其中储存的远古时期的温室气体被逐渐释放出来，这可能会气候变化进一步加剧。但有一位“英雄”或许能帮助我们阻止这一进程。&lt;/p&gt;&lt;p&gt;　　科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。&lt;/p&gt;&lt;p&gt;　　猛犸象约在1万年前从地球上灭绝。但利用最新的DNA测序和基因编辑技术，我们或许在短短几年之内便能让它们起死回生。&lt;/p&gt;&lt;p&gt;　　据美国《大众杂志》(Popular Science)称，科学家有两种可以使猛犸象复活的方法。&lt;/p&gt;&lt;p&gt;　　一种是利用从远古生物身上收集的材料来克隆猛犸象。自从人们在一头名叫“毛毛”(Buttercup)的猛犸象尸体上找到了残留的组织之后，科学家就一直在尝试这一点。&lt;/p&gt;&lt;p&gt;　　自从人们在西伯利亚发现了一头名叫“毛毛”(Buttercup)的猛犸象尸体后，科学家就一直在尝试复活猛犸象。这头雌性猛犸象是在2013年5月发现的。它身高8英尺(约合2.4米)，死亡时年龄约为50岁，体型和现代大象差不多。&lt;/p&gt;&lt;p&gt;　　这头雌性猛犸象是在2013年5月发现的。它身高8英尺(约合2.4米)，死亡时年龄约为50岁，体型和现代大象差不多。&lt;/p&gt;&lt;p&gt;　　虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&lt;/p&gt;&lt;p&gt;　　另一种复活猛犸象的方法是修改亚洲象的DNA，因为它是猛犸象仍未灭绝的近亲中与之最为相似的一种。&lt;/p&gt;&lt;p&gt;　　这些体型巨大的野兽一度是“猛犸大草原”上的主宰，这一草原生态系统曾占据了整个北半球。它们在草原上起到了至关重要的作用。作为食草生物，它们让树木在平原上无法生长，并在草原各处撒播营养物质。&lt;/p&gt;&lt;p&gt;　　如果猛犸象能够复活，这一生态系统也将得到修复，并阻止北极永久冻土层继续消融。&lt;/p&gt;&lt;p&gt;　　“由于缺乏猛犸象的帮助，冻土层不断上升，导致人类行为引发的气候变化进一步加剧。”该研究项目指出。&lt;/p&gt;&lt;p&gt;　　“如果没有草原将冻原的永久冻土层隔绝开来，永久冻土层就会消融，释放出其中已经储存了数十万年的温室气体。”&lt;/p&gt;&lt;p&gt;　　“全球的永久冻土层一旦消融，引发的后果相当于将全球的森林焚烧了2.5次。”&lt;/p&gt;&lt;p&gt;　　虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&lt;/p&gt;&lt;p&gt;　　该项目指出，将亚洲象“改造”成猛犸象的过程主要分为三步。首先，他们需要让亚洲象具备在低温时提高血氧水平的能力。&lt;/p&gt;&lt;p&gt;　　其次，人们需要增加亚洲象的皮下脂肪，帮助它们度过没有食物的时期，最后还要让它们长出厚厚的皮毛。&lt;/p&gt;&lt;p&gt;　　虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&lt;/p&gt;&lt;p&gt;　　该项目指出，将亚洲象“改造”成猛犸象的过程主要分为三步。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　首先，他们需要让亚洲象具备在低温时提高血氧水平的能力，还要增加亚洲象的皮下脂肪，帮助它们度过没有食物的时期，最后还要让它们长出厚厚的皮毛。&lt;/p&gt;&lt;p&gt;　　接下来，研究人员需要改造它们的成纤维细胞，让它们变成在实验室中“永远不会死亡”的诱导多能干细胞(iPSCs)。这样一来，就不需要培养新的细胞、或从胚胎开始培育了。&lt;/p&gt;&lt;p&gt;　　最后，这些干细胞将被培育成不同的组织，包括红细胞、脂肪和毛发等。他们还将在不同的条件下测试这些红细胞的携氧能力。&lt;/p&gt;&lt;p&gt;　　“我们复活猛犸象的终极目标是创造新的猛犸象，使欧亚大陆和北美的冻原和北部森林重获生机。”该项目指出。&lt;/p&gt;&lt;p&gt;　　“我们的目的并不是精确地复制出已经灭绝的猛犸象，而是努力研究亚洲象需要进行哪些改造、才能像猛犸象那样在冻原的寒冷气候中生存。从培育大象的身体组织，到基因编辑和克隆技术，这些都将是我们在研究之路上取得的里程碑。”(叶子)&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('84', '&lt;p&gt;2014年8月6日，欧空局任务控制中心，罗塞塔项目工作人员在接收到飞船成功入轨信号后兴奋不已&lt;/p&gt;&lt;p&gt;　　新浪科技讯 北京时间7月19日消息，据英国广播公司(BBC)网站报道，两年前的2014年，全世界都被欧洲空间局的一艘小小飞船追逐并登陆一颗彗星的壮举所吸引，那么两年过去，今年9月份，这次探测任务就将接近尾声，我们在这次探测任务期间学习到了什么？&lt;/p&gt;&lt;p&gt;　　星际交会&lt;/p&gt;&lt;p&gt;　　经过10年的太空追逐，2014年11月12日，正在围绕67P彗星运行的欧洲空间局(ESA)“罗塞塔”探测器成功释放一艘小型着陆器“菲莱”(Philae)并成功降落在彗星表面。而现在，罗塞塔项目团队正在规划着更为复杂的举动：他们计划在2016年9月份，控制罗塞塔飞船本身直接撞击彗星。这将是欧洲空间局本次任务期间利用这艘出色的飞船采集彗星数据的最后机会。&lt;/p&gt;&lt;p&gt;　　但尽管罗塞塔任务逐渐临近尾声，本次任务已经让科学家们取得了一系列的新发现，揭示关于太阳系的诸多奥秘并拓展我们对于彗星的认识。&lt;/p&gt;&lt;p&gt;　　但是，罗塞塔飞船并非首个人类针对彗星的探测器。这个头衔属于1978年发射的“国际彗星探测器”(ICE)，它在1985年穿越了21P/Giacobini–Zinner彗星。但所罗塞塔飞船的确是首个围绕彗星运行的人类探测器，以及首个向彗星表明释放着陆器的探测器，菲莱是世界上首个成功降落在彗核表面的探测器。&lt;/p&gt;&lt;p&gt;艺术示意图：着陆在彗星表面的“菲莱”着陆器&lt;/p&gt;&lt;p&gt;　　罗塞塔的发现&lt;/p&gt;&lt;p&gt;　　1) 关于地球起源&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船发现彗星67P没有磁场。借助罗塞塔飞船和菲莱着陆器采集的数据，科学家们将能够排除一部分有关我们地球形成机制的候选理论。欧空局对比了罗塞塔飞船和菲莱着陆器在同一时间利用磁强计采集的磁场测量数据。数据显示67P彗星不存在自身磁场。这一结果不支持一项关于行星形成机制的理论，该理论认为磁场帮助将彗星物质聚集到一起，并最终成为构建原始行星的基本材料。&lt;/p&gt;&lt;p&gt;　　2) 关于生命起源&lt;/p&gt;&lt;p&gt;　　菲莱着陆器发现67P彗星上存在有机物质，其中包括一些此前从未在彗星上被探测到过的有机物成分。这是一项令人兴奋的发现，因为地球上所有生命都是由有机分子构成的，科学家们想要了解地球上最早的有机物质是否有可能是由彗星运送过来的。通过对类似67P这样彗星的研究，科学家们有望进一步加深对这一问题的理解。&lt;/p&gt;&lt;p&gt;　　3) 水的起源&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船发现67P彗星上含有与地球不同的水。67P向外喷射的气体很多都是水汽。但罗塞塔飞船发现，相比地球水体，这些水体中氘的含量更高(氘是氢的同位素，其原子核中多了一个中子)。&lt;/p&gt;&lt;p&gt;　　此前科学家们一直认为彗星有可能是地球上最早水体的来源之一，当彗星撞击地球时就会为地球带来水体。但罗塞塔的发现显然让这个问题变得复杂化了。那么关于地球上水的起源是否还存在着其他的可能性呢？我们显然需要更多的探索。&lt;/p&gt;&lt;p&gt;　　4) 变化中的彗星表面&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船发现67P彗星的地表处于时刻的变化之中。随着67P彗星逐渐接近太阳，罗塞塔团队开始观测到壮观的彗核活动现象。这是科学家们首次有能力近距离实地观察彗星上的水冰是如何变为水汽的。高分辨率图像显示彗星喷射的大量气体和尘埃云团都来自彗星表面巨大的塌陷空洞和悬崖崩塌过程，这也解释了为何彗核表面会如此千疮百孔。&lt;/p&gt;&lt;p&gt;罗塞塔飞船近距离拍摄的彗核表面喷流&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　罗塞塔的谢幕演出&lt;/p&gt;&lt;p&gt;　　在2016年9月份，欧洲空间局计划为已经持续了20年之久的罗塞塔探测任务正式画上一个圆满的句号——他们将控制罗塞塔飞船，命令它直接撞向彗星表面。&lt;/p&gt;&lt;p&gt;　　随着彗星逐渐远离太阳，罗塞塔飞船的太阳能帆板能够接收到的太阳能电力将愈发萎缩，相对应的，飞船的各项功能也将逐渐受到影响。为此，科学家们决定让罗塞塔飞船缓慢下降到67P彗星表面，他们希望这样做将能够采集到分辨率更高的数据和图像——尽管是最后一次。&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船上安装有远比着陆器“菲莱”强大的多的设备仪器。因此随着罗塞塔飞船逐渐下降高度，它搭载的相机和光谱仪将能够接收到最高分辨率的图像和各项其他数据。而关于彗星喷出的气体成分等等，随着距离的下降，其分析精度也将得到提升。&lt;/p&gt;&lt;p&gt;　　由于罗塞塔飞船很有可能将无法在这场命运的撞击之中幸存下来，科学家们决定让飞船一直持续采集数据，直到生命的最后一刻。(晨风)&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');

-- ----------------------------
-- Table structure for ebcms5_content_channel
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_channel`;
CREATE TABLE `ebcms5_content_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'meta标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `extend_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '扩展id',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `tpl_detail` varchar(255) NOT NULL DEFAULT '' COMMENT '内容页模板',
  `eb_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `eb_ext` text COMMENT '扩展信息',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COMMENT='内容栏目表';

-- ----------------------------
-- Records of ebcms5_content_channel
-- ----------------------------
INSERT INTO `ebcms5_content_channel` VALUES ('1', '0', 'news', '新闻', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1473737709', '1468748433', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('2', '0', 'tiyu', '体育', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1473737719', '1468748443', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('4', '0', 'yule', '娱乐', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1473737742', '1468748480', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('7', '1', 'junshi', '军事', '军事哈哈哈哈', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1480595690', '1468748523', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('8', '1', 'shehui', '社会', '', '', '', '0', '', '', '', '', '1468752305', '1468748532', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('9', '1', 'guoji', '国际', '', '', '', '0', '', '', '', '', '1468752309', '1468748540', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('10', '2', 'nba', 'NBA', '', '', '', '0', '', '', '', '', '1468748553', '1468748553', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('11', '2', 'zhongchao', '中超', '', '', '', '0', '', '', '', '{\"text\":\"自定义单行文本\",\"__config__\":{\"text\":\"text\",\"textarea\":\"textarea\",\"file\":\"file\",\"editor\":\"ueditor\",\"__test__\":\"test\"},\"textarea\":\"自定义多行文本\",\"file\":\"自定义文件上传\",\"editor\":\"<p>自定义编辑器。<br\\/><\\/p>\"}', '1468834879', '1468748568', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('12', '2', 'aoyun', '奥运', '奥运', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1468900974', '1468748585', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('16', '4', 'mingxing', '明星', '', '', '', '0', '', '', '', '', '1468748640', '1468748640', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('17', '4', 'dianying', '电影', '', '', '', '0', '', '', '', '', '1468748652', '1468748652', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('18', '0', 'xingzuo', '付费浏览', '', '', '', '1', '', 'detail_money', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1501423100', '1468748664', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('19', '0', 'shouji', '手机', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1502106212', '1468748682', '0', '1');
INSERT INTO `ebcms5_content_channel` VALUES ('20', '0', 'tansuo', '探索', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1502106219', '1468748693', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_content_content
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_content`;
CREATE TABLE `ebcms5_content_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_shorttitle` varchar(255) NOT NULL DEFAULT '' COMMENT '短标题',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'META标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `eb_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT '文件名称',
  `ext` text COMMENT '扩展信息',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `eb_style` varchar(255) NOT NULL DEFAULT '' COMMENT '样式',
  PRIMARY KEY (`id`),
  KEY `list` (`channel_id`,`status`,`id`),
  KEY `list2` (`status`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8 COMMENT='内容基本表';

-- ----------------------------
-- Records of ebcms5_content_content
-- ----------------------------
INSERT INTO `ebcms5_content_content` VALUES ('1', '7', '美国海军作战部长紧急访华谈南海问题 登辽宁舰', '', '', '', '外媒称，美国海军14日宣布，海军作战部长约翰·理查森上将即将访问中国，以探讨南中国海安全事宜。据美国《星条旗报》网站7月14日报道，一份海军新闻稿说，理查森在三天访问期间将参观中国人民解放军海军设施，并与解放军海军司令员吴胜利上将举行会晤。除南中国海议题外，两位上将预计还将探讨其他争议性较小的议题，包括最近举行的“环太平洋”联合军事演习。理查森将于7月17日起访问北京和青岛。这是他首次访华。根据海', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '62', '1479356937', '1468748963', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('2', '19', '土耳其封锁驻土美空军基地 白宫举行紧急会议', '', '', '', '土耳其7月15日晚发生一起未遂军事政变，导致至少161人死亡和1440人受伤。16日，土政府指责流亡美国的土耳其宗教人士费特胡拉·居伦（FethullahGulen）在幕后策划这次政变，使土美关系出现紧张迹象，并封锁了美国在土耳其的空军基地，白宫为此召开紧急会议。据俄罗斯卫星新闻网17日报道，美国驻土耳其领事馆16日说，在发生军人政变后，美国在土耳其南部的因斯里克空军基地被封锁，基地电力供应也被切', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '108', '1479363456', '1468749007', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('3', '7', '中美一旦在南海开战 中国胜算到底有多大？', '', '', '', '最近美帝国主义两艘航母战斗群公然闯入南海，耀武扬威的嘴脸令人发指，再加上南海仲裁对中国非常不利，这两件事牵动了无数中国人的心，一时间中美开战的舆论“甚嚣尘上”。如果因为南海问题真的打起来了，中国的胜算有几何？得出结论之前，先做如下考虑：第一，孰叫胜，孰叫败？现代的战争，军事上的胜败远不是最终的评判标准。最终的评判标准，应该是谁在战争中获取了更多的政治利益和战略利益！第二，战争的形式问题。毫无疑问，', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '68', '1479356928', '1468749054', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('4', '7', '蔡英文不登太平岛 台渔民要自己去宣示“主权”', '', '', '', '针对所谓的南海“仲裁结果”，太平岛被认定为是礁，台湾渔民自组船队预订20日开往太平岛登岛护权。台“海岸巡防署”16日也派出千吨级的巡防救难舰“台东舰”前往太平岛，接替“伟星舰”执行巡弋护渔任务。据台湾《联合报》报道，所谓南海“仲裁结果”引起岛内渔民的强烈反弹。“判决实在太不公平了”东港籍海吉利号渔船船主郑春忠表示，太平岛怎么可能是礁？一出领海就是别人的经济海域，以后怎么去捕鱼，既然台当局力度不够，', 'http://static.ebcms.com/img/ad3.gif', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '480', '1481083891', '1468749074', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('5', '7', '美部署萨德卡住我导弹命门？反送火箭军新目标', '', '', '', '经过多年的讨价还价，美韩还是在7月8日敲定了部署“萨德”（THAAD：末段高空区域防御系统）到韩国的具体地点，当然了目前所有消息都认为这是美国的一次战略上的胜利。尤其是“萨德”本身2000公里探测距离，将会让中国东部的远程弹道导弹都处于美国反导网络侦测范围内，而这一带正好是中国对美洲大陆进行核打击的“东风-31”弹道导弹的发射阵地。这不等于卡主了中国“东风”导弹的命门了吗？实际上并非如此，美国如此', 'http://static.ebcms.com/img/slide2.jpg', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '219', '1481083921', '1468749113', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('6', '7', '战死一个亿，也要保住南海所有岛屿！', '', '', '', '导言：新华社快讯：菲律宾南海仲裁案仲裁庭１２日作出非法无效的所谓最终裁决。对此，中方多次声明，菲律宾共和国阿基诺三世政府单方面提起仲裁违背国际法，仲裁庭没有管辖权，中国不接受，不承认。美国曾经遇到此类所谓的判决，靠的强大的军事机器让胜诉者执行不了，对于中国来说，若菲国不撤诉，就不要指望与中国合作解决经济困境的问题，就象尼加拿瓜一样，没打一仗就象得到岛屿与土地，这个是不可能的，美国就是靠打来解决所有', 'http://static.ebcms.com/img/slide1.jpg', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '289', '1481083906', '1468749135', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('7', '7', '南海仲裁，中国被上了生动的一课', '', '', '', '海牙国际法庭所谓的南海仲裁案终于公布了，结果中国被置于彻底否定和相当不利的地位。这件事当然不能就此了结，相反，这恐怕只是一个开始，不要说接下来会不会有具体执行的，仅就这项裁决本身而言，也注定要成为中国头上的一个“紧箍咒”，被“国际社会”用来时时地敲打中国。预计，在今后与美国进一步“良性互动”，“深化互信，增强合作”的诸般过程中，中国将始终摆脱不了这方面的讹诈，美国将时时、处处、事事借仲裁要挟中国，', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '119', '1479356896', '1468749158', '1', '{\"bold\":\"\"}');
INSERT INTO `ebcms5_content_content` VALUES ('8', '7', '韩国称中国核弹技术还不如印度', '', '', '', '中国已经多年没有进行过核弹核爆试验，那么现在中国核力量到达是个什么水平，就引发了网友的关心和热议。由于中国一直都不愿意公开谈论中国本身装备的核弹数量，威力等等细节，因此外界对此也是有各式各样的猜测。韩国认为评价核弹技术的一个重要指标是核弹小型化技术，在这个方面中国没有优势，还不如印度。只有核弹小型化，才能缩小洲际导弹的尺寸，或者搭载更多的探测设备和燃料。按韩国的数字，美国核弹头仅有110公斤，俄罗', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '122', '1479356893', '1468749206', '1', '#d9534f');
INSERT INTO `ebcms5_content_content` VALUES ('9', '7', '俄罗斯为何拼命想卖给中国战略武器', '', '', '', '最近，俄罗斯媒体一直在吹风，一会要把原来俄罗斯的超级航母技术卖给中国，一会又要卖给中国核潜艇，这和过去毛子卖给中国武器的态度完全不同，俄罗斯媒体为何突然吹这个风呢？在占豪看来，主要应该是基于三方面原因：一、经济压力所迫。由于俄罗斯经济陷入衰退，俄罗斯2016年的军事预算削减了5%，这种压力对俄罗斯来说非常大，那么出售装备给中国就是维系其军工企业运营和升级的关键。然而，现在中国军事实力也上来了，一般', '', '', '', 'feiji', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}},\"xxx1\":\"\"}', '206', '1479990521', '1468749226', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('11', '7', '归国华人诉说真实的印度：我是吐着回来的', '', '', '印度,印度电影,印度神油,印度尼西亚,印度舞蹈,印度性与艺术照片,印度电影大全,印度吧,印度人看中国,印度罕见连体婴降生,印度妓女村', '最近关于印度的话题很火，印度电影大全，今年因为工作关系我在印度呆了半年，所以对印度的情况相对了解一点，又发现国内的很多同志们对印度并不很清楚，印度，所以向大家介绍下我在印度的感受。1、基本建设真的是糟糕透顶。我在印度坐十个小时的火车，沿途就没看到过任何令人赏心悦目的建筑，印度舞蹈，印度性与艺术照片，到处都是一片破败的景象。说他们基本建设落后我们30年绝不为过。而且在十个小时的火车中，我也没有看到任', '', '', '', '', '{\"price\":\"12\",\"param\":{\"__config__\":{\"__test__\":\"test\"}},\"xxx1\":\"\"}', '605', '1480169142', '1468749288', '1', '{\"bold\":\"600\",\"color\":\"#f0ad4e\"}');
INSERT INTO `ebcms5_content_content` VALUES ('12', '8', '商人村官被指身背2亿巨债跑路 事发前仍在防汛', '', '', '', '让拥有一定资产的能人、富人走上村干部岗位，曾被当成发展农村经济的捷径，在江苏乃至全国遍地开花。然而，在“老板村官”为农村面貌带来改变的同时，一些问题也随之暴露。今年5月，南通海门明星村官叶剑生疑因身陷债务纠纷服下化学物品。时隔两个月，常州也发生类似情况，一村支书因身缠巨债与外界失联。现代快报记者历时数日调查，从个案到现象，尝试找出“老板村官”频繁出事的潜在原因。知名社会学专家邱建新在接受现代快报记', '', '', '', '', '', '48', '1479356980', '1468749372', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('13', '8', '仨熊孩子偷葫芦 被抓后称想当葫芦娃有错吗', '', '', '', '正值暑假，安徽阜阳3男孩在家看动画《葫芦娃》，一时兴起想“扮”葫芦娃玩儿。于是他们走到村里一处葫芦地，顺手偷了几个葫芦，“扮起”葫芦娃。民警找来家长，协商赔偿了农民伯伯的损失。男孩不解：“想当葫芦娃有错吗？”@@中警安徽', '', '', '', '', '', '69', '1479356976', '1468749388', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('14', '8', '男子一天遭14000通电话骚扰 被令花300元换清净', '', '', '', '记者左燕燕实习生龚晨霞“遭遇‘呼死你’软件攻击，一分钟5个电话，一小时600个电话，一天14000多个电话，持续一天了，微信转账300元才能停止骚扰”。昨日，网友聂先生发微博称。通讯专家向重案组37号(微信号：zhonganzu37)解释，针对这种情况，可下载一些拦截软件，通过设置拦截无主叫号码电话，便可脱离困扰。警方则建议市民遇到上述情况，可立即报警求助。莫名遭遇一天14000多无主电话骚扰7月', '', '', '', '', '', '73', '1479356972', '1468749414', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('15', '8', '男子疑因未给女友买到电影票跳楼身亡', '', '', '', '网友视频爆料，“广东大沥新都会一男子的女友要换电影票，工作人员不让，男子就跟工作人员吵了起来，随后从6楼跳下”。对此佛山市公安局南海分局称，事发7月14日，地点是南海大沥新都会商场，男子跳楼原因仍在调查。网友：为什么把命看得那么淡[蜡烛]', '', '', '', '', '', '63', '1479356966', '1468749435', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('16', '8', '男子因争执纵火致4死 遇害内地母女来港仅5日', '', '', '', '据香港《文汇报》7月17日报道，香港西区观龙楼昨天（16日）凌晨发生骸人听闻纵火及凶杀案。独居6旬老汉因噪音与一邻居积怨，争执后有人突向对方住所掷燃烧弹纵火，邻居一家三口惨遭灭门，其中持单程证（又称前往港澳通行证，为公安部门发给有条件的申请人赴港澳地区定居的证件--观察者网注）来港团聚仅5日的妻子及年仅3岁半女儿相拥葬身火海，男户主全身着火坠楼死亡，疑凶后折返再纵火自焚同丧黄泉。警方港岛总区重案组', '', '', '', '', '', '74', '1479356963', '1468749458', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('17', '8', '富豪遭12人打死 曾穿7斤重黄金T恤炫富(图)', '', '', '', '据港媒报道，爱金成狂的印度宾布里富豪普盖（DattaPhuge）周四遇袭身亡，12名嫌犯手持镰刀和石头对其痛殴，普盖送医后死亡。警方随后拘捕5名疑犯，其中一人为普盖的侄儿，事件怀疑与金钱纠纷有关。事发于周四晚上，48岁的普盖与22岁儿子获邀出席一个生日派对，当他们开车抵达派对地点后，袭击者把普盖从座驾里拉了出来，有指12名疑犯用镰刀和大石殴打普盖至死。普盖22岁儿子舒布汉驾驶另一辆车子从旁经过，目', '', '', '', '', '', '126', '1479356959', '1468749480', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('18', '8', '男子因琐事将妻子岳母杀害 女儿呼救被关进厨房', '', '', '', '华商报汉中讯（记者周金柱）6月25日晚9时许，南郑县青树镇冉家营村发生惨剧：上门女婿罗某因琐事与妻子发生口角，将妻子和岳母残忍杀害。行凶过程中，女儿一度呼救，却被他关进厨房后继续行凶。7月13日上午，在南郑县青树镇冉家营村杨明志家，9岁的孙女躲在他身后一语不发。杨明志说，当时他正在镇上工地打工，听孙女电话里说“妈妈和奶奶都被爸爸砍倒了”，就赶紧骑摩托车赶回家，发现老伴和女儿躺在院子里，已没有了呼吸', '', '', '', '', '', '136', '1479356955', '1468749557', '1', '#428bca');
INSERT INTO `ebcms5_content_content` VALUES ('19', '8', '男子打飞的向前女友求爱遭拒换对方家锁芯', '', '', '', '重庆商报讯日前，合川区公安局云门派出所接到群众报警，称他家里进去了一名陌生男子，怀疑是小偷。民警迅速赶到现场，发现了擅自闯入的年轻男子倪某。经了解，倪某今年23岁，浙江温州人，与居住在该处的李某曾是男女朋友。后来两人分手，但倪某一直放不下这段感情。为挽回李某，倪某买了一堆礼物，从工作地广东打飞的来到重庆，找到了李某的住处。面对“从天而降”的前男友，李某当场婉拒了，随后便藏身朋友家“玩失踪”。倪某则', '', '', '', '', '', '174', '1479356951', '1468749583', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('20', '8', '小伙拿工资买车票发现12张假钞 疑工厂发放(图)', '', '', '', '据中山电视台《城市零距离》报道，在广东中山古镇打工的汪先生向我们报料，说工厂给他的工资中有假钱，他数了一下，竟然有12张之多！事情还要从7月11日说起，当时汪先生去广州火车站买车票，打算坐火车去浙江找工作。“我是拿两张100元钞票出来，因为它是200元的车票，售票员说这钱是假的，然后叫我换几张。”汪先生于是又从钱包里重新拿了四张百元钞票出来，谁知道还是被告知是假的。汪先生赶紧清点自己的钱，发现类似', '', '', '', '', '', '198', '1479356948', '1468749606', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('21', '9', '外国人问中国为何无颜色革命 中国姑娘回答获赞', '', '', '', '网站截图这个犀利、理直气壮甚至十分粗鲁的问题，来自Quora上一位不知名人士。Quora类似知乎，是美国知名的问答平台。一年多来，超过100名网友给出了答案，美国人、印度人、挪威人以及海外华人……长期受到西方媒体轰炸的他们，却道出了风格各异的精彩见解，一个上海姑娘的短文配图更是获赞两万。7月13日，微博网友@天涯尼丹小发现了这些回答，他感叹这简直是在“用论文方式给题主洗脑”，读书人现在干嘛要造反？', '', '', '', '', '', '64', '1479357022', '1468749638', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('22', '9', '日本前首相鸠山:南海问题应由当事方对话解决', '', '', '', '新华社北京7月16日电日本前首相鸠山由纪夫16日回答新华社记者提问时说，南海问题应该由当事方通过对话与合作解决，不应该从外部施加压力要求中国和菲律宾接受仲裁结果。鸠山说：“南海问题应该由中国与菲律宾来解决，据说新上任的菲律宾总统也想开始与中国对话。我不希望看到，有外部压力利用这个事情一个劲地挑衅对方。”当天，鸠山在北京举行的第五届世界和平论坛上发表了演讲。在谈到菲律宾南海仲裁案临时仲裁庭本月12日', '', '', '', '', '', '90', '1479357019', '1468749657', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('23', '9', '土耳其军方：上百名叛乱分子被杀', '', '', '', '[土军方：上百名叛乱分子被杀]BBC报道，土耳其军方代理参谋长表示，104名叛乱分子被杀。此前报道中提到的在政变中死亡的90人中，包括41名警察、47名平民和两名士兵。目前，军事政变造成的死亡人数已超过190', '', '', '', '', '', '98', '1479357015', '1468749675', '1', '#d9534f');
INSERT INTO `ebcms5_content_content` VALUES ('24', '9', '亚美尼亚首都警察局遭袭击 当局驳斥政变传闻', '', '', '', '#环球快讯#[亚美尼亚首都警方大楼被占领当局驳斥“政变”传闻]据外电报道，亚美尼亚安全部门官员7月17日说，首都埃里温一警察局遭一队与被拘禁反对派领导有关的武装部队袭击，并劫持了多名人质。人质中包括警察局副局长。政府和武装部队的谈判正在进行，不过当局已驳斥了政变传闻。', '', '', '', '', '', '74', '1479357012', '1468749695', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('25', '10', '美媒:10大理由让詹皇无法再夺冠 西部对手太强', '', '', '', '北京时间7月17日，今年NBA总决赛，勒布朗-詹姆斯带领骑士完成了历史性的逆转，并夺得总冠军。在不少人看来，今年31岁的詹姆斯有望夺得更多的总冠军，但是cheatsheet网站却列出了詹姆斯无法再夺冠的十点理由，前提是他一直留在骑士队。10）东部正在变强在过去长达十年的时间里，东部已经成为了詹姆斯的“私人后花园”。他已经赢得了3个NBA总冠军，而且连续6次参加总决赛。但是这种局面可能不会维持太久。', '', '', '', '', '', '96', '1479357042', '1468749727', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('26', '10', '曝绿军已放弃追逐格里芬 他身上藏着2大隐患', '', '', '', '新浪体育讯北京时间7月16日，据《波士顿先驱报》报道，最近，有关凯尔特人仍然希望补强并且可能通过交易得到球星的消息成为一大热门，而跟绿军联系紧密的其中一个巨星，就是快船核心布雷克-格里芬。但最新消息显示，凯尔特人方面对于格里芬并没有太大的兴趣，除了他的合同之外，还有另外一个因素。根据此前的报道，凯尔特人曾经希望通过引入第三方来跟快船进行有关格里芬的交易，而这第三方很有可能会是国王队，他们最近在兜售', '', '', '', '', '', '112', '1479357038', '1468749747', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('27', '10', '莱利:韦德离开让我震惊 他走后我们还没交流过', '', '', '', '新浪体育讯北京时间7月17日，迈阿密热火队总裁帕特-莱利今天召开了一场新闻发布会，并主要谈论了热火在今夏的运作。发布会上，莱利坦言德维恩-韦德离开热火让他“大感震惊”。今年夏天，虽然热火队留住了白边，但是他们没有追到第一目标凯文-杜兰特，而且还流失了队魂韦德。“我们经历了一个艰难的夏天，就是这样。”帕特-莱利告诉在场的记者。“发生在德维恩身上的事情让我大感震惊。”今夏自由球员市场上，韦德与热火的谈', '', '', '', '', '', '158', '1479357035', '1468749765', '1', '#d9534f');
INSERT INTO `ebcms5_content_content` VALUES ('29', '11', '曼萨诺展望上海德比:盼主场拿下对手 先做好自己', '', '', '', '新浪体育讯北京时间7月17日，中超联赛烽火继续，中超第17轮最焦点的赛事无疑是上海申花坐镇主场虹口足球场对阵上海上港的德比大战。今天申花方面放弃了赛前前往虹口足球场适应场地的训练，而是全队在康桥基地完成了德比大战之前的最后一练，今晚7点30分，主帅曼萨诺携阵中大将柏佳骏出席了赛前发布会。针对德比大战的备战情况，申花主帅曼萨诺表示：“周三刚打好足协杯，准备时间不长，但是大家都做好了充分准备对这场比赛', '', '', '', '', '', '68', '1479357064', '1468749815', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('30', '11', '圣杨智不白叫!带伤扑出必进球 这一幕必成经典', '', '', '', '新浪体育讯北京时间7月16日晚19：35，2016年中超联赛第17轮，河北华夏幸福主场迎战北京国安，上半场比赛伤停补时阶段，国安门将杨智带着腰伤扑出了姜宁近在咫尺的头球攻门，再次展现了圣杨智的威风，完成这次扑救后，杨智中场休息时只能在队友的搀扶才能离场，下半场比赛也被侯森换下，希望他的伤势没有大碍。杨智受伤瞬间比赛第31分钟，华夏幸福中路过顶长传，老将杜威前插抢点时与杨智撞在一起，杜威的大腿顶在了', '', '', '', '', '', '84', '1479357060', '1468749865', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('31', '11', '足协公布处罚:申花官员指责裁判被禁3场+罚15000元', '', '', '', '北京时间7月15日，中国足协官网公布处罚决定，上海申花俱乐部官员庞斯因在7月9日与延边富德的比赛中指责裁判员造成不良影响，被禁止进入替补席3场并罚款15000元', '', '', '', '', '', '83', '1479357055', '1468749905', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('32', '12', '女排排名中国被巴西反超至第3', '', '', '', '北京时间7月17日消息，在2016年世界女排大奖赛结束后，国际排联公布了最新一期的世界排名。上期位居次席的中国女排因今年大奖赛仅获第5、被最终夺魁的巴西以2分的微弱优势反超，积278分退至第3。大奖赛卫冕受挫屈居亚军的美国仍以315分高居榜首，280分的巴西升至第2。本期世界排名所统计的比赛包括2016年世界女排大奖赛、2015年世界杯、2014年世界锦标赛和2012年伦敦奥运会，2015年洲际锦', '', '', '', '', '', '75', '1479357084', '1468749931', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('33', '12', '波波维奇帕克造访美国泳军 秒变粉丝合影菲鱼|图', '', '', '', '新浪体育讯随着美国奥运选拔赛告一段落，美国奥运游泳团队也已经集结完毕，正在美国本土进行最后的紧张训练中。美国当地时间昨天，NBA圣安东尼奥马刺队的主教练波波维奇和曾经获得总决赛MVP的法国球星帕克造访美国奥运泳团，给美国泳军打气助威。在里约奥运会前，美国泳军获得奥运资格的选手都将来到奥运备战训练营进行最后的备战。包括菲尔普斯、罗切特、莱德基、富兰克林等诸多名将都在阵中。', '', '', '', '', '', '77', '1479357080', '1468749955', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('34', '12', '里约红灯区变成性交易超市 30分钟交易仅需9英镑', '', '', '', '新浪体育讯北京时间7月15日消息，里约热内卢红灯区的妓女们正在为里约奥运会提供“性服务销售”，原本希望在巴西举办世界杯之后迎来井喷的市场，却在两年后意外遇冷。身处臭名昭著的比拉-米莫萨区的性工作者们表示，原本期待在巴西世界杯后延续热潮的市场却出现了大幅下滑。目前距离奥运会开幕还有不到一个月的时间，性工作者表示她们已经准备好了英文传单邀请运动员光顾里约城旁边的这个红灯区，提供十分便宜的性交易。破旧的', '', '', '', '', '', '91', '1479357077', '1468749974', '1', '#d9534f');
INSERT INTO `ebcms5_content_content` VALUES ('44', '16', '还在各种瘫？鹿晗运动季开启 快来运动吧', '', '', '', '新浪娱乐讯不知不觉，又到星期五了，号称周五播报员的鹿晗[微博]貌似又有大动作？是的，#鹿晗运动季#在今天正式开启啦！7月11日，新浪娱乐就发微博预告，鹿晗小镇再次开启，神秘大礼盒就是#鹿晗运动季#！别再“北京瘫”、“横店瘫”、“葛优瘫”等各种瘫了，快跟着鹿晗一块儿来运动吧~！一言不合就运动？鹿晗早就预告过啦！', '', '', '', '', '', '86', '1479357170', '1468750210', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('45', '16', '喜上加喜！林心如陈妍希领衔“带球”出嫁的10大女星', '', '', '', '据台湾媒体报道，霍建华与林心如14日凌晨相约KTV欢唱，出门时林心如却媒体被拍到“大肚照”，疑似坐实怀孕传闻。两性观念开放的年代，娱乐圈中有很多女星曾“带球”出嫁，下面一床情书便来扒扒奉子成婚喜上加喜的10大女星。', '', '', '', '', '', '99', '1479357166', '1468750232', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('46', '17', '周末看电影丨八部新片上映 高分佳作现身', '', '', '', '本文来自“玩儿电影”公众号（id：wan2movie）进入暑期以后，每周都有不止一部吸引眼球的新片上线抢市场。观众看得热闹，但为了跟上点评/吐槽的节奏，本玩可能会在这个夏天里，在厕所哭晕N次……但，也是没有办法的事，这就是暑期档嘛。《寒战2》《大鱼海棠》等片的热度还没完全过去，本周的新片已经气势汹汹地杀来——文艺佳作、爱情喜剧、动作喜剧、犯罪悬疑、惊悚、动画……乍看之下眼花缭乱，但其实选择起来依然', '', '', '', '', '', '48', '1479357196', '1468750261', '1', '#d9534f');
INSERT INTO `ebcms5_content_content` VALUES ('47', '17', '又要买买买？传万达正洽购派拉蒙49%股权', '', '', '', '据澎湃新闻7月14日报道7月13日，《华尔街日报》援引知情人士称，万达集团正与维亚康姆（Viacom）进行磋商，欲收购对方旗下公司派拉蒙影业（ParamountPictures）49%的股份。但该消息还未得到万达方面的官方确认。但现在，维亚康姆内部分成了两派：目前维亚康姆最大股东、现年92岁的亿万富翁萨默•雷石东（SumnerRedstone）竭力反对该交易的进行；而另一边，包括董事长和首席执行长', '', '', '', '', '', '99', '1479357192', '1468750282', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('48', '17', '许玮甯台北影奖封后 王大陆遗憾错失影帝', '', '', '', '新浪娱乐讯第18届台北电影奖16日晚间在台北举行，许玮甯以《红衣小女孩》、《失控谎言》、短片《世纪末的华丽》夺下影后宝座，也是台北电影奖史上首度以三部作品同时得奖，许玮甯硬咽感谢工作人员与家人，不免被问到是否与旧爱阮经天复合？她表示：“先不回应了，把焦点放在电影上吧。”合作鬼片《红衣小女孩》的黄河也擒下影帝，备受瞩目的任达华、王大陆、宋芸桦等人则与奖项失之交臂。以原住民为主角的《只要我长大》获得百', '', '', '', '', '', '73', '1479357188', '1468750305', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('49', '18', '此文不收费，开放浏览', '', '', '', '朋友圈已经随着网络的普及成为了许多人日常生活中的一个组成部分，产生了任何想法、发生了某件事情第一时间并不是和身边人分享，而是组织一下语言发朋友圈。科技紫微星座网今天就要为大家揭秘，在12星座好友的可见范围内，千万别发这些内容，否则你就等着被屏蔽吧', '', '', '', '', '{\"currency_on\":\"0\",\"price\":\"0\",\"currency\":\"jifen\",\"expire\":\"0\"}', '183', '1501423059', '1468750336', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('50', '19', 'iPhone 7还没发布8的消息就来了：将采用OLED屏幕', '', '', '', '2017年将是苹果iPhone诞生的第十个年头，在这样一个特殊的日子，全新的iPhone8或7s也将以崭新的面貌展现在用户面前，根据内部人士的爆料和分析师的预测，下一代iPhone8无论在材质还是功能上都将有飞跃，其中可以确定的是明年的iPhone将使用OLED屏幕。全球OLED供应商包括LGDisplay、三星、JDI和夏普，无论是谁都想抢得苹果这个超级金主，三星目前垄断全球90%OLED屏幕出', '', '', '', '', '', '115', '1479357233', '1468750363', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('51', '19', '还是大屏更适合亚洲 三星A9 Pro销售区域确定', '', '', '', '5月底我们曾经报道了三星A9Pro在海外开售的消息，不过根据最新消息，三星A9Pro的销售范围将仅限亚洲市场。也就是说三星A9Pro将成为一款名副其实的亚洲特供机。三星A9Pro拥有一块6英寸的大屏幕，或许是考虑到如此大的机身尺寸在某些国家和地区可能不受欢迎，三星A9Pro才选择只限定在亚洲范围开卖。除了6英寸屏幕，三星A9Pro的主要卖点还包括骁龙652处理器、4GBRAM+32GBROM、80', '', '', '', '', '', '87', '1479357229', '1468750387', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('52', '19', '果然涨价了 魅族MX6售价曝光：这价格贵吗？', '', '', '', '魅族已经宣布将在7月19日正式发布新旗舰MX6。此前，魅族联合创始人、总裁白永祥表示，魅族把PRO6的很多工艺带给了MX6，供应链部门也正在努力让MX6成为备货最好的梦想机。此外，白永祥强调，MX6的成本提高了，售价也会提升，但他相信MX6会是两千元价位上设计和工艺最好的产品。如此来说，MX6的售价就不是原来的1799元起了，会是多少呢？今日，有网友曝光了一张魅族内部文件，文件显示，即将发布的MX', '', '', '', '', '', '86', '1479357226', '1468750412', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('53', '19', '三星S7 Edge巴西里约奥运会限量版：五环五色', '', '', '', '巴西里约奥运会开幕在即，作为奥运会的主赞助商之一，三星也顺势推出了一款里约奥运限量版的GalaxyS7Edge。在造型上，这款奥运限量版的S7Edge与普通版基本相同，不过它在设计中大量运用奥运五环的颜色对机身进行点缀。其中，机身左侧的音量键就用上了奥运五环中的绿色。', '', '', '', '', '', '219', '1479357222', '1468750428', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('54', '10', '要赶奥运热：三星Note 7或发布日就开卖', '', '', '', '经过多轮爆料和三星官方的预热，我们对三星Note7的外观、配置和发布日期已经有了基本的了解，变数不会太大。接下来，我们所关心的就是其究竟什么时候开卖了，毕竟咱们买得到才是王道。关于这一点，韩国媒体最新消息称，三星Note7有望在发布当日就开卖，也就是8月2日。回顾上代Note旗舰，三星Note5是在发布后大约一周才实现首发的，Note7今年这上市速度有点惊人了。据了解，2016年里约奥运会将在8月', '', '', '', '', '', '167', '1479357032', '1468750445', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('55', '20', '太阳黑子连续十几天消失 新一轮“冰河期”要来了？', '', '', '', '编者按：太阳黑子是太阳活动水平的标识，但是在2016年6月底，太阳上连续十几天没有黑子，难道很快要进入太阳活动低年？太阳马上要进入休眠状态了？地球要进入新一轮“冰河期”了？“冰河期”真的要来了吗？最近，随着第24活动周太阳活动水平的不断下降，太阳上的黑子真是越来越少了，以前还可以掰着指头数，现在恐怕只能握着拳头数了。甚至在6月下旬开始的十几天里，太阳上便没有了黑子，明亮的太阳上干干净净的。7月5日', '', '', '', '', '', '41', '1479357273', '1468750469', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('56', '20', '研究报告：地球近六成陆地物种多样性遭严重破坏', '', '', '', '资料图：亚马逊雨林被开垦用来种大豆。中新网7月16日电据外媒报道，最新《科学》期刊上的一份研究报告称，地球陆地上58%地区的物种多样性完整指数已低于安全值。该份报告指出，受此冲击最大的是美国、阿根廷、南非与中亚的草原地区，这些地区的动物与植物数量皆因人类活动而减少。报告指出，陆地表面约58%地区的物种“完整性”已经降至安全界限以下；这主要是农业用地、道路与城市发展持续扩充所致。全球大约71%的人口', '', '', '', '', '', '99', '1479357269', '1468750489', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('57', '20', '军舰鸟空中连续飞行两个月不落地：长途跋涉在空气中睡觉', '军舰鸟空中连续飞行两个月不落地', '军舰鸟空中连续飞行两个月不落地', '', '文章来源：蝌蚪五线谱科学家已经发现军舰鸟能长时间的飞行，但是近期的一项研究结果令人有点震惊，研究人员发现军舰鸟的飞行时间可以长达两个月！发表在《科学》杂志上的新研究发现，居住在印度洋和太平洋的大型的军舰鸟，借助上升气流，每隔六分钟挥舞着巨大翅膀，从而飞行几百英里。研究团队在军舰鸟的后颈贴上了极轻的设备。该小型太阳能设备与卫星相连，其功能包括GPS跟踪、心率监视器、加速计和测高计。它们的重量只有10', '', '', '', '', '', '80', '1479357266', '1468750525', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('58', '20', '中国基因编辑研究且快且急，看专家怎么说？', '', '', '', '文章来源：中国科学报微信公众号专家建议尽快完善相关法律规避伦理风险和社会争议从修改植物基因，到改变蝴蝶翅膀的图案，再到修改人类细胞……以CRISPR为代表的基因编辑技术风靡生命科学领域。日前，在香山科学会议第564次学术讨论会上，专家指出，我国基因编辑研究工作正在向源头创新转移，现阶段应大力推动该领域的研究及应用，并及时制定严格有效的监管措施和伦理规范，保证基因编辑下游应用快速健康有序发展。向源头', '', '', '', '', '', '124', '1479357262', '1468750556', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('59', '8', '油价回归“5元时代” 加满一箱油省五块钱', '', '', '油价下调,油价下调时间,今日油价下调,中国油价下调,油价下调最新消息,油价下调整最新消息,油价下调再爽约,油价下调图片,油价下调原因,国内油价下调,最新国内油价下调', '央视财经讯我国年内第14次成品油零售价调价窗口期，于7月21日24时开启。经过前两次搁浅后,国家发改委宣布，本次成品油价格迎来年内第二次下调！汽、柴油每吨分别下调155元和150元；全国平均来看折合90号汽油每升下调0.1元，0号柴油每升下调0.13元，油价下调原因，中国油价下调，今日油价下调，92号汽油均每升下调0.11元。按一般家用汽车油箱50L的容量估测,加满一箱汽油将节省约5元。此次成品油', '', '', '', 'heheyoujia', '', '291', '1479991157', '1469092861', '1', '{\"color\":\"#d9534f\",\"bold\":\"600\"}');
INSERT INTO `ebcms5_content_content` VALUES ('60', '9', '菲总统称将恢复与华对话 因中国有钱而美国没钱', '', '', '', '【环球网报道记者余鹏飞】菲律宾总统杜特尔特日前暗示了他愿意按照前总统菲德尔·拉莫斯的建议，搁置南海仲裁案的“裁决”，恢复与中国的双边对话。杜特尔特就此解释称，“中国有钱，美国是没有钱的”。据《菲律宾商报》7月24日报道，菲律宾总统杜特尔特22日发表演讲称，菲德尔·拉莫斯向其建议在与中国对话时，搁置南海仲裁案的“裁决”是没有问题的。与中国的经济合作可帮助菲律宾的南部群岛致富。不过，菲律宾最高法院高级', '', '', '', '', '', '84', '1479357008', '1469348616', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('61', '10', '阿杜:没人当面喷我加盟勇士 都是键盘侠在作祟', '', '', '', '北京时间7月24日，据雅虎体育报道，凯文-杜兰特今夏加盟勇士队的决定引起了很大的争议，但是据阿杜本人表示，从那之后，从来没有人当面抨击过他的这个决定。自从杜兰特在7月4日宣布加盟勇士队之后，外界的反应非常激烈，雷霆队球迷开始烧杜兰特的球衣；查尔斯-巴克利对他的决定表示失望，并称杜兰特这是“想骗一个总冠军”；甚至连他的两位昔日队友坎特和亚当斯都在推特上唱双簧并讽刺杜兰特背叛球队。虽然杜兰特已经听到了', '', '', '', '', '', '266', '1479357028', '1469348661', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('62', '11', '佩莱:申花是很强大的对手 祝福登巴巴早日康复', '', '', '', '佩莱出席战申花赛前发布会齐鲁网济南7月23日讯（记者李淼实习记者薛睿）中超联赛第19轮山东鲁能主场迎战上海申花，鲁能主帅马加特出席了赛前发布会，主帅马加特表示申花是一支强大的队伍，明天不会期待很多进球。马加特：申花是强大的对手明天不会期待很多进球发布会上，鲁能主帅马加特表示申花是一个强大的对手，“在几周前足协杯的比赛中对阵上海申花使我们积攒了经验，我认为那是一场不错的比赛。申花向我们展示出他是一支', '', '', '', '', '', '80', '1479357051', '1469348698', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('63', '11', '李源一世界波斩中超首球 回泰达想这刻他等太久', '', '', '', '李源一进球后被队友包围庆祝新浪体育讯2016赛季中超联赛第19轮，天津泰达客场1-3负于杭州绿城。虽然输掉了比赛，但天津泰达本场比赛也有收获。前国奥主力中场李源一本场比赛奉献一脚世界波，一度为天津泰达扳平比分，在重返天津泰达后踢得第一场中超比赛中就收获了中超首球。李源一本场比赛25分钟的出场时间虽然不多，但已经超过了他在广州恒大半个赛季的中超出场时间，攻防两端都很积极，表现让人眼前一亮。', '', '', '', '', '', '109', '1479357048', '1469352465', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('64', '12', '重磅！曝俄罗斯或全员无缘里约奥运 一共387人', '', '', '', '俄罗斯田径之前被判定不能参加里约奥运会，而现在又传来更惊人的消息，据英国媒体《每日邮报》报道，国际奥林匹克委员会准备对整个俄罗斯代表团实行禁赛，代表团387名运动员将无法出战里约奥运会。《每日邮报》周日版了解到，整个俄罗斯奥运代表团都无法参加下个月的里约奥运会，根据他们的消息源，国际奥委会将用最强硬的方式处罚这387名俄罗斯代表团运动员。之前，受到处罚的只是俄罗斯田径代表团，但《每日邮报》表示，今', '', '', '', '', '', '74', '1479357073', '1469352503', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('65', '12', '举重队里约最低目标六金 8届奥运29金堪称王牌军', '', '', '', '陆浩杰和陆永（右）中新社北京7月23日电（记者张素）力拔山兮，壮士出征，中国举重队23日晚从北京兵发里约。这支最“给力”的队伍说：这次要全面超越上届奥运会。自1984年洛杉矶奥运会至今，中国举重队共获29枚金牌，与中国体操队并列“金牌榜”第二。近4届奥运会，除了2008年北京奥运会时豪夺8金，他们在悉尼、雅典、伦敦三次境外参赛所获金牌数均为5枚。这一次，中国举重队派出10名大力士出战10个级别，明', '', '', '', '', '', '78', '1479357070', '1469352532', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('73', '16', '陈晓陈妍希办婚礼 盘点明星的天价婚礼', '', '', '', '小龙女与杨过终于结婚了，这个无论是在小说还是影视作品中均为出现的场景，今天(7月19日)将在现实中出现！7月19日，“过儿”陈晓和“小龙女”陈妍希将在北京的雁西湖举办婚礼！陈晓陈妍希婚礼内场布置', '', '', '', '', '', '92', '1479357161', '1469353010', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('74', '16', '34D陈乔恩大方传授丰胸秘诀：吃鸡睾丸', '', '', '', '陈乔恩以前一段说自己爱吃睾丸，尤其是鸡睾丸的视频被网友扒了出来，引起热议。对此陈乔恩透露自己的丰胸秘诀是吃鸡睾丸。陈乔恩', '', '', '', '', '', '98', '1479357158', '1469353063', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('75', '16', '34D港星写真内地老板买3000本 拒50万饭局', '', '', '', '今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。透露获内地老板朋友扫写真，预计中港合共售出近3000本。24岁何洛沂穿低胸装展露事业线新浪娱乐讯北京时间7月24日消息，据香港媒体报导，今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。昨天（7月23日）她凑热闹入书展宣传，以低胸上衣配短裤，露事业线加长腿赠兴。她透露获内地老板朋友扫写真，预计中港合共售出近3000本。拒50', '', '', '', '', '', '184', '1479357154', '1469353113', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('76', '17', '成龙：为影迷坚持拍戏 签约吴亦凡有计划', '', '', '', '新浪娱乐讯在承诺不再拍“大型动作片”四年后，62岁的成龙[微博]在这个夏天又出山了。虽没亲自担任导演，但《绝地逃亡》那笑料和动作齐飞的熟悉配方、那中外混血的熟悉味道，早已将他出卖。这次他多了约翰尼·诺克斯维尔这个在片中成事不足败事有余的老外拍档，多了范冰冰[微博]的倾情助阵，也多了些力不从心的自知。但大哥依然是那个爱玩命、爱“教年轻人”、爱感叹苦日子里出光辉的大哥。年过六旬的成龙为何坚持扮演动作英', '', '', '', '', '', '69', '1479357184', '1469353294', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('77', '17', '周末看电影丨中日印美四国影片上阵混战', '', '', '', '不知不觉7月已到月尾，大雨也从南方下到了北方，可就算大雨让整座城市倾倒，影院也会为你上新片……但也有觉得暑期档太挤，移到中秋档的《大话西游3》，还有作别七夕档进军贺岁档的《三少爷的剑》。就让小玩向这两部改档的电影挥挥手，然后再激动的和你们讲讲这周的新片情况。相较于前几周的清一色的国产片，这周影院里多了日本、印度和美国的片子，票房厮杀战就更厉害了，大家的选择空间也更多了一些。新片一共有十部，但并不是', '', '', '', '', '', '81', '1479357180', '1469353327', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('78', '17', '不满宣传？杨子姗:和预想不同 常被问档期', '', '', '', '杨子姗新浪娱乐讯面前的杨子姗[微博]一身黑色紧身小西装，长衣长裤，利落爽快，与《天亮之前》中那个“风尘女子”的人设相去甚远。这是生活中的杨子姗喜欢的穿衣风格，中性，再加那么一点酷，至于风情，她更多地留给了故事中的角色。《天亮之前》是杨子姗与老公吴中天自公布婚讯以来的首度合作。此前，二人异地恋终成正果的爱情故事已遍传网络，声情并“貌”地甜倒了一片单身狗。不过当这对颜值演艺俱登对的小情侣调整身份变成了', '', '', '', '', '', '129', '1479357177', '1469353356', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('79', '18', '此文收费1积分，购买一次永久有效', '', '', '', '7月22日太阳进入狮子座的影响7月22日：太阳进入狮子座（查看你的本命盘&gt;&gt;）太阳这颗星体是狮子座的守护星座，象征着绝对的权力与光芒，富有活力与表现力，并且在执行力度上非常强劲，当这颗星体再次进入入庙位置的狮子座，对大众而言，经历过六月的沉淀与休憩，意味着下半年的真正开始与再次出发。之前讲述过上半年对这一整年而言都是一种磨砺，而真正的重头戏则在下半年太阳进入狮子座之后，届时不论是对社会', '', '', '', '', '{\"currency_on\":\"1\",\"price\":\"1\",\"currency\":\"jifen\",\"expire\":\"0\"}', '261', '1501423081', '1469353392', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('80', '18', '此文收费1余额，1小时候需要重新支付', '', '', '', '如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦~8心动绝招让男人拜倒裙下在崇尚自由恋爱的时代，大多数人不到万不得已都不会走上相亲这条老路，然而不得不承认的是，相亲确实是解决剩女问题最有效的方法之一。如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦！注意一：首次见面一定要让他选地方作为女人，有太多的主意', '', '', '', '', '{\"currency_on\":\"1\",\"price\":\"1\",\"currency\":\"yuan\",\"expire\":\"3600\"}', '184', '1501423029', '1469353424', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('81', '18', '此文收费1金币，1分钟后需要重新支付', '', '', '', '12星座男能给你什么样的安全感恋爱中的女人，无疑是需要安全感的，而安全感的内容可以是不同的：男友温柔细心，对自己无尽呵护宠爱，让女人有安全感；男友勤勉上进，懂得为未来的美好生活奋斗、规划，让女人有安全感……那么，12星男又会带给恋人怎样的安全感呢？魔法星座即刻来揭晓！', '', '', '', '', '{\"currency_on\":\"1\",\"price\":\"1\",\"currency\":\"jinbi\",\"expire\":\"60\"}', '251', '1501423002', '1469353450', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('82', '18', '此文收费1积分，一分钟后需要重新支付', '', '', '', '香港七星堂/文眉也是面相学中的一种，也可以看出一个人的运势与否，看一个人能否带来好的运势，眉形也有影响，那么眉形要怎么样才是好的呢？下面来详细解析眉形看福气。1，眉形长度比眼睛长有福气眉毛无论是粗细还是长短，但是一定要顺，要比眼睛长，但是也不能太长，会对个人性格上有很大的反差，要适中，那才比较好，古人云：眉毛长过目为良相，本身也是如此，这是相学中针对眉毛中最基本的准则。除此之外，即使一个人的眉毛比', '', '', '', '', '{\"currency_on\":\"1\",\"price\":\"1\",\"currency\":\"jifen\",\"expire\":\"60\"}', '771', '1501422976', '1469353477', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('83', '20', '科学家计划“复活”猛犸象：减慢温室效应', '', '', '', '科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。猛犸象约在1万年前从地球上灭绝。新浪科技讯北京时间7月21日消息，随着北极的永久冻土层不断融化，其中储存的远古时期的温室气体被逐渐释放出来，这可能会气候变化进一步加剧。但有一位“英雄”或许能帮助我们阻止这一进程。科学家表示，如果能将猛犸象复活、重新引入生态系统之中，', '', '', '', '', '', '94', '1479357258', '1469353566', '1', '');
INSERT INTO `ebcms5_content_content` VALUES ('84', '20', '罗塞塔计划9月直接撞击彗星：登陆彗星让我们学到了什么？', '', '', '', '2014年8月6日，欧空局任务控制中心，罗塞塔项目工作人员在接收到飞船成功入轨信号后兴奋不已新浪科技讯北京时间7月19日消息，据英国广播公司(BBC)网站报道，两年前的2014年，全世界都被欧洲空间局的一艘小小飞船追逐并登陆一颗彗星的壮举所吸引，那么两年过去，今年9月份，这次探测任务就将接近尾声，我们在这次探测任务期间学习到了什么？星际交会经过10年的太空追逐，2014年11月12日，正在围绕67', '', '', '', '', '', '181', '1479357255', '1469353600', '1', '');

-- ----------------------------
-- Table structure for ebcms5_content_tag
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_tag`;
CREATE TABLE `ebcms5_content_tag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `tag` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  `recommend` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `eb_style` varchar(255) NOT NULL DEFAULT '' COMMENT '样式',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8 COMMENT='内容标签表';

-- ----------------------------
-- Records of ebcms5_content_tag
-- ----------------------------
INSERT INTO `ebcms5_content_tag` VALUES ('1', '村官', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('2', '基因工程', '1', '1', '{\"color\":\"#d9534f\",\"bold\":\"600\"}');
INSERT INTO `ebcms5_content_tag` VALUES ('3', '生命科学', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('4', '武器', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('6', '环境保护', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('7', '宇宙科学', '1', '1', '');
INSERT INTO `ebcms5_content_tag` VALUES ('9', '魅族', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('10', 'iphone8', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('11', 'iphone7', '2', '1', '{\"color\":\"#d9534f\",\"bold\":\"900\"}');
INSERT INTO `ebcms5_content_tag` VALUES ('12', '星座', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('13', '王大陆', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('14', '许玮甯', '2', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('15', '万达', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('18', '王思聪', '1', '1', '');
INSERT INTO `ebcms5_content_tag` VALUES ('19', '寒战2', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('20', '大鱼海棠', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('21', '林心如', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('22', '陈妍希', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('23', '鹿晗', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('24', '黑色金属', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('25', 'GDP', '1', '1', '');
INSERT INTO `ebcms5_content_tag` VALUES ('26', '有色金属', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('27', '橡胶', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('28', '土耳其', '6', '1', '{\"color\":\"#d9534f\",\"bold\":\"600\"}');
INSERT INTO `ebcms5_content_tag` VALUES ('29', '私募', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('30', '证券', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('31', '期货', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('32', '王海雄', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('33', '百毅资本', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('34', '曹剑飞', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('35', '股权激励', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('36', '券商', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('37', 'A股', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('38', '红灯区', '1', '1', '#d9534f');
INSERT INTO `ebcms5_content_tag` VALUES ('39', '性', '1', '1', '#d9534f');
INSERT INTO `ebcms5_content_tag` VALUES ('40', '里约', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('41', '波波维奇帕克', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('42', '菲鱼', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('43', '女排', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('44', '上海申花', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('45', '圣杨智', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('46', '曼萨诺', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('47', '中超联赛', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('48', '韦德', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('49', '马刺', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('50', '利拉德', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('51', '莱利', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('52', '绿军', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('53', '格里芬', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('54', '詹皇', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('55', '亚美尼亚', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('56', '鸠山', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('58', '海外华人', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('59', '华侨', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('60', '假钞', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('61', '假币', '1', '1', '');
INSERT INTO `ebcms5_content_tag` VALUES ('62', '秀恩爱', '2', '0', '#d9534f');
INSERT INTO `ebcms5_content_tag` VALUES ('63', '飞的', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('64', '家庭暴力', '2', '0', '{\"color\":\"\"}');
INSERT INTO `ebcms5_content_tag` VALUES ('65', '家庭犯罪', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('66', '富豪', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('67', '炫富', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('68', '骚扰电话', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('69', '电话诈骗', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('70', '动画片', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('71', '教育', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('72', '贪污', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('73', '印度', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('74', '南海', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('75', '菲律宾', '1', '0', '#d9534f');
INSERT INTO `ebcms5_content_tag` VALUES ('76', '俄罗斯', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('77', '韩国', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('78', '核技术', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('79', '萨德', '1', '0', '{\"color\":\"\"}');
INSERT INTO `ebcms5_content_tag` VALUES ('80', '太平岛', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('81', '测试', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('82', '123', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('83', '罗塞塔', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('84', '彗星', '1', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('85', '南海问题', '4', '0', '{\"bold\":\"600\",\"color\":\"#428bca\"}');
INSERT INTO `ebcms5_content_tag` VALUES ('88', ' 派拉蒙', '1', '0', '{\"color\":\"#d9534f\"}');
INSERT INTO `ebcms5_content_tag` VALUES ('89', '印度电影', '1', '0', '');

-- ----------------------------
-- Table structure for ebcms5_content_tags
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_tags`;
CREATE TABLE `ebcms5_content_tags` (
  `c_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '标签ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容标签关联表';

-- ----------------------------
-- Records of ebcms5_content_tags
-- ----------------------------
INSERT INTO `ebcms5_content_tags` VALUES ('12', '72');
INSERT INTO `ebcms5_content_tags` VALUES ('58', '3');
INSERT INTO `ebcms5_content_tags` VALUES ('58', '2');
INSERT INTO `ebcms5_content_tags` VALUES ('57', '4');
INSERT INTO `ebcms5_content_tags` VALUES ('56', '6');
INSERT INTO `ebcms5_content_tags` VALUES ('50', '11');
INSERT INTO `ebcms5_content_tags` VALUES ('55', '7');
INSERT INTO `ebcms5_content_tags` VALUES ('2', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('23', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('52', '9');
INSERT INTO `ebcms5_content_tags` VALUES ('56', '11');
INSERT INTO `ebcms5_content_tags` VALUES ('50', '10');
INSERT INTO `ebcms5_content_tags` VALUES ('48', '13');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '14');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '15');
INSERT INTO `ebcms5_content_tags` VALUES ('48', '14');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '88');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '18');
INSERT INTO `ebcms5_content_tags` VALUES ('46', '19');
INSERT INTO `ebcms5_content_tags` VALUES ('46', '20');
INSERT INTO `ebcms5_content_tags` VALUES ('45', '22');
INSERT INTO `ebcms5_content_tags` VALUES ('45', '21');
INSERT INTO `ebcms5_content_tags` VALUES ('44', '23');
INSERT INTO `ebcms5_content_tags` VALUES ('51', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('34', '39');
INSERT INTO `ebcms5_content_tags` VALUES ('34', '38');
INSERT INTO `ebcms5_content_tags` VALUES ('34', '40');
INSERT INTO `ebcms5_content_tags` VALUES ('33', '41');
INSERT INTO `ebcms5_content_tags` VALUES ('33', '42');
INSERT INTO `ebcms5_content_tags` VALUES ('32', '43');
INSERT INTO `ebcms5_content_tags` VALUES ('31', '44');
INSERT INTO `ebcms5_content_tags` VALUES ('30', '45');
INSERT INTO `ebcms5_content_tags` VALUES ('29', '47');
INSERT INTO `ebcms5_content_tags` VALUES ('29', '46');
INSERT INTO `ebcms5_content_tags` VALUES ('27', '48');
INSERT INTO `ebcms5_content_tags` VALUES ('27', '51');
INSERT INTO `ebcms5_content_tags` VALUES ('26', '52');
INSERT INTO `ebcms5_content_tags` VALUES ('26', '53');
INSERT INTO `ebcms5_content_tags` VALUES ('25', '54');
INSERT INTO `ebcms5_content_tags` VALUES ('24', '55');
INSERT INTO `ebcms5_content_tags` VALUES ('53', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('1', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('22', '56');
INSERT INTO `ebcms5_content_tags` VALUES ('21', '59');
INSERT INTO `ebcms5_content_tags` VALUES ('21', '58');
INSERT INTO `ebcms5_content_tags` VALUES ('20', '61');
INSERT INTO `ebcms5_content_tags` VALUES ('20', '60');
INSERT INTO `ebcms5_content_tags` VALUES ('19', '63');
INSERT INTO `ebcms5_content_tags` VALUES ('19', '62');
INSERT INTO `ebcms5_content_tags` VALUES ('18', '65');
INSERT INTO `ebcms5_content_tags` VALUES ('18', '64');
INSERT INTO `ebcms5_content_tags` VALUES ('17', '66');
INSERT INTO `ebcms5_content_tags` VALUES ('17', '67');
INSERT INTO `ebcms5_content_tags` VALUES ('16', '64');
INSERT INTO `ebcms5_content_tags` VALUES ('15', '62');
INSERT INTO `ebcms5_content_tags` VALUES ('14', '68');
INSERT INTO `ebcms5_content_tags` VALUES ('14', '69');
INSERT INTO `ebcms5_content_tags` VALUES ('13', '70');
INSERT INTO `ebcms5_content_tags` VALUES ('13', '71');
INSERT INTO `ebcms5_content_tags` VALUES ('12', '1');
INSERT INTO `ebcms5_content_tags` VALUES ('11', '89');
INSERT INTO `ebcms5_content_tags` VALUES ('9', '76');
INSERT INTO `ebcms5_content_tags` VALUES ('8', '78');
INSERT INTO `ebcms5_content_tags` VALUES ('8', '77');
INSERT INTO `ebcms5_content_tags` VALUES ('3', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('5', '79');
INSERT INTO `ebcms5_content_tags` VALUES ('4', '80');
INSERT INTO `ebcms5_content_tags` VALUES ('6', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('54', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('22', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('11', '73');
INSERT INTO `ebcms5_content_tags` VALUES ('84', '83');
INSERT INTO `ebcms5_content_tags` VALUES ('84', '84');
INSERT INTO `ebcms5_content_tags` VALUES ('49', '12');

-- ----------------------------
-- Table structure for ebcms5_extend
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extend`;
CREATE TABLE `ebcms5_extend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `app` varchar(255) DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='扩展表';

-- ----------------------------
-- Records of ebcms5_extend
-- ----------------------------
INSERT INTO `ebcms5_extend` VALUES ('1', '内容模块', '收费模型', '', '1', '1', 'content');

-- ----------------------------
-- Table structure for ebcms5_extendfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extendfield`;
CREATE TABLE `ebcms5_extendfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `value` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='扩展字段表';

-- ----------------------------
-- Records of ebcms5_extendfield
-- ----------------------------
INSERT INTO `ebcms5_extendfield` VALUES ('1', '1', '收费设置', '收费币种', 'currency', 'jifen', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.currency\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '', '1', '1');
INSERT INTO `ebcms5_extendfield` VALUES ('2', '1', '收费设置', '收费额', 'price', '0', 'form_numberbox', '{\"disabled\":\"0\",\"readonly\":\"0\",\"max\":\"\",\"min\":\"\",\"prompt\":\"\"}', '', '2', '1');
INSERT INTO `ebcms5_extendfield` VALUES ('3', '1', '收费设置', '是否需要收费', 'currency_on', '0', 'form_bool', '{\"disabled\":\"0\",\"readonly\":\"0\"}', '', '3', '1');
INSERT INTO `ebcms5_extendfield` VALUES ('4', '1', '收费设置', '有效期', 'expire', '0', 'form_select', '{\"values\":\"\\u4e0d\\u9650\\u671f|0\\r\\n1\\u5206\\u949f|60\\r\\n1\\u5c0f\\u65f6|3600\\r\\n1\\u5929|86400\",\"editable\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\"}', '超过该时间需要重新支付', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_form
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_form`;
CREATE TABLE `ebcms5_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `html` text COMMENT '模板',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3218 DEFAULT CHARSET=utf8 COMMENT='表单表';

-- ----------------------------
-- Records of ebcms5_form
-- ----------------------------
INSERT INTO `ebcms5_form` VALUES ('1', '表单配置', '单行文本', 'form_textbox', '', '100', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2', '表单配置', '布尔选项', 'form_bool', '', '56', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('3', '表单配置', '隐藏域', 'form_hidden', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('4', '表单配置', '百度编辑器', 'form_ueditor', '', '86', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('5', '表单配置', '数字框', 'form_numberbox', '', '91', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('6', '表单配置', '上传', 'form_upload', '', '69', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('9', '表单配置', '多文件上传', 'form_uploads', '', '62', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('13', '表单配置', '数据库', 'form_database', '', '45', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('14', '表单配置', '多行文本', 'form_multitextbox', '', '97', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('18', '账户管理', '添加角色', 'ebcms_group_add', '', '66', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('19', '账户管理', '修改角色', 'ebcms_group_edit', '', '56', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('20', '账户管理', '添加账户', 'ebcms_manager_add', '', '136', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('21', '账户管理', '编辑账户', 'ebcms_manager_edit', '', '75', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('22', '扩展管理', '添加扩展', 'ebcms_extend_add', '', '141', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('23', '扩展管理', '修改扩展', 'ebcms_extend_edit', '', '71', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('24', '扩展管理', '添加字段', 'ebcms_extendfield_add', '', '60', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('25', '扩展管理', '修改字段', 'ebcms_extendfield_edit', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('26', '表单配置', '单选', 'form_radio', '', '72', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('27', '表单配置', '复选', 'form_checkbox', '', '71', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('32', '基本表单', '修改自己密码', 'ebcms_index_password', '', '90', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('33', '表单配置', '下拉选项', 'form_select', '', '44', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('411', '导航管理', '添加导航', 'ebcms_nav_add', '', '160', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('412', '导航管理', '编辑导航', 'ebcms_nav_edit', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('1444', '基本表单', '发送邮件', 'ebcms_index_email', '', '110', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('1497', '表单配置', '自定义', 'form_custom', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2542', '账户管理', '分配权限', 'ebcms_group_rule', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2543', '账户管理', '菜单权限', 'ebcms_group_menu', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2544', '账户管理', '重置密码', 'ebcms_manager_password', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2545', '账户管理', '分配角色', 'ebcms_manager_group', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2546', '基本表单', '应用卸载', 'ebcms_app_uninstall', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('3173', '内容管理', '添加分类', 'content_admin.channel_add', '', '350', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3174', '内容管理', '添加内容', 'content_admin.content_add', '', '39', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3175', '内容管理', '标签合并', 'content_admin.tag_merge', '', '17', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3176', '内容管理', '合并', 'content_admin.channel_merge', '', '48', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3177', '内容管理', '修改标签', 'content_admin.tag_edit', '', '18', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3178', '内容管理', '修改分类', 'content_admin.channel_edit', '', '49', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3179', '内容管理', '内容批量移动', 'content_admin.content_move', '', '37', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3180', '内容管理', '修改内容', 'content_admin.content_edit', '', '38', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3181', '模板助手', '添加', 'mbzs_mbzs_add', '', '300', '', 'mbzs');
INSERT INTO `ebcms5_form` VALUES ('3182', '模板助手', '编辑', 'mbzs_mbzs_edit', '', '3', '', 'mbzs');
INSERT INTO `ebcms5_form` VALUES ('3183', '友情链接', '添加', 'link_admin.link_add', '', '220', null, 'link');
INSERT INTO `ebcms5_form` VALUES ('3184', '友情链接', '编辑', 'link_admin.link_edit', '', '0', null, 'link');
INSERT INTO `ebcms5_form` VALUES ('3199', '简易论坛', '添加板块', 'forum_admin.forum_add', '', '300', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3200', '简易论坛', '移动帖子', 'forum_admin.thread_move', '', '0', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3201', '简易论坛', '添加版主', 'forum_admin.forum_add_moderator', '', '5', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3202', '简易论坛', '编辑板块', 'forum_admin.forum_edit', '', '9', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3203', '简易论坛', '编辑版主', 'forum_admin.forum_edit_moderator', '', '4', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3204', '简易论坛', '权限设置', 'forum_admin.forum_auth', '', '6', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3205', '简易论坛', '编辑帖子', 'forum_admin.thread_edit', '', '8', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3206', '简易论坛', '编辑跟帖', 'forum_admin.rethread_edit', '', '7', null, 'forum');
INSERT INTO `ebcms5_form` VALUES ('3207', '简易论坛', '合并板块', 'forum_admin.forum_merge', '', '8', '', 'forum');
INSERT INTO `ebcms5_form` VALUES ('3213', '用户管理', '发消息', 'user_admin.user_msg', '', '0', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3214', '用户管理', '添加用户', 'user_admin.user_add', '', '170', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3215', '用户管理', '编辑用户', 'user_admin.user_edit', '', '0', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3216', '用户管理', '财务变更', 'user_admin.user_currency', '', '0', '', 'user');
INSERT INTO `ebcms5_form` VALUES ('3217', '用户管理', '编辑评论', 'user_admin.comment_edit', '', '0', '', 'user');

-- ----------------------------
-- Table structure for ebcms5_formfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_formfield`;
CREATE TABLE `ebcms5_formfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `subtable` varchar(250) NOT NULL DEFAULT '' COMMENT '副表',
  `extfield` varchar(250) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `defaultvaluetype` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '取值类型',
  `defaultvalue` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22602 DEFAULT CHARSET=utf8 COMMENT='表单字段表';

-- ----------------------------
-- Records of ebcms5_formfield
-- ----------------------------
INSERT INTO `ebcms5_formfield` VALUES ('2', '1', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('3', '1', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '38');
INSERT INTO `ebcms5_formfield` VALUES ('7', '1', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('8', '1', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('9', '2', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('10', '2', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('11', '2', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('12', '3', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('13', '4', '基本配置', '高度', 'initialframeheight', '', 'config', '3', 'initialframeheight', 'form_numberbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('14', '4', '基本配置', '自动高度', 'autoheightenabled', '', 'config', '3', 'autoheightenabled', 'form_bool', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('15', '4', '基本配置', '最大字符数', 'maximumwords', '', 'config', '3', 'maximumwords', 'form_numberbox', '{\"required\":\"0\",\"editable\":\"1\",\"readonly\":\"0\",\"max\":\"\",\"min\":\"\",\"prompt\":\"\",\"disabled\":\"0\",\"width\":\"\",\"prefix\":\"\",\"suffix\":\"\",\"groupseparator\":\"\",\"decimalseparator\":\"\",\"precision\":\"\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('16', '4', '基本配置', '开启字数统计', 'wordcount', '', 'config', '3', 'wordcount', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('17', '4', '基本配置', '显示元素路径', 'elementpathenabled', '', 'config', '3', 'elementpathenabled', 'form_bool', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('18', '4', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('20', '5', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('21', '5', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '38');
INSERT INTO `ebcms5_formfield` VALUES ('22', '5', '基本配置', '最大值', 'max', '', 'config', '3', 'max', 'form_numberbox', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('23', '5', '基本配置', '最小值', 'min', '', 'config', '3', 'min', 'form_numberbox', 'null', '', '25');
INSERT INTO `ebcms5_formfield` VALUES ('24', '5', '基本配置', '提示信息', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '15');
INSERT INTO `ebcms5_formfield` VALUES ('25', '5', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('29', '6', '基本配置', '允许的类型', 'extensions', '', 'config', '3', 'extensions', 'form_textbox', 'null', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40');
INSERT INTO `ebcms5_formfield` VALUES ('30', '6', '基本配置', '提示信息', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('31', '6', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('47', '9', '基本配置', '允许的类型', 'extensions', '', 'config', '3', 'extensions', 'form_textbox', 'null', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40');
INSERT INTO `ebcms5_formfield` VALUES ('48', '9', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('49', '9', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('66', '13', '基本配置', '模型名称', 'model', '', 'config', '3', 'model', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '对应的后台的模型名称', '50');
INSERT INTO `ebcms5_formfield` VALUES ('67', '13', '基本配置', '是否可编辑', 'editable', '', 'config', '3', 'editable', 'form_bool', 'null', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '48');
INSERT INTO `ebcms5_formfield` VALUES ('69', '13', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '43');
INSERT INTO `ebcms5_formfield` VALUES ('70', '13', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '42');
INSERT INTO `ebcms5_formfield` VALUES ('71', '13', '基本配置', '根选项', 'rootitem', '', 'config', '3', 'rootitem', 'form_bool', 'null', '根选项开启后 所有条目都会在根选项之下，通常用于选择父级 默认0', '40');
INSERT INTO `ebcms5_formfield` VALUES ('72', '13', '其他配置', '查询条件', 'queryparams', '', 'config', '3', 'queryparams', 'form_multitextbox', 'null', '格式：字段|eq|value\r\n字段|eq|(I)value 添加(I)表示的是提交变量\r\n字段|eq|(@)value 添加(@)表示的是变量', '40');
INSERT INTO `ebcms5_formfield` VALUES ('73', '13', '基本配置', '树型化', 'tree', '', 'config', '3', 'tree', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('74', '13', '其他配置', '递归字段', 'pid', '', 'config', '3', 'pid', 'form_textbox', 'null', '通常请不要修改 默认pid', '30');
INSERT INTO `ebcms5_formfield` VALUES ('75', '13', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('76', '13', '其他配置', '显示字段', 'titlefield', '', 'config', '3', 'titlefield', 'form_textbox', 'null', '默认为text', '9');
INSERT INTO `ebcms5_formfield` VALUES ('77', '13', '其他配置', '值字段', 'valuefield', '', 'config', '3', 'valuefield', 'form_textbox', 'null', '默认为id', '6');
INSERT INTO `ebcms5_formfield` VALUES ('78', '13', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('79', '13', '其他配置', '宽度', 'width', '', 'config', '3', 'width', 'form_numberbox', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('81', '14', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('82', '14', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('83', '14', '基本配置', '高度', 'height', '', 'config', '3', 'height', 'form_numberbox', 'null', '这里是指行数。默认5', '31');
INSERT INTO `ebcms5_formfield` VALUES ('84', '14', '基本配置', '宽度', 'width', '', 'config', '3', 'width', 'form_numberbox', 'null', '不填写表示 100% ', '30');
INSERT INTO `ebcms5_formfield` VALUES ('87', '14', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '15');
INSERT INTO `ebcms5_formfield` VALUES ('88', '14', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('104', '18', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '{\"disabled\":\"0\",\"values\":\"系统|系统\\r\\n普通|普通\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('106', '18', '基本信息', '名称', 'title', '', '', '0', '', 'form_textbox', 'null', '', '91');
INSERT INTO `ebcms5_formfield` VALUES ('107', '18', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('109', '19', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '{\"disabled\":\"0\",\"values\":\"系统|系统\\r\\n普通|普通\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('110', '19', '基本信息', '名称', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '82');
INSERT INTO `ebcms5_formfield` VALUES ('111', '19', '基本信息', '备注', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('112', '19', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('113', '20', '基本信息', '邮箱', 'email', '', '', '0', '', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('114', '20', '基本信息', '昵称', 'nickname', '', '', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"2-6个字符\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('115', '20', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"5-10个字符\",\"maxlength\":\"10\",\"minlength\":\"5\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('116', '20', '基本信息', '头像', 'avatar', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/manager\\/avatar\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('119', '21', '基本信息', '邮箱', 'email', '', '', '3', 'email', 'form_textbox', 'null', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('120', '21', '基本信息', '昵称', 'nickname', '', '', '3', 'nickname', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('121', '21', '基本信息', '头像', 'avatar', '', '', '3', 'avatar', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/manager\\/avatar\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('123', '21', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('124', '22', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('125', '22', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96');
INSERT INTO `ebcms5_formfield` VALUES ('126', '22', '基本信息', '说明', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '75');
INSERT INTO `ebcms5_formfield` VALUES ('127', '23', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('128', '23', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '97');
INSERT INTO `ebcms5_formfield` VALUES ('129', '23', '基本信息', '说明', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '46');
INSERT INTO `ebcms5_formfield` VALUES ('130', '23', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('131', '24', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('132', '24', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"10\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96');
INSERT INTO `ebcms5_formfield` VALUES ('133', '24', '基本信息', '字段', 'name', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '89');
INSERT INTO `ebcms5_formfield` VALUES ('134', '24', '基本信息', '表单类型', 'type', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|表单配置\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('135', '24', '基本信息', '默认值', 'value', '', '', '0', '', 'form_multitextbox', 'null', '', '78');
INSERT INTO `ebcms5_formfield` VALUES ('136', '24', '基本信息', '说明', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('137', '24', '基本信息', '分类', 'category_id', '', '', '1', 'category_id', 'form_hidden', 'null', '', '2');
INSERT INTO `ebcms5_formfield` VALUES ('138', '25', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('139', '25', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '95');
INSERT INTO `ebcms5_formfield` VALUES ('140', '25', '基本信息', '字段', 'name', '', '', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '94');
INSERT INTO `ebcms5_formfield` VALUES ('141', '25', '基本信息', '表单类型', 'type', '', '', '3', 'type', 'form_database', '{\"model\":\"ebcms\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|表单配置\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '更改表单类型后 请更改上一行字段名称 否则可能报错', '93');
INSERT INTO `ebcms5_formfield` VALUES ('142', '25', '基本信息', '默认值', 'value', '', '', '3', 'value', 'form_multitextbox', 'null', '', '87');
INSERT INTO `ebcms5_formfield` VALUES ('143', '25', '基本信息', '说明', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '67');
INSERT INTO `ebcms5_formfield` VALUES ('144', '25', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('145', '26', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('146', '26', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '55');
INSERT INTO `ebcms5_formfield` VALUES ('147', '26', '基本配置', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50');
INSERT INTO `ebcms5_formfield` VALUES ('148', '26', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('149', '27', '基本信息', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('150', '27', '基本信息', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '70');
INSERT INTO `ebcms5_formfield` VALUES ('151', '27', '基本信息', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50');
INSERT INTO `ebcms5_formfield` VALUES ('152', '27', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('175', '32', '基本信息', '旧密码', 'oldpassword', '', '', '0', '', 'form_textbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('176', '32', '基本信息', '新密码', 'password', '', '', '0', '', 'form_textbox', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('177', '32', '基本信息', '重复密码', 'passwordtwo', '', '', '0', '', 'form_textbox', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('178', '33', '基本信息', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '80');
INSERT INTO `ebcms5_formfield` VALUES ('179', '33', '基本信息', '是否可编辑', 'editable', '', 'config', '3', 'editable', 'form_bool', 'null', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '60');
INSERT INTO `ebcms5_formfield` VALUES ('180', '33', '基本信息', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('181', '33', '基本信息', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('182', '33', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2882', '411', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('2883', '411', '基本信息', '链接地址', 'eb_url', '', '', '0', '', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/\r\n系统写法：content/index/lists?id=1', '6');
INSERT INTO `ebcms5_formfield` VALUES ('2884', '411', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('2885', '411', '基本信息', '父级', 'pid', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/nav\",\"editable\":\"0\",\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"group|eq|(I)group\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2886', '412', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"ebcms\\/nav\",\"editable\":\"0\",\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"group|eq|(@)group\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('2887', '412', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2888', '412', '基本信息', '链接地址', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/\r\n系统写法：content/index/lists?id=1', '7');
INSERT INTO `ebcms5_formfield` VALUES ('2889', '412', '个性扩展', '个性扩展', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2890', '412', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2891', '411', '基本信息', '所属应用', 'app', '', '', '0', '', 'form_textbox', '{\"prompt\":\"可不填\"}', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：\r\n1、卸载应用的时候，自动删除\r\n2、暂停应用的时候，前台自动隐藏', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2892', '412', '基本信息', '所属应用', 'app', '', '', '3', 'app', 'form_textbox', '{\"prompt\":\"可不填\"}', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：\r\n1、卸载应用的时候，自动删除\r\n2、暂停应用的时候，前台自动隐藏', '5');
INSERT INTO `ebcms5_formfield` VALUES ('7002', '411', '个性扩展', '个性扩展', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('7006', '13', '基本配置', '分组化', 'group', '', 'config', '3', 'group', 'form_bool', 'null', '', '35');
INSERT INTO `ebcms5_formfield` VALUES ('10186', '1444', '基本信息', '邮件主题', 'topic', '', '', '1', 'topic', 'form_select', '{\"values\":\"系统消息|系统消息\\r\\n优惠信息|优惠信息\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('10187', '1444', '基本信息', '邮件地址', 'email', '', '', '1', 'email', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('10188', '1444', '基本信息', '对方称呼', 'name', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('10189', '1444', '基本信息', '内容', 'content', '', '', '0', '', 'form_ueditor', '{\"initialframeheight\":\"200\",\"maximumwords\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('10558', '1497', '基本配置', 'HTML', 'html', '', 'config', '3', 'html', 'form_multitextbox', '{\"height\":\"20\",\"width\":\"\",\"prompt\":\"\"}', '常见结构：\r\n&lt;tr&gt;\r\n	&lt;th&gt;{$field.title}&lt;/th&gt;\r\n	&lt;td&gt;\r\n		&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;示例&quot;&gt;\r\n		{notempty name=\'field.remark\'}\r\n			&lt;p class=&quot;help-block&quot;&gt;{$field.remark}&lt;/p&gt;\r\n		{/notempty}\r\n	&lt;/td&gt;\r\n&lt;/tr&gt;\r\n支持变量：\r\nfield   当前字段的配置数据\r\ndata    当前表单分配的数据\r\ngroups  当前表单的字段信息\r\nform    当前表单信息', '9');
INSERT INTO `ebcms5_formfield` VALUES ('10559', '1497', '基本配置', 'ID', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('11750', '411', '基本信息', '打开方式', 'target', '', '', '0', '_self', 'form_select', '{\"values\":\"新窗口|_blank\\r\\n当前窗口|_self\\r\\n父窗口|_parent\\r\\n_top|_top\",\"editable\":\"1\"}', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('11751', '412', '基本信息', '打开方式', 'target', '', '', '3', 'target', 'form_select', '{\"values\":\"新窗口|_blank\\r\\n当前窗口|_self\\r\\n父窗口|_parent\\r\\n_top|_top\",\"editable\":\"1\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('12294', '22', '基本信息', '所属应用', 'app', '', '', '0', '', 'form_textbox', 'null', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：卸载应用的时候，自动删除', '10');
INSERT INTO `ebcms5_formfield` VALUES ('12295', '23', '基本信息', '所属应用', 'app', '', '', '3', 'app', 'form_textbox', 'null', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：卸载应用的时候，自动删除', '10');
INSERT INTO `ebcms5_formfield` VALUES ('17492', '2542', '基本信息', '权限', 'rule_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n    $checked = \\\\think\\\\Db::name(\'auth_group\')-&gt;where(array(\'id\' =&gt; array(\'eq\', input(\'id\'))))-&gt;value(\'rules\');\\r\\n    $rules = \\\\think\\\\Db::name(\'auth_rule\')-&gt;order(\'sort desc\')-&gt;select();\\r\\n    $rules = \\\\ebcms\\\\Tree::tree($rules);\\r\\n{\\/php}\\r\\n{foreach name=\'rules\' item=\'a\'}\\r\\n    &lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n        &lt;tr&gt;\\r\\n            &lt;td colspan=&quot;2&quot;&gt;\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$a.id}&quot; {in name=&quot;a.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$a.title}\\r\\n                &lt;\\/label&gt;\\r\\n            &lt;\\/td&gt;\\r\\n        &lt;\\/tr&gt;\\r\\n        {foreach name=\'a.rows\' item=\'b\'}\\r\\n        &lt;tr&gt;\\r\\n            &lt;th&gt;\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$b.id}&quot; {in name=&quot;b.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$b.title}\\r\\n                &lt;\\/label&gt;\\r\\n            &lt;\\/th&gt;\\r\\n            &lt;td&gt;\\r\\n                {foreach name=\'b.rows\' item=\'c\'}\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$c.id}&quot; {in name=&quot;c.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$c.title}\\r\\n                &lt;\\/label&gt;\\r\\n                {\\/foreach}\\r\\n            &lt;\\/td&gt;\\r\\n        &lt;\\/tr&gt;\\r\\n        {\\/foreach}\\r\\n    &lt;\\/table&gt;\\r\\n{\\/foreach}\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17493', '2542', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('17494', '2543', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17495', '2543', '基本信息', '菜单', 'menu_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$checked = \\\\think\\\\Db::name(\'auth_group\')-&gt;where(array(\'id\' =&gt; array(\'eq\', input(\'id\'))))-&gt;value(\'menus\');\\r\\n\\t$menus = \\\\think\\\\Db::name(\'menu\')-&gt;order(\'sort desc\')-&gt;select();\\r\\n\\t$menus = \\\\ebcms\\\\Tree::tree($menus);\\r\\n{\\/php}\\r\\n&lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n\\t{foreach name=\'menus\' item=\'top\'}\\r\\n\\t&lt;tr&gt;\\r\\n\\t\\t&lt;th&gt;\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$top.id}&quot; {in name=&quot;top.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$top.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t&lt;\\/th&gt;\\r\\n\\t\\t&lt;td&gt;\\r\\n\\t\\t\\t{foreach name=\'top.rows\' item=\'sub\'}\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$sub.id}&quot; {in name=&quot;sub.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$sub.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;\\/td&gt;\\r\\n\\t&lt;\\/tr&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/table&gt;\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17496', '2544', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17497', '2544', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '2');
INSERT INTO `ebcms5_formfield` VALUES ('17498', '2545', '基本信息', '角色', 'group_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$checked = \\\\think\\\\Db::name(\'auth_access\')-&gt;where(\'uid=\' . input(\'id\'))-&gt;column(\'group_id\');\\r\\n\\t$groups = \\\\think\\\\Db::name(\'auth_group\')-&gt;select();\\r\\n\\t$groups = \\\\ebcms\\\\Tree::group($groups);\\r\\n{\\/php}\\r\\n&lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n\\t{foreach name=\'groups\' item=\'items\'}\\r\\n\\t&lt;tr&gt;\\r\\n\\t\\t&lt;th&gt;\\r\\n\\t\\t\\t{$key}\\r\\n\\t\\t&lt;\\/th&gt;\\r\\n\\t\\t&lt;td&gt;\\r\\n\\t\\t\\t{foreach name=\'items\' item=\'vo\'}\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$vo.id}&quot; {in name=&quot;vo.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$vo.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;\\/td&gt;\\r\\n\\t&lt;\\/tr&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/table&gt;\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17499', '2545', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17500', '2546', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', null, '为保证系统安全，请输入密码！', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17501', '2546', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('18296', '6', '基本配置', '上传目录', 'path', '', 'config', '3', 'path', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('18299', '9', '基本配置', '上传目录', 'path', '', 'config', '3', 'path', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('21544', '13', '基本配置', '查询排序', 'order', '', 'config', '3', '', 'form_textbox', null, '', '49');
INSERT INTO `ebcms5_formfield` VALUES ('21545', '13', '基本配置', '查询排序', 'order', '', 'config', '3', '', 'form_textbox', null, '', '49');
INSERT INTO `ebcms5_formfield` VALUES ('22372', '3173', '基本信息', '父级', 'pid', '', '', '1', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22373', '3173', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"editable\":\"1\",\"maxlength\":\"80\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22374', '3173', '基本信息', '名称', 'name', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"请填写英文字符\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22375', '3173', '高级设置', 'meta标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', 'null', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22376', '3173', '基本信息', '关键字', 'keywords', '', '', '0', '', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '空格或英文的逗号分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22377', '3173', '基本信息', '摘要', 'description', '', '', '0', '', 'form_multitextbox', '{\"required\":\"0\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"255\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22378', '3173', '高级设置', '模型扩展', 'extend_id', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '在 【系统管理 =&gt; 模型扩展】 里面设置\n可以根据自身网站需要扩展出 产品模型 图集模型 下载模型等等', '41');
INSERT INTO `ebcms5_formfield` VALUES ('22379', '3173', '高级设置', '列表页模板', 'tpl', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填写 默认为channel\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22380', '3173', '高级设置', '内容页模板', 'tpl_detail', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填写默认为 detail\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '21');
INSERT INTO `ebcms5_formfield` VALUES ('22381', '3173', '高级设置', '跳转链接', 'eb_url', '', '', '0', '', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/news.html\n以及系统写法：content/index/channel?id=3', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22382', '3173', '个性扩展', '个性扩展', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22383', '3174', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '600');
INSERT INTO `ebcms5_formfield` VALUES ('22384', '3174', '高级设置', 'META标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', 'null', '用作seo标题设置，不填则默认为标题', '300');
INSERT INTO `ebcms5_formfield` VALUES ('22385', '3174', '高级设置', '短标题', 'eb_shorttitle', '', '', '0', '', 'form_textbox', 'null', '一般用作 首页 列表页调用 没有则调用标题', '70');
INSERT INTO `ebcms5_formfield` VALUES ('22386', '3174', '高级设置', '摘要', 'description', '', '', '0', '', 'form_multitextbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22387', '3174', '基本信息', '关键字', 'keywords', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    $(function() {\\r\\n        EBCMS.CORE.myfun(\'suggest_keywords\',function(container,content,strong){\\r\\n            if (content) {\\r\\n                if (content != 0) {\\r\\n                    if ($(container).val()) {\\r\\n                        var keywords = $(container).val().split(\',\');\\r\\n                        var ue = UE.getEditor(content);\\r\\n                        var contents = ue.getContent().split(\'\\uff0c\');\\r\\n                        var num = Math.min(keywords.length,contents.length-1);\\r\\n                        var nums = EBCMS.FN.random_num(num,0,contents.length-1);\\r\\n                        $.each(nums, function(index, val) {\\r\\n                            if (strong == 1) {\\r\\n                                contents[val] = contents[val]+\'\\uff0c&lt;strong&gt;\'+keywords[index]+\'&lt;\\/strong&gt;\';\\r\\n                            }else{\\r\\n                                contents[val] = contents[val]+\'\\uff0c\'+keywords[index];\\r\\n                            }\\r\\n                        });\\r\\n                        ue.setContent(contents.join(\'\\uff0c\'));\\r\\n                    }\\r\\n                }else{\\r\\n                    EBCMS.MSG.notice(\'\\u672a\\u914d\\u7f6e\\u63a5\\u6536\\u5b57\\u6bb5\\uff01\');\\r\\n                }\\r\\n            }else{\\r\\n                EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u4e2d...\');\\r\\n                $.ajax({\\r\\n                    url: \'{:url(\'ebcms\\/api\\/index\')}\',\\r\\n                    type: \'POST\',\\r\\n                    dataType: \'json\',\\r\\n                    data: {\\r\\n                        api: \'suggest_keywords\',\\r\\n                        k:$(container).val(),\\r\\n                    },\\r\\n                    success:function(res){\\r\\n                        if (res.data &amp;&amp; res.data.length) {\\r\\n                            EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u6210\\u529f...\',0.5);\\r\\n                            $(container).val($(container).val()+\',\'+res.data.join(\',\'));\\r\\n                        }else{\\r\\n                            EBCMS.MSG.tips(\'\\u6682\\u65e0\\u5185\\u5bb9...\');\\r\\n                        }\\r\\n                    },\\r\\n                    error:function(){\\r\\n                        EBCMS.MSG.alert(\'\\u670d\\u52a1\\u5668\\u5fd9\\uff0c\\u8bf7\\u7a0d\\u540e\\u518d\\u8bd5\\uff01\');\\r\\n                    }\\r\\n                });\\r\\n            }\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n    &lt;tr&gt;\\r\\n        &lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\\r\\n            &lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\');&quot;&gt;\\u957f\\u5c3e\\u5173\\u952e\\u8bcd&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\',\'{$groups[\'\\u57fa\\u672c\\u4fe1\\u606f\'][\'body[body]\'][\'unique\']}\',1);&quot;&gt;\\u63d2\\u5165\\u5230\\u5185\\u5bb9&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n    &lt;\\/tr&gt;\\r\\n&lt;\\/table&gt;\"}', '空格或英文的逗号分割', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22388', '3174', '基本信息', '标签', 'tags', '', '', '0', '', 'form_textbox', 'null', '空格或英文的逗号分割', '42');
INSERT INTO `ebcms5_formfield` VALUES ('22389', '3174', '高级设置', '模板', 'tpl', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填默认为detail\"}', '只填写文件名，不要写后缀\n模板位于 application/content/view/index/下', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22390', '3174', '高级设置', '文件名', 'filename', '', '', '0', '', 'form_textbox', 'null', '默认为文章id', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22391', '3174', '基本信息', '缩略图', 'thumb', '', '', '0', '', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/content\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22392', '3174', '基本信息', '内容', 'body', '', 'body', '0', '', 'form_ueditor', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22393', '3174', '高级设置', '外部链接', 'eb_url', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '常规写法：http://www.ebcms.com/news.html\n系统写法：content/index/channel?id=1', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22394', '3174', '基本信息', '分类', 'channel_id', '', '', '1', 'channel_id', 'form_hidden', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"extend_id|eq|($)channel.extend_id\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22395', '3175', '基本信息', '将标签', 'tag1', '', '', '1', 'tag1', 'form_textbox', '{\"required\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"\"}', '多个标签 请用空格分隔', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22396', '3175', '基本信息', '合并到', 'tag2', '', '', '1', 'tag2', 'form_textbox', 'null', '不存在则自动创建', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22397', '3176', '基本信息', '栏目id', 'ids', '', '', '1', 'ids', 'form_multitextbox', '{\"required\":\"1\",\"disabled\":\"0\",\"readonly\":\"1\",\"height\":\"\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22398', '3176', '基本信息', '合并到', 'id', '', '', '0', '', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"id|notin|(I)ids\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '不同模型之间的栏目合并，如果和目标栏目模型不一样，会造成这些栏目下面的内容的自定义扩展数据丢失，但主体内容不受影响！', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22399', '3177', '基本信息', '标签', 'tag', '', '', '3', 'tag', 'form_textbox', 'null', '若标签存在，将执行合并', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22400', '3177', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22401', '3178', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22402', '3178', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22403', '3178', '基本信息', '名称', 'name', '', '', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22404', '3178', '基本信息', '关键字', 'keywords', '', '', '3', 'keywords', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '用空格或英文的逗号”,“分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22405', '3178', '高级设置', 'meta标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22406', '3178', '基本信息', '摘要', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22407', '3178', '高级设置', '模型扩展', 'extend_id', '', '', '3', 'extend_id', 'form_database', '{\"model\":\"ebcms\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '在 【系统管理 =&gt; 模型扩展】 里面设置\n可以根据自身网站需要扩展出 产品模型 图集模型 下载模型等等', '41');
INSERT INTO `ebcms5_formfield` VALUES ('22408', '3178', '高级设置', '列表页模板', 'tpl', '', '', '3', 'tpl', 'form_textbox', '{\"prompt\":\"不填写 默认为channel\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22409', '3178', '高级设置', '内容页模板', 'tpl_detail', '', '', '3', 'tpl_detail', 'form_textbox', '{\"prompt\":\"不填写 默认为detail\"}', '只填写文件名，不要写填写后缀\n模板文件位于 application/content/view/index/下面', '21');
INSERT INTO `ebcms5_formfield` VALUES ('22410', '3178', '高级设置', '跳转链接', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/news.html\n以及系统写法：content/index/channel?id=3', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22411', '3178', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22412', '3178', '个性扩展', '扩展字段', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22413', '3179', '基本信息', '内容id', 'ids', '', '', '1', 'ids', 'form_multitextbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22414', '3179', '基本信息', '移动到', 'channel_id', '', '', '1', 'channel_id', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '如果移动的内容和移动到的栏目的模型不一样，会造成移动的内容中模型不一样的那一部分数据的自定义扩展内容数据丢失，但主体内容数据不会丢失！\n非超级管理员操作，会自动排除已经锁定的数据。', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22415', '3180', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '600');
INSERT INTO `ebcms5_formfield` VALUES ('22416', '3180', '高级设置', 'META标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', 'null', '用作seo标题设置，不填则默认为标题', '300');
INSERT INTO `ebcms5_formfield` VALUES ('22417', '3180', '高级设置', '短标题', 'eb_shorttitle', '', '', '3', 'eb_shorttitle', 'form_textbox', 'null', '一般用作 首页 列表页调用 没有则调用标题', '70');
INSERT INTO `ebcms5_formfield` VALUES ('22418', '3180', '基本信息', '关键字', 'keywords', '', '', '3', 'keywords', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    $(function() {\\r\\n        EBCMS.CORE.myfun(\'suggest_keywords\',function(container,content,strong){\\r\\n            if (content) {\\r\\n                if (content != 0) {\\r\\n                    if ($(container).val()) {\\r\\n                        var keywords = $(container).val().split(\',\');\\r\\n                        var ue = UE.getEditor(content);\\r\\n                        var contents = ue.getContent().split(\'\\uff0c\');\\r\\n                        var num = Math.min(keywords.length,contents.length-1);\\r\\n                        var nums = EBCMS.FN.random_num(num,0,contents.length-1);\\r\\n                        $.each(nums, function(index, val) {\\r\\n                            if (strong == 1) {\\r\\n                                contents[val] = contents[val]+\'\\uff0c&lt;strong&gt;\'+keywords[index]+\'&lt;\\/strong&gt;\';\\r\\n                            }else{\\r\\n                                contents[val] = contents[val]+\'\\uff0c\'+keywords[index];\\r\\n                            }\\r\\n                        });\\r\\n                        ue.setContent(contents.join(\'\\uff0c\'));\\r\\n                    }\\r\\n                }else{\\r\\n                    EBCMS.MSG.notice(\'\\u672a\\u914d\\u7f6e\\u63a5\\u6536\\u5b57\\u6bb5\\uff01\');\\r\\n                }\\r\\n            }else{\\r\\n                EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u4e2d...\');\\r\\n                $.ajax({\\r\\n                    url: \'{:url(\'ebcms\\/api\\/index\')}\',\\r\\n                    type: \'POST\',\\r\\n                    dataType: \'json\',\\r\\n                    data: {\\r\\n                        api: \'suggest_keywords\',\\r\\n                        k:$(container).val(),\\r\\n                    },\\r\\n                    success:function(res){\\r\\n                        if (res.data &amp;&amp; res.data.length) {\\r\\n                            EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u6210\\u529f...\',0.5);\\r\\n                            $(container).val($(container).val()+\',\'+res.data.join(\',\'));\\r\\n                        }else{\\r\\n                            EBCMS.MSG.tips(\'\\u6682\\u65e0\\u5185\\u5bb9...\');\\r\\n                        }\\r\\n                    },\\r\\n                    error:function(){\\r\\n                        EBCMS.MSG.alert(\'\\u670d\\u52a1\\u5668\\u5fd9\\uff0c\\u8bf7\\u7a0d\\u540e\\u518d\\u8bd5\\uff01\');\\r\\n                    }\\r\\n                });\\r\\n            }\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n    &lt;tr&gt;\\r\\n        &lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\\r\\n            &lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\');&quot;&gt;\\u957f\\u5c3e\\u5173\\u952e\\u8bcd&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\',\'{$groups[\'\\u57fa\\u672c\\u4fe1\\u606f\'][\'body[body]\'][\'unique\']}\',1);&quot;&gt;\\u63d2\\u5165\\u5230\\u5185\\u5bb9&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n    &lt;\\/tr&gt;\\r\\n&lt;\\/table&gt;\"}', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22419', '3180', '高级设置', '摘要', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22420', '3180', '高级设置', '模板', 'tpl', '', '', '3', 'tpl', 'form_textbox', '{\"prompt\":\"不填写 默认为detail\"}', '只填写文件名，不要写后缀\n模板位于 application/content/view/index/下', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22421', '3180', '基本信息', '标签', 'tags', '', '', '3', 'tags', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '35');
INSERT INTO `ebcms5_formfield` VALUES ('22422', '3180', '高级设置', '文件名', 'filename', '', '', '3', 'filename', 'form_textbox', '{\"prompt\":\"\"}', '默认为文章id', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22423', '3180', '基本信息', '缩略图', 'thumb', '', '', '3', 'thumb', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/content\",\"prompt\":\"\"}', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22424', '3180', '高级设置', '外部链接', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '常规写法：http://www.ebcms.com/news.html\n系统写法：content/index/channel?id=1', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22425', '3180', '基本信息', '内容', 'body', 'body', '', '3', 'body', 'form_ueditor', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22426', '3180', '高级设置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22427', '3181', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22428', '3181', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22429', '3181', '基本信息', '键', 'name', '', '', '0', '', 'form_textbox', '', '英文字符', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22430', '3181', '基本信息', '值', 'value', '', '', '0', '', 'form_custom', '{\"html\":\"{switch name=&quot;$Request.param.form&quot;}\\r\\n\\t{case value=&quot;multitextbox&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;ueditor&quot;}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUE(\'{$field.unique}\',{\\r\\n\\t\\t\\t\\t\\tautoHeightEnabled:{$field.config.autoheightenabled|default=\'false\'},\\r\\n\\t\\t\\t\\t\\tmaximumWords:{$field.config.maximumwords|default=\'10000\'},\\r\\n\\t\\t\\t\\t\\twordCount:{$field.config.wordcount|default=\'true\'},\\r\\n\\t\\t\\t\\t\\telementPathEnabled:{$field.config.elementpathenabled|default=\'true\'},\\r\\n\\t\\t\\t\\t\\tinitialFrameHeight:{$field.config.initialframeheight|default=\'420\'},\\r\\n\\t\\t\\t\\t});\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;textarea name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot;&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;upload&quot;}\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$field[\'config\'][\'path\'] = \'\\/mbzs\'\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUploader(\'#{$field.unique}_pick\',function(file,res){\\r\\n\\t\\t\\t\\t\\tif (res.code) {\\r\\n\\t\\t\\t\\t\\t\\t$(\'#{$field.unique}\').val(res.data.pathname);\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\tEBCMS.MSG.alert(res.msg);\\r\\n\\t\\t\\t\\t\\t};\\r\\n\\t\\t\\t\\t},\'{$field.config.extensions|default=&quot;&quot;}\',\'{$field.config.path|default=&quot;&quot;}\');\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n\\t\\t\\t&lt;tr&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;padding: 0px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;div id=&quot;{$field.unique}_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t&lt;\\/tr&gt;\\r\\n\\t\\t&lt;\\/table&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;tpl&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n{\\/switch}\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22431', '3181', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', '', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22432', '3181', '基本信息', '表单类型', 'form', '', '', '1', 'form', 'form_hidden', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5355\\u884c\\u6587\\u672c|form_textbox\\r\\n\\u591a\\u884c\\u6587\\u672c|form_multitextbox\\r\\n\\u7f16\\u8f91\\u5668|form_ueditor\\r\\n\\u56fe\\u7247|form_image\\r\\n\\u5e03\\u5c14|form_bool\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22433', '3182', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22434', '3182', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22435', '3182', '基本信息', '键', 'name', '', '', '3', 'name', 'form_textbox', '', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22436', '3182', '基本信息', '值', 'value', '', '', '3', 'value', 'form_custom', '{\"html\":\"{switch name=&quot;data.form&quot;}\\r\\n\\t{case value=&quot;multitextbox&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;ueditor&quot;}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUE(\'{$field.unique}\',{\\r\\n\\t\\t\\t\\t\\tautoHeightEnabled:{$field.config.autoheightenabled|default=\'false\'},\\r\\n\\t\\t\\t\\t\\tmaximumWords:{$field.config.maximumwords|default=\'10000\'},\\r\\n\\t\\t\\t\\t\\twordCount:{$field.config.wordcount|default=\'true\'},\\r\\n\\t\\t\\t\\t\\telementPathEnabled:{$field.config.elementpathenabled|default=\'true\'},\\r\\n\\t\\t\\t\\t\\tinitialFrameHeight:{$field.config.initialframeheight|default=\'420\'},\\r\\n\\t\\t\\t\\t});\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;textarea name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot;&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;upload&quot;}\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$field[\'config\'][\'path\'] = \'\\/mbzs\'\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUploader(\'#{$field.unique}_pick\',function(file,res){\\r\\n\\t\\t\\t\\t\\tif (res.code) {\\r\\n\\t\\t\\t\\t\\t\\t$(\'#{$field.unique}\').val(res.data.pathname);\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\tEBCMS.MSG.alert(res.msg);\\r\\n\\t\\t\\t\\t\\t};\\r\\n\\t\\t\\t\\t},\'{$field.config.extensions|default=&quot;&quot;}\',\'{$field.config.path|default=&quot;&quot;}\');\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n\\t\\t\\t&lt;tr&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;padding: 0px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;div id=&quot;{$field.unique}_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t&lt;\\/tr&gt;\\r\\n\\t\\t&lt;\\/table&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;tpl&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n{\\/switch}\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22437', '3182', '基本信息', '备注', 'remark', '', '', '3', 'remark', 'form_multitextbox', '', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22438', '3182', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', '', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22439', '3183', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_select', '{\"values\":\"友情链接|友情链接\\r\\n合作伙伴|合作伙伴\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22440', '3183', '基本信息', '名称', 'title', '', '', '0', '', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22441', '3183', '基本信息', '网址', 'url', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22442', '3183', '基本信息', '站标', 'logo', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/link\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22443', '3183', '基本信息', '简介', 'description', '', '', '0', '', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22444', '3183', '基本信息', '其他信息', 'info', '', '', '0', '', 'form_multitextbox', 'null', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22445', '3184', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_select', '{\"values\":\"友情链接|友情链接\\r\\n合作伙伴|合作伙伴\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22446', '3184', '基本信息', '名称', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22447', '3184', '基本信息', '网址', 'url', '', '', '3', 'url', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22448', '3184', '基本信息', '站标', 'logo', '', '', '3', 'logo', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/link\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22449', '3184', '基本信息', '简介', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22450', '3184', '基本信息', '其他信息', 'info', '', '', '3', 'info', 'form_multitextbox', 'null', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22451', '3184', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22514', '3199', '基本信息', '分组', 'group', '', '', '0', '默认分组', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22515', '3199', '高级设置', '列表模板', 'tpl_list', '', 'config', '0', '', 'form_textbox', null, '默认为 list', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22516', '3199', '数据扩展', '数据扩展', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*改名名称*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*编辑器*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;填写内容&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;上传&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;单行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;多行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;文件&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;编辑框&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        {notempty name=\'field.remark\'}\\r\\n            &lt;p class=&quot;help-block&quot;&gt;{$field.remark}&lt;\\/p&gt;\\r\\n        {\\/notempty}\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;table-responsive&quot; style=&quot;border: 1px solid #ddd;&quot;&gt;\\r\\n            &lt;table class=&quot;table table-noborder&quot; id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/table&gt;\\r\\n            &lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\\r\\n        &lt;\\/div&gt;\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22517', '3199', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22518', '3199', '基本信息', 'META标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22519', '3199', '高级设置', '帖子模板', 'tpl_thread', '', 'config', '0', '', 'form_textbox', null, '默认为 thread', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22520', '3199', '基本信息', '关键词', 'keywords', '', '', '0', '', 'form_textbox', null, '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22521', '3199', '基本信息', '简介', 'description', '', '', '0', '', 'form_multitextbox', null, '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22522', '3200', '基本信息', '帖子ID', 'ids', '', '', '1', 'ids', 'form_multitextbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22523', '3200', '基本信息', '移动到', 'forum_id', '', '', '0', '', 'form_database', '{\"model\":\"forum\\/forum\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22524', '3201', '基本信息', '用户ID', 'user_id', '', '', '0', '', 'form_numberbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22525', '3201', '基本信息', '权限', 'auth', '', '', '0', '', 'form_checkbox', '{\"values\":\"删除|delete\\r\\n编辑|edit\\r\\n审核|status\\r\\n精华|best\\r\\n置顶|top1\\r\\n全局置顶|top2\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22526', '3201', '基本信息', '论坛id', 'forum_id', '', '', '1', 'forum_id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22527', '3202', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22528', '3202', '高级设置', '列表模板', 'tpl_list', '', 'config', '3', 'tpl_list', 'form_textbox', null, '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22529', '3202', '数据扩展', '数据扩展', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*改名名称*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*编辑器*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;填写内容&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;填写内容&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;上传&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:180px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;删除&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;上移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;下移&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width:120px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;填写名称&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;单行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;多行文本&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;文件&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;编辑框&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        {notempty name=\'field.remark\'}\\r\\n            &lt;p class=&quot;help-block&quot;&gt;{$field.remark}&lt;\\/p&gt;\\r\\n        {\\/notempty}\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;div class=&quot;table-responsive&quot; style=&quot;border: 1px solid #ddd;&quot;&gt;\\r\\n            &lt;table class=&quot;table table-noborder&quot; id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/table&gt;\\r\\n            &lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\\r\\n        &lt;\\/div&gt;\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22530', '3202', '高级设置', '帖子模板', 'tpl_thread', '', 'config', '3', 'tpl_thread', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22531', '3202', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22532', '3202', '基本信息', 'META标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22533', '3202', '基本信息', '关键词', 'keywords', '', '', '3', 'keywords', 'form_textbox', null, '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22534', '3202', '基本信息', '简介', 'description', '', '', '3', 'description', 'form_multitextbox', null, '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22535', '3202', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22536', '3203', '基本信息', '用户id', 'user_id', '', '', '3', 'user_id', 'form_numberbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22537', '3203', '基本信息', '权限', 'auth', '', '', '3', 'auth', 'form_checkbox', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"删除|delete\\r\\n编辑|edit\\r\\n审核|status\\r\\n精华|best\\r\\n置顶|top1\\r\\n全局置顶|top2\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22538', '3203', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22539', '3204', '基本信息', '权限', 'auth', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n    $grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n    $grades[0] = \'游客\';\\r\\n    $x = \\\\think\\\\Db::name(\'forum\') -&gt; find(input(\'id\'));\\r\\n    $auth = explode(\',\',$x[\'auth\']);\\r\\n    $authgroup = [\\r\\n        \'浏览\'                =&gt;  0,\\r\\n        \'发帖\'                =&gt;  10,\\r\\n        \'发帖无须审核\'        =&gt;  11,\\r\\n        \'发帖无须验证码\'         =&gt;  12,\\r\\n        \'跟帖\'                =&gt;  40,\\r\\n        \'跟帖无须审核\'        =&gt;  41,\\r\\n        \'跟帖验证码\'         =&gt;  42,\\r\\n    ];\\r\\n{\\/php}\\r\\n&lt;script&gt;\\r\\n    $(function(){\\r\\n        $(\'.auth\').bind(\'click\', function(event) {\\r\\n            $(\'input\',this).trigger(\'click\');\\r\\n        });\\r\\n        $(\'._aa\').bind(\'click\', function(event) {\\r\\n            $(\'.aa_\'+$(this).data(\'x\')).trigger(\'click\');\\r\\n        });\\r\\n        $(\'._bb\').bind(\'click\', function(event) {\\r\\n            $(\'.bb_\'+$(this).data(\'x\')).trigger(\'click\');\\r\\n        });\\r\\n        $(\'._aabb\').bind(\'click\', function(event) {\\r\\n            $(\'.auth\').trigger(\'click\');\\r\\n        });\\r\\n        $.each({$auth|json_encode}, function(index, val) {\\r\\n            $(\'.auth_\'+val).trigger(\'click\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;tr&gt;\\r\\n    &lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n    &lt;td&gt;\\r\\n        &lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n            &lt;tr&gt;\\r\\n                &lt;th class=&quot;_aabb&quot;&gt;&lt;\\/th&gt;\\r\\n                {foreach name=\'authgroup\' item=\'x\'}\\r\\n                &lt;th class=&quot;_aa&quot; data-x=\'{$x}\'&gt;{$key}&lt;\\/th&gt;\\r\\n                {\\/foreach}\\r\\n            &lt;\\/tr&gt;\\r\\n            {foreach name=\'grades\' item=\'vo\' key=&quot;k1&quot;}\\r\\n                &lt;tr&gt;\\r\\n                    &lt;th class=&quot;_bb&quot; data-x=&quot;{$k1}&quot;&gt;{$vo}&lt;\\/th&gt;\\r\\n                    {foreach name=\'authgroup\' item=\'x\'}\\r\\n                    &lt;td class=&quot;auth aa_{$x} bb_{$k1}&quot;&gt;\\r\\n                        &lt;input type=&quot;checkbox&quot; name=&quot;auth[]&quot; class=&quot;auth_{$k1}_{$x}&quot; value=&quot;{$k1}_{$x}&quot;&gt;\\r\\n                    &lt;\\/td&gt;\\r\\n                    {\\/foreach}\\r\\n                &lt;\\/tr&gt;\\r\\n            {\\/foreach}\\r\\n        &lt;\\/table&gt;\\r\\n    &lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22540', '3204', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22541', '3205', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', null, '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22542', '3205', 'SEO', '关键词', 'keywords', '', '', '3', 'keywords', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22543', '3205', 'SEO', '描述', 'description', '', '', '3', 'description', 'form_multitextbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22544', '3205', '基本信息', '内容', 'detail', 'body', '', '3', 'detail', 'form_ueditor', null, '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22545', '3205', '基本信息', 'ID', 'id', '', '', '3', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22546', '3206', '基本信息', '跟帖内容', 'content', '', '', '3', 'content', 'form_ueditor', null, '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22547', '3206', '基本信息', 'ID', 'id', '', '', '3', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22548', '3207', '基本信息', '板块ID', 'ids', '', '', '1', 'ids', 'form_multitextbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22549', '3207', '基本信息', '合并到', 'id', '', '', '0', '', 'form_database', '{\"model\":\"forum\\/forum\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22576', '3213', '基本信息', '用户', 'user', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$user = \\\\app\\\\user\\\\model\\\\User::get(input(\'user_id\'));\\r\\n{\\/php}\\r\\n&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;{$user.nickname}\\uff08ID\\uff1a{$user.id}\\uff0c\\u90ae\\u7bb1\\uff1a{$user.email}\\uff09&quot; readonly disabled&gt;\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22577', '3213', '基本信息', '消息类型', 'topic', '', '', '0', '系统消息', 'form_select', '{\"values\":\"系统消息|系统消息\\r\\n信息通知|信息通知\",\"editable\":\"1\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22578', '3213', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22579', '3213', '基本信息', '消息内容', 'content', '', '', '0', '', 'form_multitextbox', 'null', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22580', '3213', '基本信息', 'user_id', 'user_id', '', '', '1', 'user_id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22581', '3214', '基本信息', '用户等级', 'grade', '', '', '0', '1', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22582', '3214', '基本信息', '邮箱', 'email', '', '', '0', '', 'form_textbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22583', '3214', '基本信息', '昵称', 'nickname', '', '', '0', '', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22584', '3214', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22585', '3214', '基本信息', '头像', 'avatar', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/user\\/avatar\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22586', '3214', '基本信息', '座右铭', 'motto', '', '', '0', '', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22587', '3215', '基本信息', '用户等级', 'grade', '', '', '3', 'grade', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$my_grades = \\\\ebcms\\\\Config::get(\'user.base.grade\');\\r\\n{\\/php}\\r\\n&lt;select class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot;&gt;\\r\\n\\t{foreach name=\'my_grades\' item=\'_temp\'}\\r\\n\\t&lt;option value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}selected{\\/eq}&gt;{$_temp}&lt;\\/option&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/select&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22588', '3215', '基本信息', '邮箱', 'email', '', '', '3', 'email', 'form_textbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22589', '3215', '基本信息', '昵称', 'nickname', '', '', '3', 'nickname', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22590', '3215', '基本信息', '头像', 'avatar', '', '', '3', 'avatar', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/user\\/avatar\",\"prompt\":\"\"}', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22591', '3215', '基本信息', '座右铭', 'motto', '', '', '3', 'motto', 'form_multitextbox', 'null', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22592', '3215', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22593', '3216', '基本信息', '用户', 'user', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$user = \\\\app\\\\user\\\\model\\\\User::get(input(\'user_id\'));\\r\\n{\\/php}\\r\\n&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;{$user.nickname}\\uff08ID\\uff1a{$user.id}\\uff0c\\u90ae\\u7bb1\\uff1a{$user.email}\\uff09&quot; readonly disabled&gt;\"}', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22594', '3216', '基本信息', '类型', 'type', '', '', '0', 'inc', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"充值|inc\\r\\n扣费|dec\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22595', '3216', '基本信息', '币种', 'currency', '', '', '0', 'jifen', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$_currency = \\\\ebcms\\\\Config::get(\'user.base.currency\');\\r\\n{\\/php}\\r\\n{foreach name=\'_currency\' item=\'_temp\' key=\'curr\'}\\r\\n\\t&lt;label class=&quot;radio-inline&quot; for=&quot;{$field.unique}_{$curr}&quot;&gt;\\r\\n\\t\\t&lt;input type=&quot;radio&quot; name=&quot;{$field.field}&quot; id=&quot;{$field.unique}_{$curr}&quot; value=&quot;{$curr}&quot; {eq name=&quot;field.value&quot; value=\'$curr\'}checked{\\/eq}&gt; {$_temp}\\r\\n\\t&lt;\\/label&gt;\\r\\n{\\/foreach}\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22596', '3216', '基本信息', '数额', 'num', '', '', '0', '0', 'form_numberbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22597', '3216', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22598', '3216', '基本信息', '通知消息', 'msg', '', '', '0', '', 'form_multitextbox', 'null', '通知用户的消息，不填写则为系统默认消息', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22599', '3216', '基本信息', '用户id', 'user_id', '', '', '1', 'user_id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22600', '3217', '基本信息', '内容', 'content', '', '', '3', 'content', 'form_multitextbox', null, '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22601', '3217', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '0');

-- ----------------------------
-- Table structure for ebcms5_forum
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum`;
CREATE TABLE `ebcms5_forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'meta标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `eb_ext` text COMMENT '扩展信息',
  `config` text COMMENT '配置',
  `auth` text COMMENT '权限',
  `open` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '开启论坛',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='论坛表';

-- ----------------------------
-- Records of ebcms5_forum
-- ----------------------------
INSERT INTO `ebcms5_forum` VALUES ('1', '默认分组', '手机论坛', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '{\"tpl_list\":\"\",\"tpl_thread\":\"\"}', '1_0,1_10,1_11,1_40,1_41,2_0,2_10,2_11,2_40,2_41,3_0,3_10,3_11,3_40,3_41,4_0,4_10,4_11,4_40,4_41,0_0,0_10,0_11,0_40,0_41', '1', '0', '0', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_forum_moderator
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_moderator`;
CREATE TABLE `ebcms5_forum_moderator` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '论坛id',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '评论人id',
  `auth` varchar(255) NOT NULL DEFAULT '' COMMENT '权限',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='版主权限表';

-- ----------------------------
-- Records of ebcms5_forum_moderator
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_forum_rethread
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_rethread`;
CREATE TABLE `ebcms5_forum_rethread` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thread_id` int(10) unsigned NOT NULL COMMENT 'FORUM_ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回帖用户ID',
  `content` text,
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  PRIMARY KEY (`id`),
  KEY `forum_id` (`thread_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ebcms5_forum_rethread
-- ----------------------------
INSERT INTO `ebcms5_forum_rethread` VALUES ('1', '1', '1', '&lt;p&gt;第一帖子。。第一帖子。。&lt;br&gt;\r\n第一帖子。。&lt;br&gt;\r\n第一帖子。。第一帖子。。&lt;br&gt;\r\n第一帖子。。&lt;/p&gt;', '221.237.30.199', '1499659918', '1499659918', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('2', '2', '4', '&lt;div style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;http://demo.ebcms.com/upload/forum/20170711/feb8b79bd9a220a4c533b171cba10f44.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt;', '60.206.40.86', '1499732131', '1499732131', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('3', '2', '1', '\n&lt;div style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;http://demo.ebcms.com/upload/forum/20170711/16f603bfb703a53aa07c2acdc280f11a.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt;\n&lt;div style=&quot;text-align: center;&quot;&gt;11&lt;/div&gt;\n', '221.237.30.199', '1499747472', '1499738899', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('4', '2', '1', '\n&lt;p&gt;asdfasdfasf&lt;/p&gt;\n&lt;p&gt;asdfasdf&lt;/p&gt;\n&lt;p&gt;asfdasdfasdf&lt;/p&gt;\n', '221.237.30.199', '1499747510', '1499747484', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('5', '1', '0', '&lt;p&gt;第三方的撒飒飒的飞洒发达的十分发达&lt;/p&gt;', '180.166.45.146', '1499912915', '1499912915', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('6', '5', '0', '&lt;p&gt;11&quot;&amp;gt;&lt;/p&gt;', '111.194.202.244', '1501522401', '1501522401', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('7', '1', '0', '&lt;p&gt;测试&lt;/p&gt;', '113.138.23.184', '1501899880', '1501899880', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('8', '5', '0', '&lt;p&gt;dfdswwwqweqw&lt;/p&gt;', '119.253.40.170', '1502343218', '1502343218', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('9', '5', '0', '&lt;p&gt;随后为一举突击&lt;/p&gt;', '125.41.81.178', '1502844922', '1502844922', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('10', '5', '0', '&lt;p&gt;asf&lt;/p&gt;', '106.122.207.236', '1502869061', '1502869061', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('11', '1', '0', '\n&lt;p&gt;就好像什么都没有发生一张的&lt;img alt=&quot;抓狂&quot; src=&quot;/third/xheditor/xheditor_emot/default/crazy.gif&quot;&gt;&lt;/p&gt;\n&lt;h2&gt;哈哈哈&lt;/h2&gt;\n&lt;div&gt;感觉哈哈还&lt;/div&gt;\n&lt;div&gt;&lt;br&gt;&lt;/div&gt;\n', '125.71.214.190', '1502943585', '1502943585', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('12', '6', '0', '&lt;p&gt;额额温热万人玩儿玩儿玩儿维吾尔&lt;/p&gt;', '219.141.47.49', '1502984629', '1502984629', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('13', '3', '0', '&lt;p&gt;“》&quot;&amp;gt;&lt;/p&gt;', '221.216.134.235', '1504092951', '1504092951', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('15', '10', '24', '&lt;p&gt;adfadfadfasf&lt;/p&gt;', '58.16.0.24', '1505034719', '1505034719', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('16', '4', '28', '&lt;p&gt;123132123123132123123123&lt;/p&gt;', '111.227.21.232', '1505883175', '1505883175', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('17', '1', '0', '&lt;p&gt;阿什顿发达&lt;/p&gt;', '27.18.181.160', '1508232471', '1508232471', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('18', '1', '0', '&lt;p&gt;sadfadfasdfasasdfasd&lt;/p&gt;', '27.18.181.160', '1508232493', '1508232493', '1', '0');
INSERT INTO `ebcms5_forum_rethread` VALUES ('19', '11', '0', '&lt;p&gt;123123&lt;/p&gt;', '122.70.1.246', '1511336706', '1511336706', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_forum_thread
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_thread`;
CREATE TABLE `ebcms5_forum_thread` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '内容ID',
  `forum_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '标题',
  `keywords` char(70) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` char(250) NOT NULL DEFAULT '' COMMENT '内容描述',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP',
  `views` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览数',
  `rethreads` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '跟帖数',
  `eb_cache` text COMMENT '缓存',
  `rethread_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最新跟帖时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '修改时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '精华等级',
  `best` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '精华等级',
  `top` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '置顶',
  PRIMARY KEY (`id`),
  KEY `user` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ebcms5_forum_thread
-- ----------------------------
INSERT INTO `ebcms5_forum_thread` VALUES ('1', '1', '1', '第一帖子。。', '', '第一帖子。。第一帖子。。第一帖子。。', '221.237.30.199', '95', '6', '{\"rethreads_time\":1512723080}', '1508232493', '1508232493', '1499659904', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('2', '1', '4', '世界上最美丽的地方—悉尼蓝山', '', '非常不错啊，继续支持你们', '60.206.40.88', '147', '3', '{\"rethreads_time\":1512723080}', '1499747484', '1499747484', '1499732075', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('3', '1', '2', '测试EEEEEEEEE', '', '16516516515', '171.81.159.148', '69', '1', '{\"rethreads_time\":1512723080}', '1504092951', '1504092951', '1500902015', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('4', '1', '0', '999777', '', '123', '113.140.24.4', '59', '1', '{\"rethreads_time\":1512723080}', '1505883175', '1505883175', '1500972714', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('5', '1', '6', ' 电视剧《我的前半生》昨晚在东方卫视播出大结局', '', '测试一下范冰冰开三轮车在最新一期的《挑战者联盟》中，范冰冰不改王牌ACE本色，全程开挂。不仅能够用超强的领导能力，分分钟将两名得力干将张杰和谢依霖收入麾下；还能大展最美女司机车技，将电动三轮车开出帅酷哈雷范。如此霸气，自然是分分钟让韩庚和欧弟两位竞争者不敢小觑。在默契大考验环节，面对体力和身高都占据绝对优势的韩庚和欧弟，范冰冰淡定上演连环计。一上场，她就采取了正面攻击策略，瞬间打爆欧弟身上的气球，', '60.206.40.88', '273', '4', '{\"rethreads_time\":1512723080}', '1502869061', '1502869061', '1501466959', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('6', '1', '0', '2342342', '', '23432432423423423423423', '219.141.47.49', '41', '1', '{\"rethreads_time\":1512723080}', '1502984629', '1502984629', '1502984603', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('7', '1', '0', 'scscwdwdw', '', 'scsc', '58.63.0.233', '69', '0', '{\"rethreads_time\":1512723080}', '1504098512', '1504098512', '1503457980', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('8', '1', '0', '41111111111', '', '111111111111111', '119.144.124.16', '57', '0', '{\"rethreads_time\":1512723080}', '0', '1503623272', '1503623272', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('9', '1', '8', '&lt;DIV STYLE=&quot;width: expression(alert(\'XSS\'));&quot;&gt;', '', '', '221.216.134.235', '87', '0', '{\"rethreads_time\":1512723080}', '0', '1504098566', '1504098566', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('10', '1', '0', 'wesddfdfdf', '', 'we', '60.191.33.170', '101', '1', '{\"rethreads_time\":1512723080}', '1505034719', '1505034719', '1504852194', '1', '0', '0', '0');
INSERT INTO `ebcms5_forum_thread` VALUES ('11', '1', '0', '111111111111231231234564561', '', '233132', '111.227.21.232', '117', '1', '{\"rethreads_time\":1512723080}', '1511336706', '1511336706', '1505883639', '1', '0', '0', '0');

-- ----------------------------
-- Table structure for ebcms5_forum_thread_body
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forum_thread_body`;
CREATE TABLE `ebcms5_forum_thread_body` (
  `id` int(11) unsigned NOT NULL,
  `detail` text NOT NULL COMMENT '帖子内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ebcms5_forum_thread_body
-- ----------------------------
INSERT INTO `ebcms5_forum_thread_body` VALUES ('1', '&lt;p&gt;第一帖子。。第一帖子。。&lt;br&gt;\r\n第一帖子。。&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('2', '&lt;p&gt;非常不错啊，继续支持你们&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('3', '&lt;p&gt;16516516515&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('4', '&lt;p&gt;123&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('5', '\n&lt;p&gt;测试一下&lt;/p&gt;\n&lt;p&gt;&lt;/p&gt;\n&lt;p class=&quot;detailPic&quot; style=&quot;margin-right: auto; margin-left: auto; padding: 0px; text-indent: 28px; text-align: center; word-wrap: break-word; word-break: normal; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif;&quot;&gt;&lt;img src=&quot;http://p3.ifengimg.com/a/2017_31/585852246ff6d7e_size104_w600_h900.jpg&quot; id=&quot;ext-gen1039&quot; width=&quot;333&quot; height=&quot;500&quot; alt=&quot;&quot;&gt;&lt;/p&gt;\n&lt;p class=&quot;picIntro&quot; style=&quot;margin-bottom: 25px; padding: 0px; text-align: center; word-wrap: break-word; word-break: normal; font-family: 楷体_gb2312, 楷体; color: rgb(43, 43, 43);&quot;&gt;范冰冰开三轮车&lt;/p&gt;\n&lt;p style=&quot;margin-bottom: 25px; padding: 0px; text-indent: 28px; text-align: justify; word-wrap: break-word; word-break: normal; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif;&quot;&gt;在最新一期的《挑战者联盟》中，范冰冰不改王牌ACE本色，全程开挂。不仅能够用超强的领导能力，分分钟将两名得力干将张杰和谢依霖收入麾下；还能大展最美女司机车技，将电动三轮车开出帅酷哈雷范。如此霸气，自然是分分钟让韩庚和欧弟两位竞争者不敢小觑。&lt;/p&gt;\n&lt;p style=&quot;margin-bottom: 25px; padding: 0px; text-indent: 28px; text-align: justify; word-wrap: break-word; word-break: normal; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif;&quot;&gt;在默契大考验环节，面对体力和身高都占据绝对优势的韩庚和欧弟，范冰冰淡定上演连环计。一上场，她就采取了正面攻击策略，瞬间打爆欧弟身上的气球，随后为一举突击、占据绝对优势，甚至还上演了“空城计”，欲攻其不备。&lt;span class=&quot;ifengLogo&quot;&gt;&lt;a href=&quot;http://www.ifeng.com/&quot; target=&quot;_blank&quot; style=&quot;color: rgb(0, 66, 118); font-weight: bold;&quot;&gt;&lt;img src=&quot;http://p2.ifengimg.com/a/2016/0810/204c433878d5cf9size1_w16_h16.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;\n&lt;br&gt;\n');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('6', '&lt;p&gt;23432432423423423423423&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('7', '&lt;p&gt;scsc&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('8', '&lt;p&gt;111111111111111&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('9', '&lt;p&gt;&amp;lt;DIV STYLE=&quot;width: expression(alert(\'XSS\'));&quot;&amp;gt;&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('10', '&lt;p&gt;we&lt;/p&gt;');
INSERT INTO `ebcms5_forum_thread_body` VALUES ('11', '&lt;p&gt;233&lt;br&gt;\r\n132&lt;/p&gt;');

-- ----------------------------
-- Table structure for ebcms5_link_link
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_link_link`;
CREATE TABLE `ebcms5_link_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `info` varchar(255) NOT NULL DEFAULT '' COMMENT '其他信息',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '连接地址',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- ----------------------------
-- Records of ebcms5_link_link
-- ----------------------------
INSERT INTO `ebcms5_link_link` VALUES ('1', '友情链接', '易贝网站管理系统', '', '', '', 'http://www.ebcms.com/', '1479188905', '1479188905', '0', '1');
INSERT INTO `ebcms5_link_link` VALUES ('2', '友情链接', '开源CMS', '', '', '', 'http://www.ebcms.com/', '1479189038', '1479188937', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_manager
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_manager`;
CREATE TABLE `ebcms5_manager` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '后台人员ID',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT 'QQ号码',
  `nickname` char(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `login_times` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `login_ip` char(15) NOT NULL DEFAULT '' COMMENT '登陆ip地址',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登陆时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of ebcms5_manager
-- ----------------------------
INSERT INTO `ebcms5_manager` VALUES ('1', 'kujiw@qq.com', '管理员', '', '559461b6b41e9e4010dfb8f069cf0e2c', '1122', '182.150.164.222', '1512800940', '0', '0', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_mbzs
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_mbzs`;
CREATE TABLE `ebcms5_mbzs` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `form` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `remark` text COMMENT '说明',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='核心配置表';

-- ----------------------------
-- Records of ebcms5_mbzs
-- ----------------------------
INSERT INTO `ebcms5_mbzs` VALUES ('1', '广告', '头部banner', 'header_banner', 'http://static.ebcms.com/img/ad1.gif', 'upload', '首页头部广告', '1479041750', '1479037002', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('2', '广告', '首页栏目上方', 'index_panel_ad', 'http://static.ebcms.com/img/ad2.gif', 'upload', '首页栏目面板上方刚搞', '1479041759', '1479037071', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('3', '广告', '侧栏广告', 'side_ad', 'http://static.ebcms.com/img/ad3.gif', 'upload', '', '1479041767', '1479037097', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('5', '广告', '论坛帖子', 'index_forum', '{if condition=&quot;check_app(\'forum\')&quot;}\r\n&lt;style&gt;\r\n	.text-overflow{\r\n		display:block;\r\n		white-space:nowrap;\r\n		overflow:hidden;\r\n		text-overflow:ellipsis;\r\n	}\r\n&lt;/style&gt;\r\n{php}\r\n	$lists = \\app\\forum\\model\\Thread::with(\'forum,user\') -&gt; where([\'status\'=&gt;1,\'forum_id\'=&gt;[\'in\',\'1,2\']]) -&gt; order(\'id desc,rethread_time desc\') -&gt; limit(15) -&gt; select();\r\n{/php}\r\n&lt;table class=&quot;table table-bordered table-hover&quot; style=&quot;table-layout: fixed;&quot;&gt;\r\n	&lt;tr&gt;\r\n		&lt;th style=&quot;width: 130px;&quot;&gt;作者&lt;/th&gt;\r\n		&lt;th&gt;标题&lt;/th&gt;\r\n		&lt;th style=&quot;width: 140px;&quot; class=&quot;hidden-xs&quot;&gt;发帖时间&lt;/th&gt;\r\n		&lt;th style=&quot;width: 50px;&quot; class=&quot;hidden-xs&quot;&gt;阅读&lt;/th&gt;\r\n		&lt;th style=&quot;width: 50px;&quot; class=&quot;hidden-xs&quot;&gt;跟帖&lt;/th&gt;\r\n		&lt;th style=&quot;width: 140px;&quot; class=&quot;hidden-xs&quot;&gt;最后回帖&lt;/th&gt;\r\n	&lt;/tr&gt;\r\n	{foreach name=\'lists\' item=\'vo\'}\r\n	&lt;tr&gt;\r\n		&lt;td&gt;{notempty name=\'vo.user.nickname\'}&lt;a href=&quot;{$vo.user.space_url}&quot; class=&quot;text-overflow&quot;&gt;&lt;img src=&quot;{$vo.user.avatar|thumb=14,14,3}&quot; width=&quot;14&quot; height=&quot;14&quot; alt=&quot;&quot;&gt; {$vo.user.nickname}&lt;/a&gt;{else}&lt;img src=&quot;/system/image/avatar.gif&quot; width=&quot;14&quot; height=&quot;14&quot; alt=&quot;&quot;&gt; 游客{/notempty}&lt;/td&gt;\r\n		&lt;td&gt;&lt;a href=&quot;{$vo.forum.url}&quot; class=&quot;text-muted&quot;&gt;[{$vo.forum.title}]&lt;/a&gt;&amp;nbsp;&lt;a href=&quot;{$vo.url}&quot; style=&quot;{$vo.style}&quot;&gt;{$vo.title}&lt;/a&gt;&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.create_time|date=\'Y-m-d H:i\',###}&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.views}&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.rethreads2}&lt;/td&gt;\r\n		&lt;td class=&quot;hidden-xs&quot;&gt;{$vo.rethread_time|date=\'Y-m-d H:i\',###}&lt;/td&gt;\r\n	&lt;/tr&gt;\r\n	{/foreach}\r\n&lt;/table&gt;\r\n{/if}', 'tpl', '', '1502975931', '1501410271', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('6', '广告', '侧边广告', 'slide_ad', '&lt;p&gt;\r\n&lt;script type=&quot;text/javascript&quot; src=&quot;http://a.ebcms.com/mhzniieiekon.js&quot;&gt;&lt;/script&gt;\r\n&lt;/p&gt;', 'tpl', '', '1509623232', '1502974497', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('7', '广告', '内容页广告', 'content_ad', '&lt;p&gt;\r\n&lt;script type=&quot;text/javascript&quot; src=&quot;http://a.ebcms.com/mhzniieiekon.js&quot;&gt;&lt;/script&gt;\r\n&lt;/p&gt;', 'tpl', '', '1504179130', '1502976505', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('8', '广告', '调用指定栏目的文章', 'content_lists', '{php}\r\n    $data = \\app\\content\\model\\Content::where([\'channel_id\'=&gt;\'7\',\'status\'=&gt;1]) -&gt; limit(\'5\') -&gt; order(\'id desc\') -&gt; select();\r\n{/php}\r\n{foreach name=\'data\' item=\'vo\'}\r\n    文章标题：{$vo.title}\r\n{/foreach}', 'tpl', '', '1509623138', '1509623124', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_menu
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_menu`;
CREATE TABLE `ebcms5_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `url` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1675 DEFAULT CHARSET=utf8 COMMENT='导航表';

-- ----------------------------
-- Records of ebcms5_menu
-- ----------------------------
INSERT INTO `ebcms5_menu` VALUES ('3', '10', '账户管理', 'ebcms/manager/index', '53', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('4', '10', '角色管理', 'ebcms/group/index', '54', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('8', '10', '操作日志', 'ebcms/oplog/index', '52', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('10', '0', '系统', '', '2000', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('11', '10', '设置中心', 'ebcms/config/index', '83', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('22', '936', '应用商店', 'ebcms/store/index', '98', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('560', '10', '__DIVIDER__', '', '60', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('935', '10', '模型扩展', 'ebcms/extend/index', '81', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('936', '0', '模块', '', '3000', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1030', '936', '__DIVIDER__', '', '50', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1315', '10', '清理缓存', 'javascript:M.runtime();', '1', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1330', '10', '前台导航', 'ebcms/nav/index', '80', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1652', '0', '内容', '', '5000', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1653', '1652', '内容管理', 'content/admin.content/index', '9', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1654', '1652', '栏目管理', 'content/admin.channel/index', '8', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1655', '1652', '标签管理', 'content/admin.tag/index', '7', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1656', '1652', '属性管理', 'content/admin.attr/index', '0', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1657', '936', '内容管理', 'content/admin.content/index', '3', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1658', '936', '模板助手', 'mbzs/mbzs/index', '4', 'mbzs');
INSERT INTO `ebcms5_menu` VALUES ('1659', '936', '友情链接', 'link/admin.link/index', '3', 'link');
INSERT INTO `ebcms5_menu` VALUES ('1665', '936', '论坛管理', 'forum/admin.forum/index', '7', 'forum');
INSERT INTO `ebcms5_menu` VALUES ('1666', '936', '访客统计', 'tongji/tongji/index', '0', 'tongji');
INSERT INTO `ebcms5_menu` VALUES ('1671', '0', '会员', '', '7000', 'user');
INSERT INTO `ebcms5_menu` VALUES ('1672', '1671', '会员管理', 'user/admin.user/index', '1', 'user');
INSERT INTO `ebcms5_menu` VALUES ('1673', '1671', '流水管理', 'user/admin.currencylog/index', '0', 'user');
INSERT INTO `ebcms5_menu` VALUES ('1674', '1671', '评论管理', 'user/admin.comment/index', '0', 'user');

-- ----------------------------
-- Table structure for ebcms5_nav
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_nav`;
CREATE TABLE `ebcms5_nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_url` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `target` varchar(20) NOT NULL DEFAULT '' COMMENT '目标窗口',
  `eb_ext` text COMMENT '扩展',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COMMENT='功能菜单表';

-- ----------------------------
-- Records of ebcms5_nav
-- ----------------------------
INSERT INTO `ebcms5_nav` VALUES ('3', '主导航', '0', '官方论坛', 'https://www.ebcms.com/forum.html', '_blank', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '0', '');
INSERT INTO `ebcms5_nav` VALUES ('17', '用户中心', '0', '论坛', '', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('18', '用户中心', '17', '我的帖子', 'forum/user/thread', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '3', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('19', '用户中心', '17', '我的跟帖', 'forum/user/rethread', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '2', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('20', '个人空间', '0', '论坛', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('21', '个人空间', '20', '他的帖子', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('22', '主导航', '0', '论坛', 'forum/index/index', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1', '1', 'forum');
INSERT INTO `ebcms5_nav` VALUES ('27', '用户中心', '0', '个人账户', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '50', '1', 'user');
INSERT INTO `ebcms5_nav` VALUES ('28', '用户中心', '27', '账户概况', 'user/currency/index', '', '{\"__config__\":{\"__test__\":\"test\"}}', '9', '1', 'user');
INSERT INTO `ebcms5_nav` VALUES ('29', '用户中心', '27', '账户流水', 'user/currency/log', '', '{\"__config__\":{\"__test__\":\"test\"}}', '8', '1', 'user');
INSERT INTO `ebcms5_nav` VALUES ('30', '用户中心', '27', '自助升级', 'user/gradebuy/index', '_self', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1', 'user');

-- ----------------------------
-- Table structure for ebcms5_oplog
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_oplog`;
CREATE TABLE `ebcms5_oplog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '说明',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '动作',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  `ids` text COMMENT '提交的id',
  `request` text COMMENT '详细',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '执行状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_oplog
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_superpay
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_superpay`;
CREATE TABLE `ebcms5_superpay` (
  `sign` varchar(50) NOT NULL DEFAULT '' COMMENT '标志',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `expire_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '过期时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='购买记录表';

-- ----------------------------
-- Records of ebcms5_superpay
-- ----------------------------
INSERT INTO `ebcms5_superpay` VALUES ('content_82', '5', '1502934407');
INSERT INTO `ebcms5_superpay` VALUES ('content_82', '6', '1501467081');
INSERT INTO `ebcms5_superpay` VALUES ('content_82', '4', '1501663227');
INSERT INTO `ebcms5_superpay` VALUES ('content_82', '10', '1501743635');
INSERT INTO `ebcms5_superpay` VALUES ('content_79', '10', '0');
INSERT INTO `ebcms5_superpay` VALUES ('content_79', '5', '0');
INSERT INTO `ebcms5_superpay` VALUES ('content_82', '15', '1503638251');
INSERT INTO `ebcms5_superpay` VALUES ('content_82', '20', '1504251934');
INSERT INTO `ebcms5_superpay` VALUES ('content_82', '25', '1505443767');

-- ----------------------------
-- Table structure for ebcms5_tongji_tongji
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_tongji_tongji`;
CREATE TABLE `ebcms5_tongji_tongji` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '网页标题',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `from` varchar(255) NOT NULL DEFAULT '' COMMENT '来源地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_tongji_tongji
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_user
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user`;
CREATE TABLE `ebcms5_user` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '邮箱',
  `nickname` char(20) NOT NULL DEFAULT '' COMMENT '昵称',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `motto` varchar(255) NOT NULL DEFAULT '' COMMENT '座右铭',
  `grade` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员等级',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `login_times` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `login_ip` char(15) NOT NULL DEFAULT '' COMMENT '登陆ip地址',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登陆时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `ext` text COMMENT '扩展信息',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of ebcms5_user
-- ----------------------------
INSERT INTO `ebcms5_user` VALUES ('1', 'yuefeihuo@qq.com', 'tianyu123', '', '', '1', 'eeb98b380d15cca556f8025843876aa5', '1', '', '0', '1500696358', '1500696358', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('2', '460761515@qq.com', 'suobing', '/avatar/20170724/1221c06019c7b60fad96b51db34adee2.jpg', '测试签名的', '1', '40d7afd70ceda6e6ef9e98ea328c66d2', '1', '', '0', '1500901944', '1500901944', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('3', '2811832487@qq.com', 'test', '', '', '1', '86721f8238173eb4729816354dc5c200', '2', '180.191.103.224', '1512473983', '1512473983', '1501049136', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('4', '2950918980@qq.com', 'getcww', '', '', '1', 'd83964fafd3f5f94d5c316c69c1f9332', '4', '121.32.127.153', '1509004606', '1509004606', '1501147187', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('5', 'kujiw@qq.com', '123', '', '', '1', '559461b6b41e9e4010dfb8f069cf0e2c', '14', '113.105.12.153', '1509362175', '1509362175', '1501422438', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('6', 'hqz8812@126.com', '暂时无名', '/avatar/20170731/78f4fad2d54412ea7233d7c4f597fe98.jpg', '我就是我，不要问。', '1', 'a3e51ab8da2423ce8e061ed4a8db55aa', '4', '60.206.40.86', '1502763620', '1502763620', '1501466848', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('7', '867517345@qq.com', 'jjzk', '', '', '1', '019b9d28f7f386b080fa601364822144', '1', '', '0', '1501475895', '1501475895', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('8', '87215712@qq.com', 'wind', '/avatar/20170830/db74b67f5c9e49aa9b3928e123d627f9.png', '', '1', '7673ddd5d5743b53b2f8937997fe51b6', '2', '221.216.134.235', '1504098355', '1504098355', '1501522461', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('9', '1120032500@qq.com', 'bairuoqing', '', '', '1', '20fd8c0bc92567c910e6c09efef94421', '1', '', '0', '1501724591', '1501724591', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('10', '1982339647@qq.com', '星刻之痕', '', '', '1', 'b441106ae4fcf1dd8c3a8efa9604441d', '1', '', '0', '1501743554', '1501743554', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('11', '113743677@qq.com', 'xiaoxiao2', '', '', '1', '5784be51171e519debf5c3365d8b3911', '1', '', '0', '1501843936', '1501843936', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('12', '954952689@qq.com', '小莫', '', '', '1', 'd132393676e16712ab7abe4d1cc0eaec', '1', '', '0', '1502290202', '1502290202', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('13', '2214362719@qq.com', 'w_ting', '', '', '1', 'ce832102a5c07b12f54815ef5ab9d259', '1', '', '0', '1502382736', '1502382736', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('14', '286438690@qq.com', '毛啊摸3', '', '', '1', 'a923ff2079f5338e052ee729a662f621', '1', '', '0', '1502709795', '1502709795', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('15', '468888911@qq.com', 'weiwei90', '', '', '1', 'c6dc3309e386c6f1127e530b1e3256e1', '2', '27.222.139.205', '1503638127', '1503638127', '1503540246', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('16', 'faith4444@163.com', 'noob', '', '', '1', '3854c4f4a90a1e7b1be9e96cae5a461f', '3', '223.93.188.66', '1504230339', '1504230339', '1504061817', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('17', '651162013@qq.com', 'balisong', '', '', '1', 'a416f2e50062f6933fc232209075ccf2', '2', '222.209.84.125', '1504080224', '1504080224', '1504079726', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('18', '651543204@qq.com', 'balisong1', '', '', '1', '4b81ab12667050830e07c37252871066', '1', '', '0', '1504080016', '1504080016', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('19', '704646600@qq.com', 'noob_noob', '', '', '1', '60f66f242abfbaff27d740412b1eda55', '1', '', '0', '1504230556', '1504230556', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('20', '274593714@qq.com', '明月', '', '', '1', '77ef0d9bf64d14902f68daac8bd039be', '1', '', '0', '1504251824', '1504251824', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('21', '78388335@qq.com', '78388335', '', '', '1', '1c28e39604accba8aed2833156d80d7f', '1', '', '0', '1504355969', '1504355969', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('22', 'xutao@eversec.cn', 'shilezhi', '', '', '1', '5633f12e49a79aad1b4c897065b61473', '1', '', '0', '1504510000', '1504510000', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('23', '1460451166@qq.com', 'shilezhi2', '', '', '1', '1cd5ce36b36cdcccfdfe8552794b38f4', '2', '121.60.25.31', '1504510193', '1504510193', '1504510039', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('24', '1258484192@qq.com', 'maxbug', '', '', '1', 'bcc2947947013546787adee448607a6e', '1', '', '0', '1505034252', '1505034252', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('25', '247898709@qq.com', 'ncnic', '', '', '1', '8fdd63bc06c7c78de39e3e3ee7978678', '1', '', '0', '1505443698', '1505443698', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('26', '63660932@qq.com', 'lxj168', '', '', '1', '8095cdb48faaebb039e6dc31d4d63af0', '1', '', '0', '1505629321', '1505629321', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('27', '99239218@qq.com', 'zwf9918', '', '', '1', '3b5b5f6e7a7e6f63f3b81946a390fd5d', '1', '', '0', '1505641598', '1505641598', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('28', '906842182@qq.com', '9068428212', '', '', '1', '6be0283f1d8611ed5ce0d87ae2a048ef', '1', '', '0', '1505883117', '1505883117', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('29', '410048135@qq.com', 'qsj123', '', '', '1', '51765d17fd207d9279785dd0dc46e33d', '1', '', '0', '1507609477', '1507609477', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('30', '3218013423@qq.com', '考试宝典', '', '', '1', 'adb83fb5cc05871ed64c959e0e1025cd', '1', '', '0', '1508463439', '1508463439', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('31', '190676721@qq.com', '考试宝典111', '', '', '1', '07ac2424b984a8dfe0ad4dc8e65d6647', '1', '', '0', '1508465464', '1508465464', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('32', '853899319@qq.com', '虎头虎猫', '', '', '1', 'f00ee2e45d110862005334dfb26b299f', '1', '', '0', '1509636389', '1509636389', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('33', '2676586@qq.com', 'luojunjin', '', '', '1', 'fafbfc61bee6d0854df887378f3eacfa', '1', '', '0', '1510152460', '1510152460', '0', '1', null);
INSERT INTO `ebcms5_user` VALUES ('34', '337972603@qq.com', 'yang123', '', '', '1', '0c205c71a3b05255d6021e338d9afd0e', '1', '', '0', '1510301336', '1510301336', '0', '1', null);

-- ----------------------------
-- Table structure for ebcms5_user_comment
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_comment`;
CREATE TABLE `ebcms5_user_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `key` varchar(255) NOT NULL DEFAULT '' COMMENT '标识',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '评论人id',
  `to_user_id` int(10) unsigned DEFAULT '0' COMMENT '回复对象id',
  `top_id` int(10) unsigned DEFAULT '0' COMMENT '顶级评论id',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父评论id',
  `content` text NOT NULL COMMENT '评论内容',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='内容评论表';

-- ----------------------------
-- Records of ebcms5_user_comment
-- ----------------------------
INSERT INTO `ebcms5_user_comment` VALUES ('1', 'content', 'content_4', '0', '0', '0', '0', '此次渔民自主发起的宣示活动', '1502289555', '1502289555', '1', '0', '118.113.44.74');
INSERT INTO `ebcms5_user_comment` VALUES ('2', 'content', 'content_4', '0', '0', '0', '0', '阿斯顿发顺丰你妈。。。', '1502289565', '1502289565', '99', '0', '118.113.44.74');
INSERT INTO `ebcms5_user_comment` VALUES ('3', 'content', 'content_61', '0', '0', '0', '0', '66666TEST\r\n', '1502947944', '1502947944', '1', '0', '210.64.188.215');
INSERT INTO `ebcms5_user_comment` VALUES ('4', 'content', 'content_26', '0', '0', '0', '0', 'kkkkkk', '1504372290', '1504372290', '1', '0', '222.128.150.252');
INSERT INTO `ebcms5_user_comment` VALUES ('5', 'content', 'content_53', '0', '0', '0', '0', '0--0-0', '1505512872', '1505512872', '1', '0', '112.103.155.58');
INSERT INTO `ebcms5_user_comment` VALUES ('6', 'content', 'content_7', '0', '0', '0', '0', '，，，，，，，，，，', '1508509637', '1508509637', '1', '0', '121.234.16.153');
INSERT INTO `ebcms5_user_comment` VALUES ('7', 'content', 'content_6', '0', '0', '0', '0', 'aaaaaaaaaaaaa', '1508834388', '1508834388', '1', '0', '111.222.25.42');
INSERT INTO `ebcms5_user_comment` VALUES ('8', 'content', 'content_61', '0', '0', '3', '3', '东湖街道色胆如天更是让他让他也', '1510217201', '1510217201', '1', '0', '115.228.181.6');
INSERT INTO `ebcms5_user_comment` VALUES ('9', 'content', 'content_61', '0', '0', '3', '8', '00000', '1511026034', '1511026034', '1', '0', '120.82.19.58');
INSERT INTO `ebcms5_user_comment` VALUES ('10', 'content', 'content_60', '0', '0', '0', '0', '哈哈哈哈哈哈哈哈', '1511832751', '1511832751', '1', '0', '42.236.202.88');

-- ----------------------------
-- Table structure for ebcms5_user_currency
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_currency`;
CREATE TABLE `ebcms5_user_currency` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '后台人员ID',
  `jifen` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '积分',
  `jinbi` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '金币',
  `yuan` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '元',
  `bi1` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种1',
  `bi2` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种2',
  `bi3` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种3',
  `bi4` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种4',
  `bi5` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种5',
  `bi6` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '币种6',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COMMENT='用户财富表';

-- ----------------------------
-- Records of ebcms5_user_currency
-- ----------------------------
INSERT INTO `ebcms5_user_currency` VALUES ('1', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('2', '20', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('3', '11', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('4', '12', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('5', '1104', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('6', '22', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('7', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('8', '22', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('9', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('10', '8', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('11', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('12', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('13', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('14', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('15', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('16', '12', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('17', '11', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('18', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('19', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('20', '9', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('21', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('22', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('23', '11', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('24', '11', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('25', '9', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('26', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('27', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('28', '11', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('29', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('30', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('31', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('32', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('33', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');
INSERT INTO `ebcms5_user_currency` VALUES ('34', '10', '0', '0.00', '0', '0', '0', '0', '0', '0');

-- ----------------------------
-- Table structure for ebcms5_user_currency_log
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_currency_log`;
CREATE TABLE `ebcms5_user_currency_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `num` int(11) NOT NULL DEFAULT '0' COMMENT '数量',
  `currency` varchar(255) NOT NULL DEFAULT '' COMMENT '货币类型',
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作人id',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 COMMENT='财富日志表';

-- ----------------------------
-- Records of ebcms5_user_currency_log
-- ----------------------------
INSERT INTO `ebcms5_user_currency_log` VALUES ('1', '1', '10', 'jifen', '0', '223.87.246.61', '注册奖励', '1500696358', '1500696358', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('2', '2', '10', 'jifen', '0', '171.81.159.148', '注册奖励', '1500901944', '1500901944', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('3', '2', '10', 'jifen', '0', '171.81.159.148', '发帖奖励', '1500902015', '1500902015', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('4', '3', '10', 'jifen', '0', '112.28.170.37', '注册奖励', '1501049136', '1501049136', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('5', '4', '10', 'jifen', '0', '121.32.12.170', '注册奖励', '1501147187', '1501147187', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('6', '5', '1', 'jifen', '0', '118.113.46.69', '登陆奖励', '1501422452', '1501422452', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('7', '5', '15', 'jifen', '1', '118.113.46.69', '', '1501422465', '1501422465', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('8', '5', '-10', 'jifen', '0', '118.113.46.69', '超级支付：付费查看内容:福气满满的3种眉型你有吗', '1501422473', '1501422473', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('9', '5', '1111', 'jifen', '1', '118.113.46.69', '', '1501422629', '1501422629', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('10', '5', '-10', 'jifen', '0', '118.113.46.69', '超级支付：付费查看内容:福气满满的3种眉型你有吗', '1501422634', '1501422634', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('11', '5', '-10', 'jifen', '0', '118.113.46.69', '超级支付：付费查看内容:福气满满的3种眉型你有吗', '1501422773', '1501422773', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('12', '6', '10', 'jifen', '0', '60.206.40.88', '注册奖励', '1501466848', '1501466848', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('13', '6', '10', 'jifen', '0', '60.206.40.88', '发帖奖励', '1501466959', '1501466959', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('14', '6', '-1', 'jifen', '0', '60.206.40.88', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1501467021', '1501467021', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('15', '7', '10', 'jifen', '0', '115.221.139.177', '注册奖励', '1501475895', '1501475895', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('16', '8', '10', 'jifen', '0', '111.194.202.244', '注册奖励', '1501522461', '1501522461', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('17', '6', '1', 'jifen', '0', '60.206.40.88', '登陆奖励', '1501545862', '1501545862', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('18', '4', '1', 'jifen', '0', '121.32.127.192', '登陆奖励', '1501663132', '1501663132', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('19', '4', '-1', 'jifen', '0', '121.32.127.192', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1501663167', '1501663167', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('20', '9', '10', 'jifen', '0', '223.96.238.94', '注册奖励', '1501724591', '1501724591', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('21', '10', '10', 'jifen', '0', '58.59.196.114', '注册奖励', '1501743554', '1501743554', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('22', '10', '-1', 'jifen', '0', '58.59.196.114', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1501743575', '1501743575', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('23', '10', '-1', 'jifen', '0', '58.59.196.114', '超级支付：付费查看内容:此文收费1积分，购买一次永久有效', '1501743634', '1501743634', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('24', '5', '1', 'jifen', '0', '118.113.44.34', '登陆奖励', '1501768829', '1501768829', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('25', '5', '-1', 'jifen', '0', '118.113.44.34', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1501768834', '1501768834', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('26', '5', '-1', 'jifen', '0', '118.113.44.34', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1501768900', '1501768900', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('27', '5', '-1', 'jifen', '0', '118.113.44.34', '超级支付：付费查看内容:此文收费1积分，购买一次永久有效', '1501768919', '1501768919', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('28', '11', '10', 'jifen', '0', '110.184.199.6', '注册奖励', '1501843936', '1501843936', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('29', '6', '1', 'jifen', '0', '125.34.0.232', '登陆奖励', '1502104943', '1502104943', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('30', '12', '10', 'jifen', '0', '61.159.121.66', '注册奖励', '1502290202', '1502290202', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('31', '5', '1', 'jifen', '0', '119.253.40.170', '登陆奖励', '1502343292', '1502343292', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('32', '13', '10', 'jifen', '0', '113.132.10.189', '注册奖励', '1502382736', '1502382736', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('33', '14', '10', 'jifen', '0', '171.8.203.10', '注册奖励', '1502709795', '1502709795', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('34', '6', '1', 'jifen', '0', '60.206.40.86', '登陆奖励', '1502763620', '1502763620', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('35', '5', '1', 'jifen', '0', '27.10.98.198', '登陆奖励', '1502768452', '1502768452', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('36', '4', '1', 'jifen', '0', '121.32.127.142', '登陆奖励', '1502785795', '1502785795', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('37', '5', '1', 'jifen', '0', '115.195.124.121', '登陆奖励', '1502934343', '1502934343', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('38', '5', '-1', 'jifen', '0', '115.195.124.121', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1502934347', '1502934347', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('39', '15', '10', 'jifen', '0', '27.222.139.205', '注册奖励', '1503540246', '1503540246', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('40', '15', '1', 'jifen', '0', '27.222.139.205', '登陆奖励', '1503638127', '1503638127', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('41', '15', '-1', 'jifen', '0', '27.222.139.205', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1503638191', '1503638191', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('42', '16', '10', 'jifen', '0', '218.108.81.26', '注册奖励', '1504061817', '1504061817', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('43', '16', '1', 'jifen', '0', '218.108.81.26', '登陆奖励', '1504061873', '1504061873', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('44', '17', '10', 'jifen', '0', '222.209.84.125', '注册奖励', '1504079726', '1504079726', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('45', '18', '10', 'jifen', '0', '222.209.84.125', '注册奖励', '1504080016', '1504080016', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('46', '17', '1', 'jifen', '0', '222.209.84.125', '登陆奖励', '1504080224', '1504080224', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('47', '8', '1', 'jifen', '0', '221.216.134.235', '登陆奖励', '1504098355', '1504098355', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('48', '8', '1', 'jifen', '0', '221.216.134.235', '回帖奖励', '1504098512', '1504098512', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('49', '8', '10', 'jifen', '0', '221.216.134.235', '发帖奖励', '1504098566', '1504098566', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('50', '16', '1', 'jifen', '0', '223.93.188.66', '登陆奖励', '1504230339', '1504230339', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('51', '19', '10', 'jifen', '0', '223.93.188.66', '注册奖励', '1504230556', '1504230556', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('52', '20', '10', 'jifen', '0', '163.179.236.241', '注册奖励', '1504251824', '1504251824', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('53', '20', '-1', 'jifen', '0', '163.179.236.241', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1504251874', '1504251874', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('54', '21', '10', 'jifen', '0', '183.50.61.160', '注册奖励', '1504355969', '1504355969', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('55', '22', '10', 'jifen', '0', '121.60.25.31', '注册奖励', '1504510000', '1504510000', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('56', '23', '10', 'jifen', '0', '121.60.25.31', '注册奖励', '1504510039', '1504510039', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('57', '23', '1', 'jifen', '0', '121.60.25.31', '登陆奖励', '1504510193', '1504510193', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('58', '5', '1', 'jifen', '0', '221.181.228.196', '登陆奖励', '1504621582', '1504621582', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('59', '24', '10', 'jifen', '0', '58.16.0.24', '注册奖励', '1505034252', '1505034252', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('60', '24', '1', 'jifen', '0', '58.16.0.24', '回帖奖励', '1505034719', '1505034719', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('61', '5', '1', 'jifen', '0', '175.11.186.148', '登陆奖励', '1505092399', '1505092399', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('62', '25', '10', 'jifen', '0', '222.214.172.51', '注册奖励', '1505443698', '1505443698', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('63', '25', '-1', 'jifen', '0', '222.214.172.51', '超级支付：付费查看内容:此文收费1积分，一分钟后需要重新支付', '1505443707', '1505443707', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('64', '26', '10', 'jifen', '0', '42.93.101.146', '注册奖励', '1505629321', '1505629321', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('65', '27', '10', 'jifen', '0', '183.225.175.90', '注册奖励', '1505641598', '1505641598', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('66', '28', '10', 'jifen', '0', '111.227.21.232', '注册奖励', '1505883118', '1505883118', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('67', '28', '1', 'jifen', '0', '111.227.21.232', '回帖奖励', '1505883175', '1505883175', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('68', '5', '1', 'jifen', '0', '175.9.45.193', '登陆奖励', '1506671401', '1506671401', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('69', '29', '10', 'jifen', '0', '182.140.175.143', '注册奖励', '1507609477', '1507609477', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('70', '5', '1', 'jifen', '0', '220.161.73.50', '登陆奖励', '1507645944', '1507645944', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('71', '30', '10', 'jifen', '0', '116.7.29.143', '注册奖励', '1508463439', '1508463439', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('72', '31', '10', 'jifen', '0', '116.7.29.143', '注册奖励', '1508465464', '1508465464', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('73', '5', '1', 'jifen', '0', '139.201.218.147', '登陆奖励', '1508649010', '1508649010', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('74', '5', '1', 'jifen', '0', '36.57.136.46', '登陆奖励', '1508894756', '1508894756', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('75', '4', '1', 'jifen', '0', '121.32.127.153', '登陆奖励', '1509004606', '1509004606', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('76', '5', '1', 'jifen', '0', '36.57.137.223', '登陆奖励', '1509345844', '1509345844', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('77', '32', '10', 'jifen', '0', '110.85.152.75', '注册奖励', '1509636389', '1509636389', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('78', '33', '10', 'jifen', '0', '115.228.181.6', '注册奖励', '1510152461', '1510152461', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('79', '34', '10', 'jifen', '0', '123.114.156.240', '注册奖励', '1510301336', '1510301336', '0', '1');
INSERT INTO `ebcms5_user_currency_log` VALUES ('80', '3', '1', 'jifen', '0', '180.191.103.224', '登陆奖励', '1512473983', '1512473983', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_user_message
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_message`;
CREATE TABLE `ebcms5_user_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `topic` varchar(255) NOT NULL DEFAULT '' COMMENT '主题',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `content` text COMMENT '消息内容',
  `isread` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COMMENT='消息通知表';

-- ----------------------------
-- Records of ebcms5_user_message
-- ----------------------------
INSERT INTO `ebcms5_user_message` VALUES ('1', '1', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:tianyu123，你好，你注册的邮箱是 yuefeihuo@qq.com 欢迎注册！</p>', '0', '1500696358', '1500696358', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('2', '2', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:suobing，你好，你注册的邮箱是 460761515@qq.com 欢迎注册！</p>', '1', '1500901944', '1500901944', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('3', '3', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:test，你好，你注册的邮箱是 2811832487@qq.com 欢迎注册！</p>', '0', '1501049136', '1501049136', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('4', '4', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:getcww，你好，你注册的邮箱是 2950918980@qq.com 欢迎注册！</p>', '0', '1501147187', '1501147187', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('5', '5', '系统消息', '财务变更通知！', '系统已为您充值 15积分,若有疑问，请联系我们！', '1', '1501422465', '1501422465', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('6', '5', '系统消息', '财务变更通知！', '系统已为您充值 1111积分,若有疑问，请联系我们！', '1', '1501422629', '1501422629', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('7', '6', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:暂时无名，你好，你注册的邮箱是 hqz8812@126.com 欢迎注册！</p>', '1', '1501466848', '1501466848', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('8', '7', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:jjzk，你好，你注册的邮箱是 867517345@qq.com 欢迎注册！</p>', '0', '1501475895', '1501475895', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('9', '6', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/5.html?goto=6\">点击查看</a>', '1', '1501522401', '1501522401', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('10', '8', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:wind，你好，你注册的邮箱是 87215712@qq.com 欢迎注册！</p>', '1', '1501522461', '1501522461', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('11', '4', '系统消息', '您的密码已修改成功！', '您的密码已修改成功，请妥善保管！', '0', '1501663095', '1501663095', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('12', '9', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:bairuoqing，你好，你注册的邮箱是 1120032500@qq.com 欢迎注册！</p>', '1', '1501724591', '1501724591', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('13', '10', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:星刻之痕，你好，你注册的邮箱是 1982339647@qq.com 欢迎注册！</p>', '0', '1501743554', '1501743554', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('14', '11', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:xiaoxiao2，你好，你注册的邮箱是 113743677@qq.com 欢迎注册！</p>', '1', '1501843936', '1501843936', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('15', '1', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/1.html?goto=7\">点击查看</a>', '0', '1501899880', '1501899880', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('16', '12', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:小莫，你好，你注册的邮箱是 954952689@qq.com 欢迎注册！</p>', '1', '1502290202', '1502290202', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('17', '6', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/5.html?goto=8\">点击查看</a>', '0', '1502343218', '1502343218', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('18', '13', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:w_ting，你好，你注册的邮箱是 2214362719@qq.com 欢迎注册！</p>', '0', '1502382736', '1502382736', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('19', '14', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:毛啊摸3，你好，你注册的邮箱是 286438690@qq.com 欢迎注册！</p>', '0', '1502709795', '1502709795', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('20', '6', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/5.html?goto=9\">点击查看</a>', '0', '1502844922', '1502844922', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('21', '6', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/5.html?goto=10\">点击查看</a>', '0', '1502869061', '1502869061', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('22', '1', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/1.html?goto=11\">点击查看</a>', '0', '1502943585', '1502943585', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('23', '15', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:weiwei90，你好，你注册的邮箱是 468888911@qq.com 欢迎注册！</p>', '0', '1503540246', '1503540246', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('24', '16', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:noob，你好，你注册的邮箱是 faith4444@163.com 欢迎注册！</p>', '0', '1504061817', '1504061817', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('25', '17', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:balisong，你好，你注册的邮箱是 651162013@qq.com 欢迎注册！</p>', '0', '1504079726', '1504079726', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('26', '18', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:balisong1，你好，你注册的邮箱是 651543204@qq.com 欢迎注册！</p>', '0', '1504080016', '1504080016', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('27', '17', '系统消息', '您的密码已修改成功！', '您的密码已修改成功，请妥善保管！', '0', '1504080195', '1504080195', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('28', '2', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/3.html?goto=13\">点击查看</a>', '0', '1504092951', '1504092951', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('29', '8', '系统消息', '您的密码已修改成功！', '您的密码已修改成功，请妥善保管！', '1', '1504098342', '1504098342', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('30', '19', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:noob_noob，你好，你注册的邮箱是 704646600@qq.com 欢迎注册！</p>', '0', '1504230556', '1504230556', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('31', '16', '系统消息', '您的密码已修改成功！', '您的密码已修改成功，请妥善保管！', '0', '1504232886', '1504232886', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('32', '19', '系统消息', '您的密码已修改成功！', '您的密码已修改成功，请妥善保管！', '0', '1504233240', '1504233240', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('33', '20', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:明月，你好，你注册的邮箱是 274593714@qq.com 欢迎注册！</p>', '0', '1504251824', '1504251824', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('34', '21', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:78388335，你好，你注册的邮箱是 78388335@qq.com 欢迎注册！</p>', '1', '1504355969', '1504355969', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('35', '22', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:shilezhi，你好，你注册的邮箱是 xutao@eversec.cn 欢迎注册！</p>', '0', '1504510000', '1504510000', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('36', '23', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:shilezhi2，你好，你注册的邮箱是 1460451166@qq.com 欢迎注册！</p>', '0', '1504510039', '1504510039', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('37', '23', '系统消息', '您的密码已修改成功！', '您的密码已修改成功，请妥善保管！', '0', '1504510169', '1504510169', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('38', '24', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:maxbug，你好，你注册的邮箱是 1258484192@qq.com 欢迎注册！</p>', '0', '1505034252', '1505034252', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('39', '25', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:ncnic，你好，你注册的邮箱是 247898709@qq.com 欢迎注册！</p>', '0', '1505443698', '1505443698', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('40', '26', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:lxj168，你好，你注册的邮箱是 63660932@qq.com 欢迎注册！</p>', '1', '1505629321', '1505629321', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('41', '27', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:zwf9918，你好，你注册的邮箱是 99239218@qq.com 欢迎注册！</p>', '0', '1505641598', '1505641598', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('42', '28', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:9068428212，你好，你注册的邮箱是 906842182@qq.com 欢迎注册！</p>', '1', '1505883118', '1505883118', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('44', '1', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/1.html?goto=17\">点击查看</a>', '0', '1508232471', '1508232471', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('45', '1', '论坛消息', '您的帖子有新回复啦！', '您的帖子有新的回复，<a href=\"/thread/1.html?goto=18\">点击查看</a>', '0', '1508232493', '1508232493', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('46', '30', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:考试宝典，你好，你注册的邮箱是 3218013423@qq.com 欢迎注册！</p>', '0', '1508463439', '1508463439', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('47', '31', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:考试宝典111，你好，你注册的邮箱是 190676721@qq.com 欢迎注册！</p>', '0', '1508465464', '1508465464', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('48', '32', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:虎头虎猫，你好，你注册的邮箱是 853899319@qq.com 欢迎注册！</p>', '0', '1509636389', '1509636389', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('49', '33', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:luojunjin，你好，你注册的邮箱是 2676586@qq.com 欢迎注册！</p>', '0', '1510152461', '1510152461', '0', '1');
INSERT INTO `ebcms5_user_message` VALUES ('50', '34', '系统消息', '欢迎您的到来！', '<p>尊敬的会员:yang123，你好，你注册的邮箱是 337972603@qq.com 欢迎注册！</p>', '0', '1510301336', '1510301336', '0', '1');
