<?php
function saxue_get_block( $blockconfig, $retflag = 0 ) {
		global $saxueTpl;
		global $saxueCache;
		if ( !is_object( $saxueTpl ) ) {
				include_once( SAXUE_ROOT_PATH . "/lib/template/template.php" );
				$saxueTpl = &saxuetpl :: getinstance();
		}
		$blockret = array();
		if ( 0 < $blockconfig['custom'] ) {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/block_custom.php";
		} else {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/" . trim( $blockconfig['filename'] ) . ".php";
		} 
		$usecache = false;
		if ( $blockconfig['contenttype'] != SAXUE_CONTENT_PHP && empty( $blockconfig['hasvars'] ) ) {
				if ( 0 < $blockconfig['custom'] ) {
						$templatefile = empty( $blockconfig['bid'] ) ? $blockconfig['filename'] . ".html" : "block_custom" . $blockconfig['bid'] . ".html";
				} else {
						$templatefile = empty( $blockconfig['template'] ) ? $blockconfig['filename'] . ".html" : $blockconfig['template'];
				} 
				$templatefile = SAXUE_THEME_PATH . "/blocks/" . $templatefile;
				$cachefile = str_replace( SAXUE_ROOT_PATH, SAXUE_CACHE_PATH, $templatefile );
				if ( $saxueCache -> iscached( $cachefile ) ) {
						$usecache = true;
				} 
		} 
		if ( $usecache ) {
				$blockret = array( "title" => $blockconfig['title'], "content" => $saxueCache -> get( $cachefile ) );
		} else {
				$blockfile = @realpath( $blockfile );
				if ( is_file( $blockfile ) && preg_match( "/blocks[\\/\\\\]block_\\w+\\.php\$/i", $blockfile ) ) {
						$tpl_bak_vars = $saxueTpl -> get_all_assign();
						$tpl_bak_caching = $saxueTpl -> getcaching();
						$tpl_bak_cachetime = $saxueTpl -> getcachetime();
						$tpl_bak_overtime = $saxueTpl -> getovertime();
						include_once( $blockfile );
						$saxueBlock = new $blockconfig['classname']( $blockconfig );
						$blockret = array( "title" => $saxueBlock -> gettitle(), "content" => $saxueBlock -> getcontent() );
						$saxueTpl -> set_all_assign( $tpl_bak_vars );
						$saxueTpl -> setcaching( $tpl_bak_caching );
						$saxueTpl -> setcachetime( $tpl_bak_cachetime );
						$saxueTpl -> setovertime( $tpl_bak_overtime );
				} else {
						return false;
				} 
		} 
		if ( $retflag == 1 ) {
				return $blockret['content'];
		} 
		if ( $retflag == 2 ) {
				return $blockret['title'];
		} 
		return $blockret;
} 
