<?php
if ( !is_a( $query_handler, "saxuequeryhandler" ) ) {
		saxue_includedb();
		$query_handler = saxuequeryhandler :: getinstance( "saxuequeryhandler" );
} 
function cache_roles() {
		global $query_handler;
		$sql = "SELECT id,rolename,power,status FROM " . saxue_dbprefix( 'system_roles' ) . " ORDER BY id ASC";
		$_result = $query_handler -> db -> query( $sql );
		$rows = array();
		while ( $v = $query_handler -> getobject( $_result ) ) {
				$k = $v -> getvar( 'id' );
				$rows[$k] = $v -> getvars( 'n' );
		} 
		saxue_setconfigs( "roles", $rows, "admin" );
} 
function cache_article_cate() {
		global $query_handler;
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['article'] ) ) {
				saxue_getconfigs( "configs", "article" );
		}
		$sql = "SELECT * FROM " . saxue_dbprefix( 'article_cate' ) . " ORDER BY views DESC";
		$_result = $query_handler -> db -> query( $sql );
		$rows = $aliasrows = $arrchild = $channel = array();
		while ( $v = $query_handler -> getobject( $_result ) ) {
				$pid = $v -> getvar( 'pid' );
				$cid = $v -> getvar( 'cid' );
				$alias = $v -> getvar( 'alias' );
				$rows['article'][$cid] = $v -> getvars( 'n' );
				$rows['article'][$cid]['child'] = 0;
				$rows['article'][$cid]['arrchild'] = $cid;
				if ( $pid > 0 ) $arrchild[$pid][] = $cid;
				if ( empty( $rows['article'][$cid]['pnum'] ) ) $rows['article'][$cid]['pnum'] = $saxueConfigs['article']['pnum'];
				if ( empty( $rows['article'][$cid]['tempdetail'] ) ) $rows['article'][$cid]['tempdetail'] = 'detail.html';
				if ( empty( $rows['article'][$cid]['tempcatalog'] ) ) $rows['article'][$cid]['tempcatalog'] = 'catalog.html';
				if ( empty( $rows['article'][$cid]['tempchapter'] ) ) $rows['article'][$cid]['tempchapter'] = 'chapter.html';
		}
		foreach ( $arrchild as $cid => $v ) {
				$rows['article'][$cid]['child'] = 1;
				$rows['article'][$cid]['arrchild'] .= ',' . implode( ',', $v );
		}
		foreach ( $rows['article'] as $cid => $v ) {
				$rows['article'][$cid]['curl'] = saxue_geturl( "article_list", $cid, $rows['article'] );
				$rows['article'][$cid]['curl_page'] = saxue_geturl( "article_list", $cid, $rows['article'], '<{$page}>' );
				$rows['article'][$cid]['scurl'] = saxue_geturl( "slide_list", $cid, $rows['article'] );
				$rows['article'][$cid]['scurl_page'] = saxue_geturl( "slide_list", $cid, $rows['article'], '<{$page}>' );
				if ( $v['showchannel'] && !$v['child'] ) {
						$rows['article'][$cid]['showchannel'] = '0';
				}
				if ( empty( $rows['article'][$cid]['templist'] ) ) {
						$rows['article'][$cid]['templist'] = ( $rows['article'][$cid]['showchannel'] ? 'channel.html' : 'list.html' );
				}
				if ( $v['pid'] == 0 ) {
						$aliasrows['article'][$v['alias']] = $cid;
						$channel[$cid]['cname'] = $v['cname'];
						$channel[$cid]['curl'] = $rows['article'][$cid]['curl'];
						$channel[$cid]['scurl'] = $rows['article'][$cid]['scurl'];
				} else {
						$aliasrows['article'][$rows['article'][$v['pid']]['alias'] . '_' . $v['alias']] = $cid;
				}
		}
		saxue_setconfigs( "cate", $rows, "article", 'saxueCate', true );
		saxue_setconfigs( "catealias", $aliasrows, "article" );
		saxue_setconfigs( "channel", $channel );
}
function cache_topic_cate() {
		global $query_handler;
		$sql = "SELECT * FROM " . saxue_dbprefix( 'topic_cate' );
		$_result = $query_handler -> db -> query( $sql );
		$rows = $aliasrows = array();
		while ( $v = $query_handler -> getobject( $_result ) ) {
				$cid = $v -> getvar( 'cid' );
				$alias = $v -> getvar( 'alias' );
				$rows['topic'][$cid] = $v -> getvars( 'n' );
				$rows['topic'][$cid]['curl'] = saxue_geturl( "topic_list", $cid, $alias );
				$rows['topic'][$cid]['curl_page'] = saxue_geturl( "topic_list", $cid, $alias, '<{$page}>' );
				$aliasrows['topic'][$alias] = $cid;
		} 
		saxue_setconfigs( "cate", $rows, "topic", 'saxueCate', true );
		saxue_setconfigs( "catealias", $aliasrows, "topic" );
}
function cache_plugin() {
		global $query_handler;
		$sql = "SELECT * FROM " . saxue_dbprefix( 'plugin' );
		$_result = $query_handler -> db -> query( $sql );
		$rows = array();
		while ( $v = $query_handler -> getobject( $_result ) ) {
				$k = $v -> getvar( 'identifier' );
				$rows[$k] = $v -> getvars( 'n' );
				$rows[$k]['path'] = '/plugin/' . $rows[$k]['dir'];
				if ( !empty( $rows[$k]['menu'] ) ) {
						$rows[$k]['menu'] = unserialize( $rows[$k]['menu'] );
						foreach ( $rows[$k]['menu'] as $pmod => $v ) {
								if ( false === strpos( $v['url'], 'http://' ) ) {
										$rows[$k]['menu'][$pmod]['url'] = $rows[$k]['path'] . '/' . $v['url'];
								} 
								if ( false === strpos( $v['url'], '?' ) ) {
										$rows[$k]['menu'][$pmod]['url'] .= '?identifier=' . $k . '&pmod=' . $pmod;
								} else {
										$rows[$k]['menu'][$pmod]['url'] .= '&identifier=' . $k . '&pmod=' . $pmod;
								} 
						} 
				} 
				if ( is_array( $rows[$k]['menu'] ) && count( $rows[$k]['menu'] ) > 0 ) {
						$rows[$k]['hasmenu'] = 1;
				} else {
						$rows[$k]['hasmenu'] = 0;
				} 
		} 
		saxue_setconfigs( "plugin", $rows, "system", "saxuePlugin", true );
} 
function cache_friendlink() {
		global $query_handler;
		$sql = "SELECT title,url,logo,type FROM " . saxue_dbprefix( 'friendlink' ) . " WHERE display=1 ORDER BY listorder ASC";
		$_result = $query_handler -> db -> query( $sql );
		$rows = array();
		$k = 0;
		while ( $v = $query_handler -> getobject( $_result ) ) {
				$tmp = $v -> getvars( 'n' );
				if ( $tmp['type'] ) {
						$rows['logo'][$k]['logo'] = $tmp['logo'];
						$rows['logo'][$k]['title'] = $tmp['title'];
						$rows['logo'][$k]['url'] = $tmp['url'];
				} else {
						$rows['text'][$k]['title'] = $tmp['title'];
						$rows['text'][$k]['url'] = $tmp['url'];
				} 
				++$k;
		} 
		saxue_setconfigs( "friendlink", $rows, "system", "saxueFriendlink", true );
} 
function cache_pages() {
		global $query_handler;
		$sql = "SELECT * FROM " . saxue_dbprefix( 'pages' ) . " ORDER BY listorder ASC";
		$_result = $query_handler -> db -> query( $sql );
		$rows = array();
		while ( $v = $query_handler -> getobject( $_result ) ) {
				$tmp = $v -> getvars( 'n' );
				if ( empty( $tmp['filename'] ) ) {
						$tmp['filename'] = $tmp['id'] . '.html';
				} 
				if ( empty( $tmp['mfilename'] ) ) {
						$tmp['mfilename'] = $tmp['id'] . '.htm';
				} 
				$rows[$tmp['item']][$tmp['id']]['title'] = $tmp['title'];
				$rows[$tmp['item']][$tmp['id']]['url'] = saxue_fileurl( $tmp['htmldir'], $tmp['htmlurl'] ) . '/' . $tmp['filename'];
				$rows[$tmp['item']][$tmp['id']]['murl'] = saxue_fileurl( $tmp['htmldir'], $tmp['htmlurl'] ) . '/' . $tmp['mfilename'];
		} 
		saxue_setconfigs( "pages", $rows, "system" );
} 
function cache_member_menu() {
		global $query_handler;
		$sql = "SELECT * FROM " . saxue_dbprefix( 'member_menu' ) . " ORDER BY listorder ASC,pid ASC,menuid ASC";
		$_result = $query_handler -> db -> query( $sql );
		$menus = array();
		while ( $v = $query_handler -> getobject( $_result ) ) {
				if ( $v -> getvar( 'display' ) == 1 ) {
						$menus[$v -> getvar( 'menuid' )] = $v -> getvars( 'n' );
				} 
		} 
		$menu = array();
		foreach( $menus as $mid => $v ) {
				$menu[$mid]['pid'] = $v['pid'];
				$menu[$mid]['title'] = $v['caption'];
				$menu[$mid]['url'] = $v['command'];
				if ( false === strpos( $menu[$mid]['url'], '?' ) ) {
						$menu[$mid]['url'] .= '?menuid=' . $mid;
				} else {
						$menu[$mid]['url'] .= '&menuid=' . $mid;
				} 
				$menu[$mid]['submenu'] = cache_get_arrsub( $mid, $menus );
				$menu[$mid]['child'] = count( $menu[$mid]['submenu'] );
		} 
		saxue_setconfigs( "membermenu", $menu, "member", "saxueMembermenu", true );
} 
function cache_get_arrsub( $id, $CATEGORY ) {
		$subcat = array();
		if ( is_array( $CATEGORY ) ) {
				foreach( $CATEGORY as $subid => $v ) {
						if ( $v['pid'] == $id ) {
								$subcat[$subid] = $subid;
						} 
				} 
		} 
		return $subcat;
} 
function cache_timthumb() {
		global $query_handler;
		$sql = "SELECT tname,width,height,quality,zoomcrop,cutpos,pngtrans,bgcolor FROM " . saxue_dbprefix( 'timthumb' ) . " WHERE status=1";
		$_result = $query_handler -> db -> query( $sql );
		$rows = array();
		while ( $v = $query_handler -> getobject( $_result ) ) {
				$k = $v -> getvar( 'tname' );
				$rows[$k] = $v -> getvars( 'n' );
				$rows[$k]['bgcolor'] = str_replace( '#', '', $rows[$k]['bgcolor'] );
		} 
		saxue_setconfigs( "timthumb", $rows );
} 