<?php
class saxuepackarticle extends saxueobject {
		public $aid = 0;
		public $addtime = 0;
		public $article = array();
		public $contents = array();
		public $replacewords = array();
		public $isload = false;
		public $isslide = 0;
		public $show404 = false;
		public $html404_pc = '';
		public $html404_mobile = '';

		public $ischapter = 0;
		public $isloadchapter = false;
		public $xml = null;
		public $chapters = array();
		public $nowid = 0;
		public $preid = 0;
		public $nextid = 0;

		protected $innerad = '{saxue_innerad}';
		protected $innerad_article = '';
		protected $innerad_chapter = '';
		protected $pagebreak = '{saxue_pagebreak}';
		protected $gallery = '~{saxue_gallery}~';
		protected $galleryHtml = '<div id="saxue_gallery" class="saxue_gallery"></div>';
		protected $galleries = '~{saxue_gallery_(\d+)}~';
		protected $galleriesHtml = '<div class="saxue_gallery" data-id="$1"></div>';
		protected $imgs = '~(<img.+?>)~is';
		protected $imgsCheck = '<!--Saxue Copy From-->';
		protected $imgsHtml = '<div class="divimg">$1</div>';

		public function saxuepackarticle( $_vars ) {
				global $saxueConfigs;
				$this -> saxueobject();
				$this -> replacewords = saxue_replace_words_array();
				$this -> innerad_article = $saxueConfigs['article']['innerad_article'];
				$this -> innerad_chapter = $saxueConfigs['article']['innerad_chapter'];
				if ( is_array( $_vars ) ) {
						if ( $_vars['status'] == 4 && !empty( $saxueConfigs['article']['show404'] ) ) {
								$this -> show404 = true;
						}
						if ( !$this -> show404 ) {
								if ( !isset( $_vars['content'] ) ) {
										$_txtpath = $this -> getdir( "txtdir", false, false );
										$_txtfile = $_txtpath . '/' . $_vars['aid'] . '.txt';
										if ( is_file( $_txtfile ) ) {
												$_vars['content'] = saxue_readfile( $_txtfile );
										}
										if ( $_vars['isslide'] ) {
												$_txtfile = $_txtpath . '/' . $_vars['aid'] . '.slide';
												if ( is_file( $_txtfile ) ) {
														$_vars['slide'] = saxue_readfile( $_txtfile );
												}
										}
										$_txtfile = $_txtpath . '/' . $_vars['aid'] . '.expand';
										if ( is_file( $_txtfile ) ) {
												$_vars['expand'] = json_decode( saxue_readfile( $_txtfile ), true );
										}
								}
								if ( $_vars['isslide'] ) {
										$_vars['pics'] = json_decode( $_vars['slide'], true );
										$_vars['picnum'] = count( $_vars['pics'] );
								}
								$_vars['content'] = $this -> formatcontent( $_vars['content'] );
						}
						$_vars['tagid'] = str_replace( ',', '|', $_vars['tagids'] );
						$this -> aid = intval( $_vars['aid'] );
						$this -> addtime = $_vars['addtime'];
						$this -> ischapter = $_vars['ischapter'];
						$this -> isslide = $_vars['isslide'];
						$this -> article = $_vars;
						$this -> isload = true;
				} else {
						$this -> aid = intval( $_vars );
						$this -> isload = false;
				}
		} 

		public function setid( $_aid = 0 ) {
				$this -> aid = intval( $_aid );
		} 

		public function getid() {
				return $this -> aid;
		} 

		public function gettemplate( $temp = 'detail' ) {
				if ( $this -> show404 ) {
						return SAXUE_THEME_PATH . '/article/404.html';
				}
				global $saxueCate;
				if ( !isset( $saxueCate['article'] ) ) {
						saxue_getconfigs( "cate", "article" );
				}
				if ( !$this -> ischapter ) {
						$temp = 'detail';
				} elseif ( $temp == 'detail' ) {
						$temp = 'catalog';
				}
				$_template = SAXUE_THEME_PATH . '/article/' . $saxueCate['article'][$this -> article['cid']]['temp' . $temp];
				if ( !file_exists( $_template ) ) {
						$_template = SAXUE_THEME_PATH . '/article/' . $temp . '.html';
				}
				return $_template;
		} 

		protected function getdir( $_dirname = "txtdir", $_ischapter = false, $_create = false ) {
				global $saxueConfigs;
				$_pathname = $saxueConfigs['article'][$_dirname];
				if ( $_create && !file_exists( $_pathname ) ) {
						saxue_createdir( $_pathname );
				} 
				if ( in_array( $_dirname, array( 'htmldir', 'mobile_htmldir' ) )  && $saxueConfigs['article']['url_detail'] == 4 ) {
						$_pathname .= '/' . date( 'Y', $this -> addtime ) . '/' . date( 'md', $this -> addtime );
				} else {
						$_pathname .= saxue_getsubdir( $this -> aid );
				}
				if ( $_create && !file_exists( $_pathname ) ) {
						saxue_createdir( $_pathname );
				} 
				if ( $_ischapter ) {
						$_pathname .= '/' . $this -> aid;
						if ( $_create && !file_exists( $_pathname ) ) {
								saxue_createdir( $_pathname );
						} 
				}
				return $_pathname;
		}  

		protected function formatcontent( $_content = '', $_ischapter = 0 ) {
				$_content = trim( $_content, "\xEF\xBB\xBF" );
				$_content = saxue_replace_words( $_content, $this -> replacewords );
				if ( false === stripos( $_content, $this -> imgsCheck ) ) {
						$_content = preg_replace( $this -> imgs, $this -> imgsHtml, $_content );
				}
				$_content = preg_replace( $this -> galleries, $this -> galleriesHtml, $_content );
				$_content = preg_replace( $this -> gallery, $this -> galleryHtml, $_content, 1 );
				$_content = str_replace( $this -> gallery, '', $_content );
				if ( $_ischapter ) {
						$_content = str_replace( $this -> innerad, $this -> innerad_chapter, $_content );
				} else {
						$_content = str_replace( $this -> innerad, $this -> innerad_article, $_content );
						$this -> contents = explode( $this -> pagebreak, $_content );
				}
				$_content = str_replace( $this -> pagebreak, '', $_content );
				return $_content;
		}

		protected function getcontent( $_chapterid = 0 ) {
				if ( $_chapterid ) {
						$content = saxue_readfile( $this -> getdir( "txtdir", true, false ) . '/' . $_chapterid . '.txt' );
				} else {
						$content = saxue_readfile( $this -> getdir( "txtdir", false, false ) . '/' . $this -> aid . '.txt' );
				}
				$content = $this -> formatcontent( $content, $_chapterid );
				return $content;
		}

		public function loadarticle() {
				if ( $this -> aid <= 0 ) {
						return false;
				}
				global $article_handler;
				global $saxueConfigs;
				if ( !is_object( $article_handler ) ) {
						include_once( SAXUE_ROOT_PATH . "/model/article.php" );
						$article_handler = saxuearticlehandler :: getinstance( "saxuearticlehandler" );
				}
				// 文章主表
				$_article = $article_handler -> get( $this -> aid );
				if ( !is_object( $_article ) ) {
						return false;
				} 
				$_status = $_article -> getvar( 'status' );
				if ( $_status == 4 && !empty( $saxueConfigs['article']['show404'] ) ) {
						$this -> show404 = true;
				} elseif ( $_status != 1 ) {
						return false;
				}
				$_row = $_article -> getvars( 'n' );
				// 文章数据表
				global $data_handler;
				if ( !is_object( $data_handler ) ) {
						include_once SAXUE_ROOT_PATH . "/model/article_data.php";
						$data_handler = saxuearticledatahandler :: getinstance( "saxuearticledatahandler" );
				}
				$data_handler -> setdatatable( $_row['tbnum'] );
				$_data = $data_handler -> get( $this -> aid );
				if ( !is_object( $_data ) ) {
						return false;
				} 
				$_row = ( $_row + ( $_data -> getvars( 'n' ) ) );
				$_row['tagid'] = str_replace( ',', '|', $_row['tagids'] );
				if ( !$this -> show404 ) {
						$_txtpath = $this -> getdir( "txtdir", false, false );
						// 内容	TXT	
						$_txtfile = $_txtpath . '/' . $this -> aid . '.txt';
						if ( is_file( $_txtfile ) ) {
								$_row['content'] = saxue_readfile( $_txtfile );
						}
						$_row['content'] = $this -> formatcontent( $_row['content'] );
						// 图集
						if ( $_row['isslide'] ) {
								$_txtfile = $_txtpath . '/' . $this -> aid . '.slide';
								if ( is_file( $_txtfile ) ) {
										$_row['slide'] = saxue_readfile( $_txtfile );
										$_row['pics'] = json_decode( $_row['slide'], true );
										$_row['picnum'] = count( $_row['pics'] );
								}
						}
						// 扩展属性
						$_txtfile = $_txtpath . '/' . $this -> aid . '.expand';
						if ( is_file( $_txtfile ) ) {
								$_row['expand'] = json_decode( saxue_readfile( $_txtfile ), true );
						}
				}
				$this -> addtime = $_row['addtime'];
				$this -> ischapter = $_row['ischapter'];
				$this -> isslide = $_row['isslide'];
				$this -> article = $_row;
				$this -> isload = true;
				return true;
		} 

		public function loadchapter() {
				$_cdsfile = $this -> getdir( "txtdir", true, false ) . '/index.cds';
				if ( !file_exists( $_cdsfile ) ) {
						return false;
				} 
				if ( !is_object( $this -> xml ) ) {
						$this -> xml = new xml();
				} 
				$this -> xml -> load( $_cdsfile );
				$_chapternode = $this -> xml -> firstChild -> firstChild;
				$this -> chapters = array();
				$_i = 0;
				while ( $_chapternode ) {
						$this -> chapters[$_i] = $_chapternode -> attributes;
						$_chapternode = $_chapternode -> nextSibling;
						++$_i;
				} 
				unset( $_chapternode );
				$this -> isloadchapter = true;
				return true;
		} 

		public function showarticle( $_page = 0 ) {
				if ( !$this -> isload ) {
						$this -> loadarticle();
				}
				if ( $this -> ischapter ) {
						$_page == 0 ? $this -> makeindex( true ) : $this -> showchapter( $_page );
				} else {
						$this -> makehtml( $_page, true );
				}
		}

		public function showchapter( $_chapterid ) {
				if ( !$this -> isloadchapter ) {
						$this -> loadchapter();
				}
				$chaptercount = count( $this -> chapters );
				$_i = 0;
				while ( $_i < $chaptercount ) {
						$_id = intval( $this -> chapters[$_i]['href'] );
						if ( $_id == $_chapterid ) {
								if ( $this -> show404 ) {
										return $this -> make404( true, 0, $_chapterid, saxue_htmlstr( $this -> chapters[$_i]['name'] ) );
								}
								$this -> makechapter( $_i + 1, true );
								return true;
						}
						++$_i;
				}
				return false;
		}

		public function showslide() {
				if ( !$this -> isload ) {
						$this -> loadarticle();
				}
				if ( $this -> isslide ) {
						$this -> makehtml( 0, true );
				}
		}

		public function makearticle( $_client = 0 ) {
				if ( !$this -> isload ) {
						$this -> loadarticle();
				}
				if ( $this -> ischapter ) {
						return $this -> makeindex( false, $_client );
				} else {
						return $this -> makehtml( 0, false, $_client );
				}
		}

		public function make404( $_show = false, $_client = 0, $_page = 0, $_chaptername = '' ) {
				if ( !$this -> show404 || !$this -> isload ) {
						return false;
				}
				global $saxueTpl;
				$saxueTpl -> assign( "aid", $this -> aid );
				$saxueTpl -> assign( "cid", $this -> article['cid'] );
				$saxueTpl -> assign( "uid", $this -> article['uid'] );
				$saxueTpl -> assign( "tagid", $this -> article['tagid'] );
				$saxueTpl -> assign( "topicid", $this -> article['topicid'] );
				$saxueTpl -> assign_by_ref( "article", $this -> article );
				if ( $_page > 0 && $this -> ischapter ) {
						$ischapter = 1;
				} else {
						$ischapter = 0;
				}
				$saxueTpl -> assign( "ischapter", $ischapter );
				$saxueTpl -> assign( "chaptername", $_chaptername );
				if ( !$_show ) {
						// 生成HTML
						$_pchtml = $_waphtml = false;
						switch ( $_client ) {
								case 0:
										$_pchtml = true;
										global $saxueConfigs;
										if ( SAXUE_MOBILE_OPEN && !empty( $saxueConfigs['article']['mobile_htmldir'] ) ) $_waphtml = true;
										break;
								case 1:
										$_pchtml = true;
										break;
								case 2:
										$_waphtml = true;
										break;
								case 3:
										$_pchtml = true;
										$_waphtml = true;
										break;
						}
						$saxueTpl -> setcaching( 0 );
						if ( $_pchtml ) {
								$saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_URL);
								$_tempdetail = SAXUE_THEME_PATH . '/article/404.html';
								if ( $this -> ischapter ) {
										if ( $_page > 0 ) {
												$_htmlfile = $this -> getdir( "htmldir", true, true ) . '/' . $_page . '.html';
										} else {
												$_htmlfile = $this -> getdir( "htmldir", true, true ) . '/index.html';
										}
								} else {
										$_htmlfile = $this -> getdir( "htmldir", false, true ) . '/' . $this -> aid . '.html';
								}
								if ( !empty( $this -> html404_pc ) ) {
										$_htmlstr = $this -> html404_pc;
								} else {
										$_htmlstr = $saxueTpl -> fetch( $_tempdetail );
										if ( $ischapter ) {
												$this -> html404_pc = $_htmlstr;
										}
								}
								saxue_writefile( $_htmlfile, $_htmlstr );
								if ( !$_page && $this -> isslide ) {
										$_htmlfile = $this -> getdir( "htmldir", false, true ) . '/slide_' . $this -> aid . '.html';
										saxue_writefile( $_htmlfile, $_htmlstr );
								}
						}
						if ( $_waphtml ) {
								if ( SAXUE_MSKIN_SET == '' ) $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/m' );
								else $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/' . SAXUE_MSKIN_SET );
								if ( SAXUE_MTHEME_SET == '' ) {
										$_tempdetail = SAXUE_ROOT_PATH . '/templates/m/article/404.html';
								} else {
										$_tempdetail = SAXUE_ROOT_PATH . '/templates/' . SAXUE_MTHEME_SET . '/article/404.html';
								}
								if ( $this -> ischapter ) {
										if ( $_page > 0 ) {
												$_htmlfile = $this -> getdir( "mobile_htmldir", true, true ) . '/' . $_page . '.html';
										} else {
												$_htmlfile = $this -> getdir( "mobile_htmldir", true, true ) . '/index.html';
										}
								} else {
										$_htmlfile = $this -> getdir( "mobile_htmldir", false, true ) . '/' . $this -> aid . '.html';
								}
								if ( !empty( $this -> html404_mobile ) ) {
										$_htmlstr = $this -> html404_mobile;
								} else {
										$_htmlstr = $saxueTpl -> fetch( $_tempdetail );
										if ( $ischapter ) {
												$this -> html404_mobile = $_htmlstr;
										}
								}
								saxue_writefile( $_htmlfile, $_htmlstr );
								if ( !$_page && $this -> isslide ) {
										$_htmlfile = $this -> getdir( "mobile_htmldir", false, true ) . '/slide_' . $this -> aid . '.html';
										saxue_writefile( $_htmlfile, $_htmlstr );
								}
						}
						return $this -> article;
				}
		}

		public function makehtml( $_page, $_show = false, $_client = 0 ) {
				if ( $this -> aid <= 0 ) {
						return false;
				}
				if ( $this -> show404 ) {
						return $this -> make404( $_show, $_client );
				}
				global $saxueTpl;
				global $saxueCate;
				global $saxueConfigs;
				if ( !isset( $saxueCate['article'] ) ) {
						saxue_getconfigs( "cate", "article" );
				} 
				// 基础数据
				$this -> article['murl'] = SAXUE_MURL . $this -> article['url'];
				$this -> article['url'] = SAXUE_URL . $this -> article['url'];
				$this -> article['msurl'] = SAXUE_MURL . $this -> article['surl'];
				$this -> article['surl'] = SAXUE_URL . $this -> article['surl'];
				$this -> article['cname'] = $saxueCate['article'][$this -> article['cid']]['cname'];
				$this -> article['curl'] = $saxueCate['article'][$this -> article['cid']]['curl'];
				if ( $this -> article['uid'] > 0 ) {
						$this -> article['uhome'] = saxue_geturl( "user_home", $this -> article['uid'] );
						$this -> article['avatar'] = saxue_geturl( "user_avatar", $this -> article['uid'], 'l' );
				}
				$saxueTpl -> assign_by_ref( "article", $this -> article );
				// 读取TAG
				$_tags = array();
				$_tagnum = 0;
				if ( strlen( $this -> article['tags'] ) > 0 ) {
						$_arr = explode( ',', $this -> article['tags'] );
						$_arrid = explode( ',', $this -> article['tagids'] );
						foreach ( $_arr as $_i => $_s ) {
								$_tags[$_tagnum]['name'] = $_s;
								$_tags[$_tagnum]['url'] = saxue_geturl( "tag_show", $_arrid[$_i] );
								++$_tagnum;
						} 
				}
				$saxueTpl -> assign( "tagnum", $_tagnum ); 
				$saxueTpl -> assign_by_ref( "tags", $_tags ); 
				// 父分类定位
				$catepos = array();
				if ( $this -> article['pid'] != $this -> article['cid'] ) {
						$catepos[] = $saxueCate['article'][$this -> article['pid']];
				}
				$catepos[] = $saxueCate['article'][$this -> article['cid']];
				$saxueTpl -> assign_by_ref( "catepos", $catepos ); 
				// 扩展信息
				$_REQUEST['cid'] = $this -> article['cid']; 
				$_REQUEST['topicid'] = $this -> article['topicid']; 
				$saxueTpl -> assign( "cid", $this -> article['cid'] );
				$saxueTpl -> assign( "cname", $this -> article['cname'] );
				$saxueTpl -> assign( "curl", $this -> article['curl'] );
				$saxueTpl -> assign( "topicid", $this -> article['topicid'] );
				// 上下篇处理
				$_prearticle = $_nextarticle = array( 'aid' => 0, 'title' => '没有了', 'url' => SAXUE_URL, 'thumb' => '' );
				if ( $saxueConfigs['article']['prenext'] && ( $this -> article['preid'] > 0 || $this -> article['nextid'] > 0 ) ) {
						global $data_handler;
						if ( !is_object( $data_handler ) ) {
								include_once SAXUE_ROOT_PATH . "/model/article_data.php";
								$data_handler = saxuearticledatahandler :: getinstance( "saxuearticledatahandler" );
						}
						$_data = $data_handler -> get( $this -> article['preid'] );
						if ( is_object( $_data ) ) {
								$_prearticle['aid'] = $this -> article['preid'];
								$_prearticle['title'] = $_data -> getvar( 'title', 'n' );
								$_prearticle['url'] = $_data -> getvar( 'url', 'n' );
								$_prearticle['thumb'] = $_data -> getvar( 'thumb', 'n' );
						}
						$_data = $data_handler -> get( $this -> article['nextid'] );
						if ( is_object( $_data ) ) {
								$_nextarticle['aid'] = $this -> article['nextid'];
								$_nextarticle['title'] = $_data -> getvar( 'title', 'n' );
								$_nextarticle['url'] = $_data -> getvar( 'url', 'n' );
								$_nextarticle['thumb'] = $_data -> getvar( 'thumb', 'n' );
						}
				}
				$saxueTpl -> assign_by_ref( "prearticle", $_prearticle ); 
				$saxueTpl -> assign_by_ref( "nextarticle", $_nextarticle );
				// 内容分页处理
				$_totalpage = count( $this -> contents );
				$_pages = array();
				for ( $_i = 0; $_i < $_totalpage; $_i++ ) {
						$_pages[$_i] = saxue_geturl( 'article_page', $this -> aid, $_i );
				}
				$saxueTpl -> assign( "totalpage", $_totalpage );
				$saxueTpl -> assign_by_ref( "pages", $_pages );
				if ( !$_show ) {
						// 生成HTML
						$_pchtml = $_waphtml = false;
						switch ( $_client ) {
								case 0:
										$_pchtml = true;
										if ( SAXUE_MOBILE_OPEN && !empty( $saxueConfigs['article']['mobile_htmldir'] ) ) $_waphtml = true;
										break;
								case 1:
										$_pchtml = true;
										break;
								case 2:
										$_waphtml = true;
										break;
								case 3:
										$_pchtml = true;
										$_waphtml = true;
										break;
						}
						$saxueTpl -> setcaching( 0 );
						if ( $_pchtml ) {
								$saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_URL);
								$_tempdetail = SAXUE_THEME_PATH . '/article/' . $saxueCate['article'][$this -> article['cid']]['tempdetail'];
								foreach ( $this -> contents as $_page => $_content ) {
										$_prepage = $_nextpage = '';
										if ( $_totalpage > 1 ) {
												if ( ( $_page - 1 ) >= 0 ) $_prepage = $_pages[$_page - 1];
												else $_prepage = $_pages[$_totalpage - 1];
												if ( ( $_page + 1 ) < $_totalpage ) $_nextpage = $_pages[$_page + 1];
												else $_nextpage = $_pages[0];
										}
										$saxueTpl -> assign( "page", $_page );
										$saxueTpl -> assign( "prepage", $_prepage );
										$saxueTpl -> assign( "nextpage", $_nextpage );
										$saxueTpl -> assign( "content", $_content );
										$_htmlfile = $this -> getdir( "htmldir", false, true ) . '/' . $_pages[$_page];
										saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempdetail ) );
								}
								if ( $this -> isslide ) {
										$_tempslide = SAXUE_THEME_PATH . '/slide/detail.html';
										$_htmlfile = $this -> getdir( "htmldir", false, true ) . '/slide_' . $this -> aid . '.html';
										saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempslide ) );
								}
						}
						if ( $_waphtml ) {
								if ( SAXUE_MSKIN_SET == '' ) $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/m' );
								else $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/' . SAXUE_MSKIN_SET );
								if ( SAXUE_MTHEME_SET == '' ) {
										$_tempdetail = SAXUE_ROOT_PATH . '/templates/m/article/';
										$_tempslide = SAXUE_ROOT_PATH . '/templates/m/slide/detail.html';
								} else {
										$_tempdetail = SAXUE_ROOT_PATH . '/templates/' . SAXUE_MTHEME_SET . '/article/';
										$_tempslide = SAXUE_ROOT_PATH . '/templates/' . SAXUE_MTHEME_SET . '/slide/detail.html';
								}
								if ( file_exists( $_tempdetail . $saxueCate['article'][$this -> article['cid']]['tempdetail'] ) ) {
										$_tempdetail .= $saxueCate['article'][$this -> article['cid']]['tempdetail'];
								} else {
										$_tempdetail .= 'detail.html';
								}
								foreach ( $this -> contents as $_page => $_content ) {
										$_prepage = $_nextpage = '';
										if ( $_totalpage > 1 ) {
												if ( ( $_page - 1 ) >= 0 ) $_prepage = $_pages[$_page - 1];
												else $_prepage = $_pages[$_totalpage - 1];
												if ( ( $_page + 1 ) < $_totalpage ) $_nextpage = $_pages[$_page + 1];
												else $_nextpage = $_pages[0];
										}
										$saxueTpl -> assign( "page", $_page );
										$saxueTpl -> assign( "prepage", $_prepage );
										$saxueTpl -> assign( "nextpage", $_nextpage );
										$saxueTpl -> assign( "content", $_content );
										$_htmlfile = $this -> getdir( "mobile_htmldir", false, true ) . '/' . $_pages[$_page];
										saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempdetail ) );
								}
								if ( $this -> isslide ) {
										$_htmlfile = $this -> getdir( "mobile_htmldir", false, true ) . '/slide_' . $this -> aid . '.html';
										saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempslide ) );
								}
						}
						return $this -> article;
				} else {
						// 模版显示内容
						$_prepage = $_nextpage = '';
						if ( $_page < 0 ) $_page = 0;
						elseif ( $_page > $_totalpage ) $_page = $_totalpage;
						if ( $_totalpage > 1 ) {
								if ( ( $_page - 1 ) >= 0 ) $_prepage = $_pages[$_page - 1];
								else $_prepage = $_pages[$_totalpage - 1];
								if ( ( $_page + 1 ) < $_totalpage ) $_nextpage = $_pages[$_page + 1];
								else $_nextpage = $_pages[0];
						}
						$saxueTpl -> assign( "page", $_page );
						$saxueTpl -> assign( "prepage", $_prepage );
						$saxueTpl -> assign( "nextpage", $_nextpage );
						$saxueTpl -> assign( "content", $this -> contents[$_page] );
				}
		}

		public function makeindex( $_show = false, $_client = 0 ) {
				if ( !$this -> isload ) {
						$this -> loadarticle();
				}
				if ( !$this -> isloadchapter ) {
						$this -> loadchapter();
				}
				if ( $this -> show404 ) {
						return $this -> make404( $_show, $_client );
				}
				global $saxueTpl;
				global $saxueCate;
				global $saxueConfigs;
				if ( !isset( $saxueCate['article'] ) ) {
						saxue_getconfigs( "cate", "article" );
				} 
				if ( !isset( $this -> article['content'] ) ) {
						$this -> article['content'] = $this -> getcontent();
				} 
				// 基础数据
				if ( empty( $this -> article['content'] ) ) {
						$this -> article['content'] = $this -> article['intro'];
				}
				$this -> article['murl'] = SAXUE_MURL . $this -> article['url'];
				$this -> article['url'] = SAXUE_URL . $this -> article['url'];
				$this -> article['msurl'] = SAXUE_MURL . $this -> article['surl'];
				$this -> article['surl'] = SAXUE_URL . $this -> article['surl'];
				$this -> article['cname'] = $saxueCate['article'][$this -> article['cid']]['cname'];
				$this -> article['curl'] = $saxueCate['article'][$this -> article['cid']]['curl'];
				$saxueTpl -> assign_by_ref( "article", $this -> article );
				// 读取TAG
				$_tags = array();
				$_tagnum = 0;
				if ( strlen( $this -> article['tags'] ) > 0 ) {
						$_arr = explode( ',', $this -> article['tags'] );
						$_arrid = explode( ',', $this -> article['tagids'] );
						foreach ( $_arr as $_i => $_s ) {
								$_tags[$_tagnum]['name'] = $_s;
								$_tags[$_tagnum]['url'] = saxue_geturl( "tag_show", $_arrid[$_i] );
								++$_tagnum;
						} 
				}
				$saxueTpl -> assign( "tagnum", $_tagnum ); 
				$saxueTpl -> assign_by_ref( "tags", $_tags ); 
				// 上下篇处理
				$_prearticle = $_nextarticle = array();
				$_prearticle = $_nextarticle = array( 'aid' => 0, 'title' => '没有了', 'url' => SAXUE_URL, 'thumb' => '' );
				if ( $saxueConfigs['article']['prenext'] && ( $this -> article['preid'] > 0 || $this -> article['nextid'] > 0 ) ) {
						global $data_handler;
						if ( !is_object( $data_handler ) ) {
								include_once SAXUE_ROOT_PATH . "/model/article_data.php";
								$data_handler = saxuearticledatahandler :: getinstance( "saxuearticledatahandler" );
						}
						$_data = $data_handler -> get( $this -> article['preid'] );
						if ( is_object( $_data ) ) {
								$_prearticle['aid'] = $this -> article['preid'];
								$_prearticle['title'] = $_data -> getvar( 'title', 'n' );
								$_prearticle['url'] = $_data -> getvar( 'url', 'n' );
								$_prearticle['thumb'] = $_data -> getvar( 'thumb', 'n' );
						}
						$_data = $data_handler -> get( $this -> article['nextid'] );
						if ( is_object( $_data ) ) {
								$_nextarticle['aid'] = $this -> article['nextid'];
								$_nextarticle['title'] = $_data -> getvar( 'title', 'n' );
								$_nextarticle['url'] = $_data -> getvar( 'url', 'n' );
								$_nextarticle['thumb'] = $_data -> getvar( 'thumb', 'n' );
						}
				}
				$saxueTpl -> assign_by_ref( "prearticle", $_prearticle ); 
				$saxueTpl -> assign_by_ref( "nextarticle", $_nextarticle );
				// 父分类定位
				$catepos = array();
				if ( $this -> article['pid'] != $this -> article['cid'] ) {
						$catepos[] = $saxueCate['article'][$this -> article['pid']];
				}
				$catepos[] = $saxueCate['article'][$this -> article['cid']];
				$saxueTpl -> assign_by_ref( "catepos", $catepos ); 
				// 扩展信息
				$_REQUEST['cid'] = $this -> article['cid']; 
				$_REQUEST['topicid'] = $this -> article['topicid']; 
				$saxueTpl -> assign( "cid", $this -> article['cid'] );
				$saxueTpl -> assign( "cname", $this -> article['cname'] );
				$saxueTpl -> assign( "curl", $this -> article['curl'] );
				$saxueTpl -> assign( "topicid", $this -> article['topicid'] );
				// 章节信息
				$_chapters = array();
				$_i = 0;
				$this -> preid = 0;
				$this -> nextid = 0;
				foreach ( $this -> chapters as $_k => $_chapter ) {
						$_chapterid = intval( $_chapter['href'] );
						$_chapters[$_i]["chaptername"] = $_chapter['name'];
						$_chapters[$_i]["chapterid"] = $_chapterid;
						$_chapters[$_i]["isvolume"] = $_chapter['isvolume'];
						$_k += 1;
						if ( !$_chapter['isvolume'] ) {
								$_chapters[$_i]["chapterurl"] = saxue_geturl( 'article_chapter', $_chapterid, $this -> aid );
								if ( $_k < $this -> nowid ) {
										$this -> preid = $_k;
								} else if ( $this -> nowid < $_k && $this -> nextid == 0 ) {
										$this -> nextid = $_k;
								} 
						}
						++$_i;
				} 
				$saxueTpl -> assign_by_ref( "chapters", $_chapters ); 
				if ( !$_show ) {
						// 生成HTML
						$_pchtml = $_waphtml = false;
						switch ( $_client ) {
								case 0:
										$_pchtml = true;
										if ( SAXUE_MOBILE_OPEN && !empty( $saxueConfigs['article']['mobile_htmldir'] ) ) $_waphtml = true;
										break;
								case 1:
										$_pchtml = true;
										break;
								case 2:
										$_waphtml = true;
										break;
								case 3:
										$_pchtml = true;
										$_waphtml = true;
										break;
						}
						$saxueTpl -> setcaching( 0 );
						if ( $_pchtml ) {
								$saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_URL);
								$_tempdetail = SAXUE_THEME_PATH . '/article/' . $saxueCate['article'][$this -> article['cid']]['tempcatalog'];
								$_htmlfile = $this -> getdir( "htmldir", true, true ) . '/index.html';
								saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempdetail ) );
								if ( $this -> isslide ) {
										$_tempslide = SAXUE_THEME_PATH . '/slide/detail.html';
										$_htmlfile = $this -> getdir( "htmldir", false, true ) . '/slide_' . $this -> aid . '.html';
										saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempslide ) );
								}
						}
						if ( $_waphtml ) {
								if ( SAXUE_MSKIN_SET == '' ) $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/m' );
								else $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/' . SAXUE_MSKIN_SET );
								if ( SAXUE_MTHEME_SET == '' ) {
										$_tempdetail = SAXUE_ROOT_PATH . '/templates/m/article/';
										$_tempslide = SAXUE_ROOT_PATH . '/templates/m/slide/detail.html';
								} else {
										$_tempdetail = SAXUE_ROOT_PATH . '/templates/' . SAXUE_MTHEME_SET . '/article/';
										$_tempslide = SAXUE_ROOT_PATH . '/templates/' . SAXUE_MTHEME_SET . '/slide/detail.html';
								}
								if ( file_exists( $_tempdetail . $saxueCate['article'][$this -> article['cid']]['tempcatalog'] ) ) {
										$_tempdetail .= $saxueCate['article'][$this -> article['cid']]['tempcatalog'];
								} else {
										$_tempdetail .= 'catalog.html';
								}
								$_htmlfile = $this -> getdir( "mobile_htmldir", true, true ) . '/index.html';
								saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempdetail ) );
								if ( $this -> isslide ) {
										$_htmlfile = $this -> getdir( "mobile_htmldir", false, true ) . '/slide_' . $this -> aid . '.html';
										saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempslide ) );
								}
						}
						return $this -> article;
				}
		}

		public function makechapter( $nowid, $_show = false, $_client = 0 ) {
				if ( $nowid <= 0 ) {
						return false;
				} 
				if ( !$this -> isloadchapter ) {
						$this -> loadchapter();
				}
				if ( $this -> chapters[$nowid - 1]['isvolume'] ) {
						return true;
				} 
				$chaptercount = count( $this -> chapters );
				if ( $chaptercount < $nowid ) {
						return false;
				} 
				if ( !$this -> isload ) {
						$this -> loadarticle();
				}
				global $saxueTpl;
				global $saxueCate;
				global $saxueConfigs;
				if ( !isset( $saxueCate['article'] ) ) {
						saxue_getconfigs( "cate", "article" );
				} 
				// 基础数据
				$this -> article['murl'] = SAXUE_MURL . $this -> article['url'];
				$this -> article['url'] = SAXUE_URL . $this -> article['url'];
				$this -> article['msurl'] = SAXUE_MURL . $this -> article['surl'];
				$this -> article['surl'] = SAXUE_URL . $this -> article['surl'];
				$this -> article['cname'] = $saxueCate['article'][$this -> article['cid']]['cname'];
				$this -> article['curl'] = $saxueCate['article'][$this -> article['cid']]['curl'];
				$saxueTpl -> assign_by_ref( "article", $this -> article );
				// 父分类定位
				$catepos = array();
				if ( $this -> article['pid'] != $this -> article['cid'] ) {
						$catepos[] = $saxueCate['article'][$this -> article['pid']];
				}
				$catepos[] = $saxueCate['article'][$this -> article['cid']];
				$saxueTpl -> assign_by_ref( "catepos", $catepos ); 
				// 扩展信息
				$_REQUEST['cid'] = $this -> article['cid']; 
				$_REQUEST['topicid'] = $this -> article['topicid']; 
				$saxueTpl -> assign( "cid", $this -> article['cid'] );
				$saxueTpl -> assign( "cname", $this -> article['cname'] );
				$saxueTpl -> assign( "curl", $this -> article['curl'] );
				$saxueTpl -> assign( "topicid", $this -> article['topicid'] );
				// 章节信息开始
				$posttime = intval( $this -> chapters[$nowid - 1]['posttime'] );
				$chapterid = intval( $this -> chapters[$nowid - 1]['href'] );
				$chaptername = saxue_htmlstr( $this -> chapters[$nowid - 1]['name'] );
				$chaptercontent = $this -> getcontent( $chapterid );
				if ( $saxueConfigs['article']['url_detail'] ) {
						$indexurl = 'index.html';
				} else {
						$indexurl = 'detail.php?aid=' . $this -> aid;
				} 
				$void = $nowid - 2;
				$volume = "";
				while ( 0 <= $void && !$this -> chapters[$void]['isvolume'] ) {
						--$void;
				}
				if ( 0 <= $void ) {
						$volume = saxue_htmlstr( $this -> chapters[$void]['name'] );
				}
				$preid = $nowid - 2;
				while ( 0 <= $preid && $this -> chapters[$preid]['isvolume'] ) {
						--$preid;
				} 
				++$preid;
				$nextid = $nowid;
				while ( $nextid < $chaptercount && $this -> chapters[$nextid]['isvolume'] ) {
						++$nextid;
				} 
				if ( $chaptercount <= $nextid ) {
						$nextid = 0;
				} else {
						++$nextid;
				} 
				$chapterid = intval( $this -> chapters[$nowid - 1]['href'] );
				if ( 0 < $preid ) {
						$tmpvar = intval( $this -> chapters[$preid - 1]['href'] );
						if ( $saxueConfigs['article']['url_detail'] ) {
								$tmpurl = $tmpvar . '.html';
						} else {
								$tmpurl = 'detail.php?aid=' . $this -> aid . '&chapterid=' . $tmpvar;
						} 
						$saxueTpl -> assign( "pre_chaptername", saxue_htmlstr( $this -> chapters[$preid - 1]['name'] ) );
						$saxueTpl -> assign( "pre_chapterurl", $tmpurl );
						$saxueTpl -> assign( "pre_chapterid", $tmpvar );
				} else {
						$saxueTpl -> assign( "pre_chaptername", '' );
						$saxueTpl -> assign( "pre_chapterurl", $indexurl );
						$saxueTpl -> assign( "pre_chapterid", 0 );
				} 
				if ( 0 < $nextid ) {
						$tmpvar = intval( $this -> chapters[$nextid - 1]['href'] );
						if ( $saxueConfigs['article']['url_detail'] ) {
								$tmpurl = $tmpvar . '.html';
						} else {
								$tmpurl = 'detail.php?aid=' . $this -> aid . '&chapterid=' . $tmpvar;
						} 
						$saxueTpl -> assign( "next_chaptername", saxue_htmlstr( $this -> chapters[$nextid - 1]['name'] ) );
						$saxueTpl -> assign( "next_chapterurl", $tmpurl );
						$saxueTpl -> assign( "next_chapterid", $tmpvar );
				} else {
						$saxueTpl -> assign( "next_chaptername", '' );
						$saxueTpl -> assign( "next_chapterurl", $indexurl );
						$saxueTpl -> assign( "next_chapterid", 0 );
				} 
				$saxueTpl -> assign( "indexurl", $indexurl );
				$saxueTpl -> assign( "posttime", $posttime );
				$saxueTpl -> assign( "volume", $volume );
				$saxueTpl -> assign( "chapterid", $chapterid );
				$saxueTpl -> assign( "chaptername", $chaptername );
				$saxueTpl -> assign( "chaptercontent", $chaptercontent );
				if ( !$_show ) {
						// 生成HTML
						$_pchtml = $_waphtml = false;
						switch ( $_client ) {
								case 0:
										$_pchtml = true;
										if ( SAXUE_MOBILE_OPEN && !empty( $saxueConfigs['article']['mobile_htmldir'] ) ) $_waphtml = true;
										break;
								case 1:
										$_pchtml = true;
										break;
								case 2:
										$_waphtml = true;
										break;
								case 3:
										$_pchtml = true;
										$_waphtml = true;
										break;
						}
						$saxueTpl -> setcaching( 0 );
						if ( $_pchtml ) {
								$saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_URL);
								$_tempdetail = SAXUE_THEME_PATH . '/article/' . $saxueCate['article'][$this -> article['cid']]['tempchapter'];
								$_htmlfile = $this -> getdir( "htmldir", true, true ) . '/' . $chapterid . '.html';
								saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempdetail ) );
						}
						if ( $_waphtml ) {
								if ( SAXUE_MSKIN_SET == '' ) $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/m' );
								else $saxueTpl -> assign( "saxue_skin_url", SAXUE_SKIN_SERVER . '/' . SAXUE_MSKIN_SET );
								if ( SAXUE_MTHEME_SET == '' ) $_tempdetail = SAXUE_ROOT_PATH . '/templates/m/article/';
								else $_tempdetail = SAXUE_ROOT_PATH . '/templates/' . SAXUE_MTHEME_SET . '/article/';
								if ( file_exists( $_tempdetail . $saxueCate['article'][$this -> article['cid']]['tempchapter'] ) ) {
										$_tempdetail .= $saxueCate['article'][$this -> article['cid']]['tempchapter'];
								} else {
										$_tempdetail .= 'chapter.html';
								}
								$_htmlfile = $this -> getdir( "mobile_htmldir", true, true ) . '/' . $chapterid . '.html';
								saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempdetail ) );
						}
						return $this -> article;
				}
		}

		public function maketxtfull() {
				global $saxueConfigs;
				if ( !$this -> isloadchapter ) {
						$this -> loadchapter();
				}
				$_txtdir = $this -> getdir( "txtdir", true, false );
				$_breakstr = "\r\n";
				$_txtfull = '您下载的文章由' . SAXUE_SITE_NAME . '（' . SAXUE_URL . '）收集整理，版权归原作者所有' . $_breakstr . $_breakstr;
				$_txtfull .= '《' . $this -> article['title'] . '》' . $_breakstr . $_breakstr;
				$_volume = '';
				foreach ( $this -> chapters as $_chapter ) {
						if ( $_chapter['isvolume'] ) {
								$_volume = $_chapter['name'] . ' - ';
						} else {
								$_txtfull .= '<' . $_volume . $_chapter['name'] . '>' . $_breakstr . $_breakstr;
								$_txtfull .= strip_tags( saxue_readfile( $_txtdir . '/' . $_chapter['href'] ) ) . $_breakstr . $_breakstr;
						}
				}
				$_txtfull .= '您下载的文章由' . SAXUE_SITE_NAME . '（' . SAXUE_URL . '）收集整理，版权归原作者所有';
				saxue_writefile( $_txtdir . '/_' . $this -> aid . '.txt', $_txtfull );
		}

		public function makepiczip() {
				$_txtdir = $this -> getdir( "txtdir", false, false );
				$_file = $_txtdir . '/' . $this -> aid . '.slide';
				if ( !is_file( $_file ) ) {
						return false;
				}
				set_time_limit( 0 );
				$_slide = saxue_readfile( $_file );
				$_pics = json_decode( $_slide, true );
				$_filepath = SAXUE_CACHE_PATH . '/slide/' . $this -> aid . '/';
				saxue_checkdir( $_filepath, true );
				foreach ( $_pics as $_pic ) {
						if ( false === stripos( $_pic['url'], 'http://' ) || false !== stripos( $_pic['url'], SAXUE_URL ) ) {
								saxue_copyfile( str_replace( saxue_uploadurl(), saxue_uploadpath(), $_pic['url'] ), $_filepath . basename( $_pic['url'] ) );
						} else {
								file_put_contents( $_filepath . basename( $_pic['url'] ), file_get_contents( $_pic['url'] ) );
						}
				}
				include_once SAXUE_ROOT_PATH . "/lib/util/pclzip.php";
				$archive = new PclZip( $_txtdir . '/' . $this -> aid . '.zip' );
				$archive -> create( $_filepath, PCLZIP_OPT_REMOVE_PATH, $_filepath );
				saxue_delfolder( $_filepath );
		}

		public function addchapter( $_chapter ) {
				global $saxueConfigs;
				$_txtfile = $this -> getdir( "txtdir", true, true ) . '/' . $_chapter['chapterid'] . '.txt';
				saxue_writefile( $_txtfile, $_chapter['chaptercontent'] );
				$this -> loadchapter();
				$this -> chapters[] = array( "name" => $_chapter['chaptername'], "href" => $_chapter['chapterid'] . '.txt', "isvolume" => $_chapter['isvolume'], "posttime" => $_chapter['posttime'] );
				$this -> createcds( );
				if ( !$_chapter['isvolume'] && $saxueConfigs['article']['url_detail'] > 2 ) {
						$this -> nowid = $_chapter['chapterorder'];
						$this -> makeindex();
						if ( 0 < $this -> preid ) {
								$this -> makechapter( $this -> preid );
						}
						if ( 0 < $this -> nextid ) {
								$this -> makechapter( $this -> nextid );
						}
						$this -> makechapter( $this -> nowid );
				}
		} 

		public function editchapter( $_chapter ) {
				global $saxueConfigs;
				$_txtfile = $this -> getdir( "txtdir", true, true ) . '/' . $_chapter['chapterid'] . '.txt';
				saxue_writefile( $_txtfile, $_chapter['chaptercontent'] );
				$this -> loadchapter();
				$_isvolume = $this -> chapters[$_chapter['chapterorder'] - 1]['isvolume'];
				$this -> chapters[$_chapter['chapterorder'] - 1] = array( "name" => $_chapter['chaptername'], "href" => $_chapter['chapterid'] . '.txt', "isvolume" => $_chapter['isvolume'], "posttime" => $_chapter['posttime'] );
				$this -> createcds( );
				if ( $saxueConfigs['article']['url_detail'] > 2 ) {
						$this -> nowid = $_chapter['chapterorder'];
						$this -> makeindex();
						if ( !$_chapter['isvolume'] ) {
								$this -> makechapter( $this -> nowid );
						}
				}
		}

		public function delchapter( $_chapterorder, $_chapterid ) {
				global $saxueConfigs;
				$_txtfile = $this -> getdir( "txtdir", true, false ) . '/' . $_chapterid . '.txt';
				if ( file_exists( $_txtfile ) ) {
						saxue_delfile( $_txtfile );
				}
				$this -> loadchapter();
				$_chaptercount = count( $this -> chapters );
				for ( $_i = $_chapterorder; $_i < $_chaptercount; ++$_i ) {
						$this -> chapters[$_i - 1] = $this -> chapters[$_i];
				}
				array_pop( $this -> chapters );
				$this -> createcds();
				if ( $saxueConfigs['article']['url_detail'] > 2 ) {
						if ( $_chaptercount <= $_chapterorder ) {
								$_chapterorder = $_chaptercount - 1;
						}
						$this -> nowid = $_chapterorder;
						$this -> makeindex();
						$_htmlfile = $this -> getdir( "htmldir", true, false ) . '/' . $_chapterid . '.html';
						if ( file_exists( $_htmlfile ) ) {
								saxue_delfile( $_htmlfile );
						}
						$_mhtmlfile = $this -> getdir( "mobile_htmldir", true, false ) . '/' . $_chapterid . '.html';
						if ( file_exists( $_mhtmlfile ) ) {
								saxue_delfile( $_mhtmlfile );
						}
						if ( 0 < $this -> preid ) {
								$this -> makechapter( $this -> preid );
						}
						if ( !$this -> chapters[$_chapterorder - 1]['isvolume'] ) {
								$this -> makechapter( $_chapterorder );
						} else if ( 0 < $this -> nextid ) {
								$this -> makechapter( $this -> nextid );
						}
				}
		}

		public function sortchapter( $_fromid, $_toid ) {
				global $saxueConfigs;
				$this -> loadchapter();
				$_chaptercount = count( $this -> chapters );
				if ( $_fromid < 1 || $_chaptercount < $_fromid || $_toid < 0 || $_chaptercount < $_toid ) {
						return false;
				}
				if ( $_fromid == $_toid || $_fromid == $_toid + 1 ) {
						return true;
				}
				if ( $this -> chapters[$_fromid - 1]['isvolume'] ) {
						$_makechapter = false;
				} else {
						$_makechapter = true;
				}
				if ( $_fromid < $_toid ) {
						$_tmp = $this -> chapters[$_fromid - 1];
						for ( $_i = $_fromid; $_i < $_toid;	++$_i ) {
								$this -> chapters[$_i - 1] = $this -> chapters[$_i];
						}
						$this -> chapters[$_toid - 1] = $_tmp;
				} else {
						$_tmp = $this -> chapters[$_fromid - 1];
						for ( $_i = $_fromid - 1; $_toid < $_i;	--$_i ) {
								$this -> chapters[$_i] = $this -> chapters[$_i - 1];
						}
						$this -> chapters[$_toid] = $_tmp;
				}
				$this -> createcds( );
				if ( $saxueConfigs['article']['url_detail'] > 2 ) {
						$this -> makeindex();
						if ( $_makechapter ) {
								if ( $_toid < $_fromid ) {
										++$_toid;
								}
								$_makes = array( );
								if ( !$this -> chapters[$_fromid - 1]['isvolume'] ) {
										$this -> makechapter( $_fromid );
										$_makes[] = $_fromid;
								}
								if ( !$this -> chapters[$_toid - 1]['isvolume'] ) {
										$this -> makechapter( $_toid );
										$_makes[] = $_toid;
								}
								$_preid = 0;
								$_nextid = 0;
								for ( $_i = 1; $_i <= $_chaptercount; ++$_i ) {
										if ( !$this -> chapters[$_i - 1]['isvolume'] ) {
												if ( $_i < $_fromid ) {
														$_preid = $_i;
												} else if ( $_fromid < $_i && $_nextid == 0 ) {
														$_nextid = $_i;
														$_i = $_chaptercount + 1;
												}
										}
								}
								if ( 0 < $_preid && !in_array( $_preid, $_makes ) ) {
										$this -> makechapter( $_preid );
										$_makes[] = $_preid;
								}
								if ( 0 < $_nextid && !in_array( $_nextid, $_makes ) ) {
										$this -> makechapter( $_nextid );
										$_makes[] = $_nextid;
								}
								$_preid = 0;
								$_nextid = 0;
								for ( $_i = 1; $_i <= $_chaptercount; ++$_i ) {
										if ( !$this -> chapters[$_i - 1]['isvolume'] ) {
												if ( $_i < $_toid ) {
														$_preid = $_i;
												} else if ( $_toid < $_i && $_nextid == 0 ) {
														$_nextid = $_i;
														$_i = $_chaptercount + 1;
												}
										}
								}
								if ( 0 < $_preid && !in_array( $_preid, $_makes ) ) {
										$this -> makechapter( $_preid );
										$_makes[] = $_preid;
								}
								if ( 0 < $_nextid && !in_array( $_nextid, $_makes ) ) {
										$this -> makechapter( $_nextid );
										$_makes[] = $_nextid;
								}
						}
				}
		}

		public function createcds( $_save = true ) {
				$this -> xml = new xml();
				$this -> xml -> encoding = "UTF-8";
				$this -> xml -> xmlDecl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
				$package = $this -> xml -> createelement( "package" );
				$package -> attributes['aid'] = $this -> aid;
				$this -> xml -> appendchild( $package );
				$i = 0;
				foreach ( $this -> chapters as $_var ) {
						${ "item" . $i } = $this -> xml -> createelement( "item" );
						${ "item" . $i } -> attributes = $_var;
						$package -> appendchild( ${ "item" . $i } );
						++$i;
				} 
				if ( $_save ) {
						$this -> savecds();
				} 
		}

		public function savecds() {
				$_cdsfile = $this -> getdir( "txtdir", true, true ) . '/index.cds';
				saxue_writefile( $_cdsfile, $this -> xml -> tostring() );
		} 
}

function RepackArticle( $aid, $packflag = array(), $socket = false, $client = 0 ){
		if ( count( $packflag ) == 0 ) return true;
		if ( $socket ) {
				$_url = SAXUE_URL . '/article/admin/makepack.php?aid=' . $aid . '&client=' . $client . '&key=' . urlencode( md5( SAXUE_DB_USER . SAXUE_DB_PASS . SAXUE_DB_NAME ) );
				foreach ( $packflag as $_k => $_v ) {
						if ( $_v ) {
								$_url .= '&packflag[]=' . urlencode( $_k );
						}
				}
				return saxue_socket_url( $_url );
		}
		$packarticle = new saxuepackarticle( $aid );
		global $chapter_handler;
		if ( !is_object( $chapter_handler ) ) {
				include SAXUE_ROOT_PATH . "/model/article_chapter.php";
				$chapter_handler = saxuearticlechapterhandler :: getinstance( "saxuearticlechapterhandler" );
		}
		$criteria = new criteriacompo( new criteria( "aid", $aid ) );
		$criteria -> setsort( "chapterorder ASC, chapterid" );
		$criteria -> setorder( "ASC" );
		$res = $chapter_handler -> queryobjects( $criteria );
		$i = 0;
		while ( $_chapter = $chapter_handler -> getobject( $res ) ) {
				$packarticle -> chapters[$i] = array( "name" => $_chapter -> getvar( "chaptername", "n" ), "href" => $_chapter -> getvar( "chapterid", "n" ) . '.txt', "isvolume" => $_chapter -> getvar( "isvolume", "n" ), "posttime" => $_chapter -> getvar( "posttime", "n" ) );
				++$i;
				if ( $_chapter -> getvar( "chapterorder", "n" ) != $i ) {
						$_chapter -> setvar( "chapterorder", $i );
						$chapter_handler -> insert( $_chapter );
				}
		}
		$ret = true;
		$packarticle -> isloadchapter = true;
		if ( $packflag['makecds'] ) {
				$packarticle -> createcds();
		}
		if ( $packflag['makeindex'] ) {
				$ret = $packarticle -> makeindex( false, $client );
		}
		if ( $packflag['makechapter'] ) {
				$_count = count( $packarticle -> chapters );
				for ( $i = 1; $i <= $_count; ++$i ) {
						$ret = $packarticle -> makechapter( $i, false, $client );
				}
		}
		return $ret;
}
function saxue_socket_url( $_url ) {
		if ( !function_exists( "fsockopen" ) ) {
				return false;
		}
		$_method = "GET";
		$_arr = parse_url( $_url );
		$_port = isset( $_arr['port'] ) ? $_arr['port'] : 80;
		$_fp = fsockopen( $_arr['host'], $_port, $_errno, $_errstr, 30 );
		if ( !$_fp ) {
				return false;
		}
		$_path = $_arr['path'];
		if ( !empty( $_arr['query'] ) ) {
				$_path .= "?" . $_arr['query'];
		}
		$_str = $_method . " " . $_path;
		$_str .= " HTTP/1.1\r\n";
		$_str .= "Host: " . $_arr['host'] . "\r\n";
		$_str .= "Connection:Close\r\n\r\n";
		fwrite( $_fp, $_str );
		if ( !feof( $_fp ) ) {
				fgets( $_fp, 8 );
		}
		fclose( $_fp );
		return true;
}
function saxue_replace_words_array( $_words_to = "**" ) {
		global $saxueConfigs;
		$_words_array = array();
		if ( !empty( $saxueConfigs['article']['replacewords'] ) ) {
				$_words = explode( "\n", strval( $saxueConfigs['article']['replacewords'] ) );
				foreach ( $_words as $_word ) {
						$_tmparr = explode( "=", $_word );
						$_tmparr[0] = trim( $_tmparr[0] );
						if ( 0 < strlen( $_tmparr[0] ) ) {
								if ( !isset( $_tmparr[1] ) || strlen( trim( $_tmparr[1] ) ) == 0 ) {
										$_tmparr[1] = $_words_to;
								}
								$_words_array[$_tmparr[0]] = trim( $_tmparr[1] );
						}
				}
		}
		return $_words_array;
}
function saxue_replace_words( $_value, $_words, $_words_to = "**" ) {
		$_from = array( );
		$_to = array( );
		if ( is_array( $_words ) ) {
				foreach ( $_words as $_k => $_v ) {
						$_k = trim( strval( $_k ) );
						if ( 0 < strlen( $_k ) ) {
								$_from[] = $_k;
								$_to[] = trim( strval( $_v ) );
						}
				}
		} else {
				$_words = explode( "\n", strval( $_words ) );
				foreach ( $_words as $_word ) {
						$_tmparr = explode( "=", $_word );
						$_tmparr[0] = trim( $_tmparr[0] );
						if ( 0 < strlen( $_tmparr[0] ) ) {
								if ( !isset( $_tmparr[1] ) && strlen( trim( $_tmparr[1] ) ) == 0 ) {
										$_tmparr[1] = $_words_to;
								}
								$_from[] = $_tmparr[0];
								$_to[] = trim( $_tmparr[1] );
						}
				}
		}
		if ( 0 < count( $_from ) ) {
				$_value = str_replace( $_from, $_to, $_value );
		}
		return $_value;
}
if ( !isset( $saxueConfigs['article'] ) ) {
		saxue_getconfigs( "configs", "article" );
}
if ( !is_object( $saxueTpl ) ) {
		include_once( SAXUE_ROOT_PATH . "/lib/template/template.php" );
		$saxueTpl = &saxuetpl :: getinstance();
}
saxue_getconfigs( 'channel' );
$saxueTpl -> assign_by_ref( "channel", $saxueChannel );
include SAXUE_ROOT_PATH . '/lib/xml/xml.php';