<?php
class saxuesqlitedatabase extends saxueobject {
		public $conn;
		public $dbset;

		public function saxuesqlitedatabase( $_db = "" ) {
				$this -> saxueobject();
		} 

		public function setdbset( $dbset ) {
				$this -> dbset = $dbset;
				$this -> connect();
				return true;
		} 

		public function connect( $master = false ) {
				if ( $this -> dbset["dbpconnect"] == 1 ) {
						$this -> conn = @sqlite_open( $this -> dbset["dbname"], 438, $sqliteerror );
				} else {
						$this -> conn = @sqlite_popen( $this -> dbset["dbname"], 438, $sqliteerror );
				} 
				if ( !$this -> conn ) {
						saxue_printfail( "Can not connect to database!<br /><br />error: " . $sqliteerror );
						return false;
				} else {
						return true;
				} 
		} 

		public function genid( $_sequence = "" ) {
				return 0;
		} 

		public function fetchrow( $_result ) {
				return @sqlite_fetch_array( $_result, SQLITE_NUM );
		} 

		public function fetcharray( $_result ) {
				return @sqlite_fetch_array( $_result, SQLITE_ASSOC );
		} 

		public function getinsertid() {
				return sqlite_last_insert_rowid( $this -> conn );
		} 

		public function getrowsnum( $_result ) {
				return @sqlite_num_rows( $_result );
		} 

		public function getaffectedrows() {
				return sqlite_changes( $this -> conn );
		} 

		public function close() {
				@sqlite_close( $this -> conn );
		} 

		public function freerecordset( $_result ) {
				return true;
		} 

		public function error() {
				$_errno = @sqlite_last_error( $this -> conn );
				if ( !empty( $_errno ) ) {
						return @sqlite_error_string( $_errno );
				} else {
						return "";
				}
		} 

		public function errno() {
				return @sqlite_last_error( $this -> conn );
		} 

		public function quotestring( $_str ) {
				return "'" . saxue_dbslashes( $_str ) . "'";
		} 

		public function query( $_sql, $_limit = 0, $_start = 0, $_nobuffer = false ) {
				if ( !empty( $_limit ) ) {
						if ( empty( $_start ) ) {
								$_start = 0;
						} 
						$_sql = $_sql . " LIMIT " . ( int )$_start . ", " . ( int )$_limit;
				} 
				$_sql = str_replace( array( "\'", "\\\"", "\\\\" ), array( "''", "\"", "\\" ), $sql );
				if ( $_nobuffer ) {
						$_result = sqlite_unbuffered_query( $_sql, $this -> conn );
				} else {
						$_result = sqlite_query( $_sql, $this -> conn );
				} 
				if ( $_result ) {
						return $_result;
				} else {
						$this -> raiseerror( "SQL: " . $_sql, SAXUE_ERROR_RETURN );
						return false;
				}
		} 

		public function list_tables() {
				if ( function_exists( "sqlite_list_tables" ) ) {
						return sqlite_list_tables();
				} else {
						$_tables = array();
						$_sql = "SELECT name FROM sqlite_master WHERE (type = 'table')";
						if ( $_res = sqlite_query( $this -> conn, $_sql ) ) {
								while ( sqlite_has_more( $_res ) ) {
										$tables[] = sqlite_fetch_single( $_res );
								} 
						} 
						return $_tables;
				}
		} 

		public function table_exists( $_table ) {
				if ( function_exists( "sqlite_table_exists" ) ) {
						return sqlite_table_exists( $this -> conn, $_table );
				} else {
						$_sql = "SELECT count(name) FROM sqlite_master WHERE ((type = 'table') and (name = '" . $_table . "'))";
						if ( $_res = sqlite_query( $this -> conn, $_sql ) ) {
								return 0 < sqlite_fetch_single( $_res );
						} else {
								return false;
						} 
				}
		} 
} 
