<?php
class saxuecompiler extends saxuetpl {
		public $unite = false;
		public $tplinc = "";
		public $functions = array (
				"noparam" => array ( 
						0 => "addslashes",
						1 => "htmlspecialchars",
						2 => "htmlentities",
						3 => "nl2br",
						4 => "rawurlencode",
						5 => "rawurldecode",
						6 => "bin2hex",
						7 => "strip_tags",
						8 => "stripslashes",
						9 => "strlen",
						10 => "strtolower",
						11 => "strtoupper",
						12 => "trim",
						13 => "ucfirst",
						14 => "ucwords",
						15 => "sizeof",
						16 => "basename",
						17 => "dirname",
						18 => "base64_encode",
						19 => "base64_decode",
						20 => "empty",
						21 => "is_array",
						22 => "isset",
						23 => "getdate",
						24 => "crc32",
						25 => "md5",
						26 => "count",
						27 => "ceil",
						28 => "floor",
						29 => "round",
						30 => "abs",
						31 => "urlencode",
						32 => "urldecode",
						33 => "intval",
						34 => "strval",
						35 => "serialize",
						36 => "unserialize",
						37 => "subdirectory",
						38 => "is_array" 
						),
				"right" => array ( 0 => "strrchr",
						1 => "strstr",
						2 => "strpos",
						3 => "str_pad",
						4 => "number_format",
						5 => "substr",
						6 => "wordwrap",
						7 => "cutstr",
						8 => "arithmetic",
						9 => "defaultval",
						10 => "saxue_geturl",
						11 => "in_array" 
						),
				"left" => array ( 0 => "date",
						1 => "implode",
						2 => "sprintf",
						3 => "str_replace",
						4 => "str_repeat" 
						) 
				);
		public $regexp = array ( "sqstr" => "\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"",
				"dqstr" => "'[^'\\\\]*(?:\\\\.[^'\\\\]*)*'",
				"qstr" => "(?:\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|'[^'\\\\]*(?:\\\\.[^'\\\\]*)*')",
				"set" => " *set +([\\\$a-zA-Z_0-9]+) *= *['\"]?([^'\"]*)['\"]? *",
				"block" => " *block (.*)",
				"var" => " *[\\\$]([a-zA-Z_0-9]+.*) *",
				"loop" => " *section +name *=(.*)loop *=(.*)",
				"eloop" => " *eloop +name *=(.*)loop *=(.*) (.*)",
				"if" => " *(else if|elseif|if)(.*)(!=|>=|<=|==|>|<)(.*)",
				"include" => " *include +file *=(.*)",
				"function" => " *function ([a-zA-Z_0-9]+.*) *" 
				);
		static public $instance;

		public function getinstance() {
				if ( empty( self :: $instance ) ) {
						self :: $instance = new saxuecompiler();
				} 
				return self :: $instance;
		} 

		public function _addslashes( $str ) {
				return str_replace( array( "\\", "'" ), array( "\\\\", "\\'" ), $str );
		} 

		public function _init_template_vars( &$template ) {
				$this -> template_dir = $template -> template_dir;
				$this -> compile_dir = $template -> compile_dir;
				$this -> force_compile = $template -> force_compile;
				$this -> caching = $template -> caching;
				$this -> left_delimiter = $template -> left_delimiter;
				$this -> right_delimiter = $template -> right_delimiter;
				$this -> left_comments = $template -> left_comments;
				$this -> right_comments = $template -> right_comments;
				$this -> _tpl_vars = &$template -> _tpl_vars;
				$this -> compile_id = $template -> compile_id;
		} 

		public function _compile_file( &$tpl_file, $isfile = true ) {
				$this -> tplinc = "";
				if ( $isfile ) {
						$str = saxue_readfile( $tpl_file );
				} else {
						$str = &$tpl_file;
				} 
				$_preg_from = array( "/" . $this -> left_comments . ".*" . $this -> right_comments . "/isU",
						"/<\\?.*\\?>/isU",
						"/<%.*%>/isU",
						"/<\\s*script[^>]+language\\s*=\\s*['\"]?php['\"]?.*>.*<\\/\\s*script\\s*>/isU" 
						);
				$_preg_to = array( "", "", "", "" );
				$str = preg_replace( $_preg_from, $_preg_to, $str );
				$htmlStrs = preg_split( "/(" . $this -> left_delimiter . ".*" . $this -> right_delimiter . ")/isU", $str, -1, PREG_SPLIT_DELIM_CAPTURE );
				$str = "";
				$p = count( $htmlStrs );
				$this -> unite = false;
				for ( $i = 0; $i < $p; ++$i ) {
						if ( ( 0 < strlen( $htmlStrs[$i] ) ) && ( $htmlStrs[$i] != "\n" ) && ( $htmlStrs[$i] != "\r\n" ) ) {
								if ( $this -> unite ) {
										$str .= ".'" . $this -> _addslashes( $htmlStrs[$i] ) . "'";
								} else {
										$str .= "echo '" . $this -> _addslashes( $htmlStrs[$i] ) . "'";
								} 
								$this -> unite = true;
						} 
						++$i;
						if ( $i < $p ) {
								$tmpflag = $this -> unite;
								$tmpval = strval( $this -> gettplstr( $htmlStrs[$i] ) );
								if ( ( $tmpflag == true ) && ( $this -> unite == true ) ) {
										$str .= "." . $tmpval;
								} else if ( ( $tmpflag == true ) && ( $this -> unite == false ) ) {
										$str .= ";\r\n" . $tmpval;
								} else if ( ( $tmpflag == false ) && ( $this -> unite == true ) ) {
										$str .= "echo " . $tmpval;
								} else if ( ( $tmpflag == false ) && ( $this -> unite == false ) ) {
										$str .= $tmpval;
								} 
						} 
				} 
				if ( $this -> unite ) {
						$str .= ";";
				} 
				unset( $regs );
				unset( $htmlStrs );
				return $str;
		} 

		public function gettplstr( $tplstr ) {
				$regs = array();
				if ( 0 < preg_match( "/" . $this -> left_delimiter . " *\\/(if|section|eloop) *" . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						$ret = "}\r\n";
						$this -> unite = false;
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . " *else *" . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						$ret = "}else{\r\n";
						$this -> unite = false;
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['var'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						return $this -> getvar( $regs );
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['set'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						$ret = $this -> getset( $regs );
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['block'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						return $this -> getblock( $regs );
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['loop'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						return $this -> getloop( $regs );
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['eloop'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						return $this -> geteloop( $regs );
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['if'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						return $this -> getif( $regs );
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['include'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						return $this -> getinclude( $regs );
				} else if ( 0 < preg_match( "/" . $this -> left_delimiter . $this -> regexp['function'] . $this -> right_delimiter . "/isU", $tplstr, $regs ) ) {
						return $this -> getfunction( $regs );
				} 
				if ( $ret === false ) {
						$this -> unite = true;
						return "'" . $this -> _addslashes( $tplstr ) . "'";
				} else {
						return $ret;
				}
		} 

		public function getset( $regs ) {
				$var = isset( $regs[1] ) ? $regs[1] : "";
				$value = isset( $regs[2] ) ? $regs[2] : "";
				$params = array();
				preg_match_all( "/[\\$][\w\[\]\.'\"]+/i", $var, $params, PREG_SET_ORDER );
				$fromvar = array();
				$tovar = array();
				foreach ( $params as $k => $v ) {
						$fromvar[$k] = $v[0];
						$tovar[$k] = "{" . $this -> getvarstr( $v[0] ) . "}";
				} 
				$params = array();
				preg_match_all( "/\{?([\\$][\w\[\]\.'\"]+)\}?/i", $value, $params, PREG_SET_ORDER );
				$fromval = array();
				$tovar = array();
				foreach ( $params as $k => $v ) {
						$fromval[$k] = $v[0];
						$tovar[$k] = $this -> getvarstr( $v[0] );
				} 
				if ( 0 < strlen( $var ) ) {
						$this -> unite = false;
						$tmpvalue = ( empty( $fromval ) ? "'" . $this -> _addslashes( stripslashes( $value ) ) . "'" : "\"" . str_replace( $fromval, $toval, $value ) . "\"" );
						if ( empty( $fromvar ) ) {
								$ret = "\$GLOBALS['saxueTset']['" . $this -> _addslashes( stripslashes( $var ) ) . "'] = " . $tmpvalue . ";\r\n";
						} else {
								$ret = str_replace( $fromvar, $tovar, $var ) . " = " . $tmpvalue . ";\r\n";
						} 
						$this -> tplinc .= $_ret;
						return '';
				} else {
						return false;
				}
		} 

		public function getblock( $regs ) {
				$blockconfig = ( isset( $regs[1] ) ? trim( $regs[1] ) : "" );
				if ( 0 < strlen( $blockconfig ) ) {
						preg_match_all( "/([a-zA-Z_0-9]+) *= *['\"]([^'\"]*)['\"]/isU", $blockconfig, $bcs, PREG_SET_ORDER );
						$bcstr = "";
						foreach ( $bcs as $bc ) {
								if ( !empty( $bcstr ) ) {
										$bcstr .= ", ";
								} 
								$bcstr .= "'" . $bc[1] . "'=>'" . $this -> _addslashes( stripslashes( $bc[2] ) ) . "'";
						} 
						$this -> unite = true;
						$ret = "saxue_get_block(array(" . $bcstr . "), 1)";
						return $ret;
				} else {
						return false;
				} 
		} 

		public function geteloop( $regs ) {
				$_name = isset( $regs[1] ) ? str_replace( array( '\'', '"' ), '', trim( $regs[1] ) ) : "";
				$_data = isset( $regs[2] ) ? trim( $regs[2] ) : "";
				$_loop_arr = $this -> getvarstr( $_data );
				$eloopconfig = isset( $regs[3] ) ? trim( $regs[3] ) : "";
				if ( 0 == strlen( $eloopconfig ) ) {
						return false;
				}
				preg_match_all( "/([a-zA-Z_0-9]+) *= *['\"]([^'\"]*)['\"]/isU", $eloopconfig, $bcs, PREG_SET_ORDER );
				$bcstr = "";
				foreach ( $bcs as $bc ) {
						if ( !empty( $bcstr ) ) {
								$bcstr .= ", ";
						} 
						$bcstr .= "'" . $bc[1] . "'=>'" . $this -> _addslashes( stripslashes( $bc[2] ) ) . "'";
				} 
				$_eloop = "saxue_get_eloop(array(" . $bcstr . "))";
				$this -> unite = false;
				return "{$_loop_arr} = {$_eloop};\r\nif (empty(" . $_loop_arr . ")) {$_loop_arr} = array();\r\n\$this->_tpl_vars['{$_name}']=array();\r\n\$this->_tpl_vars['{$_name}']['loops'] = count({$_loop_arr});\r\nreset({$_loop_arr});\r\nfor(\$this->_tpl_vars['{$_name}']['index'] = 0; \$this->_tpl_vars['{$_name}']['index'] < \$this->_tpl_vars['{$_name}']['loops']; \$this->_tpl_vars['{$_name}']['index']++){\r\n\t\$this->_tpl_vars['{$_name}']['order'] = \$this->_tpl_vars['{$_name}']['index'] + 1;\r\n\tif(\$this->_tpl_vars['{$_name}']['index'] < \$this->_tpl_vars['{$_name}']['loops']){\r\n\t\tlist(\$this->_tpl_vars['{$_name}']['key'], \$this->_tpl_vars['{$_name}']['value']) = each({$_loop_arr});\r\n\t}else{\r\n\t\t\$this->_tpl_vars['{$_name}']['key'] = '';\r\n\t\t\$this->_tpl_vars['{$_name}']['value'] = '';\r\n\t}\r\n\t";
		}  

		public function getfunction( $funcs ) {
				$func = isset( $funcs[1] ) ? trim( $funcs[1] ) : "";
				if ( !empty( $func ) ) {
						return $this -> getfunctionstr( $func );
				} 
				return false;
		} 

		public function getfunctionstr( $func, $varStr = "" ) {
				if ( !empty( $func ) ) {
						$func = str_replace( chr( 0 ), "", $func );
						$funstrs = array();
						preg_match_all( "/" . $this -> regexp["qstr"] . "/i", $func, $funstrs );
						if ( !empty( $funstrs ) ) {
								$func = preg_replace( "/" . $this -> regexp["qstr"] . "/i", chr( 0 ), $func );
						} 
						$func = explode( "|", $func );
						$p = 0;
						$i = 0;
						for ( $n = count( $func ); $i < $n; $i++ ) {
								$cfunc = explode( ":", $func[$i] );
								$funcname = trim( $cfunc[0] );
								if ( 0 < strlen( $funcname ) ) {
										$param = array();
										$j = 1;
										for ( $k = count( $cfunc ); $j < $k; $j++ ) {
												$funcvars = array();
												if ( strpos( $cfunc[$j], chr( 0 ) ) !== false ) {
														$tmpi = 0;
														$tmpl = strlen( $cfunc[$j] );
														$tmps = "";
														for ( $m = 0; $m < $tmpl; $m++ ) {
																if ( 0 < ord( $cfunc[$j][$m] ) ) {
																		$tmps .= $cfunc[$j][$m];
																} else {
																		$tmps .= "'" . $this -> _addslashes( stripslashes( substr( $funstrs[0][$p], 1, -1 ) ) ) . "'";
																		$p++;
																} 
														} 
														if ( !preg_match( "/^\\$([a-zA-Z_0-9]+.*)/is", $tmps, $funcvars ) ) {
																$param[] = trim( $tmps );
														} else {
																$param[] = trim( $this -> getVarStr( $funcvars[1] ) );
														} 
												} else {
														$cfunc[$j] = trim( $cfunc[$j] );
														if ( !preg_match( "/^\\$([a-zA-Z_0-9]+.*)/is", $cfunc[$j], $funcvars ) ) {
																$param[] = "'" . $this -> _addslashes( $cfunc[$j] ) . "'";
														} else {
																$param[] = $this -> getVarStr( $funcvars[1] );
														} 
												} 
										} 
										if ( in_array( $funcname, $this -> functions["noparam"] ) ) {
												$varStr = $funcname . "($varStr)";
										} else if ( in_array( $funcname, $this -> functions["right"] ) ) {
												$varStr = ( $varStr != "" ? $funcname . "(" . $varStr . "," . implode( ",", $param ) . ")" : $funcname . "(" . implode( ",", $param ) . ")" );
										} else if ( in_array( $funcname, $this -> functions["left"] ) ) {
												if ( $funcname != "date" ) {
														$varStr = ( $varStr != "" ? $funcname . "(" . implode( ",", $param ) . "," . $varStr . ")" : $funcname . "(" . implode( ",", $param ) . ")" );
												} else {
														$varStr = ( $varStr != "" ? $funcname . "('" . str_replace( "'", "", implode( ":", $param ) ) . "'," . $varStr . ")" : $funcname . "('" . str_replace( "'", "", implode( ":", $param ) ) . ")" );
												} 
										} else {
												$varStr = $funcname . "(" . implode( ",", $param ) . ")";
										} 
								} 
						} 
						$this -> unite = true;
						return $varStr;
				} else {
						return false;
				}
		} 

		public function getvar( $regs ) {
				$name = isset( $regs[1] ) ? trim( $regs[1] ) : "";
				$newStr = $this -> getvarstr( $name );
				if ( $newStr !== false ) {
						$this -> unite = true;
						return $newStr;
				} else {
						return false;
				}
		} 

		public function getvarstr( $_str, $re = false ) {
				preg_match( "/([a-zA-Z_0-9]+) *(\\[[^\\|]*\\])*((\\.[a-zA-Z_0-9]+)*)( *\\|.*)*/is", $_str, $regs );
				$_name = isset( $regs[1] ) ? $regs[1] : "";
				$_var = isset( $regs[2] ) ? $regs[2] : "";
				$_subvar = isset( $regs[3] ) ? $regs[3] : "";
				$_function = isset( $regs[5] ) ? trim( $regs[5] ) : "";
				$_ret_str = '';
				if ( $_name == 'Saxue' && !empty( $_subvar ) ) {
						$_ret_str = $this -> getconst( $regs[3] );
				} 
				if ( empty( $_ret_str ) ) {
						$_var = preg_replace( "/\\[\\\$([a-zA-Z_0-9]+)/i", "[\$this->_tpl_vars['\$1']", $_var );
						$_var = preg_replace( "/\\.([a-zA-Z_0-9]+)/i", "['\$1']", $_var );
						$_var = preg_replace( "/\\[([^'\"\\[\\]]*)\\]/i", "[\$this->_tpl_vars['\$1']['key']]", $_var );
						$_ret_str = "\$this->_tpl_vars['" . $_name . "']" . $_var;
						if ( !empty( $_subvar ) ) {
								$_ret_str .= preg_replace( "/\\.([a-zA-Z_0-9]+)/i", "['\$1']", trim( $_subvar ) );
						} 
				} 
				if ( !empty( $_function ) ) {
						return $this -> getfunctionstr( $_function, $_ret_str );
				} 
				if ( $re ) {
						$_ret_str = str_replace( '$' . $regs[0], "'." . $_ret_str . ".'", $_str );
				} 
				unset( $regs );
				return $_ret_str;
		} 
		public function getconst( $_str ) {
				$_vars = explode( '.', $_str );
				$_vars[1] = strtoupper( trim( $_vars[1] ) );
				$_parseStr = '';
				if ( count( $_vars ) >= 3 ) {
						$_vars[2] = trim( $_vars[2] );
						switch ( $_vars[1] ) {
								case 'SERVER':
										$_parseStr = '$_SERVER[\'' . strtoupper( $_vars[2] ) . '\']';
										break;
								case 'GET':
										$_parseStr = '$_GET[\'' . $_vars[2] . '\']';
										break;
								case 'POST':
										$_parseStr = '$_POST[\'' . $_vars[2] . '\']';
										break;
								case 'REQUEST':
										$_parseStr = '$_REQUEST[\'' . $_vars[2] . '\']';
										break;
								case 'CONST':
										$_parseStr = strtoupper( $_vars[2] );
										break;
								case 'ENV':
										$_parseStr = '$_ENV[\'' . strtoupper( $_vars[2] ) . '\']';
										break;
								case 'COOKIE':
										if ( isset( $_vars[3] ) ) {
												$_parseStr = '$_COOKIE[\'' . $_vars[2] . '\'][\'' . $_vars[3] . '\']';
										} else {
												$_parseStr = '$_COOKIE[\'' . $_vars[2] . '\']';
										} 
										break;
								case 'SESSION':
										if ( isset( $vars[3] ) ) {
												$_parseStr = '$_SESSION[\'' . $_vars[2] . '\'][\'' . $_vars[3] . '\']';
										} else {
												$_parseStr = '$_SESSION[\'' . $_vars[2] . '\']';
										} 
										break;
								default:break;
						} 
				} else if ( count( $_vars ) == 2 && defined( $_vars[1] ) ) {
						$_parseStr = $_vars[1];
				} 
				return $_parseStr;
		} 

		public function getloop( $regs ) {
				$_name = isset( $regs[1] ) ? trim( $regs[1] ) : "";
				$_data = isset( $regs[2] ) ? trim( $regs[2] ) : "";
				$_loop_arr = $this -> getvarstr( $_data );
				$this -> unite = false;
				return "if (empty(" . $_loop_arr . ")) {$_loop_arr} = array();\r\nelseif (!is_array({$_loop_arr})) {$_loop_arr} = (array){$_loop_arr};\r\n\$this->_tpl_vars['{$_name}']=array();\r\n\$this->_tpl_vars['{$_name}']['loops'] = count({$_loop_arr});\r\nreset({$_loop_arr});\r\nfor(\$this->_tpl_vars['{$_name}']['index'] = 0; \$this->_tpl_vars['{$_name}']['index'] < \$this->_tpl_vars['{$_name}']['loops']; \$this->_tpl_vars['{$_name}']['index']++){\r\n\t\$this->_tpl_vars['{$_name}']['order'] = \$this->_tpl_vars['{$_name}']['index'] + 1;\r\n\tif(\$this->_tpl_vars['{$_name}']['index'] < \$this->_tpl_vars['{$_name}']['loops']){\r\n\t\tlist(\$this->_tpl_vars['{$_name}']['key'], \$this->_tpl_vars['{$_name}']['value']) = each({$_loop_arr});\r\n\t}else{\r\n\t\t\$this->_tpl_vars['{$_name}']['key'] = '';\r\n\t\t\$this->_tpl_vars['{$_name}']['value'] = '';\r\n\t}\r\n\t";
		} 

		public function getif( $regs ) {
				$tplStr = ( isset( $regs[0] ) ? $regs[0] : "" );
				if ( preg_match( "/[\(\);]/i", $tplStr ) ) {
						$this -> unite = false;
						return "";
				} 
				$fromary = array();
				$toary = array();
				$params = array();
				preg_match_all( "/[$][^!=<>\)\s\?]+/i", $tplStr, $params, PREG_SET_ORDER );
				if ( !empty( $params ) ) {
						foreach ( $params as $k => $v ) {
								$fromary[$k] = $v[0];
								$toary[$k] = $this -> getVarStr( $v[0] );
						} 
				} 
				$ifStr = ( isset( $regs[1] ) ? $regs[1] : "" );
				$param1 = ( isset( $regs[2] ) ? $regs[2] : "" );
				$operator = ( isset( $regs[3] ) ? $regs[3] : "" );
				$param2 = ( isset( $regs[4] ) ? $regs[4] : "" );
				$tmpStr = "";
				if ( strtolower( $ifStr ) == "if" ) {
						$tmpStr .= $ifStr;
				} else {
						$tmpStr .= "}" . $ifStr;
				} 
				$tmpStr .= "(" . str_replace( $fromary, $toary, trim( $param1 . $operator . $param2 ) ) . "){\r\n";
				$this -> unite = false;
				return $tmpStr;
		} 

		public function getinclude( $regs ) {
				$file = isset( $regs[1] ) ? trim( $regs[1] ) : "";
				if ( preg_match( "/^['\"].*['\"]\$/", $file ) ) {
						$file = substr( $file, 1, -1 );
				} 
				if ( preg_match_all( "/\\\$([a-zA-Z_0-9]+) *(\\[[^\\|]*\\])*((\\.[a-zA-Z_0-9]+)*)( *\\|.*)*/is", $file, $filevars ) ) {
						foreach ( $filevars[0] as $var) {
								$file = str_replace( $var, "'." . $this -> getvarstr( $var ) . ".'", $file );
						}
				}
				$expFile = explode( "?", $file );
				strpos( $expFile[0], '.html' ) || $expFile[0] .= '.html';
				$fileName = &$expFile[0];
				$this -> unite = false;
				if ( !preg_match( "/\.html?$/i", $fileName ) ) {
						return "";
				} 
				$varstr = "";
				if ( isset( $expFile[1] ) ) {
						$expVars = explode( "&", trim( $expFile[1] ) );
						foreach ( $expVars as $val ) {
								if ( !empty( $val ) ) {
										$expVar = explode( "=", $val );
										if ( !empty( $varstr ) ) {
												$varstr .= ",";
										} 
										$varstr .= "'" . str_replace( "'", "\"", $expVar[0] ) . "'=>'" . str_replace( "'", "\"", $expVar[1] ) . "'";
								} 
						} 
				} 
				$varstr = "array(" . $varstr . ")";
				return "\$_template_tpl_vars = \$this->_tpl_vars;\r\n \$this->_template_include(array('template_include_tpl_file' => '" . $fileName . "', 'template_include_vars' => " . $varstr . "));\r\n \$this->_tpl_vars = \$_template_tpl_vars;\r\n unset(\$_template_tpl_vars);\r\n";
		} 
} 
