<?php
class saxuetpl {
		public $template_dir = "templates";
		public $compile_dir = "compiled";
		public $compile_check = true;
		public $force_compile = false;
		public $caching = 0;
		public $cache_type = 0;
		public $cache_dir = "cache";
		public $cache_lifetime = 3600;
		public $cache_overtime = 0;
		public $left_delimiter = "{\?";
		public $right_delimiter = "\?}";
		public $left_comments = "{\*";
		public $right_comments = "\*}";
		public $compile_id = null;
		public $_tpl_vars = array();
		public $_tmp_vars = array();
		public $_file_perms = 511;
		public $_dir_perms = 511;
		public $_compile_prefix = ".php";
		public $_include_prefix = ".inc.php";
		static public $instance;

		public function saxuetpl() {
				$this -> template_dir = SAXUE_ROOT_PATH . "/templates/" . SAXUE_THEME_NAME;
				$this -> cache_dir = SAXUE_CACHE_PATH;
				$this -> compile_dir = SAXUE_COMPILED_PATH;
				if ( SAXUE_USE_CACHE ) {
						$this -> caching = 1;
				} else {
						$this -> caching = 0;
				} 
				$this -> cache_lifetime = SAXUE_CACHE_LIFETIME;
				$this -> assign( array( 
						"saxue_domain" => SAXUE_COOKIE_DOMAIN,
						"saxue_url" => SAXUE_URL,
						"saxue_murl" => SAXUE_MURL,
						"saxue_sitename" => SAXUE_SITE_NAME,
						"saxue_charset" => SAXUE_SYSTEM_CHARSET,
						"saxue_version" => SAXUE_VERSION,
						"saxue_admin_url" => SAXUE_ADMIN_URL,
						"saxue_skin_url" => SAXUE_SKIN_URL,
						"saxue_skin_server" => SAXUE_SKIN_SERVER,
						"saxue_theme" => SAXUE_THEME_NAME,
						"saxue_skin" => SAXUE_SKIN_NAME,
						"saxue_time" => SAXUE_NOW_TIME,
						"meta_keywords" => SAXUE_META_KEYWORDS,
						"meta_description" => SAXUE_META_DESCRIPTION,
						"fun" => null 
				) );
				if ( isset( $_SESSION ) ) {
						$this -> assign( "saxue_sessid", @session_id() );
				} 
		} 

		public function getinstance() {
				if ( empty( self :: $instance ) || !is_a( self :: $instance, "saxuetpl" ) ) {
						self :: $instance = new saxuetpl();
				} 
				return self :: $instance;
		} 

		public function getcachtype() {
				return $this -> cache_type;
		} 

		public function setcachtype( $num = 0 ) {
				$this -> cache_type = ( int ) $num;
		} 

		public function getcaching() {
				return $this -> caching;
		} 

		public function setcaching( $num = 0 ) {
				$this -> caching = ( int ) $num;
		} 

		public function getcachetime() {
				return $this -> cache_lifetime;
		} 

		public function setcachetime( $num = 0 ) {
				$this -> cache_lifetime = ( int ) $num;
		} 

		public function getovertime() {
				return $this -> cache_overtime;
		} 

		public function setovertime( $num = 0 ) {
				$this -> cache_overtime = ( int ) $num;
		} 

		public function settheme( $theme = '' ) {
				$this -> template_dir = SAXUE_ROOT_PATH . "/templates/" . $theme;
		} 

		public function assign( $tpl_val, $value = null ) {
				if ( is_array( $tpl_val ) ) {
						foreach ( $tpl_val as $key => $val ) {
								if ( $key != "" ) {
										$this -> _tpl_vars[$key] = $val;
								} 
						} 
				} else if ( $tpl_val != "" ) {
						$this -> _tpl_vars[$tpl_val] = $value;
				} 
		} 

		public function assign_by_ref( $tpl_val, &$value ) {
				if ( $tpl_val != "" ) {
						$this -> _tpl_vars[$tpl_val] = &$value;
				} 
		} 

		public function clear_assign( $tpl_val ) {
				if ( is_array( $tpl_val ) ) {
						foreach ( $tpl_val as $curr_var ) {
								unset( $this -> _tpl_vars[$curr_var] );
						} 
				} else {
						unset( $this -> _tpl_vars[$tpl_var] );
				} 
		} 

		public function clear_all_assign() {
				$this -> _tpl_vars = array();
		} 

		public function get_assign( $vname ) {
				$keys = explode( ".", $vname );
				$ret = false;
				$first = true;
				foreach ( $keys as $key ) {
						if ( $first ) {
								$ret = $this -> _tpl_vars[$key];
						} else {
								$ret = $ret[$key];
						} 
						$first = false;
				} 
				return $ret;
		} 

		public function get_all_assign() {
				return $this -> _tpl_vars;
		} 

		public function set_all_assign( $vars ) {
				$this -> _tpl_vars = $vars;
		} 

		public function clear_cache( $tpl_file = null, $cache_id = null, $compile_id = null ) {
				global $saxueCache;
				if ( !isset( $compile_id ) ) {
						$compile_id = $this -> compile_id;
				} 
				if ( !isset( $tpl_file ) ) {
						$compile_id = null;
				} 
				$_auto_id = $this -> _get_auto_id( $cache_id, $compile_id );
				$_tname = $this -> _get_auto_filename( $this -> cache_dir, $tpl_file, $_auto_id );
				$saxueCache -> delete( $_tname );
		} 

		public function clear_all_cache() {
				global $saxueCache;
				$saxueCache -> clear();
		} 

		public function is_cached( $tpl_file, $cache_id = null, $compile_id = null, $cache_time = null, $over_time = null, $return_value = false ) {
				global $saxueCache;
				if ( !SAXUE_USE_CACHE ) {
						return false;
				} 
				if ( $this -> force_compile ) {
						return false;
				} 
				if ( !isset( $compile_id ) ) {
						$compile_id = $this -> compile_id;
				} 
				$_auto_id = $this -> _get_auto_id( $cache_id, $compile_id );
				$_cache_file = $this -> _get_auto_filename( $this -> cache_dir, $tpl_file, $_auto_id );
				if ( is_null( $cache_time ) ) {
						$cache_time = $this -> cache_lifetime;
				} 
				if ( is_null( $over_time ) ) {
						$over_time = $this -> cache_overtime;
				} 
				if ( empty( $over_time ) && ( $this -> cache_type == 0 ) ) {
						$over_time = intval( @filemtime( $tpl_file ) );
				} 
				if ( !$return_value ) {
						return $saxueCache -> iscached( $_cache_file, $cache_time, $over_time );
				} else {
						$_cache_data = $saxueCache -> get( $_cache_file, $cache_time, $over_time );
						if ( ( $this -> cache_type == 1 ) && ( $_cache_data != false ) ) {
								@eval( "\$_temp_vars = " . trim( $_cache_data ) . ";" );
								if ( is_array( $_temp_vars ) ) {
										foreach ( $_temp_vars as $k => $v ) {
												if ( isset( $this -> _tpl_vars[$k] ) ) {
														$this -> _tpl_vars[$k] = $v;
												} 
										} 
								} 
								unset( $_temp_vars );
						} 
						return $_cache_data;
				}
		} 

		public function get_cachekey( $tpl_file, $cache_id = null, $compile_id = null ) {
				return $this -> _get_auto_filename( $this -> cache_dir, $tpl_file, $this -> _get_auto_id( $cache_id, $compile_id ) );
		} 

		public function get_cachedtime( $tpl_file, $cache_id = null, $compile_id = null ) {
				global $saxueCache;
				$cachefile = $this -> _get_auto_filename( $this -> cache_dir, $tpl_file, $this -> _get_auto_id( $cache_id, $compile_id ) );
				return $saxueCache -> cachedtime( $cachefile );
		} 

		public function update_cachedtime( $tpl_file, $cache_id = null, $compile_id = null ) {
				global $saxueCache;
				$cachefile = $this -> _get_auto_filename( $this -> cache_dir, $tpl_file, $this -> _get_auto_id( $cache_id, $compile_id ) );
				return $saxueCache -> uptime( $cachefile );
		} 

		public function clear_compiled_tpl( $tpl_file = null, $compile_id = null ) {
				if ( !isset( $compile_id ) ) {
						$compile_id = $this -> compile_id;
				} 
				$_tname = $this -> _get_auto_filename( $this -> compile_dir, $tpl_file, $compile_id );
				@unlink( $_tname . ".php" );
				@unlink( $_tname . ".inc.php" );
		} 

		public function template_exists( $tpl_file ) {
				return is_file( $tpl_file );
		} 

		public function get_template_vars( $name = null ) {
				if ( !isset( $name ) ) {
						return $this -> _tpl_vars;
				} 
				if ( isset( $this -> _tpl_vars[$name] ) ) {
						return $this -> _tpl_vars[$name];
				} 
		} 

		public function get_compiled_inc( $tpl_file, $compile_id = null ) {
				$resource_dir = dirname( $tpl_file );
				if ( empty( $resource_dir ) || $resource_dir == "." ) {
						$tpl_file = $this -> template_dir . "/" . $tpl_file;
				} 
				if ( !isset( $compile_id ) ) {
						$compile_id = $this -> compile_id;
				} 
				$compiled_path = $this -> _get_compile_path( $tpl_file );
				if ( $this -> _is_compiled( $tpl_file, $compiled_path ) || $this -> _compile_resource( $tpl_file, $compiled_path ) ) {
						$incfile = $compiled_path . $this -> _include_prefix;
						if ( is_file( $incfile ) ) {
								return $incfile;
						} else {
								return false;
						}
				} 
		} 

		public function include_compiled_inc( $template_file, $compile_id = null, $force = false ) {
				$incfile = $this -> get_compiled_inc( $template_file, $compile_id );
				if ( !empty( $incfile ) ) {
						if ( $force ) {
								include ( $incfile );
						} else {
								include_once ( $incfile );
						} 
				} 
		} 

		public function display( $tpl_file, $cache_id = null, $compile_id = null, $cache_time = null, $over_time = null ) {
				$this -> fetch( $tpl_file, $cache_id, $compile_id, $cache_time, $over_time, true );
		} 

		public function fetch( $template_file, $cache_id = null, $compile_id = null, $cache_time = null, $over_time = null, $display = false ) {
				global $saxueCache;
				if ( is_array( $template_file ) ) {
						$cache_file = $template_file['cache_file'];
						$template_file = $template_file['tpl_file'];
				} else {
						$cache_file = $template_file;
				}
				if ( 0 === stripos( $template_file, SAXUE_ROOT_PATH . '/templates/' ) ) {
						$this -> template_dir = preg_replace( '~^(' . SAXUE_ROOT_PATH . '/templates/.+?)/.+?\.html$~i', '$1', $template_file );
				} elseif ( false === stripos( $template_file, SAXUE_WEB_PATH ) && $template_file[0] != '/' ) {
						$template_file = $this -> template_dir . "/" . $template_file;
				}
				if ( !isset( $compile_id ) ) {
						$compile_id = $this -> compile_id;
				} 
				if ( is_null( $cache_time ) ) {
						$cache_time = $this -> cache_lifetime;
				} 
				if ( is_null( $over_time ) ) {
						$over_time = $this -> cache_overtime;
				} 
				$save_cachevars = false;
				if ( $this -> caching == 1 ) {
						if ( $this -> cache_type == 1 ) {
								if ( $this -> is_cached( $template_file, $cache_id, $compile_id, $cache_time, $over_time, true ) !== false ) {
										$save_cachevars = true;
								} 
						} else {
								$_template_results = $this -> is_cached( $cache_file, $cache_id, $compile_id, $cache_time, $over_time, true );
								if ( false !== $_template_results ) {
										if ( $display ) {
												echo $_template_results;
												return true;
										} else {
												return $_template_results;
										}
								} elseif ( $display ) {
										header( "Last-Modified: " . date( "D, d M Y H:i:s", SAXUE_NOW_TIME ) . " GMT" );
								} 
						} 
				} else if ( ( 0 < $this -> caching ) && ( $this -> cache_type == 1 ) ) {
						$save_cachevars = $this -> is_cached( $template_file, $cache_id, $compile_id, $cache_time, $over_time, false );
				} 
				$_template_compile_path = $this -> _get_compile_path( $template_file );
				ob_start();
				if ( $this -> _is_compiled( $template_file, $_template_compile_path ) || $this -> _compile_resource( $template_file, $_template_compile_path ) ) {
						include( $_template_compile_path . $this -> _compile_prefix );
				} 
				if ( !defined( "SAXUE_COMPRESS_MODE" ) || SAXUE_COMPRESS_MODE == 0 ) {
						$_template_results = ob_get_contents();
				} elseif ( SAXUE_COMPRESS_MODE == 1 ) {
						$_template_results = saxue_strip_nr( ob_get_contents() );
				} else {
						$_template_results = saxue_strip_nr( ob_get_contents(), true );
				}
				ob_end_clean();
				if ( 0 < $this -> caching ) {
						$_auto_id = $this -> _get_auto_id( $cache_id, $compile_id );
						$_cache_file = $this -> _get_auto_filename( $this -> cache_dir, $cache_file, $_auto_id );
						if ( $this -> cache_type == 1 ) {
								if ( $save_cachevars ) {
										$_cache_vars = array();
										foreach ( $this -> _tpl_vars as $k => $v ) {
												if ( substr( $k, 0, 6 ) != "saxue_" ) {
														$_cache_vars[$k] = $v;
												} 
										} 
										$_template_vars = var_export( $_cache_vars, true );
										unset( $_cache_vars );
										$saxueCache -> set( $_cache_file, $_template_vars, $cache_time, $over_time );
								} 
						} else {
								$saxueCache -> set( $_cache_file, $_template_results, $cache_time, $over_time );
						} 
				} 
				if ( $display ) {
						if ( isset( $_template_results ) ) {
								echo $_template_results;
						} 
						return true;
				} elseif ( isset( $_template_results ) ) {
						return $_template_results;
				} 
		} 

		public function parse_string( $str, $retcode = false ) {
				include_once( TEMPLATE_DIR . "compiler.php" );
				$template_compiler = &saxuecompiler :: getinstance();
				$template_compiler -> _init_template_vars( $this );
				$compiled_content = $template_compiler -> _compile_file( $str, false );
				if ( $retcode ) {
						return $compiled_content;
				} else {
						ob_start();
						eval( $compiled_content );
						$results = ob_get_contents();
						ob_end_clean();
						return $results;
				}
		} 

		public function _is_compiled( $tpl_file, $compile_path ) {
				$compile_path .= $this -> _compile_prefix;
				if ( !$this -> force_compile && file_exists( $compile_path ) ) {
						if ( !$this -> compile_check ) {
								return true;
						} else {
								if ( !is_file( $tpl_file ) ) {
										return false;
								} 
								if ( filemtime( $tpl_file ) <= filemtime( $compile_path ) ) {
										return true;
								} else {
										return false;
								}
						}
				} else {
						return false;
				}
		} 

		public function _compile_resource( $tpl_file, $compile_path ) {
				if ( !is_file( $tpl_file ) ) {
						echo "Template file (" . str_replace( SAXUE_ROOT_PATH, "", $tpl_file ) . ") is not exists!";
						return false;
				} 
				$_tpl_timestamp = filemtime( $tpl_file );
				$this -> _compile_source( $tpl_file, $_compiled_content, $_compiled_include );
				$_compile_file = $compile_path . $this -> _compile_prefix;
				if ( saxue_checkdir( dirname( $_compile_file ), true ) ) {
						$ret = saxue_writefile( $_compile_file, $_compiled_content );
						if ( $ret && $_tpl_timestamp ) {
								@touch( $_compile_file, $_tpl_timestamp );
						} 
				} 
				if ( 0 < strlen( $_compiled_include ) ) {
						$_compile_incfile = $compile_path . $this -> _include_prefix;
						if ( saxue_checkdir( dirname( $_compile_incfile ), true ) ) {
								$ret_inc = saxue_writefile( $_compile_incfile, $_compiled_include );
								if ( $ret_inc && $_tpl_timestamp ) {
										@touch( $_compile_incfile, $_tpl_timestamp );
								} 
						} 
				} else {
						$this -> _unlink( $compile_path . $this -> _include_prefix );
				} 
				if ( $ret && $_tpl_timestamp ) {
						@clearstatcache();
				} 
				return $ret;
		} 

		public function _compile_source( $template_file, &$compiled_content, &$compiled_include ) {
				include_once( TEMPLATE_DIR . "compiler.php" );
				$template_compiler = &saxuecompiler :: getinstance();
				$template_compiler -> _init_template_vars( $this );
				$compiled_content = "<?php\r\n" . $template_compiler -> _compile_file( $template_file ) . "\r\n?>";
				$compiled_include = strlen( $template_compiler -> tplinc ) == "" ? "" : "<?php\r\n" . $template_compiler -> tplinc . "\r\n?>";
				return true;
		} 

		public function _get_compile_path( $tpl_file ) {
				return $this -> _get_auto_filename( $this -> compile_dir, $tpl_file, $this -> compile_id );
		} 

		public function _get_auto_filename( $auto_dir, $tpl_file = null, $auto_id = null ) {
				$_filename = basename( $tpl_file );
				$_filedir = dirname( $tpl_file );
				$auto_file = str_replace( array( SAXUE_ROOT_PATH, SAXUE_WEB_PATH ), $auto_dir, $_filedir );
				if ( $auto_file == $_filedir ) {
						$_filedir = trim( str_replace( array( "\\", ":" ), array( "/", "" ), $_filedir ) );
						if ( $_filedir[0] != "/" ) {
								$auto_file = $auto_dir . "/" . $_filedir;
						} else {
								$auto_file = $auto_dir . $_filedir;
						} 
				} 
				if ( isset( $auto_id ) && ( 0 < strlen( $auto_id ) ) ) {
						$auto_file .= "/" . $_filename;
						if ( is_numeric( $auto_id ) ) {
								$auto_file .= saxue_getsubdir( intval( $auto_id ) ) . "/" . $auto_id;
						} else if ( preg_match( "/^[\w][\w\/\|]*[\w]$/", $auto_id ) ) {
								$auto_file .= "/" . str_replace( "|", "/", $auto_id );
						} else {
								$auto_id = md5( $auto_id );
								$l = strlen( $auto_id );
								$p = 0;
								if ( 3 < $l ) {
										$auto_file .= "/" . substr( $auto_id, 0, 3 );
										$p = 3;
										if ( 8 < $l ) {
												$auto_file .= "/" . substr( $auto_id, 3, 5 );
												$p = 8;
												if ( 16 < $l ) {
														$auto_file .= "/" . substr( $auto_id, 8, 8 );
														$p = 16;
												} 
										} 
								} 
								if ( 0 < $p ) {
										$auto_file .= "/" . substr( $auto_id, $p );
								} else {
										$auto_file .= "/" . $auto_id;
								} 
						} 
						$auto_file .= strrchr( $_filename, "." );
				} else {
						$auto_file .= "/" . $_filename;
				}
				return $auto_file;
		} 

		public function _get_auto_id( $cache_id = null, $compile_id = null ) {
				if ( isset( $cache_id ) ) {
						return isset( $compile_id ) ? $cache_id . "|" . $compile_id : $cache_id;
				} else if ( isset( $compile_id ) ) {
						return $compile_id;
				} else {
						return null;
				} 
		} 

		public function _unlink( $resource, $exp_time = null ) {
				if ( isset( $exp_time ) ) {
						if ( $exp_time <= SAXUE_NOW_TIME - @filemtime( $resource ) ) {
								return @unlink( $resource );
						} 
				} else {
						return @unlink( $resource );
				} 
		} 

		public function _template_include( $params ) {
				$this -> _tpl_vars = array_merge( $this -> _tpl_vars, $params['template_include_vars'] );
				$params['template_include_tpl_file'] = trim( $params['template_include_tpl_file'] );
				if ( ( $params['template_include_tpl_file'][0] != "/" ) && ( $params['template_include_tpl_file'][1] != ":" ) ) {
						$params['template_include_tpl_file'] = $this -> template_dir . "/" . $params['template_include_tpl_file'];
				} else {
						$params['template_include_tpl_file'] = SAXUE_ROOT_PATH . $params['template_include_tpl_file'];
				} 
				$_template_compile_path = $this -> _get_compile_path( $params['template_include_tpl_file'] );
				if ( $this -> _is_compiled( $params['template_include_tpl_file'], $_template_compile_path ) || $this -> _compile_resource( $params['template_include_tpl_file'], $_template_compile_path ) ) {
						include( $_template_compile_path . $this -> _compile_prefix );
				} 
		} 
} 

function cutstr( $_str, $_length = 10, $_ellipsis = "", $_format = 1 ) {
		$_start = 0;
		if ( $_format && ( strpos( $_str, "<" ) !== false || strpos( $_str, "&" ) !== false ) ) {
				$_length -= strlen( $_ellipsis );
				$_len = strlen( $_str );
				$_ret = "";
				$_i = 0;
				$_j = 0;
				$A = 0;
				$_tmp_str = "";
				$_format_mode = 1;
				$_utf8 = SAXUE_SYSTEM_CHARSET == "utf-8" ? true : false;
				while ( $_i < $_len && $A < $_length ) {
						$_l1 = 1;
						$_l2 = 1;
						if ( $_str[$_i] == "<" ) {
								$_format_mode = 1;
						} else if ( $_str[$_i] == "&" ) {
								$_format_mode = 2;
						} 
						if ( 0 < $_format_mode ) {
								$_tmp_str .= $_str[$_i];
								if ( ( $_format_mode == 1 && $_str[$_i] == ">" ) || ( $_format_mode == 2 && $_str[$_i] == ";" ) ) {
										if ( $_start <= $_j ) {
												$_ret .= $_tmp_str;
										} 
										$_format_mode = 0;
										$_tmp_str = "";
								} 
						} else {
								$_ord = ord( $_str[$_i] );
								if ( 128 < $_ord ) {
										if ( !$_utf8 ) {
												$_l1 = 2;
												$_l2 = 2;
										} else if ( 192 <= $_ord && $_ord <= 223 ) {
												$_l1 = 2;
												$_l2 = 2;
										} else if ( 224 <= $_ord && $_ord <= 239 ) {
												$_l1 = 3;
												$_l2 = 2;
										} else if ( 240 <= $_ord && $_ord <= 247 ) {
												$_l1 = 4;
												$_l2 = 2;
										} 
								} 
								if ( $_start <= $_j ) {
										$_ret .= substr( $_str, $_i, $_l1 );
										$A += $_l2;
								} 
						} 
						$_i += $_l1;
						$_j += $_l2;
				} 
				if ( $_i < $_len ) {
						$_ret .= $_ellipsis;
				} 
				return $_ret;
		} 
		return saxue_substr( $_str, $_start, $_length, $_ellipsis );
} 

function arithmetic( $str, $opt = "", $val = 0, $front = 0 ) {
		$optary = array( "+", "-", "*", "/", "%" );
		if ( is_numeric( $str ) && is_numeric( $val ) && in_array( $opt, $optary ) ) {
				if ( !$front ) {
						eval( "\$ret = \$str " . $opt . " \$val;" );
						return $ret;
				} 
				eval( "\$ret = \$val " . $opt . " \$str;" );
				return $ret;
		} 
		return $str;
} 

function subdirectory( $_id ) {
		return saxue_getsubdir( $_id );
} 

function defaultval( $_str, $_val ) {
		if ( isset( $_str, $_str ) || is_array( $_str ) && count( $_str ) == 0 ) {
				$_str = $_val;
		} 
		return $_str;
} 

function saxue_banner( $id ) {
		include_once SAXUE_ROOT_PATH . "/common/banner.php";
		return get_banner( $id );
}

function saxue_get_eloop( $blockconfig ) {
		if ( 'BlockSystemCustom' == $blockconfig['classname'] ) {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/block_custom.php";
				$blockconfig['custom'] = 1;
				$blockconfig['contenttype'] = SAXUE_CONTENT_HTML;
				$blockconfig['hasvars'] = 0;
		} elseif ( 'BlockSystemSql' == $blockconfig['classname'] ) {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/block_sql.php";
				$blockconfig['custom'] = 0;
				$blockconfig['contenttype'] = SAXUE_CONTENT_PHP;
				$blockconfig['hasvars'] = 1;
		} else {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/" . trim( $blockconfig['filename'] ) . ".php";
				$blockconfig['custom'] = 0;
				$blockconfig['contenttype'] = SAXUE_CONTENT_PHP;
				$blockconfig['hasvars'] = 1;
		} 
		$blockfile = @realpath( $blockfile );
		if ( is_file( $blockfile ) && preg_match( "/blocks[\\/\\\\]block_\\w+\\.php\$/i", $blockfile ) ) {
				include_once( $blockfile );
				$saxueBlock = new $blockconfig['classname']( $blockconfig );
				$rows = $saxueBlock -> setcontent( true );
				return $rows;
		} else {
				return false;
		} 
}

function saxue_get_block( $blockconfig, $retflag = 0 ) {
		global $saxueTpl;
		global $saxueCache;
		if ( !is_object( $saxueTpl ) ) {
				include_once( SAXUE_ROOT_PATH . "/lib/template/template.php" );
				$saxueTpl = &saxuetpl :: getinstance();
		}
		$blockret = array();
		if ( 'BlockSystemCustom' == $blockconfig['classname'] ) {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/block_custom.php";
				$blockconfig['custom'] = 1;
				$blockconfig['contenttype'] = SAXUE_CONTENT_HTML;
				$blockconfig['hasvars'] = 0;
		} elseif ( 'BlockSystemSql' == $blockconfig['classname'] ) {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/block_sql.php";
				$blockconfig['custom'] = 0;
				$blockconfig['contenttype'] = SAXUE_CONTENT_PHP;
				$blockconfig['hasvars'] = 1;
		} else {
				$blockfile = SAXUE_ROOT_PATH . "/blocks/" . trim( $blockconfig['filename'] ) . ".php";
				$blockconfig['custom'] = 0;
				$blockconfig['contenttype'] = SAXUE_CONTENT_PHP;
				$blockconfig['hasvars'] = 1;
		} 
		$usecache = false;
		if ( $blockconfig['contenttype'] != SAXUE_CONTENT_PHP && empty( $blockconfig['hasvars'] ) ) {
				if ( 0 < $blockconfig['custom'] ) {
						$templatefile = empty( $blockconfig['bid'] ) ? $blockconfig['filename'] . ".html" : "block_custom" . $blockconfig['bid'] . ".html";
				} else {
						$templatefile = empty( $blockconfig['template'] ) ? $blockconfig['filename'] . ".html" : $blockconfig['template'];
				} 
				$templatefile = SAXUE_THEME_PATH . '/blocks/' . $templatefile;
				$cachefile = str_replace( SAXUE_ROOT_PATH, SAXUE_CACHE_PATH, $templatefile );
				if ( $saxueCache -> iscached( $cachefile ) ) {
						$usecache = true;
				} 
		} 
		if ( $usecache ) {
				$blockret = array( "title" => $blockconfig['title'], "content" => $saxueCache -> get( $cachefile ) );
		} else {
				$blockfile = @realpath( $blockfile );
				if ( is_file( $blockfile ) && preg_match( "/blocks[\\/\\\\]block_\\w+\\.php\$/i", $blockfile ) ) {
						$tpl_bak_vars = $saxueTpl -> get_all_assign();
						$tpl_bak_caching = $saxueTpl -> getcaching();
						$tpl_bak_cachetime = $saxueTpl -> getcachetime();
						$tpl_bak_overtime = $saxueTpl -> getovertime();
						include_once( $blockfile );
						$saxueBlock = new $blockconfig['classname']( $blockconfig );
						$blockret = array( "title" => $saxueBlock -> gettitle(), "content" => $saxueBlock -> getcontent() );
						$saxueTpl -> set_all_assign( $tpl_bak_vars );
						$saxueTpl -> setcaching( $tpl_bak_caching );
						$saxueTpl -> setcachetime( $tpl_bak_cachetime );
						$saxueTpl -> setovertime( $tpl_bak_overtime );
				} else {
						return false;
				} 
		} 
		if ( $retflag == 1 ) {
				return $blockret['content'];
		} 
		if ( $retflag == 2 ) {
				return $blockret['title'];
		} 
		return $blockret;
}

if ( !defined( "TEMPLATE_DIR" ) ) {
		define( "TEMPLATE_DIR", dirname( __FILE__ ) . "/" );
} 
$saxueTset = array();
