<?php
class imageresize extends saxueobject {
		public $_img;
		public $_imagetype;
		public $_width;
		public $_height;

		function load( $img_name, $img_type = "" ) {
				if ( !empty( $img_type ) ) {
						$this -> _imagetype = $img_type;
				} else {
						$this -> _imagetype = $this -> get_type( $img_name );
				} 
				switch ( $this -> _imagetype ) {
						case "gif" :
								if ( function_exists( "imagecreatefromgif" ) ) {
										$this -> _img = imagecreatefromgif( $img_name );
								} 
								break;
						case "jpg" :
						case "jpeg" :
								$this -> _img = imagecreatefromjpeg( $img_name );
								break;
						case "png" :
								$this -> _img = imagecreatefrompng( $img_name );
								break;
						default :
								$this -> _img = imagecreatefromstring( $img_name );
				} 
				$this -> getxy();
		} 

		function resize( $_width, $_height, $_scale = 0 ) {
				if ( !is_resource( $this -> _img ) ) {
						return false;
				}
				if ( $this -> _width < $_width ) {
						$_width = $this -> _width;
				} 
				if ( $this -> _height < $_height ) {
						$_height = $this -> _height;
				} 
				if ( empty( $_width ) && empty( $_height ) ) {
						if ( empty( $_scale ) ) {
								return false;
						} 
						$_width = round( $this -> _width * $_scale );
						$_height = round( $this -> _height * $_scale );
				} else if ( empty( $_width ) && !empty( $_height ) ) {
						$_width = round( $_height * $this -> _width / $this -> _height );
				} else if ( empty( $_height ) && !empty( $_width ) ) {
						$_height = round( $_width * $this -> _height / $this -> _width );
				} else if ( 0 <= $_scale ) {
						$_w = $_width / $this -> _width;
						$_h = $_height / $this -> _height;
						if ( $_h < $_w ) {
								$_height = round( $this -> _height * $_w );
						} else if ( $_w < $_h ) {
								$_width = round( $this -> _width * $_h );
						} 
				} 
				$_image = imagecreatetruecolor( $_width, $_height );
				if ( function_exists( "imagecopyresampled" ) ) {
						imagecopyresampled( $_image, $this -> _img, 0, 0, 0, 0, $_width, $_height, $this -> _width, $this -> _height );
				} else {
						imagecopyresized( $_image, $this -> _img, 0, 0, 0, 0, $_width, $_height, $this -> _width, $this -> _height );
				} 
				$this -> destroy();
				$this -> _img = $_image;
				$this -> getxy();
		} 

		function cut( $_width, $_height, $_x = 0, $_y = 0 ) {
				if ( !is_resource( $this -> _img ) ) {
						return false;
				} 
				if ( $this -> _width < $_width ) {
						$_width = $this -> _width;
				} else {
						$_x = round( ( $this -> _width - $_width ) / 2 );
				} 
				if ( $this -> _height < $_height ) {
						$_height = $this -> _height;
				} else {
						$_y = round( ( $this -> _height - $_height ) / 2 );
				} 
				if ( $_x < 0 ) {
						$_x = 0;
				} 
				if ( $_y < 0 ) {
						$_y = 0;
				} 
				$_image = imagecreatetruecolor( $_width, $_height );
				imagecopy( $_image, $this -> _img, 0, 0, $_x, $_y, $_width, $_height );
				$this -> destroy();
				$this -> _img = $_image;
				$this -> getxy();
		} 

		function display( $destroy = true ) {
				if ( !is_resource( $this -> _img ) ) {
						return false;
				} 
				switch ( $this -> _imagetype ) {
						case "jpg" :
						case "jpeg" :
								header( "Content-type: image/jpeg" );
								imagejpeg( $this -> _img );
								break;
						case "gif" :
								header( "Content-type: image/gif" );
								imagegif( $this -> _img );
								break;
						case "png" :
								header( "Content-type: image/png" );
								imagepng( $this -> _img );
				} 
				if ( $destroy ) {
						$this -> destroy();
				} 
		} 

		function save( $fname, $destroy = false, $type = "" ) {
				if ( !is_resource( $this -> _img ) ) {
						return false;
				} 
				if ( empty( $type ) ) {
						$type = $this -> get_type( $fname, false );
				} 
				switch ( $type ) {
						case "jpg" :
						case "jpeg" :
								$ret = imagejpeg( $this -> _img, $fname );
								break;
						case "gif" :
								$ret = imagegif( $this -> _img, $fname );
								break;
						case "png" :
								$ret = imagepng( $this -> _img, $fname );
				} 
				if ( $destroy ) {
						$this -> destroy();
				} 
				return $ret;
		} 

		function destroy() {
				if ( is_resource( $this -> _img ) ) {
						imagedestroy( $this -> _img );
				} 
		} 

		function getxy() {
				if ( is_resource( $this -> _img ) ) {
						$this -> _width = imagesx( $this -> _img );
						$this -> _height = imagesy( $this -> _img );
				} 
		} 

		function get_type( $img_name, $check = true ) {
				$type = "string";
				if ( $check && is_file( $img_name ) ) {
						$ret = getimagesize( $img_name );
						if ( is_array( $ret ) ) {
								switch ( $ret[2] ) {
										case 1:
												$type = "gif";
												break;
										case 2:
												$type = "jpg";
												break;
										case 3:
												$type = "png";
												break;
										case 6:
												$type = "bmp";
												break;
								} 
						} 
				} else if ( preg_match( "/\.(jpg|jpeg|gif|png|bmp)$/i", $img_name, $matches ) ) {
						$type = strtolower( $matches[1] );
				} 
				return $type;
		} 
} 
