<?php
saxue_includedb();
class saxueattachs extends saxueobjectdata {
		function saxueattachs() {
				$this -> initvar( "attachid", SAXUE_TYPE_INT, 0, "附件序号", false, 11 );
				$this -> initvar( "aid", SAXUE_TYPE_INT, 0, "文章ID", false, 11 );
				$this -> initvar( "filepath", SAXUE_TYPE_TXTBOX, "", "附件路径", false, 200 );
				$this -> initvar( "fileurl", SAXUE_TYPE_TXTBOX, "", "访问URL", false, 200 );
				$this -> initvar( "savein", SAXUE_TYPE_TXTBOX, "local", "保存位置", false, 10 );
				$this -> initvar( "timeline", SAXUE_TYPE_INT, 0, "时间戳", false, 10 );
		} 
} 

class saxueattachshandler extends saxueobjecthandler {
		function saxueattachshandler( $_db = "" ) {
				$this -> saxueobjecthandler( $_db );
				$this -> basename = "attachs";
				$this -> autoid = "attachid";
				$this -> dbname = "attachs";
		} 

		function updateattachs( $_aid, $_timeline ) {
				$_aid = intval( $_aid );
				$_timeline = intval( $_timeline );
				if ( empty( $_aid ) || empty( $_timeline ) ) {
						return false;
				} 
				$_sql = 'UPDATE ' . saxue_dbprefix( $this -> dbname ) . ' SET aid=' . $_aid . ' WHERE aid=0 AND timeline=' . $_timeline;
				$this -> db -> query( $_sql );
				return true;
		} 

		//按文章ID删除
		function delarticle( $_aid ) {
				$_aid = intval( $_aid );
				$_sql = 'SELECT * FROM ' . saxue_dbprefix( $this -> dbname ) . ' WHERE aid=' . $_aid;
				$_res = $this -> db -> query( $_sql );
				$_objects = array();
				while ( $v = $this -> db -> fetcharray( $_res ) ) {
						switch ( $v['savein'] ) {
								case 'local':
								case 'ftp':
										saxue_delfile( $v['filepath'] );
										break;
								case 'oss':
										$_objects[] = $v['filepath'];
										break;
						}
				} 
				if ( count( $_objects ) > 0 ) {
						global $oss_sdk_service;
						if ( !is_object( $oss_sdk_service ) ) {
								include_once SAXUE_ROOT_PATH . '/aliyun/oss_php52/sdk.class.php';
						}
						$ret = saxue_oss_del_objects( $_objects );
						if ( !$ret['flag'] ) {
								error_log( date( 'H:i:s' ) . '| delarticle: ' . $ret['msg'] . "\r\n\r\n", 3, SAXUE_ROOT_PATH . '/aliyun/oss_php52/logs/' . date( 'Ymd' ) . '.txt' );
						}
				}
				$_sql = 'DELETE FROM ' . saxue_dbprefix( $this -> dbname ) . ' WHERE aid=' . $_aid;
				$this -> db -> query( $_sql );
				return true;
		} 

		//按附件ID删除
		function delattachs( $_ids ) {
				if ( !is_array( $_ids ) || count( $_ids ) == 0 ) {
						return false;
				} 
				$_sql = 'SELECT * FROM ' . saxue_dbprefix( $this -> dbname ) . ' WHERE attachid IN(' . implode( ',', $_ids ) . ')';
				$_res = $this -> db -> query( $_sql );
				$_objects = array();
				while ( $v = $this -> db -> fetcharray( $_res ) ) {
						switch ( $v['savein'] ) {
								case 'local':
								case 'ftp':
										saxue_delfile( $v['filepath'] );
										break;
								case 'oss':
										$_objects[] = $v['filepath'];
						}
				} 
				if ( count( $_objects ) > 0 ) {
						global $oss_sdk_service;
						if ( !is_object( $oss_sdk_service ) ) {
								include_once SAXUE_ROOT_PATH . '/aliyun/oss_php52/sdk.class.php';
						}
						$ret = saxue_oss_del_objects( $_objects );
						if ( !$ret['flag'] ) {
								error_log( date( 'H:i:s' ) . '| delarticle: ' . $ret['msg'] . "\r\n\r\n", 3, SAXUE_ROOT_PATH . '/aliyun/oss_php52/logs/' . date( 'Ymd' ) . '.txt' );
						}
				}
				$_sql = 'DELETE FROM ' . saxue_dbprefix( $this -> dbname ) . ' WHERE attachid IN(' . implode( ',', $_ids ) . ')';
				$this -> db -> query( $_sql );
				return true;
		} 
}