<?php
saxue_includedb();
class saxuememberoauth extends saxueobjectdata {
		function saxuememberoauth() { 
				$this -> initvar( "oid", SAXUE_TYPE_INT, 0, "序号", false, 11 );
				$this -> initvar( "uid", SAXUE_TYPE_INT, 0, "会员ID", false, 11 );
				$this -> initvar( "site", SAXUE_TYPE_TXTBOX, "", "接口标识", false, 10 );
				$this -> initvar( "openid", SAXUE_TYPE_TXTBOX, "", "OPENID", false, 32 );
				$this -> initvar( "nickname", SAXUE_TYPE_TXTBOX, "", "昵称", false, 100 );
				$this -> initvar( "avatar", SAXUE_TYPE_TXTBOX, "", "头像", false, 255 );
				$this -> initvar( "url", SAXUE_TYPE_TXTBOX, "", "会员主页", false, 255 );
				$this -> initvar( "logintimes", SAXUE_TYPE_INT, 0, "登录次数", false, 10 );
				$this -> initvar( "logintime", SAXUE_TYPE_INT, 0, "最后登录", false, 10 );
				$this -> initvar( "addtime", SAXUE_TYPE_INT, 0, "绑定时间", false, 10 );
		} 
} 

class saxuememberoauthhandler extends saxueobjecthandler {
		function saxuememberoauthhandler( $_db = "" ) {
				$this -> saxueobjecthandler( $_db );
				$this -> basename = "memberoauth";
				$this -> autoid = "oid";
				$this -> dbname = "member_oauth";
		} 

		function getoauth( $uid, $site ) {
				$uid = intval( $uid );
				if ( !empty( $uid ) && !empty( $site ) ) {
						$site = saxue_dbslashes( $site );
						$sql = "SELECT * FROM " . saxue_dbprefix( $this -> dbname ) . " WHERE uid=" . $uid . " AND site='" . $site . "'";
						if ( !( $result = $this -> db -> query( $sql ) ) ) {
								return false;
						} 
						$numrows = $this -> db -> getrowsnum( $result );
						if ( 1 <= $numrows ) {
								$tmpvar = "Saxue" . ucfirst( $this -> basename );
								${$this->basename} = new $tmpvar();
								${$this->basename} -> setvars( $this -> db -> fetcharray( $result ) );
								return ${$this->basename};
						} 
				} 
				return false;
		} 

		function getuser( $openid, $site ) {
				if ( !empty( $openid ) && !empty( $site ) ) {
						$openid = saxue_dbslashes( $openid );
						$site = saxue_dbslashes( $site );
						$sql = "SELECT * FROM " . saxue_dbprefix( $this -> dbname ) . " WHERE openid='" . $openid . "' AND site='" . $site . "'";
						if ( !( $result = $this -> db -> query( $sql ) ) ) {
								return false;
						} 
						$numrows = $this -> db -> getrowsnum( $result );
						if ( 1 <= $numrows ) {
								$tmpvar = "Saxue" . ucfirst( $this -> basename );
								${$this->basename} = new $tmpvar();
								${$this->basename} -> setvars( $this -> db -> fetcharray( $result ) );
								return ${$this->basename};
						} 
				} 
				return false;
		} 

		function updateoauth( $oid ) {
				if ( empty( $oid ) || !is_numeric( $oid ) ) {
						return false;
				} 
				$_sql = "UPDATE " . saxue_dbprefix( $this -> dbname ) . " SET logintimes=logintimes+1,logintime=" . SAXUE_NOW_TIME . " WHERE oid=" . $oid;
				$this -> db -> query( $_sql );
				return true;
		} 

		function bindopenid( $site, $info ) {
				if ( empty( $site ) || empty( $info['openid'] ) ) {
						return false;
				} 
				$sql = "INSERT INTO " . saxue_dbprefix( $this -> dbname ) . " (uid,site,openid,logintimes,logintime,addtime,nickname,avatar,url) VALUES (0,'" . $site . "','" . $info['openid'] . "',1," . SAXUE_NOW_TIME . "," . SAXUE_NOW_TIME . ",'" . $info['nickname'] . "','" . $info['avatar'] . "','" . $info['url'] . "')";
				$result = $this -> db -> query( $sql );
				if ( !$result ) {
						return false;
				} 
				return $this -> db -> getinsertid();
		}

		function bind( $uid, $site, $info ) {
				$uid = intval( $uid );
				if ( empty( $uid ) || empty( $site ) || empty( $info['openid'] ) ) {
						return false;
				} 
				$sql = "UPDATE " . saxue_dbprefix( $this -> dbname ) . " SET uid=" . $uid . " WHERE site='" . $site . "' AND openid='" . $info['openid'] . "'";
				$result = $this -> db -> query( $sql );
				if ( !$result ) {
						return false;
				} 
				return true;
		} 

		function unbind( $oid ) {
				if ( empty( $oid ) ) {
						return false;
				} 
				if ( is_array( $oid ) ) {
						$sql = "DELETE FROM " . saxue_dbprefix( $this -> dbname ) . " WHERE oid IN(" . implode( ',', $oid ) . ")";
				} elseif ( is_numeric( $oid ) ) {
						$sql = "DELETE FROM " . saxue_dbprefix( $this -> dbname ) . " WHERE oid=" . $oid;
				} else {
						return false;
				} 
				$result = $this -> db -> query( $sql );
				if ( !$result ) {
						return false;
				} 
				return true;
		} 
}