<?php
function saxue_xmltext( $text ){
		$entities = array("&" => "&amp;", "<" => "&lt;", ">" => "&gt;", "'" => "&apos;", '"' => "&quot;");
		$text = strtr( $text, $entities );
		$text = preg_replace( "/[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]/", '', $text );
		return $text;
}
if ( !defined( "SAXUE_CORE_INCLUDE" ) ) {
		include "../core.php";
} 
if ( !empty( $_REQUEST['apipass'] ) ) {
		if ( $_REQUEST['apipass'] != SAXUE_API_PASS ) die();
} else {
		saxue_checkpower( 'maps' );
}
saxue_getfilevars( "mapset" );
if ( !isset( $saxueMapset ) || !is_array( $saxueMapset ) ) {
		$saxueMapset = array( );
}
if ( !isset( $_REQUEST['action'] ) ) $_REQUEST['action'] = '';
switch ( $_REQUEST['action'] ) {
		case 'sitemap':
				saxue_getconfigs( 'cate', 'article' );
				saxue_getconfigs( 'cate', 'topic' );
				$caterows = array();
				foreach ( $saxueCate['article'] as $cid => $v ) {
						if ( $v['pid'] == 0 ) $caterows[$cid] = $v;
				}
				foreach ( $saxueCate['article'] as $cid => $v ) {
						if ( $v['pid'] && isset( $caterows[$v['pid']] ) ) $caterows[$v['pid']]['subcate'][$cid] = $v;
				}
				include SAXUE_ROOT_PATH . '/lib/template/template.php';
				$saxueTpl = &saxuetpl :: getinstance();
				$saxueTpl -> setcaching( 0 );
				saxue_getconfigs( 'channel' );
				$saxueTpl -> assign_by_ref( "channel", $saxueChannel );
				$saxueTpl -> assign_by_ref( "caterows", $caterows );
				$saxueTpl -> assign_by_ref( "catetopic", $saxueCate['topic'] );
				$template = SAXUE_THEME_PATH . '/maps/sitemap.html';
				if ( isset( $_REQUEST['preview'] ) ) {
						$saxueTpl -> display( $template );
						exit;
				} else {
						$filepath = saxue_htmlstr( trim( $_POST['filepath'] ) );
						if ( strlen( $filepath ) == 0 || $filepath[0] != '/' || substr( $filepath, -5 ) != '.html' ) {
								saxue_printfail( '文件位置格式错误' );
						}
						$saxueMapset['sitemap']['filepath'] = $filepath;
						$filepath = SAXUE_WEB_PATH . $filepath;
						saxue_checkdir( dirname( $filepath ), true );
						saxue_writefile( $filepath, $saxueTpl -> fetch( $template ) );
				}
				break;
		case 'rssmap':
				saxue_getconfigs( 'cate', 'article' );
				$caterows = array();
				foreach ( $saxueCate['article'] as $cid => $v ) {
						if ( $v['pid'] == 0 ) $caterows[$cid] = $v;
				}
				foreach ( $saxueCate['article'] as $cid => $v ) {
						if ( $v['pid'] && isset( $caterows[$v['pid']] ) ) $caterows[$v['pid']]['subcate'][$cid] = $v;
				}
				include SAXUE_ROOT_PATH . '/lib/template/template.php';
				$saxueTpl = &saxuetpl :: getinstance();
				$saxueTpl -> setcaching( 0 );
				saxue_getconfigs( 'channel' );
				$saxueTpl -> assign_by_ref( "channel", $saxueChannel );
				$saxueTpl -> assign_by_ref( "caterows", $caterows );
				$template = SAXUE_THEME_PATH . '/maps/rssmap.html';
				if ( isset( $_REQUEST['preview'] ) ) {
						$saxueTpl -> display( $template );
						exit;
				} else {
						$filepath = saxue_htmlstr( trim( $_POST['filepath'] ) );
						if ( strlen( $filepath ) == 0 || $filepath[0] != '/' || substr( $filepath, -5 ) != '.html' ) {
								saxue_printfail( '文件位置格式错误' );
						}
						$saxueMapset['rssmap']['filepath'] = $filepath;
						$filepath = SAXUE_WEB_PATH . $filepath;
						saxue_checkdir( dirname( $filepath ), true );
						saxue_writefile( $filepath, $saxueTpl -> fetch( $template ) );
				}
				break;
		case 'rss':
				if ( !isset( $_REQUEST['preview'] ) ) {
						$filepath = saxue_htmlstr( trim( $_REQUEST['filepath'] ) );
						if ( strlen( $filepath ) == 0 || $filepath[0] != '/' || substr( $filepath, -1 ) != '/' ) {
								saxue_printfail( '文件目录格式错误' );
						}
						$saxueMapset['rss']['filepath'] = $filepath;
						saxue_checkdir( SAXUE_WEB_PATH . $filepath, true );
				}
				$items = intval( $_REQUEST['items'] );
				if ( $items <= 0 ) $items = 50;
				$saxueMapset['rss']['items'] = $items;
				saxue_getconfigs( 'cate', 'article' );
				include SAXUE_ROOT_PATH . '/lib/template/template.php';
				$saxueTpl = &saxuetpl :: getinstance();
				$saxueTpl -> setcaching( 0 );
				$saxueTpl -> assign( "rssheader", '<?xml version="1.0" encoding="UTF-8" ?>' );
				$template = SAXUE_THEME_PATH . '/maps/rss.html';
				include SAXUE_ROOT_PATH . "/model/article.php";
				$article_handler = &saxuearticlehandler :: getinstance( "saxuearticlehandler" );
				foreach ( $saxueCate['article'] as $cid => $v ) {
						if ( $saxueCate['article'][$cid]['child'] ) {
								$criteria = new criteriacompo( new criteria( 'pid', $cid ) );
						} else {
								$criteria = new criteriacompo( new criteria( 'cid', $cid ) );
						} 
						$criteria -> add( new criteria( 'status', 1 ) );
						$criteria -> setsort( "aid" );
						$criteria -> setorder( "DESC" );
						$criteria -> setlimit( $items );
						$article_handler -> queryobjects( $criteria );
						$rows = $tables = array();
						while ( $v = $article_handler -> getobject() ) {
								$k = $v -> getvar( 'aid' );
								$rows[$k] = $v -> getvars( 'n' );
								$rows[$k]['atomtime'] = date( DATE_ATOM, $rows[$k]['addtime'] );
								$rows[$k]['cname'] = $saxueCate['article'][$rows[$k]['cid']]['cname'];
								$rows[$k]['curl'] = SAXUE_URL . $saxueCate['article'][$rows[$k]['cid']]['curl'];
								$tables[$rows[$k]['tbnum']][] = $k;
						}  
						if ( count( $tables ) > 0 ) {
								foreach ( $tables as $tbnum => $ids  ) {
										$_res = $article_handler -> db -> query( "SELECT * FROM " . saxue_dbprefix( 'article_data_' . $tbnum ) . " WHERE aid IN (" . implode( ',', $ids ) . ")" );
										while ( $v = $article_handler -> getobject( $_res ) ) {
												$k = $v -> getvar( 'aid' );
												$rows[$k] = $rows[$k] + ( $v -> getvars( 'n' ) );
												$rows[$k]['url'] = SAXUE_URL . $rows[$k]['url'];
												$rows[$k]['intro'] = saxue_xmltext( $rows[$k]['intro'] );
												$rows[$k]['uname'] = saxue_xmltext( $rows[$k]['uname'] );
												$rows[$k]['author'] = saxue_xmltext( $rows[$k]['author'] );
										} 
								} 
						}
						$saxueTpl -> assign_by_ref( "rows", $rows );
						$saxueTpl -> assign( "cname", $saxueCate['article'][$cid]['cname'] );
						$saxueTpl -> assign( "curl", SAXUE_URL . $saxueCate['article'][$cid]['curl'] );
						if ( isset( $_REQUEST['preview'] ) ) {
								$saxueTpl -> display( $template );
								exit;
						} 
						$filename = SAXUE_WEB_PATH . $filepath . $cid . '.xml';
						saxue_writefile( $filename, $saxueTpl -> fetch( $template ) );
				}
				break;
		case 'baidumap':
				// 提取生成参数
				$mode = trim( $_REQUEST['mode'] );
				if ( !in_array( $mode, array( 'update', 'new' ) ) ) {
						saxue_printfail( '请选择“生成方式”' );
				}
				$pcagent = intval( $_REQUEST['pcagent'] );
				$mobileagent = intval( $_REQUEST['mobileagent'] );
				if ( !$pcagent && !$mobileagent ) {
						saxue_printfail( '请选择“提取URL”' );
				}
				$filepath = saxue_htmlstr( trim( $_REQUEST['filepath'] ) );
				if ( strlen( $filepath ) == 0 || $filepath[0] != '/' || substr( $filepath, -1 ) != '/' ) {
						saxue_printfail( '文件目录格式错误' );
				}
				saxue_checkdir( SAXUE_WEB_PATH . $filepath, true );
				$items = intval( $_REQUEST['items'] );
				if ( $items <= 0 ) $items = 2000;
				$saxueMapset['baidumap']['filepath'] = $filepath;
				$saxueMapset['baidumap']['items'] = $items;
				$saxueMapset['baidumap']['pcagent'] = $pcagent;
				$saxueMapset['baidumap']['mobileagent'] = $mobileagent;
				
				include SAXUE_ROOT_PATH . '/lib/template/template.php';
				$saxueTpl = &saxuetpl :: getinstance();
				$saxueTpl -> setcaching( 0 );
				$saxueTpl -> assign( "rssheader", '<?xml version="1.0" encoding="UTF-8" ?>' );
				include SAXUE_ROOT_PATH . "/model/article.php";
				$article_handler = &saxuearticlehandler :: getinstance( "saxuearticlehandler" );
				$totalpage = intval( $_REQUEST['totalpage'] );
				$page = intval( $_REQUEST['page'] );
				if ( $totalpage == 0 || $page == 0 ) {
						// 生成Index.xml
						$rowcount = $article_handler -> getcount( new criteria( 'status', 1 ) );
						$pages = ceil( $rowcount / $items );
						$page = 0;
						if ( $mode == 'update' ) {
								$page = intval( $saxueMapset['baidumap']['pages'] );
						}
						$rows = array();
						for ( $p = 1; $p <= $pages; $p++ ) {
								$file = SAXUE_WEB_PATH . $filepath . $p . '.xml';
								$lastmod = 0;
								if ( $mode == 'update' && $p < $page && is_file( $file ) ) {
										$lastmod = filemtime ( $file );
								}
								if ( $lastmod ) {
										$rows[$p]['lastmod'] = date( 'Y-m-d', $lastmod );
								} else {
										$rows[$p]['lastmod'] = date( 'Y-m-d' );
								}
								$rows[$p]['url'] = SAXUE_URL . $filepath . $p . '.xml';
						}
						$saxueTpl -> assign_by_ref( "rows", $rows );
						$template = SAXUE_THEME_PATH . '/maps/baidu_index.html';
						saxue_writefile( SAXUE_WEB_PATH . $filepath . 'index.xml', $saxueTpl -> fetch( $template ) );
						if ( !$page ) $page = 1;
						$url = 'maps.php?action=baidumap&mode=' . $mode . '&pcagent=' . $pcagent . '&mobileagent=' . $mobileagent . '&filepath=' . $filepath . '&items=' . $items . '&totalpage=' . $pages . '&page=' . $page . '&apipass=' . SAXUE_API_PASS;
						if ( isset( $_REQUEST['robot'] ) ) {
								header( 'Location: ' . SAXUE_ADMIN_URL . '/' . $url . '&robot=1' );
								exit;
						}
						saxue_jumppage( $url, '百度Sitemap索引生成完成，开始生成数据XML' );
				} else {
						$criteria = new criteriacompo( new criteria( 'status', 1 ) );
						$criteria -> setsort( "aid" );
						$criteria -> setorder( "ASC" );
						$criteria -> setlimit( $items );
						$criteria -> setstart( ( $page - 1 ) * $items );
						$article_handler -> queryobjects( $criteria );
						$rows = $tables = array();
						while ( $v = $article_handler -> getobject() ) {
								$k = $v -> getvar( 'aid' );
								$rows[$k] = $v -> getvars( 'n' );
								$tables[$rows[$k]['tbnum']][] = $k;
						}  
						if ( count( $tables ) > 0 ) {
								foreach ( $tables as $tbnum => $ids  ) {
										$_res = $article_handler -> db -> query( "SELECT * FROM " . saxue_dbprefix( 'article_data_' . $tbnum ) . " WHERE aid IN (" . implode( ',', $ids ) . ")" );
										while ( $v = $article_handler -> getobject( $_res ) ) {
												$k = $v -> getvar( 'aid' );
												$rows[$k] = $rows[$k] + ( $v -> getvars( 'n' ) );
												$rows[$k]['murl'] = SAXUE_MURL . $rows[$k]['url'];
												$rows[$k]['url'] = SAXUE_URL . $rows[$k]['url'];
										} 
								} 
						}
						$saxueTpl -> assign( "pcagent", $pcagent );
						$saxueTpl -> assign( "mobileagent", $mobileagent );
						$saxueTpl -> assign_by_ref( "rows", $rows );
						$template = SAXUE_THEME_PATH . '/maps/baidu_sitemap.html';
						saxue_writefile( SAXUE_WEB_PATH . $filepath . $page . '.xml', $saxueTpl -> fetch( $template ) );
						if ( $page < $totalpage ) {
								++$page;
								$url = 'maps.php?action=baidumap&mode=' . $mode . '&pcagent=' . $pcagent . '&mobileagent=' . $mobileagent . '&filepath=' . $filepath . '&items=' . $items . '&totalpage=' . $totalpage . '&page=' . $page . '&apipass=' . SAXUE_API_PASS;
								if ( isset( $_REQUEST['robot'] ) ) {
										header( 'Location: ' . SAXUE_ADMIN_URL . '/' . $url . '&robot=1' );
										exit;
								}
								saxue_jumppage( $url, '开始生成第 ' . $page . ' 页数据XML' );
						}
						$saxueMapset['baidumap']['pages'] = $totalpage;
				}
				break;
		case 'baiducse':
				// 提取生成参数
				$mode = trim( $_REQUEST['mode'] );
				if ( !in_array( $mode, array( 'update', 'new' ) ) ) {
						saxue_printfail( '请选择“生成方式”' );
				}
				$filepath = saxue_htmlstr( trim( $_REQUEST['filepath'] ) );
				if ( strlen( $filepath ) == 0 || $filepath[0] != '/' || substr( $filepath, -1 ) != '/' ) {
						saxue_printfail( '文件目录格式错误' );
				}
				saxue_checkdir( SAXUE_WEB_PATH . $filepath, true );
				$items = intval( $_REQUEST['items'] );
				if ( $items <= 0 ) $items = 2000;
				$saxueMapset['baiducse']['filepath'] = $filepath;
				$saxueMapset['baiducse']['items'] = $items;
				
				include SAXUE_ROOT_PATH . '/lib/template/template.php';
				$saxueTpl = &saxuetpl :: getinstance();
				$saxueTpl -> setcaching( 0 );
				$saxueTpl -> assign( "rssheader", '<?xml version="1.0" encoding="UTF-8" ?>' );
				include SAXUE_ROOT_PATH . "/model/article.php";
				$article_handler = &saxuearticlehandler :: getinstance( "saxuearticlehandler" );
				$totalpage = intval( $_REQUEST['totalpage'] );
				$page = intval( $_REQUEST['page'] );
				if ( $totalpage == 0 || $page == 0 ) {
						// 生成Index.xml
						$rowcount = $article_handler -> getcount( new criteria( 'status', 1 ) );
						$pages = ceil( $rowcount / $items );
						$page = 0;
						if ( $mode == 'update' ) {
								$page = intval( $saxueMapset['baiducse']['pages'] );
						}
						$rows = array();
						for ( $p = 1; $p <= $pages; $p++ ) {
								$file = SAXUE_WEB_PATH . $filepath . $p . '.xml';
								$lastmod = 0;
								if ( $mode == 'update' && $p < $page && is_file( $file ) ) {
										$lastmod = filemtime ( $file );
								}
								if ( $lastmod ) {
										$rows[$p]['lastmod'] = date( 'Y-m-d', $lastmod );
								} else {
										$rows[$p]['lastmod'] = date( 'Y-m-d' );
								}
								$rows[$p]['url'] = SAXUE_URL . $filepath . $p . '.xml';
						}
						$saxueTpl -> assign_by_ref( "rows", $rows );
						$template = SAXUE_THEME_PATH . '/maps/baidu_index.html';
						saxue_writefile( SAXUE_WEB_PATH . $filepath . 'index.xml', $saxueTpl -> fetch( $template ) );
						if ( !$page ) $page = 1;
						$url = 'maps.php?action=baiducse&mode=' . $mode . '&filepath=' . $filepath . '&items=' . $items . '&totalpage=' . $pages . '&page=' . $page . '&apipass=' . SAXUE_API_PASS;
						if ( isset( $_REQUEST['robot'] ) ) {
								header( 'Location: ' . SAXUE_ADMIN_URL . '/' . $url . '&robot=1' );
								exit;
						}
						saxue_jumppage( $url, '百度Sitemap索引生成完成，开始生成数据XML' );
				} else {
						saxue_getconfigs( 'cate', 'article' );
						$criteria = new criteriacompo( new criteria( 'status', 1 ) );
						$criteria -> setsort( "aid" );
						$criteria -> setorder( "ASC" );
						$criteria -> setlimit( $items );
						$criteria -> setstart( ( $page - 1 ) * $items );
						$article_handler -> queryobjects( $criteria );
						$rows = $tables = array();
						while ( $v = $article_handler -> getobject() ) {
								$k = $v -> getvar( 'aid' );
								$rows[$k] = $v -> getvars( 'n' );
								$rows[$k]['pubtime'] = date( 'Y-m-d', $rows[$k]['addtime'] ) . 'T' . date( 'H:i:s', $rows[$k]['addtime'] );
								$rows[$k]['cname'] = saxue_xmltext( $saxueCate['article'][$rows[$k]['cid']]['cname'] );
								$rows[$k]['curl'] = SAXUE_URL . $saxueCate['article'][$rows[$k]['cid']]['curl'];
								if ( $rows[$k]['uid'] > 0 ) {
										$rows[$k]['uhome'] = SAXUE_URL . saxue_geturl( "user_home", $rows[$k]['uid'] );
										$rows[$k]['uavatar'] = saxue_geturl( "user_avatar", $rows[$k]['uid'], 'l' );
										if ( false === stripos( $rows[$k]['uavatar'], 'http://' ) ) $rows[$k]['uavatar'] = SAXUE_URL . $rows[$k]['uavatar'];
								}
								$pid = $saxueCate['article'][$rows[$k]['cid']]['pid'];
								if ( $pid ) {
										$rows[$k]['pid'] = $pid;
										$rows[$k]['pname'] = saxue_xmltext( $saxueCate['article'][$pid]['cname'] );
										$rows[$k]['purl'] = SAXUE_URL . $saxueCate['article'][$pid]['curl'];
								} else {
										$rows[$k]['pid'] = 0;
								}
								$tables[$rows[$k]['tbnum']][] = $k;
						} 
						if ( count( $tables ) > 0 ) {
								foreach ( $tables as $tbnum => $ids  ) {
										$_res = $article_handler -> db -> query( "SELECT * FROM " . saxue_dbprefix( 'article_data_' . $tbnum ) . " WHERE aid IN (" . implode( ',', $ids ) . ")" );
										while ( $v = $article_handler -> getobject( $_res ) ) {
												$k = $v -> getvar( 'aid' );
												$rows[$k] = $rows[$k] + ( $v -> getvars( 'n' ) );
												$rows[$k]['murl'] = SAXUE_MURL . $rows[$k]['url'];
												$rows[$k]['url'] = SAXUE_URL . $rows[$k]['url'];
												$rows[$k]['title'] = saxue_xmltext( $rows[$k]['title'] );
												$rows[$k]['intro'] = saxue_xmltext( trim( $rows[$k]['intro'] ) );
												$rows[$k]['uname'] = saxue_xmltext( $rows[$k]['uname'] );
												$rows[$k]['author'] = saxue_xmltext( $rows[$k]['author'] );
												if ( $rows[$k]['thumb'] != '' && substr( $rows[$k]['thumb'], 0, 7 ) != 'http://' ) {
														$rows[$k]['thumb'] = SAXUE_URL . $rows[$k]['thumb'];
												}
												$_tags = array();
												$_tagnum = 0;
												if ( strlen( $rows[$k]['tags'] ) > 0 ) {
														$_arr = explode( ',', $rows[$k]['tags'] );
														$_arrid = explode( ',', $rows[$k]['tagids'] );
														foreach ( $_arr as $_i => $_s ) {
																$_tags[$_tagnum]['name'] = $_s;
																$_tags[$_tagnum]['url'] = saxue_geturl( "tag_show", $_arrid[$_i] );
																++$_tagnum;
														} 
												}
												$rows[$k]['taglist'] = $_tags;
										} 
								} 
						}
						$saxueTpl -> assign_by_ref( "rows", $rows );
						$template = SAXUE_THEME_PATH . '/maps/baidu_cse.html';
						saxue_writefile( SAXUE_WEB_PATH . $filepath . $page . '.xml', $saxueTpl -> fetch( $template ) );
						if ( $page < $totalpage ) {
								++$page;
								$url = 'maps.php?action=baiducse&mode=' . $mode . '&filepath=' . $filepath . '&items=' . $items . '&totalpage=' . $totalpage . '&page=' . $page . '&apipass=' . SAXUE_API_PASS;
								if ( isset( $_REQUEST['robot'] ) ) {
										header( 'Location: ' . SAXUE_ADMIN_URL . '/' . $url . '&robot=1' );
										exit;
								}
								saxue_jumppage( $url, '开始生成第 ' . $page . ' 页数据XML' );
						}
						$saxueMapset['baiducse']['pages'] = $totalpage;
				}
				break;
		case 'baidutag':
				// 提取生成参数
				$mode = trim( $_REQUEST['mode'] );
				if ( !in_array( $mode, array( 'update', 'new' ) ) ) {
						saxue_printfail( '请选择“生成方式”' );
				}
				$pcagent = intval( $_REQUEST['pcagent'] );
				$mobileagent = intval( $_REQUEST['mobileagent'] );
				if ( !$pcagent && !$mobileagent ) {
						saxue_printfail( '请选择“提取URL”' );
				}
				$filepath = saxue_htmlstr( trim( $_REQUEST['filepath'] ) );
				if ( strlen( $filepath ) == 0 || $filepath[0] != '/' || substr( $filepath, -1 ) != '/' ) {
						saxue_printfail( '文件目录格式错误' );
				}
				saxue_checkdir( SAXUE_WEB_PATH . $filepath, true );
				$items = intval( $_REQUEST['items'] );
				if ( $items <= 0 ) $items = 2000;
				$saxueMapset['baidutag']['filepath'] = $filepath;
				$saxueMapset['baidutag']['items'] = $items;
				$saxueMapset['baidutag']['pcagent'] = $pcagent;
				$saxueMapset['baidutag']['mobileagent'] = $mobileagent;
				
				include SAXUE_ROOT_PATH . '/lib/template/template.php';
				$saxueTpl = &saxuetpl :: getinstance();
				$saxueTpl -> setcaching( 0 );
				$saxueTpl -> assign( "rssheader", '<?xml version="1.0" encoding="UTF-8" ?>' );
				include SAXUE_ROOT_PATH . "/model/tag.php";
				$tag_handler = &saxuetaghandler :: getinstance( "saxuetaghandler" );
				$totalpage = intval( $_REQUEST['totalpage'] );
				$page = intval( $_REQUEST['page'] );
				if ( $totalpage == 0 || $page == 0 ) {
						// 生成Index.xml
						$rowcount = $tag_handler -> getcount();
						$pages = ceil( $rowcount / $items );
						$page = 0;
						if ( $mode == 'update' ) {
								$page = intval( $saxueMapset['baidutag']['pages'] );
						}
						$rows = array();
						for ( $p = 1; $p <= $pages; $p++ ) {
								$file = SAXUE_WEB_PATH . $filepath . $p . '.xml';
								$lastmod = 0;
								if ( $mode == 'update' && $p < $page && is_file( $file ) ) {
										$lastmod = filemtime ( $file );
								}
								if ( $lastmod ) {
										$rows[$p]['lastmod'] = date( 'Y-m-d', $lastmod );
								} else {
										$rows[$p]['lastmod'] = date( 'Y-m-d' );
								}
								$rows[$p]['url'] = SAXUE_URL . $filepath . $p . '.xml';
						}
						$saxueTpl -> assign_by_ref( "rows", $rows );
						$template = SAXUE_THEME_PATH . '/maps/baidu_index.html';
						saxue_writefile( SAXUE_WEB_PATH . $filepath . 'index.xml', $saxueTpl -> fetch( $template ) );
						if ( !$page ) $page = 1;
						$url = 'maps.php?action=baidutag&mode=' . $mode . '&pcagent=' . $pcagent . '&mobileagent=' . $mobileagent . '&filepath=' . $filepath . '&items=' . $items . '&totalpage=' . $pages . '&page=' . $page . '&apipass=' . SAXUE_API_PASS;
						if ( isset( $_REQUEST['robot'] ) ) {
								header( 'Location: ' . SAXUE_ADMIN_URL . '/' . $url . '&robot=1' );
								exit;
						}
						saxue_jumppage( $url, '百度Sitemap索引生成完成，开始生成数据XML' );
				} else {
						$criteria = new criteriacompo();
						$criteria -> setsort( "tagid" );
						$criteria -> setorder( "ASC" );
						$criteria -> setlimit( $items );
						$criteria -> setstart( ( $page - 1 ) * $items );
						$tag_handler -> queryobjects( $criteria );
						$rows = array();
						$k = 0;
						while ( $v = $tag_handler -> getobject() ) {
								$rows[$k] = $v -> getvars( 'n' );
								$rows[$k]['addtime'] = SAXUE_NOW_TIME;
								$url = saxue_geturl( 'tag_show', $rows[$k]['tagid'] );
								$rows[$k]['murl'] = SAXUE_MURL . $url;
								$rows[$k]['url'] = SAXUE_URL . $url;
								++$k;
						}  
						$saxueTpl -> assign( "pcagent", $pcagent );
						$saxueTpl -> assign( "mobileagent", $mobileagent );
						$saxueTpl -> assign_by_ref( "rows", $rows );
						$template = SAXUE_THEME_PATH . '/maps/baidu_sitemap.html';
						saxue_writefile( SAXUE_WEB_PATH . $filepath . $page . '.xml', $saxueTpl -> fetch( $template ) );
						if ( $page < $totalpage ) {
								++$page;
								$url = 'maps.php?action=baidutag&mode=' . $mode . '&pcagent=' . $pcagent . '&mobileagent=' . $mobileagent . '&filepath=' . $filepath . '&items=' . $items . '&totalpage=' . $totalpage . '&page=' . $page . '&apipass=' . SAXUE_API_PASS;
								if ( isset( $_REQUEST['robot'] ) ) {
										header( 'Location: ' . SAXUE_ADMIN_URL . '/' . $url . '&robot=1' );
										exit;
								}
								saxue_jumppage( $url, '开始生成第 ' . $page . ' 页数据XML' );
						}
						$saxueMapset['baidutag']['pages'] = $totalpage;
				}
				break;
}
if ( !empty( $_REQUEST['action'] ) ) {
		saxue_setfilevars( "mapset", $saxueMapset );
		saxue_jumppage( 'maps.php', LANG_DO_SUCCESS );
}
include SAXUE_ADMIN_PATH . "/header.php";
$saxueTpl -> assign( "apipass", SAXUE_API_PASS );
$saxueTpl -> assign_by_ref( "mapset", $saxueMapset );
$saxueTset['saxue_contents_template'] = SAXUE_ADMIN_PATH . "/templates/maps.html";
include SAXUE_ADMIN_PATH . "/footer.php";