DROP TABLE IF EXISTS `saxue_article`;
CREATE TABLE IF NOT EXISTS `saxue_article` (
  `aid` int(11) unsigned NOT NULL auto_increment COMMENT '文章编号',
  `topicid` int(11) unsigned NOT NULL default '0' COMMENT '主题ID',
  `cid` smallint(4) unsigned NOT NULL default '0' COMMENT '分类编号',
  `pid` smallint(4) unsigned NOT NULL default '0' COMMENT '父分类',
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '会员ID',
  `views` int(11) unsigned NOT NULL default '0' COMMENT '浏览次数',
  `downs` int(11) unsigned NOT NULL default '0' COMMENT '下载次数',
  `favs` int(11) unsigned NOT NULL default '0' COMMENT '收藏次数',
  `tops` int(11) unsigned NOT NULL default '0' COMMENT '顶次数',
  `addtime` int(10) unsigned NOT NULL default '0' COMMENT '发布时间',
  `status` tinyint(1) unsigned NOT NULL default '0' COMMENT '文章状态',
  `level` tinyint(1) unsigned NOT NULL default '0' COMMENT '文章级别',
  `isthumb` tinyint(1) unsigned NOT NULL default '0' COMMENT '有无缩略图',
  `ischapter` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否多章节',
  `isslide` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否图集',
  `isrobot` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否采集',
  `tbnum` tinyint(2) unsigned NOT NULL default '1' COMMENT '数据分表',
  PRIMARY KEY  (`aid`),
  KEY `cid` (`cid`),
  KEY `pid` (`pid`),
  KEY `level` (`level`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_article_cate`;
CREATE TABLE IF NOT EXISTS `saxue_article_cate` (
  `cid` smallint(4) unsigned NOT NULL auto_increment COMMENT '分类编号',
  `pid` smallint(4) unsigned NOT NULL default '0' COMMENT '父分类编号',
  `views` int(11) unsigned NOT NULL default '0' COMMENT '访问次数',
  `cname` varchar(20) NOT NULL COMMENT '分类名称',
  `alias` varchar(20) NOT NULL COMMENT '英文别名',
  `pnum` smallint(4) unsigned NOT NULL default '0' COMMENT '列表每页显示',
  `templist` varchar(30) NOT NULL COMMENT '频道/列表模版',
  `tempdetail` varchar(30) NOT NULL COMMENT '内容页模版',
  `tempcatalog` varchar(30) NOT NULL default '' COMMENT '目录页模版',
  `tempchapter` varchar(30) NOT NULL default '' COMMENT '章节页模版',
  `showchannel` tinyint(1) unsigned NOT NULL default '0' COMMENT '显示频道页',
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=70 ;

DROP TABLE IF EXISTS `saxue_article_chapter`;
CREATE TABLE IF NOT EXISTS `saxue_article_chapter` (
  `chapterid` int(11) unsigned NOT NULL auto_increment COMMENT '章节ID',
  `chaptername` char(50) NOT NULL default '' COMMENT '章节标题',
  `chapterorder` smallint(4) unsigned NOT NULL default '0' COMMENT '章节排序',
  `isvolume` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否分卷',
  `aid` int(11) unsigned NOT NULL default '0' COMMENT '文章ID',
  `posttime` int(10) unsigned NOT NULL default '0' COMMENT '章节时间',
  PRIMARY KEY  (`chapterid`),
  KEY `aid` (`aid`),
  KEY `chapterorder` (`chapterorder`),
  KEY `isvolume` (`isvolume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_article_data_1`;
CREATE TABLE IF NOT EXISTS `saxue_article_data_1` (
  `aid` int(11) unsigned NOT NULL default '0' COMMENT '文章编号',
  `preid` int(11) unsigned NOT NULL default '0' COMMENT '上一篇文章ID',
  `nextid` int(11) unsigned NOT NULL default '0' COMMENT '下一篇文章ID',
  `title` varchar(100) NOT NULL default '' COMMENT '文章标题',
  `ftitle` varchar(100) NOT NULL default '' COMMENT '文章副标题',
  `style` char(7) NOT NULL default '' COMMENT '标题颜色',
  `intro` varchar(200) NOT NULL default '' COMMENT '文章简介',
  `tags` varchar(100) NOT NULL default '' COMMENT 'TAG标签',
  `tagids` varchar(100) NOT NULL default '' COMMENT 'TAG标签ID',
  `uname` varchar(30) NOT NULL COMMENT '会员名',
  `author` varchar(30) NOT NULL default '' COMMENT '文章作者',
  `copyfrom` varchar(30) NOT NULL default '' COMMENT '文章来源',
  `fromurl` varchar(100) NOT NULL default '' COMMENT '文章来源URL',
  `url` varchar(100) NOT NULL default '' COMMENT '文章URL',
  `surl` varchar(100) NOT NULL default '' COMMENT '图集URL',
  `thumb` varchar(100) NOT NULL default '' COMMENT '文章缩略图',
  `album` text NOT NULL COMMENT '图集图片',
  UNIQUE KEY `aid` (`aid`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_article_expand`;
CREATE TABLE IF NOT EXISTS `saxue_article_expand` (
  `eid` int(11) unsigned NOT NULL auto_increment COMMENT '序号',
  `name` varchar(30) NOT NULL default '' COMMENT '属性名称',
  `title` varchar(30) NOT NULL default '' COMMENT '属性标题',
  `intro` varchar(100) NOT NULL default '' COMMENT '属性说明',
  `type` tinyint(2) unsigned NOT NULL default '0' COMMENT '属性类型',
  `adminform` text NOT NULL COMMENT '后台表单模版',
  `userform` text NOT NULL COMMENT '前台表单模版',
  `options` text NOT NULL COMMENT '可用选项值',
  `listorder` int(10) unsigned NOT NULL default '0' COMMENT '排序',
  `required` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否必填',
  `cids` text NOT NULL COMMENT '应用于分类',
  PRIMARY KEY  (`eid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_article_report`;
CREATE TABLE IF NOT EXISTS `saxue_article_report` (
  `aid` int(11) unsigned NOT NULL COMMENT '文章ID',
  `reporttype` tinyint(1) unsigned NOT NULL default '0' COMMENT '举报类型',
  `reporttime` int(10) unsigned NOT NULL default '0' COMMENT '举报时间',
  `reporttimes` smallint(4) unsigned NOT NULL default '1' COMMENT '举报次数',
  `url` varchar(255) NOT NULL default '' COMMENT '文章URL',
  `note` text NOT NULL COMMENT '举报说明',
  `ishandle` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否处理',
  `handletime` int(10) unsigned NOT NULL default '0' COMMENT '处理时间',
  UNIQUE KEY `aid` (`aid`),
  KEY `reporttime` (`reporttime`),
  KEY `reporttype` (`reporttype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_attachs`;
CREATE TABLE IF NOT EXISTS `saxue_attachs` (
  `attachid` int(11) unsigned NOT NULL auto_increment COMMENT '附件序号',
  `aid` int(11) unsigned NOT NULL default '0' COMMENT '文章ID',
  `filepath` varchar(200) NOT NULL default '' COMMENT '附件路径',
  `fileurl` varchar(200) NOT NULL default '' COMMENT '访问URL',
  `savein` varchar(10) NOT NULL default 'local' COMMENT '保存位置',
  `timeline` int(10) NOT NULL default '0' COMMENT '时间戳',
  PRIMARY KEY  (`attachid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_friendlink`;
CREATE TABLE IF NOT EXISTS `saxue_friendlink` (
  `linkid` smallint(5) unsigned NOT NULL auto_increment,
  `type` tinyint(1) unsigned NOT NULL default '0',
  `title` varchar(50) NOT NULL,
  `url` varchar(250) NOT NULL,
  `logo` varchar(250) NOT NULL,
  `intro` varchar(250) NOT NULL,
  `contact` varchar(30) NOT NULL,
  `listorder` smallint(4) unsigned NOT NULL default '0',
  `addtime` int(10) unsigned NOT NULL default '0',
  `display` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`linkid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS `saxue_member_account`;
CREATE TABLE IF NOT EXISTS `saxue_member_account` (
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '会员ID',
  `payee` varchar(10) NOT NULL default '' COMMENT '收款人',
  `bank` varchar(10) NOT NULL default '' COMMENT '银行',
  `account` varchar(50) NOT NULL default '' COMMENT '帐号',
  `updatetime` int(10) unsigned NOT NULL default '0' COMMENT '更新日期',
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_member_bill`;
CREATE TABLE IF NOT EXISTS `saxue_member_bill` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '流水号',
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '会员ID',
  `amount` decimal(8,2) unsigned NOT NULL default '0.00' COMMENT '提现金额',
  `applytime` int(10) unsigned NOT NULL default '0' COMMENT '申请日期',
  `paytime` int(10) unsigned NOT NULL default '0' COMMENT '支付日期',
  `status` tinyint(1) unsigned NOT NULL default '0' COMMENT '状态',
  `account` varchar(50) NOT NULL default '' COMMENT '支付帐号',
  `reason` varchar(200) NOT NULL default '' COMMENT '原因备注',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_member_doing`;
CREATE TABLE IF NOT EXISTS `saxue_member_doing` (
  `doid` int(11) unsigned NOT NULL auto_increment COMMENT '序号',
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '会员ID',
  `aid` int(11) unsigned NOT NULL default '0' COMMENT '文章ID',
  `dotime` int(10) unsigned NOT NULL default '0' COMMENT '时间',
  `doing` tinyint(1) unsigned NOT NULL default '0' COMMENT '操作：1发布，2收藏，3推荐，4下载',
  `chapterid` int(11) unsigned NOT NULL default '0' COMMENT '章节ID',
  PRIMARY KEY  (`doid`),
  UNIQUE KEY `do` (`uid`,`doing`,`aid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_member_follow`;
CREATE TABLE IF NOT EXISTS `saxue_member_follow` (
  `fid` int(11) unsigned NOT NULL auto_increment COMMENT '序号',
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '关注人',
  `toid` int(11) unsigned NOT NULL default '0' COMMENT '被关注人',
  `followtime` int(10) unsigned NOT NULL default '0' COMMENT '关注时间',
  PRIMARY KEY  (`fid`),
  UNIQUE KEY `follow` (`uid`,`toid`),
  KEY `toid` (`toid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_member_menu`;
CREATE TABLE IF NOT EXISTS `saxue_member_menu` (
  `menuid` smallint(4) unsigned NOT NULL auto_increment COMMENT '菜单ID',
  `pid` smallint(4) unsigned NOT NULL default '0' COMMENT '上级菜单ID',
  `listorder` smallint(4) unsigned NOT NULL default '0' COMMENT '菜单排序',
  `level` tinyint(1) unsigned NOT NULL default '1' COMMENT '菜单等级',
  `caption` varchar(50) NOT NULL default '' COMMENT '菜单标题',
  `command` varchar(100) NOT NULL default '' COMMENT '菜单链接',
  `display` tinyint(1) unsigned NOT NULL default '1' COMMENT '是否显示',
  PRIMARY KEY  (`menuid`),
  KEY `display` (`display`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

DROP TABLE IF EXISTS `saxue_member_message`;
CREATE TABLE IF NOT EXISTS `saxue_member_message` (
  `messageid` int(11) unsigned NOT NULL auto_increment COMMENT '短信ID',
  `postdate` int(10) NOT NULL default '0' COMMENT '发送时间',
  `fromid` int(11) unsigned NOT NULL default '0' COMMENT '发送人ID',
  `fromname` varchar(20) NOT NULL default '' COMMENT '发送人用户名',
  `toid` int(11) unsigned NOT NULL default '0' COMMENT '接收人ID',
  `toname` varchar(20) NOT NULL default '' COMMENT '接收人用户名',
  `title` varchar(50) NOT NULL default '' COMMENT '短信标题',
  `content` text NOT NULL COMMENT '短信内容',
  `isread` tinyint(1) NOT NULL default '0' COMMENT '是否已读',
  `fromdel` tinyint(1) NOT NULL default '0' COMMENT '发件人删除标识',
  `todel` tinyint(1) NOT NULL default '0' COMMENT '接收人删除标识',
  PRIMARY KEY  (`messageid`),
  KEY `fromid` (`fromid`),
  KEY `toid` (`toid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_member_money`;
CREATE TABLE IF NOT EXISTS `saxue_member_money` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '流水ID',
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '会员ID',
  `amount` decimal(8,2) NOT NULL default '0.00' COMMENT '金钱数额',
  `balance` decimal(8,2) NOT NULL default '0.00' COMMENT '金钱余额',
  `time` int(10) unsigned NOT NULL default '0' COMMENT '流水日期',
  `aid` int(11) unsigned NOT NULL default '0' COMMENT '文章ID',
  `type` smallint(4) unsigned NOT NULL default '0' COMMENT '说明',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_member_oauth`;
CREATE TABLE IF NOT EXISTS `saxue_member_oauth` (
  `oid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '序号',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `site` varchar(10) NOT NULL DEFAULT '' COMMENT '接口标识',
  `openid` varchar(32) NOT NULL DEFAULT '' COMMENT 'OPENID',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '昵称',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '会员主页',
  `logintimes` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `logintime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '绑定时间',
  PRIMARY KEY (`oid`),
  KEY `site` (`site`,`openid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_member_registerip`;
CREATE TABLE IF NOT EXISTS `saxue_member_registerip` (
  `ip` char(15) NOT NULL default '' COMMENT '注册IP',
  `regtime` int(10) unsigned NOT NULL default '0' COMMENT '注册时间',
  `count` smallint(6) unsigned NOT NULL default '0' COMMENT '注册次数',
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_member_score`;
CREATE TABLE IF NOT EXISTS `saxue_member_score` (
  `id` int(11) unsigned NOT NULL auto_increment COMMENT '流水ID',
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '会员ID',
  `amount` int(11) NOT NULL default '0' COMMENT '积分数',
  `balance` int(11) NOT NULL default '0' COMMENT '积分余额',
  `time` int(10) unsigned NOT NULL default '0' COMMENT '流水日期',
  `aid` int(11) unsigned NOT NULL default '0' COMMENT '文章ID',
  `type` smallint(4) unsigned NOT NULL default '0' COMMENT '说明',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_member_userdata`;
CREATE TABLE IF NOT EXISTS `saxue_member_userdata` (
  `uid` int(11) unsigned NOT NULL default '0' COMMENT '会员ID',
  `regtime` int(10) unsigned NOT NULL default '0' COMMENT '注册日期',
  `regip` char(15) NOT NULL COMMENT '注册IP',
  `mobile` char(11) NOT NULL default '' COMMENT '手机',
  `prelogintime` int(10) unsigned NOT NULL default '0' COMMENT '上次登录日期',
  `preloginip` char(15) NOT NULL default '' COMMENT '上次登录IP',
  `logintime` int(10) unsigned NOT NULL default '0' COMMENT '本次登录日期',
  `loginip` char(15) NOT NULL default '' COMMENT '本次登录IP',
  `logintimes` int(8) unsigned NOT NULL default '0' COMMENT '登录次数',
  `gender` tinyint(1) unsigned NOT NULL default '0' COMMENT '性别0未知1男2女',
  `qq` varchar(20) NOT NULL default '' COMMENT 'QQ',
  `msn` varchar(50) NOT NULL default '' COMMENT 'MSN',
  `intro` varchar(150) NOT NULL default '' COMMENT '个人简介',
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_member_users`;
CREATE TABLE IF NOT EXISTS `saxue_member_users` (
  `uid` int(11) unsigned NOT NULL auto_increment COMMENT '会员ID',
  `uname` char(30) NOT NULL default '' COMMENT '会员名',
  `password` char(32) NOT NULL default '' COMMENT '密码',
  `email` char(30) NOT NULL default '' COMMENT '邮箱',
  `status` tinyint(1) unsigned NOT NULL default '1' COMMENT '状态',
  `avatar` tinyint(1) unsigned NOT NULL default '0' COMMENT '有无头像',
  `score` int(11) unsigned NOT NULL default '0' COMMENT '积分',
  `money` decimal(8,2) unsigned NOT NULL default '0.00' COMMENT '金钱',
  `views` int(11) unsigned NOT NULL default '0' COMMENT '访问量',
  `follows` smallint(5) unsigned NOT NULL default '0' COMMENT '关注数',
  `fans` smallint(5) unsigned NOT NULL default '0' COMMENT '粉丝数',
  `isrobot` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否采集',
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `uname` (`uname`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_pages`;
CREATE TABLE IF NOT EXISTS `saxue_pages` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `item` varchar(20) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `content` mediumtext NOT NULL,
  `htmldir` varchar(100) NOT NULL default '',
  `htmlurl` varchar(200) NOT NULL default '',
  `filename` varchar(30) NOT NULL default '',
  `template` varchar(30) NOT NULL default '',
  `mfilename` varchar(30) NOT NULL default '',
  `mtemplate` varchar(30) NOT NULL default '',
  `listorder` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

DROP TABLE IF EXISTS `saxue_plugin`;
CREATE TABLE IF NOT EXISTS `saxue_plugin` (
  `pluginid` smallint(6) unsigned NOT NULL auto_increment,
  `status` tinyint(1) unsigned NOT NULL default '0',
  `name` varchar(20) NOT NULL default '',
  `identifier` varchar(20) NOT NULL default '',
  `intro` varchar(255) NOT NULL default '',
  `dir` varchar(20) NOT NULL default '',
  `author` varchar(20) NOT NULL default '',
  `version` varchar(5) NOT NULL default '',
  `releases` int(8) unsigned NOT NULL default '0',
  `menu` text NOT NULL,
  `isfounder` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`pluginid`),
  UNIQUE KEY `identifier` (`identifier`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_system_admin`;
CREATE TABLE IF NOT EXISTS `saxue_system_admin` (
  `id` smallint(5) NOT NULL auto_increment,
  `account` varchar(20) NOT NULL,
  `password` char(32) NOT NULL,
  `role` smallint(4) unsigned NOT NULL default '0',
  `status` tinyint(1) unsigned NOT NULL default '0',
  `isfounder` tinyint(1) unsigned NOT NULL default '0',
  `lasttime` int(10) unsigned NOT NULL default '0',
  `lastip` char(15) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS `saxue_system_adminmenu`;
CREATE TABLE IF NOT EXISTS `saxue_system_adminmenu` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `pid` smallint(5) unsigned NOT NULL default '0',
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `level` tinyint(1) unsigned NOT NULL default '1',
  `node` varchar(20) NOT NULL default '',
  `caption` varchar(30) NOT NULL default '',
  `command` varchar(100) NOT NULL default '',
  `display` tinyint(1) unsigned NOT NULL default '1',
  `issystem` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=64 ;

DROP TABLE IF EXISTS `saxue_system_blocks`;
CREATE TABLE IF NOT EXISTS `saxue_system_blocks` (
  `bid` smallint(4) unsigned NOT NULL auto_increment,
  `blockname` varchar(50) NOT NULL default '',
  `filename` varchar(50) NOT NULL default '',
  `classname` varchar(50) NOT NULL default '',
  `title` text NOT NULL,
  `description` text NOT NULL,
  `content` mediumtext NOT NULL,
  `vars` text NOT NULL,
  `template` varchar(50) NOT NULL default '',
  `cachetime` int(11) NOT NULL default '0',
  `contenttype` tinyint(3) NOT NULL default '0',
  `custom` tinyint(1) unsigned NOT NULL default '0',
  `canedit` tinyint(1) unsigned NOT NULL default '0',
  `hasvars` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_system_configs`;
CREATE TABLE IF NOT EXISTS `saxue_system_configs` (
  `cid` int(10) unsigned NOT NULL auto_increment,
  `gname` varchar(20) NOT NULL default 'system',
  `cname` varchar(30) NOT NULL default '',
  `ctitle` varchar(50) NOT NULL default '',
  `cvalue` text NOT NULL,
  `cdescription` text NOT NULL,
  `cdefine` tinyint(1) NOT NULL default '0',
  `ctype` tinyint(1) NOT NULL default '0',
  `options` text NOT NULL,
  `catorder` int(10) NOT NULL default '0',
  `catname` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`cid`),
  UNIQUE KEY `group` (`gname`,`cname`),
  KEY `catorder` (`catorder`),
  KEY `cdefine` (`cdefine`),
  KEY `catname` (`catname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=115 ;

DROP TABLE IF EXISTS `saxue_system_roles`;
CREATE TABLE IF NOT EXISTS `saxue_system_roles` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `rolename` varchar(30) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL default '1',
  `note` varchar(200) NOT NULL,
  `power` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_system_session`;
CREATE TABLE IF NOT EXISTS `saxue_system_session` (
  `sess_id` varchar(32) NOT NULL default '',
  `sess_updated` int(11) unsigned NOT NULL default '0',
  `sess_data` text NOT NULL,
  PRIMARY KEY  (`sess_id`),
  KEY `sess_updated` (`sess_updated`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_tag`;
CREATE TABLE IF NOT EXISTS `saxue_tag` (
  `tagid` int(11) unsigned NOT NULL auto_increment COMMENT '标签ID',
  `cid` smallint(4) unsigned NOT NULL default '0' COMMENT 'TAG分类',
  `tagname` char(10) NOT NULL default '' COMMENT 'TAG名',
  `counts` int(10) unsigned NOT NULL default '0' COMMENT '文章总数',
  `views` int(10) unsigned NOT NULL default '0' COMMENT '访问数',
  `isgood` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否推荐',
  PRIMARY KEY  (`tagid`),
  UNIQUE KEY `tagname` (`tagname`),
  KEY `cid` (`cid`),
  KEY `isgood` (`isgood`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_tag_article`;
CREATE TABLE IF NOT EXISTS `saxue_tag_article` (
  `tagid` int(11) unsigned NOT NULL default '0' COMMENT '标签ID',
  `aid` int(11) unsigned NOT NULL default '0' COMMENT '文章ID',
  UNIQUE KEY `tagarticle` (`tagid`,`aid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `saxue_timthumb`;
CREATE TABLE IF NOT EXISTS `saxue_timthumb` (
  `tid` smallint(4) unsigned NOT NULL auto_increment COMMENT '方案序号',
  `tname` varchar(20) NOT NULL default '' COMMENT '方案标识',
  `status` tinyint(1) unsigned NOT NULL default '1' COMMENT '方案是否启用',
  `intro` varchar(100) NOT NULL default '' COMMENT '方案说明',
  `width` smallint(4) unsigned NOT NULL default '0' COMMENT '缩略图宽度',
  `height` smallint(4) unsigned NOT NULL default '0' COMMENT '缩略图高度',
  `quality` tinyint(2) unsigned NOT NULL default '90' COMMENT '缩略图质量',
  `zoomcrop` tinyint(1) unsigned NOT NULL default '1' COMMENT '缩放模式',
  `cutpos` char(2) NOT NULL default 'c' COMMENT '裁剪位置',
  `pngtrans` tinyint(1) unsigned NOT NULL default '1' COMMENT 'PNG是否透明',
  `bgcolor` char(7) NOT NULL default '' COMMENT '背景色',
  PRIMARY KEY  (`tid`),
  UNIQUE KEY `tname` (`tname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_topic`;
CREATE TABLE IF NOT EXISTS `saxue_topic` (
  `topicid` int(11) unsigned NOT NULL auto_increment COMMENT '专题ID',
  `cid` smallint(4) unsigned NOT NULL default '0' COMMENT '分类ID',
  `counts` smallint(4) unsigned NOT NULL default '0' COMMENT '文章数',
  `views` int(11) unsigned NOT NULL default '0' COMMENT '访问数',
  `addtime` int(10) unsigned NOT NULL default '0' COMMENT '添加时间',
  `status` tinyint(1) unsigned NOT NULL default '0' COMMENT '状态',
  `isthumb` tinyint(1) unsigned NOT NULL default '0' COMMENT '有无缩略图',
  `isgood` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否推荐',
  PRIMARY KEY  (`topicid`),
  KEY `cid` (`cid`),
  KEY `isgood` (`isgood`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_topic_cate`;
CREATE TABLE IF NOT EXISTS `saxue_topic_cate` (
  `cid` smallint(4) unsigned NOT NULL auto_increment COMMENT '分类编号',
  `cname` varchar(20) NOT NULL COMMENT '分类名称',
  `alias` varchar(20) NOT NULL COMMENT '英文别名',
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `saxue_topic_data`;
CREATE TABLE IF NOT EXISTS `saxue_topic_data` (
  `topicid` int(11) unsigned NOT NULL default '0' COMMENT '专题ID',
  `title` varchar(50) NOT NULL default '' COMMENT '标题',
  `alias` varchar(30) NOT NULL default '' COMMENT '英文名',
  `temp` varchar(20) NOT NULL default '' COMMENT '模版',
  `pnum` smallint(4) unsigned NOT NULL default '0' COMMENT '每页显示文章',
  `intro` varchar(200) NOT NULL default '' COMMENT '摘要',
  `thumb` varchar(100) NOT NULL default '' COMMENT '缩略图',
  `url` varchar(100) NOT NULL default '' COMMENT 'URL',
  UNIQUE KEY `tid` (`topicid`),
  KEY `title` (`title`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;