<?php
function resetpass( $saxueUsers, $newpass, $repass ) {
		global $saxueConfigs;
		// 密码检查
		if ( strlen( $newpass ) == 0 || strlen( $repass ) == 0 ) {
				exit( json_encode( array( 'flag' => 0, 'msg' => '密码不能为空' ) ) );
		} else if ( $newpass != $repass ) {
				exit( json_encode( array( 'flag' => 0, 'msg' => '密码和重复密码不一致' ) ) );
		} else if ( !empty( $saxueConfigs['member']['regminpwd'] ) && strlen( $newpass ) < intval( $saxueConfigs['member']['regminpwd'] ) ) {
				exit( json_encode( array( 'flag' => 0, 'msg' => '密码长度不能少于' . $saxueConfigs['member']['regminpwd'] . '个字符' ) ) );
		} else if ( !empty( $saxueConfigs['member']['regmaxpwd'] ) && strlen( $newpass ) > intval( $saxueConfigs['member']['regmaxpwd'] ) ) {
				exit( json_encode( array( 'flag' => 0, 'msg' => '密码长度不能大于' . $saxueConfigs['member']['regmaxpwd'] . '个字符' ) ) );
		} else if ( $saxueConfigs['member']['regnpdifferf'] == 1 && $newpass == $saxueUsers -> getvar( 'uname' ) ) {
				exit( json_encode( array( 'flag' => 0, 'msg' => '密码和用户名不能相同' ) ) );
		} 
		// 密码复杂度检查
		if ( !empty( $saxueConfigs['member']['regchrpwd'] ) ) {
				$pwdrule = explode( ',', $saxueConfigs['member']['regchrpwd'] );
				foreach ( $pwdrule as $r ) {
						switch ( intval( $r ) ) {
								case 1:
										if ( !preg_match( "/[a-z]/", $newpass ) ) {
												exit( json_encode( array( 'flag' => 0, 'msg' => '密码中必须包含小写字母' ) ) );
										} 
										break;
								case 2:
										if ( !preg_match( "/[A-Z]/", $newpass ) ) {
												exit( json_encode( array( 'flag' => 0, 'msg' => '密码中必须包含大写字母' ) ) );
										} 
										break;
								case 3:
										if ( !preg_match( "/[0-9]/", $newpass ) ) {
												exit( json_encode( array( 'flag' => 0, 'msg' => '密码中必须包含数字' ) ) );
										} 
										break;
								case 4:
										if ( !preg_match( "/[^a-zA-Z0-9]/", $newpass ) ) {
												exit( json_encode( array( 'flag' => 0, 'msg' => '密码中必须包含符号' ) ) );
										} 
										break;
								default:
										break;
						} 
				} 
		} 
		global $users_handler;
		$saxueUsers -> setvar( "password", $users_handler -> encryptpass( $newpass ) );
		if ( !$users_handler -> insert( $saxueUsers ) ) {
				exit( json_encode( array( 'flag' => 0, 'msg' => '重设密码失败' ) ) );
		} 
		unset( $_SESSION['forgetEmail'] );
		exit( json_encode( array( 'flag' => 1 ) ) );
} 
include "../core.php";
if ( !isset( $_REQUEST['action'] ) ) {
		$GLOBALS['_REQUEST']['action'] = "getpass";
} 
switch ( $_REQUEST['action'] ) {
		case "resetpass" :
				$uid = 0;
				$time = 0;
				$verify = '';
				include SAXUE_ROOT_PATH . "/common/function.php";
				$data = trim( $_REQUEST['data'] );
				if ( !empty( $data ) ) {
						$tmp = saxue_crypt( $data );
						$arr = explode( '|', $tmp );
						if ( is_array( $arr ) && count( $arr ) == 3 ) {
								$uid = intval( $arr[0] );
								$time = intval( $arr[1] );
								$verify = trim( $arr[2] );
						}
				}
				if ( empty( $uid ) || empty( $time ) || empty( $verify ) ) {
						saxue_printfail( '重设密码链接错误' );
				} 
				saxue_getconfigs( 'configs', 'member' );
				$saxueConfigs['member']['setpassexp'] = intval( $saxueConfigs['member']['setpassexp'] );
				if ( !empty( $saxueConfigs['member']['setpassexp'] ) && ( $saxueConfigs['member']['setpassexp'] * 3600 + $time ) < SAXUE_NOW_TIME ) {
						saxue_printfail( '重设密码链接已过期' );
				} 
				include SAXUE_ROOT_PATH . "/model/member_users.php";
				$users_handler = &saxuememberusershandler :: getinstance( "saxuememberusershandler" );
				$saxueUsers = $users_handler -> get( $uid );
				if ( !$saxueUsers ) {
						saxue_printfail( LANG_NO_USER );
				} 
				$tmp = md5( $uid . $saxueUsers -> getvar( "email" ) . $saxueUsers -> getvar( "password" ) );
				if ( $verify != $tmp ) {
						saxue_printfail( '重设密码链接验证失败' );
				} 
				if ( isset( $_POST['dosubmit'] ) ) {
						$newpass = trim( $_POST['newpass'] );
						$repass = trim( $_POST['repass'] );
						resetpass( $saxueUsers, $newpass, $repass );
				} 
				include_once( SAXUE_WEB_PATH . "/header.php" );
				$saxueTpl -> assign( "data", $data );
				$saxueTpl -> assign( "uname", $saxueUsers -> getvar( 'uname' ) );
				$saxueTpl -> assign( "config", $saxueConfigs['member'] );
				$saxueTpl -> setcaching( 0 );
				$saxueTset['saxue_page_template'] = SAXUE_THEME_PATH . '/member/forget_resetpass.html';
				include_once( SAXUE_WEB_PATH . "/footer.php" );
				break;
		case "sendmail" :
				if ( strtolower( $_POST['checkcode'] ) != strtolower( $_SESSION['saxueCheckCode'] ) ) {
						exit( json_encode( array( 'flag' => 0, 'type' => 'checkcode', 'msg' => '验证码错误！' ) ) );
				} 
				include SAXUE_ROOT_PATH . "/model/member_users.php";
				$users_handler = &saxuememberusershandler :: getinstance( "saxuememberusershandler" );
				$GLOBALS['_POST']['gettype'] = trim( $_POST['gettype'] );
				switch ( $_POST['gettype'] ) {
						case 'email': 
								// 邮箱检查
								$email = trim( $_POST['email'] );
								if ( strlen( $email ) == 0 ) {
										exit( json_encode( array( 'flag' => 0, 'type' => 'email', 'msg' => '请填写电子邮箱！' ) ) );
								} 
								if ( !preg_match( "/^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+([\\.][a-z0-9-]+)+\$/i", $email ) ) {
										exit( json_encode( array( 'flag' => 0, 'type' => 'email', 'msg' => '电子邮箱格式错误！' ) ) );
								} 
								$users_handler -> queryobjects( new criteria( "email", $email ) );
								$saxueUsers = $users_handler -> getobject();
								if ( !$saxueUsers ) {
										exit( json_encode( array( 'flag' => 0, 'type' => 'email', 'msg' => '该邮箱未注册！' ) ) );
								} 
								break;
						case 'uname': 
								// 帐号检查
								$uname = trim( $_POST['uname'] );
								if ( strlen( $uname ) == 0 ) {
										exit( json_encode( array( 'flag' => 0, 'type' => 'uname', 'msg' => '请填写会员帐号！' ) ) );
								} 
								if ( preg_match( "/^\\s*\$|^c:\\con\\con\$|[@%,;:\\.\\|\\*\\\"'\\\\\\/\\s\\t\\<\\>\\&]|　/is", $uname ) ) {
										exit( json_encode( array( 'flag' => 0, 'type' => 'uname', 'msg' => '会员帐号格式错误！' ) ) );
								} 
								$users_handler -> queryobjects( new criteria( "uname", $uname ) );
								$saxueUsers = $users_handler -> getobject();
								if ( !$saxueUsers ) {
										exit( json_encode( array( 'flag' => 0, 'type' => 'uname', 'msg' => '该帐号未注册！' ) ) );
								} 
								$email = $saxueUsers -> getvar( 'email' );
								if ( empty( $email ) ) {
										exit( json_encode( array( 'flag' => 0, 'type' => 'uname', 'msg' => '帐号没有绑定邮箱！' ) ) );
								} 
								break;
				} 
				// 发送邮件
				$uid = $saxueUsers -> getvar( 'uid' );
				$uname = $saxueUsers -> getvar( 'uname' );
				include SAXUE_ROOT_PATH . "/common/function.php";
				$data = $uid . $email . $saxueUsers -> getvar( "password" );
				$data = $uid . '|' . SAXUE_NOW_TIME . '|' . md5( $data );
				$verifyurl = SAXUE_URL . '/member/forget.php?action=resetpass&data=' . saxue_crypt( $data, 'ENCODE' );
				$content = $uname . '，<br>请点击以下链接重置您的帐号密码：<br>' . $verifyurl . '<br>(如无法打开，请将该地址手工粘贴到浏览器地址栏再访问)<br><br>如非本人操作，可能您的帐号存在安全隐患，请立即修改您的帐号密码和认证邮箱';
				$ret = saxue_sendmail( $email, '找回密码 - ' . SAXUE_SITE_NAME, $content );
				if ( $ret['flag'] ) $_SESSION['forgetEmail'] = $email;
				$ret['type'] = $_POST['gettype'];
				exit( json_encode( $ret ) );
				break;
		case "mailsuccess" :
				if ( empty( $_SESSION['forgetEmail'] ) ) {
						saxue_jumppage( 'forget.php' );
				} 
				$x = strpos( $_SESSION['forgetEmail'], '@' );
				include_once( SAXUE_WEB_PATH . "/header.php" );
				$saxueTpl -> assign( "email", $_SESSION['forgetEmail'][0] . str_repeat( '*', $x - 1 ) . strstr( $_SESSION['forgetEmail'], '@' ) );
				$saxueTpl -> assign( "emailurl", 'http://mail.' . ( substr( $_SESSION['forgetEmail'], $x + 1 ) ) );
				$saxueTpl -> setcaching( 0 );
				$saxueTset['saxue_page_template'] = SAXUE_THEME_PATH . '/member/forget_mailsuccess.html';
				include_once( SAXUE_WEB_PATH . "/footer.php" );
		case "getpass" :
				include_once( SAXUE_WEB_PATH . "/header.php" );
				$saxueTpl -> setcaching( 0 );
				$saxueTset['saxue_page_template'] = SAXUE_THEME_PATH . '/member/forget_getpass.html';
				include_once( SAXUE_WEB_PATH . "/footer.php" );
} 
