<?php
function saxue_safestr( $_str ) {
		$_str = str_replace( '%20', '', $_str );
		$_str = str_replace( '%27', '', $_str );
		$_str = str_replace( '%2527', '', $_str );
		$_str = str_replace( ';', '；', $_str );
		$_str = str_replace( '\\', '', $_str );
		$_str = htmlspecialchars( $_str, ENT_QUOTES );
		$_str = preg_replace( "/&amp;#(\\d+);/isU", "&#\\1;", $_str );
		return $_str;
} 
include "../core.php";
saxue_checklogin();
include SAXUE_ROOT_PATH . "/model/member_users.php";
$users_handler = &saxuememberusershandler :: getinstance( "saxuememberusershandler" );
$saxueUsers = $users_handler -> get( $_SESSION['saxueUserId'] );
if ( !$saxueUsers ) {
		saxue_printfail( LANG_NO_USER );
} 
if ( !isset( $_REQUEST['action'] ) ) {
		$_REQUEST['action'] = "edit";
} 
include SAXUE_ROOT_PATH . "/model/member_userdata.php";
$userdata_handler = &saxuememberuserdatahandler :: getinstance( "saxuememberuserdatahandler" );
switch ( $_REQUEST['action'] ) {
		case "update" :
				$email = saxue_htmlstr( trim( $_POST['email'] ) );
				if ( strlen( $email ) == 0 ) {
						exit( json_encode( array( 'flag' => 0, 'msg' => '邮箱不能为空' ) ) );
				}
				if ( $saxueUsers -> getvar( "email" ) != $email ) {
						if ( !preg_match( "/^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+([\\.][a-z0-9-]+)+\$/i", $email ) ) {
								exit( json_encode( array( 'flag' => 0, 'msg' => '邮箱格式错误' ) ) );
						} 
						if ( 0 < $users_handler -> getcount( new criteria( "email", $email ) ) ) {
								saxue_printfail( '邮箱 ' . $email . ' 已存在' );
						} 
						$users_handler -> updatefields( array( 'email' => $email ), 'uid=' . $_SESSION['saxueUserId'] );
						$_SESSION['saxueUserEmail'] = $email;
				}
				$up = array();
				$up['mobile'] = saxue_htmlstr( trim( $_POST['mobile'] ) );
				if ( strlen( $up['mobile'] ) > 0 ) {
						if ( !preg_match( "/^1[34578]{1}[0-9]{9}$/i", $up['mobile'] ) ) {
								exit( json_encode( array( 'flag' => 0, 'msg' => '手机格式错误' ) ) );
						} 
				}
				$up['gender'] = intval( $_POST['gender'] );
				$up['qq'] = saxue_htmlstr( trim( $_POST['qq'] ) );
				if ( !empty( $up['qq'] ) && !preg_match( "/^[0-9]{5,12}$/i", $up['qq'] ) ) {
						exit( json_encode( array( 'flag' => 0, 'msg' => 'QQ格式错误' ) ) );
				} 
				$up['msn'] = saxue_htmlstr( trim( $_POST['msn'] ) );
				if ( !empty( $up['msn'] ) && !preg_match( "/^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+([\\.][a-z0-9-]+)+\$/i", $up['msn'] ) ) {
						exit( json_encode( array( 'flag' => 0, 'msg' => 'MSN格式错误' ) ) );
				} 
				$up['intro'] = saxue_safestr( trim( $_POST['intro'] ) );
				$userdata_handler -> updatefields( $up, 'uid=' . $_SESSION['saxueUserId'] );
				exit( json_encode( array( 'flag' => 1 ) ) );
		case "edit" :
				$saxueUserdata = $userdata_handler -> get( $_SESSION['saxueUserId'] );
				$user = $saxueUsers -> getvars( "n" ) + $saxueUserdata -> getvars( "n" );
				include SAXUE_WEB_PATH . "/member/header.php";
				$saxueTpl -> assign( "user", $user );
				$saxueTpl -> setcaching( 0 );
				$saxueTset['saxue_contents_template'] = SAXUE_THEME_PATH . '/member/useredit.html';
				include SAXUE_WEB_PATH . "/member/footer.php";
} 
