KindEditor.plugin('gallerymanager', function(K) {
	var self = this, name = 'gallerymanager',
		galleryManagerJson = K.undef(self.galleryManagerJson, self.basePath + 'php/gallery_manager_json.php'),
		lang = self.lang(name + '.');
		
	self.plugin.gallerymanagerDialog = function(options) {
		var width = K.undef(options.width, 650),
			height = K.undef(options.height, 510),
			clickFn = options.clickFn;
		var html = ['<div>',
			'<div class="ke-gallerymanager-body" style="width:' + width + 'px;height:' + height + 'px;"></div>',
			'</div>'].join('');
		var dialog = self.createDialog({
			name : name,
			width : width,
			title : self.lang(name),
			body : html
		}),
		div = dialog.div,
		win, doc;
		var iframe = K('<iframe frameborder="0" src="' + galleryManagerJson + '" style="width:' + width + 'px;height:' + height + 'px;"></iframe>');
		function ready() {
			win = iframe[0].contentWindow;
			var changeArray = K.queryAll('.change', win.document);
			K.each(changeArray, function (i) {
				K(this).bind('click', function() {
					clickFn.call(this, K(this).attr('data-id'));
				});
			});
		}
		iframe.bind('load', function() {
			iframe.unbind('load');
			if (K.IE) {
				ready();
			} else {
				setTimeout(ready, 0);
			}
		});
		K('.ke-gallerymanager-body', div).replaceWith(iframe);

		return dialog;
	}
});