<?php
if ( !defined( "SAXUE_CORE_INCLUDE" ) ) {
		include "../../core.php";
} 
saxue_checkpower( 'topicurl' );
saxue_getconfigs( 'cate', 'topic' );
if ( isset( $_REQUEST['dosubmit'] ) ) {
		$page = isset( $_REQUEST['page'] ) ? intval( $_REQUEST['page'] ) : 1;
		$total = isset( $_REQUEST['total'] ) ? intval( $_REQUEST['total'] ) : 0;
		$pagesize = !empty( $_REQUEST['pagesize'] ) ? intval( $_REQUEST['pagesize'] ) : 100;
		if ( !is_array( $_REQUEST['catids'] ) ) {
				$catids = $_REQUEST['catids'];
		} elseif ( $_REQUEST['catids'][0] > 0 ) {
				$catids = implode( ',', $_REQUEST['catids'] );
		} else {
				$catids = '';
		} 
		include( SAXUE_ROOT_PATH . "/model/topic.php" );
		$topic_handler = saxuetopichandler :: getinstance( "saxuetopichandler" );
		include SAXUE_ROOT_PATH . "/model/topic_data.php";
		$topicdata_handler = saxuetopicdatahandler :: getinstance( "saxuetopicdatahandler" );
		$criteria = new criteriacompo();
		if ( !empty( $catids ) ) {
				$criteria -> add( new criteria( 'cid', '(' . $catids . ')', 'IN' ) );
		}
		$url = '?dosubmit=1&catids=' . $catids . '&type=' . $_REQUEST['type'] . '&pagesize=' . $pagesize;
		switch ( $_REQUEST['type'] ) {
				case 'lastinput':
						$criteria -> setsort( "topicid" );
						$criteria -> setorder( "DESC" );
						break;
				case 'date':
						if ( !empty( $_REQUEST['fromtime'] ) ) {
								$criteria -> add( new criteria( 'addtime', strtotime( $_REQUEST['fromtime'] . ' 00:00:00' ), '>=' ) );
								$url .= '&fromtime=' . $_REQUEST['fromtime'];
						}
						if ( !empty( $_REQUEST['totime'] ) ) {
								$criteria -> add( new criteria( 'addtime', strtotime( $_REQUEST['totime'] . ' 23:59:59' ), '<=' ) );
								$url .= '&totime=' . $_REQUEST['totime'];
						}
						break;
				case 'id':
						if ( !empty( $_REQUEST['fromid'] ) ) {
								$criteria -> add( new criteria( 'aid', intval( $_REQUEST['fromid'] ), '>=' ) );
								$url .= '&fromid=' . $_REQUEST['fromid'];
						}
						if ( !empty( $_REQUEST['toid'] ) ) {
								$criteria -> add( new criteria( 'aid', intval( $_REQUEST['toid'] ), '<=' ) );
								$url .= '&toid=' . $_REQUEST['toid'];
						}
						break;
		} 
		$criteria -> setlimit( $pagesize );
		$criteria -> setstart( ( $page - 1 ) * $pagesize );
		// 更新URL
		$topic_handler -> queryobjects( $criteria );
		$rows = $ids = array();
		while ( $v = $topic_handler -> getobject() ) {
				$k = $v -> getvar( 'topicid' );
				$rows[$k]['cid'] = $v -> getvar( 'cid' );
				$ids[] = $k;
		}
		$_res = $topic_handler -> db -> query( "SELECT topicid,alias FROM " . saxue_dbprefix( 'topic_data' ) . " WHERE topicid IN (" . implode( ',', $ids ) . ")" );
		while ( $v = $topic_handler -> getobject( $_res ) ) {
				$topicid = $v -> getvar( 'topicid' );
				$alias = $v -> getvar( 'alias' );
				$url = saxue_geturl( 'topic_show', $topicid, $rows[$topicid]['cid'], $alias );
				$topicdata_handler -> updatefields( array( 'url' => $url ), 'topicid=' . $topicid );
		} 
		if ( empty( $total ) ) {
				$total = $topic_handler -> getcount( $criteria );
		} 
		$pages = ceil( $total / $pagesize );
		if ( $pages > $page ) {
				$msg = '总专题数：' . $total . '，已更新 ' . ( $page * $pagesize ) . '篇，正在跳转到下一页';
				++$page;
				$url .= '&total=' . $total . '&page=' . $page;
				saxue_jumppage( $url, $msg, 1 );
		} 
		saxue_jumppage( 'urlupdate.php', 'URL更新完成', 1 );
} 
include_once( SAXUE_ROOT_PATH . "/lib/util/tree.php" );
$tree = new tree;
$tree -> icon = array( '&nbsp;│&nbsp;', '&nbsp;├─&nbsp;', '&nbsp;└─&nbsp;' );
$tree -> nbsp = '&nbsp;';
$tree -> mid = 'cid';
$tree -> pid = 'pid';
$tree -> init( $saxueCate['topic'] );
$str = "<option value='\$cid'>\$spacer\$cname</option>";
$cates = $tree -> get_tree( 0, $str );
include_once( SAXUE_ADMIN_PATH . "/header.php" );
$saxueTpl -> assign( "cates", $cates );
$saxueTset['saxue_contents_template'] = SAXUE_WEB_PATH . "/topic/templates/urlupdate.html";
include_once( SAXUE_ADMIN_PATH . "/footer.php" );
