<?php

if (!defined('CSCMSPATH')) exit('No permission resources');

return array(
		  //新闻列表
         "CREATE TABLE IF NOT EXISTS `{prefix}news` (
            `id` int(10) unsigned NOT NULL auto_increment,
            `name` varchar(128) default '' COMMENT '名称',
            `bname` varchar(64) default '' COMMENT '英文别名',
            `color` varchar(10) default '' COMMENT '名称颜色',
            `tags` varchar(255) default '' COMMENT 'TAGS标签',
            `pic` varchar(255) default '' COMMENT '萎缩图',
            `pic2` varchar(255) default '' COMMENT '幻灯图片',
            `cid` mediumint(5) default '0' COMMENT '分类ID',
            `tid` mediumint(5) default '0' COMMENT '专题ID',
            `reco` tinyint(1) default '0' COMMENT '推荐星级',
            `uid` int(10) unsigned default '0' COMMENT '会员ID',
            `hits` int(10) unsigned default '0' COMMENT '总人气',
            `yhits` int(10) unsigned default '0' COMMENT '月人气',
            `zhits` int(10) unsigned default '0' COMMENT '周人气',
            `rhits` int(10) unsigned default '0' COMMENT '日人气',
            `dhits` int(10) unsigned default '0' COMMENT '顶人气',
            `chits` int(10) unsigned default '0' COMMENT '踩人气',
            `cion` mediumint(5) default '0' COMMENT '阅读需要金币',
            `vip` mediumint(5) default '0' COMMENT '可观看组',
            `level` mediumint(5) default '0' COMMENT '可观看等级',
            `info` varchar(128) default '' COMMENT '描述',
            `content` text COMMENT '新闻内容',
            `addtime` int(10) unsigned default '0' COMMENT '增加时间',
            `skins` varchar(64) default 'show.html' COMMENT '默认模板',
            `title` varchar(64) default '' COMMENT 'SEO标题',
            `keywords` varchar(150) default '' COMMENT 'SEO关键词',
            `description` varchar(200) default '' COMMENT 'SEO介绍',
             PRIMARY KEY  (`id`),
             KEY `uid` (`uid`),
             KEY `cid` (`cid`),
             KEY `tid` (`tid`),
             KEY `reco` (`reco`),
             KEY `hits` (`hits`),
             KEY `yhits` (`yhits`),
             KEY `zhits` (`zhits`),
             KEY `rhits` (`rhits`),
             KEY `addtime` (`addtime`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='新闻表';",
          //新闻审核列表
         "CREATE TABLE IF NOT EXISTS `{prefix}news_verify` (
            `id` int(10) unsigned NOT NULL auto_increment,
            `did` int(10) default '0' COMMENT '新闻ID',
            `name` varchar(128) default '' COMMENT '名称',
            `bname` varchar(64) default '' COMMENT '英文别名',
            `color` varchar(10) default '' COMMENT '名称颜色',
            `tags` varchar(255) default '' COMMENT 'TAGS标签',
            `pic` varchar(255) default '' COMMENT '萎缩图',
            `pic2` varchar(255) default '' COMMENT '幻灯图片',
            `cid` mediumint(5) default '0' COMMENT '分类ID',
            `tid` mediumint(5) default '0' COMMENT '专题ID',
            `reco` tinyint(1) default '0' COMMENT '推荐星级',
            `uid` int(10) unsigned default '0' COMMENT '会员ID',
            `hits` int(10) unsigned default '0' COMMENT '总人气',
            `yhits` int(10) unsigned default '0' COMMENT '月人气',
            `zhits` int(10) unsigned default '0' COMMENT '周人气',
            `rhits` int(10) unsigned default '0' COMMENT '日人气',
            `dhits` int(10) unsigned default '0' COMMENT '顶人气',
            `chits` int(10) unsigned default '0' COMMENT '踩人气',
            `cion` mediumint(5) default '0' COMMENT '阅读需要金币',
            `vip` mediumint(5) default '0' COMMENT '可观看组',
            `level` mediumint(5) default '0' COMMENT '可观看等级',
            `info` varchar(128) default '' COMMENT '描述',
            `content` text COMMENT '新闻内容',
            `addtime` int(10) unsigned default '0' COMMENT '增加时间',
            `skins` varchar(64) default 'show.html' COMMENT '默认模板',
            `title` varchar(64) default '' COMMENT 'SEO标题',
            `keywords` varchar(150) default '' COMMENT 'SEO关键词',
            `description` varchar(200) default '' COMMENT 'SEO介绍',
             PRIMARY KEY  (`id`),
             KEY `uid` (`uid`),
             KEY `cid` (`cid`),
             KEY `addtime` (`addtime`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='新闻审核表';",

          //新闻回收站列表
         "CREATE TABLE IF NOT EXISTS `{prefix}news_hui` (
            `id` int(10) unsigned NOT NULL auto_increment,
            `did` int(10) default '0' COMMENT '新闻ID',
            `hid` tinyint(1) default '0' COMMENT '是否回收站',
            `name` varchar(128) default '' COMMENT '名称',
            `bname` varchar(64) default '' COMMENT '英文别名',
            `color` varchar(10) default '' COMMENT '名称颜色',
            `tags` varchar(255) default '' COMMENT 'TAGS标签',
            `pic` varchar(255) default '' COMMENT '萎缩图',
            `pic2` varchar(255) default '' COMMENT '幻灯图片',
            `cid` mediumint(5) default '0' COMMENT '分类ID',
            `tid` mediumint(5) default '0' COMMENT '专题ID',
            `reco` tinyint(1) default '0' COMMENT '推荐星级',
            `uid` int(10) unsigned default '0' COMMENT '会员ID',
            `hits` int(10) unsigned default '0' COMMENT '总人气',
            `yhits` int(10) unsigned default '0' COMMENT '月人气',
            `zhits` int(10) unsigned default '0' COMMENT '周人气',
            `rhits` int(10) unsigned default '0' COMMENT '日人气',
            `dhits` int(10) unsigned default '0' COMMENT '顶人气',
            `chits` int(10) unsigned default '0' COMMENT '踩人气',
            `cion` mediumint(5) default '0' COMMENT '阅读需要金币',
            `vip` mediumint(5) default '0' COMMENT '可观看组',
            `level` mediumint(5) default '0' COMMENT '可观看等级',
            `info` varchar(128) default '' COMMENT '描述',
            `content` text COMMENT '新闻内容',
            `addtime` int(10) unsigned default '0' COMMENT '增加时间',
            `skins` varchar(64) default 'show.html' COMMENT '默认模板',
            `title` varchar(64) default '' COMMENT 'SEO标题',
            `keywords` varchar(150) default '' COMMENT 'SEO关键词',
            `description` varchar(200) default '' COMMENT 'SEO介绍',
             PRIMARY KEY  (`id`),
             KEY `uid` (`uid`),
             KEY `cid` (`cid`),
             KEY `addtime` (`addtime`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='新闻回收表';",

         //新闻分类
         "CREATE TABLE IF NOT EXISTS `{prefix}news_list` (
            `id` mediumint(5) unsigned NOT NULL auto_increment,
            `name` varchar(64) default '' COMMENT '名称',
            `bname` varchar(30) default '' COMMENT '英文别名',
            `fid` tinyint(3) default '0' COMMENT '上级ID',
            `xid` tinyint(3) default '0' COMMENT '排序ID',
            `yid` tinyint(1) default '0' COMMENT '是否显示',
            `skins` varchar(64) default 'list.html' COMMENT '默认模板',
            `title` varchar(64) default '' COMMENT 'SEO标题',
            `keywords` varchar(150) default '' COMMENT 'SEO关键词',
            `description` varchar(200) default '' COMMENT 'SEO介绍',
             PRIMARY KEY  (`id`),
             KEY `xid` (`xid`),
             KEY `fid` (`fid`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='新闻分类表';",

         //收费阅读记录
         "CREATE TABLE IF NOT EXISTS `{prefix}news_look` (
            `id` int(10) unsigned NOT NULL auto_increment,
            `name` varchar(64) default '' COMMENT '新闻名称',
            `cid` mediumint(5) unsigned default '0' COMMENT '新闻分类ID',
            `did` varchar(128) default '' COMMENT '新闻ID',
            `uid` int(10) unsigned default '0' COMMENT '会员ID',
            `cion` int(10) default '0' COMMENT '扣除金币',
            `ip` varchar(20) default '' COMMENT '会员IP',
            `addtime` int(10) unsigned default '0' COMMENT '时间',
             PRIMARY KEY  (`id`),
             KEY `uid` (`uid`),
             KEY `cid` (`cid`),
             KEY `did` (`did`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='新闻收费阅读记录';",


         //新闻专题
         "CREATE TABLE IF NOT EXISTS `{prefix}news_topic` (
            `id` int(10) unsigned NOT NULL auto_increment,
            `name` varchar(64) default '' COMMENT '名称',
            `bname` varchar(20) default '' COMMENT '别名',
            `pic` varchar(255) default '' COMMENT '图片',
            `toppic` varchar(255) default '' COMMENT '顶部图片',
            `tid` tinyint(1) default '0' COMMENT '是否推荐',
            `yid` tinyint(1) default '0' COMMENT '是否审核',
            `hits` int(10) unsigned default '0' COMMENT '总人气',
            `yhits` int(10) unsigned default '0' COMMENT '月人气',
            `zhits` int(10) unsigned default '0' COMMENT '周人气',
            `rhits` int(10) unsigned default '0' COMMENT '日人气',
            `neir` text COMMENT '介绍',
            `skins` varchar(64) default 'topic.html' COMMENT '默认模板',
            `addtime` int(10) unsigned default '0' COMMENT '时间',
            `title` varchar(64) default '' COMMENT 'SEO标题',
            `keywords` varchar(150) default '' COMMENT 'SEO关键词',
            `description` varchar(200) default '' COMMENT 'SEO介绍',
             PRIMARY KEY  (`id`),
             KEY `hits` (`hits`),
             KEY `yhits` (`yhits`),
             KEY `zhits` (`zhits`),
             KEY `rhits` (`rhits`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='新闻专题表';",

		  //默认分类数据
         "INSERT INTO `{prefix}news_list` (`id`, `name`, `bname`, `fid`, `xid`, `yid`, `skins`, `title`, `keywords`, `description`) VALUES
            (1, '国内', 'gl', 0, 1, 0, 'list.html', '', '', ''),
            (2, '时政', 'sz', 0, 2, 0, 'list.html', '', '', ''),
            (3, '社会', 'sh', 0, 3, 0, 'list.html', '', '', ''),
            (4, '国际', 'gj', 0, 4, 0, 'list.html', '', '', ''),
            (5, '娱乐', 'yl', 0, 5, 0, 'list.html', '', '', ''),
            (6, '军事', 'js', 0, 6, 0, 'list.html', '', '', ''),
            (7, '健康', 'jk', 0, 7, 0, 'list.html', '', '', ''),
            (8, '时尚', 'ss', 0, 8, 0, 'list.html', '', '', ''),
            (9, '科技', 'kj', 0, 9, 0, 'list.html', '', '', ''),
            (10, '体育', 'ty', 0, 10, 0, 'list.html', '', '', ''),
            (11, '教育', 'jy', 0, 11, 0, 'list.html', '', '', '');"
);
