<?php
/**
 * @Cscms open source management system
 * @copyright 2009-2015 chshcms.com. All rights reserved.
 * @Author:Cheng Jie
 * @Dtime:2014-07-26
 */
/**
 * ȫͨú
 */
//ȡļMIME
function get_file_mime($file){
	$regexp = '/^([a-z\-]+\/[a-z0-9\-\.\+]+)(;\s.+)?$/';
	if(function_exists('finfo_file')){
		$finfo = @finfo_open(FILEINFO_MIME);
		if (is_resource($finfo)){
			$mime = @finfo_file($finfo, $file);
			finfo_close($finfo);
			if (is_string($mime) && preg_match($regexp, $mime, $matches)){
				return $matches[1];
			}
		}
	}
	if(DIRECTORY_SEPARATOR !== '\\'){
		$cmd = function_exists('escapeshellarg')
			? 'file --brief --mime '.escapeshellarg($file).' 2>&1'
			: 'file --brief --mime '.$file.' 2>&1';
		if (function_usable('exec')){
			$mime = @exec($cmd, $mime, $return_status);
			if ($return_status === 0 && is_string($mime) && preg_match($regexp, $mime, $matches)){
				return $matches[1];
			}
		}
		if(!ini_get('safe_mode') && function_usable('shell_exec')){
			$mime = @shell_exec($cmd);
			if (strlen($mime) > 0){
				$mime = explode("\n", trim($mime));
				if (preg_match($regexp, $mime[(count($mime) - 1)], $matches)){
					return $matches[1];
				}
			}
		}
		if (function_usable('popen')){
			$proc = @popen($cmd, 'r');
			if (is_resource($proc)){
				$mime = @fread($proc, 512);
				@pclose($proc);
				if ($mime !== FALSE){
					$mime = explode("\n", trim($mime));
					if (preg_match($regexp, $mime[(count($mime) - 1)], $matches)){
						return $matches[1];
					}
				}
			}
		}
	}
	if(function_exists('mime_content_type')){
		return  @mime_content_type($file);
	}
	return false;
}
//ַȡ
function str_substr($start, $end, $str, $sid=1){
    $temp = explode($start, $str, 2);
    $content = explode($end, $temp[1], 2);
    $str = $content[0];
	if($sid==2){
		$str = preg_replace("/<a[^>]+>(.+?)<\/a>/i","$1",$str);
		//˻з
		$str = preg_replace("/ /","",$str);
		$str = preg_replace("/&nbsp;/","",$str);
		$str = preg_replace("//","",$str);
		$str = preg_replace("/\r\n/","",$str);
		$str = str_replace(chr(13),"",$str);
		$str = str_replace(chr(10),"",$str);
		$str = str_replace(chr(9),"",$str);
    }
    return $str;
}
//XMLʵַת
function xml_string($str){
	$ci = &get_instance();
	$ci->load->helper('xml');
    return xml_convert($str);
}
//PHPò
function show($varName){
	switch($result = get_cfg_var($varName)){
		case 0:return '<font color="red"></font>';break;
		case 1:return '<font color=#0076AE></font>';break;
		default: return $result;break;
	}
}
//Mysql
function mydb(){
	$ci = &get_instance();
	if (!isset($ci->db)){
        $ci->load->database();
	}
    $getmysqlver=$ci->db->version();
    if(empty($getmysqlver)){
        return L('jiance_no');
    }
    $MysqlALL=explode(".",$getmysqlver);
    if($MysqlALL[0] < 5){
	    return $getmysqlver.'&nbsp;&nbsp;<i class="fa fa-close" style="color: red;"></i>';
    }else{
	    return $getmysqlver.'&nbsp;&nbsp;<i class="fa fa-check colorl"></i>';
    }

}
//PHP
function isfun($funName = ''){
    if (!$funName || trim($funName) == '' || preg_match('~[^a-z0-9\_]+~i', $funName, $tmp)) return L('error');
	return (false !== function_exists($funName)) ? '<font color=#0076AE></font>' : '<font color="red"></font>';
}
//ȡò
function config($found='',$dir=''){
    $dir = empty($dir) ? PLUBPATH : $dir;
	if($dir=='sys'){
		if(!empty($found)){
			$res = null;
			if(defined($found)){
				$res = constant($found);
			}
			if(!$res){
				if($found=='Seo'){
					$res = array();
					$res['title'] = Web_Title;
					$res['keywords'] = Web_Keywords;
					$res['description'] = Web_Description;
				}
			}
			return $res;
		}else{
			return null;
		}
	}
    global $PLUBARR;
    if(!isset($PLUBARR[$dir])){
    	$site = require CSCMS.$dir.FGF.'site.php';
    	//дȫֱ
    	$GLOBALS['PLUBARR'][$dir] = $site;
    }else{
    	$site = $PLUBARR[$dir];
    }
	if(empty($found)) return $site;
	if(isset($site[$found])){
		return $site[$found];
	}else{
		return null;
	}
}
//
function L($key = '', $arr=array()){
	if($key == ''){
        return '';
	}else{
        $ci	= &get_instance();
		if(!empty($arr)){
            return vsprintf($ci->lang->line($key),$arr);
		}else{
            return $ci->lang->line($key);
		}
	}
}
//ȡĿ¼
function Skins_Dir($skins=null){
	if(defined('MOBILE') && Mobile_Is==1){ //ֻ
		if(defined('USERPATH')){ //Ա
        	$TempImg = Web_Path.'tpl/mobile/user/'.Mobile_User_Dir.'/';
		}elseif(defined('HOMEPATH')){ //ռ
			if($skins){
        		$TempImg = Web_Path.'tpl/mobile/home/'.$skins.'/';
			}else{
        		$TempImg = Web_Path.'tpl/mobile/home/'.Mobile_Home_Dir.'/';
			}
		}else{
        	$TempImg = Web_Path.'tpl/mobile/skins/'.Mobile_Skins_Dir.'/';
		}
	}else{
		if(defined('USERPATH')){ //Ա
        	$TempImg = Web_Path.'tpl/pc/user/'.Pc_User_Dir.'/';
		}elseif(defined('HOMEPATH')){ //ռ
			if($skins){
        		$TempImg = Web_Path.'tpl/pc/home/'.$skins.'/';
			}else{
        		$TempImg = Web_Path.'tpl/pc/home/'.Pc_Home_Dir.'/';
			}
		}else{
        	$TempImg = Web_Path.'tpl/pc/skins/'.Pc_Skins_Dir.'/';
		}
    }
    $TempImg = str_replace('//','/',$TempImg);
    $end = strrpos(substr($TempImg,0,strlen($TempImg)-1),'/')+1;
    return substr(substr($TempImg,0,strlen($TempImg)-1),0,$end);
}
//ȡֶϢ
function getzd($table,$ziduan,$id,$cha='id'){
	global $CSZDY;
	if(!isset($CSZDY[$table][$ziduan][$id])){
		$zdy = null;
		$ci = &get_instance();
		if (!isset($ci->db)){
	        $ci->load->database();
		}
	    if($table && $ziduan && $id){
		    $ci->db->where($cha,$id);
		   	$ci->db->select($ziduan);
		   	$row=$ci->db->get($table)->row();
			if($row){
				$zdy = $row->$ziduan;
			}else{
				return null;	
			}
		}
		$GLOBALS['CSZDY'][$table][$ziduan][$id] = $zdy;
	}else{
		$zdy = $CSZDY[$table][$ziduan][$id];
	}
	return $zdy;
}
//жǷע
function getgz($uid=0){
	$ci = &get_instance();
	if (!isset($ci->db)){
        $ci->load->database();
	}
	if((int)$uid==0){
		return 0;
	}
	$guanzu=0;
    if(isset($_SESSION['cscms__id'])){
        $count_sql ="SELECT count(*) as count FROM ".CS_SqlPrefix."friend where uidb=".$uid." and uida=".$_SESSION['cscms__id']."";
	    $query = $ci->db->query($count_sql)->result_array();
	    $guanzu = $query[0]['count'];
	}
	return $guanzu;
}
//ȡԱȼ
function getlevel($jinyans=0,$type=0){
	$ci = &get_instance();
	if (!isset($ci->db)){
       $ci->load->database();
	}
	$level = 1;
	$name = '';
	$xid = 0;
	$jinyan = 0;
	$stars = 1;
	$row=$ci->db->query("SELECT * FROM ".CS_SqlPrefix."userlevel where jinyan<".intval($jinyans+1)." order by xid desc")->row();
	if($row){
		$level = $row->xid; //ȼID
		$name = $row->name; //ȼ
		$jinyan = $row->jinyan; //ȼ
		$xid = $row->id;   //ǰȼID
		$stars = $row->stars; //
	}
	if($type==0){
		return $level;	 //Աȼ
	}
	if($type==1){
		return get_stars($stars,$level,$name);	//ʾ
	}
	$xjinyan=$jinyan;
	$rowx=$ci->db->query("SELECT jinyan FROM ".CS_SqlPrefix."userlevel where id>".$xid." order by xid asc")->row();
	if($rowx){
		$xjinyan=$rowx->jinyan;
	}
	if($type==2){
		return $xjinyan;	//¸Ҫ
	}
	if($type==3){
		return ($xjinyan-$jinyans);	//¸ʣྭ
	}
	if($type==4){
		return number_format($jinyans/$xjinyan*100,2);	//¸ٷֱ
	}
	if($type==5){
		return $name;	//ȼ
	}
}
//滻̬ɱǩ
function str_replace_dir($url,$id,$sname,$sort,$page,$dir='',$fid='lists'){
	if(empty($sort)) $sort='id';
	if(strpos($url,'{sname}') !== FALSE && !empty($dir)){
	     $ci = &get_instance();
		 $ci->load->library('pinyin');
         if(empty($sname) || $sname=='null'){
			 if($fid=='topic/show' || ($fid=='topic' && $sort=='show')){
			     $table=$dir.'_topic';
				 $field='name';
			 }else{
			     $table=($fid=='lists') ? $dir.'_list' : $dir;
				 $field=($fid=='lists') ? 'bname' : 'name';
			 }
		     if($ci->db->table_exists(CS_SqlPrefix.$table) && $ci->db->field_exists($field, CS_SqlPrefix.$table)){
                 $sname=getzd($table,$field,$id);
			 }
		 }
		 $sname=$ci->pinyin->result($sname);
	}
	$old = array('{id}','{sname}','{pinyinid}','{sort}','{md5id}','{page}','{zu}','{ji}');
	$new = array($id,$sname,topinyin($id),$sort,substr(md5($id),0,16),$page,0,0);
	return str_replace($old,$new,$url);
}
//ȡ
function host_ym($k=0) {
    $host=$_SERVER['HTTP_HOST'];
    preg_match('/[\w][\w-]*\.(?:com\.cn|gov\.cn|cn\.com|org\.cn|net\.cn)(\/|$)/isU', $host, $domain);
    $ym = rtrim(@$domain[0], '/');
	$ips = explode(':',$host);
    if(empty($ym) && $host!='localhost' && !preg_match("/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/",$ips[0])){
           $ymarr=explode('.',$host);
           $nums=count($ymarr);
           $ym=$ymarr[$nums-2].'.'.$ymarr[$nums-1];
	}
	if(empty($ym)){
		$ym = $ips[0];
	}else{
   	    $ym = $k==0 ? '.'.$ym : $ym;
	}
    return $ym;
}
//ȡ׺ƹ
function get_extpic($ext) {
    $ext=strtolower($ext);
    if($ext=='php' || $ext=='asp' || $ext=='css' || $ext=='js' || $ext=='jsp' || $ext=='tpl') {
        $pic = 'php';
    }elseif($ext=='jpg' || $ext=='png' || $ext=='gif' || $ext=='bmp' || $ext=='jpge') {
        $pic = 'pic';
    }elseif($ext=='html' || $ext=='htm' || $ext=='shtm' || $ext=='shtml') {
        $pic = 'html';
    }elseif($ext=='mp3' || $ext=='wma' || $ext=='m4a') {
        $pic = 'mp3';
    }elseif($ext=='mp4' || $ext=='wmv' || $ext=='flv' || $ext=='wav' || $ext=='avi') {
        $pic = 'mp4';
    }elseif($ext=='rar' || $ext=='zip' || $ext=='7z') {
        $pic = 'rar';
	}else{
        $pic = 'no';
    }
	return $pic;
}
//ȡַĺ
function sub_str($str, $length, $start=0, $suffix="...", $charset='gbk'){
	$str=str_checkhtml($str);
	if(($length+2) >= strlen($str)){
		return $str;
	}
	if(function_exists("mb_substr")){
		return mb_substr($str, $start, $length, $charset).$suffix;
	}elseif(function_exists('iconv_substr')){
		return iconv_substr($str,$start,$length,$charset).$suffix;
	}
	$re['utf-8']  = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
	$re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
	$re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
	$re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
	preg_match_all($re[$charset], $str, $match);
	$slice = join("",array_slice($match[0], $start, $length));
	return $slice.$suffix;
}
//дļ
function write_file($path, $data, $mode = FOPEN_WRITE_CREATE_DESTRUCTIVE){
	$data = get_bm($data);
	$dir = dirname($path);
	if(!is_dir($dir)){
		mkdirss($dir);
	}
	if ( ! $fp = @fopen($path, $mode)){
		return FALSE;
	}
	flock($fp, LOCK_EX);
	fwrite($fp, $data);
	flock($fp, LOCK_UN);
	fclose($fp);
	return TRUE;
}
//ݹ鴴ļ
function mkdirss($dir) {
    if (!$dir) {
        return FALSE;
    }
    if (!is_dir($dir)) {
        mkdirss(dirname($dir));
        if (!file_exists($dir)) {
            mkdir($dir, 0777);
        }
    }
    return true;
}
//ʱʽת
function datetime($TimeTime){
	$limit=time()-$TimeTime;
	if ($limit <5) {$show_t = L('time_01');}
	if ($limit >= 5 and $limit <60) {$show_t = $limit.L('time_02');}
	if ($limit >= 60 and $limit <3600) {$show_t = sprintf("%01.0f",$limit/60).L('time_03');}
	if ($limit >= 3600 and $limit <86400) {$show_t = sprintf("%01.0f",$limit/3600).L('time_04');}
	if ($limit >= 86400 and $limit <2592000) {$show_t = sprintf("%01.0f",$limit/86400).L('time_05');}
	if ($limit >= 2592000 and $limit <31104000) {$show_t = sprintf("%01.0f",$limit/2592000).L('time_06');}
	if ($limit >= 31104000) {$show_t = L('time_07');}
	return $show_t;
}
//Base64
function cs_base64_encode($string) {
    $data = base64_encode($string);
    $data = str_replace(array('+', '/', '='), array('-', '_', ''), $data);
    return $data;
}
//Base64
function cs_base64_decode($string) {
    $data = str_replace(array('-', '_'), array('+', '/'), $string);
    $mod4 = strlen($data) % 4;
    if ($mod4) {
        $data.= substr('====', $mod4);
    }
    return base64_decode($data);
}
//ʵл
function arraystring($data) {
    return $data ? addslashes(serialize($data)) : '';
}
//ʵл
function unarraystring($data) {
	if(empty($data)) return '';
    return unserialize(stripslashes($data));
}
//HTMLתַ
function str_encode($str){
	if(is_array($str)) {
		foreach($str as $k => $v) {
			$str[$k] = str_encode($v); 
		}
	}else{
		if(is_string($str)){
			$str=str_replace("<","&lt;",$str);
			$str=str_replace(">","&gt;",$str);
			$str=str_replace("\"","&quot;",$str);
			$str=str_replace("'",'&#039;',$str);
		}
	}
	return $str;
}
//ַתHTML
function str_decode($str){
	if(is_array($str)) {
		foreach($str as $k => $v) {
			$str[$k] = str_decode($v); 
		}
	}else{
		if(is_string($str)){
			$str=str_replace("&lt;","<",$str);
			$str=str_replace("&gt;",">",$str);
			$str=str_replace("&quot;","\"",$str);
			$str=str_replace("&#039;","'",$str);
		}
	}
	return $str;
}
//SQL
function safe_replace($string){
	if(is_array($string)) {
		foreach($string as $k => $v) {
			$string[$k] = safe_replace($v); 
		}
	}else{
		if(is_string($string)){
		    $string = str_replace('%20','',$string);
		    $string = str_replace('%27','',$string);
		    $string = str_replace('%2527','',$string);
			$string = str_replace("'",'&#039;',$string);
		    $string = str_replace('"','&quot;',$string);
		    $string = str_replace(';','',$string);
		    $string = str_replace('*','',$string);
		    $string = str_replace('<','&lt;',$string);
		    $string = str_replace('>','&gt;',$string);
		    $string = str_replace('\\','',$string);
		    $string = str_replace('%','\%',$string);
		}else{
		    if(preg_match('/^\d{1,9}$/',$string)) $string = (int)$string;
		}
	}
	return $string;
}
//html
function str_checkhtml($str,$sql=0) {
	if(is_array($str)) {
		foreach($str as $k => $v) {
			$str[$k] = str_checkhtml($v); 
		}
	}else{
		$str = preg_replace("/\s+/"," ", $str);
		$str = preg_replace("/&nbsp;/","",$str);
		$str = preg_replace("/\r\n/","",$str);
		$str = preg_replace("/\n/","",$str);
		$str = str_replace(chr(13),"",$str);
		$str = str_replace(chr(10),"",$str);
		$str = str_replace(chr(9),"",$str);
		$str = strip_tags($str);
		$str = str_encode($str);
	}
	if($sql==1){
		$str = safe_replace($str);
	}
	return $str;
}
//xss˺
function remove_xss($val) { 
	$ci = &get_instance();
	$vaule = $ci->security->xss_clean($val);
	return $vaule; 
}
//볤ǷϹ涨
function is_userpass($password) {
	$strlen = strlen($password);
	if($strlen >= 6 && $strlen <= 20) return true;
	return false;
}
//Ƿдַ
function is_badword($string) {
	$badwords = array("\\",'&',' ',"'",'"','/','*',',','<','>',"\r","\t","\n","#");
	foreach($badwords as $value){
		if(strpos($string, $value) !== FALSE) {
			return TRUE;
		}
	}
	return FALSE;
}
//жûʽǷȷ
function is_username($username,$s=0) {
	$strlen = strlen($username);
    if($s==0 && User_RegZw==0 && preg_match("/[\x7f-\xff]/", $username)) {
		return false;
	} elseif (is_badword($username) || !preg_match("/^[a-zA-Z0-9_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]+$/", $username)){
		return false;
	} elseif ( 20 < $strlen || $strlen < 2 ) {
		return false;
	}
	return true;
}
//жemailʽǷȷ
function is_email($email) {
	return strlen($email) > 6 && preg_match("/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/", $email);
}
//жֻʽǷȷ
function is_tel($tel) {
	return preg_match("/^1[3|4|5|7|8][0-9]{9}$|14[0-9]{9}|15[0-9]{9}$|18[0-9]{9}$/", $tel);
}
//жQQʽǷȷ
function is_qq($qq) {
    return preg_match('/^[1-9][0-9]{4,12}$/', $qq);
}
//ת
function get_bm($string,$s1='utf-8',$s2='gbk') {
    if(is_array($string)) {
        foreach($string as $k => $v) { 
            $string[$k] = get_bm($v,$s1,$s2); 
        } 
	}else{
        if(strtolower($s1)=='gbk' || (strtolower($s1)=='utf-8' && is_utf8($string))){
			$string2 = $string;
	     	if(function_exists("mb_convert_encoding")){
				$string = mb_convert_encoding($string, $s2, $s1);
            }else{
                $string = iconv($s1, $s2, $string);
            }
			if(empty($string) || $string=='ʧ') $string = $string2;
	    }
		if(preg_match('/^\d{1,9}$/',$string)) $string = (int)$string;
	}
    return $string;
}
//urlencode
function rurlencode($string) {
	$key=rawurldecode($string);
	if(!is_utf8($key)){
		$key = get_bm($key,'utf-8', 'gbk');
	}
	return $key;
}
//жַǷUTF-8
function is_utf8($text) { 
	$e = mb_detect_encoding($text, array('UTF-8', 'GBK'));
	if($e=='UTF-8'){
		return true;
	} else { 
	    return false;
	}
}
//escape
function escape($string, $in_encoding = 'GBK',$out_encoding = 'UCS-2') { 
    $return = ''; 
    if (function_exists('mb_get_info')) { 
        for($x = 0; $x < mb_strlen ( $string, $in_encoding ); $x ++) { 
            $str = mb_substr ( $string, $x, 1, $in_encoding ); 
            if (strlen ( $str ) > 1) { // ַֽ 
                $return .= '%u' . strtoupper ( bin2hex ( mb_convert_encoding ( $str, $out_encoding, $in_encoding ) ) ); 
            } else { 
                $return .= '%' . strtoupper ( bin2hex ( $str ) ); 
            } 
        } 
    } 
    return $return; 
}
//escape
function unescape($str) { 
    $ret = ''; 
    $len = strlen($str); 
    for ($i = 0; $i < $len; $i ++) { 
        if ($str[$i] == '%' && $str[$i + 1] == 'u') { 
            $val = hexdec(substr($str, $i + 2, 4)); 
            if ($val < 0x7f) 
                $ret .= chr($val); 
            else  
                if ($val < 0x800) 
                    $ret .= chr(0xc0 | ($val >> 6)) . 
                     chr(0x80 | ($val & 0x3f)); 
                else 
                    $ret .= chr(0xe0 | ($val >> 12)) . 
                     chr(0x80 | (($val >> 6) & 0x3f)) . 
                     chr(0x80 | ($val & 0x3f)); 
            $i += 5; 
        } else  
            if ($str[$i] == '%') { 
                $ret .= urldecode(substr($str, $i, 3)); 
                $i += 2; 
            } else 
                $ret .= $str[$i]; 
    } 
    return $ret; 
}
//ַܡ
function sys_auth($string,$operation,$key=''){
	$key=($key=='')?CS_Encryption_Key:$key;
	$key=md5($key);
	$key_length=strlen($key);
	$string=$operation=='D'?base64_decode(str_replace('-','/',str_replace('_','+',$string))):substr(md5($string.$key),0,8).$string;
	$string_length=strlen($string);
	$rndkey=$box=array();
	$result='';
	for($i=0;$i<=255;$i++){
       $rndkey[$i]=ord($key[$i%$key_length]);
       $box[$i]=$i;
	}
	for($j=$i=0;$i<256;$i++){
       $j=($j+$box[$i]+$rndkey[$i])%256;
       $tmp=$box[$i];
       $box[$i]=$box[$j];
       $box[$j]=$tmp;
	}
	for($a=$j=$i=0;$i<$string_length;$i++){
       $a=($a+1)%256;
       $j=($j+$box[$a])%256;
       $tmp=$box[$a];
       $box[$a]=$box[$j];
       $box[$j]=$tmp;
       $result.=chr(ord($string[$i])^($box[($box[$a]+$box[$j])%256]));
	}
	if($operation=='D'){
	   if(substr($result,0,8)==substr(md5(substr($result,8).$key),0,8)){
	        return substr($result,8);
	   }else{
	        return'';
	   }
	}else{
	   return str_replace('+','_',str_replace('=','',base64_encode($result)));
	}
}
//ɫ
function random_color() {
    $str = '#';
    for ($i = 0; $i < 6; $i++) {
        $randNum = rand(0, 15);
        switch ($randNum) {
            case 10: $randNum = 'A'; break;
            case 11: $randNum = 'B'; break;
            case 12: $randNum = 'C'; break;
            case 13: $randNum = 'D'; break;
            case 14: $randNum = 'E'; break;
            case 15: $randNum = 'F'; break;
        }
        $str.= $randNum;
    }
    return $str;
}
//ת
function facehtml($str)  {  
	if (empty($str)) return false;  
	for($i=1;$i<=56;$i++){
	     $str = str_replace( '[em:'.$i.']', "<img align='absmiddle' src=".Web_Path."packs/images/faces/e".$i.".gif border=0>", $str); 
	}
	return $str;
}
//Сת
function formatsize($size, $dec=2){
	$a = array("B", "KB", "MB", "GB", "TB", "PB");
	$pos = 0;
	while ($size >= 1024) {
		$size /= 1024;
		$pos++;
	}
	return round($size,$dec)." ".$a[$pos];
}
//жȨ
function getqx($value,$perm,$sid=0){
	if(empty($perm)){
	    return "no";
	}else{
		$permarr=explode(',',$perm);
		for($i=0;$i<count($permarr);$i++){
		    if($sid>0){
		        if(strpos($value,$permarr[$i]) !== FALSE){
					return "ok";
		        }
		    }else{
		        if($permarr[$i]==$value){
					return "ok";
		        }
		    }
		}
	}
	return "no";
}
//ȡIP
function getip(){ 
	$ci = &get_instance();
	$ip = $ci->input->ip_address();
	if(preg_match("/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/",$ip)){
	    return $ip; 
	}else{
	    return null;
	}
} 
//ʼϢǩ滻
function getmsgto($str,$all){ 
	foreach ($all as $key => $value) {
	    if($key=='username'){
	        $str = str_replace("{cscms:user}", $value, $str);
	    }
	    if($key=='url'){
	        $str = str_replace("{cscms:url}", $value, $str); 
	    }
	}
	$str = str_replace("{cscms:webname}", Web_Name, $str); 
	$str = str_replace("{cscms:time}", date('Y-m-d H:i:s'), $str); 
	return str_decode($str); 
} 
//ͨkeyvalue
function arr_key_value($arr,$key){
	if(is_array($arr)){
		foreach ($arr as $keys => $value) {
		    if($key==$keys){
		        return $value;
		    }
		}
	}
	return null;
}
//д鵽ļ
function arr_file_edit($arr,$file=''){
	if($file=='') $file=CSCMS.'sys/Cs_Domain.php';
	if(is_array($arr)){
	    $con = var_export($arr,true);
	} else{
	    $con = $arr;
	}
	$strs="<?php if (!defined('FCPATH')) exit('No direct script access allowed');".PHP_EOL;
	$strs.="return $con;";
	$strs.="?>";
	return write_file($file, $strs);
}
//ȫֺJS
function cs_addjs($Mark_Text){
	if(strpos($Mark_Text,'</title>') !== FALSE){
	    $view = explode('</title>',$Mark_Text); 
	    $Mark_Text=$view[0]."</title>\r\n<script type='text/javascript'>var cscms_path='".is_ssl().Web_Url.Web_Path."';</script>\r\n<link rel='stylesheet' href='".Web_Path."packs/layui/css/layui.css'>\r\n<script type='text/javascript' src='".Web_Path."packs/layui/layui.js' charset='utf-8'></script>\r\n<script type='text/javascript' src='".Web_Path."packs/js/jquery.min.js'></script>\r\n<script type='text/javascript' src='".Web_Path."packs/js/cscms.js'></script>";
	    if(count($view)>1) $Mark_Text.=$view[1];
	}
	return $Mark_Text;
}
//ģJS
function hits_js($Mark_Text,$jslink){
	$js="<script type='text/javascript'>cscms.inc_js('".$jslink."');</script>";
	if(strpos($Mark_Text,'</body>') !== FALSE){
		$view = explode('</body>',$Mark_Text); 
		$Mark_Text=$view[0].$js."\r\n</body>";
		if(count($view)>1) $Mark_Text.=$view[1];
	}else{
	   	$Mark_Text.=$js;
	}
	return $Mark_Text;
}
//תƴ
function topinyin($str) {
	$str=str_replace("0","ling",$str);
	$str=str_replace("1","yi",$str);
	$str=str_replace("2","er",$str);
	$str=str_replace("3","san",$str);
	$str=str_replace("4","si",$str);
	$str=str_replace("5","wu",$str);
	$str=str_replace("6","liu",$str);
	$str=str_replace("7","qi",$str);
	$str=str_replace("8","ba",$str);
	$str=str_replace("9","jiu",$str);
	return $str;	
}
//ȡԶ
function htmlall($url,$codes='utf-8'){
	if(empty($url)) return null;
	 // curlģʽ
	if (function_exists('curl_init') && function_exists('curl_exec')){
		$curl = curl_init(); //ʼcurl
		curl_setopt($curl, CURLOPT_URL, $url); //÷ʵվַ
		curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); //ģûʹõ
		curl_setopt($curl, CURLOPT_AUTOREFERER, 1);    //Զ·Ϣ
		curl_setopt($curl, CURLOPT_TIMEOUT, 10);      //óʱƷֹѭ
		curl_setopt($curl, CURLOPT_HEADER, 0);         //ʾصheader
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); //ȡϢļʽ
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); 
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false); 
		$data = curl_exec($curl);
		curl_close($curl);
	}else{
	    $data = @file_get_contents($url);
	}
	if(strtolower($codes)=='gbk'){
	    $data = get_bm($data);
	}
	$data=str_replace('</textarea>','&lt;/textarea&gt;',$data);
	return $data;
}
// HTMLתJS  
function htmltojs($str){
    $re='';
    $str=str_replace('\\','\\\\',$str);
    $str=str_replace("'","\'",$str);
    $str=str_replace('"','\"',$str);
    $str=str_replace('\t','',$str);
    $str= explode("\r\n",$str);
    for($i=0;$i<count($str);$i++){
        $re.="document.writeln(\"".$str[$i]."\");\r\n";
    }
    return $re;
}
//ɾĿ¼ļ
function deldir($dir,$sid='ok') {
	//ɾĿ¼µļ
	if(!is_dir($dir)){
	  return true;
	}
	$dh=opendir($dir);
	while ($file=readdir($dh)) {
		if($file!="." && $file!="..") {
			$fullpath=$dir."/".$file;
		 	if(!is_dir($fullpath)) {
		     	@unlink($fullpath);
		 	} else {
		     	deldir($fullpath);
		 	}
		}
	}
	closedir($dh);
	//ɾǰļУ
	if($sid=='ok'){
		if(@rmdir($dir)) {
		    return true;
		}else{
		    return false;
		}
	}else{
		return true;
	}
}
//ȡǰĿ¼ܴС
function getdirsize($dir){ 
    $handle = opendir($dir);
    $sizeResult=0;
    while (false!==($FolderOrFile = readdir($handle))){ 
        if($FolderOrFile != "." && $FolderOrFile != ".."){ 
            if(is_dir("$dir/$FolderOrFile")){ 
                $sizeResult += getDirSize("$dir/$FolderOrFile"); 
            }else{ 
                $sizeResult += filesize("$dir/$FolderOrFile"); 
            }
        }    
    }
    closedir($handle);
    return $sizeResult;
}
//תͼ
function get_stars($num, $level=0, $name='', $starthreshold = 4) {
    $str = '';
    $alt = ($level>0)?'title="ǰȼ: Lv.' . $level . '('.$name.')"':'';
    for ($i = 3; $i > 0; $i--) {
        $numlevel = intval($num / pow($starthreshold, ($i - 1)));
        $num = ($num % pow($starthreshold, ($i - 1)));
        for ($j = 0; $j < $numlevel; $j++) {
            $str.= '<img align="absmiddle" src="'.Web_Path.'packs/images/stars'.$i.'.gif" ' . $alt . ' />';
        }
    }
    return $str;
}
//ۡιؼ
function filter($str){
	$KeyArr=explode(',',Pl_Str);
	for($i=0;$i<count($KeyArr);$i++){
	    $str=str_replace($KeyArr[$i],"**",$str);
	}
	return $str;
}
//ķִ
function gettag($title,$content=''){
	if(empty($content)) $content = $title;
	$url = 'http://ictclas.nlpir.org/nlpir/index5/getKeyWords.do';
	$post = 'content='.sub_str(get_bm($content,'gbk','utf-8'),500);
	$head = "Origin:http://ictclas.nlpir.org \r\nReferer:http://ictclas.nlpir.org/nlpir/";
	$option = array('http'=>array('method'=>'POST','header'=>$head,'content'=>$post)); 
	$xoption = stream_context_create($option);  
	$json = file_get_contents($url, false, $xoption);
	$arr = json_decode($json,1);
	$tags = array_filter(explode('#',$arr['keywords']));
	if(!empty($tags)){
		return get_bm(implode(',',$tags));
	}else{
		return '';
	}
}
//۵
function get_pl($dir, $did=0, $cid=0){
	$cscms_pl="<div id='cscms_pl'><div class='cscms_txt'><img src='".Web_Path."packs/images/load.gif'>&nbsp;&nbsp;,Ե......</div></div>\r\n<script type='text/javascript'>var dir='".$dir."';var did=".$did.";var cid=".$cid.";cscms.pl(1,0,0);</script>";
	return $cscms_pl;
}
//Ե
function get_gbook($uid=0){
	$cscms_gbook="<div id='cscms_gbook'><div class='cscms_txt'><img src='".Web_Path."packs/images/load.gif'>&nbsp;&nbsp;,Ե......</div></div>\r\n<script type='text/javascript'>var uid=".$uid.";cscms.home_gbook(1);</script>";
	return $cscms_gbook;
}
//Token
function get_token($name='token',$s=0,$time=3600){
	$ci = &get_instance();
	if($s==0){ //д
		$ci->load->helper('string');
		$token=random_string('alnum',10);
		$ci->cookie->set_cookie($name,$token,time()+$time);
		return $token;
	}elseif($s==2){ //ɾ
		$ci->cookie->set_cookie($name);
		return true;
	}else{ //ж
		$token=$ci->cookie->get_cookie($name);
		if(empty($token) || $token!=$time){
		    return false;
		}else{
		    return true;
		}
	}
}
//ȡID   cid=1,2,3,4,5,6
function getChild($CID,$type='',$zd='fid'){
	if(empty($type)) $type = PLUBPATH.'_list';
	$ci = &get_instance();
	if (!isset($ci->db)){
		$ci->load->database();
	}
	if(!empty($CID)){
	    $ClassArr = explode(',',$CID);
	    for($i=0;$i<count($ClassArr);$i++){
			$sql="select id from ".CS_SqlPrefix.$type." where ".$zd."='$ClassArr[$i]'";
			$result=$ci->db->query($sql)->result();
			if(!empty($result)){
                foreach ($result as $row) {
                	$ClassArr[]=$row->id;
                }
	        }
	  		$CID = implode(',',$ClassArr);
		}
	}
	return $CID;
}
//ȡ
function getcount($table='',$day=0){
	if(empty($type)) $type = PLUBPATH;
	$ci = &get_instance();
	if (!isset($ci->db)){
		$ci->load->database();
	}
	$sql="select count(*) as count from ".CS_SqlPrefix.$table;
	$where = array();
	//ѯʱ
	if($day>0){
		$day--;
		$time = strtotime(date("Y-m-d 0:0:0")) - $day*86400;
		$where[] = 'addtime>'.$time;
	}
	if(!empty($where)) $sql.=' where '.implode(' and ',$where);
	$row = $ci->db->query($sql)->row_array();
	$nums = !$row ? 0 : $row['count'];
	return $nums;
}

//ǩ
function tagslink($Search_Key,$fid='tags'){
	$dir = PLUBPATH == 'sys' ? 'dance' : PLUBPATH;
	$Search_link = is_ssl().Web_Url.Web_Path.'index.php/'.$dir.'/'; //ַ
    $Search_List=$Search_Key1="";
    $Search_Key=trim($Search_Key);
    $Str=" @,@@|@/@_";
    $StrArr=explode('@',$Str);
    for($i=0;$i<=5;$i++){
        if(stristr($Search_Key,$StrArr[$i])){
            $Search_Key1 = explode($StrArr[$i],$Search_Key);
        }
	}
    if(is_array($Search_Key1)){
        for($j=0;$j<count($Search_Key1);$j++){
            $Search_List.="<a target=\"tags\" href=\"".$Search_link."search?".$fid."=".urlencode($Search_Key1[$j])."\">".$Search_Key1[$j]."</a> ";
		}
	}else{
        $Search_List="<a target=\"tags\" href=\"".$Search_link."search?".$fid."=".urlencode($Search_Key)."\">".$Search_Key."</a> ";
	}
	//
	$Ym_Mode = config('Ym_Mode',$dir); //״̬
	$Ym_Url = config('Ym_Url',$dir);   //ַ
	$Web_Mode = config('Web_Mode',$dir);   //ģʽ
	if($Ym_Mode==1){
		if($Web_Mode==2){
	        $Search_List  = str_replace(Web_Url.Web_Path."index.php/".PLUBPATH."/",$Ym_Url.Web_Path,$Search_List);
		}else{
	        $Search_List  = str_replace(Web_Url.Web_Path."index.php/".PLUBPATH."/",$Ym_Url.Web_Path."index.php/",$Search_List);
		}
	}
	if($Web_Mode==2){
        $Search_List  = str_replace("index.php/","",$Search_List);
	}
    return $Search_List;
}
//жϵǰǷΪsslģʽ
function is_ssl(){   
	if(Is_Ssl === 1){  //̨
		return 'https://';  
	}else{  
		if(!is_https()){
			return 'http://';
		}else{
			return 'https://';
		}  
	}
} 
//JSON
function getjson($info,$error=1,$sign=0,$callback=''){
	$info = get_bm($info,'gbk','utf-8');
	$msg = $info;
	$data['error'] = $error;
	$data['info'] = $info;
	//ǰ̨
	$data['msg'] = $msg;
	if($sign==1 && is_array($msg)){
		$data = array_merge($msg);
	}
	$json  = json_encode($data);
	if(!empty($callback)){
		echo $callback."(".$json.")";
	}else{
		echo $json;
	}
	exit;
}
//ȡԶֶϢ
function opt_field($dir,$opt,$table){
	if (is_file(CSCMS.'sys/Cs_Field.php')) {
		$field = require(CSCMS.'sys/Cs_Field.php');
		if(isset($field[$dir])){
			$str = '';$fid = 4;$tid=1;$gctime=1;$upid=5;
			foreach ($field[$dir] as $key => $value) {
				if(defined('IS_ADMIN')){
					$display1 = 'inline';
					$display2 = '';
					$ifelse = $value['table']==$table && $value['status']==1;
				}else{
					$display1 = 'block';
					$display2 = 'display:none';
					$ifelse = $value['table']==$table && $value['status']==1 && $value['qiantai']==1;
				}
				if($ifelse){
					switch ($value['leix']) {
						case 'number':
							$str .= '<div class="layui-form-item"><label class="layui-form-label">'.$value['note'].'</label><div class="layui-input-'.$display1.'"><input type="text" name="'.$value['zd'].'" value="'.$opt[$value['zd']].'" class="layui-input"></div><div style="'.$display2.'" class="layui-form-mid layui-word-aux">'.$value['notice'].'</div></div>';
							break;
						case 'text':
							if($value['attr']==0){
								$pass = ($value['pass']==1)?'password':'text';
								$str .= '<div class="layui-form-item"><label class="layui-form-label">'.$value['note'].'</label><div class="layui-input-'.$display1.'"><input type="'.$pass.'" name="'.$value['zd'].'" value="'.$opt[$value['zd']].'" class="layui-input"></div><div style="'.$display2.'" class="layui-form-mid layui-word-aux">'.$value['notice'].'</div></div>';
							}elseif ($value['attr']==1) {
								$str .= '<div class="layui-form-item layui-form-text"><label class="layui-form-label">'.$value['note'].'</label><div class="layui-input-block"><textarea name="'.$value['zd'].'" style="height: 100px" class="layui-textarea">'.$opt[$value['zd']].'</textarea></div></div>';
							}else{
								$str .= '<div class="layui-form-item layui-form-text">
	                            <label class="layui-form-label">'.$value['note'].'</label>
	                            <div class="layui-input-block"><textarea name="'.$value['zd'].'" lay-verify="content" id="gc'.$gctime.'" placeholder="'.$value['notice'].'" style="display: none;" class="layui-textarea">'.$opt[$value['zd']].'</textarea>
	                            </div>
	                        </div>';
								$str .= '<script>var gc'.$gctime.'_name=\''.$value['zd'].'\';layui.use([\'layedit\',\'form\'], function(){var layedit = layui.layedit;var form = layui.form();layedit.set({uploadImage: {elem:\'Filedata\',url: \''.Web_Path.SELF.'/upload/up_save_json?dir='.$dir.'\'}});gc'.$gctime.' = layedit.build(\'gc'.$gctime.'\',{height: 160 });form.verify({content: function(value){layedit.sync(gc'.$gctime.');}});});gctime++;</script>';
								$gctime++;
							}
							break;
						case 'image':
							$str .= '<div class="layui-form-item"><label class="layui-form-label">'.$value['note'].'</label><div class="layui-input-inline"><input type="text" id="pic'.$fid.'" name="'.$value['zd'].'" value="'.$opt[$value['zd']].'" class="layui-input"></div>';
	                        if(preg_match("/(iPhone|iPad|iPod|Android)/i", strtoupper($_SERVER['HTTP_USER_AGENT']))){
	                            $str .= '<input type="file" id="image'.$fid.'" name="Filedata" class="layui-upload-file">';
	                            $str .= '<script>layui.use(\'upload\', function(){layui.upload({url: \''.Web_Path.SELF.'/upload/up_save_json?dir=dance&fid='.$fid.'\',title: \'ϴ'.$value['note'].'ͼƬ\',ext: \''.$value['accept'].'\',elem:\'#image'.$fid.'\',success: function(res){if(res.error==0){$(\'#pic'.$fid.'\').val(res.info.url);}else{cscms.layer.msg(res.info);}}});});</script>';
	                        }else{
	                            $str .= '<div class="layui-input-inline" style="width: auto;"><a href="javascript:cscms.get_open(\''.site_url('upload/up').'?dir='.$dir.'&fid='.$fid.'\',\'ϴͼƬ\',\'500px\',\'360px\')" class="layui-btn layui-btn-primary"><i class="layui-icon" style="color:green">&#xe608;</i>ϴͼƬ</a></div>';
	                        }
							$str .= '</div>';
							$fid++;
							break;
						case 'select':
							$option = '';
							if(!empty($value['option'])){
								$op = explode('|', $value['option']);
								foreach ($op as $k => $v) {
									$temp_op = explode(':', $v);
									if($value['attr']==0){
										$cls=($opt[$value['zd']]==$temp_op[1])?'checked':'';
										$option .= '<input type="radio" name="'.$value['zd'].'" value="'.$temp_op[1].'" title="'.$temp_op[0].'" '.$cls.'>';
									}elseif($value['attr']==1){
										$cls=($opt[$value['zd']]==$temp_op[1])?'checked':''; 
										$option .= '<input type="checkbox" lay-skin="primary" name="'.$value['zd'].'" value="'.$temp_op[1].'" title="'.$temp_op[0].'" '.$cls.'>';
									}else{
										$cls=($opt[$value['zd']]==$temp_op[1])?'selected':''; 
										$option .= '<option type="checkbox" value="'.$temp_op[1].'" '.$cls.'>'.$temp_op[0].'</option>';
									}
								}
								$str .= '<div class="layui-form-item"><label class="layui-form-label">'.$value['note'].'</label><div class="layui-input-'.$display1.'">';
								if($value['attr']==2) $str .= '<select name="'.$value['zd'].'">';
								$str .= $option;
								if($value['attr']==2) $str .= '</select>';
								$str .= '</div></div>';
							}
							break;
						case 'datetime':
							if($value['attr']=='date'){
								$str .= '<div class="layui-form-item"><label class="layui-form-label">'.$value['note'].'</label><div class="layui-input-'.$display1.' "><input type="text" name="'.$value['zd'].'" value="'.$opt[$value['zd']].'" class="layui-input" onclick="layui.laydate({elem: this, istime: true, format: \'YYYY-MM-DD\'})"></div></div>';
								$str .= '<script>layui.use(\'laydate\', function(){var laydate = layui.laydate;var newt = {min: \'1970-01-01\',max: \'2099-06-16\',istoday: false,choose: function(datas){}};});</script>';
							}else{
								$str .= '<div class="layui-form-item"><label class="layui-form-label">'.$value['note'].'</label><div class="layui-input-'.$display1.' "><input type="text" name="'.$value['zd'].'" value="'.$opt[$value['zd']].'" class="layui-input" onclick="layui.laydate({elem: this, istime: true, format: \'YYYY-MM-DD hh:mm:ss\'})"></div></div>';
								$str .= '<script>layui.use(\'laydate\', function(){var laydate = layui.laydate;var newt = {min: \'1970-01-01 00:00:00\',max: \'2099-06-16 00:00:00\',format: \'YYYY-MM-DD hh:mm:ss\',istoday: false,choose: function(datas){}};});</script>';
							}
							break;
						case 'upload':
							$str .= '<div class="layui-form-item">
                            <label class="layui-form-label">'.$value['note'].'</label>
                            <div class="layui-input-inline">
                                <input type="text" name="'.$value['zd'].'" id="upf'.$upid.'" value="'.$opt[$value['zd']].'" class="layui-input">
                            </div>';
                            $actemp = explode('|', $value['accept']);
                    		$acarr = array();
                    		foreach ($actemp as $k => $v) {
                    			$acarr[$k] = '*.'.$v;
                    		}
                    		$accept = implode(';',$acarr);
                            if(!preg_match("/(iPhone|iPad|iPod|Android)/i", strtoupper($_SERVER['HTTP_USER_AGENT']))){
                            		
                                    $str .= '<div class="layui-input-inline" style="width: auto;"><a href="javascript:cscms.get_open(\''.site_url('upload/up').'?fhid=upf&fid='.$upid.'&nums='.$value['attr'].'&type='.$accept.'\',\'ϴļ\',\'500px\',\'360px\')" class="layui-btn layui-btn-primary"><i class="layui-icon" style="color:green">&#xe608;</i>ϴļ</a></div>';
                                }else{
                                    $str .= '<input type="file" name="Filedata" id="lupf'.$upid.'" class="layui-upload-file">';
                                    $str .= '<script>layui.use(\'upload\', function(){layui.upload({url: \''.Web_Path.SELF.'/upload/up_save_json?fhid=upf&fid='.$upid.'&dir=&type='.$accept.'\',elem:\'#lupf'.$upid.'\',title: \'ϴļ\',ext: \''.$value['accept'].'\',success: function(res){if(res.error==0){$(\'#upf'.$upid.'\').val(res.info.url);}else{cscms.layer.msg(res.info);}}});});</script>';
                                }
                            $str .= '</div>';
							break;
						default:
							# code...
							break;
					}
				}
			}
			$gcstr = '<script>';
			for ($i=1; $i < $gctime; $i++) { 
				$gcstr .= 'var gc'.$i.';';
			}
			$gcstr .= '</script>';
			$data['str'] = $gcstr.$str;
			$data['gctime'] = $gcstr;
			return $data;
		}
	}
}
//дԶֶεļ
function save_field($dir,$table,$sign=0){
	$arr = array();
	if (is_file(CSCMS.'sys/Cs_Field.php')) {
		$field = require(CSCMS.'sys/Cs_Field.php');
		if(isset($field[$dir])){
			foreach ($field[$dir] as $key => $value) {
				if($value['table']==$table && $value['status']==1){
					if($sign==0 || ($sign==1 && $value['qiantai']==1)){
						$_POST = get_bm($_POST);
						if($value['leix']=='text' && $value['attr']==2){
							if(isset($_POST[$value['zd']])){
								$arr[$value['zd']] = remove_xss($_POST[$value['zd']]);
							}
						}else{
							if(isset($_POST[$value['zd']])){
								$arr[$value['zd']] = str_encode($_POST[$value['zd']]);
							}
						}
						if($value['required']==1 && isset($arr[$value['zd']]) && empty($arr[$value['zd']])){
							if($sign==1){
								msg_url($value['note'].'Ϊ~!','javascript:history.back();');
							}else{
								getjson($value['note'].'Ϊ~!');
							}
						}
						if(!empty($value['regexp']) && !empty($arr[$value['zd']])){
							if(!preg_match($value['regexp'], $arr[$value['zd']])){
								if($sign==1){
									msg_url($value['note'].''.$value['wrong'],'javascript:history.back();');
								}else{
									getjson($value['note'].''.$value['wrong']);
								}
							}
						}
					}
				}
			}
		}
	}
	return $arr;
}
//̨ʾϢ
function admin_msg($msg, $gourl, $zt='ok', $color='',$left=''){
	$sign = $zt=='ok' ? 1 : 2;
	admin_info(array('msg'=>$msg,'url'=>$gourl),$sign);
}
//ǰ̨ҳ淵Ϣ
function msg_url($title,$url,$time=3000) {
	if(intval($time)==0) $time=3000;
	//ֻ
	if(preg_match("/(iPhone|iPad|iPod|Android)/i", strtoupper($_SERVER['HTTP_USER_AGENT']))){
	    include FCPATH.'tpl'.FGF.'errors'.FGF.'html'.FGF.'mbmsg.php';
	    exit();
	}
	include FCPATH.'tpl'.FGF.'errors'.FGF.'html'.FGF.'pcmsg.php';
    exit();
}
//ǰ̨󷵻Ϣ
function msg_txt($msg) {
	$msg = get_bm($msg);
	//ֻ
	if(preg_match("/(iPhone|iPad|iPod|Android)/i", strtoupper($_SERVER['HTTP_USER_AGENT']))){
        exit("<!DOCTYPE html><html><head><meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'></head><body><center><br><br>".$msg."</center></body></html>");
	}
	//PC
	echo '<!DOCTYPE html><html><head><meta http-equiv="Content-Type"content="text/html; charset=gbk"/><meta name="generator" content="cscms 4.x" /><link rel="stylesheet" type="text/css" href="'.Web_Path.'packs/images/msg.css"/><title>Cscms Error</title></head><body class="msg_txt"><div id="container"><h1>Cscms Error</h1><div class="box"><span class="code"><b class="f14">'.L('cscms_msg_04').'</b><font><p><b>'.$msg.'</b></p></font></span></div><div class="box"><span class="code"><b class="f14">'.L('cscms_msg_05').'</b><font><p>'.L('cscms_msg_06').'</p><p><a href="http://bbs.chshcms.com/search.html?key='.urlencode($msg).'" target="help">'.L('cscms_msg_07').'</a></p><p><a href="javascript:history.back(-1);">'.L('cscms_msg_08').'</a></p><p><a href="'.is_ssl().Web_Url.Web_Path.'">ҳ ('.Web_Url.')</a></p></font></span></div></div></body></html>';
	exit();
}
//ҳʾϢ
function admin_info($info,$sign=0){
	$sign = intval($sign);
	$res = '<link rel="stylesheet" href="'.Web_Path.'packs/layui/css/layui.css"><script src="'.Web_Path.'packs/js/jquery.min.js"></script><script src="'.Web_Path.'packs/layui/layui.js"></script><script src="'.Web_Path.'packs/admin/js/cscms.js"></script><script>';
	$res .= 'layui.use([\'layer\'], function(){
		var layer = layui.layer;';
	if($sign==0){
		$res .= 'layer.msg(\''.$info.'\',{icon:2,time:0});';

	}
	if($sign==1){
		if(is_array($info)){
			$res .= 'layer.msg(\''.$info['msg'].'\',{icon:1,time:0});';
			$res .= 'setTimeout(function(){location.href=\''.$info['url'].'\'},2000);';
		}else{
			$res .= 'layer.msg(\''.$info.'\',{icon:1,time:0});';
		}
		
	}
	if($sign==2){
		$res .= 'layer.msg(\''.$info['msg'].'\',{icon:2,time:0});';
		$res .= 'setTimeout(function(){location.href=\''.$info['url'].'\'},2000);';
	}
	if($sign==3){
		$res .= 'layer.msg(\''.$info['msg'].'\',{icon:2,time:0});';
		$res .= 'setTimeout(function(){location.href=\''.$info['url'].'\'},5000);';
	}
	$res .= '});</script>';
	exit($res);
}

