<?php
require_once CSPATH."pay/wxpay/lib/WxPay.Exception.php";
require_once CSPATH."pay/wxpay/lib/WxPay.Config.php";
require_once CSPATH."pay/wxpay/lib/WxPay.Data.php";

/**
 * 
 * ӿڷ࣬΢֧APIбķװзΪstatic
 * ÿӿĬϳʱʱ䣨ύɨ֧Ϊ10sϱʱʱΪ1s⣬Ϊ6s
 * @author widyhu
 *
 */
class WxPayApi
{
	/**
	 * 
	 * ͳһµWxPayUnifiedOrderout_trade_nobodytotal_feetrade_type
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayUnifiedOrder $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function unifiedOrder($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/pay/unifiedorder";
		//
		if(!$inputObj->IsOut_trade_noSet()) {
			throw new WxPayException("ȱͳһ֧ӿڱout_trade_no");
		}else if(!$inputObj->IsBodySet()){
			throw new WxPayException("ȱͳһ֧ӿڱbody");
		}else if(!$inputObj->IsTotal_feeSet()) {
			throw new WxPayException("ȱͳһ֧ӿڱtotal_fee");
		}else if(!$inputObj->IsTrade_typeSet()) {
			throw new WxPayException("ȱͳһ֧ӿڱtrade_type");
		}
		
		//
		if($inputObj->GetTrade_type() == "JSAPI" && !$inputObj->IsOpenidSet()){
			throw new WxPayException("ͳһ֧ӿУȱٱopenidtrade_typeΪJSAPIʱopenidΪ");
		}
		if($inputObj->GetTrade_type() == "NATIVE" && !$inputObj->IsProduct_idSet()){
			throw new WxPayException("ͳһ֧ӿУȱٱproduct_idtrade_typeΪJSAPIʱproduct_idΪ");
		}
		
		//첽֪ͨurlδãʹļеurl
		if(!$inputObj->IsNotify_urlSet()){
			$inputObj->SetNotify_url(WxPayConfig::NOTIFY_URL);//첽֪ͨurl
		}
		
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetSpbill_create_ip($_SERVER['REMOTE_ADDR']);//նip	  
		//$inputObj->SetSpbill_create_ip("1.1.1.1");  	    
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		//ǩ
		$inputObj->SetSign();
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}
	
	/**
	 * 
	 * ѯWxPayOrderQueryout_trade_notransaction_idһ
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayOrderQuery $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function orderQuery($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/pay/orderquery";
		//
		if(!$inputObj->IsOut_trade_noSet() && !$inputObj->IsTransaction_idSet()) {
			throw new WxPayException("ѯӿУout_trade_notransaction_idһ");
		}
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}
	
	/**
	 * 
	 * رնWxPayCloseOrderout_trade_no
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayCloseOrder $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function closeOrder($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/pay/closeorder";
		//
		if(!$inputObj->IsOut_trade_noSet()) {
			throw new WxPayException("ѯӿУout_trade_no");
		}
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}

	/**
	 * 
	 * ˿WxPayRefundout_trade_notransaction_idһ
	 * out_refund_nototal_feerefund_feeop_user_idΪ
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayRefund $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function refund($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/secapi/pay/refund";
		//
		if(!$inputObj->IsOut_trade_noSet() && !$inputObj->IsTransaction_idSet()) {
			throw new WxPayException("˿ӿУout_trade_notransaction_idһ");
		}else if(!$inputObj->IsOut_refund_noSet()){
			throw new WxPayException("˿ӿУȱٱout_refund_no");
		}else if(!$inputObj->IsTotal_feeSet()){
			throw new WxPayException("˿ӿУȱٱtotal_fee");
		}else if(!$inputObj->IsRefund_feeSet()){
			throw new WxPayException("˿ӿУȱٱrefund_fee");
		}else if(!$inputObj->IsOp_user_idSet()){
			throw new WxPayException("˿ӿУȱٱop_user_id");
		}
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, true, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}
	
	/**
	 * 
	 * ѯ˿
	 * ύ˿ͨøýӿڲѯ˿״̬˿һʱ
	 * Ǯ֧˿20ڵˣп֧˿3պ²ѯ˿״̬
	 * WxPayRefundQueryout_refund_noout_trade_notransaction_idrefund_idĸһ
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayRefundQuery $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function refundQuery($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/pay/refundquery";
		//
		if(!$inputObj->IsOut_refund_noSet() &&
			!$inputObj->IsOut_trade_noSet() &&
			!$inputObj->IsTransaction_idSet() &&
			!$inputObj->IsRefund_idSet()) {
			throw new WxPayException("˿ѯӿУout_refund_noout_trade_notransaction_idrefund_idĸһ");
		}
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}
	
	/**
	 * ض˵WxPayDownloadBillbill_dateΪ
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayDownloadBill $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function downloadBill($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/pay/downloadbill";
		//
		if(!$inputObj->IsBill_dateSet()) {
			throw new WxPayException("˵ӿУȱٱbill_date");
		}
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		if(substr($response, 0 , 5) == "<xml>"){
			return "";
		}
		return $response;
	}
	
	/**
	 * ύɨ֧API
	 * Աʹɨ豸ȡ΢ûˢȨԺ󣬶άϢ̨̻
	 * ̨̨̻̻øýӿڷ֧
	 * WxPayWxPayMicroPaybodyout_trade_nototal_feeauth_code
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayWxPayMicroPay $inputObj
	 * @param int $timeOut
	 */
	public static function micropay($inputObj, $timeOut = 10)
	{
		$url = "https://api.mch.weixin.qq.com/pay/micropay";
		//
		if(!$inputObj->IsBodySet()) {
			throw new WxPayException("ύɨ֧APIӿУȱٱbody");
		} else if(!$inputObj->IsOut_trade_noSet()) {
			throw new WxPayException("ύɨ֧APIӿУȱٱout_trade_no");
		} else if(!$inputObj->IsTotal_feeSet()) {
			throw new WxPayException("ύɨ֧APIӿУȱٱtotal_fee");
		} else if(!$inputObj->IsAuth_codeSet()) {
			throw new WxPayException("ύɨ֧APIӿУȱٱauth_code");
		}
		
		$inputObj->SetSpbill_create_ip($_SERVER['REMOTE_ADDR']);//նip
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}
	
	/**
	 * 
	 * APIӿڣWxPayReverseвout_trade_notransaction_idдһ
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayReverse $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 */
	public static function reverse($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/secapi/pay/reverse";
		//
		if(!$inputObj->IsOut_trade_noSet() && !$inputObj->IsTransaction_idSet()) {
			throw new WxPayException("APIӿУout_trade_notransaction_idдһ");
		}
		
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, true, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}
	
	/**
	 * 
	 * ϱ÷ڲװreportУʹʱע쳣
	 * WxPayReportinterface_urlreturn_coderesult_codeuser_ipexecute_time_
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayReport $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function report($inputObj, $timeOut = 1)
	{
		$url = "https://api.mch.weixin.qq.com/payitil/report";
		//
		if(!$inputObj->IsInterface_urlSet()) {
			throw new WxPayException("ӿURLȱٱinterface_url");
		} if(!$inputObj->IsReturn_codeSet()) {
			throw new WxPayException("״̬룬ȱٱreturn_code");
		} if(!$inputObj->IsResult_codeSet()) {
			throw new WxPayException("ҵȱٱresult_code");
		} if(!$inputObj->IsUser_ipSet()) {
			throw new WxPayException("ʽӿIPȱٱuser_ip");
		} if(!$inputObj->IsExecute_time_Set()) {
			throw new WxPayException("ӿںʱȱٱexecute_time_");
		}
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetUser_ip($_SERVER['REMOTE_ADDR']);//նip
		$inputObj->SetTime(date("YmdHis"));//̻ϱʱ	 
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		return $response;
	}
	
	/**
	 * 
	 * ɶά,ģʽһ֧ά
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayBizPayUrl $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function bizpayurl($inputObj, $timeOut = 6)
	{
		if(!$inputObj->IsProduct_idSet()){
			throw new WxPayException("ɶά룬ȱٱproduct_id");
		}
		
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetTime_stamp(time());//ʱ	 
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		
		return $inputObj->GetValues();
	}
	
	/**
	 * 
	 * ת
	 * ýӿҪɨԭ֧ģʽһеĶάתɶ(weixin://wxpay/s/XXXXXX)
	 * СάɨٶȺ;ȷȡ
	 * appidmchidspbill_create_ipnonce_strҪ
	 * @param WxPayShortUrl $inputObj
	 * @param int $timeOut
	 * @throws WxPayException
	 * @return ɹʱأ쳣
	 */
	public static function shorturl($inputObj, $timeOut = 6)
	{
		$url = "https://api.mch.weixin.qq.com/tools/shorturl";
		//
		if(!$inputObj->IsLong_urlSet()) {
			throw new WxPayException("ҪתURLǩԭURL encode");
		}
		$inputObj->SetAppid(WxPayConfig::APPID);//˺ID
		$inputObj->SetMch_id(WxPayConfig::MCHID);//̻
		$inputObj->SetNonce_str(self::getNonceStr());//ַ
		
		$inputObj->SetSign();//ǩ
		$xml = $inputObj->ToXml();
		
		$startTimeStamp = self::getMillisecond();//ʼʱ
		$response = self::postXmlCurl($xml, $url, false, $timeOut);
		$result = WxPayResults::Init($response);
		self::reportCostTime($url, $startTimeStamp, $result);//ϱ󻨷ʱ
		
		return $result;
	}
	
 	/**
 	 * 
 	 * ֧֪ͨͨ
 	 * @param function $callback
 	 * ֱӻصʹ÷: notify(you_function);
 	 * صԱ:notify(array($this, you_function));
 	 * $callback  ԭΪfunction function_name($data){}
 	 */
	public static function notify($callback, &$msg)
	{
		//ȡ֪ͨ
		$xml = $GLOBALS['HTTP_RAW_POST_DATA'];
		//سɹ֤ǩ
		try {
			$result = WxPayResults::Init($xml);
		} catch (WxPayException $e){
			$msg = $e->errorMessage();
			return false;
		}
		
		return call_user_func($callback, $result);
	}
	
	/**
	 * 
	 * ַ32λ
	 * @param int $length
	 * @return ַ
	 */
	public static function getNonceStr($length = 32) 
	{
		$chars = "abcdefghijklmnopqrstuvwxyz0123456789";  
		$str ="";
		for ( $i = 0; $i < $length; $i++ )  {  
			$str .= substr($chars, mt_rand(0, strlen($chars)-1), 1);  
		} 
		return $str;
	}
	
	/**
	 * ֱxml
	 * @param string $xml
	 */
	public static function replyNotify($xml)
	{
		echo $xml;
	}
	
	/**
	 * 
	 * ϱݣ ϱʱ쳣
	 * @param string $usrl
	 * @param int $startTimeStamp
	 * @param array $data
	 */
	private static function reportCostTime($url, $startTimeStamp, $data)
	{
		//Ҫϱ
		if(WxPayConfig::REPORT_LEVENL == 0){
			return;
		} 
		//ʧϱ
		if(WxPayConfig::REPORT_LEVENL == 1 &&
			 array_key_exists("return_code", $data) &&
			 $data["return_code"] == "SUCCESS" &&
			 array_key_exists("result_code", $data) &&
			 $data["result_code"] == "SUCCESS")
		 {
		 	return;
		 }
		 
		//ϱ߼
		$endTimeStamp = self::getMillisecond();
		$objInput = new WxPayReport();
		$objInput->SetInterface_url($url);
		$objInput->SetExecute_time_($endTimeStamp - $startTimeStamp);
		//״̬
		if(array_key_exists("return_code", $data)){
			$objInput->SetReturn_code($data["return_code"]);
		}
		//Ϣ
		if(array_key_exists("return_msg", $data)){
			$objInput->SetReturn_msg($data["return_msg"]);
		}
		//ҵ
		if(array_key_exists("result_code", $data)){
			$objInput->SetResult_code($data["result_code"]);
		}
		//
		if(array_key_exists("err_code", $data)){
			$objInput->SetErr_code($data["err_code"]);
		}
		//
		if(array_key_exists("err_code_des", $data)){
			$objInput->SetErr_code_des($data["err_code_des"]);
		}
		//̻
		if(array_key_exists("out_trade_no", $data)){
			$objInput->SetOut_trade_no($data["out_trade_no"]);
		}
		//豸
		if(array_key_exists("device_info", $data)){
			$objInput->SetDevice_info($data["device_info"]);
		}
		
		try{
			self::report($objInput);
		} catch (WxPayException $e){
			//κδ
		}
	}

	/**
	 * postʽύxmlӦĽӿurl
	 * 
	 * @param string $xml  Ҫpostxml
	 * @param string $url  url
	 * @param bool $useCert ǷҪ֤飬ĬϲҪ
	 * @param int $second   urlִгʱʱ䣬Ĭ30s
	 * @throws WxPayException
	 */
	private static function postXmlCurl($xml, $url, $useCert = false, $second = 30)
	{		
		$ch = curl_init();
		//óʱ
		curl_setopt($ch, CURLOPT_TIMEOUT, $second);
		
		//ôô
		if(WxPayConfig::CURL_PROXY_HOST != "0.0.0.0" 
			&& WxPayConfig::CURL_PROXY_PORT != 0){
			curl_setopt($ch,CURLOPT_PROXY, WxPayConfig::CURL_PROXY_HOST);
			curl_setopt($ch,CURLOPT_PROXYPORT, WxPayConfig::CURL_PROXY_PORT);
		}
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,FALSE);
		curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,FALSE);//ϸУ2
		//header
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		//ҪΪַĻ
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	
		if($useCert == true){
			//֤
			//ʹ֤飺cert  key ֱ.pemļ
			curl_setopt($ch,CURLOPT_SSLCERTTYPE,'PEM');
			curl_setopt($ch,CURLOPT_SSLCERT, WxPayConfig::SSLCERT_PATH);
			curl_setopt($ch,CURLOPT_SSLKEYTYPE,'PEM');
			curl_setopt($ch,CURLOPT_SSLKEY, WxPayConfig::SSLKEY_PATH);
		}
		//postύʽ
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
		//curl
		$data = curl_exec($ch);
		//ؽ
		if($data){
			curl_close($ch);
			return $data;
		} else { 
			$error = curl_errno($ch);
			curl_close($ch);
			throw new WxPayException("curl:$error");
		}
	}
	
	/**
	 * ȡ뼶ʱ
	 */
	private static function getMillisecond()
	{
		//ȡʱ
		$time = explode ( " ", microtime () );
		$time = $time[1] . ($time[0] * 1000);
		$time2 = explode( ".", $time );
		$time = $time2[0];
		return $time;
	}
}


