<?php

namespace backend\controllers;

use Yii;
use common\models\Config;
use common\models\CustomService;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\CHelper;

/**
 * CustomServiceController implements the CRUD actions for CustomService model.
 */
class CustomServiceController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'create','update','delete'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                ],
            ],
        ];
    }

    /**
     * Lists all Product models.
     * @return mixed
     */
    public function actionIndex()
    {
        $this->check_access('custom_service');
        $list = Config::find()->asArray()->indexBy('name')->all();
        if(Yii::$app->request->isPost){
            foreach (Yii::$app->request->post() as $key => $value) {
                Yii::$app->db->createCommand('UPDATE '.Yii::$app->db->tablePrefix.'config set `value`="'.$value.'" where `name`="'.$key.'"')->execute();
            }
            Config::updateCache();
            $this->showmsg(1,'保存成功！');
            return $this->redirect(Yii::$app->request->getReferrer());
        }
        $dataProvider = new ActiveDataProvider([
            'query' => CustomService::find(),
            'pagination'=>[
                'pagesize'=>10,
            ],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'list' => $list,
        ]);
    }

    /**
     * Creates a new Product model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $this->check_access('custom_service');
        $model = new CustomService();
        $model->ordid = 0;
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $this->showmsg(1,'添加成功！');
            return $this->redirect(['index']);
        }
        return $this->render('create',[
            'model'=>$model,
        ]);
    }

    /**
     * Updates an existing Product model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $this->check_access('custom_service');
        $model = $this->findModel($id);
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $this->showmsg(1,'修改成功！');
            return $this->redirect(['index']);
        }
        return $this->render('update',[
            'model'=>$model,
        ]);
    }

    /**
     * Deletes an existing Product model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->check_access('custom_service');
        $model = $this->findModel($id);
        $model->delete();
        $this->showmsg(1,'删除成功！');

        return $this->redirect(['index']);
    }

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return Product the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = CustomService::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
}
