<?php

namespace backend\controllers;

use Yii;
use common\models\Pagecache;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

class PagecacheController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                ],
            ],
        ];
    }
    public function actionIndex(){
        $this->check_access('pagecache');
        $list = Pagecache::find()->orderBy('id asc')->asArray()->all();
        if(Yii::$app->request->isPost){
            $id = Yii::$app->request->post('id');
            $status = Yii::$app->request->post('status');
            $time = Yii::$app->request->post('time');
            foreach ($id as $key => $value) {
                Yii::$app->db->createCommand('UPDATE '.Yii::$app->db->tablePrefix.'pagecache set `status`="'.$status[$value].'",`time`='.$time[$value].' where `id`="'.$value.'"')->execute();
            }
            Pagecache::updateCache();
            $this->showmsg(1,'保存成功！');
            return $this->redirect(Yii::$app->request->getReferrer());
        }
        return $this->render('index', [
            'list' => $list,
        ]);
    }
}
