<?php

namespace backend\controllers;

use Yii;
use common\models\Config;
use common\models\RouteRule;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

class RouteController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index','create','update','set-status','delete','rule'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                ],
            ],
        ];
    }
    public function actionIndex(){
        $this->check_access('route');
        $list = Config::find()->asArray()->indexBy('name')->all();
        if(Yii::$app->request->isPost){
            foreach (Yii::$app->request->post() as $key => $value) {
                Yii::$app->db->createCommand('UPDATE '.Yii::$app->db->tablePrefix.'config set `value`="'.$value.'" where `name`="'.$key.'"')->execute();
            }
            Config::updateCache();
            RouteRule::updateCache();
            $this->showmsg(1,'保存成功！');
            return $this->redirect(Yii::$app->request->getReferrer());
        }
        return $this->render('index', [
            'list' => $list,
        ]);
    }
    public function actionRule(){
        $this->check_access('route');
        $dataProvider = new ActiveDataProvider([
            'query' => RouteRule::find(),
            'pagination'=>[
                'pagesize'=>10,
            ],
        ]);
        return $this->render('rule', [
            'dataProvider' => $dataProvider,
        ]);
    }
    /**
     * Creates a new RouteRule model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $this->check_access('route');
        $model = new RouteRule();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $this->showmsg(1,'发布成功！');
            return $this->redirect(['rule']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing RouteRule model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $this->check_access('route');
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $this->showmsg(1,'修改成功！');
            return $this->redirect(['rule']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }
    public function actionSetStatus($id,$status)
    {
        $this->check_access('route');
        $model = $this->findModel($id);
        $model->status = $status;

        if ($model->save()) {
            $this->showmsg(1,'操作成功！');
            return $this->redirect(['rule']);
        } else {
            $this->showmsg(0,'操作失败！');
            return $this->redirect(['rule']);
        }
    }

    /**
     * Deletes an existing Route model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->check_access('route');
        $this->findModel($id)->delete();
        $this->showmsg(1,'删除成功！');

        return $this->redirect(['rule']);
    }
    /**
     * Finds the RouteRule model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return RouteRule the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = RouteRule::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
