<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Article */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="article-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'title',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'content')->widget('common\widgets\ueditor\Ueditor',[
        'options'=>[
            'initialFrameWidth' => 800,
            'initialFrameHeight' => 300,
        ]
    ]) ?>

    <?= $form->field($model, 'display')->dropdownList(['1'=>'显示','0'=>'隐藏']) ?>
    
    <?= $form->field($model, 'seo_title',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true,'placeholder'=>'如留空系统将自动截取文章内容填充']) ?>
    <?= $form->field($model, 'seo_keywords',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true,'placeholder'=>'如留空系统将自动截取文章内容填充']) ?>
    <?= $form->field($model, 'seo_description',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textArea(['maxlength' => true,'placeholder'=>'如留空系统将自动截取文章内容填充']) ?>

    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '发布' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('about/index').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
