<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 
use common\models\AdCategory;

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Product */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'type')->dropdownList(['0'=>'文字','1'=>'图片']) ?>
    <?= $form->field($model, 'alias')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'width')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'height')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'max')->textInput(['maxlength' => true]) ?>

    
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '添加' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('/ad-category').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
